	print	"System"

;Operating system specific routines
;Only included if OP_SYS is true

	disp	2

;***************************
;* Opsys only opo routines *
;***************************

;-------------------------------------
; Return pointer to device name in r1,
;   length of name in r0
;-------------------------------------

opo_cname:
	save	[r4]
	movzbd	4*dof_id+dofid_max(r7),r0
	addr	r7[r0:d],r1	;Address of name
	save	[r1]
	movzbd	name_siz,r0	;Max length for name
	movqd	0,r4
	skpsb	u
	restore [r1]
	negb	r0,r0
	addb	name_siz,r0	;Length of name
	restore	[r4]
	movqd	0,r6
	ret
	

;---------------------------------
; Install name in r1, length in r0
;---------------------------------

nlo_csetnm:
	save	[r0,r1,r2]
	movzbd	4*dof_id+dofid_max(r7),r2
	addr	r7[r2:d],r2	;Address of name
	cmpd	name_siz,r0
	if	hi
	 movqb	0,r2[r0:b]	;Terminate with 0 if less than name_siz bytes
	else
	 movzbd	name_siz,r0	;Max length
	endif
	movsb
	restore	[r0,r1,r2]
	movqd	0,r6
	ret


;Initialize common SB data block

ld_init:
	cond	0
	 save	[r0,r1,r2,r3,r4,r5]
	 
	 movqd	0,m_errct
	 movqd	1,max_err
	 movb	dev_sev,tx_dev
	 movqd	0,math_ptr
	 movw	10,m_radix
	 movqd	-1,t_symfp
	 movqd	-1,t_symlnk
	 
	 movqd	0,mod_indx
	 movqd	0,lmod
	 addr	mod_tabl,r1
	 movqw	-1,4+4(r1)	;CXP table offset
	 movqd	0,4+4+2(r1)	;Symbol offset - pad upper bits with 0
	 movd	sidx_end,4+4+2+sidx_of(r1) ;Offset to name (padded with 0s)
	 movqd	-1,4+4+2+2*sidx_of(r1) ;M_PCOFST for this module
	 movqd	-1,4+4+2+2*sidx_of+4(r1) ;Starting PC
	 movqd	-1,4+4+2+2*sidx_of+4+4(r1) ;Starting SB
	 movqd	-1,4+4+2+2*sidx_of+4+4+4(r1) ;Starting MOD
	 movqd	-1,4+4+2+2*sidx_of+4+4+4+4(r1) ;Starting LINK

	 addr	t_symalf,r1
	 addr	1(r1),r2
	 movd	sidx_of*13*("Z"-"A"+1)-1,r0
	 movqb	-1,(r1)
	 movsb			;Fill with -1
	 movqd	0,msym_beg
	 
	 movd	m_string,r1
	 movd	r1,m_strptr
	 addd	h'200,r1
	 movd	r1,t_cxp
	 movd	r1,t_cxpx
	 addd	h'200,r1
	 movd	r1,m_xrf	;Not used
	 movd	r1,m_xrfptr
	 movd	r1,m_xrflin
	 addd	h'20,r1
	 movd	r1,m_lnkptr
	 movd	r1,m_link
	 movd	r1,m_linkm
	 addd	h'200,r1
	 movd	r1,t_symbl
	 movd	r1,tsym_end
	 movd	r1,msym_end
	 
	 addr	t_delim:d,m_delim
	 addr	t_delim2:d,m_delim2
	 
	 movqd	0,m_stksiz	;Filled in by program
	 movqd	0,m_stksiz+4
	 
	 restore [r0,r1,r2,r3,r4,r5]
	cend

	ret


;*******************
;* Buffer routines *
;*******************

	mode	imm,0
obuf_hnd: blkd	2		;Buffer handle for applications:
				;  4 bytes pointer to buffer
				;  4 bytes size of buffer (0 if invalid)
obuf_nxt: blkd			;Address of next linear buffer handle
obuf_prv: blkd			;Address of previous linear buffer handle
obuf_nhn: blkd			;Address of next handle
obuf_phn: blkd			;Address of previous handle
obuf_siz: blkb			;Size of buffer control block in bytes
obuf_app: blkb			;Application number
obuf_st: blkw			;Status for each heap buffer:
obuf_max:			;Size of buffer pointer data block

;Heap buffer status bits
	org	0
bbuf_use:: blkb			;In use bit (for non-current app.)
bbuf_rem:: blkb			;Removable if set (may delete if desired)
bbuf_usr:: blkb			;User mode if set
bbuf_lok:: blkb			;Locked bit (for all apps.)
bbuf_vrt:: blkb			;Virtual if set
	mode	pc


;------------------------
; Initialize heap buffers
;------------------------

buf_init:
	save	[r3,r4,r5]

	movd	tbuf_adr,r5
	movd	r5,tbuf_ptr	;First handle goes here
	addr	obuf_max(r5),r4	;Next buffer handle
	movd	r4,obuf_hnd(r5) ;Address of 1st buffer
	movqd	0,obuf_hnd+4(r5) ;No allocated size
	movqd	-1,obuf_prv(r5)	;No previous handle
	movd	r4,obuf_nxt(r5)	;Next buffer handle
	movd	r4,obuf_nhn(r5)	;Next handle
	movqd	-1,obuf_phn(r5)	;No previous handle
	movb	obuf_max,obuf_siz(r5)
	movb	app_num(svc_app),obuf_app(r5) ;Must be current application
	movw	exp bbuf_use+exp bbuf_lok,obuf_st(r5)

	sprd	sb,r3
	addd	-4(r3),r3	;Last heap address+1

	movd	r3,obuf_hnd(r4) ;Address of 1st buffer
	movqd	0,obuf_hnd+4(r4) ;No allocated size
	movd	r5,obuf_prv(r4)
	movqd	-1,obuf_nxt(r4)	;No next handle
	movqd	-1,obuf_nhn(r4)	;No next handle
	movd	r5,obuf_phn(r4)	;Previous handle
	movb	obuf_max,obuf_siz(r4)
	movb	app_num(svc_app),obuf_app(r4) ;Must be current application
	movw	exp bbuf_use+exp bbuf_lok+exp bbuf_usr,obuf_st(r4)
	addr	obuf_max(r4),tbuf_svc ;End of SVC start of user area

	subd	r5,r3
	movd	r3,tbuf_siz	;Size of heap

	movqb	0,muse_buf	;Nothing in progress

	restore	[r3,r4,r5]
	ret


;---------------------------------
; Verify buffer handle in r4
; if error then r4=-1, r6=bstat_na
; If OK then r6=0, eq true
;---------------------------------

buf_chek:
	movd	r1,tos
	cmpb	obuf_app(r4),app_num(svc_app) ;Must be current application
	if	ne		;Error already if wrong application
	 movzbd	bstat_na,r6	;Error
	 movqd	-1,r4		;Invalid
	else
	 movd	tbuf_ptr,r1	;Buffer pointer
	 until	eq
	  movd	obuf_nxt(r1),r1 ;Next handle
	  cmpqd	-2,r1
	 quit	lo		;End of line if lo
	  cmpd	r1,r4
	 endu
	orif	ne		;No match if ne
	 movqd	0,r6		;Success
	endif
	movd	tos,r1
	cmpqd	0,r6
	ret
	

;--------------------------
; Buffer garbage collection
;--------------------------

buf_grbg:
	save	[r0,r1,r2,r4]

	until fc
	 sbitb 0,muse_buf	;Lock out overlapping calls
	endu

	movd	tbuf_ptr,r4	;Address of 1st pointer
	movd	r4,tbuf_svc	;Reset division between svc and user areas
	begin			;Find last buffer
	 tbitb	bbuf_usr,obuf_st(r4)
	 if	fc		;Supervisor mode if fc
	  movd	obuf_hnd(r4),r1
	  addd	obuf_hnd+4(r4),r1
	 else			;User mode
	  movzbd obuf_siz(r4),r1
	  addd	r4,r1		;Last byte of control block+1
	 endif
	 cmpd	tbuf_svc,r1
	 if	lo
	  movd	r1,tbuf_svc	;New top of svc area
	 endif
	 cmpqd	-1,obuf_nxt(r4)	;Pointer to next handle
	while	ne		;End of the line if eq
	 movd	obuf_nxt(r4),r4
	endw
	movd	obuf_hnd(r4),r2	;Upper limit

	begin
	 movd	obuf_prv(r4),r4 ;Pointer to previous chained buffer
	 tbitb	bbuf_usr,obuf_st(r4) ;User mode only here
	while	fs		;Must be user mode
	 tbitb	bbuf_lok,obuf_st(r4) ;Can't move if locked
	 if	fc
	  cmpb	obuf_app(r4),app_num(svc_app) ;Check for current application
	  if	ne
	   tbitb bbuf_use,obuf_st(r4) ;Can't move if in use
	  endif
	 endif
	 if	fs		;Not moveable if FS
	  movd	obuf_hnd(r4),r2 ;Address of immovable buffer
	 else			;This is moveable
	  movd	obuf_hnd+4(r4),r0 ;Size of buffer
	  movd	r0,r1
	  addd	obuf_hnd(r4),r1	;Address of next available block
	  cmpd	r2,r1		;See if a move is required
	  if	eq
	   subd	r0,r2		;Just adjust R2 if EQ
	  else			;Move required
	   addqd -4,r1		;Last Dword of current block
	   addqd -4,r2		;Last Dword of free memory
	   lshd	-2,r0		;Divide size by 4
	   movsd b
	   addqd 4,r2		;Point to start of buffer
	   movd	r2,obuf_hnd(r4)	;New address
	  endif
	 endif
	endw

	movqb	0,muse_buf	;Release
	restore	[r0,r1,r2,r4]
	ret


;----------------------------------------------------------------
; Get available heap address, R4 holds requested size
;   Bit dc_fusr set in r5 for user mode
; On exit: R0=size, r1=address, r2=previous handle
; Buffer must already be locked against simultaneous access
;----------------------------------------------------------------

buf_block:
	save	[r3,r4,r5,r6,r7]

	until fc
	 sbitb 0,muse_buf	;Lock out overlapping calls
	endu

	movd	r5,r6
	addqd	3,r4
	bicb	3,r4		;Size rounded up to Dword boundary

	movd	tbuf_svc,r1	;Default position
	movd	tbuf_ptr,r2
	until	fs
	 movd	obuf_nxt(r2),r2
	 tbitb	bbuf_usr,obuf_st(r2) ;Look for first user block
	endu
	movd	obuf_hnd(r2),r0
	subd	r1,r0		;Available space in middle
	tbitb	dc_fusr,r6
	if	fc
	 movd	tbuf_ptr,r2	;Start here if supervisor block
	endif

	movd	r2,r5		;R5 is handle pointer
	until	fs
	 tbitb	bbuf_usr,obuf_st(r5)
	 if	fs		;User mode
	  movd	obuf_nxt(r5),r3 ;Next handle
	  movd	obuf_hnd(r3),r3	;Upper limit for this block
	 else			;Supervisor mode
	  movd	obuf_nhn(r5),r3	;Upper limit for this block
	 endif
	 subd	obuf_hnd(r5),r3
	 subd	obuf_hnd+4(r5),r3 ;Free memory in this slot
	 cmpd	r3,r0		;See if bigger than previous block
	 if	gt		;Current block bigger than previous if gt
	  cmpd	r0,r4		;Previous block too small if lt
	  sltb	r7
	 else			;Current block smaller than previous
	  cmpd	r3,r4		;Current block big enough if hs
	  sgeb	r7
	 endif
	 cmpqb	0,r7
	 if	ne
	  movd	r3,r0		;Better fit
	  movd	r5,r2
	  movd	obuf_hnd(r5),r1
	  addd	obuf_hnd+4(r5),r1 ;Buffer pointer
	 endif
	 movw	obuf_st(r5),r3
	 movd	obuf_nxt(r5),r5
	 cmpqd	-1,obuf_nxt(r5)	;Check for last handle
	quit	eq
	 xorw	obuf_st(r5),r3
	 tbitb	bbuf_usr,r3	;Quit if switched to user mode
	endu

	cmpd	r0,r4		;Choose smallest
	if	lo
	 movd	r0,r4		;Can't have more than will fit
	endif
	tbitb	dc_fusr,r6
	if	fs		;User buffer if fs
	 addd	r0,r1		;Top of buffer
	 subd	r4,r1		;Leave just enough room
	endif

	movqb	0,muse_buf	;Release
	restore	[r3,r4,r5,r6,r7]
	ret


;---------------------------------------------------------------------
; Set up new buffer, r4 holds requested size: adjust to Dword boundary
;   Bit dc_fusr set in r5 for user mode
; R3 holds buffer control block size
; Return handle in R5, R5 is -1 if nothing available
; (R5) = address of buffer, 4(R5) = available size
;---------------------------------------------------------------------

alloc:
	save	[r0,r1,r2,r3,r4,r7]
	movd	r5,r7		;Save here

	tbitb	dc_fusr,r7
	if	fs		;User mode if fs
	 save	[r4]
	 movd	r3,r4
	 movqd	0,r5		;Supervisor mode
	 bsr	buf_block	;Get handle block
	 movd	r1,r5
	 restore [r4]
	 cmpd	r3,r0
	 if	ls
	  save	[r2,r5]
	  movd	r7,r5
	  bsr	buf_block	;Now get storage block
	  restore [r2,r5]
	 else
	  movqd	0,r0		;No room
	 endif
	else			;Handle and storage consecutive
	 addd	r3,r4
	 movd	r7,r5
	 bsr	buf_block
	 cmpd	r3,r0
	 if	lo
	  movd	r1,r5		;Handle block
	  addd	r3,r1
	  subd	r3,r0		;Data block
	 else
	  movqd	0,r0		;No room
	 endif
	endif

	cmpqd	0,r0		;Must be room for something
	seqd	r6		;0 if OK
	if	ne
	 movd	r1,obuf_hnd(r5) ;Address of buffer
	 movd	r0,obuf_hnd+4(r5) ;Size of buffer
	 movd	obuf_nxt(r2),obuf_nxt(r5)
	 movd	r2,obuf_prv(r5)
	 movd	r5,obuf_nxt(r2)
	 movd	obuf_nxt(r5),r3
	 movd	r5,obuf_prv(r3)
	 movb	app_num(svc_app),obuf_app(r5) ;Current application
	 movw	exp bbuf_use,obuf_st(r5) ;Status bits now in place
	 tbitb	dc_fusr,r7
	 if	fs		;User mode if fs
	  sbitb	bbuf_usr,obuf_st(r5)
	 endif
	 movd	tbuf_ptr,r3
	 begin			;Find absolute position for this handle
	  cmpqd	-1,obuf_nhn(r3)
	 quit	eq
	  cmpd	obuf_nhn(r3),r5
	 while	hi
	  movd	obuf_nhn(r3),r3
	 endw			;R3 => previous handle
	 movd	obuf_nhn(r3),obuf_nhn(r5)
	 movd	r5,obuf_nhn(r3)
	 movd	r3,obuf_phn(r5)
	 cmpqd	-1,obuf_nhn(r5)
	 if	ne
	  movd	obuf_nhn(r5),r3
	  movd	r5,obuf_phn(r3)
	 endif
	else
	 movqd	-1,r5
	endif

	restore	[r0,r1,r2,r3,r4,r7]
	ret


;---------------------------------------------------------------------
; Set up new buffer, r4 holds requested size: adjust to Dword boundary
;   Bit dc_fusr set in r5 for user mode
; Return handle in R5, R5 is -1 if nothing available
; (R5) = address of buffer, 4(R5) = available size
;---------------------------------------------------------------------

opo_newbf:
	save	[r3]
	movzbd	obuf_max,r3
	bsr	alloc
	restore	[r3]
	ret


;-------------------------------------------
; Fetch buffer from heap, r4 = size
; r6<>0 if less than requested space granted
; eq set according to r6
;-------------------------------------------

get_bufh:
	movqd	0,r5		;Supervisor mode
	bsr	opo_newbf
	cmpqd	0,r6
	if	eq		;Got handle if eq
	 cmpd	4(r5),r4
	 sltd	r6		;R6<>0 if less than requested size
	endif
	cmpqd	0,r6
	ret


;--------------------------
; R4 holds handle of buffer
; Release storage
;--------------------------

opo_clrbf:
	bsr	buf_chek	;Verify handle
	if	eq
	 save	[r5]
	 until fc
	  sbitb 0,muse_buf	;Lock out overlapping calls
	 endu
	 ;
	 movd	obuf_prv(r4),r5 ;R5 points to previous handle
	 movd	obuf_nxt(r4),obuf_nxt(r5) ;Set previous next pointer
	 movd	obuf_nxt(r4),r5 ;Next handle
	 movd	obuf_prv(r4),obuf_prv(r5) ;Set next previous pointer
	 movd	obuf_phn(r4),r5 ;R5 points to previous handle
	 movd	obuf_nhn(r4),obuf_nhn(r5) ;Set previous next pointer
	 cmpqd	-1,obuf_nhn(r4)
	 if	ne
	  movd	obuf_nhn(r4),r5 ;Next handle
	  movd	obuf_phn(r4),obuf_phn(r5) ;Set next previous pointer
	 endif
	 ;
	 movqb	0,muse_buf	;Release
	 bsr	buf_grbg	;Garbage collection
	 restore [r5]
	endif
	ret


;---------------------------
; Set new buffer size, r4 =>
;  handle, new size
;---------------------------

opo_bufsz:
	save	[r2,r4]
	movd	4(r4),r2	;Requested new size
	movd	(r4),r4		;Handle
	addqd	3,r2
	bicb	3,r2		;Dword boundary
	bsr	buf_chek	;Verify buffer handle
	if	eq
	 cmpd	4(r4),r2	;Size must be possible
	 if	hs
	  movd	r2,4(r4)
	  bsr	buf_grbg
	 else
	  movzbd exp bstat_na,r6 ;Error in size
	 endif
	endif
	restore	[r2,r4]
	ret
	

;-----------------------------------------------
; R4 holds application number, clear all buffers
;-----------------------------------------------

clr_app:
	save	[r5]
	movd	tbuf_ptr,r5	;First buffer pointer

	begin
	 movd	obuf_nxt(r5),r5	;Offset to next pointer
	 cmpqd	-1,r5		;End of the line if so
	while	ne
	 cmpb	r4,obuf_app(r5)	;Check for app # match
	 if	eq
	  bsr	opo_clrbf	;Release this buffer
	 endif
	endw

	restore	[r5]
	ret


;---------------------------------------
; Set bit(s) in obuf_st
; TOS holds parameter:w, R4 holds handle
;---------------------------------------

buf_setbit:
	bsr	buf_chek	;Verify buffer handle
	if	eq
	 orw	4(sp),obuf_st(r4)
	endif
	ret	2


;---------------------------------------
; Clear bit(s) in obuf_st
; TOS holds parameter:w, R4 holds handle
;---------------------------------------

buf_clrbit:
	bsr	buf_chek	;Verify buffer handle
	if	eq
	 bicw	4(sp),obuf_st(r4)
	endif
	ret	2


;---------------------------------------------------
; Lock buffer against all moves from any application
; R4 holds handle
;---------------------------------------------------

opo_lonbf:
	movw	exp bbuf_lok,tos
	bsr	buf_setbit
	ret


;-----------------------------------------------------
; Unlock buffer against all moves from any application
; R4 holds handle
;-----------------------------------------------------

opo_lofbf:
	movw	exp bbuf_lok,tos
	bsr	buf_clrbit
	ret


;--------------------------------------------------------------
; Set in use flag to prevent moves for non-current applications
; R4 holds handle
;--------------------------------------------------------------

opo_uonbf:
	movw	exp bbuf_use,tos
	bsr	buf_setbit
	ret


;----------------------------------------------------------------
; Clear in use flag to prevent moves for non-current applications
; R4 holds handle
;----------------------------------------------------------------

opo_uofbf:
	movw	exp bbuf_use,tos
	bsr	buf_clrbit
	ret


;**********************
;* Nested sub-buffers *
;**********************

	mode	imm,obuf_max
subf_prv: blkd			;Handle for previous data block
subf_nxt: blkd			;Handle for next data block
subf_lvl: blkb			;Nesting level
subf_st: blkb			;Status bits
subf_max:			;Extensions start here

;Sub-buffer status bits
	org	0
bsbf_val: blkb			;Valid data block
	mode	pc


;------------------------------------
; R4 holds handle, return level in r5
;------------------------------------

getlvl_subf:
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	movzbd	subf_lvl(r4),r5
	ret
	

;--------------------------
; R4 holds handle
; Return first handle in r5
;--------------------------

first_subf:
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 movd	r4,r5
	 begin
	  cmpqd	-1,subf_prv(r5)
	 while	ne
	  movd	subf_prv(r5),r5
	 endw
	endif
	ret


;-------------------------
; R4 holds handle
; Return last handle in r5
;-------------------------

last_subf:
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 movd	r4,r5
	 begin
	  cmpqd	-1,subf_nxt(r5)
	 while	ne
	  movd	subf_nxt(r5),r5
	 endw
	endif
	ret


;----------------------------
; Get next handle, same level
; r4=handle
; Return in r5
;----------------------------

getnxt_subf:
	save	[r3,r4]
	movqd	-1,r5		;Assume error
	bsr	buf_chek
	if	eq
	 movb	subf_lvl(r4),r3	;Current level
	 until	eq
	  movqd	-1,r5		;Assume no match
	  movd	subf_nxt(r4),r4
	  cmpqd	-1,r4
	 quit	eq
	  cmpb	subf_lvl(r4),r3
	 quit	lo		;End of level if lo
	  movd	r4,r5		;Possible keeper
	 endu
	 cmpqd	-1,r5
	 seqd	r6
	endif
	restore	[r3,r4]
	ret


;--------------------------------
; Get previous handle, same level
; r4=handle
; Return in r5
;--------------------------------

getprv_subf:
	save	[r3,r4]
	movqd	-1,r5		;Assume error
	bsr	buf_chek
	if	eq
	 movb	subf_lvl(r4),r3	;Current level
	 until	eq
	  movqd	-1,r5		;Assume no match
	  movd	subf_prv(r4),r4
	  cmpqd	-1,r4
	 quit	eq
	  cmpb	subf_lvl(r4),r3
	 quit	lo		;End of level if lo
	  movd	r4,r5		;Possible keeper
	 endu
	 cmpqd	-1,r5
	 seqd	r6
	endif
	restore	[r3,r4]
	ret


;------------------------
; Drop down to next level
; Return handle in R5
; R4 holds current handle
;------------------------

nxtlvl_subf:
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 movd	subf_nxt(r4),r5
	 cmpqd	-1,r5
	 if	ne
	  cmpb	subf_lvl(r4),subf_lvl(r5)
	  if	hs
	   movqd -1,r5		;Not nested if hs
	  endif
	 endif
	endif
	cmpqd	-1,r5
	seqd	r6
	ret


;-------------------------
; Backup to previous level
; Return handle in R5
; R4 holds current handle
;-------------------------

prvlvl_subf:
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 until	hi
	  movd	subf_prv(r4),r5
	  cmpqd	-1,r5
	 quit	eq
	  cmpb	subf_lvl(r4),subf_lvl(r5)
	 endu
	endif
	cmpqd	-1,r5
	seqd	r6
	ret


;------------------------------
; Initialize sub-buffer in (R5)
;------------------------------

subf_init:
	cmpqd	-1,r5
	if	ne		;OK if so
	 save	[r4]
	 movd	r5,r4		;New handle
	 bsr	opo_lonbf
	 movqd	-1,subf_prv(r4)
	 movqd	-1,subf_nxt(r4)
	 movqb	0,subf_lvl(r4)	;Start at 0
	 movb	exp bsbf_val,subf_st(r4) ;Valid data block
	 restore [r4]
	endif
	ret


;-------------------------------------
; Make base buffer
; R4=space required
; Bit dc_fusr set in r5 for user mode
; Return handle in r5
;-------------------------------------

make_subf:
	save	[r3]
	movd	subf_max,r3	;Control block space requirements
	bsr	alloc		;Setup control block and get buffer space
	bsr	subf_init
	restore	[r3]
	ret


;-------------------------------------
; Insert at same nesting level
; (R4)=previous handle, space required
; Bit dc_fusr set in r5 for user mode
; Return handle in r5
;-------------------------------------

ins_subf:
	save	[r0,r1,r2,r3,r4]

	movd	r5,r0		;User/supervisor selection
	movd	r4,r1		;Pointer to parameters
	movd	(r1),r4		;Preceding handle
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 movd	4(r1),r4	;Data block size
	 movd	r0,r5
	 bsr	make_subf	;Setup control block and get buffer space
	 cmpqd	0,r6
	 if	eq		;OK if so
	  movd	r5,r4		;New handle
	  movd	(r1),r3		;Previous handle
	  bsr	opo_lonbf
	  movd	r3,subf_prv(r4)
	  movd	subf_nxt(r3),subf_nxt(r4)
	  movd	r4,subf_nxt(r3)
	  cmpqd	-1,subf_nxt(r4)
	  if	ne
	   movd	subf_nxt(r4),r2
	   movd	r4,subf_prv(r2)
	  endif
	  movb	subf_lvl(r3),subf_lvl(r4) ;Same level
	  movb	exp bsbf_val,subf_st(r4) ;Valid data block
	 endif
	endif

	restore	[r0,r1,r2,r3,r4]
	ret


;-------------------------------------
; Insert at next nesting level
; (R4)=previous handle, space required
; Bit dc_fusr set in r5 for user mode
; Return handle in r5
;-------------------------------------

nest_subf:
	bsr	ins_subf
	cmpqd	0,r6
	if	eq
	 addqb	1,subf_lvl(r5)
	endif
	ret


;-------------------------------------
; Add new buffer at same nesting level
; (R4)=previous handle, space required
; Bit dc_fusr set in r5 for user mode
; Return handle in r5
;-------------------------------------

new_subf:
	save	[r3,r4]
	movqd	-1,r5		;Assume error
	bsr	buf_chek
	if	eq
	 movb	subf_lvl(r4),r3	;Save current level
	 movd	4(r4),tos
	 bsr	getnxt_subf	;Advance to next entry on same level
	 cmpqd	0,r6
	 if	eq
	  movd	subf_prv(r5),tos
	 else
	  bsr	last_subf
	  movd	r5,tos
	 endif
	 addr	tos,r4
	 bsr	ins_subf
	 movb	r3,subf_lvl(r5)	;Make this same level
	 adjspb	-8
	endif
	restore	[r3,r4]
	ret


;----------------------------
; Delete buffer, handle in r4
;----------------------------

del_subf:
	save	[r0,r1,r2,r3,r4,r5]
	movd	r4,r2
	movqd	-1,r5		;In case of error
	bsr	buf_chek
	if	eq
	 cbitb	bsbf_val,subf_st(r4) ;Make this invalid
	 movqd	0,r0
	 movb	subf_lvl(r2),r1	;Look for nested buffers
	 begin
	  movd	subf_nxt(r2),r2
	  cmpqd	-1,r2
	 quit	eq
	  cmpb	subf_lvl(r2),r1
	 while	hi
	  tbitb	bsbf_val,subf_st(r2)
	  if	fs
	   addqd 1,r0
	  endif
	 endw
	 cmpqd	0,r0
	 if	eq		;Can't delete if nested buffers
	  until	ls
	   movd subf_prv(r4),r5 ;Previous handle
	   cmpqd -1,r5
	   if	ne
	    movd subf_nxt(r4),subf_nxt(r5)
	   endif
	   movd subf_nxt(r4),r5 ;Next handle
	   cmpqd -1,r5
	   if	ne
	    movd subf_prv(r4),subf_prv(r5)
	   endif
	   bsr	opo_clrbf	;Release data block
	   movd	r5,r4
	   cmpqd -1,r4
	  quit eq
	   cmpb	subf_lvl(r4),r1
	  endu
	 endif
	endif
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;************************
;* Application routines *
;************************

;-----------------------------------------------------------
; Return number in R5 of next available application slot
; R5=-1 if nothing available, Pointer loaded with 0 if found
; Scan (APP_PTR) for 1st -1
;-----------------------------------------------------------

get_app:
	until fc
	 sbitb 0,muse_app	;Lock out overlapping calls
	endu

	movqd	-1,r5		;Invalid for now
	save	[r0,r1]
	movd	app_ptr,r1	;Pointer to pointers
	movqd	0,r0		;Application counter
	begin
	 cmpd	map_max,r0
	while	hi
	 cmpd	r5,(r1)
	quit	eq		;Got one if EQ
	 addqd	4,r1
	 addqd	1,r0
	qend
	 movqd	0,(r1)
	 movd	r0,r5		;App number
	endw

	movqb	0,muse_app	;Release
	restore	[r0,r1]
	ret
	

;-----------------------------------------------------------
; Get new application number and setup memory
; R5 holds address of new application storage or -1 if error
; NE true if OK, EQ true if error
;-----------------------------------------------------------

	cond	0
new_app::
	 save	[r0,r1,r2,r3,r4]
	 bsr	get_app		;Get a new app number in R5
	 cmpqd	-1,r5
	 if	ne		;No free app numbers if -1
	  movd	r5,r4		;App number
	  movd	app_last,r3	;Required memory for application storage
	  bsr	newbf_sb
	  cmpqd	-1,r5		;Must be valid storage
	  if	ne
	   cmpd	app_last,4(r5)	;Must be big enough
	   if	ls
	    orw	exp bbuf_use+exp bbuf_lok,obuf_st(r5)
	    movd r5,(app_ptr)[r4:d] ;Handle to application specific storage
	    movd app_last,r0	;Number of bytes to move
	    movd svc_app,r1	;Source address
	    movd (r5),r2	;Target address
	    movsb
	    movd (r5),r5	;Address of new storage
	    movb r4,app_num(r5)
	   else
	    movd r5,r4
	    bsr	opo_clrbf	;Can't use this anymore
	    movqd -1,r5		;Error
	   endif
	  endif
	 endif
	 restore [r0,r1,r2,r3,r4]
	 cmpqd	-1,r5		;Error if EQ
	 ret
	cend


;Launch an application in current app number

	cond	0
opo_prgl::
	 save	[r0,r1,r5,r6,r7]
	 movd	(dev_m1+1)+dof_cmd lsh b_iosrv,r6 ;M1 command
	 movd	dc_open+usr_exe,r5
	 bsr	dosvc
	 cmpqd	0,r6
	 restore [r0,r1,r5,r6,r7]
	 if	eq
	  save	[r6,r7]
	  movd	(dev_m1+1)+dof_cmd lsh b_iosrv,r6 ;M1 command
	  movd	dc_getsiz+usr_exe,r5
	  bsr	dosvc
	  restore [r6,r7]
	  movd	r5,r3
	  bsr	newbf_sb:w
	  cmpqd -1,r5		;Must be valid
	  if	ne
	   cmpd 4(r5),r3
	   if	hs
	    movd r5,r4		;Handle to link file
	    orw exp bbuf_use+exp bbuf_lok,obuf_st(r4)
	    movd (r4),r1
	    save [r4,r6,r7]
	    movd exp bkb_trm+h'ffff,r0 ;Read entire file
	    movd (dev_m1+1)+dof_blk lsh b_iosrv,r6 ;M1 block input
	    bsr dosvc
	    movd r6,tos		;0 if successful read
	    movd (dev_m1+1)+dof_cmd lsh b_iosrv,r6 ;M1 command
	    movd dc_close,r5
	    bsr dosvc
	    ord	tos,r6
	    cmpqd 0,r6
	    restore [r4,r6,r7]
	    if	eq
	     bsr ld_init	;Initialize loader memory
	     movd (r4),r1
	     movd r1,mod_tabl+4+4+2+2*sidx_of ;Code address
	     movd r1,mod_tabl+4+4+2+2*sidx_of+4 ;PC address
	     movqd 0,tos
	     movd r1,tos	;Starting address of code
	     bsr rd_link:d	;Preliminary link/load
	     adjspb -8		;Drop execution address/module
	     
	     movd mod_indx,r5	;Number of MOD tables needed
	     bsr get_mod:w	;Get mod table pointer in R5
	     movd r5,r1		;MOD table pointer for debugger
	     cmpqd -1,r1
	     if	ne
	      movd r1,mod_tabl+4+4+2+2*sidx_of+4+4+4 ;MOD address
	      movd (r4),r1
	      movd r1,mod_tabl+4+4+2+2*sidx_of+4 ;PC address
	      extsb 4+32+32(r1),r5,0,1 ;ONEMOD bit
	      lshb 2,r5		;Move to correct bit for LNK_PRM
	      movb r5,lnk_prm
	      movqd 0,r2	;Total PC size
	      movqd 0,r3	;Total SB size
	      movd mod_indx,r0
	      addr mod_tabl,r1
	      until eq
	       addd (r1),r2
	       addd 4(r1),r3	;Size of SB
	       addqd 3,r3
	       bicb 3,r3	;Round to Dword boundary
	       addd mod_tsiz,r1
	       addqd -1,r0
	       cmpqd 0,r0
	      endu
	      addd (r4),r2	;Last PC address
	      addqd 3,r2
	      bicb 3,r2		;Dword boundary
	      movd r2,mod_tabl+4+4+2+2*sidx_of+4+4+4+4 ;Link table address
	      bsr newbf_sb:w	;SB buffer
	      cmpqd -1,r5
	      if ne
	       orw exp bbuf_use+exp bbuf_lok,obuf_st(r5)
	       cmpd 4(r5),r3
	       if hs
	        movd (r5),mod_tabl+4+4+2+2*sidx_of+4+4 ;SB address
	        movd m_stksiz,r3 ;Stack size
	        bsr newbf_sb:w	;Stack buffer
	        cmpqd -1,r5
	        if ne
	         cmpd 4(r5),r3
	         if hs
	          orw exp bbuf_use+exp bbuf_lok,obuf_st(r5)
	          addd (r5),r3	;TOS address
	          movd r3,m_stksiz+4 ;Store stack address
	          movd mod_tabl+4+4+2+2*sidx_of+4+4+4,tos ;MOD address
	          bsr lnk_adr:d
	          
	          movd m_link,tos ;Pointer to link data
	          movd mod_tabl+4+4+2+2*sidx_of,r5 ;Current base address
	          movd r5,tos	;Address for object code
	          movd r5,tos	;Starting PC_OFST
	          movqd 0,lmod	;Start with Mod 0
	          movqd 0,msym_beg ;Search entire symbol table now
	          movb "L",m_pass ;Link only here
	          bsr do_link:d	;Final link routine
	          bsr bld_mod:d	;Build MOD and LINK tables in memory now
	          cmpqd 0,m_errct
	          if eq
	           bispsrw flag_s ;Select user stack
	           lprd sp,m_stksiz+4
	           bicpsrw flag_s ;Back to system stack
	           sprw psr,tos	;Interrupt flag must be copied
	           orw flag_s+flag_u,tos ;These must be set
	           movd mod_tabl+4+4+2+2*sidx_of+4+4+4,r5 ;MOD address
	           movw r5,tos
	           movd 8(r5),tos ;Execution address
	           cond cpu532
	            lprw mod,r5
	            lprd sb,(r5)
	           cend
	           rett		;Do it
	          endif
	         endif
	        endif
	       endif
	      endif
	     endif
	    endif
	   endif
	  endif
	 endif
	 
;Release all storage and exit
	 
	 movzbd	app_num(svc_app),r4
	 bsr	clr_app:w	;Release all storage
	 bsr	clr_mod:w	;Release MOD tables
	 ret
	cend


opo_cprgx::			;Exit to operating system
	cond	0
	 movzbd	app_num(svc_app),r4
	 bsr	clr_app:w	;Release all storage
	 bsr	clr_mod:w	;Release MOD tables
	 lprd	sp,svc_sp	;Reload supervisor stack
	 sprw	psr,tos
	 sprw	mod,tos		;Use supervisor's MOD and PSR
	 addr	menu_lp:d,tos	;Target address
	 cond	svc_cxp and cpu532
	  sprd	mod,r1		;Current MOD
	  lprd	sb,(r1)		;Current SB
	 cend
	 rett
	cend


;**********************
;* MOD table routines *
;**********************

;-----------------------------
; Initialize mod table storage
;-----------------------------

mod_init:
	save	[r2,r5]
	sprd	mod,r2
	movqb	0,muse_mod	;Nothing in progress
	movd	-4(r2),r5	;Size of MOD table memory
	addd	r2,r5		;Last memory address for MOD tables
	movd	r5,mod_last
	addd	4*4,r2
	movd	r2,mod_base
	movqw	0,(r2)		;End of the line
	movqb	0,2(r2)		;Current application
	movqb	0,3(r2)		;No MOD tables here
	restore	[r2,r5]
	ret


;-------------------------------------
; R5 holds number of MOD blocks needed
; Return address in R5, -1 if none
;-------------------------------------

get_mod:
	save	[r0,r1,r2,r3,r4]
	until fc
	 sbitb	0,muse_mod	;Lock out overlapping calls
	endu

	movd	mod_base,r1	;MOD table pointer
	movd	r5,r2		;Save number of mods needed

	until	ls
	 movqd	-1,r5		;Nothing yet
	 cmpd	mod_last,r1
	 if	hi
	  movzwd (r1),r3	;Next address
	  cmpqd	0,r3
	  if	eq
	   movd	mod_last,r3	;Highest possible address
	  endif
	  movzbd 3(r1),r5	;Number of MODs here
	  lshd	4,r5		;Multiply by 16
	  addr	4+4(r1)[r5:b],r5 ;Next possible MOD (after header)
	  movd	r2,r4
	  lshd	4,r4		;Bytes needed for requested MODs
	  addd	r5,r4		;Next address after new inserted block
	  cmpd	r4,r3
	  if	ls		;Room after (R3) block if LS
	   movw	(r1),-4(r5)	;Current pointer to next entry
	   addr	-4(r5),r4
	   movw r4,(r1)		;Previous pointer to next entry
	   movb	r2,-1(r5)	;Number of blocks
	   movb	app_num(svc_app),-2(r5) ;Current application
	  else
	   movd	r3,r1		;Next address
	  endif
	 endif
	endu

	movqb	0,muse_mod	;Release
	restore	[r0,r1,r2,r3,r4]
	ret


;----------------------------------------------------
; R5 holds application number, release all MOD tables
;----------------------------------------------------

clr_mod:
	save	[r1,r2]
	until fc
	 sbitb 0,muse_mod	;Lock out overlapping calls
	endu

	movd	mod_base,r1	;MOD table pointer
	movd	r1,r2		;Last table actually in use
	until	eq
	 cmpb	r5,2(r1)
	 if	eq
	  movw	(r1),(r2)	;Next pointer skips released blocks
	 else
	  movd	r1,r2		;This is still in use
	 endif
	 movzwd	(r1),r1		;Next block
	 cmpqd	0,r1		;End of the line if so
	endu

	movqb	0,muse_mod	;Release
	restore	[r1,r2]
	ret
	

;****************************
;* Service routine chaining *
;****************************


;Format of chained heap buffer:
	mode	imm-,0
;IO routine
lch_idxia: blkd			;Service routine address
lch_r7ia: blkd			;R7 block for entry
lch_jsria: blkb 6		;jsr @chain:d
;Status routine
lch_idxsa: blkd
lch_r7sa: blkd
lch_jsrsa: blkb 6
;Target chained routine
lch_idxib: blkd
lch_r7ib: blkd
lch_jsrib: blkb 6
lch_idxsb: blkd
lch_r7sb: blkd
lch_jsrsb: blkb 6
;Command routine
lch_idxc: blkd
lch_r7c: blkd
lch_jsrc: blkb	6
lch_oldcmd: blkd		;Storage for original command routine
lch_siz:			;Size
	mode	pc
	
;------------------------------
; Actual service routine:
; (sp) => data: r7:d, address:d
;------------------------------

chain:
	save	[r3,r7]
	movd	0(8(sp)),r7	;New r7 value
	movd	4(8(sp)),r3	;Target address
	jsr	r3
	restore	[r3,r7]
	adjspb	-4		;Drop pointer to parameters
	ret


;-----------------------------------
; Chain devices, r5 holds new device
;-----------------------------------

nlo_chain:
	save	[r0,r1,r2,r3,r4,r5]

	save	[r7]
	movb	svc_r6,r2	;Save this
	movb	r5,svc_r6	;Temporary new value
	movqd	0,r4		;No extra room required here
	movzbd	r5,r0		;Device to chain into
	movd	(dev_ptr)[r0:d],r7 ;Device to chain into
	bsr	nlo_cinstnc
	movd	r5,r1		;Save new r7 value
	movb	r2,svc_r6	;Restore original
	restore	[r7]
	cmpqd	0,r6
	if	eq
	 negd	lch_siz,r4	;Extra room for more parameters
	 bsr	nlo_cinstnc	;Create new instance
	 movd	r5,r7		;New r7 value
	 cmpqd	0,r6		;Only if OK so far
	 if	ne
	  save	[r7]
	  movd	r1,r7
	  bsr	nlo_cunvct	;Release this too
	  restore [r7]
	 else
;	  movb	lnt_chain,4*dof_id+3(r7)
	  movzbd 4*dof_id+dofid_max(r7),r2 ;Dof_max
	  addr	name_siz(r7)[r2:d],r2 ;Skip to start of parameters
	  movd	lnk_hnd(r2),r5	;Current handle
	  movd	(r5),r2		;First address of buffer
	  addd	4(r5),r2	;Last address of buffer+1
	  movd	4*dof_sio(r7),lch_idxia(r2)
	  movd	4*dof_sst(r7),lch_idxsa(r2)
	  movd	4*dof_cmd(r7),lch_idxc(r2)
	  movd	4*dof_sio(r1),lch_idxib(r2)
	  movd	4*dof_sst(r1),lch_idxsb(r2)
	  movd	r7,lch_r7ia(r2)
	  movd	r7,lch_r7sa(r2)
	  movd	r7,lch_r7c(r2)
	  movd	r1,lch_r7ib(r2)
	  movd	r1,lch_r7sb(r2)
	  movw	l'7fae,lch_jsria(r2) ;JSR @:d opcode
	  movw	l'7fae,lch_jsrsa(r2)
	  movw	l'7fae,lch_jsrib(r2)
	  movw	l'7fae,lch_jsrsb(r2)
	  movw	l'7fae,lch_jsrc(r2)
	  addr	chain,r4	;Address of dispatch routine
	  rotw	8,r4		;Swap lower 2 bytes
	  rotd	16,r4		;Exchange upper and lower words
	  rotw	8,r4		;Byte order reversed now
	  orb	h'c0,r4		;Make Dword displacement
	  movd	r4,lch_jsria+2(r2) ;JSR @chain installed
	  movd	r4,lch_jsrsa+2(r2)
	  movd	r4,lch_jsrib+2(r2)
	  movd	r4,lch_jsrsb+2(r2)
	  movd	r4,lch_jsrc+2(r2)
	  cond	cpu532
	   cinv	a,i,r2		;Clear instruction cache
	  cend
	  ;
	  addr	lch_jsrib(r2),4*dof_io(r7)
	  addr	lch_jsrsb(r2),4*dof_stat(r7)
	  addr	lch_jsria(r2),4*dof_sio(r1)
	  addr	lch_jsrsa(r2),4*dof_sst(r1)
	  movd	4*dof_cdat(r1),r5 ;Pointer to command data
	  movzwd (r5),r4	;Number of commands
	  addr	2(r5)[r4:d],r5	;Pointer to default processor
	  movd	(r5),lch_oldcmd(r2) ;Save original
	  addr	lch_jsrc(r2),(r5) ;Look here if nothing found there
	  ;
	  movzbd svc_r6,r4
	  movd	r7,(dev_ptr)[r4:d] ;Install new default pointer
	  movd	r1,(dev_ptr)[r0:d] ;Routine chained into
	 endif
	endif

	restore [r0,r1,r2,r3,r4,r5]
	ret


;--------------------
; Unchain and restore
;--------------------

nlo_unchn:
	save	[r0,r1,r4,r5]

	movqd	-1,r6		;Assume error
;	cmpb	lnt_chain,4*dof_id+3(r7)
	if	eq		;Must be chained
	 movzbd 4*dof_id+dofid_max(r7),r5 ;Dof_max
	 lshd	2,r5		;Multiply by 4
	 addd	name_siz,r5	;Skip over name field
	 save	[r7]
	 movd	lch_r7ib(r5),r7
	 movd	4*dof_cdat(r7),r1 ;Pointer to commands
	 movzwd (r1),r0	;Command count
	 movd	lch_oldcmd(r5),2(r1)[r0:d] ;Restore old default processor
	 bsr	nlo_cunvct	;Release target chained routine
	 restore [r7]
	 bsr	nlo_cunvct
	endif

	restore [r0,r1,r4,r5]
	ret


;******************
;* Mouse routines *
;******************

;---------------
; Initialization
;---------------

pti_cinit:
	save	[r2,r3,r5]
	movzbd	dev_smk+1,r5
	movd	(dev_ptr)[r5:d],r2
	movd	4*dof_dat(r2),r2 ;Data pointer
	bsr	nlo_chain	;Chain into keyboard routine
	movd	4*dof_dat(r7),r3
	movb	dat_kv(r2),dat_kv(r3) ;Copy echo device
	restore	[r2,r3,r5]
	ret


;-------
; Status
;-------

pti_sst:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3 ;Address of data block

	movd	4*dof_stat(r7),r4
	jsr	r4		;Check device status
	cmpqd	0,r6		;Something there if EQ
	if	eq
	 movqd	0,r0		;Character counter
	 movqd	0,r1		;Composite character
	 movqd	0,r2		;Insertion index
	 movzbd dat_kv(r3),r6
	 movd	(dev_ptr)[r6:d],r6
	 movd	4*dof_dat(r6),r6
	 movzbd dat_kv(r6),r6	;Input device
	 orw	dof_cmd lsh b_iosrv,r6
	 until	ne
	  movd	r6,tos
	  movd	4*dof_io(r7),r4 ;Address of input routine
	  jsr	r4
	  movd	tos,r6
	  insb	r2,r5,r1,8	;Insert into next position
	  addqd 1,r0		;1 more character read
	  addb	8,r2		;Next insertion position
	  movd	dc_xlat,r5
	  movd	r6,tos
	  bsr	bsr_svc
	  cmpqd exp bstat_nr,r6 ;Need more characters if eq
	  movd	tos,r6
	 endu
	 movd	4*dof_bdat(r7),r2
	 tbitb	bdp_mous,dat_ptcl(r2)
	 if	fc		;No mouse intercept if fc
	  movd	dat_bwtx(r3),r0 ;Write index
	  movd	dat_bpt(r3),r1	;Buffer pointer
	  until	eq
	   movb	r4,r1[r0:b]	;Store character just received
	   addqd 1,r0		;Increment pointer
	   andd	dat_bsz(r3),r0	;Wrap around as needed
	   addqd 1,dat_bchr(r3)	;Increment character count
	   lshd	-8,r4
	   addqb -1,r5
	   cmpqb 0,r5
	  endu
	  movd	r0,dat_bwtx(r3)	;New data pointer
	 else
	  cmpqb	2,r0
	 orif	ne
	  cmpb	vc_win,r1	;Must be window command
	 orif	ne
	  lshw	-8,r1		;2nd byte to bits 0-7
	  cond	kbdansi
	   bicb	vcw_pix,r1	;Pixel and character same if ansi
	  cend
	  movd h'ffff0000,r2	;Mouse movement offset
	  cmpb	vcw_chr+vcw_mov+vcw_up,r1 ;Up
	  if	eq
	   movd	r2,r4
	   movd dc_relxy,r5	;Set new relative pixel xy coordinates
	   movzbd dat_kv(r3),r6
	   orw	dof_cmd lsh b_iosrv,r6
	   bsr	bsr_svc
	   bispsrb flag_z	;Make eq
	  else
	   movd h'10000,r2
	   cmpb	vcw_chr+vcw_mov+vcw_dn,r1 ;Down
	  orif	eq
	   movqd 1,r2
	   cmpb	vcw_chr+vcw_mov+vcw_rt,r1 ;Right
	  orif	eq
	   movzwd h'ffff,r2
	   cmpb	vcw_chr+vcw_mov+vcw_lft,r1 ;Left
	  orif	eq
	  endif
	 orif	ne
	 endif
	endif

	cmpqd	0,dat_bchr(r3)	;See if anything in buffer
	seqd	r6
	restore	[r0,r1,r2,r3,r4,r5]

	ret


;*****************
;* Menu routines *
;*****************

;-------------------------
;Table of menu subcommands
;-------------------------

t_menvc:
	db	men_base	;Base value
	db	(t_menvc2-t_menvc1)/8 ;Number of entries

t_menvc1:
	dd	1		;One byte follows
	dd	tab_vcs-($-4)	;Horizontal space
	dd	0		;Nothing else required
	dd	nln_vcs-($-4)	;New line if not at beginning
	dd	0		;Nothing else required
	dd	cls_vcs-($-4)	;New page
	dd	2		;Col, row follow
	dd	cur_vcs-($-4)	;Position to col:B,row:B
	dd	4		;Col, row follow
	dd	pix_vcs-($-4)	;Pixel position col:W, row:W
	dd	8		;Upper left col/row, dimensions
	dd	win_vcs-($-4)	;Set window pixel size
	dd	1		;Bit 7 set for flash, bit 6 set for text
	dd	crsr_vcs-($-4)	;Set cursor size/type
t_menvc2:

	cond	0

;Turn on the cursor

crsr_on:
	ret

;Turn off the cursor

crsr_off:
	ret

;Set cursor according to R5
;R7 must be valid
;Enter at S2O_CRSB to not update memory storage

s2o_crsr:
s2o_crsb:
	ret


;Release window (number in R5:B if DC_WCR5 set)
;Use current window if DC_WCR5 is clear

s2o_wclr:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3 ;Current data block
	movd	r5,r2		;Window number/command
	movqd	0,r5		;Invalid window data pointer
	tbitb	dc_wcr5,r2	;Clear window storage in R5 if set
	if	fc
	 movb	dat_wndw(r3),r2	;Use current window
	endif
	cmpb	win_max,r2	;Must be valid
	if	hi
	 movzbd r2,r2		;Window number in R2
	 muld	win_last,r2	;Size of each window
	 addr	(win_base)[r2:b],r1 ;Base address
	 movd	dat_wptr(r1),r5	;This is the window data pointer
	 movqw	0,dat_wprm(r1)	;Release window here
	 movqd	0,dat_wptr(r1)	;Clear this too
	endif
	movd	r5,r4
	bsr	opo_clrbf	;Release storage in R5 too
	restore	[r1,r2,r3,r4,r5]
	ret


;Return number of free window in R5
;Also set BDW_USE bit and load number into DAT_WNDW
;Current window saved
;R5 = -1 if none and nothing changed

s2o_wnxt:
	save	[r0,r1,r2,r3]
	movd	4*dof_dat(r7),r3
	movzbd	dat_wndw(r3),r2	;Current window number
	muld	win_last,r2	;Size of each window
	addr	(win_base)[r2:b],r2 ;Pointer to window data
	addr	dat_wmin(r3),r1	;Current data pointer
	movzbd	dat_wmax-dat_wmin,r0 ;Number of bytes to save
	movsb			;Save in case it's in use
	movd	4*dof_vdat(r7),r1 ;Virtual device parameters
	addr	vdt_wmin(r1),r1
	movzbd	vdt_wmax-vdt_wmin,r0
	movsb
	movqd	0,r5		;Window counter
	addr	(win_base),r1	;Pointer to first window
	begin
	 sbitb	bdw_use,dat_wprm(r1) ;See if in use
	while	fs
	 addqb	1,r5		;Next possible window number
	 addd	win_last,r1	;Advance to next window
	 cmpb	r5,win_max
	quit	hs
	qend
	 movqd	-1,r5
	endw
	cmpqd	-1,r5
	if	ne
	 movb	r5,dat_wndw(r3)	;Current window selection
	 movw	exp bdw_use,dat_wprm(r1) ;Clear all but in use bit
	endif
	restore	[r0,r1,r2,r3]
	ret


;Begin menu window, read data into storage
{
on entry: dat_next holds default r0:w, max number of characters:w
storage block in dat_next:
  bytes 9-12: exit address if count decremented to 0
  bytes 13-16: buffer handle (pointer:d, size:d)
  bytes 17-18: current data offset
  byte 19: string count
}

set_menu:
	movzwd	7(r2),r4	;Max size, MSB/LSB
	rotw	8,r4		;Correct byte order
	movqd	0,r5		;Supervisor mode
	bsr	opo_newbf	;Get handle in R5
	movzwd	5(r2),r3	;Default R0
	rotw	8,r3		;Correct byte order
	cmpqd	-1,r5
	if	ne		;No buffer memory if NE
	 save	[r2]
	 movd	(r5),r1		;Data pointer to R1
	 movd	r1,r4		;Save pointer here
	 movd	4(r5),r0	;Size of buffer
	 addqd	-1,r0
	 addr	1(r1),r2
	 movqb	0,(r1)
	 movsb			;Fill entire buffer
	 movw	256*vcw_menb+vc_win,(r4)
	 movw	dat_col(r3),2(r4) ;Cursor column
	 movw	dat_line(r3),4(r4) ;Cursor row
	 movw	r3,6(r4)	;Default R0
	 restore [r2]
	endif
	movd	r5,13(r2)	;Handle to data storage
	movw	8,17(r2)	;Current data offset
	movqb	0,19(r2)	;0 string length
	movqd	1,r0		;Read character by character
	addr	sav_menu,r1
	br	vc_more


;Store R5 in menu storage

sav_menu:
	movd	13(r1),r5	;Window handle
	movd	(r5),r1		;Pointer to menu storage
	movd	4(r5),r0	;Size of storage
	movb	5(r2),r5	;Current character to store
	movzwd	17(r2),r4	;Buffer offset
	cmpqd	-1,r1		;Nothing if -1
	if	ne
	 cmpw	r4,r0		;Current offset must be less than buffer size
	 if	lo
	  addd	r1,r4		;Current address
	  movb	r5,(r4)		;Store current character
	  addqw 1,12(r2)
	 endif
	endif
	cmpqb	0,19(r2)	;See if storing string
	if	eq
	 cmpb	h'80,r5
	 if	ls
	  cmpb	h'9f,r5
	  if	hs
	   cmpqb 0,t_dovc1-h'80[r5:b] ;See if more follows
	   if	ne
	    addr sav_vc,9(r2)	;Exit address
	    movqb 1,19(r2)
	   endif
	  endif
	 endif
	else
	 addqb	-1,19(r2)
	 cmpqb	0,19(r2)
	 if	eq

	movzbd	5(r2),r5	;Command to process
	subb	(r1),r5		;Subtract offset
	cmpb	1(r1),r5	;Make sure it's in range
	bls	retrn:w

	save	[r3]
	addr	2(r1),r3	;Advance to dispatch offsets
	movxwd	r3[r5:d],r1	;Offset to target from base
	addd	r3,r1		;Absolute address of following routine
	movb	2(r3)[r5:d],r0	;Number of bytes to follow
	restore	[r3]

	cmpqb	0,r0		;Just jump to it if no more parameters needed
	bne	vc_more		;Read more if required
	jump	r1



	  movd	9(r2),tos
	  ret
	 endif
	endif
sav_menx:
	movqd	1,r0
	addr	sav_menu,r1
	br	vc_more		;Do it all again

;2nd byte of H'80-H'9F code received

sav_vc:
	cmpw	vc_win,-1(r4)	;Check for window command
	if	ne
	 addr	-1(r4),r1
	 bsr	vstr_len	;Get number of following characters in R5
	 movb	r5,19(r2)
	 addr	sav_menx,9(r2)	;Exit address after all codes stored
	else
	 cmpb	vcw_mene,r5	;End of menu
	 if	eq
	  movqb	2,19(r2)	;Default item index
	  addr	sav_mite,9(r2)	;All done after default menu received
	 else
	  cmpb	vcw_minp,r5	;Input area
	  if	eq
	   addqw 4,17(r2)	;4 bytes cursor position storage
	   movb	8,19(r2)	;R0:W, R5:D, default/max length
	   addr	sav_minp,9(r2)
	  else
	   cmpb	vcw_mitb,r5	;Item beginning
	   if	eq
	    addqw 4,17(r2)	;Cursor storage
	    movqb 2,19(r2)	;Hilite attribute, select code length
	    addr sav_mitb,9(r2)
	   else
	    cmpb vcw_mcst,r5
	    if	eq
	     addqw 1,17(r2)	;Current MINP string storage
	     movqb 1,19(r2)
	     addr sav_menx,9(r2)
	    endif
	   endif
	  endif
	 endif
	endif
	br	sav_menx

;Table of menu codes:
;  Offset of service routine from t_menu1
;  Number of bytes to follow
;  Number of bytes storage to allocate

t_menu:
	db	men_base
	db	(t_menu2-t_menu1)/4
t_menu1:
	dw	do_mmitb-t_menu1 ;Begin a menu item
	db	0, 2+2+1+1	;Cursor col, row, attribute, data byte
	dw	do_mminp-t_menu1 ;Menu line input position
	db	0, 2+2+1+1	;Cursor col, row, attribute, data byte
	dw	do_mmcst-t_menu1 ;Comma separated strings input
	db	0, 0
	dw	do_mtdsp-t_menu1 ;Text for immediate display
	db	0, 1+1		;Max length, current length
	dw	do_mtinp-t_menu1 ;Text field for string input
	db	0, 1+1		;Max length, current length
	dw	do_msel-t_menu1	;Select string
	db	0, 1+1		;Max length, current length
	dw	do_mret-t_menu1	;Return string
	db	0, 1		;Length
	dw	do_mnxt-t_menu1	;Next item index
	db	2, 0
	dw	do_mr0-t_menu1	;R0 value for string input
	db	4, 0
	dw	do_mr5-t_menu1	;R5 value for string input
	db	4, 0
	dw	do_msub-t_menu1	;Subroutine address
	db	4, 0
	dw	do_mdat-t_menu1	;Data field
	db	8, 0
	dw	do_mid-t_menu1	;ID field for return
	db	8, 0
	dw	do_mx-t_menu1	;End of string, item, etc.
	db	0, 0
	dw	d0_mmene-t_menu1 ;Menu end
	db	0, 0
t_menu2:

;MENE and default item number just received

sav_mene:
	movzwd	17(r2),r4	;Current storage index
	cmpd	r4,r0
	if	lo		;Free unused space at end
	 movd	13(r2),r5	;Handle to buffer
	 movd	r4,4(r5)	;New length
	endif
	ret			;All done with saving

;MINP default text coming next

sav_minp:
	movb	r5,19(r2)	;Receive default text next
	addr	sav_menx,9(r2)
	br	sav_menx

;MITB select code coming next

sav_mitb:
	movb	r5,19(r2)
	addr	sav_mit2,9(r2)	;Data type coming next
	br	sav_menx

;MITB data type coming next

sav_mit2:
	movqb	1,19(r2)
	addr	sav_mit3,9(r2)
	br	sav_menx

;Data value coming next, type in R5

sav_mit3:
	addw	8,17(r2)	;Storage for data
	andd	h'f,r5
	cmpb	h'f,r5		;Undefined if EQ
	if	ne
	 movb	t_symsiz[r5:b],r5 ;Number of bytes to read
	 subw	r5,17(r2)	;Right justify data
	 movb	r5,19(r2)
	 addr	sav_menx,9(r2)
	endif
	br	sav_menx


;Current window DAT_WPTR points to menu data
;Process menu and return keypress in R5, string in R0/R1, item index in R4
;Selected item becomes new default, bit 7 of hilite attribute toggled
;Returns when any string item done, or when space pressed or
; when any movement command exits a string (default updated for re-entry) or
; when ESC or RET pressed as selected by default XLAT option
;SPACE tags an item and sets bit 7 of hilite attribute
;ESC aborts
;RET completes entry, returns item index but doesn't tag entry
;R1 => buffer; If no string: R0=0

{
m_mitb followed by cursor col:w, cursor row:w
  hi-lite:b, select length:b, select text:n
  data type:b, data variable storage:8 (right justified)
m_minp followed by cursor col:w, cursor row:w, r0:w, r5:d, default length:b,
  max length:b, default text
m_mcst followed by current string storage:b, number if minp strings:b
m_mene followed by default item number
}

do_menu:
	save	[r1,r2,r3,r6]

	mode	sp,4*7+2*2
domn_r1: blkd			;Original R1
domn_r5: blkd			;Original R5
domn_r6: blkd			;Original R6
domn_dat: blkd			;Data block for output
domn_ptr: blkd			;Pointer to start of menu data
domn_len: blkd			;Length of menu data
domn_dfl: blkd			;Pointer to default item number
domn_max: blkw			;Max item number
domn_cnt: blkw			;Current item number
	mode	pc

	adjspb	4*7+2*2
	addr	(sp),r2		;Pointer to stack data
	movd	r1,domn_r1
	movd	r5,domn_r5
	movd	r6,domn_r6
	subw	1 lsh b_iosrv,r6 ;Need output offset here
	movb	dof_chr,r6	;Character output
	movd	4*dof_dat(r7),r1
	movd	r1,domn_dat	;Data block for output
	movzbd	dat_wndw(r1),r1	;Current window number
	muld	win_last,r1	;Size of each window
	movd	dat_wptr(win_base)[r1:b],r1 ;Pointer to data
	cmpqd	0,r1		;Not defined if 0
	if	eq
	 movqd	0,r0
	 movqd	-1,r5
	else
	 cmpqd	-1,r1
	orif	eq
	 movd	4(r1),r0	;Size of data
	 movd	r0,domn_len
	 movd	(r1),r1		;Pointer to data
	 movd	r1,domn_ptr
	 addr	-2(r1)[r0:b],domn_dfl ;Address of default item number
	 movw	(domn_dfl),domn_cnt ;Current item number

;Ready to display menu

	 bsr	crsr_off
	 addqd	2,r1
	 addqd	-2,r0		;Advance to cursor position
	 bsr	win_crsr	;Position cursor according to (R1)
	 bsr	end_item	;Skip to next text
	 addqd	-4,r0		;Don't count menu end code or default item #
	 
	 movqw	-1,domn_max	;Highest item index (from 0)
	 begin
	  cmpw	vc_win+256*vcw_mene,(r1) ;Check for end of menu data
	 while	ne
	  cmpb	vc_win,(r1)
	  if	ne		;Just display following characters if NE
	   movd r0,tos
	   save [r1]
	   movqb 0,r4		;Look for anything
	   bsr	win_srch	;Look for item beginning
	   restore [r1]
	   if	fc		;Don't display VCW command if found
	    addqd 2,r0
	   endif
	   movd	r0,r4		;Actual remaining count
	   negd r0,r0
	   addd tos,r0		;Number of characters to display
	   bsr	win_outp	;R1 advanced
	   movd	r4,r0		;Remaining characters
	  else
	   addqw 1,domn_max	;One more item
	   tbitb dc_mndsp,domn_r5 ;See if display is requested
	   if	fs
	    save [r0,r1]
	    bsr	domensub	;Process VCW command
	    restore [r0,r1]
	   endif
	   addqd 2,r1
	   addqd -2,r0
	   bsr	end_item
	  endif
	 endw
	 
;Ready for actual input routine now

	 tbitb	dc_mnexe,domn_r5 ;See if execution requested
	 if	fs
	  until	fs
	   movd	domn_ptr(r2),r1 ;Data pointer
	   movd	domn_len(r2),r0	;Length of data
	   addqd 2,r1
	   addqd -2-4,r0	;Don't include menu end
	   bsr	end_item	;Skip to end of MENB data
	   movqd 0,r3		;Item index
	   begin
	    movqd 0,r4		;Find any VCW_ item
	    bsr	win_srch
	    cmpw domn_cnt(r2),r3 ;See if this is the current entry
	   while ne
	    cmpb vcw_mcst,-1(r1) ;Check for comma separated strings
	    if	ne
	     bsr end_item	;Skip this item
	     addqd 1,r3
	    else
	     movd r3,r4
	     movzbd (r1),r3	;Number of MINP strings
	     addd r4,r3		;Item after MCST
	     addqd -1,r3	;Last MCST item
	     cmpw domn_cnt(r2),r3 ;See if within this MCST block
	    orif hi
	     negd r4,r4	
	     addw domn_cnt(r2),r4 ;MINP offset
	     movb r4,(r1)
	    endif
	   endw
	   movw domn_cnt,(domn_dfl) ;New default
	   movw	-2(r1),tos	;Item type
	   bsr	menu_sb		;Return FS and registers set if exiting
	   movw	tos,r4		;Item type
	  endu
	  lshd	16,r4		;Item type to bits 16-31
	  movw	(domn_dfl),r4	;Current entry number to R4 bits 0-15
	  movw domn_cnt,(domn_dfl) ;Default for re-entry if MENU_SB changed
	 endif
	endif
	bsr	crsr_on
	adjspb	-4*7-2*2
	restore	[r1,r2,r3,r6]
	ret

;Do item in R0/R1
;R1 already advanced past code
;Return FS if exiting

menu_sb:
	save	[r0,r1,r4]
	movb	-1(r1),r4	;Character to search for
	addr	menustbx-1,r1	;Last character in table
	movzbd	menustbx-menustbl,r0
	skpsb	b,u		;FC if nothing found
	movd	r0,r5		;Index to R5
	restore	[r0,r1,r4]
menusb1:
	casew	menustbx[r5:w]
menustbl:
	db	vcw_mitb	;Beginning of menu item
	db	vcw_minp	;Menu string input
	db	vcw_mcst	;Comma separated strings
menustbx:
	dw	retrn-menusb1
	dw	menumitb-menusb1
	dw	menuminp-menusb1
	dw	menumcst-menusb1

;Menu item beginning

menumitb:
	save	[r2,r3,r4]
	movb	4(r1),tos	;Hilite byte
	sbitb	7,4(r1)
	if	fs		;Also hilite if FS
	 ibitb	vca_rev,4(r1)	;Toggle reverse bit
	else
	 movb	h'80+exp vca_rev,4(r1) ;Just reverse if not hilited
	endif
	save	[r0,r1]
	bsr	mitb_vc1	;Display reversed
	restore	[r0,r1]
	movb	tos,4(r1)	;Hilite byte

	save	[r0,r1,r6,r7]
	addd	3 lsh b_iosrv,r6 ;Offset to input device
	movb	dof_blk,r6
	movd	domn_r1(r2),r1	;R1 must be valid pointer
	movd	domn_ptr(r2),r5	;Pointer to start of menu code
	movd	6-2(r5),r0	;Default XLAT status to bits 16-31
	andd	exp bkb_esc+exp bkb_ret+exp bkb_spc+exp bkb_cnv,r0
	ord	exp bkb_swn+exp bkb_cnt+1,r0
	bsr	svc_bsr
	movd	r0,r3
	restore	[r0,r1,r6,r7]
	cmpqb	0,r3		;See if a character entered

	if	eq		;No character entry if EQ
	 cmpw	vc_win*256,r5	;Check for window command
	 if	hi		;Not window command if HI
	  cmpb	" ",r5
	  if	eq
	   ibitb 7,4(r1)	;Invert hilite flag
	   bispsrb flag_f	;Always exit if tagging
	  else
	   cmpb	cr,r5
	   if	eq
	    save [r0,r1,r2]
	    movzbd 5(r1),r0	;Length of input
	    movd r0,r3
	    addr 6(r1),r1	;Input code
	    movd domn_r1(r2),r2	;Target for move
	    movsb		;R0 is 0
	    restore [r0,r1,r2]
	    bispsrb flag_f
	   else
	    cmpb esc,r5
	    if	eq
	     bispsrb flag_f	
	    else
	     bicpsrb flag_f
	    endif
	   endif
	  endif
	  sfsb	r4
	  bsr	mitb_vc1	;Redisplay as appropriate
	  movd	r3,r0		;Returned length
	  tbitb	0,r4		;Restore F
	 else			;Window command
	  bsr	win_vcw		;Process VCW_ commands
	  sfsb	r4		;Save flag status
	  bsr	mitb_vc1	;Redisplay as appropriate
	  movqd	0,r0
	  tbitb	0,r4		;Reset F
	 endif
	else
	 bsr	mitb_vc1	;Display this entry normally
	 movd	domn_ptr(r2),r1
	 movd	domn_len(r2),r0
	 addqd	-2,r0
	 addqd	2,r1		;Skip menu beginning
	 bsr	end_item
	 movqd	0,r3		;Item counter
	 begin
	  movqd	0,r4
	  bsr	win_srch
	 quit	fs
	  cmpb	vcw_mitb,-1(r1)	;Check for item beginning
	  if	eq
	   cmpqb 1,5(r1)	;Length must be at least 1
	   if	ls
	    cmpb r5,6(r1)	;See if code matches
	   endif
	  endif
	 while	ne
	  bsr	end_item
	  addqd	1,r3		;Try next item
	 qend
	  movqd	-1,r3		;Not found
	 endw
	 cmpqd	-1,r3
	 if	ne
	  ibitb	7,4(r1)		;Set hilite bit
	  bsr	mitb_vc1	;Hilite new selection
	  save	[r1,r2]
	  movzbd 5(r1),r0	;Length of input
	  addr	6(r1),r1	;Input code
	  movd	domn_r1(r2),r2	;Target for move
	  save	[r0]
	  movsb			;R0 is 0
	  restore [r0]
	  restore [r1,r2]
	  movw	r3,domn_cnt(r2)	;New current entry
	  movd	domn_dfl(r2),r4	;Pointer to default storage
	  movw	r3,(r4)		;This is new default
	  bispsrb flag_f	;Exit with valid selection
	 else
	  bicpsrb flag_f	;Invalid selection, don't exit yet
	 endif
	endif
	restore	[r2,r3,r4]
	ret

;String input item

menuminp:
	save	[r2,r3,r4]

	save	[r0,r1,r6]
	bsr	win_crsr	;Position cursor according to (R1)
	bsr	win_outs
	db	vc_sat,exp vca_rev,0 ;Enable reverse video
	bsr	crsr_on
	movzbd	11(r1),r5	;Total input length
	begin	
	 cmpqb	0,r5
	while	ne		;Fill remaining space with " "
	 save	[r3,r5,r6,r7]
	 movb	" ",r5
	 bsr	svc_bsr
	 restore [r3,r5,r6,r7]
	 addqb	-1,r5
	endw
	bsr	win_crsr	;Position cursor according to (R1)

	addd	3 lsh b_iosrv,r6 ;Offset to input device
	movb	dof_blk,r6
	movzwd	4-2(r1),r0	;R0 for input (bits 16-31)
	movd	6(r1),r5	;Termination character
	movzbw	11(r1),r0	;Maximum input length
	addd	12,r1		;Input buffer
	movzbd	-2(r1),r3	;Default input length
	save	[r0,r1,r2]
	movd	domn_r1(r2),r2	;Original R1
	movd	r3,r0		;Default input length
	movsb			;Copy input to R1 buffer in case aborted
	restore	[r0,r1,r2]

	save	[r2,r7]
	movd	r1,tos
	movd	domn_r1(r2),r1	;Use this as input buffer
	tbitb	bkb_dft,r0	;Check for default string
	if	fc
	 save	[r3]
	 bsr	svc_bsr		;No default type of FC
	 restor [r3]
	else
;	 movb	8,tos		;String data type
;	 movw	r3,tos		;Default length
;	 cbitb	b_ior7,r6	;SVC provides R7
;	 cbitb	b_iodat,r6	;No other data block
;	 mac_2svc		;Must use SVC routine here
;	 adjspb -3
	endif

	movd	r0,r3		;Original R0
	movd	tos,r2		;Default storage
	movsb			;Copy input to R1 buffer
	restore	[r2,r7]
	restore	[r0,r1,r6]
	bsr	win_outs
	db	vc_cat,exp vca_rev,0 ;Disable reverse video
	bsr	crsr_off
	cmpqb	0,r3
	if	ne
	 movb	r3,10(r1)	;New default length
	endif
	bsr	minp_vc1	;Display now in normal video

	cmpw	vc_win*256,r5	;Check for window command
	if	ls		;Not window command if HI
	 bsr	win_vcw		;Adjust current index for re-entry
	endif
	movd	r3,r0		;Restore returned R0
	bispsrb flag_f		;Always exit after string input
	restore	[r2,r3,r4]
	ret

;Process VCW_ command in R5

win_vcw:
	cmpb	h'80+vcw_chr+vcw_mov+vcw_lft,r5
	if	eq
	 cmpqw	0,domn_cnt(r2)
	 if	lo
	  addqw -1,domn_cnt(r2) ;Backup
	  bicpsrb flag_f
	 else
	  bispsrb flag_f	;Out of range, let program handle it
	 endif
	else
	 cmpb	h'80+vcw_chr+vcw_mov+vcw_up,r5
	orif	eq
	 cmpb	h'80+vcw_chr+vcw_mov+vcw_rt,r5
	 if	eq
	  cmpw	domn_cnt(r2),domn_max(r2)
	  if	lo
	   addqw 1,domn_cnt(r2) ;Advance
	   bicpsrb flag_f
	  else
	   bispsrb flag_f	;Out of range, exit
	  endif
	 else
	  cmpb	h'80+vcw_chr+vcw_mov+vcw_dn,r5
	 orif	eq
	  movqd	0,r0
	  bispsrb flag_f	;Return anything else
	 endif
	endif
	ret


domensub:
	addqd	2,r1
	addqd	-2,r0		;Advance past VCW code
	save	[r0,r1,r4]
	movb	-1(r1),r4	;Character to search for
	addr	domentbx-1,r1	;Last character in table
	movzbd	domentbx-domentbl,r0
	skpsb	b,u
	movd	r0,r5		;Index to R5
	restore	[r0,r1,r4]
domens1:
	casew	domentbx[r5:w]
domentbl:
	db	vcw_mitb	;Beginning of menu item
	db	vcw_minp	;Menu string input
	db	vcw_mcst	;Comma separated string
domentbx:
	dw	retrn-domens1
	dw	mitb_vcw-domens1
	dw	minp_vcw-domens1
	dw	mcst_vcw-domens1

;Display menu item
;R6 must be valid

mitb_vcw:
	save	[r3]
	movd	domn_dat(r2),r3
	movw	dat_col(r3),(r1) ;Cursor column
	movw	dat_line(r3),2(r1) ;Cursor row
	restore	[r3]

;Enter here to just display entry

mitb_vc1:
	save	[r5]
	bsr	win_crsr	;Position cursor according to (R1)
	movzbd	4(r1),r5	;Hilite attribute
	lshw	8,r5
	save	[r5]
	movb	vc_sat,r5
	tbitb	15,r5		;Hilite if set
	if	fs
	 bsr	win_outr5
	endif
	movzbd	5(r1),r5	;Select code length
	addd	6+9,r5		;Cursor, storage, hilite, length, data
	addd	r5,r1
	subd	r5,r0		;Ready for item text now
	movd	r0,tos
	save	[r1,r4]
	movb	vcw_mite,r4	;Item end
	bsr	win_srch	;Find length of this item
	restore	[r1,r4]
	movd	r0,r5		;Remaining length
	negd	r0,r0
	addd	tos,r0		;Number of characters
	addqd	-2,r0		;Item end code doesn't count
	movd	r5,tos		;Save remaining count
	bsr	win_outp	;Display menu item text
	addqd	2,r1		;Skip item end
	movd	tos,r0		;Restore R0
	restore	[r5]
	movb	vc_cat,r5
	tbitb	15,r5		;Hilite if set
	if	fs
	 bsr	win_outr5	;Clear attributes now
	endif
	restore	[r5]
	ret
	 
;Display string input default line

minp_vcw:
	save	[r3]
	movd	domn_dat(r2),r3
	movw	dat_col(r3),(r1) ;Cursor column
	movw	dat_line(r3),2(r1) ;Store row too
	restore	[r3]
minp_vc1:
	save	[r5]
	bsr	win_crsr	;Position cursor according to (R1)
	addd	12,r1		;Skip cursor, R0, R5, lengths
	addd	-12,r0
	save	[r0,r1]
	movzbd	-2(r1),r0	;Actual entered text length
	bsr	win_outp	;Display menu item text
	restore	[r0,r1]
	movzbd	-1(r1),r5	;Total reserved space
	subb	-2(r1),r5	;Remaining unused space
	begin	
	 cmpqb	0,r5
	while	ne		;Fill remaining space with " "
	 save	[r3,r5,r6,r7]
	 movb	" ",r5
	 bsr	svc_bsr
	 restore [r3,r5,r6,r7]
	 addqb	-1,r5
	endw
	movzbd	-1(r1),r5	;Total reserved space
	addd	r5,r1
	subd	r5,r0
	restore	[r5]
	ret

;R0/R1 must point to valid item+2, advance to last byte+1

end_item:
	save	[r5]
	cmpb	vcw_menb,-1(r1)
	if	eq
	 movqd	4+2,r5		;Cursor position, R0 high bits
	else
	 cmpb vcw_mitb,-1(r1)
	 if	eq
	  movzbd 5(r1),r5	;Length of select code
	  addd	6+9,r5		;Cursor, status, hilite, select length, data
	  addd	r5,r1
	  subd	r5,r0		;Advance to actual text
	  save	[r4]
	  movb	vcw_mite,r4
	  bsr	win_srch
	  restore [r4]
	  movqd	0,r5		;Registers set if FC
	  if	fs
	   movqd -1,r5		;Force error
	  endif
	 else
	  cmpb vcw_minp,-1(r1)
	  if	eq
	   movzbd 11(r1),r5
	   addw 12,r5
	  else
	   cmpb vcw_mene,-1(r1)
	   if	eq
	    movqd 2,r5
	   else
	    cmpb vcw_mcst,-1(r1)
	    if	eq
	     addqd 2,r1
	     addqd -2,r0	;Skip this code
	     movb -1(r1),r5	;Number of MINP strings
	     begin
	      cmpqb 0,r5
	     while eq
	      save [r4,r5]
	      movb vcw_minp,r4
	      bsr win_srch
	      bsr end_item
	      restore [r4,r5]
	      addqb -1,r5
	     endw
	     movqd 0,r5
	    else
	     movqd -1,r5	;Force error if undefined
	    endif
	   endif
	  endif
	 endif
	endif
	addd	r5,r1
	subd	r5,r0
	bicpsrb	flag_f		;Assume success
	if	cs		;OK if positive
	 addd	r0,r1		;Set to end of sequence
	 movqd	0,r0
	 bispsrb flag_f
	endif
	restore	[r5]
	ret


;Position window cursor to colomn/row in (R1)

win_crsr:
	movb	2(r1),tos	;Cursor row
	movb	(r1),tos	;Cursor column
	movb	vcs_cur,tos	;Position cursor
	movb	vc_scr,tos
	save	[r0,r1]
	addr	8(sp),r1
	movqd	4,r0
	bsr	win_outp
	restore [r0,r1]
	adjspb	-4
	ret


;Search for window command in R4
;If R4=0 then return any window command
;R1 holds address, R0 holds search length
;FS if not found
;On return R1 => character after match if found

win_srch:
	until	eq
	 cmpqd	0,r0
	quit	ge		;Count must be > 0
	 cmpb	vc_win,(r1)
	 if	eq
	  addqd 1,r1
	  addqd -1,r0		;At least 1 character left
	  cmpqd 1,r0
	  if	ls		;NE if HI
	   addqd 1,r1
	   addqd -1,r0
	   cmpqb 0,r4
	   if	ne
	    cmpb r4,-1(r1)
	   endif
	  endif
	 else
	  bsr	vstr_nxt	;Get next video string character
	  bicpsrb flag_z	;Make NE
	 endif
	qend
	 addd	r0,r1		;Backup R1 in case R0 is negative
	 movqd	0,r0
	 bispsrb flag_f		;Error
	endu
	ret

;R0/R1 must point to valid item+2, advance to next item+2
;FS on exit if error

nxt_item:
	bsr	end_item	;Find end of current item
	movqd	0,r4		;Find any VCW_ command
	br	win_srch

	cend


;***************************
;* SMT SmartWatch routines *
;***************************

{
Control lines:
  a0 is serial data write line
  a2 high for read, low for write
  d0 is serial data read line
  a14 resets chip if low and bit 36 in data registers is low

Data registers (BCD encoded):
  bits 0-7: 1/100 seconds [0-99]
  bits 8-15: seconds [0-59]
  bits 16-23: minutes [0-59]
  bits 24-31: hours [0-23, 1-12] (bit 7 high = 12 hour format, bit 5 set = pm)
  bits 32-39: day [1-7] (Bit 5 high disables reset, bit 6 high disables clock)
  bits 40-47: date [1-31]
  bits 48-55: month [1-12]
  bits 56-63: year [0-99]
  
a1 of CPU connects to a0 of SmartWatch/EPROM,
  shift all addresses left for access
}

	disp	1

;--------------------------
; Enable SmartWatch chip
; Return cfg register in r3
;--------------------------

smt_enable:
	save	[r0,r1,r2]

	addr	m_watch,r1
	cmpqb	0,exp (2+1)(r1)	;Access chip with a2 high to reset comparator
	cond	cpu532
	 sprd	cfg,r3
	 movd	r3,r0
	 sbitb	cfg_ldc,r0
	 lprd	cfg,r0		;Lock data cache
	 cinv	d,r1		;Invalidate watch address to force reads
	cend

	movb	64,r0		;Number bits in access code
	movd	h'5ca33ac5,r2	;Enable code, written twice
	until	eq		;Write access code
	 inssb	r2,r1,1,1	;Bit 0 of r2 to bit 1 of r1
	 cmpqb	0,(r1)		;Write current bit of access code
	 rotd	-1,r2
	 addqb	-1,r0
	 cmpqb	0,r0
	endu

	restore	[r0,r1,r2]
	ret


;----------------------------
; Time/date conversion table:
;   offset in BCD table:b
;   shift factor for read:b
;   shift factor for writes:b
;   bit mask for writes:b
;----------------------------

td_ofs:
	db	1, -1, 1, h'3f		;Seconds
	db	2, 5, -5, h'3f		;Minutes
	db	3, 5+6, -5-6, h'1f	;Hours
	db	5, 5+6+5, -5-6-5, h'1f	;Date
	db	6, 5+6+5+5, -5-6-5-5, h'f ;Month
	db	7, 5+6+5+5+4, -5-6-5-5-4, h'7f ;Year


;------------------------------
; Read SmartWatch, return in r4
;------------------------------

smt_read:
	save	[r0,r1,r2,r3,r5]

	bsr	smt_enable	;Enable chip, lock data cache
	movqd	0,r0		;Bit index
	addr	m_watch+exp (2+1),r1 ;a2 high for reads
	movb	64,r2		;Upper limit of index
	adjspb	8		;Write buffer for clock data

	until	eq		;Read serial bit stream
	 insb	r0,(r1),tos,1
	 addqb	1,r0
	 cmpb	r0,r2
	endu

;Convert tos buffer BCD data to r4 date/time

	movqd	0,r4		;Initialize r4
	movqd	5,r0		;Data index
	until	gt
	 movzbd	td_ofs[r0:d],r5	;Index to BCD buffer
	 extsd	tos[r5:b],r1,0,4 ;BCD 1s
	 extsb	tos[r5:b],r2,4,4 ;BCD 10s
	 mulb	10,r2
	 addb	r2,r1		;Binary units
	 movxbd	td_ofs+1[r0:d],r5 ;Shift factor for reads
	 lshd	r5,r1
	 ord	r1,r4		;Merge into r4
	 addqb	-1,r0
	 cmpqb	0,r0
	endu

	adjspb	-8		;Drop stack frame
	cond	cpu532
	 lprd	cfg,r3		;Restore original
	cend
	movqd	0,r6		;Success
	restore	[r0,r1,r2,r3,r5]
	ret


;---------------------------
; Set SmartWatch, data in r4
;---------------------------

smt_write:
	save	[r0,r1,r2,r3,r5]

	bsr	smt_enable	;Enable chip, lock data cache
	movqd	0,tos
	movqd	0,tos		;Build BCD data here

;Convert r4 date/time to BCD format in tos buffer

	movqd	5,r0		;Data index
	until	gt
	 movxbd	td_ofs+2[r0:d],r5 ;Shift factor for writes
	 movd	r4,r1
	 lshd	r5,r1		;Shift to proper position
	 movb	td_ofs+3[r0:d],r5 ;Mask for data
	 andb	r5,r1		;Extracted data in r1
	 movb	r1,r2
	 divb	10,r2		;BCD 10s
	 modb	10,r1		;BCD 1s
	 movzbd	td_ofs[r0:d],r5	;Tos buffer index
	 movb	r1,tos[r5:b]
	 inssb	r2,tos[r5:b],4,4
	 addqb	-1,r0
	 cmpqb	0,r0
	endu

	movqd	0,r0		;Bit index
	addr	m_watch,r1 	;a2 low for writes
	movb	64,r2		;Upper limit of bit index
	until	eq		;Write new data
	 extb	r0,tos,r1,1
	 addb	r1,r1		;Data to bit 1 position
	 cmpqb	0,(r1)		;Write current bit of access code
	 addqb	1,r0
	 cmpb	r0,r2
	endu

	adjspb	-8		;Drop tos buffer
	cond	cpu532
	 lprd	cfg,r3		;Restore original
	cend
	movqd	0,r6		;Success
	restore	[r0,r1,r2,r3,r5]
	ret


;******************
;* Timer routines *
;******************

;------------------------------------------------
; R4 holds requested time delay in 40ms intervals
; Return pointer to count:w in r5
;------------------------------------------------

opo_timer:
	save	[r0]
	movb	m_clkcnt,r0	;Max count
	movd	m_clkadr,r5
	movqd	-1,r6		;Assume none available
	until	eq
	 sbitb	btim_use,tim_stat(r5)
	quit	fc		;Got a keeper
	 addd	tim_last,r5
	 addqb	-1,r0
	 cmpqb	0,r0
	qend
	 cbitb	btim_adr,tim_stat(r5) ;Invalidate address just in case
	 movw	r4,tim_rld(r5)	;Reload value
	 movw	r4,tim_cnt(r5)	;Now enable counter
	 movqd	0,r6
	endu
	restore [r0]
	ret


;--------------------------------
; Release timer, r4 holds pointer
;--------------------------------

opo_clrclk:
	save	[r0,r1,r2]
	movqd	-1,r6		;Assume error
	movd	r4,r0
	subd	m_clkadr,r0	;Base address
	movd	r0,r1
	modd	tim_last,r1
	cmpqd	0,r1
	if	eq		;Error if ne
	 divd	tim_last,r0
	 movzbd	m_clkcnt,r2
	 cmpd	r0,r2
	 if	lo		;Valid pointer if lo
	  movqw	0,tim_rld(r4)
	  movqw	0,tim_cnt(r4)
	  movqb	0,tim_stat(r4)	;Everything off
	  movqd	0,r6		;OK
	 endif
	endif
	restore	[r0,r1,r2]
	ret


;-------------------------------------
; 40ms clock interrupt service routine
;-------------------------------------

clok_int:
	bispsrw	flag_i		;Interrupts enabled here
	save	[r0,r1,r2,r3]
	movb	m_clkcnt,r0	;Number of table entries
	movd	m_clkadr,r1	;Data address
	movzbd	tim_last,r3	;Increment value for r1
	until	eq
	 movw	tim_cnt(r1),r2
	 cmpqw	0,r2
	 if	ne		;Don't decrement below 0
	  addqw	-1,r2
	  movw	r2,tim_cnt(r1)
	  cmpqw	0,r2
	  if	eq		;Count decremented to 0 if eq
	   movw	tim_rld(r1),tim_cnt(r1)	;Reset counter
	   tbitb btim_adr,tim_stat(r1)
	   if	fs		;Valid service routine if fs
	    movd tim_adr(r1),r2
	    jsr	r2
	   endif
	  endif
	 endif
	 addd	r3,r1
	 addqb	-1,r0
	 cmpqb	0,r0
	endu
	restore	[r0,r1,r2,r3]
	reti

;End of System.asm
