	print	"SVC32"

{
To do:

dat_next routine needs overflow check, abort if so
}

svc32	module
	disp	1

;-------------------------------------
; Operating system supervisor routines
;-------------------------------------

	mode	sb

m_config: blkd			;CFG register stored here
typ_fpu: blkd			;FPU type (0 if none)
svc_sp:	blkd			;Base address of system stack pointer

tde_vct: blkd			;Pointer to trap data area
tde_indx: blkb			;Index of last trap taken
	mode	imm,0		;Trap data allocation built on heap
tde_jsr: ds	2+4		;JSR @:D
tde_base:			;Base address of data after JSR
tde_dpc: blkd			;Service routine PC for DE mode
tde_dmd: blkw			;Service routine MOD for DE mode
tde_dps: blkw			;Service routine PSR for DE mode
tde_psb: blkd			;Pointer to trapped SB storage for DE mode
tde_ssb: blkd			;Default storage for trapped SB for DE mode
tde_pc:	blkd			;Target PC
tde_mod: blkw			;Target MOD
tde_psr: blkw			;Target PSR
tde_max:
	mode	sb

m_clkcnt: blkb			;Max number of timers
m_clkadr: blkd			;Pointer to clock service data

debug_pc: blkd			;Debugger's entry PC, -1 if none
debug_mod: blkd			;Debugger's entry MOD:D for use as pointer
debug_psr: blkw			;Debugger's entry PSR


muse_app: blkb			;Application operation in progress if not 0
map_max: blkd			;Maximum number of applications
app_ptr: blkd			;Pointer to application specific data:
				;  one handle for each possible application
				;  Handle returned by NEWBF_SB
				;  -1 = undefined (none)
svc_app: blkd			;Pointer to application specific storage
svcapp_ptr set	0		;Label counter for svc_app section
	mode	imm,svcapp_ptr	;Put into svc_app section
app_dvpt: blkd			;Dev_ptr
app_num: blkb			;Current application number
svc_ssz	equ	64		;Size of stack	
	ds	svc_ssz		;Stack extends downward
stak_svc: blkd			;Parameter stack pointer
	cond	op_sys
app_call: blkb			;Calling application number, -1 if none
app_isp: blkd
app_usp: blkd
app_fp:	 blkd
app_reg: blkd	8
	cend
svcapp_ptr set	$
	mode	sb

mdev_max: blkw			;Max device count
dev_ptr: blkd			;Pointer to device table
tbuf_adr: blkd			;Address of bottom of heap
	cond	not op_sys
svc_lpt: blkd			;Pointer to device link table base
win_base: blkd			;Window data blocks
	cend

	cond	op_sys
muse_buf: blkb			;Buffer operation in progress if not 0
tbuf_siz: blkd			;Total size of heap
tbuf_ptr: blkd			;Address of buffer pointers
tbuf_svc: blkd			;Address of end of SVC mode buffers

muse_mod: blkb			;Mod operation if not 0
mod_base: blkd			;Base address of MOD tables
				;  2 byte address of next MOD block
				;  1 byte application number
				;  1 byte number of consecutive MOD tables
				;  N*16 bytes of MOD data (SB/LINK,PC/0)
mod_last: blkd			;Highest usable address+1 for MODs
	cend

	mode	pc
	align	4

svc_last::
	dd	to_debug-svc	;Size of svc code
svc_init::
	dd	dev_init-svc	;Address of master initialization

;SVC must be next PC relative code


;Process code in R5, offset in R6
;R4 holds extra parameters if fewer than 5 bytes or
;  pointer to parameters if more than 4 bytes
;R3 is a scratch register

svc::
	cond	svc_cxp
	 addqd	1,tos		;Increment RET address past SVC opcode
	cend
	enter	[r3,r6,r7],0

svc_r3:	equ	-4:(fp)		;Original r3
svc_r6:	equ	-8:(fp)		;Original r6
svc_r7:	equ	-12:(fp)	;Original r7

	bsr	dosvc
	movd	svc_r3,r3
	movd	svc_r7,r7	;Only restore these
	exit	[]		;Don't restore r6

svc_xit:
	cond	svc_cxp
	 cond	cpu532
	  lprw	mod,4(sp)	;Restore MOD, garbage if not DE mode
	  lprd	sb,5*tde_max+tde_ssb(tde_vct) ;Restore SB
	 cend
	 rett
	celse
	 rxp
	cend


;------------------------------
; Do actual SVC service routine
; R3 is altered
;------------------------------

dosvc:
	movzbd	r6,r3		;Device index
	cmpb	mdev_max,r3	;Check for legal device
	if	ls
	 movd	exp bstat_il,r6	;Illegal command or device
	disp	2
	else
	disp	1
	 tbitb	b_ionam,r6
	 if	fc		;R7 already loaded if fs
	  movd	(dev_ptr)[r3:d],r7 ;Base pointer to R7
	 endif
	 lshw	-b_iosrv,r6
	 movzbd	r6,r6
	 cmpqb	dof_cmd,r6	;Must be at least this
	orif	hi
	 cmpb	4*dof_id+dofid_max(r7),r6 ;Must be in range
	orif	ls
	 movd	4*dof_bdat(r7),r3
	 sbitb	bsm_bsy,dat_smoc(r3)
	 if	fc
	  movb	app_num(svc_app),dat_smoc+2(r3) ;Lock device, app. #
	  movd	r7[r6:d],r3	;Address of service routine
	  jsr	r3
	  movd	4*dof_bdat(r7),r3
	  tbitb	bsm_lok,dat_smoc(r3)
	  if	fc
	   tbitb bsm_cmd,dat_smoc(r3)
	   if	fc
	    cbitb bsm_bsy,dat_smoc(r3)
	   endif
	  endif
	 else
	  cmpb	app_num(svc_app),dat_smoc+2(r3)
	 orif	eq		;OK if same application
	  tbitb	b_iodev,svc_r6	;Clear if output, set if input
	  if	fs		;Input if fs
	   tbitb bsm_rok,dat_smoc(r3)
	  else
	   tbitb bsm_wok,dat_smoc(r3)
	  endif
	 orif	fs
	  tbitb bsm_lok,dat_smoc(r3)
	  if	fc		;Quit now if locked
	   until fc		;Wait until all clear
	    sbitb bsm_bsy,dat_smoc(r3)
	   endu
	  endif
	 disp	2
	 orif	fc		;OK to proceed if eq
	 disp	1
	  movzbd bstat_iu,r6	;In use, can't do it yet
	 endif
	endif
	ret


;----------------------------------------------
; Call another device
; Registers must be set
; svc_r6 saved and loaded with new device index
;----------------------------------------------

bsr_svc:
	save	[r3,r7]
	movw	svc_r6,tos
	movw	r6,svc_r6	;Temporary new value
	bsr	dosvc
	movw	tos,svc_r6
	restore	[r3,r7]
	ret


;--------------------------
; Registers set for command
; Use current device
;--------------------------

do_cmd:
	movd	r3,tos
	movd	4*dof_cmd(r7),r3
	jsr	r3
	movd	tos,r3
	ret


;----------------------------------
; Default interrupt service routine
;----------------------------------

int_srv:
	reti


;------------------------------
; DE mode routine
; Save MOD, SB, load new values
; (SP) holds data pointer
;------------------------------

	cond	cpu532
to_traps:			;Pre-processing for DE mode traps
	 sprw	mod,4+4(sp)	;Save calling routine's MOD
	 movd	tde_psb-tde_base((sp)),tos ;Pointer to SB storage
	 sprd	sb,((sp))
	 lprw	mod,tde_dmd-tde_base(4(sp)) ;Service routine's MOD
	 sprd	mod,(sp)
	 lprd	sb,((sp))	;Service routine's SB
	 movd	tde_dpc-tde_base(4(sp)),(sp) ;Target address
	 movd	tde_dmd-tde_base(4(sp)),4(sp) ;MOD and PSR MSB
	 sprb	psr,4+2(sp)	;PSR LSB retained
	 rett
	cend

trp_msg:
	db	" trap at address ",0

;Display message in (sp) and continue with trap routine

traps:
	save	[all]
	movd	4*8(sp),r1	;Pointer to message
	movd	4*8+4(sp),r2	;Return address
	enter	[r3,r6,r7],0	;Need valid storage for bsr_svc

	movzbd	dev_smv,r0
	until	gt
	 movd	(dev_ptr)[r0:d],r7
	 movd	4*dof_bdat(r7),r3
	 movqd	0,dat_smoc(r3)	;Clear this
	 addqb	1,r0
	 cmpb	r0,dev_sek+1
	endu

	movb	(r1),tde_indx
	addqd	1,r1		;Advance to message
	movd	exp bkb_tr5,r0	;R5 holds termination
	movqd	0,r5		;Terminate on 0
	movd	dev_sev+dof_blk lsh b_iosrv,r6
	bsr	bsr_svc		;Display message

	addr	trp_msg,r1	;Pointer to message
	movd	exp bkb_tr5,r0	;R5 holds termination
	movqd	0,r5		;Terminate on 0
	movd	dev_sev+dof_blk lsh b_iosrv,r6
	bsr	bsr_svc		;Prepare for address display

	movb	8,r0		;Digit counter
	until	eq
	 rotd	4,r2		;MSDigit to LSDigit
	 movzbd	r2,r5		;Current digit
	 andb	h'f,r5
	 addb	"0",r5
	 cmpb	"9",r5		;Must be valid ASCII
	 if	lo
	  addqb	'A'-('9'+1),r5	;A-F
	 endif
	 movd	dev_sev+dof_chr lsh b_iosrv,r6
	 save	[r0,r2]
	 bsr	bsr_svc
	 restore [r0,r2]
	 addqb	-1,r0
	 cmpqb	0,r0
	endu
	movd	dev_sev+dof_chr lsh b_iosrv,r6
	movzbd	cr,r5
	bsr	bsr_svc
	movd	dev_sev+dof_chr lsh b_iosrv,r6
	movzbd	lf,r5
	bsr	bsr_svc

	exit	[r3,r6,r7]
	restore	[all]
	adjspb	-4		;Drop pointer to message
	br	call_debug:w	;Jump to debugger

trp_nvi:
	bsr	traps
	db	0		;Index
	db	"Non-vectored interrupt", 0

trp_nmi:
	bsr	traps
	db	1		;Index
	db	"Non-maskable interrupt", 0

trp_abt:
	bsr	traps
	db	2		;Index
	db	"Abort", 0

trp_fpu:
	bsr	traps
	db	3		;Index
	db	$"FPU", 0

trp_ill:
	bsr	traps
	db	4		;Index
	db	"Illegal operation", 0

trp_svc:
	bsr	traps
	db	5		;Index
	db	$"SVC", 0

trp_dvz:
	bsr	traps
	db	6		;Index
	db	"Division by zero", 0

trp_flg:
	bsr	traps
	db	7		;Index
	db	$"Flag", 0

trp_bpt:
	bsr	traps
	db	8		;Index
	db	"Breakpoint", 0

trp_trc:
	bsr	traps
	db	9		;Index
	db	"Trace", 0

trp_und:
	bsr	traps
	db	10		;Index
	db	"Undefined operation", 0

trp_rbe:
	bsr	traps
	db	11		;Index
	db	"Restartable bus error", 0

trp_nbe:
	bsr	traps
	db	12		;Index
	db	"Non-restartable bus error", 0

trp_ovf:
	bsr	traps
	db	13		;Index
	db	"Integer overflow", 0

trp_dbg:
	bsr	traps
	db	14		;Index
	db	"Debug", 0

;Trap vector offsets

trp_vct:
	dw	trp_nvi-svc, trp_nmi-svc, trp_abt-svc
	dw	trp_fpu-svc, trp_ill-svc
	cond	svc_cxp
	 dw	svc-svc
	celse
	 dw	trp_svc-svc
	cend
	dw	trp_dvz-svc, trp_flg-svc, trp_bpt-svc
	dw	trp_trc-svc, trp_und-svc, trp_rbe-svc
	dw	trp_nbe-svc, trp_ovf-svc, trp_dbg-svc


;-------------------------------------------
;R4 holds requested permanant buffer size
;Return pointer in r5, -1 if not enough room
;Storage filled with 0s
;Base address always on Dword boundary
;Eq true if r5 = -1
;-------------------------------------------

get_buf:
	save	[r0,r1,r2]
	addr	3(r4),r0
	bicb	3,r0		;Round up to Dword boundary
	sprd	sb,r2
	addd	-4(sb),r2	;Last address + 1
	addr	(tbuf_adr)[r0:b],r1 ;Requested top of heap+1
	cmpd	r1,r2
	if	ls		;Still room if ls
	 movd	tbuf_adr,r5
	 movd	r1,tbuf_adr	;New end of heap
	 movd	r5,r1
	 addr	1(r1),r2
	 movqb	0,(r1)
	 addqd	-1,r0		;First byte already filled
	 movsb			;Fill with 0s
	else
	 movqd	-1,r5		;No room at all
	endif
	cmpqd	-1,r5		;Status
	restore	[r0,r1,r2]
	ret


;----------------------------------------------------
;R2 holds requested buffer size, return pointer in r2
;R2 = -1 and eq true if not enough room
;----------------------------------------------------

pd_getbf:
	save	[r4,r5]
	movd	r2,r4		;Requested size
	bsr	get_buf
	movd	r5,r2		;Returned pointer
	restore	[r4,r5]
	ret

	disp	2

;---------------------------
;Initialize device
;R1 => data, r0 holds offset
;R1 updated on exit
;R6 = 0 if OK
;---------------------------

pd_init:
	save	[r2,r3,r4,r5,r7]
	movd	r0,tos		;Offset at 0(sp)
	movzbd	(r1),r3		;Allocated device
	addqd	1,r1
	movzwd	mdev_max,r4	;Next device to install
	cmpw	r4,r3		;See if already allocated
	if	hi		;Predefined device if hi
	 movd	(dev_ptr)[r3:d],(dev_ptr)[r4:d] ;Copy previous pointer
	else			;New device
	 movzbd	(r1),r3		;Parent device
	 addqd	1,r1
	 cmpb	r3,r4
	 if	hi
	  movb	r4,r3		;Can't have forward referenced parent, use self
	 endif
	 ;
	 movzbd	(r1),r2
	 lshd	2,r2		;Required space for devices
	 addd	name_siz,r2	;Space for name too
	 bsr	pd_getbf
	quit	eq
	 movd	r2,r7		;Save pointer here
	 movd	r7,(dev_ptr)[r4:d] ;Pointer to physical device table
	 cmpb	r3,r4
	 if	lo		;Inherited data if lo
	  save	[r0,r1]
	  movd	(dev_ptr)[r3:d],r1 ;Source address
	  movzbd (r1),r0	;dof_max
	  movsd
	  restore [r0,r1]
	 endif
	 movzbd	(r1),4*dof_id+dofid_max(r7) ;dof_max
	 addqd	1,r1
	 movb	r4,4*dof_id+dofid_dev(r7) ;Device index
	 ;
	 movzbd	4*dof_id+dofid_max(r7),r2
	 addr	r7[r2:d],r2	;Address for name
	 save	[r4]
	 movqd	0,r4
	 movqd	-1,r0
	 movsb	u		;Copy device name
	 restore [r4]
	 addqd	1,r1		;Skip terminating 0
	 ;
	 movzwd	(r1),r2		;Size of data block
	 addqd	2,r1		;Advance past size of data block
	 cmpqw	0,r2
	 if	ne
	  bsr	pd_getbf
	  beq	pd_inix
	  movd	r2,4*dof_dat(r7)
	  movd	r2,4*dof_bdat(r7) ;First dat block is base
	  cmpb	r3,r4
	  if	lo		;Inheriting if lo
	   save	[r1,r2]
	   movd	(dev_ptr)[r3:d],r1 ;Parent device
	   movd	4*dof_dat(r1),r1 ;Parent data block
	   movzwd (r1),r0	;Size of block
	   movsb		;Copy parent block
	   restore [r1,r2]
	  endif
	  movw	-2(r1),(r2)	;Size of data block
	  addqd	2,r2
	  movzwd (r1),r0	;Number of bytes to move
	  addqd	2,r1
	  save	[r0]
	  movsb			;Copy initialization data into place
	  restore [r0]
	  movd	4*dof_dat(r7),r5 ;Pointer to data block
	  cmpd	dat_bpt+4-2,r0	;See if dat_bpt size moved
	  if	ls
	   movd	dat_bpt(r5),r2	;Original buffer size moved from (r1)
	   cmpqd 0,r2
	   if	ne
	    bsr	pd_getbf
	    beq	pd_inix
	    movd r2,dat_bpt(r5)
	   endif
	  endif
	  cmpd	dat_next+4-2,r0	;See if dat_next size moved
	  if	ls
	   movd	dat_next(r5),r2	;Original buffer size moved from (r1)
	   cmpqd 0,r2
	   if	ne
	    bsr	pd_getbf
	    beq	pd_inix
	    movw dat_next(r5),(r2) ;Store size of buffer
	    movd r2,dat_next(r5)
	   endif
	  endif
	 endif
	 ;
	 movzwd	(r1),r2		;Size of virtual data block
	 addqd	2,r1		;Advance past size of data block
	 cmpqw	0,r2
	 if	ne
	  bsr	pd_getbf
	  beq	pd_inix
	  movd	r2,4*dof_vdat(r7)
	  cmpb	r3,r4
	  if	lo		;Inheriting if lo
	   save	[r1,r2]
	   movd	(dev_ptr)[r3:d],r1 ;Parent device
	   movd	4*dof_vdat(r1),r1 ;Parent data block
	   movzwd (r1),r0	;Size of block
	   movsb		;Copy parent block
	   restore [r1,r2]
	  endif
	  movw	-2(r1),(r2)	;Size of data block
	  addqd	2,r2
	  movzwd (r1),r0	;Number of bytes to move
	  addqd	2,r1
	  movsb			;Copy initialization data into place
	 endif
	 ;
	 movqd	-1,4*dof_lnk(r7) ;Link pointer
	 ;
	 movd	(r1),4*dof_cdat(r7) ;Just store command count for new
	 addqd	4,r1
	 ;
	 movd	(r1),r5		;Command processor
	 addqd	4,r1
	 cmpqd	-1,r5
	 if	ne
	  addd	(sp),r5
	  movd	r5,4*dof_cmd(r7) ;Command processor in place
	 else
	  cmpb	r3,r4
	  if	eq		;Default processor if no parent
	   addr	svc_cmdrt,4*dof_cmd(r7)
	  endif
	 endif
	 ;
	 movzbd	4*dof_id+dofid_max(r7),r0 ;Dof_max
	 subb	dof_cmd+1,r0	;Number of vectors remaining
	 addr	4*(dof_cmd+1)(r7),r2
	 until	eq
	  movd	(r1),r5
	  addqd	4,r1
	  cmpqd	-1,r5
	  if	ne		;Use parent routine if eq
	   addd	(sp),r5
	   movd	r5,(r2)
	  endif
	  addqd	4,r2
	  addqb	-1,r0
	  cmpqb	0,r0
	 endu
	 ;
	 movd	(dev_ptr)[r3:d],r6 ;Parent r7 block
	 cmpqd	0,4*dof_cdat(r7) ;Command count
	 if	ne
	  movd	4*dof_cdat(r7),r2 ;Number of commands if no parent
	  cmpb	r3,r4
	  if	lo		;Parent if lo
	   save	[r1]
	   movd	4*dof_cdat(r7),r0 ;Number of new commands
	   movd	r1,r2		;New command pointer
	   movd	4*dof_cdat(r6),r1 ;Parent commands
	   addqd 2,r1		;First command
	   movd	r0,r5		;Number of commands different from parent
	   begin
	    cmpqb 0,r0
	   while ne
	    save [r0,r1,r4]
	    movzwd -2(r1),r0	;Table size
	    movd (r2),r4	;Search for this
	    skpsd u
	    restore [r0,r1,r4]
	    if	fs		;Got a match if fs
	     addqd -1,r5	;One less new command
	    endif
	    addqd 4,r2		;Advance pointer
	    addqd -1,r0
	   endw
	   restore [r1]		;R5 holds number of different new commands
	   movd	4*dof_cdat(r6),r2 ;Parent command table
	   movzwd (r2),r2	;Number of parent commands
	   addd	r5,r2		;Total different commands
	  endif
	  movd	r2,r0		;Save total command count
	  ;
	  lshd	3,r2		;8 bytes per command
	  addd	4+4,r2		;Command count:w and default routine
	  bsr	pd_getbf
	  beq	pd_inix
	  addqd	2,r2		;Commands on Dword boundary
	  movqw	0,(r2)		;In case no parent
	  addr	commandx,2(r2)[r0:d] ;Default command processor
	  cmpqd	0,4*dof_cdat(r7) ;Possible command processor if ne
	  if	ne
	   movd	4*dof_cdat(r7),r5 ;New command count
	   movd	r1[r5:d],r5	;Command processor
	   cmpqd -1,r5
	   if	ne
	    addd (sp),r5
	    movd r5,2(r2)[r0:d]
	   endif
	  endif
	  ;
	  cmpb	r3,r4
	  if	lo		;Parent if lo
	   save	[r0,r1,r2]
	   movd	r0,r5		;Total command count
	   movd	4*dof_cdat(r6),r1
	   movzwd (r1),r0
	   addqd 2,r1		;Point to first command
	   movw	r0,(r2)		;Command count
	   addqd 2,r2		;Commands go here
	   save	[r0]
	   movsd		;Move commands
	   restore [r0]
	   subd	r0,r5		;(total count)-(current count)
	   addr	r2[r5:d],r2	;Advance to service routine position
	   addqd 1,r0		;Default command processor too
	   movsd		;Move service routines
	   restore [r0,r1,r2]	;Parent commands copied
	  endif
	  ;
	  movd	(sp),r3		;Service routine offset
	  movd	r0,r5		;Total command count
	  movd	4*dof_cdat(r7),r0 ;New command count
	  movd	r2,4*dof_cdat(r7) ;Install command pointer
	  movd	r1,r2		;Source commands
	  movd	4*dof_cdat(r7),r1 ;Command table pointer
	  movd	r0,r6		;Save command count
	  begin
	   cmpqd 0,r0
	  while	ne
	   save	[r0,r1,r4,r7]
	   movd	(r2),r4		;Current command
	   movzwd (r1),r0
	   movd	r1,r7		;Save address of count
	   addqd 2,r1		;First command
	   skpsd u		;R1 => position for this command
	   if	fc		;No match if fc
	    addqw 1,(r7)	;One more entry
	   endif
	   movd	r4,(r1)
	   movd	4(r2)[r6:d],4(r1)[r5:d]
	   addd	r3,4(r1)[r5:d]	;Add offset
	   restore [r0,r1,r4,r7]
	   addqd 4,r2
	   addqd -1,r0
	  endw
	  addr	4(r2)[r6:d],r1	;Skip service routines
	 else
	  cmpb	r3,r4
	 orif	hs		;No parent if hs
	  movd	4*dof_cdat(r6),4*dof_cdat(r7) ;Use parent command pointer
	 endif
	 ;
	 movqd	0,r6		;Success
	qend
pd_inix:
	 movqd	-1,r6		;Error
	 addqw	-1,mdev_max	;Delete this device
	endif
	addqw	1,mdev_max	;One more device done
	movd	tos,r0
	restore	[r2,r3,r4,r5,r7]
	ret

	disp	1

;-----------------------------------------------------------------------------
; Initialize device blocks
; Must be called as subroutine for SP storage to work properly
; R1 holds address of initialization data, R0 holds offset of service routines
; r7 holds CFG register value
;-----------------------------------------------------------------------------

dev_init:
	addr	4(sp),svc_sp	;Base address of SP before call
	enter	[r3,r6,r7],0	;Need valid FP storage for bsr_svc

	movd	r7,m_config	;Save config setting here
	save	[r0,r1]		;Needed later

	cond	not debug
	 cbitb	cfg_i,m_config	;Assume no 32201 for now
	 disp	2
	 if	fs		;Don't install if not wanted
	 disp	1
	  movb	b'01000010,r5
	  movb	b'10001000,r6	;CFRZ, FRZ
	  movb	r5,16*bus_byts+icu_adr ;COUTD high, NTAR high
	  movb	16*bus_byts+icu_adr,r2
	  xorb	r6,16*bus_byts+icu_adr ;Toggle CFRZ, FRZ
	  movb	16*bus_byts+icu_adr,r3
	  xorb	r6,16*bus_byts+icu_adr ;Toggle CFRZ, FRZ
	  xorb	r6,r3
	  cmpb	r3,r5		;R2, r3, r5 equal if ICU is there
	  if	eq
	   cmpb	r2,r5
	  endif
	  disp	2
	  if	eq
	  disp	1
	   sbitb cfg_i,m_config	;Vectored interrupts if eq
	   ;
	   ;ICU initialization
	   ; 8 bit interface, fixed priority mode
	   ; All I/O lines are interrupt inputs, level triggered, active low
	   ; Counters initialized
	   ; Interrupt vector address set for 10h - 1fh, all interrupts disabled
	   ;
	   movb	b'01000010,16*bus_byts+icu_adr ;COUTD high, NTAR high
	   movqb -1,10*bus_byts+icu_adr ;IMSK MSB (all off)
	   movqb -1,11*bus_byts+icu_adr ;IMSK MSB (all off)
	   ;
	   movqb 0,22*bus_byts+icu_adr ;Clock off
	   movb	 b'00010001,23*bus_byts+icu_adr ;Clock interrupts off
	   movqb -1,20*bus_byts+icu_adr ;G0-G7 are interrupt inputs
	   movqb -1,21*bus_byts+icu_adr ;G0-G7 port direction is inputs
	   movqb 0,17*bus_byts+icu_adr ;No clock output
	   ;
	   movqb 0,8*bus_byts+icu_adr ;ISRV LSB
	   movqb 0,9*bus_byts+icu_adr ;ISRV MSB
	   movqb 0,12*bus_byts+icu_adr ;CSRC LSB
	   movqb 0,13*bus_byts+icu_adr ;CSRC MSB
	   movqb 0,14*bus_byts+icu_adr ;FPRT set to 0
	   ;
	   movqb 0,4*bus_byts+icu_adr ;TPL LSB
	   movqb 0,5*bus_byts+icu_adr ;TPL MSB
	   movqb -1,2*bus_byts+icu_adr ;ELTB LSB
	   movqb -1,3*bus_byts+icu_adr ;ELTG MSB
	   sbitb 3,16*bus_byts+icu_adr ;Freeze IPND
	   movqb -1,6*bus_byts+icu_adr ;Clear all IPND LSBs
	   movqb -1,7*bus_byts+icu_adr ;Clear all IPND MSBs
	   cbitb 3,16*bus_byts+icu_adr ;Unfreeze IPND
	   ;
	   movb	h'10,bus_byts+icu_adr ;Vectors 10-1F
	   movb	h'cd,18*bus_byts+icu_adr ;Count H interrupt=12, L=13
	   movb	(6000000/4/int_second) and h'ff,24*bus_byts+icu_adr ;Low byte
	   movb	(6000000/4/int_second) lsh -8,25*bus_byts+icu_adr ;High byte
	   movb	b'00001100,22*bus_byts+icu_adr ;Start counters
	   cbitb 6,16*bus_byts+icu_adr ;COUTD low now
	   ;
	  endif
	 endif
	cend

	movd	m_config,r4
	bsr	opo_setcfg:w	;Always set cfg register

	cond	not debug
	 cond	cpu032
	  cond	w_mmu		;Only if MMU supported
	   tbitb cfg_m,m_config	;Check for MMU
	   disp	2
	   if 	fs
	   disp	1
	    lmr	msr,h'400002	;Abort on error, everything else off
	    lmr	ptb0,0
	    lmr	ptb1,0
	    lmr	pf0,0
	    lmr	pf1,0
	    lmr	sc,0
	    lmr	bpr0,0
	    lmr	bpr1,0
;	    lmr bcnt,0
	    lmr	tear,0		;532 equivalent
	   endif
	  cend
	  ;
	  tbitb	cfg_f,m_config	;Check for FPU
	  disp	2
	  if	fs
	  disp	1
	   lfsr	0
	   movbl 0,f0
	   movl	f0,f2
	   movl	f0,f4
	   movl	f0,f6
	   movd h'32081,typ_fpu	;At least this
	   sfsr r5
	   tbitb 16,r5		;See if RMB is set
	   if	fs
	    movd h'32381,typ_fpu ;Must be 32381
	   endif
	   cmpd	h'32081,typ_fpu	;4 more registers if not this
	   if	ne
	    movl l0,l1
	    movl l0,l3
	    movl l0,l5
	    movl l0,l7
	   endif
	  endif
	 cend			;End of COND CPU032
	 ;	 
	 cond	cpu532
	  lprd	dcr,0		;Everything off
	  lprd	dsr,0
	  lprd	bpc,0
	  lprd	car,0
	  ;
	  cond	w_mmu
	   lmr	mcr,0		;Everything off
	   lmr	ptb0,0
	   lmr	ptb1,0
	   lmr	msr,0
	   lmr	tear,0
	  cend
	  ;	  
	  tbitb	cfg_f,m_config	;Check for FPU
	  if	fs
	   movd h'32381,typ_fpu	;Must be 32381
	   lfsr	0
	   movbl 0,f0
	   movl	f0,f2
	   movl	f0,f4
	   movl	f0,f6
	   movl l0,l1
	   movl	l0,l3
	   movl	l0,l5
	   movl	l0,l7
	  endif
	 cend			;End of COND CPU532
	cend			;End of NOT DEBUG

	addr	svsb_end+3:w(sb),r2 ;Extend SB
	bicb	3,r2		;Round up to dword
	movd	r2,tbuf_adr

	sprd	mod,r2		;Build MOD table in (R2)
	sprd	sb,(r2)		;SB
	movqd	0,4(r2)		;Link
	addr	svc:w,8(r2)	;PC base
	movqd	0,12(r2)	;Unused

	cond	op_sys
	 bsr	mod_init:d
	cend

;Initialize INTBASE trap vectors as needed

	cond	cpu032
	 movzbd	10,r0		;Highest vector index
	cend
	cond	cpu532
	 movzbd	14,r0		;Highest vector index
	cend
	tbitb	cfg_i,m_config
	if	fs
	 movzbd h'1f,r0		;Include 16 interrupt vectors
	endif

	addr	1(r0),r4	;Actual number of vectors
	muld	tde_max,r4	;Total space requirements
	bsr	get_buf
	movd	r5,tde_vct

	sprd	intbase,r6	;Vector base address
	sprd	psr,r3
	sprd	mod,r2		;Instal_trp needs psr and mod in r3 and r2

	until	eq
	 cmpqd	-1,r6[r0:d]	;Set new vector only if -1
	 if	eq
	  addr	int_srv:w,r4	;Assume interrupt
	  cmpb 16,r0		;Check for interrupt
	  if	hi		;CPU trap if hi
 	   movzwd trp_vct[r0:w],r4 ;Offset from SVC
	   addd	8(r2),r4	;Add base address for absolute address
	  endif
	  movd	r0,r5		;Instal_trp expects vector in r5
	  bsr	instal_trp:w
	 endif
	 addqb	-1,r0
	 cmpqb	-1,r0
	endu

	tbitb	cfg_f,m_config
	if	fc
	 cond	sim_fpu
	  movd	h'32381+exp 31,typ_fpu ;Simulated 32381
	  bsr	simfpu_init:w	;Install FPU simulator
	 celse
	  movqd	0,typ_fpu	;Nothing
	 cend
	endif

	movqd	-1,debug_mod	;Invalidate this

	cond	not op_sys
	 movd	win_last*win_max,r4
	 bsr	get_buf
	 movd	r5,win_base
	cend

	movqb	0,muse_app	;Nothing in progress
	movzbd	app_max,r4
	movd	r4,map_max	;Max number of applications
	lshd	2,r4
	bsr	get_buf
	movd	r5,app_ptr	;Pointer to application specific data
	movzbd	app_max-1,r0
	movd	r5,r1
	addr	4(r1),r2
	movqd	-1,(r1)		;Invalid pointer
	movsd

	movd	app_last:#,r4
	bsr	get_buf
	movd	r5,svc_app	;Pointer to application specific data
	addr	stak_svc(r5),stak_svc(r5) ;Parameter stack
	cond	op_sys
	 movqb	0,app_call(r5)	;Calling application is same
	 ;
	 movzbd	max_timer,r4
	 movb	r4,m_clkcnt	;Number of timers
	 muld	tim_last,r4	;Storage required
	 bsr	get_buf
	 movd	r5,m_clkadr
	 ;
;	 movd	r2,m_string
;	 movd	h'4000,mem_siz
;	 addd	mem_siz,r2
	cend

	restore	[r0,r1]		;Data pointer, offset of service routines

	movzbd	(r1),r4		;Counter
	lshd	2,r4
	bsr	get_buf
	movzbd	(r1),r4		;Counter
	addqd	1,r1		;Point to actual data
	movd	r5,dev_ptr	;Device base

	movqw	0,mdev_max	;Number of virtual devices
	until	eq
	 save	[r0,r2,r4]
	 bsr	pd_init		;R1 advanced
	 restore [r0,r2,r4]
	 addqd	-1,r4
	 cmpqd	0,r4
	endu

	cond	not op_sys
	 movzwd	mdev_max,r4	;Number of devices
	 muld	4*dof_max,r4	;Size of 1 link table
	 bsr	get_buf
	 movd	r5,svc_lpt	;Pointer to base of link table
	cend
	cond	op_sys
	 bsr	buf_init:d	;Initialize heap buffers
	cend

	movqd	0,r0		;Initial index
	until	eq
	 save	[r0]
	 movzwd	dof_cmd lsh b_iosrv,r6
	 movb	r0,r6
	 movd	dc_init,r5
	 bsr	bsr_svc		;Device - Initialize thyself!
	 restore [r0]
	 addqd	1,r0
	 cmpw	mdev_max,r0
	endu

	bispsrw	flag_i		;Interrupts enabled now
	exit	[r3,r6,r7]	;Release FP block
	ret


;****************************
; Operating system routines *
;****************************

;-----------------------------------------
; Branch to proper routine according to R5
; R3 considered scratch register
;-----------------------------------------

svc_cmdrt:
	save	[r0,r1,r4]
	movd	4*dof_cdat(r7),r1 ;Device data
	movzwd	(r1),r0		;Number of commands
	addr	2-4(r1)[r0:d],r1 ;Address of last command
	movd	r1,r3		;4(r3)=service routines
	movd	r5,r4
	andd	bdv_mask,r4	;Mask status bits
	skpsd	b,u
	movd	4(r3)[r0:d],r3	;Target routine
	restore	[r0,r1,r4]
	jump	r3

commandx:
	movd	exp bstat_na,r6
	ret

retrn:
	ret

opo_cinit:
	cond	op_sys		;Start 25ms interrupt from ICU
	 movb	h'cd,18*bus_byts+icu_adr ;Count H interrupt=12, L=13
	 movb	(6000000/4/int_second) and h'ff,24*bus_byts+icu_adr ;Low byte
	 movb	(6000000/4/int_second) lsh -8,25*bus_byts+icu_adr ;High byte
	 movb	b'00001100,22*bus_byts+icu_adr ;Start counters
	 movzbd	h'1d,r5		;Vector index
	 addr	clok_int:d,r4	;Absolute address
	 sprd	mod,r2
	 sprd	psr,r3
	 bsr	instal_trp:w	;Set trap address
	 movb	b'00010011,23*bus_byts+icu_adr ;L interrupt enabled
	 cbitb	5,11*bus_byts+icu_adr ;Chip interrupt enabled
	cend
	ret


;----------------------------------------------------
; Push (R1) onto parameter stack, R0 holds byte count
; Do nothing if insufficient room on stack
;----------------------------------------------------

opo_push:
	save	[r2,r3]
	addr	-1(r1)[r0:b],r1 ;Last address to move
	movd	stak_svc(svc_app),r2
	addqd	-1,r2		;Next available stack slot
	addr	-svc_ssz(r2)[r0:b],r3 ;Lowest possible R2
	cmpd	r2,r3
	if	hs
	 movsb	b
	 addr	1(r2),stak_svc(svc_app) ;Point to valid entry
	endif
	movd	r0,r6		;Success if r6=0
	restore	[r2,r3]
	ret


;------------------------------------------------------
; Pop from parameter stack to (R1), R0 holds byte count
; Do nothing if insufficient data on stack
;------------------------------------------------------

opo_pop:
	save	[r2,r3,r4]
	movd	r1,r2
	movd	stak_svc(svc_app),r1
	addr	r1[r0:b],r3	;Stack address after pop
	addr	stak_svc(svc_app),r4
	cmpd	r3,r4		;Too many bytes if HI
	if	ls
	 movsb
	 movd	r1,stak_svc(svc_app)
	endif
	movd	r0,r6		;Success if r6=0
	restore	[r2,r3,r4]
	ret


;----------------------
; Return addr SVC in r5
;----------------------

opo_csvcad:
	addr	svc:w,r5
	movqd	0,r6		;Success
	ret


;-------------------------------------
; Return pointer to device table in r5
;-------------------------------------

opo_cdevad:
	movd	dev_ptr,r5
	movqd	0,r6		;Success
	ret


;--------------------------------
; R4 holds new cfg register value
;--------------------------------

opo_setcfg:
	cond	cpu032
	 proc			;Now set CPU config register from r4
	 reg	[]
buf:	 ds	20
	 code
	 movd	h'000b0e,buf	;SETCFG opcode
	 inssb	r4,buf+1,7,4	;Store config list in short field
	 movw	h'12,buf+3	;RET 0 opcode
	 jsr	buf
	 pend
	cend
	cond	cpu532
	 lprd	cfg,r4
	cend
	movd	r4,m_config
	movqd	0,r6
	ret


;--------------------------
; Return CFG register in r5
;--------------------------

opo_getcfg:
	movd	m_config,r5
	movqd	0,r6		;Success
	ret


;----------------------
; Return FPU type in r5
;----------------------

opo_fpu:
	movd	typ_fpu,r5	;Return FPU type in R5
	movqd	0,r6		;Success
	ret


;*******************************
;* Null device output routines *
;*******************************

	irp	op,int,err,io,stat,sst,sio
nlo_&op:
	mend
	movqd	0,r6		;Nothing to do
	ret

;-----------------------
; Output character in r5
; Also exits if error
;-----------------------

nlo_chr:
	movd	r4,tos
	bsr	nlo_chrbsy:w
	movd	4*dof_sst(r7),r4
	until	ne
	 jsr	r4
	 cmpqd	0,r6
	quit	eq
	 bicd	exp bstat_rd+exp bstat_xf,r6 ;Wait if these set
	 cmpqd	0,r6
	qend
	 movd	4*dof_sio(r7),r4
	 jsr	r4
	endu
	movd	tos,r4
	ret


;----------------------------------------------
; Block output according to status/length in R0
; (R1) holds text
; R1 advanced, R0 updated
;-----------------------------------------------

nlo_blk:
	save	[r2,r3,r4,r5]
	movqd	-1,r2		;Assume no character termination
	movd	4*dof_chr(r7),r4 ;Address of TX routine
	tbitb	bkb_bin,r0	;Check for binary file
	if	fs
	 movd	4*dof_sio(r7),r4 ;Data transfer, use sio instead
	endif

	tbitb	bkb_28,r0	;Check for extended count
	if	fs
	 movd	r0,r3
	 bicd	h'f0000000,r3
	 movqd	0,r0		;Clear all status bits
	else
	 movzwd	r0,r3		;Termination count
	 tbitb	bkb_cnt,r0
	 if	fc
	  movqd	-1,r3		;Infinite length if no count specified
	 endif
	 tbitb	bkb_tr5,r0
	 if	fs
	  movd	r5,r2		;Termination character
	 endif
	endif

	begin
	 cmpqd	0,r3
	while	ne
	 movzbd (r1),r5		;Current character
	 addqd	1,r1		;Advance pointer
	 cmpd	r5,r2		;See if this is termination character
	quit	eq
	 jsr	r4
	 addqd	-1,r3		;Decrement count
	qend
	 tbitb bkb_ekt,r0	;See if TX of last character requested
	 if	fs
	  jsr	r4		;Send termination too
	 endif
	endw

	movw	r3,r0		;Remaining count
	restore	[r2,r3,r4,r5]
	ret

	disp	2

;------------------------------------------
; Create new instance of device,
;   return base pointer in r5
; R4 holds additional storage, 0 if none
;------------------------------------------

nlo_cinstnc:
	save	[r0,r1,r2,r3,r4,r7]

	movqd	0,r6		;Assume OK
	cond	op_sys
	 movzbd 4*dof_id+dofid_max(r7),r0 ;Number of entries
	 lshd	2,r0		;Multiply by 4
	 addd	name_siz,r0	;Room for name and extra parameters
	 movd	4*dof_dat(r7),r5
	 movzwd	(r5),r5		;Size of vdat block
	 addd	r5,r4
	 movd	4*dof_vdat(r7),r5
	 movzwd	(r5),r5		;Size of vdat block
	 addd	r5,r4
	 addd	r0,r4		;Size of r7 block and name
	 addd	lnk_last,r4
	 bsr	get_bufh:d	;Get handle, r6<>0 if not enough room
	 if	eq
	  movd	r5,r4
	  bsr	opo_lonbf	;Lock it
	  movd	(r5),r2		;Target address
	  movd	r7,r1		;Source address
	  movd	r2,r7		;New dev_ptr address
	  save	[r0,r1]
	  movsb
	  restore [r0,r1]
;	  movqb lnt_instnc,4*dof_id+3(r7)
	  movb	svc_r6,lnk_indx(r2) ;Device index
	  movd	r1,lnk_base(r2)	;Assume source was base pointer
;	  cmpqb	lnt_base,4*dof_id+3(r1) ;See if source was base
	  if	ne
	   movd	lnk_base(r1)[r0:b],lnk_base(r2) ;Copy actual base r7
	  endif
	  save	[r0,r1]
	  movd	r1,lnk_r7(r2)	;Source address
	  movd	r5,lnk_hnd(r2)	;Handle for this block
	  addd	lnk_last,r2
	  movd	4*dof_dat(r7),r1 ;Vdat block
	  movzwd (r1),r0
	  movd	r2,4*dof_dat(r7) ;Address of new vdat block
	  movsb
	  movd	4*dof_vdat(r7),r1 ;Vdat block
	  movzwd (r1),r0
	  movd	r2,4*dof_vdat(r7) ;Address of new vdat block
	  movsb
	  restore [r0,r1]
	  movd	r7,4*dof_lnk(r1) ;Old routine links to new instance
	 endif
	celse
	 movzbd svc_r6,r5	;Device index
	 muld	4*dof_max,r5	;Offset to new device link table
	 addr	(svc_lpt)[r5:b],r5 ;Link data table
	 cmpqd	-1,4*dof_lnk(r7) ;Don't save if already done
	 if	eq
	  movd	r7,r1		;Source address
	  movd	r5,r2		;Target address
	  movd	dof_max,r0	;Count in Dwords
	  movsd
	  movd	r5,4*dof_lnk(r7) ;Link address
	 endif
	cend
	movd	r7,r5		;Return here

	restore	[r0,r1,r2,r3,r4,r7]
	ret


;---------------------------------------------------------
; Re-route or link, svc_r6 holds code of device to act on,
; R7 = holds source address, R5 holds new assignment
;---------------------------------------------------------

nlo_cvct:
	save	[r2,r3,r4,r5]

	movzbd	r5,r2
	movd	(dev_ptr)[r2:d],r2 ;New device IO,STAT,SIO,SST

	movqd	0,r4		;No extra size needed
	bsr	nlo_cinstnc	;Create new instance, return pointer in r5

	cmpqd	0,r6		;Only if OK so far
	if	eq
	 movd	r5,r7		;New r7 now
	 movd	4*dof_io(r2),4*dof_io(r7) ;Load new vector
	 movd	4*dof_stat(r2),4*dof_stat(r7)
	 movd	4*dof_sio(r2),4*dof_sio(r7)
	 movd	4*dof_sst(r2),4*dof_sst(r7)
	 movd	4*dof_blk(r2),4*dof_blk(r7)
	 movd	4*dof_cmd(r2),4*dof_cmd(r7)
	 movd	4*dof_cdat(r2),4*dof_cdat(r7)
	 movd	4*dof_dat(r2),4*dof_dat(r7)
	 movd	4*dof_bdat(r2),4*dof_bdat(r7)
	 cond	op_sys
;	  movb	lnt_route,4*dof_id+3(r7)
	 cend
	 movzbd	svc_r6,r3	;Save device here
	 movd	r7,(dev_ptr)[r3:d] ;Now install
	endif

	restore [r2,r3,r4,r5]
	ret


;------------------------------------------------
; Un-reroute or unlink, R7 = holds source address
;------------------------------------------------

nlo_cunvct:
	save	[r0,r1,r2,r4,r5]

	movqd	-1,r6		;Assume error
	cond	op_sys
;	 cmpb	lnt_base,4*dof_id+3(r7)
	 if	ne		;Can't unlink base block
	  movzbd 4*dof_id+dofid_max(r7),r2 ;Dof_max
	  addr	name_siz(r7)[r2:d],r2 ;Skip name field
	  movzbd lnk_indx(r2),r0 ;Device index
	  movd	r7,r1		;Save original
	  movd	lnk_r7(r2),r7
	  movd	4*dof_lnk(r1),4*dof_lnk(r7) ;Unlink this entry
	  movd	lnk_hnd(r2),r4	;Handle
	  cmpd	(dev_ptr)[r0:d],r1
	  if	eq		;Don't alter dev_ptr unless source was there
	   movd	r7,(dev_ptr)[r0:d] ;Restore pointer
	  endif
	  bsr	opo_clrbf:d	;Clear buffer
	 endif
	celse
	 movd	4*dof_lnk(r7),r1
	 cmpqd	-1,r1		;Must be something to restore
	 if	ne
	  movd	r7,r2		;Target address
	  movd	dof_max,r0	;Count in Dwords
	  movsd
	  movqd -1,4*dof_lnk(r7) ;No more linking
	  movqd	0,r6
	 endif
	cend

	restore [r0,r1,r2,r4,r5]
	ret


	disp	1

;---------------
;Return r7 in r5
;---------------

nlo_cgetr7:
	movd	r7,r5
	movqd	0,r6
	ret


;------------------------------------
;Install r4 as new (dev_ptr) r7 value
;------------------------------------

nlo_cputr7:
	save	[r0,r1]
	movd	r7,r1		;Pointer
;	cmpqb	lnt_base,4*dof_id+3(r1) ;See if this is base
	if	ne
	 movzbd	4*dof_id+dofid_max(r1),r0 ;Number of entries
	 movd	name_siz+lnk_base(r1)[r0:d],r1 ;Base pointer
	endif
	begin
	 movqd	-1,r6		;Assume error
	 cmpqd	-1,r1
	quit	eq		;End of the line if eq
	 movqd	0,r6		;Assume OK
	 cmpd	r4,r1		;Must match something in linked list
	while	ne
	 movd	4*dof_lnk(r1),r1 ;Next entry in list
	endw
	cmpqd	0,r6
	if	eq
	 movzbd	svc_r6,r0	;Index
	 movd	r4,(dev_ptr)[r0:d] ;Install validated r4
	 movd	r4,r7
	endif
	restore	[r0,r1]
	ret
	

;------------
; Lock device
;------------

nlo_lock:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	sbitb	bsm_lok,dat_smoc(r3) ;Set lock bit
	movd	tos,r3
	movqd	0,r6
	ret


;--------------
; Unlock device
;--------------

nlo_unlok:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	cbitb	bsm_lok,dat_smoc(r3)
	movd	tos,r3
	movqd	0,r6
	ret


;-------------------
; Open output device
;-------------------

nlo_copen:
nli_copen:
	save	[r2,r3]

	movd	4*dof_dat(r7),r3 ;Data pointer
	movd	4*dof_bdat(r7),r2
	movqd	0,r6		;Assume OK
	tbitb	bdp_lok,dat_ptcl(r2) ;See if lockable
	if	fs
	 bsr	nlo_lock
	endif
	cmpqd	0,r6
	if	eq
	 movqw	0,dat_line(r3)	;Start upper left
	 movqw	0,dat_col(r3)
	 movqw	0,dat_page(r3)
	 movqd	0,dat_bchr(r3)	;Clear buffer
	 movqd	0,dat_brdx(r3)	;Clear read index
	 movqd	0,dat_bwtx(r3)	;Clear write index

	 cbitb	bdp_eof,dat_ptcl(r2) ;Clear end of file status
	 sbitb	bdp_opn,dat_ptcl(r2) ;Device open for business
	endif
	movd	r7,r5		;Handle for unnamed/unlinked devices
	restore [r2,r3]
	ret


;------------------------
; Set binary file type on
;------------------------

nlo_binon:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	sbitb	bdp_bin,dat_ptcl(r3)
	movd	tos,r3
	ret


;-------------------------
; Set binary file type off
;-------------------------

nlo_binoff:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	cbitb	bdp_bin,dat_ptcl(r3)
	movd	tos,r3
	ret


;----------------------------------------
; Return current binary file type setting
;----------------------------------------

nlo_binget:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	tbitb	bdp_bin,dat_ptcl(r3)
	sfsd	r5
	movd	tos,r3
	ret


;--------------------------
; Return data pointer in r5
;--------------------------

nlo_cdatb:
	movd	4*dof_dat(r7),r5 ;Data pointer to R5
	movqd	0,r6		;Success
	ret


;----------------------------------
; Return virtual data pointer in r5
;----------------------------------

nlo_cvdatb:
	movd	4*dof_vdat(r7),r5 ;Vdat pointer
	movqd	0,r6		;Success
	ret


;---------------------------------------------------
; Write R1, number of bytes in R0, via O_SIO routine
; LSB first
;---------------------------------------------------

nlo_r1:
	save	[r0,r1,r3,r4,r5]
	movd	4*dof_sio(r7),r4
	begin
	 cmpqb	0,r0
	while	ne
	 movzbd	r1,r5
	 jsr	r4
	 rotd	-8,r1
	 addqb	-1,r0
	endw
	restore	[r0,r1,r3,r4,r5]
	ret


;----------------------------------------
; Display character in r4 as ASCII
; Set attributes as needed:
;  0-1f dim
;  20-7f normal
;  80-9f dim,reverse
;  a0-ff reverse
;----------------------------------------

nlo_dspasc:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movzwd	dat_vca(r3),r2	;Original attributes
	movd	r2,r5		;Working attributes
	cbitb	7,r4
	if	fs
	 ibitb	vca_rev,r5	;Toggle reverse
	endif
	cmpb	" ",r4
	if	hi
	 ibitb	vca_dim,r5	;Toggle dim
	 addb	"@",r4		;Keep displayable
	endif
	movd	4*dof_chr(r7),r1 ;Character display
	cmpd	r2,r5		;See if different
	if	eq
	 movd	r4,r5
	 jsr	r1
	else
	 movw	r5,dat_vca(r3)
	 bsr	sat_vc2:w	;Set new attributes
	 movd	r4,r5
	 jsr	r1
	 movw	r2,dat_vca(r3)
	 bsr	sat_vc2:w	;Restore original attributes
	endif
	restore	[r1,r2,r3,r4,r5]
	ret


;------------------------------------------
; Return current xy pixel coordinates in r5
;------------------------------------------

nlo_cgetxy:
	movd	4*dof_dat(r7),r5
	movd	dat_col(r5),r5
	ret


;-------------------------------------------
; Return current character coordinates in r5
;-------------------------------------------

nlo_cgetchr:
	movd	4*dof_dat(r7),r5
	movd	dat_col(r5),r5	;Pixel coordinates
	br	pix2chr:w	;Convert to character coordinates


;-------------------------------------
; Set command mode
; Device assumed to be properly opened
;-------------------------------------

nlo_cmdon:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	sbitb	bsm_cmd,dat_smoc(r3)
	movd	tos,r3
	ret


;-------------------------------------
; Clear command mode
; Device assumed to be properly opened
;-------------------------------------

nlo_cmdoff:
	movd	r3,tos
	movd	4*dof_bdat(r7),r3
	cbitb	bsm_cmd,dat_smoc(r3)
	movd	tos,r3
	ret


;----------------------------------------
; Process character according to dat_smoc
; bstat_rd in r6 if nothing done
; r6 = 0 if character processed
;----------------------------------------

nlo_chrbsy:
	movd	r3,tos
	movqd	exp bstat_rd,r6	;Assume not busy
	movd	4*dof_bdat(r7),r3
	tbitb	bsm_cmd,dat_smoc(r3) ;Check for command in progress
	if	fs
	 bsr	vc_stor:w
	 movqd	0,r6		;Character disposed of
	endif
	movd	tos,r3
	ret


;******************************
;* Null device input routines *
;******************************

nli_int:
nli_err:
	movqd	0,r6
	ret


nli_stat:
nli_sst:
	movzbd	exp bstat_ef,r6	;Always end of file here
	ret


nli_io:
	save	[r3,r4]
	movd	4*dof_stat(r7),r4
	br	nli_sio1:b

nli_sio:
	save	[r3,r4]
	movd	4*dof_sst(r7),r4
nli_sio1:
	movd	4*dof_bdat(r7),r3
	until	ne
	 jsr	r4
	 cmpqd 0,r6
	quit	eq
	 bicd	exp bstat_rd+exp bstat_xf,r6 ;Wait if these set
	 cmpqd 0,r6
	qend
	 cmpqd	0,dat_bsz(r3)	;Check for presence of buffer
	 if	eq
	  movd	4*dof_io(r7),r4 ;Address of input routine
	  jsr	r4
	 else			;Read from buffer
	  movd	dat_bpt(r3),r5
	  movd	dat_brdx(r3),r4
	  movzbd r5[r4:b],r5
	  addqd	1,r4
	  andd	dat_bsz(r3),r4
	  movd	r4,dat_brdx(r3)
	  addqd	-1,dat_bchr(r3)
	 endif
	endu
	restore	[r3,r4]
	ret

	disp	2

nli_chr:
	save	[r0,r1,r2,r3,r4]
	bsr	nli_chrbsy
	cmpqd	0,r6
	if	ne		;Got a keeper if eq
	 movd	4*dof_dat(r7),r3 ;Data pointer
	 movqd	0,r0		;Character counter
	 movqd	0,r1		;Composite character
	 movqd	0,r2		;Insertion index
	 until	ne
	  movd	4*dof_sst(r7),r4
	  until	ne
	   jsr	r4
	   cmpqd 0,r6
	  quit	eq
	   bicd	exp bstat_rd+exp bstat_xf,r6 ;Wait if these set
	   cmpqd 0,r6
	  qend
	   movd	4*dof_sio(r7),r4 ;Address of input routine
	   jsr	r4
	   insb	r2,r5,r1,8	;Insert into next position
	   addqd 1,r0		;1 more character read
	   addb	8,r2		;Next insertion position
	  endu
	  cmpqd	0,r6
	 quit	ne		;Error in read if ne
	  movd	dc_xlat,r5
	  bsr	do_cmd
	  cmpqd exp bstat_nr,r6	;Need more characters if eq
	 endu
	 movzbd	r1,r5		;Character to return now
	 cmpqd	0,r6
	 if	eq
	  cmpqb	1,r0
	  if	lo
	   bsr	nlo_cmdon	;Command in progress
	   movd	dat_next(r3),r2 ;Pointer to command field
	   lshd	-8,r1
	   addqb -1,r0
	   movb	r0,2(r2)	;Skip over size parameter
	   movd	r1,2+1(r2)
	  endif
	 endif
	endif
	restore	[r0,r1,r2,r3,r4]
	ret

	disp	1

;-------------------
; Close input device
;-------------------

nlo_cclose:
nli_cclose:
	save	[r2,r3,r5]
	movd	dc_eof,r5	;Do any needed termination
	bsr	do_cmd
	movd	4*dof_bdat(r7),r3
	cbitb	bdp_opn,dat_ptcl(r3) ;No longer open
	bsr	nlo_unlok
	restore [r2,r3,r5]
	movqd	0,r6		;Success
	ret


;-------------------------------------------------------------
; Read value to R1, number of bytes in R0:B, via I_SIO routine
; LSB 1st
;-------------------------------------------------------------

nli_r1:
	save	[r0,r3,r4,r5]
	movd	4*dof_sio(r7),r4
	movqd	0,r1		;Initial value
	movqd	0,r3		;Bit position for 1st byte read
	begin	
	 cmpqb	0,r0
	while	ne
	 jsr	r4
	 insb	r3,r5,r1,8
	 addb	8,r3		;Next bit position
	 addqb	-1,r0
	endw
	restore	[r0,r3,r4,r5]
	movqd	0,r6
	ret

	disp	2

;------------------------------------
; Process input according to dat_smoc
; bstat_rd in r6 if nothing done
; r6 = 0 if character returned in r5
;------------------------------------

nli_chrbsy:
	save	[r2,r3,r4]
	movqd	exp bstat_rd,r6	;Assume not busy
	movd	4*dof_bdat(r7),r3
	tbitb	bsm_cmd,dat_smoc(r3) ;Check for command in progress
	if	fs
	 movd	4*dof_dat(r7),r2
	 movd	dat_next(r2),r2
	 movzbd	2(r2),r4	;Index to next character
	 movzbd	2(r2)[r4:b],r5 ;Read current character
	 addqb	-1,r4		;Decrement count
	 movb	r4,2(r2)
	 cmpqb	0,r4		;See if entire string read
	 if	eq
	  cbitb	bsm_cmd,dat_smoc(r3) ;All gone
	 endif
	 movqd 0,r6		;Success
	endif
	restore	[r2,r3,r4]
	ret


;****************************
;* Various support routines * 
;****************************

;------------------------------------------------------
; Update system parameters according to character in R5
; CR, LF, Tab, Backspace require special handling
; R7 holds base of device table
;------------------------------------------------------

	disp	2
s1o_upd:
	save	[r1,r3,r5]
	movd	4*dof_dat(r7),r3 ;Pointer to data
	movd	4*dof_vdat(r7),r1 ;Vdat pointer

	cmpw	" ",r5
	if	ls		;Just advance position if displayable
	 addw	dat_chrx(r3),dat_col(r3) ;Advance column
	else
	 cmpb	cr,r5
	 if	eq
	  movqw	0,dat_col(r3)	;Back to beginning
	 else
	  cmpb	lf,r5		;Check for line feed
	  if	eq
	   addw dat_chry(r3),dat_line(r3)
	  else
	   cmpb	tab,r5		;Check for tab
	   if	eq
	    movzwd dat_col(r3),r5
	    bsr	pix2chr
	    addw 8,r5
	    bicb 7,r5		;Advance to next tab stop
	    bsr	chr2pix
	    movw r5,dat_col(r3)
	   else
	    cmpb bksp,r5	;Check for backspace
	    if	eq
	     subw dat_chrx(r3),dat_col(r3)
	    endif
	   endif
	  endif
	 endif
	endif

	cmpw	dat_col(r3),vdt_maxc(r1) ;See if wraparound required
	if	gt
	 subw	vdt_maxc(r1),dat_col(r3) ;Wrap around to next line
	 addqw	-1,dat_col(r3)		;Maxc+1 is 0 on next line
	 addw	dat_chry(r3),dat_line(r3) ;Advance row if not beyond max
	else
	 cmpqw	0,dat_col(r3)
	 if	gt
	  addw	vdt_maxc(r1),dat_col(r3)
	  addqw	1,dat_col(r3)		;-1 is max_c on previous line
	  subw	dat_chry(r3),dat_line(r3) ;Backup one row
	 endif
	endif
	cmpw	dat_line(r3),vdt_maxl(r1) ;See if row beyond max
	if	gt
	 movw	vdt_maxl(r1),dat_line(r3)
	 subw	dat_chry(r3),dat_line(r3)
	 addqw	1,dat_line(r3)	;Current is bottom line
	else
	 cmpqw	0,dat_line(r3)
	 if	gt
	  movqw	0,dat_col(r3)
	  movqw	0,dat_line(r3)	;Don't backup beyond upper left
	 endif
	endif

	restore	[r1,r3,r5]
	ret

	disp	1

;---------------------------------------------------------
; Convert character coordinates in r5 to pixel coordinates
;---------------------------------------------------------

chr2pix:
	save	[r3,r4]
	movd	4*dof_dat(r7),r3
	movw	r5,r4
	mulw	dat_chrx(r3),r4	;Pixel column
	movqw	0,r5		;Clear column bits
	movzwd	dat_chry(r3),r3
	muld	r3,r5
	movw	r4,r5
	restore	[r3,r4]
	ret


;---------------------------------------------------------
; Convert pixel coordinates in r5 to character coordinates
;---------------------------------------------------------

pix2chr:
	save	[r3,r4]
	movd	4*dof_dat(r7),r3
	movw	r5,r4
	divw	dat_chrx(r3),r4	;Character column
	movqw	0,r5		;Clear column bits
	movzwd	dat_chry(r3),r3
	divd	r3,r5
	movw	r4,r5
	restore	[r3,r4]
	ret


;--------------------------------------------
; Convert displacement in (r1) to value in r5
; R1 advanced past displacement
;--------------------------------------------

get_disp:
	movb	(r1),r5
	tbitb	7,r5		;One byte if fc
	if	fc
	 lshd	24+1,r5		;Sign bit to bit 31
	 ashd	-24-1,r5	;Sign extend upper bit
	 addqd	1,r1
	else
	 tbitb	6,r5
	 if	fs		;4 bytes if fs
	  movd	(r1),r5
	  rotw	8,r5		;Swap lower 2 bytes
	  rotd	16,r5		;Swap words
	  rotw	8,r5
	  lshd	2,r5		;Sign bit to bit 31
	  ashd	-2,r5		;Sign extend upper 2 bits
	  addqd	4,r1
	 else			;2 bytes
	  movw	(r1),r5
	  rotw	8,r5		;Swap bytes
	  lshd	16+2,r5		;Sign bit to bit 31
	  ashd	-16-2,r5	;Sign extend upper 2 bits
	  addqd	2,r1
	 endif
	endif
	ret


;-----------------------------
; Output TOS string until 0
; Use chr routine of r6 device
;-----------------------------

win_outs:
	save	[r1,r2,r5]
	movd	3*4(sp),r1	;Point to 1st character
	movzbd	b_iosrv,r2
	insb	r2,dof_chr,r6,8
	movd	r6,r2		;Save this
	begin
	 addqd	1,r1
	 cmpqb	0,-1(r1)
	while	ne
	 movzbd	-1(r1),r5
	 movd	r2,r6
	 bsr	bsr_svc
	endw
	movd	r1,3*4(sp)	;Adjust return address
	restore	[r1,r2,r5]
	ret


;-----------------------------
; Output R0/R1
; Use blk routine of r6 device
;-----------------------------

win_outp:
	save	[r2]
	movzbd	b_iosrv,r2
	insb	r2,dof_blk,r6,8
	sbitb	bkb_cnt,r0	;Terminate on count in r0
	bsr	bsr_svc
	restore	[r2]
	ret


;------------------------------
; Output R5 via SVC_BSR
; Start with LSB, go until R5=0
;------------------------------

win_outr5:
	save	[r2]
	movzbd	b_iosrv,r2
	insb	r2,dof_chr,r6,8
	movd	r6,r2		;Save here
	begin
	 cmpqd	0,r5
	while	ne
	 save	[r5]
	 movzbd	r5,r5
	 movd	r2,r6
	 bsr	bsr_svc
	 restore [r5]
	 lshd	-8,r5
	endw
	restore	[r2]
	ret


;-------------------------------------------------
; Send string on stack to device via routine in R4
; String terminated by H'0
;-------------------------------------------------

tx_vcod:
	save	[r1,r5]
	movd	8(sp),r1	;Pointer to string
	begin
	 movzbd	(r1),r5
	 addqd	1,r1
	 cmpqb	0,r5
	while	ne
	 jsr	r4
	endw
	movd	r1,8(sp)	;Return address
	restore	[r1,r5]
	ret


;-------------------------------------
; Send value in R5 as ASCII characters
; Value must be 1-99
; R4, R6 hold device data
;-------------------------------------

tx_asci:
	save	[r0,r1,r5]
	movzbd	r5,r0
	movqd	0,r1		;Value in R0R1
	deid	10,r0		;Remainder in R0, quotient in R1
	movd	r1,r5		;10s digit
	addb	"0",r5		;Make it ASCII
	jsr	r4
	movd	r0,r5		;1s digit
	addb	"0",r5		;Make it ASCII
	jsr	r4
	restore	[r0,r1,r5]
	ret


;****************************
;* Dat_next output routines *
;****************************

;Dat_next fields:
	mode	imm,0
dnx_size: blkw			;Size of storage
dnx_dat: blkd			;Pointer to data area
dnx_flg: blkd			;Flag/status
dnx_cnt: blkw			;Count
dnx_nst: blkw			;Nesting counter
dnx_adr: blkd			;Base address
dnx_ptr: blkd			;Current pointer
dnx_lst:			;Next available address
	mode	pc

;Count status bits:	;If all clear, bits 0-11 are count
dnx_bdsp: equ	31	;0-15 are count, next value is displacement
dnx_btrm: equ	30	;Bits 0-15 are count, 16-23 are termination character
dnx_bcmd: equ	29	;Bits 0-15 are count, last character is sub-command

;-----------------------------------------------------
;Command tables
;  Base value:B
;  Number of entries:B (must be consecutive values)
;  Number of following bytes:d, offset to sub-table or
;   service routine:d
;-----------------------------------------------------

;---------------------------
;Table of screen subcommands
;---------------------------

t_scrvc:
	db	vcs_base	;Base value
	db	(t_scrvc2-t_scrvc1)/8 ;Number of entries

t_scrvc1:
	dd	1		;One byte follows
	dd	tab_vcs-($-4)	;Horizontal space
	dd	0		;Nothing else required
	dd	nln_vcs-($-4)	;New line if not at beginning
	dd	0		;Nothing else required
	dd	cls_vcs-($-4)	;New page
	dd	2		;Col, row follow
	dd	cur_vcs-($-4)	;Position to col:B,row:B
	dd	4		;Col, row follow
	dd	pix_vcs-($-4)	;Pixel position col:W, row:W
	dd	8		;Upper left col/row, dimensions
	dd	win_vcs-($-4)	;Set window pixel size
	dd	1		;Bit 7 set for flash, bit 6 set for text
	dd	crsr_vcs-($-4)	;Set cursor size/type
t_scrvc2:


;----------------------
;H'80 - h'9f characters
;----------------------

t_dovc:
	db	vc_ign		;Base value
	db	(t_dovc2-t_dovc1)/8 ;Number of entries

t_dovc1:
	dd	0		;80 = Ignore this code
	dd	retrn-($-4)

	dd	1		;81 = Take next character literally
	dd	lit_vc-($-4)

	dd	0		;82
	dd	retrn-($-4)

	dd	0		;83
	dd	retrn-($-4)

	dd	0		;84
	dd	retrn-($-4)

	dd	1 + exp dnx_bcmd ;85 = Screen command, data follows
	dd	t_scrvc-($-4)

	dd	1		;86 = Set attributes
	dd	sat_vc-($-4)

	dd	1		;87 = Clear attributes
	dd	cat_vc-($-4)

	dd	1		;88 = Toggle attributes
	dd	tat_vc-($-4)

	dd	0		;89
	dd	retrn-($-4)

	cond	op_sys
	 dd	1 + exp dnx_bcmd ;8A = Menu sub-commands
	 dd	t_menvc-($-4)
	celse
	 dd	0
	 dd	retrn-($-4)	;No menus if not operating system
	cend
t_dovc2:

;Table for 13 bit characters

t_chr13b:
	dd	1
	dd	chr13bit-($-4)


	disp	2

	cond	op_sys

;----------------------------------------
; Return length of character string in R5
; R1 => string
;----------------------------------------

vstr_len:
	save	[r0,r1,r2,r3,r4]
	movzbd	(r1),r0
	movqd	1,r5		;Always at least 1
	cmpw	h'80,r0
	if	ls
	 cmpw	h'9f,r0
	 if	hs
	  addr	t_dovc,r3	;Starting table
	  movd	r1,tos		;Save starting address
	  until	fc		;Until no sub-commands
	   movzbd (r1),r0	;Current character
	   addqd 1,r1		;Advance to next character
	   subb	(r3),r0		;Base character
	   cmpb	1(r3),r0	;Must be in range
	   if	ls		;Out of range if ls
	    bicpsrb flag_f	;End of the line
	   else			;OK if hi
	    movd 1+1(r3)[r0:q],r2 ;Number of bytes in sub-command
	    ;
	    tbitb dnx_bdsp,r2	;Check for following displacement
	    if	fs
	     movzwd r2,r4	;Count only
	     addd r4,r1		;Point to displacement value
	     bsr get_disp	;R1 advanced past displacement
	    else
	     tbitb dnx_btrm,r2	;Check for termination byte
	     if	fc		;Just add byte count if fc
	      movzwd r2,r4	;Count only
	      addd r4,r1
	     else		;Termination required
	      movzwd r2,r4
	      addd r4,r1	;Start search for termination here
	      movd r2,r4
	      lshd -16,r4	;Termination character in r4
	      begin
	       cmpb (r1),r4
	      while ne
	       bsr vstr_len
	       addd r5,r1
	      endw
	      addqd 1,r1	;Skip termination byte
	     endif
	    endif
	    ;
	    movd 1+1+4(r3)[r0:q],r4 ;Offset to sub-command tables
	    addr r3[r4:b],r3	;Address of subcommand table
	   endif
	   tbitb dnx_bcmd,r2
	  endu
	  subd	tos,r1		;Current-starting
	  movd	r1,r5
	 else
	  cmpw	h'bf,r0		;Check for 13 bit character
	  if	hs
	   movqd 2,r5
	  endif 
	 endif
	endif	
	restore [r0,r1,r2,r3,r4]
	ret


;---------------------------------------------------------------------
; R1 => character string, advance past current character/video command
; R0 holds count and may be decremented below 0 if string is too short
; Carry set on exit if R0 underflows
;---------------------------------------------------------------------

vstr_nxt:
	save	[r5]
	bsr	vstr_len	;Get length in R5
	addd	r5,r1
	subd	r5,r0
	restore	[r5]
	ret

	cend

;---------------------------------------------------
; Set up to buffer input from subsequent data writes
; R1 => data block
; R5 holds current character
; Enter at vc_mor1 if r2 holds buffer pointer
;---------------------------------------------------

vc_more:
	movd	r2,tos
	movd	4*dof_dat(r7),r2 ;Pointer to data
	movd	dat_next(r2),r2 ;Pointer to subsequent storage
	addr	dnx_lst(r2),r2	;Start data here
	bsr	vc_mor1:b
	movd	tos,r2
	ret

vc_mor1:
	save	[r0,r2,r3]
	movd	4*dof_bdat(r7),r3 ;Pointer to data
	sbitb	bsm_cmd,dat_smoc(r3) ;Multi-character command, busy set before
	movd	4*dof_dat(r7),r3
	movd	dat_next(r3),r3	;Pointer to target storage
	if	fc		;New command if fc
	 movd	r2,dnx_adr(r3)	;Base address
	 movb	r5,(r2)		;Current character
	 addr	1(r2),dnx_ptr(r3) ;Next address
	endif
	cmpqw	0,dnx_nst(r3)
	if	eq
	 movd	r1,dnx_dat(r3)	;Pointer to source data
	endif
	movd	(r1),r0
	movd	r0,dnx_flg(r3)	;Unaltered count/type
	addqw	1,dnx_nst(r3)	;One more level
	tbitb	dnx_bdsp,r0	;Check for displacement
	if	fs
	 addqw	1,r0		;Get count and following displacement
	else
	 tbitb	dnx_btrm,r0	;Check for character termination
	orif	fs
	endif
	movw	r0,dnx_cnt(r3)	;Actual character count to read
	restore	[r0,r2,r3]
	ret


;---------------------------------
; R5 holds character, do h'80-h'9f
; If doing default routine:
;   R3 = dof_dat
;   R4 = dof_sio
;---------------------------------

do_vc:
	movd	r1,tos
	addr	t_dovc,r1
	bsr	do_vcsub:b
	movd	tos,r1
	ret

;Enter here if r1 already holds address

do_vcsub:
	save	[r0,r1,r3,r4,r5]
	movzbd	r5,r0
	subb	(r1),r0
	cmpb	1(r1),r0
	if	hi		;OK if hi
	 addr	2(r1)[r0:q],r1	;Pointer to correct data block
	 cmpqd	0,(r1)
	 if	eq
	  addd	4(r1),r1	;Service address if nothing follows
	  movd	4*dof_dat(r7),r3
	  movd	4*dof_sio(r7),r4
	  jsr	r1
	  bsr	nlo_cmdoff
	 else
	  bsr	vc_more
	 endif
	else
	 bsr	nlo_cmdoff	;Could be on if nested string
	endif
	restore	[r0,r1,r3,r4,r5]
	ret


;-----------------------------------------------
; Store character in R5 in dat_next
; If last character then branch to exit routine:
;   R2 => data string
;   R3 = dof_dat
;   R4 = dof_sio
;-----------------------------------------------

vc_stor:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_next(r3),r2
	movd	dnx_ptr(r2),r1	;Current pointer
	movb	r5,(r1)
	addqd	1,r1
	movd	r1,dnx_ptr(r2)
	addqw	-1,dnx_cnt(r2)
	cmpqw	0,dnx_cnt(r2)	;Got it all if eq
	if	eq		;This was the last one if EQ
	 movd	dnx_flg(r2),r4
	 bicd	exp dnx_bcmd+h'ffff,r4
	 cmpqd	0,r4
	 if	eq		;Nothing special if hs
	  addqw	-1,dnx_nst(r2)	;Nesting counter
	  cmpqw	0,dnx_nst(r2)
	  if	eq		;Really done if eq
	   movd	dnx_dat(r2),r1	;Data pointer
	   tbitb dnx_bcmd,(r1)	;Check for sub-table
	   if	fc		;Nothing follows if eq, just do default
	    addd 4(r1),r1	;Offset to target routine
	    movd dnx_adr(r2),r2	;Data address
	    movd 4*dof_sio(r7),r4
	    jsr	r1
	    bsr	nlo_cmdoff
	   else
	    addd 4(r1),r1	;Offset to target routine
	    bsr	do_vcsub	;Setup next table
	   endif
	  else
	   movqw 1,dnx_cnt(r2)	;Resume previous nesting level
	  endif
	 else			;Special handling required
	  movqd	0,r0		;Assume nothing follows
	  tbitb	dnx_bdsp,dnx_flg(r2) ;Check for displacement
	  if	fs		;Last byte is start of displacement
	   tbitb 7,r5		;Check for 8 bits
	   if	fs
	    movqb 1,r0		;One more byte if word displacement
	    tbitb 6,r5
	    if	fs		;Dword if fs
	     movqb 3,r0		;Three more bytes
	    endif
	   endif
	   movd	r0,dnx_flg(r2)	;Count only now
	  else			;Not displacement, must be termination
	   cmpb	dnx_flg+2(r2),r5 ;Check for termination
	   if	ne		;No termination yet if ne
	    movqd 1,r0		;More follows if not termination
	    cmpb h'80,r5
	    if	ls
	     cmpb h'9f,r5
	     if	hs
	      addr t_dovc,r1
	      movzbd r5,r4
	      subb (r1),r4
	      cmpb 1(r1),r4
	      if hi		;OK if hi
	       addr 2(r1)[r4:q],r1 ;Pointer to correct data block
	       movd (r1),r4	;Check count, could be 0
	       cmpqd 0,r4	;Already done if eq
	       if ne
	        bsr vc_more
	        movw dnx_cnt(r2),r0 ;Following characters
	       endif
	      endif
	     else
	      cmpb h'bf,r5
	      if hs
	       movqb 2,r0	;2nd byte of 13 bit character follows
	      endif
	     endif
	    endif
	   endif
	  endif
	  cmpqb	0,r0
	 orif	eq
	  movw	r0,dnx_cnt(r2)	;Keep going
	 endif
	endif
	restore [r0,r1,r2,r3,r4,r5]
	ret


;*****************
;* Trap routines *
;*****************

	disp	1

;-------------------------------------------
; Return absolute address of service routine
; R5 holds trap number
;-------------------------------------------

read_trp:
	save	[r1,r2]
	movzbd	r5,r5		;Trap index
	sprd	intbase,r1
	addr	r1[r5:d],r1	;Interrupt vector
	cond	cpu532
	 tbitb	cfg_de,m_config
	 if	fc
	cend
	  movzwd (r1),r5	;MOD table address
	  movd	8(r5),r5	;Base address
	  movzwd 2(r1),r2	;Offset from base
	  addd	r2,r5
	cond	cpu532
	 else
	  movd	(r1),r5
	 endif
	cend
	restore	[r1,r2]
	ret


;--------------------------------------
; Install trap vector, trap index in r5
; PC in r4, MOD in r2, PSR in r3
;--------------------------------------

instal_trp:
	save	[r0,r1,r2,r4,r5]
	movzbd	r5,r5		;Trap index
	movzwd	r2,r2
	sprd	intbase,r1
	addr	r1[r5:d],r1	;Interrupt vector
	cond	cpu532
	 tbitb cfg_de,m_config
	 if	fc		;No DE mode if FC
	cend
	  tbitb	log flag_u,r3	;Must be supervisor mode
	  if	fc
	   subd	8(r2),r4	;Offset from base
	   lshd	16,r4		;Move to upper bits
	   ord	r4,r2
	   movd	r2,(r1)
	  endif
	cond	cpu532
	 else
	  muld	tde_max,r5
	  addd	tde_vct,r5	;Base pointer to proper data block
	  movw	l'7fae,tde_jsr(r5) ;JSR @:d opcode
	  addr	to_traps:w,r0	;Assume supervisor
	  rotw	8,r0		;Swap lower 2 bytes
	  rotd	16,r0		;Exchange upper and lower words
	  rotw	8,r0		;Byte order reversed now
	  orb	h'c0,r0		;Make Dword displacement
	  movd	r0,tde_jsr+2(r5) ;JSR @TO_TRAPS installed
	  movd	r4,tde_dpc(r5)
	  movw	r2,tde_dmd(r5)
	  movw	r3,tde_dps(r5)
	  addr	tde_ssb(r5),tde_psb(r5) ;SB storage address
	  cinv	i,a,r0		;Opcode not written to instruction cache
	  movd	r5,(r1)		;Absolute address
	 endif
	cend
	restore	[r0,r1,r2,r4,r5]
	ret


;*****************************
;* Operating system commands *
;*****************************

;--------------------------------
; Initialize debugger entry point
;--------------------------------

opo_dbadr:
	tbitb	dc_dbgpc,r5	;R4 just holds PC if set
	if	fc		;Extended data in r4 if fc
	 movd	(r4),debug_pc
	 cond	not op_sys	;System provides MOD address
	  movw	4(r4),debug_mod
	 cend
	 movw	6(r4),debug_psr
	else			;Use default MOD, PSR
	 movd	r4,debug_pc
	 cond	not op_sys	;System provices MOD address
	  movw	4+4(fp),debug_mod
	 cend
	 cond	svc_cxp
	  movw	4+4+2(fp),debug_psr
	 celse
	  sprw	psr,debug_psr
	 cend
	endif
	movqd	0,r6
	ret


;--------------------------------------------
; Initialize trap vector for trap index in r5
; Data or data pointer in r4
;--------------------------------------------

opo_tpadr:
	cond	not debug
	 save	[r2,r3,r5]
	 movw	4+4(fp),r2	;Assume default MOD
	 tbitb	dc_trppc,r5	;PC only if fs
	 if	fc
	  movzwd 4(r4),r2	;Real MOD
	  movd	(r4),r4		;Real PC
	 endif
	 cond	svc_cxp
	  movzwd 4+4+2(fp),r3	;Calling routines PSR
	 celse
	  sprd	psr,r3
	 cend
	 bsr	instal_trp
	 restore [r2,r3,r5]
	 movqd	0,r6
	cend
	ret


;------------------------
; Return trapped SB in r5
; Only valid in DE mode
;------------------------

opo_trpsb:
	movzbd	tde_indx,r5	;Index of last trap
	muld	tde_max,r5	;Offset to Entry
	addd	tde_vct,r5	;Point to base address
	movd	tde_psb(r5),r5	;Pointer to SB
	movd	(r5),r5
	movqd	0,r6
	ret


;----------------------------
; Set trap SB pointer from r4
; Only valid in DE mode
;----------------------------

opo_sbptr:
	movzbd	r5,r6		;Index of trap
	muld	tde_max,r6	;Offset to Entry
	movd	r4,tde_psb(tde_vct)[r6:b] ;Store new address
	movqd	0,r6
	ret

	disp	2

;--------------
; Call debugger
;--------------

opo_prgd::
	movd	svc_r3,r3
	movd	svc_r6,r6
	movd	svc_r7,r7	;Restore registers
 	exit	[]		;Restore SP and FP
	cond	not svc_cxp
	 movw	(sp),tos
	 movd	4(sp),2(sp)	;Move everything down
	 sprw	psr,6(sp)	;Debugger wants PSR here
	cend			;Target registers set for debugger

;SVC environment now restored
;Fall through to ...

call_debug:
	cmpqd	0,debug_mod
	if	gt		;Not yet initialized if negative mod
	 save	[all]
	 cond	op_sys
	  movd	h'14000,r4	;80K for SB
	  movqd	0,r5		;Supervisor mode
	  bsr	opo_newbf:w
	  movd	r5,r4		;Save buffer address here
	  cmpqd	-1,r5		;Must be valid
	  if	eq		;Got a good table pointer in R5
	   bsr	opo_clrbf:w	;Release this now
	   restore [all]
	   movd	exp bstat_nr,r6	;Error code
	   br	svc_xit		;Return to calling application
	  else
	   cmpd	h'8000,4(r4)	;Need at least this much
	  orif	hi
	   bsr	opo_lonbf	;Locked
	   bsr	opo_uonbf	;In use
	   movqd 1,r5
	   bsr	get_mod:w	;Get mod table pointer in R5
	   cmpqd -1,r5		;No MOD available if eq
	  orif	eq
	   movd	r5,debug_mod	;MOD table pointer for debugger
	   movd 4(r4),r1	;Size of SB
	   movd (r4),r2		;SB address
	  endif
	 celse
	  movd	tbuf_adr,r2	;Debugger's heap
	  sprd	sb,r1
	  addd	-4(r1),r1	;Highest usable offset
	  subd	r2,r1		;Available memory
	 cend
	 movzwd	debug_mod,r0	;Debugger's mod table
	 movd	r0,debug_mod	;Validated positive value now
	 cond	svc_cxp
	  movqd 0,4(r0)		;No link table
	 celse
	  movd	r2,4(r0)	;Link block at start of heap
	  sprw	mod,(r2)	;MOD table for debug LINK table
	  movw	svc-svc,2(r2)	;Offset to SVC routine
	  addqd	4,r2
	  addqd	-4,r1
	 cend
	 addqd	-4,r1		;First 4 bytes are size
	 movd	r1,(r2)
	 addqd	4,r2		;First address for storage
	 movd	r2,(r0)		;Debugger's SB
	 movd	debug_pc,8(r0)	;Debugger starting address
	 movqd	0,12(r0)	;Unused
	 restore [all]
	endif

;Ready to enter debugger now

	movw	debug_psr,tos
	movw	debug_mod,tos	;Debugger's MOD
	movd	debug_pc,tos	;Address of debugger
	cond	svc_cxp and cpu532
	 lprw	mod,debug_mod	;Debugger's MOD
	 lprd	sb,(debug_mod)	;Debugger's SB
	cend
	rett

;End of SVC32
