	print	"SER32"

;--------------------
;Serial port routines
;--------------------

	disp	1

;-------------------------
; Serial 1 input interrupt
; Interrupt only for read
; Process XON/XOFF too
;-------------------------

int_s1i:
	save	[r2,r3,r4,r5,r7]
	movzbd	serial1,r5	;Read character
	movd	4*(dev_smk+1)(dev_ptr),r7 ;Base address
	movd	4*dof_int(r7),r4
	jsr	r4
	restore	[r2,r3,r4,r5,r7]
	reti


int_s2i:
	save	[r2,r3,r4,r5,r7]
	movzbd	serial2,r5	;Read character
	movd	4*(dev_pmk+1)(dev_ptr),r7 ;Base address
	movd	4*dof_int(r7),r4
	jsr	r4
	restore	[r2,r3,r4,r5,r7]
	reti


;R5 holds character from serial port
;Registers assumed saved by calling routine!!!

s1i_int:
s2i_int:
	movd	4*dof_bdat(r7),r3 ;Address of data block

	tbitb	bdp_xof,dat_ptcl(r3)
	if	fc		;No XOFF check if FC
	 movd	dat_bpt(r3),r2	;Buffer data block
	 movd	dat_bwtx(r3),r4 ;Write index
	 movb	r5,r2[r4:b]	;Store character just received
	 addqd	1,r4		;Increment pointer
	 andd	dat_bsz(r3),r4	;Wrap around as needed
	 movd	r4,dat_bwtx(r3)	;New data pointer
	 addqd	1,dat_bchr(r3)	;Increment character count
	else
	 cmpb	xoff,r5		;Check for XOFF
	 if	eq
	  movb	xon,dat_xoff(r3) ;Halt further transmissions until XON
	 else
	  cmpb	dat_xoff(r3),r5	;See if TX re-enabled
	  if	eq
	   movqb 0,dat_xoff(r3) ;Re-enable further TXing
	  endif
	 endif
	orif	ne		;Store if none of the above
	endif

	ret


;------------------------------------------------------
; Return software status of system message device in R6
; Character available if anything in buffer
;------------------------------------------------------

s1i_stat:
s2i_stat:
s1i_sst:
s2i_sst:
	movd	r3,tos

	movd	4*dof_bdat(r7),r3
	cmpqd	0,dat_bchr(r3)	;See if anything in buffer
	seqd	r6
	tbitb	bdp_eof,dat_ptcl(r3) ;Check for end of file
	if	fs
	 sbitb	bstat_ef,r6
	endif

	movd	tos,r3
	ret

	disp	1

;-------------------------------------------
; Process system message input command in R5
;-------------------------------------------

;------------
; Open device
;------------

s1i_copen:
	save	[r3,r4,r5]
	movd	4*dof_bdat(r7),r3
	movqd	0,r6		;Assume OK
	tbitb	bdp_bin,dat_ptcl(r3)
	if	fs
	 movd	4*dof_dat(r7),r5
	 movd	dat_ptcl(r3),dat_ptcl(r5) ;Save original here
	 movqd	0,r4		;No extra storage
	 bsr	nlo_cinstnc	;Create new instance
	 cmpqd	0,r6
	 if	eq
	  movd	r5,r7		;New r7 now
	  movd	4*dof_bdat(r7),r4
	  movd	4*dof_dat(r7),r3 ;May be changed by cinstnc
	  addr	xmi_sst:w,4*dof_sst(r7) ;XMODEM routine
	  cbitb	bdp_xof,dat_ptcl(r4) ;No XOFF now
	  sbitb	bdp_xmo,dat_ptcl(r4)
	  movqw	0,dat_xmich(r3)	;XMODEM input character counter
	  movqw	0,dat_xmoch(r3)	;XMODEM output character counter
	  movqd	0,dat_xmblk(r3)	;XMODEM block number
	  movzbd svc_r6,r5	;Index
	  movd	r7,(dev_ptr)[r5:d] ;Install altered block
	 endif
	endif
	cmpqd	0,r6		;Continue if OK so far
	if	eq
	 bsr	nli_copen
	endif
	restore	[r3,r4,r5]
	ret


;-------------
; Close device
;-------------

s1i_cclose:
	save	[r3,r5,r6]
	bsr	nli_cclose
	movd	4*dof_bdat(r7),r3
	cbitb	bdp_xmo,dat_ptcl(r3)
	if	fs
	 bsr	nlo_cunvct	;Restore
	endif
	movd	4*dof_bdat(r7),r3 ;R7 may have changed by unvct
	movd	4*dof_dat(r7),r5
	movd	dat_ptcl(r5),dat_ptcl(r3) ;Restore original
	cond	not op_sys
	 sbitb	bdp_xof,dat_ptcl(r3) ;Xmodem turns this off
	cend
	cbitb	bdp_bin,dat_ptcl(r3) ;Disable binary transfers
	cbitb	bdp_eof,dat_ptcl(r3) ;Serial device is always open
	restore	[r3,r5,r6]
	ret


;---------
; Send XON
;---------

s1i_on:
	save	[r3,r4,r5]
	movd	4*dof_bdat(r7),r3
	tbitb	bdp_xof,dat_ptcl(r3) ;Check for XOFF protocol
	if	fs
	 movd	4*dof_dat(r7),r3
	 movzbd	dat_io(r3),r6
	 orw	dof_io lsh b_iosrv,r6
	 movzbd	xon,r5
	 bsr	bsr_svc		;Send character
	endif
	restore [r3,r4,r5]
	ret

s1i_off:
	save	[r3,r4,r5]

	movd	4*dof_bdat(r7),r3
	tbitb	bdp_xof,dat_ptcl(r3) ;Check for XOFF protocol
	if	fs		;Only if XMODEM
	 movd	4*dof_dat(r7),r3
	 movzbd	dat_io(r3),r6
	 orw	dof_io lsh b_iosrv,r6
	 movzbd	xoff,r5
	 bsr	bsr_svc		;Send character
	endif

	restore	[r3,r4,r5]
	ret


nli_ceof:
	save	[r3,r4,r5]
	movd	4*dof_bdat(r7),r3
	tbitb	bdp_bin,dat_ptcl(r3) ;Check for binary file
	if	fs
	 tbitb	bdp_eof,dat_ptcl(r3)
	 if	fc		;Only if not already done
	  begin
	   movd	4*dof_sst(r7),r4
	   jsr	r4
	   tbitb bstat_ef,r6
	  while	fc
	   movd	4*dof_sio(r7),r4
	   jsr	r4		;Pick up any stray characters to close file
	  endw
	 endif
	endif
	sbitb	bdp_eof,dat_ptcl(r3)
	restore [r3,r4,r5]
	ret

	disp	2

;----------------------------------------------
; R1 holds raw _sio input, r0 holds byte length
; Translate to _chr input, new length in r0
; R6=0 if xlat complete or not needed
; If length is too short, r6=bstat_nr
;----------------------------------------------

s1i_cxlat:
	movqd	0,r6		;Assume OK
	save	[r2,r5]
	movb	h'80+vcw_chr+vcw_del+vcw_lft,r5
	cmpb	h'7f,r1		;Delete (destructive backspace)
	if	eq
	 movzbd r5,r1
	 rotw	8,r1
	 movb	vc_win,r1
	 movqd	2,r0
	else
	 cond	not kbdansi
	  movb	h'80+vcw_chr+vcw_mov+vcw_lft,r5 ;Non-destructive
	 cend
	 cmpb	ctrl_h,r1	;Backspace
	orif	eq
	cond	kbdansi
	 cmpb	esc,r1
	 if	eq
	  cmpqb 3,r0
	  if	hi
	   sbitb bstat_nr,r6	;Need more characters
	  else
	   cmpw "[" lsh 8+esc,r1
	   if	eq
	    movd r1,r2
	    lshd -16,r2
	    movb h'80+vcw_chr+vcw_mov+vcw_up,r5
	    cmpb "A",r2		;Cursor up
	    if ne
	     movb h'80+vcw_chr+vcw_mov+vcw_dn,r5
	     cmpb "B",r2	;Down
	     if ne
	      movb h'80+vcw_chr+vcw_mov+vcw_rt,r5
	      cmpb "C",r2	;Right
	      if ne
	       movb h'80+vcw_chr+vcw_mov+vcw_lft,r5
	       cmpb "D",r2	;Left
	      endif
	     endif
	    endif
	   endif
	  endif
	 endif
	orif	eq
	celse
	 movb h'80+vcw_chr+vcw_mov+vcw_up,r5
	 cmpb ctrl_e,r1
	orif	eq
	 movb h'80+vcw_chr+vcw_mov+vcw_dn,r5
	 cmpb ctrl_x,r1
	orif	eq
	 movb h'80+vcw_chr+vcw_mov+vcw_rt,r5
	 cmpb ctrl_d,r1
	orif	eq
	 movb h'80+vcw_chr+vcw_ins+vcw_rt,r5
	 cmpb ctrl_v,r1
	orif	eq
	 movb h'80+vcw_chr+vcw_del+vcw_rt,r5
	 cmpb ctrl_g,r2
	orif	eq
	cend
	endif
	restore	[r2,r5]
	ret

	disp	1

;-----------------------------------------------
; Return line of input in (R1) according to R0
; R5 holds termination character if any
; Termination actually acted on returned in R5
; Tabs treated as spaces if editing, LFs ignored
; If input length = -1, then infinite
;-----------------------------------------------

nli_blk:
	save	[r1,r2,r3,r4]
	adjspb	5*4
	mode	sp,5*4		;Need storage on stack without FP change
srx_stat: blkd			;Original status bits
srx_echo: blkd			;Echo routine calls this
srx_edit: blkd			;Edit routine calls this
srx_reg1: blkd			;Storage for original r1
srx_max: blkd			;Storage for max number of characters

	mode	pc
	addr	(sp),r2		;Data pointer

	movd	r0,srx_stat(r2)
	movd	r1,srx_reg1(r2)	;Save original registers

	movqd	-1,r3		;No termination
	movd	4*dof_chr(r7),r4 ;Default read routine
	tbitb	bkb_bin,r0
	if	fs
	 movd	4*dof_sio(r7),r4 ;Sio/sst routines with eof check
	endif
	movd	r4,srx_echo(r2)	;Default echo service routine
	movd	r4,srx_edit(r2) ;Edit always calls this

	disp	2

	tbitb	bkb_28,r0	;Check for extended termination count
	if	fs
	 bicd	h'f0000000,r0
	 movd	exp bkb_cnt,srx_stat(r2) ;Terminate on count only
	else
	 tbitb	bkb_eko,r0
	 if	fs
	  addr	chri_echo:w,r4	;Call this if echo required
	 endif
	 tbitb	bkb_edt,r0
	 if	fs
	  addr	chri_edit:w,srx_echo(r2) ;Echo routine calls this
	 endif

	 tbitb	bkb_tr5,r0
	 if	fs
	  movd	r5,r3		;Termination character
	 endif

	 movzwd	r0,r0		;Max input length
	 cmpqw	-1,r0
	 if	eq
	  movd	h'7fffffff,r0	;Max positive value
	 endif

	 tbitb	bkb_tr5,srx_stat(r2)
	 if	fs
	  addqd	-1,r0		;Save room for termination
	 else
	  tbitb	bkb_edt,srx_stat(r2)
	  if	fs
	   tbitb bkb_ret,srx_stat(r2)
	   if	fc
	    tbitb bkb_esc,srx_stat(r2)
	   endif
	  endif
	 orif	fs
	 endif
	endif

	disp	1

	movd	r0,srx_max(r2)	;Max input length
	until	eq
	 jsr	r4		;Get a character
	 cmpqd	0,r6		;See if successful
	quit	ne		;Error or end of file if ne
	 movb	r5,(r1)		;Store it
	 addqd	-1,r0
	 addqd	1,r1
	 cmpd	r5,r3
	 if	ne
	  cmpqd	0,r0
	  if	ge
	   cmpb	r0,r0		;Make eq in case terminating on 0 count
	   tbitb bkb_cnt,srx_stat(r2) ;See if termination required on count
	   if	fc
	    movqd 0,r0
	    addqd -1,r1		;Can't input past max length
	    bicpsrb flag_z	;Clear 0 flag
	   endif
	  endif
	 endif
	endu
	negd	r0,r0
	addd	srx_max(r2),r0	;Actual number of bytes entered

	tbitb	bkb_edt,srx_stat(r2)
	if	fc
	 tbitb	bkb_hlt,srx_stat(r2) ;See if XOFF required at end
	 if	fs
	  movd	r5,tos
	  movd	dc_off,r5
	  bsr	do_cmd
	  movd	tos,r5
	 endif
	endif

	tbitb	bkb_cnv,srx_stat(r2) ;Get conversion status
	if	fs		;LC to UC conversion if fs
	 save	[r0,r1]
	 movd	srx_reg1(r2),r1	;Original r1
	 begin
	  cmpqd	0,r0
	 while	ne
	  movb	(r1),r4
	  cmpb	"a",r4
	  if	ls
	   cmpb	"z",r4
	   if	hs
	    cbitb 5,(r1)	;Convert to upper case
	   endif
	  endif
	  addqd	1,r1
	  addqd	-1,r0		;Backup one character
	 endw
	 restore [r0,r1]
	endif

	adjspb	-5*4
	restore	[r1,r2,r3,r4]
	movqd	0,r6		;Success
	ret


;-----------------------------------------
; Load r6 with echo device character index
;-----------------------------------------

echo_dev:
	movd	r3,tos
	movd	4*dof_dat(r7),r3 ;Data pointer
	movzbd	dat_kv(r3),r6
	orw	dof_chr lsh b_iosrv,r6
	movd	tos,r3
	ret


;---------------------
; Echo character in r5
;---------------------

echo_r5:
	bsr	echo_dev
	bsr	bsr_svc		;Echo character
	ret
	 
	 
;--------------------------
; Echo character in r5
; Must be displayable ASCII
;--------------------------

echo_asc:
	save	[r3,r4,r5,r6]
	movd	r5,r4		;Character to display
	bsr	echo_dev
	movzbd	b_iosrv,r3
	insb	r3,dof_cmd,r6,8
	movd	dc_dspasc,r5
	bsr	bsr_svc		;Display as ASCII
	restore [r3,r4,r5,r6]
	ret
	

;-------------------------------------
; Read a character and echo it
; srx_echo(r2) holds routine
; r3 holds termination value
; Cursor always kept within edit field
;-------------------------------------

chri_echo:
	save	[r3,r4]
	movd	srx_echo(r2),r4
	jsr	r4
	cmpqd	0,r6		;Success if eq
	if	eq
	 cmpd	r5,r3		;See if termination
	 if	eq
	  tbitb	bkb_ekt,srx_stat(r2)
	  if	fs		;Echo actual character if fs
	   bsr	echo_r5
	  endif
	 else
	  bsr	echo_asc	;Echo displayable character
	 endif
	 movd	srx_reg1(r2),r3
	 addd	srx_max(r2),r3
	 addqd	-1,r3		;Last possible character position
	 cmpd	r1,r3
	 if	eq
	  tbitb	bkb_edt,srx_stat(r2) ;See if editing enabled
	  if	fs
	   movd	r5,tos
	   movzbd ctrl_h,r5
	   bsr	echo_r5		;Keep cursor within edit field
	   movd	tos,r5
	  endif
	 endif
	endif
	restore	[r3,r4]
	ret
	
	
;------------------------------------------
; Get character from srx_edit(r2)
; Check for and process editing characters
; Termination character in r3, if found:
;   R1 adjusted to point to end of entry
; If not appending to string:
;   R0 incremented to cancel next decrement
;------------------------------------------

	disp	2

chri_edit:
	save	[r3,r4]
	movd	srx_edit(r2),r4	;Receive routine
	until	ne
	 jsr	r4
	 cmpqd	0,r6
	 if	eq		;Error or end of file if ne
	  bicpsrb flag_f
	  cmpb	cr,r5
	  if	eq
	   tbitb bkb_ret,srx_stat(r2)
	  endif
	  if	fs
	   negd r0,r1
	   addd srx_max(r2),r1	;Number of bytes entered previously
	   addd srx_reg1(r2),r1 ;Termination always goes at end
	   bicpsrb flag_z	;Make ne to quit loop
	  else
	   cmpb	esc,r5
	   if	eq
	    tbitb bkb_esc,srx_stat(r2)
	    if	fs
	     movd srx_max(r2),r0 ;Clear entry
	    endif
	   endif
	  orif	fs
	   cmpd	r5,r3		;Check for termination character
	  orif	eq
	   cmpb	lf,r5		;Ignore this
	   if	ne
	    cmpb tab,r5
	    if	eq
	     movb " ",r5	;Tabs treated as spaces here
	     bicpsrb flag_z	;Make ne
	    else
	     cmpb vc_win,r5	;Check for window command
	     if eq
	      jsr r4		;Fetch next command
	      save [r0,r1,r4]
	      addr rxed1-1,r1	;Address of last character to check
	      movzbd rxed1-rx_eds1,r0 ;Number of characters to search
	      movzbd r5,r4	;Character to look for
	      skpsb b,u
	      movd r0,r5	;Index to R5
	      restore [r0,r1,r4]
	      if fs		;Keeper if fs
	       addqd -1,r5	;Start offset from 0
	       bsr edit_sub	;Do command
	      endif
	      cmpb r5,r5	;Make eq to stay in loop
	     endif
	    endif
	   endif
	  endif
	 endif
	endu
	negd	r0,r3
	addd	srx_max(r2),r3	;Number of bytes entered previously
	movd	r1,r4
	subd	srx_reg1(r2),r4 ;Last entered character + 1
	cmpd	r4,r3
	if	lo
	 cmpqd	0,r0		;Can't be at last character
	 if	lt
	  bsr	rxed05		;Always insert if not appending
	  addqd	1,r0		;Not appending, r0 should stay same
	 endif
	endif
	restore	[r3,r4]
	ret

	disp	1

;----------------------
; Destructive backspace
;----------------------

rxed7f:
	save	[r3,r5]
	negd	r0,r3
	addd	srx_max(r2),r3	;Number of bytes entered previously
	movd	r1,r5
	subd	srx_reg1(r2),r5 ;Last entered character + 1
	cmpd	r5,r3
	if	lo
	 bsr	rxed18:w	;Not at end, use delete routine
	else
	 cmpd	srx_reg1(r2),r1	;Can't backup if at beginning
	 if	lo
	  bsr	echo_dev
	  bsr	win_outs:w
	  db	bksp," ",bksp,0
	  addqd	1,r0		;One less entry
	  addqd	-1,r1		;Backup pointer too
	 endif
	endif
	restore [r3,r5]
	ret


;---------------------------------
; Edit command index in r5 - do it
;---------------------------------

edit_sub:
	casew	rxed1[r5:w]
rx_eds1:
	db	h'80+vcw_chr+vcw_mov+vcw_rt
	db	h'80+vcw_chr+vcw_mov+vcw_lft
	db	h'80+vcw_chr+vcw_ins+vcw_rt
	db	h'80+vcw_chr+vcw_del+vcw_rt
	db	h'80+vcw_chr+vcw_del+vcw_lft
rxed1:
	dw	rxed04-edit_sub	;Cursor right
	dw	rxed08-edit_sub	;Cursor left (non-destructive)
	dw	rxed05-edit_sub	;Insert right
	dw	rxed18-edit_sub	;Delete right
	dw	rxed7f-edit_sub	;Delete left

;---------------
; Advance cursor
;---------------

rxed04:
	save	[r3,r4,r5]
	negd	r0,r3
	addd	srx_max(r2),r3	;Number of bytes entered previously
	movd	r1,r4
	subd	srx_reg1(r2),r4 ;Last entered character + 1
	cmpd	r4,r3
	if	lo
	 cmpqd	0,r0		;Can't be at last character
	 if	lt
	  movzbd (r1),r5	;Current character
	  bsr	echo_asc	;Redisplay current character to advance
	  addqd	1,r1		;Advance pointer
	 endif
	endif
	restore	[r3,r4,r5]
	ret


;-----------------------------
; Cursor left, non-destructive
;-----------------------------

rxed08:
	cmpd	srx_reg1(r2),r1	;Must be beyond beginning
	if	lo
	 movd	r5,tos
	 movzbd	bksp,r5
	 bsr	echo_r5
	 addqd	-1,r1		;Backup pointer
	 movd	tos,r5
	endif
	ret


;----------------------------------
; Display string in r1, count in r0
; Original cursor position restored
; R1, r0 altered
;----------------------------------

chri_dsp:
	movd	r5,tos
	movd	r0,tos
	begin
	 cmpqd	0,r0
	while	ne
	 movzbd	(r1),r5
	 bsr	echo_asc
	 addqd	1,r1
	 addqd	-1,r0
	endw
	movd	tos,r0
	begin
	 cmpqd	0,r0
	while	ne
	 movzbd	bksp,r5
	 bsr	echo_r5
	 addqd	-1,r0
	endw

	movd	tos,r5
	ret

;---------------
; Insert a space
;---------------

rxed05:
	save	[r3,r4,r5]
	negd	r0,r3
	addd	srx_max(r2),r3	;Number of bytes entered previously
	movd	r1,r4
	subd	srx_reg1(r2),r4 ;Last entered character + 1
	cmpd	r4,r3
	if	lo
	 cmpqd	0,r0		;Must be room
	 if	lt
	  save	[r0,r1,r2]
	  movd	r3,r0		;Total characters entered
	  subd	r4,r0		;Number of characters after this one
	  movd	srx_reg1(r2),r2	;Start of entry
	  addd	r3,r2		;Last character + 1 (target address)
	  addr	-1(r2),r1	;Source address
	  movsb	b
	  restore [r0,r1,r2]

	  save	[r0,r1]
	  movb	" ",(r1)	;Space to stored string
	  movd	r3,r0
	  subd	r4,r0
	  addqd	1,r0		;Number of characters to redisplay
	  bsr	chri_dsp
	  restore [r0,r1]
	  addqd -1,r0		;One more character
	 endif
	endif
	restore	[r3,r4,r5]
	ret


;-------------------------
; Delete current character
;-------------------------

rxed18:
	save	[r3,r4,r5]
	negd	r0,r3
	addd	srx_max(r2),r3	;Number of bytes entered previously
	movd	r1,r4
	subd	srx_reg1(r2),r4 ;Last entered character + 1
	cmpd	r4,r3
	if	lo		;Must be before end
	 save	[r0,r1,r2]
	 movd	r3,r0		;Total characters entered
	 subd	r4,r0
	 addqd	-1,r0		;Number of characters after this one
	 movd	r1,r2		;Target address
	 addqd	1,r1		;Source address
	 movsb
	 movb	" ",(r2)	;Clear last character
	 restore [r0,r1,r2]
	 save	[r0,r1]
	 movd	r3,r0
	 subd	r4,r0		;Display to end of string and trailing blank
	 bsr	chri_dsp
	 restore [r0,r1]
	 addqd	1,r0		;One less character
	endif
	restore	[r3,r4,r5]
	ret


;******************
; Output routines *
;******************

;Return output status in R6

s1o_stat:
	movqd	0,r6		;Assume OK
	tbitb	4,serial1+6*bus_byts ;Check CTS input
	if	fc		;Possible hold if fc
	 movd	r3,tos
	 movd	4*dof_bdat(r7),r3
	 tbitb	bdp_cts,dat_ptcl(r3) ;Check for RTS/CTS protocol
	 if	fs		;On hold if fs
	  sbitb bstat_xf,r6
	 endif
	 movd	tos,r3
	endif
	tbitb	5,serial1+5*bus_byts
	if	fc		;Character ready if fs
	 sbitb	bstat_rd,r6	;Not ready
	endif
	ret

;Return output status in R6

s2o_stat:
	movqd	0,r6		;Assume OK
	tbitb	4,serial2+6*bus_byts ;Check CTS input
	if	fc		;Possible hold if fc
	 movd	r3,tos
	 movd	4*dof_bdat(r7),r3
	 tbitb	bdp_cts,dat_ptcl(r3) ;Check for RTS/CTS protocol
	 if	fs		;On hold if fs
	  sbitb bstat_xf,r6
	 endif
	 movd	tos,r3
	endif
	tbitb	5,serial2+5*bus_byts
	if	fc		;Character ready if fs
	 sbitb	bstat_rd,r6	;Not ready
	endif
	ret


;----------------------------------------------------------
; Tranmsit a character to device 0
; R5 holds character, R7 holds base address of device block
;----------------------------------------------------------

s1o_io:
	movd	r4,tos
	movd	4*dof_stat(r7),r4 ;Address of interpreter routine
	until	eq
	 jsr	r4		;Get status in R5
	 cmpqd	0,r6
	endu
	movd	tos,r4
	movb	r5,serial1
	ret


;----------------------------------------------------------
; Tranmsit a character
; R5 holds character, R7 holds base address of device block
;----------------------------------------------------------

s2o_io:
	movd	r4,tos
	movd	4*dof_stat(r7),r4 ;Address of interpreter routine
	until	eq
	 jsr	r4		;Get status in R5
	 cmpqd	0,r6
	endu
	movd	tos,r4
	movb	r5,serial2
	ret


s1o_sst:
s2o_sst:
	save	[r3,r4]

;Check Receiver for XOFF

	movd	4*dof_dat(r7),r3 ;Data pointer
	movqd	0,r6		;OK if no XOFF check
	movd	4*dof_bdat(r7),r4
	tbitb	bdp_xof,dat_ptcl(r4)

	if	fs
	 movzbd	dat_kv(r3),r4
	 movd	(dev_ptr)[r4:d],r4
	 movd	4*dof_bdat(r4),r4 ;Corresponding input device
	 cmpqb	0,dat_xoff(r4)	;NE if transmission on hold
	 sned	r6		;Not ready if NE
	 lshd	bstat_xf,r6
	endif

	movd	r6,r3		;XOFF status
	movd	4*dof_stat(r7),r4
	jsr	r4
	ord	r3,r6

	restore	[r3,r4]
	ret


s1o_sio:
s2o_sio:
	save	[r4]
	movd	4*dof_sst(r7),r4 ;Address of status routine
	until	eq
	 jsr	r4		;Get status in R6
	 cmpqd	0,r6
	endu
	movd	4*dof_io(r7),r4
	jsr	r4
	restore [r4]
	ret


;--------------------------------------
; Send character from R5
; R7 holds base address of device block
;--------------------------------------

s2o_chr:
s1o_chr:
	save	[r0,r1,r2,r3,r4,r5]

	bsr	nlo_chrbsy	;Process busy bits and store if command
	cmpqd	0,r6
	if	ne		;Not processed if ne
	 movd	4*dof_dat(r7),r3
	 movd	4*dof_sio(r7),r4 ;Address of output routine
	 cmpw	h'80,r5
	 if	hi
	  bsr	s1o_upd:w	;System update routine
	  jsr	r4
	 else
	  cmpw	h'c0,r5		;Alternate characters
	 orif	ls
	  cmpb	h'9f,r5		;Max command
	  if	hs		;Command if hs
	   bsr	do_vc
	  else			;Upper bits of 13 bit character
	   addr	t_chr13b,r1
	   bsr	vc_more		;Prepare for extended 13 bit character
	  endif
	  movqd	0,r6		;Success
	 endif
	endif
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-------------------------------------------------
; Video control (h'80-h'9f) routines
; Assume: r3=dof_dat, r2=> command string, r4=_sio
;-------------------------------------------------

;Process 13 bit extended character

chr13bit:
	movzwd	(r2),r5		;Extended character
	rotw	8,r5		;Swap bytes
	andw	h'1fff,r5	;Clear extraneous bits
	bsr	nlo_cmdoff	;Clear command mode
	br	s1o_chr		;Output 13 bit character now


;------------------------------
; Take next character literally
;------------------------------

lit_vc:
	movzbd	1(r2),r5	;Send as is
	jsr	r4
	ret


;---------------
; Set attributes
;---------------

sat_vc:
	movzbd	1(r2),r5

;Fall through to ...

;---------------------
; Set attributes in r5
;---------------------

sat_vc1:
	movd	r3,tos
	movd	4*dof_dat(r7),r3
	orw	r5,dat_vca(r3)	;Set new attributes
	movd	tos,r3

;Fall through to ...

;------------------------------------
; Set attributes according to dat_atr
;------------------------------------

sat_vc2:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movzwd	dat_vca(r3),r4
	movd	dc_atr,r5
	bsr	do_cmd
	restore	[r3,r4,r5]
	ret


;-----------------
; Clear attributes
;-----------------
cat_vc:
	movzbd	1(r2),r5

;Fall through to ...

;-----------------------
; Clear attributes in r5
;-----------------------

cat_vc1:
	movd	r3,tos
	movd	4*dof_dat(r7),r3
	bicw	r5,dat_vca(r3)	;Set new attributes
	movd	tos,r3
	br	sat_vc2


;------------------
; Toggle attributes
;------------------

tat_vc:
	movzbd	1(r2),r5

;Fall through to ...

;------------------------
; Toggle attributes in r5
;------------------------

tat_vc1:
	movd	r3,tos
	movd	4*dof_dat(r7),r3
	xorw	r5,dat_vca(r3)	;Set new attributes
	movd	tos,r3
	br	sat_vc2


;------------------------------------------------------------------------
; Horizontal tab to given character position, space once if already there
;------------------------------------------------------------------------

tab_vcs:
	movzbd	2(r2),r5	;Requested horizontal position
	bsr	nlo_cmdoff	;Clear command mode

;Fall through to ...

;---------------------------------------------------
; Tab to position in r5, space once if already there
;---------------------------------------------------

tab_vcs1:
	save	[r1,r3,r4,r5]
	movd	r5,r1
	movd	4*dof_dat(r7),r3
	movd	4*dof_chr(r7),r4

	movzwd	dat_col(r3),r5
	bsr	pix2chr
	subw	r5,r1		;Number of spaces to advance
	cmpqw	0,r1
	if	ge		;Just space once if at or past address
	 movqd	1,r1
	endif
	movzbd	" ",r5
	until	eq
	 jsr	r4
	 addqd	-1,r1
	 cmpqd	0,r1
	endu
	restore	[r1,r3,r4,r5]
	ret


;--------------------------------------
; Drop down one line if not in column 0
;--------------------------------------

nln_vcs:
	bsr	nlo_cmdoff	;Clear command mode
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	cmpqw	0,dat_col(r3)
	if	ne
	 movd	4*dof_chr(r7),r4
	 movzbd	cr,r5
	 jsr	r4
	 movzbd	lf,r5
	 jsr	r4
	endif
	restore	[r3,r4,r5]
	ret


;----------------------
; Clear screen/new page
;----------------------

cls_vcs:
	save	[r3,r5]
	movd	dc_cls,r5
	bsr	do_cmd
	movd	4*dof_dat(r7),r3
	movqw	0,dat_col(r3)
	movqw	0,dat_line(r3)
	addqw	1,dat_page(r3)
	restore	[r3,r5]
	ret


;----------------
; Position cursor
;----------------

cur_vcs:
	movzbw	3(r2),r4	;Row
	lshd	16,r4		;Move to upper bits
	movzbw	2(r2),r4	;Column

;Fall through to ...

;-------------------------------------------------
;Position cursor to character column and row in r4
;-------------------------------------------------

nlo_csetchr:
	save	[r4,r5]
	movd	r4,r5
	bsr	chr2pix		;Convert to pixel coordinates
	movd	r5,r4
	bsr	nlo_csetxy:w
	restore	[r4,r5]
	ret


;---------------------------------------
; Set new relative character coordinates
; Add r4 to current value (no wrap)
;---------------------------------------

nlo_crelchr:
	save	[r4,r5]
	movd	r4,r5
	bsr	chr2pix		;Convert to pixel coordinates
	movd	r5,r4
	bsr	nlo_crelxy:b
	restore	[r4,r5]
	ret


;--------------------------------------
; Set new relative xy pixel coordinates
; Add r4 to current value (no wrap)
;--------------------------------------

nlo_crelxy:
	save	[r2,r3,r4]
	movd	4*dof_dat(r7),r3
	movd	4*dof_vdat(r7),r2
	addw	dat_col(r3),r4	;Requested new position
	cmpw	vdt_minc(r2),r4
	if	gt
	 movw	vdt_minc(r2),r4	;Don't go below this
	endif
	cmpw	vdt_maxc(r2),r4
	if	lo
	 movw	vdt_maxc(r2),r4
	endif
	rotd	16,r4
	addw	dat_line(r3),r4
	cmpw	vdt_minl(r2),r4
	if	gt
	 movw	vdt_minl(r2),r4	;Don't go below this
	endif
	cmpw	vdt_maxl(r2),r4
	if	lo
	 movw	vdt_maxl(r2),r4
	endif
	rotd	-16,r4		;Column mustn't carry into row

	bsr	nlo_csetxy:b
	restore	[r2,r3,r4]
	ret


;----------------------------------
; Position cursor by pixel position
;----------------------------------

pix_vcs:
	movd	2(r2),r4	;New pixel position

;Fall through to ...

;--------------------------------------
; Set cursor to pixel xy position in r4
;--------------------------------------

nlo_csetxy:
	save	[r1,r3,r4]
	movd	4*dof_dat(r7),r3
	movd	4*dof_vdat(r7),r1 ;Vdat pointer
	cmpqw	0,r4		;Offset from right if negative
	if	gt
	 addw	vdt_maxc(r1),r4	;Adjusted value
	 addqw	1,r4
	endif
	cmpw	vdt_maxc(r1),r4
	if	hs
	 movw	r4,dat_col(r3)	;Store new column
	endif
	lshd	-16,r4		;Row to bits 0-15
	cmpqw	0,r4		;Offset from bottom if negative
	if	gt
	 addw	vdt_maxl(r1),r4	;Adjusted value
	 addqw	1,r4
	endif
	cmpw	vdt_maxl(r1),r4	;Can't be larger than max
	if	hs
	 movw	r4,dat_line(r3)	;Store new row
	endif
	restore	[r1,r3,r4]

;Fall through to ...

;------------------------------------
; Position cursor to dat_col, dat_row
;------------------------------------

cur_pix2:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_col(r3),r4	;Column, row
	movd	dc_cur,r5
	bsr	do_cmd
	restore	[r3,r4,r5]
	ret	


;--------------------------------------------
; Set window pixel size and upper left corner
;--------------------------------------------

win_vcs:
	save	[r3]
	movd	4*dof_vdat(r7),r3
	movd	2(r2),vdt_minc(r3)
	movd	6(r2),vdt_maxc(r3)
	subd	10001h,vdt_maxc(r3) ;Need max relative value here
	restore	[r3]

;Fall through to ...

;----------------------------------------------------------------
; Set current window parameters according to dof_dat and dof_vdat
;---------------------------------------------------------------- 

set_wndw:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_vdat(r7),r2 ;Vdat pointer
	movd	4*dof_dat(r7),r3 ;Pointer to data field
	movd	4*dof_sio(r7),r4
	movd	vdt_minc(r2),r5
	bsr	pix2chr
	movd	r5,r0		;Upper left character col/row
	movd	vdt_maxc(r2),r5
	bsr	pix2chr
	movd	r5,r1		;Max relative col/row

	cond	videxec
	 bsr	tx_vcod
	 db	esc,122," "+1,0	;Define window 1
	 movd	r0,r5		;Starting row
	 lshd	-16,r5
	 addb	" ",r5
	 jsr	r4
	 movzbd	r0,r5		;Starting column
	 addb	" ",r5
	 jsr	r4
	 movd	r0,r5		;Starting row
	 addd	r1,r5		;Actual last row
	 lshd	-16,r5
	 addb	" ",r5		;Actual last row + offset
	 jsr	r4
	 movzbd	r0,r5		;Starting column
	 addb	r1,r5		;Actual last column
	 addb	" ",r5		;Actual last column + offset
	 jsr	r4
	cend
	cond	vid340
	 bsr	tx_vcod
	 db	vc_scr,vcs_win,0
	 movd	vdt_minc(r2),r1
	 movqd	4,r0
	 bsr	nlo_r1
	 movd	vdt_maxc(r2),r1
	 addd	10001h,r1	;Dimensions
	 bsr	nlo_r1
	cend
	cond	vidansi
	 bsr	tx_vcod
	 db	esc,"[",0
	 movd	r0,r5		;Min. line to R5
	 lshd	-16,r5
	 addqb	1,r5		;Start with 1
	 bsr	tx_asci
	 movzbd	";",r5
	 jsr	r4
	 movd	r0,r5
	 addd	r1,r5		;Max row number
	 lshd	-16,r5
	 addqb	1,r5
	 bsr	tx_asci
	 movzbd	"r",r5		;Cursor ends up at 0,0
	 jsr	r4
	cend

	bsr	cur_pix2	;Set cursor position
	bsr	sat_vc2		;Also restore window's attributes
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-----------------------------------------
; Set cursor size/type
; Bit 7 set = flash
; Bit 6 set = text cursor, bits 0-5 = size
; Bit 6 clear => bits 0-5 are cursor type
;-----------------------------------------

crsr_vcs:
	cond	vid340
	 save	[r0,r1]
	 movd	2(r2),r1
	 movqd	3,r0
	 bsr	nlo_r1
	 restore [r0,r1]
	cend
	ret


;*******************************************
;* System message output command processor *
;*******************************************

;---------------------------------------------------------
; R2 holds base address of serial port, R4 holds baud rate
;---------------------------------------------------------

set_ser:
	save	[r1]
	movqb	0,bus_byts(r2)	;Interrupts off
	movd	2*bd_rate,r1
	divd	r4,r1
	addqd	1,r1		;Add .5 to round to nearest value
	lshd	-1,r1		;Divide by 2
	movb	h'80,3*bus_byts(r2) ;Set divisor latch bit
	movb	r1,(r2)		;LSB of baud rate
	rotw	-8,r1
	movb	r1,bus_byts(r2)	;MSB of baud rate
	movqb	3,3*bus_byts(r2) ;8 bits, one stop, no parity, DLAB off
	movb	4*bus_byts(r2),r1 ;/DTR, /RTS, /OUT1 register
	orb	3,r1		;/DTR, /RTS low
	movb	r1,4*bus_byts(r2) ;Don't change /OUT1
	movqb	1,2*bus_byts(r2) ;Enable FIFO if 16550
	cmpqb	0,(r2)		;Read receive buffer to clear it
	movqb	1,bus_byts(r2)	;Receive interrupt only
	restore [r1]
	ret


;--------------------------------
; Set baud rate for serial port 1
; R4 holds new baud rate
;--------------------------------

s1o_baud:
	save	[r2]
	addr	serial1,r2
	bsr	set_ser
	restore [r2]
	movqd	0,r6		;Success
	ret


;--------------------------------
; Set baud rate for serial port 2
; R4 holds new baud rate
;--------------------------------

s2o_baud:
	save	[r2]
	addr	serial2,r2
	bsr	set_ser
	restore [r2]
	movqd	0,r6		;Success
	ret


;Baud rate table

t_baud:	dd	115200
	dd	57600
	dd	38400
	dd	28800
	dd	19200
	dd	9600
	dd	7200
	dd	4800


;--------------------------
; Initialize window storage
;--------------------------

win_init:
	save	[r3,r4,r5]
	movd	4*dof_bdat(r7),r3
	cond	op_sys
	 movd	r7,r4
	celse
	 extsd	dat_ptcl+bdp_win/8(r3),r4,bdp_win mod 8,3
	cend
	bsr	s1o_cputr7:w	;Switch to same window to initialize it
	restore [r3,r4,r5]
	ret
	

;-------------------------
; Initialize serial port 1
;-------------------------

s1o_cinit:
	save	[r3,r4,r5]

	cond	cg16_edb
	 movzbd	h'14,r5
	celse
	 movzbd	h'10,r5			;Vector index
	cend
	addr	int_s1i,r4		;Absolute address
	sprd	mod,r2
	sprd	psr,r3
	bsr	instal_trp		;Set trap address

	cond	cg16_edb		;ICU line 4
	 cbitb	4,icu_adr+2*bus_byts	;Edge triggered
	 sbitb	4,icu_adr+4*bus_byts	;Rising edge
	 cbitb	4,icu_adr+10*bus_byts	;Clear mask to enable interrupt
	celse
	 cbitb	0,icu_adr+2*bus_byts	;Edge triggered
	 sbitb	0,icu_adr+4*bus_byts	;Rising edge
	 cbitb	0,icu_adr+10*bus_byts	;Clear mask to enable interrupt
	cend

	sbitb	0,serial1+bus_byts	;Enable receive interrupt only

	cond	dk_532
	 extsd	switch,r4,0,3	;Read baud rate switches
	 movd	t_baud[r4:d],r4
	celse
	 movd	9600,r4		;Fixed initial baud rate
	cend
	bsr	s1o_baud	;Initialize serial ports now
	bsr	win_init	;Initialize window

	restore [r3,r4,r5]
	movqd	0,r6		;Success
	ret


;-------------------------
; Initialize serial port 2
;-------------------------

s2o_cinit:
	cond	not cg16_edb
	 save	[r3,r4,r5]

	 movzbd	h'11,r5			;Vector index
	 addr	int_s2i,r4		;Absolute address
	 sprd	mod,r2
	 sprd	psr,r3
	 bsr	instal_trp		;Set trap address

	 cbitb	1,icu_adr+2*bus_byts	;Edge triggered
	 sbitb	1,icu_adr+4*bus_byts	;Rising edge
	 cbitb	1,icu_adr+10*bus_byts	;Clear mask to enable interrupt

	 sbitb	0,serial2+bus_byts	;Enable receive interrupt only

	 cond	dk_532
	  extsd	switch,r4,3,3	;Read baud rate switches
	  movd	t_baud[r4:d],r4
	 celse
	  movd	9600,r4		;Fixed rate
	 cend
	 bsr	s2o_baud	;Initialize serial ports now
	 movqd	0,r6		;Success

	 restore [r3,r4,r5]
	cend
	ret


;------------
; Open device
;------------

s1o_copen:
	save	[r3,r4,r5]
	movd	4*dof_bdat(r7),r3
	movqd	0,r6		;Assume OK
	tbitb	bdp_bin,dat_ptcl(r3)
	if	fs
	 movd	4*dof_dat(r7),r5
	 movd	dat_ptcl(r3),dat_ptcl(r5) ;Save original
	 movqd	0,r4		;No extra storage
	 bsr	nlo_cinstnc	;Create new instance
	 cmpqd	0,r6
	 if	eq
	  movd	r5,r7		;New r7 now
	  movd	4*dof_bdat(r7),r4
	  movd	4*dof_dat(r7),r3 ;May be changed by cinstnc
	  addr	xmo_sio:w,4*dof_sio(r7) ;XMODEM routine
	  cbitb	bdp_xof,dat_ptcl(r4) ;No XOFF now
	  sbitb	bdp_xmo,dat_ptcl(r4)
	  movqw	0,dat_xmich(r3)	;XMODEM input character counter
	  movqw	0,dat_xmoch(r3)	;XMODEM output character counter
	  movqd	0,dat_xmblk(r3)	;XMODEM block number
	  movzbd svc_r6,r5	;Index
	  movd	r7,(dev_ptr)[r5:d] ;Install
	 endif
	endif
	cmpqd	0,r6
	if	eq
	 bsr	nlo_copen
	endif
	restore	[r3,r4,r5]
	ret


;-------------
; Close device
;-------------

s1o_cclose:
	save	[r3,r5,r6]
	bsr	nlo_cclose
	movd	4*dof_bdat(r7),r3
	cbitb	bdp_xmo,dat_ptcl(r3)
	if	fs
	 bsr	nlo_cunvct	;Restore
	endif
	cond	not op_sys
	 sbitb	bdp_xof,dat_ptcl(r3) ;Xmodem turns this off
	cend
	cbitb	bdp_bin,dat_ptcl(r3) ;Disable binary transfers
	restore	[r3,r5,r6]
	ret


s1o_ceof:
	save	[r2,r3,r4,r5]

	movd	4*dof_bdat(r7),r3
	tbitb	bdp_xmo,dat_ptcl(r3) ;Check for XMODEM
	disp	2
	if	fs
	 sbitb	bdp_eof,dat_ptcl(r3)
	 if	fc		;Only if not already done
	 disp	1
	  movd	4*dof_dat(r7),r3
	  movb	128,r2
	  subb	dat_xmoch(r3),r2 ;Bytes remaining to write in this block
	  andb	h'7f,r2
	  movd	4*dof_sio(r7),r4
	  begin
	   cmpqb 0,r2
	  while	ne
	   movzbd ctrl_z,r5
	   jsr	r4
	   addqb -1,r2
	  endw
	  until	eq
	   movd	4*dof_io(r7),r4	;Don't use XMODEM routine for this
	   movqd eot,r5
	   jsr	r4
	   save	[r0,r3,r4,r6]
	   movzbd dat_io(r3),r6
	   until eq
	    movd r6,tos
	    orw	dof_sst lsh b_iosrv,r6
	    bsr	bsr_svc		;Check status
	    cmpqd 0,r6
	    movd tos,r6
	   endu
	   orw	dof_sio lsh b_iosrv,r6
	   bsr	bsr_svc		;Read character
	   restore [r0,r3,r4,r6]
	   cmpb	ack,r5
	  endu
	 endif
	endif

	restore [r2,r3,r4,r5]
	ret


;-----------------------
; Set attributes from r4
;-----------------------

s1o_catr:
	save	[r2,r4,r5]
	movd	r4,r2		;Save attributes
	movd	4*dof_sio(r7),r4

	cond	vid340
	 bsr	tx_vcod
	 db	vc_cat,-1,vc_sat,0 ;Clear everything, prepare to set
	 movzbd	r2,r5
	 jsr	r4
	cend
	cond	videxec
	 movzbd esc,r5
	 jsr	r4
	 movb	41,r5		;Dim on
	 tbitb	vca_dim,r2	;Check dim bit
	 if	fc
	  addqb	-1,r5		;Dim off
	 endif
	 jsr	r4
	 movzbd esc,r5
	 jsr	r4
	 movb	106,r5		;Reverse on
	 tbitb	vca_rev,r2	;Check reverse
	 if	fc
	  addqb	1,r5		;Reverse off
	 endif
	 jsr	r4
	cend
	cond	vidansi
	 bsr	tx_vcod
	 db	esc,"[",$"0m",0	;All attributes off
	 tbitb	vca_rev,r2	;Check reverse
	 if	fs
	  bsr	tx_vcod
	  db	esc,"[",0
	  movzbd 7,r5		;Reverse on
	  bsr	tx_asci
	  movzbd "m",r5
	  jsr	r4
	 endif
	 tbitb	vca_dim,r2
	 if	fs
	  bsr	tx_vcod
	  db	esc,"[",0
	  movzbd hilite,r5	;Definable dim attribute
	  bsr	tx_asci
	  movzbd "m",r5
	  jsr	r4
	 endif
	cend

	restore	[r2,r4,r5]
	ret


;---------------------------------
; Set cursor position, value in r4
;---------------------------------

s1o_ccur:
	save	[r0,r1,r4,r5]
	movd	r4,r1		;Save requested position
	movd	4*dof_sio(r7),r4

	bsr	tx_vcod
	cond	videxec
	 db	esc,"=",0
	 movd	r1,r5
	 lshd	-16,r5		;New row
	 addb	" ",r5
	 jsr	r4
	 movzbd	r1,r5		;New column
	 addb	" ",r5
	 jsr	r4
	cend
	cond	vid340
	 db	vc_scr,vcs_pix,0
	 movqd	4,r0
	 bsr	nlo_r1
	cend
	cond	vidansi
	 db	esc,"[",0
	 movd	r1,r5
	 lshd	-16,r5		;New row
	 movd	4*dof_vdat(r7),r0
	 addb	vdt_minl(r0),r5	;Add offset for current window
	 addqb	1,r5
	 bsr	tx_asci
	 movzbd	";",r5
	 jsr	r4
	 movzbd	r1,r5		;New column
	 addqb	1,r5
	 bsr	tx_asci
	 movzbd	"H",r5
	 jsr	r4
	cend

	restore	[r0,r1,r4,r5]
	ret


;-------------
; Clear screen
;-------------

s1o_ccls:
	save	[r1,r3,r4,r5]
	movd	4*dof_dat(r7),r3 ;Pointer to data
	movd	4*dof_vdat(r7),r1 ;Vdat pointer
	movd	4*dof_sio(r7),r4 ;Output routine

	cond	videxec
	 movzbd "Z"-40h,r5	;^Z to clear the screen
	 jsr	r4
	cend
	cond	vid340
	 bsr	tx_vcod
	 db	vc_scr,vcs_pag,0
	cend
	cond	vidansi
	 movzbd vdt_maxl(r1),r2
	 addqd	1,r2		;Number of lines in display
	 addd	r2,r2		;Multiply by 2
	 until	eq
	  movzbd lf,r5		;Can only clear window with line feeds
	  jsr	r4
	  addqd -1,r2
	  cmpqd 0,r2
	 endu
	 bsr	tx_vcod
	 db	esc,"[",0
	 movzbd vdt_minl(r1),r5 ;Starting row
	 addqb	1,r5
	 bsr	tx_asci
	 movzbd ";",r5
	 jsr	r4
	 movzbd vdt_minc(r1),r5 ;Starting column
	 addqb	1,r5
	 bsr	tx_asci
	 movzbd "H",r5
	 jsr	r4
	cend	

	restore	[r1,r3,r4,r5]
	ret


;Return current window number in r5

s1o_cgwin:
	save	[r3]
	movd	4*dof_bdat(r7),r3
	cond	op_sys
	 movd	r7,r5
	celse
	 extsd	dat_ptcl+bdp_win/8(r3),r5,bdp_win mod 8,3
	cend
	restore	[r3]
	movqd	0,r6		;Success
	ret


;Return max x/y character position in r5

s1o_cgchmx:
	save	[r3]
	movd	4*dof_vdat(r7),r3 ;Vdat pointer
	movd	vdt_maxc(r3),r5	;Max column in bits 0-15
	bsr	pix2chr		;Convert pixel xy to character xy
	restore	[r3]
	movqd	0,r6		;Success
	ret


;----------------
; Switch windows
; Selection in r4
;----------------

s1o_cputr7:
	save	[r0,r1,r2,r3,r4,r5]

	cond	op_sys
	 bsr	nlo_cputr7
	celse
	 movqd	-1,r6		;Assume invalid
	 movd	4*dof_dat(r7),r3
	 extsd	dat_ptcl+bdp_win/8(r3),r2,bdp_win mod 8,3 ;Current window
	 movd	4*dof_vdat(r7),r5
	 muld	win_last,r2	;Offset to current window data
	 addr	(win_base)[r2:b],r2 ;Pointer to current window data
	 addr	dat_wmin(r3),r1
	 movzbd	dat_wmax-dat_wmin,r0
	 movsb			;Save current parameters
	 addr	vdt_wmin(r5),r1
	 movzbd	vdt_wmax-vdt_wmin,r0
	 movsb
	 cmpqd	7,r4
	 if	hs
	  movd	r4,r1
	  muld	win_last,r1	;Offset to new window data
	  addr	(win_base)[r1:b],r1 ;Pointer to new window data
	  addr	dat_wmin(r3),r2
	  movzbd dat_wmax-dat_wmin,r0
	  movsb			;Load new parameters
	  addr	vdt_wmin(r5),r2
	  movzbd vdt_wmax-vdt_wmin,r0
	  movsb
	  inssb	r4,dat_ptcl+bdp_win/8(r3),bdp_win mod 8,3 ;Current window
	  movqd	0,r6
	 endif
	cend

	bsr	set_wndw	;Display new window

	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-----------------------------------------
; Set current window character size
; R4 holds:
;   Absolute upper left character column:b
;   Absolute upper left character row:b
;   Number of character columns:b
;   Number of character rows:b
;-----------------------------------------

s1o_cnwn:
	save	[r2,r3,r5]
	movd	4*dof_dat(r7),r3 ;Pointer to data field
	movd	4*dof_vdat(r7),r2

	movzwd	r4,r5		;Starting row
	lshd	8,r5		;Row to bits 16-23
	movzbw	r4,r5		;Starting column
	bsr	chr2pix
	movd	r5,vdt_minc(r2)	;Upper left
	movd	r4,r5		;Row/column count
	lshd	-8,r5		;Row to bits 16-23, col to bits 8-15
	lshw	-8,r5		;Column to bits 0-7
	bsr	chr2pix
	subd	h'10001,r5	;Lower right pixel
	movd	r5,vdt_maxc(r2)	;Upper left
	movqw	0,dat_col(r3)
	movqw	0,dat_line(r3)
	movqw	0,dat_page(r3)	;Always start in upper left
	movqd	0,r6
	 
	bsr	set_wndw	;Display new parameters
	bsr	cls_vcs
	restore	[r2,r3,r5]
	ret

;End of SER32
