;---------------------
;Block device routines
;---------------------

;General open/close subroutines

;R5 holds status expected from 6821, R6 holds status to return

	cond	0
stat_in:
	 save	[r0]
	 movb	16*(b_ctroff+4*b_6821),pdatc ;Cancel data mode
	 until	eq
	  extsb	pdata,r0,0,3	;Read current status
	  cmpb	b_ctratn+4*b_6821,r0
	 endu
	 movb	16*(b_ctratn+4*b_6821),pdatc
	 restore [r0]
	 
stat_in1:
	 
;Accessing data port B toggles handshake line!!!
	 
	 tbitb	2,r5		;Set=input, reset=output
	 if	fs
	  movqb	2*1,pctr	;Set IBF and interrupt bits low
	 else
	  movqb	2*1+1,pctr	;Set /OBF and interrupt bits high
	 endif
	 save	[r0]
	 until	eq
	  extsb	pdata,r0,0,3	;Read current status
	  cmpb	r5,r0
	 endu
	 movb	r6,pdatc
	 restore [r0]
	 ret
	cend


;R5 holds status to send, R6 holds status expected from 6821

	cond	0
stat_out:
	 save	[r0]
	 movb	16*(b_ctratn+b_8255*4),pdatc
	 until	eq
	  extsb	pdata,r0,0,3	;Read current status
	  cmpb	b_ctratn+b_8255*4,r0
	 endu
	 restore [r0]
	 
stat_out1:
	 
;Accessing data port B toggles handshake line!!!
	 
	 tbitb	2,r6		;Set=input, reset=output
	 if	fs
	  movqb	2*1,pctr	;Set IBF and interrupt bits low
	 else
	  movqb	2*1+1,pctr	;Set /OBF and interrupt bits high
	 endif
	 save	[r0]
	 movb	r5,pdatc
	 until	eq
	  extsb	pdata,r0,0,3	;Read current status
	  cmpb	r6,r0
	 endu
	 restore [r0]
	 ret
	cend


;Block device input status routine

bli_sst:
bli_stat:
	tbitb	0,pdatc
	sfcd	r6
	if	fc		;No data yet if interrupt bit clear
	 extsb	pdata,tos,0,3	;See if device is still enabled
	 cmpb	tos,b_ctrdat+b_6821*4
	 if	ne
	  sbitb bstat_nr,r6
	 endif
	endif
	ret

;Parallel port character input

bli_sio:
bli_io:
	save	[r4]
	movd	4*dof_stat(r7),r4 ;Address of status routine
	until	eq
	 jsr	r4		;Get status in R6
	 cmpqd	0,r6
	endu
	restore [r4]
	movzbd pdatb,r5
	ret


	disp	1

;Parallel input block routine
;R0 holds status bits, input length
;R1 points to start of buffer

bli_blk:
	save	[r0]
	bicd	exp bkb_hlt+h'ffff,r0 ;Ignore this for now
	cmpd	exp (bkb_tr5),r0 ;Termination on R5
	if	ne
	 cmpd	exp bkb_trm,r0 ;Termination on end of file
	endif
	restore	[r0]
	bne	nli_blk		;Only fast file read here

	save	[r1,r2,r3,r4,r5]
	cmpqw	-1,r0		;Check for infinite length
	tbitb	bkb_trm,r0	;EOF termination if set
	if	eq
	 movd	h'7fffffff,r0	;Infinite length
	else
	 movzwd	r0,r0		;Max input length
	endif

	movd	r0,tos
	if	fc		;R5 termination if FC
	 until eq
	  until fs
	   tbitb 0,pdatc	;Interrupt bit
	  endu
	  movb pdatb,r4
	  movb r4,(r1)
	  cmpqd 1,r0		;See if more room
	  if	lt		;Don't write past defined buffer
	   addqd 1,r1		;Advance pointer
	  endif
	  addqd -1,r0		;Decrement counter
	  cmpb r4,r5		;Check for termination
	 endu
	else			;End-of-file termination
	 until ne
	  tbitb 0,pdatc
	  if	fs		;Got a character if FS
	   movb pdatb,(r1)
	   cmpqd 1,r0		;See if more room
	   if	lt		;Don't write past defined buffer
	    addqd 1,r1		;Advance pointer
	   endif
	   addqd -1,r0		;Decrement counter
	   cmpb r1,r1		;Make EQ
	  else
	   extsb pdata,r4,0,3	;See if device is still enabled
	   cmpqb b_ctrdat+b_6821*4,r4
	  endif
	 endu
	endif

	negd	r0,r0
	addd	tos,r0		;Number of character read from device
	restore	[r1,r2,r3,r4,r5]
	movqd	0,r6
	ret


;Parallel input command processor

bli_copen:
	save	[r3,r5]

	movd	4*dof_dat(r7),r3 ;Data pointer
	tbitb	bdp_opn,dat_ptcl(r3) ;See if already open
	if	fc
	 macpin
	 cond	p_8255
	  save	[r6]
	  movb b_ctrdat+b_6821*4,r5 ;Wait for this
	  movb 16*(b_ctrdat+b_6821*4),r6 ;Send this
	  bsr	stat_in
	  restore [r6]
	 cend
	endif
	bsr	nli_copen

	restore [r3,r5]
	ret


bli_cclose:
	save	[r5]

	cond	p_8255
	 save	[r6]
	 movb	b_ctroff+b_8255*4,r5 ;Wait for this
	 movb	16*(b_ctroff+b_8255*4),r6 ;Return this
	 bsr	stat_in
	 restore [r6]
	cend
	cond	cg16_edb
	 mac_pnd		;Check for hardware termination
	 if	fs
	  mac_pxt
	 endif
	cend

	macpoff
	bsr	nli_cclose

	restore [r5]
	ret


;Re-route command, R1 holds new assignment

bli_cvct:
	save	[r3]
	bsr	nlo_cvct	;Do actual re-route
	movd	4*dof_vdat(r7),r3 ;Vdat pointer
	cmpb	dev_smv+1,r5	;Serial port if so
	if	eq
	 sbitb	bdp_xmo,vdt_ptcl(r3)
	 addr	xmi_sst:w,4*dof_sst(r7) ;Serial port input uses this
	else
	 cmpb	dev_pmv+1,r5
	orif	eq
	 cbitb	bdp_xmo,vdt_ptcl(r3)
	endif
	restore	[r3]
	ret


;-----------------------------------
; Block device output status routine
;-----------------------------------

blo_sst:
blo_stat:
	tbitb	0,pdatc
	sfcd	r6
	ret


;Parallel port IO
;Parallel port character output

blo_sio:
blo_io:
	movd	r4,tos
	until	fs
	 tbitb 0,pdatc
	endu
	movqd	0,r6
	movd	tos,r4
	movb	r5,pdatb
	ret


	disp	1

;Parallel output block routine
;R0 holds status bits, length
;R1 points to start of buffer

blo_blk:
	movd	r0,tos
	lshd	-16,(sp)
	cmpd	exp (bkb_cnt-16),tos ;See if just write for count
	bne	nlo_blk		;More than just a file write required

	begin
	 cmpqw	0,r0
	while	ne
	 until	fs
	  tbitb	0,pdatc		;Interrupt bit
	 endu
	 movb	(r1),pdatb
	 addqd	 1,r1
	 addqw	 -1,r0
	endw
	movqd	0,r6		;Success
	ret


;Parallel output command processor

blo_copen:
	save	[r3,r5]

	movd	4*dof_dat(r7),r3 ;Data pointer
	tbitb	bdp_opn,dat_ptcl(r3) ;See if already open
	if	fc
	 macpout
	 cond	p_8255
	  save	[r6]
	  movb	b_ctrdat+b_8255*4,r5 ;Wait for this
	  movb	16*(b_ctrdat+b_8255*4),r6 ;Send this
	  bsr	stat_in
	  restore [r6]
	 cend
	endif
	bsr	nlo_copen

	restore	[r3,r5]
	ret


blo_cclose:
	save	[r5]

	cond	p_8255
	 save	[r6]
	 movb	16*(b_ctroff+b_8255*4),r5 ;Send this
	 movb	b_ctroff+b_8255*4,r6 ;Wait for this
	 bsr	stat_out:w
	 restore [r6]
	cend
	macpoff
	bsr	nlo_cclose

	restore [r5]
	ret


;Re-route command, R1 holds new assignment

blo_cvct:
	save	[r3]
	bsr	nlo_cvct	;Do actual re-route
	movd	4*dof_vdat(r7),r3 ;Vdat pointer
	cmpb	dev_smv,r5	;Serial port if so
	if	eq
	 sbitb	bdp_xmo,vdt_ptcl(r3)
	 addr	xmo_sio,4*dof_sio(r7) ;XMODEM character routine
	else
	 cmpb	dev_pmv,r5
	orif	eq
	 cbitb	bdp_xmo,vdt_ptcl(r3)
	endif
	restore	[r3]
	ret

