	print	"OPS32"

;32032 opcodes and pseudo-ops

;Alphabetic index by first letter to opcode table
;Gives offset from beginning of table

ops_ret:
	ret

t_alpha:
	.word	t_op_a-t_op_a
	.word	t_op_b-t_op_a
	.word	t_op_c-t_op_a
	.word	t_op_d-t_op_a
	.word	t_op_e-t_op_a
	.word	t_op_f-t_op_a
	.word	t_op_g-t_op_a
	.word	t_op_h-t_op_a
	.word	t_op_i-t_op_a
	.word	t_op_j-t_op_a
	.word	t_op_k-t_op_a
	.word	t_op_l-t_op_a
	.word	t_op_m-t_op_a
	.word	t_op_n-t_op_a
	.word	t_op_o-t_op_a
	.word	t_op_p-t_op_a
	.word	t_op_q-t_op_a
	.word	t_op_r-t_op_a
	.word	t_op_s-t_op_a
	.word	t_op_t-t_op_a
	.word	t_op_u-t_op_a
	.word	t_op_v-t_op_a
	.word	t_op_w-t_op_a
	.word	t_op_x-t_op_a
	.word	t_op_y-t_op_a
	.word	t_op_z-t_op_a

;Opcode table
;Table arrangement:
;	First letter
;	Length
;	Alpha
;
;1 byte length of opcode name
;1 byte offset to next group
;n bytes opcode string
;	i = B/W/D field
;	f = F/L field
;	cc = condition field
;1 byte format, opcode index
;	Bits 4-7 = format, bits 0-3 = opcode within format

t_op_a:	byte	4,t_op_a5-t_op_a
	byte	$"ABSf",h'bd
	byte	$"ABSi",h'6c
	byte	$"ACBi",h'24
	byte	$"ADDR",h'49
	byte	$"ADDf",h'b0
	byte	$"ADDi",h'40
	byte	$"ANDi",h'4a
	byte	$"ASHi",h'61

t_op_a5:
	byte	5,t_op_a6-t_op_a5
	byte	"ADDCi",h'44
	byte	"ADDPi",h'6f
	byte	"ADDQi",h'20

t_op_a6:
	byte	6,t_op_b-t_op_a6
	byte	"ADJSPi",h'3a

t_op_b:
	byte	2,t_op_b3-t_op_b
	byte	$"BR",h'0e

t_op_b3:
	byte	3,t_op_b4-t_op_b3
	byte	$"BPT",h'1f
	byte	$"BSR",h'10
	byte	$"Bcc",h'00

t_op_b4:
	byte	4,t_op_b5-t_op_b4
	db	$"BBOR",h'56
	byte	$"BICi",h'42

t_op_b5:
	byte	5,t_op_b6-t_op_b5
	db	"BBAND",h'5a
	db	"BBFOR",h'5c
	db	"BBXOR",h'5e
	db	"BITWT",h'58

t_op_b6:
	byte	6,t_op_b7-t_op_b6
	byte	"BBSTOD",h'54

t_op_b7:
	byte	7,t_op_c-t_op_b7
	byte	"BICPSRi",h'32
	byte	"BISPSRi",h'36

t_op_c:
	byte	3,t_op_c4-t_op_c
	byte	$"CXP",h'12

t_op_c4:
	byte	4,t_op_c5-t_op_c4
	db	$"CINV",h'e9
	byte	$"CMPf",h'b2
	byte	$"CMPi",h'41
	byte	$"COMi",h'6d
	byte	$"CVTP",h'81
	byte	$"CXPD",h'30

t_op_c5:
	byte	5,t_op_c6-t_op_c5
	byte	"CASEi",h'3e
	byte	"CBITi",h'62
	byte	"CMPMi",h'71
	byte	"CMPQi",h'21
	byte	"CMPST",h'51
	byte	"CMPSi",h'51

t_op_c6:
	byte	6,t_op_d-t_op_c6
	byte	"CBITIi",h'63
	byte	"CHECKi",h'83

t_op_d:
	byte	3,t_op_d4-t_op_d
	byte	$"DIA",h'1c

t_op_d4:
	byte	4,t_op_e-t_op_d4
	byte	$"DEIi",h'7b
	byte	$"DIVf",h'b8
	byte	$"DIVi",h'7f
	db	$"DOTf",h'c3

t_op_e:
t_op_e4:
	byte	4,t_op_e5-t_op_e4
	byte	$"EXIT",h'19
	byte	$"EXTi",h'80

t_op_e5:
	byte	5,t_op_e6-t_op_e5
	byte	"ENTER",h'18
	byte	"EXTSi",h'73

t_op_e6:
	db	6,t_op_f-t_op_e6
	db	"EXTBLT",h'55

t_op_f:
	byte	4,t_op_f7-t_op_f
	byte	$"FFSi",h'85
	byte	$"FLAG",h'1d

t_op_f7:
	byte	7,t_op_g-t_op_f7
	byte	"FLOORfi",h'97

t_op_g:
t_op_h:
t_op_i:
	byte	4,t_op_i5-t_op_i
	byte	$"INSi",h'82

t_op_i5:
	byte	5,t_op_i6-t_op_i5
	byte	"IBITi",h'6e
	byte	"INSSi",h'72

t_op_i6:
	byte	6,t_op_j-t_op_i6
	byte	"INDEXi",h'84

t_op_j:
	byte	3,t_op_j4-t_op_j
	byte	$"JSR",h'3c

t_op_j4:
	byte	4,t_op_k-t_op_j
	byte	$"JUMP",h'34

t_op_k:
t_op_l:	byte	3,t_op_l4-t_op_l
	byte	$"LMR",h'e2
t_op_l4:
	byte	4,t_op_l5-t_op_l4
	byte	$"LFSR",h'91
	byte	$"LPRi",h'26
	byte	$"LSHi",h'65
	byte	$"LXPD",h'49

t_op_l5:
	byte	5,t_op_m-t_op_l5
	db	"LOGBf",h'c5

t_op_m:
	byte	4,t_op_m5-t_op_m
	db	$"MACf",h'ca
	byte	$"MEIi",h'79
	byte	$"MODi",h'7e
	byte	$"MOVf",h'b1
	byte	$"MOVi",h'45
	byte	$"MULf",h'bc
	byte	$"MULi",h'78

t_op_m5:
	byte	5,t_op_m6-t_op_m5
	byte	"MOVFL",h'93
	byte	"MOVLF",h'92
	byte	"MOVMi",h'70
	byte	"MOVQi",h'25
	byte	"MOVST",h'50
	byte	"MOVSi",h'50
	byte	"MOVif",h'90

t_op_m6:
	byte	6,t_op_n-t_op_m6
	db	"MOVMPi",h'57
	byte	"MOVSUi",h'86
	byte	"MOVUSi",h'86
	byte	"MOVXBW",h'74
	byte	"MOVXiD",h'77
	byte	"MOVZBW",h'75
	byte	"MOVZiD",h'76

t_op_n:
	byte	3,t_op_n4-t_op_n
	byte	$"NOP",h'1a

t_op_n4:
	byte	4,t_op_o-t_op_n4
	byte	$"NEGf",h'b5
	byte	$"NEGi",h'68
	byte	$"NOTi",h'69

t_op_o:
	byte	3,t_op_p-t_op_o
	byte	$"ORi",h'46

t_op_p:
	db	5,t_op_q-t_op_p
	db	"POLYf",h'c2

t_op_q:
	byte	4,t_op_r-t_op_q
	byte	$"QUOi",h'7c

t_op_r:
	byte	3,t_op_r4-t_op_r
	byte	$"RET",h'11
	byte	$"RXP",h'13

t_op_r4:
	byte	4,t_op_r5-t_op_r4
	byte	$"REMi",h'7d
	byte	$"RETI",h'15
	byte	$"RETT",h'14
	byte	$"ROTi",h'60

t_op_r5:
	byte	5,t_op_r7-t_op_r5
	byte	"RDVAL",h'e0

t_op_r7:
	byte	7,t_op_s-t_op_r7
	byte	"RESTORE",h'17
	byte	"ROUNDfi",h'94

t_op_s:
	byte	3,t_op_s4-t_op_s
	byte	$"SMR",h'e3
	byte	$"SVC",h'1e

t_op_s4:
	byte	4,t_op_s5-t_op_s4
	byte	$"SAVE",h'16
	byte	$"SFSR",h'96
	byte	$"SPRi",h'22
	byte	$"SUBf",h'b4
	byte	$"SUBi",h'48
	byte	$"Scci",h'23

t_op_s5:
	byte	5,t_op_s6-t_op_s5
	db	"SBITS",h'5d
	byte	"SBITi",h'66
	byte	"SKPST",h'53
	byte	"SKPSi",h'53
	db	"SQRTf",h'c1
	db	"SREMf",h'c0
	byte	"SUBCi",h'4c
	byte	"SUBPi",h'6b

t_op_s6:
	byte	6,t_op_t-t_op_s6
	byte	"SBITIi",h'67
	db	"SBITPS",h'5b
	db	"SCALBf",h'c4
	byte	"SETCFG",h'52

t_op_t:
	byte	5,t_op_t7-t_op_t
	db	"TBITS",h'59
	byte	"TBITi",h'4d

t_op_t7:
	byte	7,t_op_u-t_op_t7
	byte	"TRUNCfi",h'95

t_op_u:
t_op_v:
t_op_w:
	byte	4,t_op_w5-t_op_w
	byte	$"WAIT",h'1b

t_op_w5:
	byte	5,t_op_x-t_op_w5
	byte	$"WRVAL",h'e1

t_op_x:
	byte	4,t_op_y-t_op_x
	byte	$"XORi",h'4e

;End of table

t_op_y:
t_op_z:
	byte	0,0,1+"Z"	;Make impossible to match


;Alphabetic index by first letter to pseudo-op table
;Gives offset from beginning of table

tpsopalf:
	.word	tpsopa-tpsopa
	.word	tpsopb-tpsopa
	.word	tpsopc-tpsopa
	.word	tpsopd-tpsopa
	.word	tpsope-tpsopa
	.word	tpsopf-tpsopa
	.word	tpsopg-tpsopa
	.word	tpsoph-tpsopa
	.word	tpsopi-tpsopa
	.word	tpsopj-tpsopa
	.word	tpsopk-tpsopa
	.word	tpsopl-tpsopa
	.word	tpsopm-tpsopa
	.word	tpsopn-tpsopa
	.word	tpsopo-tpsopa
	.word	tpsopp-tpsopa
	.word	tpsopq-tpsopa
	.word	tpsopr-tpsopa
	.word	tpsops-tpsopa
	.word	tpsopt-tpsopa
	.word	tpsopu-tpsopa
	.word	tpsopv-tpsopa
	.word	tpsopw-tpsopa
	.word	tpsopx-tpsopa
	.word	tpsopy-tpsopa
	.word	tpsopz-tpsopa

;Pseudo-op table
;Table arrangement:
;	First letter
;	Length
;	Alpha
;
;1 byte length of opcode name
;1 byte offset to next group
;n bytes opcode string
;	i = B/W/D field
;	f = F/L field
;	cc = condition field
;1 byte format, opcode index
;	Bits 4-7 = format, bits 0-3 = opcode within format

tpsopa:
	byte	5,tpsopa6-tpsopa
	byte	"ABORT",h'03
	byte	"ALIGN",h'09
	byte	"ASCII",h'f0

tpsopa6:
	byte	6,tpsopb-tpsopa6
	byte	"ACCEPT",h'01

tpsopb:
	byte	4,tpsopb5-tpsopb
	byte	$"BLKB",h'f2
	db	$"BLKD",h'ff
	db	$"BLKF",h'ff
	db	$"BLKL",16*psop_alc+alc_bll
	db	$"BLKW",h'fe
	byte	$"BYTE",h'f0

tpsopb5:
	byte	5,tpsopc-tpsopb5
	byte	"BEGIN",h'd*16+cc_beg

tpsopc:
	byte	4,tpsopc5-tpsopc
	byte	$"CEND",cc_cend
	byte	$"CODE",h'd*16+cc_cod
	byte	$"COND",h'05

tpsopc5:
	byte	5,tpsopd-tpsopc5
	byte	"CELSE",cc_celse

tpsopd:
	byte	2,tpsopd2-tpsopd
	byte	$"DB",h'f0
	byte	$"DD",h'f9
	byte	$"DF",h'fc
	byte	$"DL",h'fd
	byte	$"DS",h'f2
	byte	$"DW",h'f1

tpsopd2:
	byte	3,tpsopd4-tpsopd2
	byte	$"DBL",h'f9

tpsopd4:
	byte	4,tpsopd6-tpsopd4
	byte	$"DISP",h'f6
	byte	$"DROP",h'fb

tpsopd6:
	byte	6,tpsope-tpsopd6
	byte	"DOUBLE",h'f9

tpsope:
	byte	3,tpsope4-tpsope
	byte	$"END",h'd*16+cc_end
	byte	$"EQU",h'f4

tpsope4:
	byte	4,tpsope5-tpsope4
	byte	$"ELSE",h'd*16+cc_els
	byte	$"ENDM",16*op_mac+mac_end
	byte	$"ENDU",h'd*16+cc_end
	byte	$"ENDW",h'd*16+cc_end

tpsope5:
	byte	5,tpsope6-tpsope5
	byte	"ENDIF",h'd*16+cc_end
	db	"EXTRN",op_lnk*16+lnk_ext

tpsope6:
	byte	6,tpsope7-tpsope6
	byte	"ENDMOD",h'0*16+pso_ndmd

tpsope7:
	byte	7,tpsopf-tpsope7
	db	"EXTUNDF",op_lnk*16+lnk_eun

tpsopf:
	byte	5,tpsopg-tpsopf
	byte	"FIELD",h'02
	db	"FLIST",op_lst*16+lst_fc
	db	"FLOAT",h'fc

tpsopg:
	byte	5,tpsopg6-tpsopg
	db	"GLOBL",op_lnk*16+lnk_glb

tpsopg6:
	byte	6,tpsoph-tpsopg6
	db	"GLOBAL",op_lnk*16+lnk_glb

tpsoph:
tpsopi:
	byte	2,tpsopi3-tpsopi
	byte	$"IF",h'd*16+cc_if

tpsopi3:
	db	3,tpsopi4-tpsopi3
	db	$"IRP",16*op_mac+mac_irp

tpsopi4:
	db	4,tpsopj-tpsopi3
	db	$"IRPC",16*op_mac+mac_rpc
	db	$"IRPL",16*op_mac+mac_rpl

tpsopj:
tpsopk:
tpsopl:
	byte	4,tpsopl5-tpsopl
	db	$"LEND",16*op_mac+mac_lnd
	db	$"LINK",16*op_lnk+lnk_lnk
	byte	$"LIST",h'08
	byte	$"LONG",h'fd

tpsopl5:
	byte	5,tpsopm-tpsopl5
	byte	"LOCAL",16*op_mac+mac_lcl
	byte	"LPROC",h'd*16+cc_lpr

tpsopm:
	byte	4,tpsopm5-tpsopm
	byte	$"MEND",16*op_mac+mac_end
	byte	$"MODE",h'f3

tpsopm5:
	byte	5,tpsopm6-tpsopm5
	byte	"MACRO",16*op_mac+mac_mac
	db	"MEXIT",16*op_mac+mac_xit
	db	"MLIST",16*op_lst+lst_mac

tpsopm6:
	byte	6,tpsopn-tpsopm6
	db	"MEMSIZ",16*psop_sys+sys_siz
	db	"MODULE",16*op_lnk+lnk_mod

tpsopn:
	cond	nscgnx
	 db	6,tpsopo-tpsopn
	 db	"NSCGNX",16*psop_sys+sys_gnx
	cend

tpsopo:
	byte	3,tpsopo4-tpsopo
	byte	$"ORG",psop_alc*16+alc_org

tpsopo4:
	byte	4,tpsopo6-tpsopo4
	byte	$"ORIF",h'd*16+cc_orif

tpsopo6:
	byte	6,tpsopp-tpsopo6
	db	"ONEMOD",16*op_lnk+lnk_one

tpsopp:
	byte	4,tpsopp5-tpsopp
	byte	$"PEND",h'd*16+cc_pend
	byte	$"PRET",h'd*16+cc_prt
	byte	$"PROC",h'd*16+cc_proc
	byte	$"PUSH",h'f8

tpsopp5:
	byte	5,tpsopp6-tpsopp5
	byte	"PRINT",h'04

tpsopp6:
	db	6,tpsopp9-tpsopp6
	db	"P1LIST",16*op_lst+l1_mac
	db	"PPRINT",16*op_lst+lst_str

tpsopp9:
	db	9,tpsopq-tpsopp9
	db	"PSEUDO_OP",16*psop_sys+sys_pso

tpsopq:
	byte	4,tpsopr-tpsopq
	byte	$"QEND",h'd*16+cc_qnd
	byte	$"QUIT",h'd*16+cc_qu

tpsopr:
	byte	3,tpsopr4-tpsopr
	byte	$"REG",h'd*16+cc_reg
	byte	$"RPN",h'fa

tpsopr4:
	byte	4,tpsopr5-tpsopr4
	byte	$"REPT",16*op_mac+mac_rpt

tpsopr5:
	byte	5,tpsops-tpsopr5
	byte	"RADIX",h'f7

tpsops:
	byte	3,tpsops4-tpsops
	byte	$"SET",h'f5

tpsops4:
	byte	4,tpsops5-tpsops4
	byte	$"STOP",h'00

tpsops5:
	byte	5,tpsops7-tpsops5
	byte	"SPACE",h'f2
	byte	"STACK",op_lnk*16+lnk_stk

tpsops7:
	byte	7,tpsopt-tpsops7
	byte	"SYMBOLS",op_lnk*16+lnk_sym

tpsopt:
tpsopu:
	byte	5,tpsopv-tpsopu
	byte	"UNTIL",h'd*16+cc_untl
tpsopv:
tpsopw:
	byte	4,tpsopw5-tpsopw
	byte	$"WORD",h'f1

tpsopw5:
	byte	5,tpsopx-tpsopw5
	byte	"WHILE",h'd*16+cc_whl
	db	"WIDTH",op_lst*16+lst_wid

tpsopx:
	db	4,tpsopx5-tpsopx
	db	$"XLAT",op_lst*16+lst_xlt

tpsopx5:
	byte	5,tpsopy-tpsopx5
	byte	"XPROC",h'd*16+cc_xpr

;End of table

tpsopy:
tpsopz:
	byte	0,0,1+"Z"	;Make impossible to match


;These are the format specific routines

afmt_0:	cmpqb	2,m_pass
	if	ne
	 movb	h'a,0(r7)
	endif

;If not BR then M_COND is the opcode within format

	cmpb	h'e,r3
	beq	afmt_0a		;Do parameters, format in R5, short in R6
	inssb	m_cond,r5,0,4	;Condition is opcode
afmt_0a:
	bsr	asm_fld

;Ready for PC relative offset

pc_ofst:
	bsr	comma
	bfs	nxt_txt		;Display error if no text follows
	save	[r5]

;Set up a temporary buffer on the stack

	adjspb	2+8
	addr	0(sp),r5

	bsr	ex_int
	tbitb	b_def,(r5)
	if	fs
	 subd	m_pcptr,2(r5)	;Only if defined
	endif
	inssb	h'b,1(r5),0,4	;Force to PC relative mode
	bsr	asm_dsub

	adjspb	-10
	restore	[r5]
	ret	0

;Add offset, always required
;OP_OFST does optional offset, default in R5

do_ofst:
	bsr	comma
	bfs	nxt_txt		;Display error if no text follows
	save	[r5]
	movqd	0,r5		;Prevent following phase errors if no value
	bsr	op_ofst
	restore	[r5]
	ret	0

op_ofst:
	save	[r3]
	movd	r5,r3		;Save default if nothing specified

	adjspb	2+8
	addr	0(sp),r5
	movd	r3,2(r5)
	movw	exp b_def+h'2400,(r5) ;Default value in (R5)

	bsr	comma
	if	fc
	 bsr	ex_int		;Get real value
	endif
	bsr	asm_dsub

	adjspb	-10
	movd	r3,r5		;Restore original R5
	restore	[r3]
	ret	0


;Get offset in R5, use EX
;FS if undefined value returned by EX
;Use GET_OF1 if text pointer is valid

get_ofst:
	bsr	comma
	bfs	nxt_txt		;Display error if nothing left
get_of1:

;Set up a temporary buffer on the stack

	adjspb	2+8
	addr	0(sp),r5
	bsr	ex_int
	ibitb	b_def,0(r5)	;Invert F
	tbitb	b_def,0(r5)	;Set F if undefined
	movd	2(r5),r5	;Load value into R5
	adjspb	-10
	ret	0


;Get value in R5, display error and return 1 in R5 if undefined

def_r5:	bsr	get_ofst
	bfc	ops_ret
	movqd	1,r5		;Safe default value
	bsr	sym_und
	bispsrb	flag_f		;This must be set if error
	ret


;Get result of integer expression, R5 assigned to buffer pointer
;Returned in 2(R5), FS if undefined

get_ex:	movzbd	10,r5
	bsr	aray_r5
	bfs	ops_ret
	bsr	ex_int
	tbitb	b_def,(r5)
	if	fs
	 bicpsrb flag_f		;Flag set if undefined
	else
	 bispsrb flag_f		;Flag clear if defined
	endif			;@ GEN_EX
	ret


afmt_1:	cmpqb	2,m_pass
	if	ne
	 movqb	2,0(r7)
	endif

;If opcode > A or = 5 then just do ASM_FLD

	cmpqb	5,r3		;Check opcode
	beq	asm_fld
	cmpb	h'a,r3
	bls	asm_fld

	cmpqb	2,r3		;CXP
	if	eq
	 bsr	asm_fld
	 bsr	nxt_txt		;Make sure good text follows
	 if	fc
	  addr	gen1,r5		;Address for gen, displacements
	  bsr	asm_gen		;May be EXT(xx)
	  cmpqb	-1,(r5)
	  if	ne
	   addqd 2,r5
	   extsb 1(r5),r2,b_mode-8,4
	   cmpqb 4,r2		;May be constant
	   if	eq
	    movb exp blnk_cmd+exp blnk_val+(clnkcxp lsh blnkvcmd),tos
	    bsr	addr_cxp
	   else
	    cmpb b'1011,r2	;May also be PC relative
	   orif	eq
	    bsr	type_err
	   endif
	  endif
	 endif
	 ret
	endif

;Extensions required, do ASM_FLD first

	bsr	asm_fld

	cmpqb	0,r3		;If BSR then PC displacemnt needed
	beq	pc_ofst

	cmpqb	4,r3
	movqd	0,r5		;Default offset of 0 if none specified
	bhs	op_ofst		;Optional offset if RET,RXP,RETT

;Register field required

	bsr	nxt_txt		;List required
	bfs	ops_ret

	addr	t_rgbit,r2
	bsr	bit_lst		;Get value in 2(R6)
	movb	2(r6),0(r7)
	addqd	1,r7

;If ENTER, register map OK but constant needed

	cmpb	8,r3
	beq	do_ofst

;If this was RESTORE or EXIT, reverse order of bits

	cmpqb	6,r3		;Done if SAVE
	beq	ops_ret

;Reverse bit map in R6 and -1(R7)

	movb	2(r6),r5
	bsr	rvs_bit
	movb	r5,-1(r7)
	ret	0

;Long reg list, bit 0 = R0

t_rgbit:
	byte	9
	byte	$"R0  "
	byte	$"R1  "
	byte	$"R2  "
	byte	$"R3  "
	byte	$"R4  "
	byte	$"R5  "
	byte	$"R6  "
	byte	$"R7  "
	byte	$"ALL "
	byte	h'ff
	byte	h'80
	byte	h'40
	byte	h'20
	byte	h'10
	byte	h'8
	byte	h'4
	byte	h'2
	byte	h'1


;Reverse order of bits in LS byte of R5

rvs_bit:
	save	[r3,r4]
	movb	8,r3		;Counter
	movqb	0,r4		;Reversed bits here
rvs_bt1:
	lshb	-1,r4		;Rotate current value
	addcb	r5,r5		;Bit 7 to carry
	bcc	rvs_bt2
	sbitb	7,r4
rvs_bt2:
	acbb	-1,r3,rvs_bt1
	movb	r4,r5
	restore	[r3,r4]
	ret	0


;Process bit mapped list in R2
;Cumulative total returned in 2(R6)
;List terminated by "]", end of line or invalid entry

bit_lst:
	save	[r0,r2,r3,r4,r5]
	cmpb	"[",0(r1)	;Skip opening "[" if there
	if	eq
	 addqd	1,r1
	endif
	movqd	0,2(r6)		;Cumulative total in R6
	movzbd	0(r2),r3	;First byte is number of entries
	addqd	1,r2		;Advance to 1st text of table

	begin
	 movd	r1,r5		;Save start in case of error
	 bsr	comma
	 bispsrb flag_z		;Make EQ
	 if	fc
	  cmpb	"]",0(r1)	;Done if "]" found
	 endif
	while	ne		;Check table for match
	 bsr	exp_len		;Get length of expression in R0
	 bsr	pad_blsb	;Get search value in R4
	 cmpd	"    ",r4
	quit	eq		;Invalid parameter if EQ
	 save	[r1]
	 movd	r2,r1
	 movd	r3,r0		;Move count to R0
	 skpsd	u
	 restore [r1]
	quit	fc		;Invalid parameter if FC
	 
;Got a match, OR new value with cumulative total
;Values follow table
	 
	 movd	r3,r4		;Length of table text
	 lshd	2,r4		;Each entry is 4 bytes
	 addd	r2,r4		;Base address of values
	 addqd	-1,r0		;Start offset with 0
	 orb	r4[r0:b],2(r6)
	qend
	 movd	r5,r1		;Restore start of invalid entry
	endw

	restore	[r0,r2,r3,r4,r5] ;Exit routine
	cmpb	"]",0(r1)	;Skip "]" if there
	bne	ops_ret
	addqd	1,r1
	ret	0

prm_err:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Invalid parameter",cr,lf,0
	ret	0

;R2 holds list address, all entries are :D
;R0 holds number of entries in table
;Return value of string in (R1) as short field in 2(R6), -1 = error

shrt_lst:
	save	[r4]
	bsr	pad_blnk	;Get search string, advance R1
	save	[r0,r1]
	movqd	-1,2(r6)
	cmpd	"    ",r4
	beq	sht_lstx	;Error already if EQ
	movd	r2,r1		;List in R1
	skpsd	u
	addqd	-1,r0		;Offset starts with 0, -1 if error
	movd	r0,2(r6)	;Short field
sht_lstx:
	restore	[r0,r1]
	restore	[r4]
	cmpqd	-1,2(r6)	;Error if this
	bne	ops_ret
	br	prm_err

afmt_2:	cmpqb	2,m_pass
	if	ne
	 movw	h'c,0(r7)	;Initial byte
	endif

	movzbd	m_cond,2(r6)
	cmpqb	3,r3
	beq	asm_fld		;If Scond then just need M_COND in R6

;Short field required

	bsr	nxt_txt
	bfs	ops_ret

;If SPR or LPR then need short register field

	cmpqb	2,r3
	beq	sh_reg		;SPR if EQ
	cmpqb	6,r3
	bne	sh_num		;Not LPR if NE
sh_reg:	addr	t_shreg,r2
	movzbd	h'10,r0		;Number of list entries
	bsr	shrt_lst
	br	asm_fld
sh_num:	save	[r5]
	movd	r6,r5		;Get short field here
	bsr	ex_int
	movd	r5,r6
	tbitb	b_def,(r6)
	if	fs
	 movd	2(r6),r5
	 addd	8,r5		;Must be 0-F
	 cmpd	h'f,r5
	 if	lo
	  bsr	prm_ovfl
	 end
	end

	restore	[r5]
	bsr	asm_fld

;If ACB then displacement required

	cmpqb	4,r3
	bne	ops_ret

	br	pc_ofst

;CPU short reg list (LPR, SPR)

t_shreg:
	byte	$"MOD "
	byte	$"INTB"
	byte	$"PSR "
	byte	$"CFG "
	byte	$"USP "
	byte	$"SB  "
	byte	$"SP  "
	byte	$"FP  "
	byte	$"    "
	byte	$"    "
	byte	$"    "
	byte	$"CAR "
	byte	$"DSR "
	byte	$"BPC "
	byte	$"DCR "
	byte	$"UPSR"

afmt_3:	cmpqb	2,m_pass
	if	ne
	 movw	h'7c,0(r7)
	endif

;If bit 1 clear then opcode size = 4

	tbitb	1,r5
	bfs	asm_fld
	movqb	3,m_int
	movqb	4,m_siz
	br	asm_fld

afmt_4:	cmpqb	2,m_pass
	if	ne
	 movqw	0,0(r7)
	endif

;If ADDR/LXPD then size is 4

	cmpb	9,r3
	bne	asm_fld
	movqb	3,m_int
	movqb	4,m_siz
	br	asm_fld

afmt_5:	cmpqb	2,m_pass
	if	ne
	 movb	h'e,0(r7)
	 movqw	0,1(r7)
	endif
	movqb	0,2(r6)		;Default of 0 if no list follows
	cmpqb	2,r3		;Check for SETCFG
	if	eq
	 movqd	3,m_int		;Size is always 3
	 bsr	nxt_txt		;List is required
	 addr	t_cfg,r2
	 bsr	bit_lst		;Short field in 2(R6)
	else
	 cmpqb	3,r3		;0,1,3 are string opcodes
	 if	hs		;This is a string opcode
	  movb	-1(r1),r3	;Save last letter of source opcode
	  addr	t_strop,r2
	  bsr	bit_lst		;Short field in 2(R6)
	  cmpb	"T",r3		;If "T" then size = 1, add 1 to short field
	  if	eq
	   movqb 0,m_int
	   addqb 1,2(r6)
	  endif
	 else			;CG16 graphics ops here
	  tbitb	0,r3		;BITBLT and BITWT are all even
	  if	fc
	   movqb 1,m_int	;Fixed value for all but BBAND
	   cmpb	8,r3		;Check for BITWT
	   if	ne
	    cmpb h'c,r3		;No options with BBFOR
	    if	ne
	     addr t_bitblt,r2
	     bsr bit_lst	;Check for options
	    endif
	    cmpb h'a,r3		;BBAND
	    if	eq
	     movqb 3,m_int
	     addqb 2,2(r6)	;Bit 1 of short field set for this
	    endif
	   endif
	  else
	   cmpqb 7,r3		;All but MOVMPi have fixed size
	   if	ne
	    movqb 3,m_int
	   endif
	   cmpb 9,r3		;TBITS includes options
	   if	eq
	    addr t_tbs,r2
	    bsr	bit_lst
	   endif
	  endif
	 endif
	endif
	br	asm_fld

;CMPS, MOVS options list
t_strop:
	byte	3
	byte	$"B   "
	byte	$"U   "
	byte	$"W   "
	byte	4
	byte	h'c
	byte	2


;Config list (SETCFG)

t_cfg:	byte	4
	byte	$"I   "
	byte	$"F   "
	byte	$"M   "
	byte	$"C   "
	byte	8
	byte	4
	byte	2
	byte	1

;BITBLT option list

t_bitblt:
	db	4
	db	$"IA  "
	db	$"DA  "
	db	$"S   "
	db	$"-S  "
	db	1
	db	0
	db	4
	db	0

;TBITS options list

t_tbs:
	db	2
	db	$"0   "
	db	$"1   "
	db	1
	db	0


afmt_6:	cmpqb	2,m_pass
	if	ne
	 movb	h'4e,0(r7)
	 movqw	0,1(r7)
	endif

;If ASH, LSH, ROT then size is always 1

	cmpqb	5,r3
	beq	afmt_6a
	cmpqb	1,r3
	blo	asm_fld
afmt_6a:
	movqb	1,m_siz
	bsr	asm_fld
	cmpb	h'14,gen1
	bne	ops_ret
	tbitb	b_def,gen1+2
	bfc	ops_ret
	movd	gen1+4,r2
	addd	31,r2		;-31 => 31 is OK
	cmpd	31+31,r2
	blo	prm_ovfl
	ret


afmt_7:	cmpqb	2,m_pass
	if	ne
	 movb	h'ce,0(r7)
	 movqw	0,1(r7)
	endif
	cmpqb	6,r3
	bls	asm_fld

	cmpqb	1,r3		;Check for MOVM, CMPM
	bhs	afmt_7b

	cmpqb	4,r3		;Check for MOVXBW or MOVZBW
	bhi	afmt_7a

;This is MOVXBW or MOVZBW, set size to 0

	movqb	0,m_int
	movqb	1,m_siz
	br	asm_fld

;This is INSS or EXTS, need offset and length

afmt_7a:
	bsr	asm_fld
	bsr	def_r5
	cmpqd	7,r5
	blo	prm_ovfl	;Max offset is 7

	movb	r5,r2		;Offset to R2
	bsr	def_r5		;Length to R5
	addqd	-1,r5
	cmpd	31,r5
	blo	prm_ovfl

	lshb	5,r2
	orb	r2,r5
	movb	r5,0(r7)
	addqd	1,r7
	ret	0

;This is MOVM or CMPM, need length

afmt_7b:
	bsr	asm_fld
	cmpb	h'14,gen1
	if	eq
	 bsr	err_imm
	endif
	bsr	def_r5

	addqb	-1,r5
	mulb	m_siz,r5
	movb	r5,0(r7)
	addqd	1,r7
	addb	m_siz,r5	;Actual number of bytes moved
	cmpb	16,r5
	blo	prm_ovfl
	ret	0


afmt_8:	cmpqb	2,m_pass
	if	ne
	 movb	h'2e,0(r7)
	 movqw	0,1(r7)
	 inssb	r5,0(r7),6,2	;LS 2 bits of op in bits 6-7 of 0(R7)
	 movqb	4,r2
	 andb	r5,r2
	 movb	r2,1(r7)	;Bit 3 of op to bit 3 of 1(R7)
	endif

	movqd	0,2(r6)		;Default is 0

	cmpqb	5,r3		;Check for FFS
	beq	asm_fld

;If MOVSUi or MOVUSi then short field is fixed

	cmpqb	6,r3
	bne	afmt_8a
	movqd	1,2(r6)
	cmpb	"U",-2(r1)	;MOVSUi if EQ
	beq	asm_fld
	movqd	3,2(r6)
	br	asm_fld
afmt_8a:

;Get reg in short field

	bsr	nxt_txt
	bfs	ops_ret
	addr	t_rgsht,r2
	movzbd	8,r0		;Number of entries in list
	bsr	shrt_lst	;Short field in 2(R6)

	cmpqb	3,r3		;Done if CHECK or INDEX
	bls	asm_fld

	cmpqb	1,r3		;If CVTP then size = 3
	bne	afmt_8b
	movqb	3,m_int
	movqb	4,m_siz
	br	asm_fld

;This is EXT or INS, length needed

afmt_8b:
	bsr	asm_fld
	bsr	def_r5
	movb	r5,(r7)
	addqd	1,r7
	cmpb	32,r5
	blo	prm_ovfl
	ret

;Reg list for short parameter

t_rgsht:
	byte	$"R7  "
	byte	$"R6  "
	byte	$"R5  "
	byte	$"R4  "
	byte	$"R3  "
	byte	$"R2  "
	byte	$"R1  "
	byte	$"R0  "

afmt_9:	andb	7,r3		;Op is only 3 bits
	andb	7,r5
	cmpqb	2,m_pass
	if	ne
	 movb	h'3e,0(r7)
	 movqw	0,1(r7)
	endif
	movb	m_int,m_siz	;Integer size sets size
	addqb	1,m_siz
	cmpqb	0,r3		;Normal if MOVif
	beq	asm_fld

;If ROUND, TRUNC, FLOOR then size is float size

	notb	m_flt,m_siz
	mulb	4,m_siz		;F=0, L=4
	addqb	4,m_siz		;F=4, L=8

	cmpqb	4,r3		;ROUNDfi
	beq	asm_fld
	cmpqb	5,r3		;TRUNCfi
	beq	asm_fld
	cmpqb	7,r3		;FLOORfi
	beq	asm_fld

;Check for MOVFL

	movqb	3,m_int		;Fixed at 11 if MOVFL
	movqb	0,m_flt		;Fixed
	movqb	4,m_siz
	cmpqb	3,r3
	beq	asm_fld

;Check for MOVLF

	movqb	2,m_int		;Fixed at 10 if MOVLF
	movqb	1,m_flt		;Fixed
	movb	8,m_siz
	cmpqb	2,r3
	beq	asm_fld

;This is LFSR or SFSR, register gen is always 0

	movqb	3,m_int		;Always 4 bytes
	movqb	4,m_siz
	movqb	1,m_flt		;Always 1

;If LFSR then gen2 is fixed at 0

	cbitb	12,(r4)		;Gen 1 on
	cmpqb	1,r3
	beq	asm_fld

;This is SFSR

	cbitb	11,(r4)		;Gen 1 off
	sbitb	12,(r4)		;Gen 2 on
	br	asm_fld

afmt_b:	cmpqb	2,m_pass
	if	ne
	 movb	h'be,0(r7)
	 movqw	0,1(r7)
	endif
afmt_b1:
	notb	m_flt,m_siz
	addqb	1,m_siz
	lshb	2,m_siz		;4 for float, 8 for long
	br	asm_fld

afmt_c:	cmpqb	2,m_pass
	if	ne
	 movb	h'fe,0(r7)
	 movqw	0,1(r7)
	endif
	br	afmt_b1

afmt_e:	cmpqb	2,m_pass
	if	ne
	 movw	h'31e,0(r7)	;Size fixed to 4 bytes
	 movqb	0,2(r7)
	endif
	movqb	3,m_int
	movqb	4,m_siz
	movqd	0,2(r6)		;Default short field is 0
	cmpqb	1,r3		;Check for RDVAL or WRVAL
	bhs	asm_fld

	bsr	nxt_txt		;Short field required
	cmpb	9,r3		;CINV
	if	eq
	 addr	t_cinv,r2
	 bsr	bit_lst
	 br	asm_fld
	endif

	addr	t_mreg,r2
	movzbd	h'10,r0		;Number of list entries
	bsr	shrt_lst
	cond	mmu532
	 cmpb	15,2(r6)	;Check for IVAR
	 if	eq
	  movb	-1(r1),r2	;Digit
	  subb	"1",r2		;0=>-1, 1=>0
	  addb	r2,2(r6)
	 endif
	cend
	cmpqb	3,r3		;Check for SMR
	bne	asm_fld
	bsr	asm_fld
	cmpb	h'14,gen1
	beq	err_imm
	ret

t_cinv:
	db	4
	db	$"A   "
	db	$"I   "
	db	$"D   "
	db	$"    "
	db	0
	db	1
	db	2
	db	4
t_mreg:
	cond	mmu082
	 db	$"EIA "
	cend
	cond	mmu532
	 db	$"IVAR"		;IVAR1
	cend
	db	$"IVAR"		;IVAR0
	db	$"PTB1"
	db	$"PTB0"
	cond	mmu082
	 db	$"BCNT"
	cend
	cond	mmu532
	 db	$"TEAR"
	cend
	db	$"MSR "
	db	$"MCR "
	db	$"SC  "
	db	$"    "
	db	$"    "
	db	$"PF1 "
	db	$"PF0 "
	db	$"    "
	db	$"    "
	db	$"BPR1"
	db	$"BPR0"

afmt_a:
afmt_d:
afmt_f:

pfmt_1:
pfmt_6:
pfmt_7:
pfmt_8:
pfmt_9:
pfmt_b:
pfmt_c:
pfmt_e:

	br	opcd_err

;R1 points to text, load R1 with pointer to 1st valid character
;R0 with parameter length, R2 with total length including closing character
;Parameter is from comma to comma unless <>, "", '', or && only

prm_len:
	movd	r1,tos		;Save very beginning of <> or "" strings
	bsr	str_len
	movd	r2,tos		;Entire length of <> or "" parameter
	movd	r1,tos		;Starting address
	movd	r0,tos		;Valid parameter length
	addd	r2,r1		;Skip over initial string
	until eq
	 bsr	next
	quit	fs		;Nothing to do if end of line
	 cmpb	",",(r1)	;Everything counts until comma
	 if	ne
	  movd	3*4(sp),4(sp)	;Start at very beginning now
	  bsr	str_len
	  addd	r2,r1
	  movd	r1,8(sp)	;Current text pointer
	  subd	4(sp),8(sp)	;Everything counts if multiple words
	  movd	8(sp),(sp)	;New R0 length too
	  bicpsrb flag_z	;Make NE - keep going
	 endif
	endu
	movd	tos,r0
	movd	tos,r1
	movd	tos,r2
	adjspb	-4		;Clear original start of parameter
	ret


;Execute MACRO in MAC_STK
;1st byte is pseudo-op, next 4 bytes point to text
;R1 => untranslated source, R2 => translation buffer
;Anything but MACRO: R1 => MEND

do_macro:
	lproc
	reg	[]
mvar_ptr: ds	4		;Pointer to MACRO variables
mprm_ptr: ds	4		;Pointer to MACRO parameters
msrc_ptr: ds	4		;Pointer to MACRO source text
mr2_ptr: ds	4		;Pointer to beginning of translation buffer
mstk:	ds	1		;Storage for MAC_STK pseudo-op
buf:	ds	10		;Buffer for building link table name
msym:	ds	4		;Pointer to link symbol entry
sym_lcl: blkd			;Old local symbol table
sym_1st: blkd			;Address of 1st local symbol
	code

	movb	mac_stk,mstk	;Save pseudo-op here
	movd	r2,mr2_ptr	;Base address of translation buffer
	movd	t_symlcl,sym_lcl
	movd	m_sym1st,sym_1st ;Save original start of local symbols
	movd	tsym_end,m_sym1st ;Default start of local symbols
	subd	t_symbl,m_sym1st ;Must be offset from beginning
	cmpqb	0,mac_ex	;If outer macro then clear local table
	if	eq		;New macro block if EQ
	 movb	m_ascond,m_macond ;Save copy here
	 sbitb	b_xlat,m_ascond	;Force translation
	 if	fc		;See if translation was already on
	  sbitb	b_lxlat,m_ascond ;Local translation only if not already on
	 endif
	 movd	sidx_end,t_symlcl ;New local stack
	 movb	m_dolst,m_mdolst ;Current listing flags
	 tbitb	b_maclst,m_dolst ;See if macro listing requested
	 if	fc		;No listing if FC
	  bicb	exp b_alist+exp b_xrf,m_dolst
	 endif
	endif

	cmpqb	2,m_pass
	if	eq
	 movzbd	lcod_mac,tos
	 inssb	mac_cnt,tos,0,7	;Merge in lower 7 bits of counter
	 bsr	link_pc		;Get link table block for this macro
	 movd	tos,r2
	 if	eq
	  cmpqb	0,mac_ex
	  if	eq		;If nested macro then use outer symbol table
	   movd	7(r2),t_symlcl	;Restore local symbol table
	  endif
	  movd	11(r2),mac_stk+1 ;Pointer to macro text
	 endif
	else			;Make symbol on link table
	 movqd	0,tos		;Create room for returned entry
	 bsr	last_lnk	;Get next link table address
	 movd	tos,r3
	 movb	9,tos		;9 byte name
	 movw	exp b_def+(h'2e lsh b_mode),tos
	 addr	buf,tos		;Pointer to name
	 movd	r3,tos		;Previous symbol pointer
	 movb	lcod_mac,buf	;Macro code
	 inssb	mac_cnt,buf,0,7	;May be nested at same PC
	 movd	t_symlcl,1+buf	;Pointer to local symbol table
	 movd	mac_stk+1,5+buf ;Pointer to text
	 bsr	make_sym
	 extsd	m_symadr,r2,0,sidx_bit
	 addd	t_symbl,r2
	 movd	m_pcptr,2(r2)	;Address of macro
	 movd	m_symadr,msym	;This is needed at end of routine
	endif

;Define MACRO parameter labels now
;Translate line as needed

	movd	mr2_ptr,r2	;Translation buffer
	cmpb	16*op_mac+mac_mac,mstk ;Check for regular MACRO
	if	ne
	 movd	mac_stk+1,r1	;This is pointer for non-MACRO
	 bsr	bld_lin
	 movd	mr2_ptr,r1	;Translated text
	 movd	r1,mvar_ptr	;Variable pointer for non-macro
	else
	 bsr	bld_lin
	 movd	mr2_ptr,r1	;Translated text
	 bsr	length
	 addd	r0,r1
	 bsr	skp_coln	;Skip over label if any
	 bsr	next
	 bsr	length		;Length of MACRO name
	 addd	r0,r1		;R1 points to translated parameters
	 movd	mac_stk+1,mvar_ptr ;Variable names for MACRO
	 movd	r1,mprm_ptr	;Parameter pointer for MACRO
	endif

	cmpb	16*op_mac+mac_irp,mstk ;Check for IRP
	if	eq
	 bsr	next		;Point to variable
	 bsr	length		;Length of variable
	 addd	r0,r1		;Advance to next word after variable
	 bsr	next
	 bfs	do_macx		;Quit now if no parameters
	 movd	r1,mprm_ptr	;Parameters for MACRO
	else
	 cmpb	16*op_mac+mac_rpc,mstk ;Check for IRPC
	orif	eq
	 cmpb	16*op_mac+mac_rpl,mstk ;Check for IRPL
	 if	eq
	  movd	mac_stk+1,r1	;Pointer to stored values
	  movqd -1,r0
	  movb	cr,r4
	  skpsb u		;Advance to next line
	  addqd 1,r1		;Advance past CR
	  movd	r1,mprm_ptr	;Parameters for MACRO
	 endif
	endif

;Ready to process variable names and parameters now

	movd	mvar_ptr,r1
	cmpb	16*op_mac+mac_rpt,mstk ;Check for REPT block
	if	eq
	 bsr	def_r5		;Get count in R5
	 bfs	do_macx		;Undefined if FS
	 cmpqd	0,r5
	 beq	do_macx		;Can't do 0 count
	else
	 begin
	  bsr	comma
	 while	fc		;Got pointer to parameter name in R1
	  bsr	length		;Get length in R0
	  addr	t_symlcl,r3
	  bsr	sym2sub		;Search local table
	  if	ne
	   cmpqb 2,m_pass
	   if	eq
	    bsr	err_phs
	   endif
	   save	[r3]
	   bsr	sym2val		;Can't be in other symbol tables either
	   restore [r3]
	   if	eq
	    bsr	dup_sym
	   else
	    movb r0,tos		;Length of symbol
	    movw (h'8c lsh b_mode),tos ;Variable type
	    movd r1,tos		;Pointer to symbol name
	    movd r3,tos		;Previous symbol pointer
	    bsr	make_sym	;Create undefined local symbol
	   endif
	  else
	   cmpqb 2,m_pass
	   if	ne
	    save [r5]
	    movd m_symadr,r5
	    tbitb b_def,0(t_symbl)[r5:b]
	    restore [r5]
	    if	fs
	     bsr dup_sym	;Error if defined symbol found
	    endif
	   endif
	  endif
	  addd	r0,r1		;Skip over symbol name
	  save	[r1]
	  movd	mprm_ptr,r1	;Pointer to source parameters
	  bsr	comma
	  save	[r3]
	  extsd	m_symadr,r3,0,sidx_bit
	  addd	t_symbl,r3
	  cmpb	16*op_mac+mac_rpc,mstk ;Check for IRPC
	  if	eq
	   movqw 1,2(r3)	;Length always 1 if IRPC
	   movd	r1,4(r3)	;Pointer to symbol
	   addqd 1,r1		;Pointer to next parameter
	  else
	   bsr	prm_len		;Get length/pointer like STR_LEN
	   movw r0,2(r3)	;Length of symbol
	   movd	r1,4(r3)	;Pointer to symbol
	   addd r2,r1		;Skip over parameter text
	  endif
	  sbitb	b_def,(r3)	;Must be defined
	  restore [r3]
	  movd	m_symadr,r2
	  cmpd	r2,m_sym1st	;See if new lowest value
	  if	lo
	   movd	r2,m_sym1st	;Lowest symbol here
	  endif
	  movd	r1,mprm_ptr
	  restore [r1]
	  cmpb	16*op_mac+mac_irp,mstk
	 quit	eq		;Only 1 parameter if IRP
	  cmpb	16*op_mac+mac_rpc,mstk
	 quit	eq		;Only 1 parameter if IRPC
	 endw
	endif

;All variables now defined
;Find beginning of source text

	movd	mac_stk+1,r1	;Line just before source text
	cmpb	16*op_mac+mac_rpl,mstk ;Check for IRPL
	if	eq
	 movqd	-1,r0
	 movb	vc_xpag,r4	;This precedes 1st line of source
	 skpsb	u
	endif
	movd	r1,msrc_ptr	;Pointer to line before source code starts

	addqb	1,mac_ex	;Macro now executing
	addqb	1,mac_cnt	;Increment counter
mac_loop:
	save	[r5]		;Count if REPT
	movd	msrc_ptr,r1
	until	eq
	 movqd	-1,r0		;Infinite search length
	 movb	cr,r4
	 skpsb	u		;Find CR at end of line
	 addqd	1,r1		;Advance to next line
	 bsr	a_onelin	;Do one line of MACRO
	 cmpw	16*op_mac+(exp b_ps)+mac_end,m_opcod ;Stop if MEND
	 if	ne
	  cmpw	16*op_mac+(exp b_ps)+mac_xit,m_opcod ;Also stop if MEXIT
	 endif
	endu
	restore	[r5]

;Undefine all local variables set by this macro loop

	movd	m_sym1st,r3	;Offset to start of symbols
	addd	t_symbl,r3	;Need actual address now
	addqd	-sidx_of,r3	;Backup to offset word of 1st symbol
	addr	t_symlcl,r2	;Local symbol storage
	begin
	 extsd	(r2),r2,0,sidx_bit
	 cmpd	sidx_end,r2
	while	ne
	 addd	t_symbl,r2
	 cmpd	r2,r3		;See if this symbol goes with this loop
	 if	hs
	  cbitb	b_def,sidx_of(r2)
	 endif
	endw

;Quit now if MEXIT stopped macro

	cmpw	16*op_mac+(exp b_ps)+mac_xit,m_opcod
	beq	do_macx

	cmpd	max_err,m_errct	;If max errors then quit now
	blo	do_macx

	cmpb	16*op_mac+mac_mac,mstk
	if	ne
	 cmpb	16*op_mac+mac_rpt,mstk
	 if	eq
	  addqd	-1,r5
	  cmpqd	0,r5
	  bne	mac_loop
	 else			;This is IRP, IRPC or IRPL
	  movd	mvar_ptr,r1	;Variable pointer to R1
	  bsr	comma
	  bsr	length
	  addr	t_symlcl,r3
	  bsr	sym2sub		;Get symbol name pointer
	  cmpb	16*op_mac+mac_rpl,mstk ;Check for IRPL
	  if	eq
	   movd	mprm_ptr,r1
	   movqd -1,r0
	   movb	cr,r4
	   skpsb u		;Find end of line
	   addqd 1,r1		;Advance to next line
	   movd	r1,mprm_ptr
	   cmpb	vc_xpag,(r1)
	   if	ne		;Still more if NE
	    movd mvar_ptr,r1
	    begin
	     bsr comma
	    while fc		;Assign variables as long as they come
	     bsr length
	     addr t_symlcl,r3
	     bsr sym2sub
	     addd r0,r1		;Skip over symbol name
	     if	eq
	      save [r1,r3]
	      movd mprm_ptr,r1
	      bsr comma
	      bsr prm_len
	      movd m_symadr,r3
	      addd t_symbl,r3
	      movw r0,2(r3)
	      movd r1,4(r3)
	      sbitb b_def,(r3)
	      addd r2,r1
	      movd r1,mprm_ptr
	      restore [r1,r3]
	     endif
	    endw
	    br	mac_loop
	   endif
	  else			;This is IRP or IRPC
	   movd	mprm_ptr,r1	;Pointer to next parameter
	   movd	m_symadr,r4
	   addd	t_symbl,r4
	   bsr	comma
	   if	fc		;Still coming if FC
	    cmpb 16*op_mac+mac_irp,mstk ;Check for IRP
	    if	eq
	     bsr prm_len
	     movw r0,2(r4)
	     movd r1,4(r4)	;Pointer to next symbol
	     addd r2,r1
	    else
	     movd r1,4(r4)	;Pointer to next symbol
	     addqd 1,r1
	    endif
	    sbitb b_def,(r4)
	    movd r1,mprm_ptr	;Next pointer
	    br	mac_loop	;Do it all again
	   endif
	  endif
	 endif
	endif

;Exit point for macro execution
;Zap local variable names, restore status and exit

do_macx:
;	MOVD	MVAR_PTR,R1
;	CMPB	16*OP_MAC+MAC_RPT,MSTK
;	IF	NE
;	 BEGIN
;	  BSR	COMMA
;	 WHILE	FC		;Got pointer to variable name in R1
;	  BSR	LENGTH		;Get length in R0
;	  ADDR	T_SYMLCL,R3
;	  BSR	SYM2SUB		;Search local table
;	  IF	EQ
;	   CBITB B_DEF,(M_SYMADR) ;Label now invalid
;	  ENDIF
;	  CMPB	16*OP_MAC+MAC_IRP,MSTK
;	 QUIT	EQ		;Only 1 variable if IRP
;	  CMPB	16*OP_MAC+MAC_RPC,MSTK
;	 QUIT	EQ		;Only 1 variable if IRPC
;	 ADDD	R0,R1		;Advance to next variable
;	 ENDW
;	ENDIF

	cmpqb	2,m_pass
	if	ne
	 addd	t_symbl,msym	;Convert offset back to pointer
	 movd	t_symlcl,7(msym) ;Store local symbol table pointer
	endif
	movd	sym_1st,m_sym1st ;Restore outer M_SYM1ST
	addqb	-1,mac_ex	;No longer executing this macro
	cmpqb	0,mac_ex
	if	eq
	 movd	sym_lcl,t_symlcl ;Restore original local symbol table
	 bicb	exp b_lxlat+exp b_xlat,m_ascond
	 movb	m_macond,r5	;Copy
	 andb	exp b_lxlat+exp b_xlat,r5
	 orb	r5,m_ascond	;Restore updated xlat status
	 bicb	exp b_alist+exp b_xrf,m_dolst
	 movb	m_mdolst,r5	;Copy
	 andb	exp b_alist+exp b_xrf,r5
	 orb	r5,m_dolst	;Restore updated list status
	else
	 movw	h'ff,m_opcod	;Cancel M_OPCOD for nested macros
	endif
	pend


;Format 0 is control pseudo-ops

pfmt_0:	casew	pfmt01[r3:w]
pfmt01:	word	ops_ret-pfmt_0	;STOP (0)
	word	do_acpt-pfmt_0	;ACCEPT (1)
	word	do_fld-pfmt_0	;FIELD (2)
	word	do_abt-pfmt_0	;ABORT (3)
	word	do_prnt-pfmt_0	;PRINT (4)
	word	do_acnd-pfmt_0	;COND (5)
	word	do_cels-pfmt_0	;CELSE (6)
	word	do_cend-pfmt_0	;CEND (7)
	word	do_clst-pfmt_0	;LIST (8)
	word	do_algn-pfmt_0	;ALIGN (9)
	dw	ops_ret-pfmt_0	;ENDMOD (10)

;Align current mode pointer on given byte boundary
;Optional 2nd displacement added to final value

do_algn:
	bsr	def_r5
	bfs	ops_ret

	movd	(m_amodp),r4
	modd	r5,r4
	cmpqd	0,r4
	if	ne
	 subd	r4,r5
	 addd	r5,(m_amodp)
	endif

	bsr	comma		;Optional offset
	bfs	ops_ret
	bsr	def_r5
	bfs	ops_ret
	addd	r5,(m_amodp)

	ret


;Set conditional list status

do_clst:
	bsr	def_r5		;Get expression
	inssb	r5,m_dolst,b_alist,1 ;Set current status
	inssb	r5,m_mdolst,b_alist,1 ;Copy saved by macros
	ret


;Set conditional assembly flag, set = don't assemble

do_acnd:
	cmpqb	0,acnd_ptr
	if	eq
	 movd	m_lincnt,acnd_lst ;Stack last empty here
	endif
	movzbd	acnd_ptr,r2
	movb	m_ascond,acnd_stk[r2:b]	;Store current value
	addqb	1,acnd_ptr	;Increment pointer
	tbitb	b_asmbl,m_ascond ;See if COND within false conditional
	if	fc		;Don't enable if false conditional in progress
	 bsr	def_r5		;Get expression
	 notb	r5,r5		;Set flag if not assembling this block
	 inssb	r5,m_ascond,b_asmbl,1 ;Set current status
	else
	 bsr	skp_prm		;Skip over parameters
	endif
	ret

;Else portion of conditional assembly block

do_cels:
	movzbd	acnd_ptr,r2
	cmpqd	0,r2		;Must be COND in progress
	if	eq
	 addqd	1,m_errct
	 bsr	dsp_msg
	 byte	"CELSE without COND",cr,lf,0
	else
	 addqd	-1,r2
	 movb	acnd_stk[r2:b],r2 ;Get status at start of this COND block
	 tbitb	b_asmbl,r2
	 if	fc
	  ibitb	b_asmbl,m_ascond
	 endif
	endif
	ret
	

;End of conditional assembly block

do_cend:
	cmpqb	0,acnd_ptr
	if	eq
	 addqd	1,m_errct
	 bsr	dsp_msg
	 byte	"CEND without COND",cr,lf,0
	 ret
	endif

	addqb	-1,acnd_ptr
	movzbd	acnd_ptr,r2
	movb	acnd_stk[r2:b],r2
	andb	exp b_asmbl,r2		;Only want assemble bit
	cbitb	b_asmbl,m_ascond	;Clear current status
	orb	r2,m_ascond		;Merge original B_ASMBL

	cmpqb	0,acnd_ptr
	if	eq
	 movd	m_lincnt,acnd_lst	;Stack last empty here
	endif
	ret


do_acpt:
	br	bad_exp		;Do this later

;Print following text

do_prnt:
	movzbd	10,r5
	bsr	aray_r5
	bfs	ops_ret
	begin
	 bsr	comma
	while	fc
	 bsr	ex		;Get value in 2(R5)
	 movw	m_radix,tos
	 extsb	1(r5),r2,b_size-8,4
	 cmpb	8,r2
	 if	eq		;Force ASCII display if string
	  orw	exp b_asc+exp b_lit,(sp) ;Literal ASCII display
	 endif
	 bsr	dsp_2r5		;Display according to TOS
	endw
	br	do_cr


;Set MAX_ERR to selected value

do_abt:	bsr	def_r5
	cbitb	31,r5		;Never more than this
	movd	r5,max_err
	ret

;Put bits into bit field [width]value
;Starts with LSB

do_fld:	movqd	0,r3		;Bit counter
	movqd	0,r4		;Build value here
	begin
	 bsr	comma
	while	fc
	 cmpb	"[",(r1)	;Must start with this
	 if	ne
	  bsr	bad_exp
	 endif
	 addqd	1,r1
	 movqd	1,r2		;Default size if undefined
	 bsr	def_r5
	 movd	r5,r2		;Current bit field size
	 bsr	nxt_txt
	quit	fs
	 cmpb	"]",(r1)
	 if	ne
	  bsr	bad_exp
	 endif
	 addqd	1,r1
	 bsr	def_r5		;Get actual field value now
	 save	[r2,r3]
	 movqd	1,r3
	 lshd	r2,r3		;Max size + 1 for field value
	 cmpd	r3,r5
	 restore [r2,r3]
	 if	ls
	  bsr	prm_ovfl
	 endif
	 lshd	r3,r5		;Shift to proper bit position
	 ord	r5,r4		;Merge in new value
	 addd	r2,r3		;New bit total
	 cmpd	32,r3
	 if	lo
	  bsr	prm_ovfl	;32 bit max
	  movqd 1,r3
	 endif
	endw

	addqd	7,r3
	divd	8,r3		;Round up to nearest byte boundary
	begin
	 cmpqd	0,r3
	while	ne
	 movb	r4,(r7)
	 addqd	1,r7
	 lshd	-8,r4
	 addqd	-1,r3
	endw
	ret

bad_exp:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Error in expression",cr,lf,0
	ret


;Pseudo-op format 2 is listing control

pfmt_2:	casew	pfmt21[r3:w]
pfmt21:	dw	do_lfc-pfmt_2	;FLIST
	dw	do_lmac-pfmt_2	;MLIST
	dw	do_xlt-pfmt_2	;XLAT
	dw	do_width-pfmt_2	;WIDTH
	dw	do_1lst-pfmt_2	;M1LIST
	dw	do_pprnt-pfmt_2	;PPRINT

;Pass 1 listing

do_1lst:
	bsr	def_r5
	inssb	r5,m_dolst,b_1lst,1
	ret

;False conditional listing control

do_lfc:	bsr	def_r5
	inssb	r5,m_dolst,b_fclst,1
	ret

;Macro expansion listing control

do_lmac:
	bsr	def_r5
	inssb	r5,m_dolst,b_maclst,1
	ret

;String translation control

do_xlt:	bsr	def_r5
	inssb	r5,m_ascond,b_xlat,1 ;New translation status
	cbitb	b_lxlat,m_ascond ;Local only bit always off
	inssb	r5,m_macond,b_xlat,1 ;Update image saved by macros too
	cbitb	b_lxlat,m_macond

	cmpqb	0,mac_ex	;See if a macro is executing
	if	ne
	 sbitb	b_xlat,m_ascond	;Force translation
	 if	fc		;See if translation was already on
	  sbitb	b_lxlat,m_ascond ;Local translation only if not already on
	 endif
	endif

	ret

do_width:
	bsr	def_r5
	movd	r5,m_width
	ret

;Like PRINT but send to list device
;If print pass not selected, do nothing

do_pprnt:
	tbitb	b_alist,m_dolst
	if	fc		;Printer must be selected
	 bsr	skp_prm		;Skip over parameters
	else
	 cmpqb	2,m_pass
	 if	eq
	  movb	tx_dev,tos
	  movb	dev_pr,tx_dev	;Route to printer
	  cmpb	"I",m_pass
	  if	eq
	   movzbd dev_pr,r6
	   bsr	dev_open
	  endif
	  bsr	do_prnt
	  cmpb	"I",m_pass
	  if	eq
	   movzbd dev_pr,r6
	   bsr	dev_clos
	  endif
	  movb	tos,tx_dev
	  bispsrb flag_z	;Make EQ
	 else
	  tbitb	b_1lst,m_dolst
	 orif	fs
	 endif
	orif	ne
	endif

	ret


;Format 3 is LINK pseudo-ops

pfmt_3:	casew	pfmt31[r3:w]
pfmt31:	dw	do_mod-pfmt_3	;MODULE
	dw	do_stk-pfmt_3	;STACK
	dw	do_glb-pfmt_3	;GLOBAL
	dw	do_ext-pfmt_3	;EXTRN
	dw	do_eun-pfmt_3	;EXTUNDF
	dw	do_sym-pfmt_3	;SYMBOLS
	dw	do_plnk-pfmt_3	;LINK
	dw	do_onem-pfmt_3	;ONEMOD

do_plnk:
	cmpqb	2,m_pass
	beq	ops_ret		;Don't do anything here

	cond	op_sys
	 bsr	next
	 if	fc		;Something found if FC
	  cmpb	",",(r1)
	  if	ne		;File name if NE
	   bsr	length
	   movw	usr_exe,r5	;Default file type
	   bsr	dev_fname	;Set default name
	   addd	r0,r1
	   bsr	comma		;Skip comma too
	  else
	   addqd 1,r1		;Skip comma
	  endif
	 endif
	cend

	movd	mod_indx,r4	;Next module number
	muld	mod_tsiz,r4
	addr	mod_tabl[r4:b],r4 ;Offset to module name offset
	inssd	sidx_end,4+4+2+sidx_of(r4),0,sidx_bit ;Initialize to no name

	bsr	next
	if	fc		;Something found if FC
	 cmpb	",",(r1)
	 if	ne		;Module name if NE
	  bsr	length
	  bsr	sym2val		;See if symbol already exists
	  if	eq
	   bsr	sym_rdf		;Must be new symbol
	  else			;Not found if NE
	   movb	r0,tos		;Length of name
	   movw	h'2400+lbl_ext lsh b_typ,tos ;External undefined integer
	   movd	r1,tos		;Pointer to name
	   movd	r3,tos		;Address of previous symbol
	   bsr	make_sym
	   movd	m_symadr,r5	;Address of symbol name in table
	   inssd r5,4+4+2+sidx_of(r4),0,sidx_bit ;Name index
	   addqd -sidx_of,r5	;Backup to index field
	   inssd r5,4+4+2(r4),0,sidx_bit ;First symbol address
	  endif
	  addd	r0,r1
	  bsr	comma		;Skip comma too
	 else
	  addqd	1,r1		;Skip comma
	 endif
	endif

	addd	4+4+2+2*sidx_of+4,r4 ;Advance to PC value
	movqb	4,r2		;Max number of entries
	until	eq
	 movqd	-1,(r4)		;Initialize to undefined
	 bsr	next
	 if	fc
	  cmpb	",",(r1)
	  if	ne
	   bsr	def_r5		;Get current value
	   movd	r5,(r4)		;Store it
	   bsr	comma		;Advance to next field
	  else
	   addqd 1,r1		;Skip over comma
	  endif
	 endif
	 addqd	4,r4
	 addqb	-1,r2
	 cmpqb	0,r2
	endu

	ret


;Set PC, SB, MOD, LINK addresses

do_mod:
	bsr	get_smad
	movd	r2,r4
	cmpd	sidx_end,r4
	bls	sym_und		;Must have valid symbol here
	addd	t_symbl,r4
	movd	mod_indx,r3
	addqd	-1,r3		;Current module number

	cmpqb	2,m_pass
	if	ne		;Never on pass 2
	 cmpb	h'2b,1(r4)	;If not this then error
	 if	ne
	  bsr	sym_rdf
	 endif
	 andw	h'1f,(r4)	;Mask all but name length
	 orw	h'2400+lbl_ext lsh b_typ,(r4) ;External undefined integer
	endif

	muld	mod_tsiz,r3
	addr	mod_tabl[r3:b],r3 ;Offset to proper MOD_TABL
	inssd	m_symadr,4+4+2+sidx_of(r3),0,sidx_bit ;Module name offset
	addd	4+4+2+2*sidx_of+4,r3 ;Offset to proper PC address
	begin
	 bsr	comma
	while	fc		;Go until text is exhausted
	 movd	r1,tos
	 bsr	pad_blnk
	 cmpd	tos,r1
	quit	eq		;0 length label if EQ
	 save	[r1]
	 addr	mod_prms,r1
	 movqd	4,r0
	 skpsd	b,u
	 restore [r1]
	quit	fc		;Nothing found if FC
	 addqd	-1,r0		;Make offset 0-3
	 bsr	nxt_txt
	 cmpb	"=",(r1)
	quit	ne
	 addqd	1,r1
	 bsr	nxt_txt
	 bsr	def_r5
	 if	fc
	  movd	r5,r3[r0:d]
	 endif
	qend
	 bsr	prm_err
	endw

	ret

	db	$"PB  "
	db	$"SB  "
	db	$"MB  "
mod_prms: db	$"LB  "

;Set stack size, optional absolute address of TOS

do_stk:
	bsr	def_r5
	movd	r5,m_stksiz	;Set size in bytes
	bsr	comma
	bne	ops_ret		;No comma if NE
	bsr	def_r5
	movd	r5,m_stksiz+4
	ret

;Make following symbols global

do_glb:
	movqb	lbl_glb,r4
do_glb1:
	proc
	reg	[]
buf:	ds	2+8
	code

	begin
	 bsr	comma		;Advance to valid text
	while	fc
	 bsr	length
	 cmpqd	0,r0
	quit	eq
	 movd	r1,r6		;Save pointer to symbol name
	 addr	buf,r5
	 movw	h'2b lsh b_mode,buf ;Undefined PC relative
	 inssb	r4,buf,b_typ,2	;External/global designation
	 addd	r0,r1		;Skip over name
	 cmpb	":",(r1)
	 if	eq
	  bsr	ex_coln
	 endif
	 save	[r1]
	 movd	r6,r1
	 bsr	sym2val		;See if symbol already exists
	 restore [r1]
	 if	ne		;Not found if NE
	  movb	r0,tos		;Length of name
	  movw	buf,tos		;Label type
	  movd	r6,tos		;Pointer to name
	  movd	r3,tos		;Address of previous symbol
	  bsr	make_sym
	 else
	  cmpqb	lbl_glb,r4	;May declare global only
	  if	eq
	   movd	m_symadr,r2
	   addd	t_symbl,r2	;Pointer to symbol
	   inssb r4,(r2),b_typ,2 ;Global designation
	  else
	   bsr	dup_sym		;Can't declare local symbol external
	  endif
	 endif
	endw

	pend
	ret

do_ext:
	movqb	lbl_ext,r4
	br	do_glb1

;Set undefined to external status

do_eun:	bsr	def_r5
	inssb	r5,lnk_prm,0,1
	ret

;Save all symbols

do_sym:	bsr	def_r5
	inssb	r5,lnk_prm,1,1
	ret

;One big module

do_onem:
	bsr	def_r5
	inssb	r5,lnk_prm,2,1
	ret

;Format 4 is system settings

pfmt_4:	casew	pfmt41[r3:w]
pfmt41:	word	do_msiz-pfmt_4	;MEMSIZ
	dw	do_nsc-pfmt_4	;NSCGNX

;Set new SB size

do_msiz:
	bsr	def_r5
	bfs	ops_ret		;Don't alter this if error
	movd	r5,mem_siz
	ret

do_nsc:
	bsr	def_r5
	bfs	ops_ret		;Don't alter this if error
	inssb	r5,m_ascond,b_nscgnx,1
	addr	t_delim,m_delim	;Assume Kotekan
	addr	t_delim2,m_delim2
	tbitb	0,r5		;Check for NSC
	if	fs
	 addr	nsc_dlm,m_delim
	 addr	nsc_dlm2,m_delim2
	endif

	ret


;Format 5 is allocation

pfmt_5:	casew	pfmt51[r3:w]
pfmt51:	word	pf5org-pfmt_5	;ORG
	dw	dsl-pfmt_5	;BLKL

pf5org:
	bsr	def_r5
	bfs	ops_ret		;Don't alter this if error
	movd	r5,(m_amodp)	;Set new value
	ret

;Get M_SYMADR in R2
;If no symbol defined and NSCGNX, then name follows -
;  Create symbol unless pass 2

get_smad:
	save	[r3]
	extsd	m_symadr,r2,0,sidx_bit
	cmpd	sidx_end,r2	;Must be valid symbol there
	if	eq
	 tbitb	b_nscgnx,m_ascond ;Name follows if FS
	 if	fs		;Make symbol
	  bsr	nxt_txt		;It must follow
	  bsr	length
	  bsr	sym2val		;Must not be defined unless pass 2
	  if	eq
	   tbitb b_def,sidx_of(r2) ;OK if undefined
	   if	fs
	    cmpqb 2,m_pass
	    if	ne
	     extsb sidx_of(r2),r3,b_typ,2
	     cmpb lbl_tmp,r3	;These can be re-defined
	     if	ne
	      bsr sym_rdf
	     endif
	    endif
	   endif
	  else
	   movb	r0,tos		;Length of symbol
	   movw	(h'2b lsh b_mode+exp b_def),tos ;This is expected
	   movd	r1,tos		;Pointer to symbol name
	   movd	r3,tos		;Previous symbol pointer
	   bsr	make_sym	;Create undefined local symbol
	  endif
	  addd	r0,r1		;Skip over name
	  bsr	comma		;Advance to parameter field
	  extsd	m_symadr,r2,0,sidx_bit
	 endif
	endif
	restore	[r3]
	ret


;Format 10 is MACRO pseudo-ops

pfmt_a:	casew	afmta1[r3:w]
afmta1:	word	do_mac-pfmt_a	;MACRO
	word	do_irp-pfmt_a	;REPT
	word	do_irp-pfmt_a	;IRP
	word	do_irp-pfmt_a	;IRPC
	word	do_irp-pfmt_a	;IRPL
	word	do_lcl-pfmt_a	;LOCAL
	word	do_mend-pfmt_a	;MEND
	word	do_mxit-pfmt_a	;MEXIT
	word	do_lend-pfmt_a	;LEND

;Read a MACRO block into string storage until corresponding MEND

do_mac:	bsr	get_smad
	cmpd	sidx_end,r2	;Must be valid symbol there
	bls	sym_und
	addd	t_symbl,r2
	inssb	h'bc,1(r2),b_mode-8,8 ;Multi-line text
do_irp:	cmpqd	0,mac_rd
	if	eq
	 movd	m_lincnt,m_macclr
	endif
	addqd	1,mac_rd	;Just mark this as a MACRO
	movb	m_opcod,mac_stk	;Store pseudo-op

	cmpqb	0,mac_ex
	if	eq		;Don't want extraneous local translations
	 movd	sidx_end,t_symlcl
	endif

	cmpqb	2,m_pass
	if	eq
	 movd	buf_siz,r0
	 movb	cr,r4
	 skpsb	u		;Advance to end of line
	 ret
	endif			;Nothing else to do if pass 2

;Store remaining text

	cmpqb	0,mac_ex	;See if macro executing now
	if	ne		;Already stored within macro if NE
	 save	[r1]
	 movd	m_srcptr,r1	;Point to original line in string storage
	 bsr	length
	 addd	r0,r1		;Skip over any label
	 bsr	skp_coln	;Skip colons
	 bsr	next
	 bsr	length		;Length of pseudo-op
	 addd	r0,r1
	 cmpb	16*op_mac+mac_mac,m_opcod ;See if this is a macro or repeat
	 if	eq
	  tbitb	b_nscgnx,m_ascond ;Name follows if FS
	  if	fs
	   bsr	nxt_txt		;It must follow
	   bsr	length
	   addd	r0,r1		;Skip macro name
	  endif
	 endif
	 movd	r1,mac_stk+1
	 cmpb	16*op_mac+mac_mac,m_opcod ;See if this is a macro or repeat
	 if	eq
	  movd	r1,2(r2)	;Text pointer in symbol table if macro
	 endif
	 restore [r1]
	 movqd	-1,r0
	 movb	cr,r4
	 skpsb	u		;Advance to end of line
	 ret
	endif

	movd	m_strptr,mac_stk+1 ;Pointer to remaining text
	movd	m_delim,r2
	movqd	0,r0		;Initialize length
	save	[r1]
	begin
	 cmpw	";;",(r1)	;Don't store ";;" comments
	quit	eq
	 movzbd	(r1),r4
	 cmpb	trm_cr,r2[r4:b]
	while	lo
	 addqd	1,r0		;Increment length
	 addqd	1,r1		;Advance pointer
	endw
	restore	[r1]
	bsr	trl_blnk	;Remove trailing blanks

	addr	r1[r0:b],r2	;Address of last character+1 in string
	movb	(r2),r6		;Save last character
	movb	cr,(r2)		;Must have CR as last character
	addqd	1,r0		;Always include delimiter
	cmpb	16*op_mac+mac_mac,m_opcod ;See if this is a macro or repeat
	if	eq
	 movd	m_symadr,tos	;Pointer to label in symbol table
	 movd	r0,tos		;Length to store
	 movd	r1,tos		;Starting address to store
	 bsr	str_lbl		;Store string
	else
	 movd	r0,tos		;Length to store
	 movd	r1,tos		;Starting address to store
	 bsr	put_str		;Store string
	endif
	movb	r6,(r2)		;Restore original character
	addqd	-1,r0		;Don't include last CR now

	addd	r0,r1		;Skip over parameters
	ret


;Define local variable in macro

do_lcl:
;	CMPQB	2,M_PASS
;	IF	EQ
;	 MOVB	CR,R4
;	 MOVQD	-1,R0
;	 SKPSB	U		;Skip over local labels
;	 RET
;	ENDIF

	proc
	reg	[]
buf:	blkb	8+2		;Temporary symbol name
	code
	begin
	 bsr	comma
	while	fc
	 bsr	length		;Get length in R0
	 addr	t_symlcl,r3
	 bsr	sym2sub		;Search local table
	 if	eq
	  movd	m_symadr,r2
	  addd	t_symbl,r2	;Address of start of symbol in R2
	  cmpqb	2,m_pass
	  if	ne
	   tbitb b_def,(r2)
	   if	fs
	    bsr	dup_sym		;Error if defined symbol found
	   endif
	  endif
	  subd	t_symbl,r2	;Offset to start of symbol in R2
	  cmpd	r2,m_sym1st	;See if new lowest value
	  if	lo
	   movd	r2,m_sym1st	;Lowest symbol here
	  endif
	 else
	  cmpqb	2,m_pass
	  if	eq
	   bsr	err_phs		;Phase error if not found on pass 2
	  endif	
	  save	[r3]
	  bsr	sym2val		;Can't be in any other symbol table either
	  restore [r3]
	  if	eq
	   bsr	dup_sym
	  else
	   movb	r0,tos		;Length of symbol
	   movw	(h'8c lsh b_mode),tos ;Variable type
	   movd	r1,tos		;Pointer to symbol name
	   movd	r3,tos		;Previous symbol pointer
	   bsr	make_sym	;Create undefined local symbol
	  endif
	 endif
	 addd	r0,r1		;Skip over symbol name
	 addr	buf,r2		;Pointer to temporary name buffer
	 movb	"\",(r2)	;Local symbols start with this
	 save	[r1]
	 addr	1(r2),r1	;Address for rest of symbol translation
	 movd	mac_lbl,r5
	 movqd	0,r0
	 movb	m_radix,tos
	 bsr	byt_2r5		;Put in rest of symbol name translation
	 inssb	16,m_radix,0,5	;Force to hex for symbol name
	 movb	tos,m_radix	;Restore original
	 restore [r1]
	 addqd 1,mac_lbl	;Next label
	 movd	m_symadr,tos	;Pointer to symbol name
	 movzbd 5,tos		;Length of symbol
	 addr	buf,tos		;Pointer to symbol
	 bsr	str_lbl
	endw
	pend
	ret

do_mend:
do_lend:
	ret

;MACRO exit routine, get condition
;If condition false, then zap M_OPCOD

do_mxit:
	bsr	next
	bfs	ops_ret		;Always exit if no value
	bsr	def_r5		;Must be defined value
	tbitb	0,r5
	bfs	ops_ret		;Always exit if condition true
	movw	h'ff,m_opcod	;Null value
	ret

;Format 13 is control structures

pfmt_d:	movzbd	2+8,r5
	bsr	aray_r5
	bfs	ops_ret
	movw	b_def+h'2400,(r5) ;Make defined integer

	movd	cond_ptr,r2
	addr	cond_stk,r4
	cmpb	cc_end,r3
	bhi	do_if
	beq	do_end

	subb	cc_end+1,r3	;Start with 0 offset
afmtd1:	casew	afmtd2[r3:w]
afmtd2:
	word	do_xpr-afmtd1
	word	do_lpr-afmtd1
	word	do_proc-afmtd1
	word	psop_reg-afmtd1
	word	do_cod-afmtd1
	word	do_pend-afmtd1
	dw	psop_prt-afmtd1

;In-line procedure, just set up stack
do_proc:
	movqb	4,r2
	br	doxpr1:b	;No return address, just push FP

;Local procedure, entered with BSR

do_lpr:	movb	8,r2		;8 stack bytes used by program parameters
	br	doxpr1:b

;External procedure, entered with CXP

do_xpr:
	movb	12,r2		;12 stack bytes used by program parameters
doxpr1:	cmpqb	0,m_proc
	bne	proc_err	;Unterminated procedure before this if NE
	movb	r2,m_proc
	cbitb	b_fp,m_ascond	;Default to local storage
	bsr	next		;See if general/local storage flag
	if	fc
	 bsr	def_r5		;Get defined value in R5
	 inssb	r5,m_ascond,b_fp,1
	endif
	movqd	0,m_fpptr	;Start storage address at 0
	movb	b'11000,m_amode	;Select FP mode
	addr	m_fpptr,m_amodp
	movqd	-1,m_prcstk	;Force to undefined
	movd	sidx_end,t_symfp ;Clear local stack
	movd	tsym_end,m_fpofst ;Base address of FP symbols
	subd	t_symbl,m_fpofst ;Relative offset
	movd	m_pcptr,m_disfp	;Base address for this FP block

	cmpqb	2,m_pass
	if	eq
	 movzbd	lcod_fp,tos	;Search link table for FP block
	 bsr	link_pc
	 movd	tos,r2		;Pointer to FP block entry
	 if	eq
	  movd	7(r2),t_symfp	;Local symbol pointer restored
	  movd	11(r2),m_fpofst
	 endif
	endif	

	ret

;Search link table for block matching designator on TOS:D
;EQ set on return if match, NE and phase error if not
;First byte of symbol name must match descriptor passed on stack
;Value field of symbol entry must holds PC pointer
;On exit, TOS holds pointer to block


link_pc:
	lproc
sym:	ds	4
	reg	[r2,r3,r4,r5]
	code

	addr	t_symlnk,r2
	movd	msym_beg,r3
	addd	t_symbl,r3	;Lowest possible address
	movd	msym_end,r4	;Address of next module
	until	eq		;Locate FP base for labels
	 extsd	(r2),r5,0,sidx_bit
	 cmpd	sidx_end,r5
	quit	eq
	 movd	r5,r2
	 addd	t_symbl,r2	;Next address to check
	 cmpd	r2,r4		;Must be less than this
	quit	hs
	 cmpd	r2,r3		;Must be at least this
	 if	hs
	  cmpd	sidx_of+2(r2),m_pcptr ;Other blocks indexed by PC pointer
	  if	eq
	   cmpb sym,sidx_of+2+4(r2)
	  endif
	 endif
	qend
	 bsr	err_phs		;Phase error if not found
	 bicpsrb flag_z		;Make NE
	endu

	addr	sidx_of(r2),sym	;Return pointer here
	pend	0		;Return parameter on stack

;PRET pseudo-op, set number of bytes of stack parameters to return

psop_prt:
	cmpqd	-1,m_prcstk	;REG pseudo-op cannot have been used
	bne	proc_err
	negd	m_fpptr,m_prcstk ;Number of bytes to return
	ret

;REG pseudo-op, actual ENTER opcode

psop_reg:
	cmpqb	0,m_proc	;PROC block must have been opened
	beq	proc_err

	movd	r5,r6		;Need storage for BIT_LST routine
	movb	h'82,(r7)	;Enter opcode
	addqd	1,r7
	bsr	nxt_txt		;List required
	if	fc
	 addr	t_rgbit,r2
	 bsr	bit_lst		;Get value in 2(R6)
	 movb	2(r6),0(r7)
	 movb	2(r6),m_prcreg	;Registers for EXIT to pop
	 addqd 1,r7		;Ready for offset
	endif

	negd	m_fpptr,r2	;Number of bytes of stack parameters
	movzbd	m_proc,r4	;FP overhead
	addd	r2,r4		;Total stack storage used so far
	movqd	0,m_fpptr	;Storage from here on accurate
	cmpqd	-1,m_prcstk	;See if PRET set something here
	if	ne		;No PRET if EQ
	 subd	m_prcstk,r2	;Number of bytes to keep in M_PRCSTK
	endif
	movd	r2,m_prcstk	;Number of bytes to remove before return

	cmpqb	2,m_pass
	beq	ops_ret

	movd	m_fpofst,r2	;Pointer to 1st symbol
	addd	t_symbl,r2	;Make absolute address
	begin
	 cmpd	r2,tsym_end	;Adjust FP relative symbols now
	while	lo
	 extsb	sidx_of+1(r2),r3,b_mode-8,4
	 cmpb	b'1000,r3	;Check for FP relative
	quit	ne
	 addd	r4,sidx_of+2(r2)
	 extsd	sidx_of(r2),r3,0,5 ;Length of symbol name
	 addd	r3,r2
	 addd	sidx_of+2+4,r2
	endw

	ret

;Local procedure beginning of code

do_cod:
	cmpqb	0,m_proc
	beq	proc_err	;Beginning of block must have been declared
	cmpqd	-1,m_prcstk	;REG pseudo-op must have been used
	beq	proc_err

	negd	m_fpptr,2(r5)	;FP local storage
	movw	exp b_def+(h'28 lsh b_mode),(r5)
	bsr	dsp_pi

	movb	b'11011,m_amode	;Select PC mode
	addr	m_pcptr,m_amodp

	cmpqb	2,m_pass	;Do link data entry in symbol table
	beq	ops_ret		;Never on pass 2

	movqd	0,tos		;Create room for returned entry
	bsr	last_lnk	;Get next link table address
	movd	tos,r3

	movb	9,tos		;9 byte name
	movw	exp b_def+(h'2e lsh b_mode),tos
	addr	(r5),tos	;Pointer to name
	movd	r3,tos		;Previous symbol pointer

	movb	lcod_fp,(r5)	;FP code
	movd	t_symfp,1(r5)	;This for 2nd assembler pass
	movd	m_fpofst,5(r5)	;Base offset for debugger
	bsr	make_sym
	movd	m_symadr,r3
	addd	t_symbl,r3
	movd	m_disfp,2(r3)	;Address of beginning of block

	ret


;Procedure end, restore stack and exit

do_pend:
	cmpqb	0,m_proc
	beq	proc_err	;Beginning of block must have been declared
	cmpqd	-1,m_prcstk	;REG pseudo-op must have been used
	beq	proc_err
	cmpb	b'11011,m_amode	;PC mode must have been selected by CODE
	bne	proc_err

	movb	h'92,(r7)	;Exit opcode
	addqd	1,r7
	save	[r5]
	movb	m_prcreg,r5
	bsr	rvs_bit
	movb	r5,(r7)		;Register bit map
	restore	[r5]
	addqd	1,r7

	bsr	next		;If parameter follows, that is byte count
	if	fs
	 movd	m_prcstk,2(r5)	;Default number of bytes to remove
	else
	 bsr	ex_int		;Use this if specified
	endif			;@ DO_PEND
	movw	exp b_def+(h'28 lsh b_mode),(r5)

	cmpqb	4,m_proc	;Check for in-line procedure
	if	eq
	 cmpqd	0,2(r5)
	 if	ne		;Adjust SP if something there from before
	  save	[r4,r6]
	  negd	2(r5),2(r5)	;Subtract value to shorten stack
	  bsr	byt_siz		;Get required size in R4
	  movd	r4,r6		;Need size here for later routines
	  addqd	-1,r4		;Make 0-3
	  movw	b'1010010101111100,(r7) ;ADJSP with immediate value
	  orw	r4,(r7)		;Set size field
	  addqd	2,r7
	  bsr	byt_ok		;Store immediate value in R5
	  restore [r4,r6]
	 end
	else
	 cmpb	8,m_proc	;RET if 8, EXIT if 12
	 if	eq
	  movb	h'12,(r7)	;RET opcode
	 else
	  movb	h'32,(r7)	;RXP opcode
	 end
	 addqd	1,r7
	 bsr	dsp_pi		;Install displacement
	endif			;2nd @ DO_PEND
	movqb	0,m_proc	;Make PROC block inactive
	movqd	-1,m_prcstk	;Make stack size invalid
	ret

;Error in procedure block

proc_err:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Error in procedure block",cr,lf,0
	movqb	0,m_proc	;Make PROC block inactive
	movqd	-1,m_prcstk	;Make stack size invalid
	cmpb	b'11000,m_amode	;Check for FP mode selection
	if	eq
	 movb	b'11011,m_amode	;Select PC mode
	 addr	m_pcptr,m_amodp
	endif			;@ PROC_ERR
	ret	

do_end:

;Conditional processing for END

	movd	m_pcptr,r6
	addd	m_pcofst,r6	;Need absolute address
	movd	r6,m_endadr	;Store END address
	movd	r6,m_nd1adr	;Opcode after END
	movd	r6,m_qndadr	;Default QEND
	movd	r6,m_elsadr	;Default ELSE
	movw	exp b_def+(h'2b lsh b_mode),(r5) ;Defined PC relative

;Process stack entries until entire conditional structure done

	until	eq
	 bsr	cstk_und	;Check for stack underflow
	 bfs	ops_ret		;R2 decremented by 4
	 movd	r3,r0		;Save previous condition here
	 extsd	3(r4)[r2:b],r3,0,4 ;Op index of op that PUSHed value
	 extsb	3(r4)[r2:b],m_cond,4,4 ;Condition code
	 extsd	(r4)[r2:b],r6,0,24 ;Get PC offset
	 lshd	8,r6
	 ashd	-8,r6		;Sign extend to 32 bits
	 addd	m_pcofst,r6	;Convert to absolute address

	 cmpb	cc_end,r0	;See if this is end code
	 if	eq
	  cmpb	cc_qnd,r3	;If end and no QEND then jump may be needed
	  if	ne
	   cmpb	cc_whl,m_cndcod+3 ;WHILE requires unconditional jump at end
	   if	eq
	    save [r0]
	    movzbd m_dspsz,r0	;Displacement size
	    cmpqb 2,m_pass
	    if	ne
	     movb h'ea,(r7)	;Make unconditional for WHILE
	     movb r0,1(r7)
	     inssb h'b,1(r7),4,4 ;Make PC relative
	    endif
	    addqd 1,r7
	    addd r0,r7
	    movd r7,m_nd1adr
	    movd r7,m_qndadr
	    restore [r0]
	   else
	    cmpb cc_untl,m_cndcod+3
	   orif	eq		;UNTIL requires conditional jump at end
	   endif
	  endif
	 endif

	 save	[r0,r1,r3,r5]
	 bsr	end_sub
	 restore [r0,r1,r3,r5]
	 cmpb	r3,m_cndcod+3	;Check for beginning conditional
	endu

;Stack cleared of this entry, if not empty fetch previous M_CNDCOD

	cmpqd	4,r2		;See if at least one more entry on stack
	if	ls
	 addqd	-4,r2
	 movd	r2,cond_ptr
	 movd	(r4)[r2:b],m_cndcod
	 cmpqd	0,r2
	 if	eq
	  movd	m_lincnt,m_cndclr ;Last line where stack was clear
	 endif
	endif
	ret

;Process conditional stack entry in R3

end_sub:
	casew	$+4:b[r3:w]

	word	beg_sub-end_sub
	word	if_sub-end_sub
	word	untl_sub-end_sub
	word	whl_sub-end_sub
	word	else_sub-end_sub
	word	orif_sub-end_sub
	word	quit_sub-end_sub
	word	qend_sub-end_sub

;QEND, unconditional branch to END+1, M_QNDADR = next opcode after QEND

qend_sub:
	cmpb	cc_end,r0	;This must be the last conditional
	bne	cond_er

	cmpqb	2,m_pass
	beq	ops_ret		;Nothing to do on pass 2

;If UNTIL or WHILE then QEND is new END

	cmpb	cc_whl,m_cndcod+3
	if	eq
	 movd	r6,m_endadr
	 extsd 1(r6),r0,0,4	;Displacement size of 1st jump
	 addqd	1,r6
	 addd	r0,r6		;Advance to next address
	else
	 cmpb	cc_untl,m_cndcod+3
	orif	eq
	endif			;@ QEND_SUB

	save	[r7]
	movd	r6,r7
	cmpb	cc_whl,m_cndcod+3
	if	ne		;If not while then jump to END+1
	 movb	h'ea,(r7)	;Unconditional jump
	 addqd	1,r7
	 movd	m_nd1adr,2(r5)
	 subd	r6,2(r5)	;Offset from QEND to END
	 bsr	dsp_p2		;Install displacement (pass 2 mode)
	endif
	movd	r7,m_qndadr	;First opcode for QEND routine
	restore	[r7]
	ret

;QUIT, conditional branch to QEND

quit_sub:
	cmpqb	2,m_pass
	beq	ops_ret

	save	[r7]
	addr	1(r6),r7
	movd	m_qndadr,2(r5)
	subd	r6,2(r5)	;Offset from QUIT to QEND
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	restore	[r7]
	ret

;ORIF, conditional branch to opcode after IF

orif_sub:
	cmpb	cc_if,m_cndcod+3 ;Must be IF conditional
	bne	cond_er

	cmpqb	2,m_pass
	beq	ops_ret

	save	[r7]
	extsd	m_cndcod,r0,0,24 ;Address if IF
	lshd	8,r0
	ashd	-8,r0		;Sign extend to 32 bits
	addd	m_pcofst,r0	;Get absolute address
	addqd	1,r0		;Bypass opcode
	extsd	(r0),r7,0,4	;Size of jump opcode
	addd	r7,r0		;R0 points to target for jump
	movd	r0,2(r5)

	addr	1(r6),r7
	subd	r6,2(r5)	;Offset from ORIF to IF + 1
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	restore	[r7]
	ret

;ELSE, unconditional branch to END, set M_ELSADR

else_sub
	cmpb	cc_if,m_cndcod+3 ;Must be IF conditional
	bne	cond_er
	cmpd	m_endadr,m_elsadr ;Must be default END
	bne	cond_er

	cmpqb	2,m_pass
	if	eq
	 movd	r6,m_elsadr	;Must not be end anymore
	 ret
	endif

	movb	h'ea,(r6)	;Unconditional jump

	save	[r7]
	addr	1(r6),r7
	movd	m_endadr,2(r5)
	subd	r6,2(r5)	;Offset from ELSE to END
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	movd	r7,m_elsadr	;First opcode for ELSE routine
	restore	[r7]
	ret

;WHILE, END branches to BEGIN, conditional branch to END+1

whl_sub:
	cmpb	cc_whl,m_cndcod+3 ;Must be WHILE conditional
	bne	cond_er
	movb	cc_beg,m_cndcod+3 ;Now set condition to CC_BEG

	cmpqb	2,m_pass
	beq	ops_ret

	save	[r7]

	addr	1(r6),r7	;Conditional branch offset
	movd	m_nd1adr,2(r5)	;Target routine
	subd	r6,2(r5)	;Offset from WHILE to END+1
	bsr	dsp_p2		;Install displacement (pass 2 mode)

	extsd	m_cndcod,2(r5),0,24 ;Target for END jump
	lshd	8,2(r5)
	ashd	-8,2(r5)	;Sign extend to 32 bits
	addd	m_pcofst,2(r5)	;Convert to absolute address
	movd	m_endadr,r7	;Source for END jump
	subd	r7,2(r5)	;Offset
	addr	1(r7),r7	;Address for offset
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	restore	[r7]

	ret

;UNTIL, conditional branch from END to UNTIL

untl_sub:
	cmpb	cc_untl,m_cndcod+3 ;Must be UNTIL conditional
	bne	cond_er

	cmpqb	2,m_pass
	beq	ops_ret

	save	[r7]
	movd	m_endadr,r7	;PC_PTR for source of jump
	movd	r6,2(r5)	;Target PC_PTR
	subd	r7,2(r5)	;Offset to R5
	inssb	m_cond,(r7),4,4	;Insert condition
	ibitb	4,(r7)		;Jump if condition false

	addqd	1,r7
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	restore	[r7]
	ret

;IF, conditional branch from IF to ELSE

if_sub:
	cmpb	cc_if,m_cndcod+3 ;Must be WHILE conditional
	bne	cond_er

	cmpqb	2,m_pass
	beq	ops_ret

	save	[r7]
	addr	1(r6),r7	;Conditional branch offset
	movd	m_elsadr,2(r5)	;Target routine
	subd	r6,2(r5)	;Offset from IF to ELSE
	bsr	dsp_p2		;Install displacement (pass 2 mode)
	restore	[r7]

	ret

beg_sub:
	cmpb	cc_beg,m_cndcod+3
	beq	ops_ret
	br	cond_er

;Conditional for anything but END
;Save status on stack, advance R7 unless this is BEGIN or UNTIL
;R2 holds stack counter, R4 holds base address of stack
;R3 holds condition code

do_if:	cmpqd	0,r2
	if	eq
	 movd	m_lincnt,m_cndclr ;Last line where stack was clear
	endif

;Signed M_PCPTR must fit in 24 bits

	absd	m_pcptr,r6
	cmpd	h'7ff000,r6	;Leave enough room for anything to follow
	if	lo
	 addqd	1,m_errct
	 bsr	dsp_msg
	 db	"Relative PC out of range",cr,lf,0
	 ret
	endif

;If BEGIN, IF, UNTIL, WHILE set condition type

	cmpb	cc_whl,r3	;WHILE requires BEGIN first
	if	eq
	 cmpb	cc_beg,m_cndcod+3
	 bne	cond_er
	 movb	r3,m_cndcod+3
	else
	 cmpb	cc_beg,r3
	 if	eq
	  cmpqd	0,r2		;Check pointer for empty stack
	  if	ne		;If stack not empty, store old code	
	   bsr	cstk_ov
	   bfs	ops_ret
	   movd	m_cndcod,(r4)[r2:b]
	   addqd 4,r2
	   movd	r2,cond_ptr
	  endif
	  movd	m_pcptr,m_cndcod ;Store starting address PC offset
	  movb	r3,m_cndcod+3	;Store condition type
	 else
	  cmpb	cc_if,r3
	 orif	eq
	  cmpb	cc_untl,r3
	 orif	eq
	 endif
	endif

	cmpb	cc_els,r3
	if	eq
	 cmpb	cc_if,m_cndcod+3
	 bne	cond_er
	else
	 cmpb	cc_orif,r3
	orif	eq
	endif

	cmpb	cc_beg,r3
	if	ne		;No condition test if BEGIN
	 movb	h'e,m_cond	;Unconditional branch for ELSE and QEND
	 cmpb	cc_els,r3
	 if	ne
	  cmpb	cc_qnd,r3
	  if	ne
	   cmpb	cc_qu,r3	;If quit then default is unconditional
	   bicpsrb flag_f	;Clear F if not Quit
	   if	eq
	    bsr	next		;F clear if more text
	   end
	   if	fc
	    bsr	nxt_txt
	    bsr	length
	    bsr	cond_chk	;Condition code in M_COND
	    addd r0,r1		;Advance past condition string
	    bne	prm_err
	   endif
	  endif
	 endif
	endif

	bsr	cstk_ov
	bfs	ops_ret

	movd	m_pcptr,(r4)[r2:b] ;Relative PC offset
	movb	r3,3(r4)[r2:b]	;Pseudo op is bits 0-3
	inssb	m_cond,3(r4)[r2:b],4,4 ;Condition code is upper 4 bits
	addqd	4,r2
	movd	r2,cond_ptr

;If BEGIN or UNTIL, then done

	cmpqb	cc_beg,r3
	beq	ops_ret
	cmpb	cc_untl,r3
	beq	ops_ret

	movzbd	m_dspsz,r5	;Leave room for displacement

	cmpqb	2,m_pass
	if	ne
	 movb	h'a,(r7)
	 inssb	m_cond,(r7),4,4	;Store conditional branch opcode
	 cmpb	cc_if,r3	;If IF or WHILE then negate condition status
	 if	eq
	  ibitb	4,(r7)
	 else
	  cmpb	cc_whl,r3
	 orif	eq
	 endif
	 movb	r5,1(r7)
	 inssb	h'b,1(r7),4,4	;Make PC relative
	endif
	addqd	1,r7
	addd	r5,r7

;If QEND and UNTIL condition, then a 2nd unconditional jump is needed

	cmpb	cc_qnd,r3
	bne	ops_ret
	cmpb	cc_untl,m_cndcod+3
	bne	ops_ret
	cmpqb	2,m_pass
	if	ne
	 movb	h'ea,(r7)
	 movb	r5,1(r7)
	 inssb	h'b,1(r7),4,4	;Make PC relative
	endif
	addqd	1,r7
	addd	r5,r7

	ret	0

;Check stack, FS on exit if overflow

cstk_ov:
	bicpsrb	flag_f
	cmpd	cond_siz-4,r2	;Need this many bytes left
	bhs	ops_ret

;Stack overflow
	
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Condition stack overflow",cr,lf,0
	bsr	last_cnd	;Display last line where stack was clear
	movd	m_lincnt,m_cndclr ;Last line where stack was clear
	movqd	0,r2
	movd	r2,cond_ptr
	bispsrb	flag_f
	ret	0

;Condition mismatch

cond_er:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Condition mismatch",cr,lf,0
	bsr	last_cnd	;Display last line where stack was clear
	movd	m_lincnt,m_cndclr ;Last line where stack was clear
	movqd	0,r2
	movd	r2,cond_ptr
	ret


cstk_und:
	addqd	-4,r2
	movd	r2,cond_ptr
	cmpqd	0,r2
	bicpsrb	flag_f
	ble	ops_ret

;Stack underflow
	
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Condition stack empty",cr,lf,0
	bsr	last_cnd	;Display last line where stack was clear
	movqd	0,r2
	movd	r2,cond_ptr
	movd	m_lincnt,m_cndclr ;Last line where stack was clear
	bispsrb	flag_f
	ret	0

;Format 15 is pseudo ops
;Op 0 = BYTE
;Op 1 = WORD
;Op 2 = BLKB
;Op 3 = MODE (PC,SB,FP,SP)
;Op 4 = EQU
;Op 5 = SET
;Op 6 = DISP
;Op 7 = RADIX
;Op 8 = PUSH
;Op 9 = DBL
;Op A = RPN
;Op B = DROP
;Op C = DF
;Op D = DL
;Op E = BLKW
;Op F = BLKD

pfmt_f:	casew	z5[r3:w]

z5:	word	db-pfmt_f
	word	dw-pfmt_f
	word	ds-pfmt_f
	word	set_mode-pfmt_f
	word	do_equ-pfmt_f
	word	do_set-pfmt_f
	word	do_dspl-pfmt_f
	word	do_rdx-pfmt_f
	word	do_push-pfmt_f
	word	dd-pfmt_f
	word	rpn-pfmt_f
	word	do_drop-pfmt_f
	word	df-pfmt_f
	word	dl-pfmt_f
	dw	dsw-pfmt_f
	dw	dsd-pfmt_f

;Display last address where condition stack was empty

last_cnd:
	bsr	dsp_msg
	byte	"Condition stack was last cleared in line ",0
	save	[r5]
	movd	m_cndclr,r5
	bsr	dsp_r5
	restore	[r5]
	br	do_cr

;Return a count in R0, default is 1
;Check for [count], R0=0 if error

cnt_r0:
	movqd	1,r0		;Default repeat count
	bsr	next
	cmpb	"[",(r1)
	if	eq
	 addqd	1,r1
	 save	[r5]		;Save buffer address
	 bsr	def_r5
	 movd	r5,r0
	 restore [r5]
	 if	fs		;Error if FS
	  movqd 0,r0		;No count
	 endif
	 bsr	next
	 cmpb	"]",(r1)
	 if	eq
	  addqd 1,r1
	 else
	  bsr	prm_err
	 endif
	endif
	ret


;BYTE pseudo-op

db:	movqd	1,r4		;Storage length
db1:	movd	r6,r5		;R6 has buffer assigned
	movd	r4,r6		;Storage length
	begin
	 bsr	comma
	while	fc		;Must be more text
	 movd	r1,tos
	 bsr	cnt_r0		;Get optional count 
	 bsr	next		;Advance to text to install
	 bsr	ex
	 
	 begin
	  cmpqd	0,r0
	 while	ne
	  save	[r0,r3]
	  cmpd	r3,r1		;Check for 0 length label
	  if	ne
	   extsb 1(r5),r3,b_size-8,4
	   cmpqb 7,r3		;Integer or float
	   if	hs
	    bsr	dval
	   else
	    cmpb h'8c,1(r5)	;Check for string
	    if	ne
	     bsr prm_ovfl	;Improper parameter if NE
	    else
	     tbitb b_def,(r5)	;Must be defined always
	     if	fc
	      bsr sym_und
	     else
	      save [r1]
	      movd r7,r2	;Target address
	      movd 4(r5),r1	;Source address
	      movzwd 2(r5),r0	;Length
	      cmpqb 2,m_pass
	      if eq
	       cmpb r0,(r7)
	       if ne
	        bsr prm_ovfl	;Size doesn't match this time
	        movzbd (r7),r0	;Always use stored size
	       endif
	       movsb
	       movd r2,r7
	      else
	       movb r0,(r7)
	       tbitb b_2pass,m_dolst ;Check 2 pass status
	      orif fc		;Just install if one pass
	       addd r0,r7	;1st of 2 passes, just store size
	      endif
	      restore [r1]
	     endif
	    endif
	   endif
	  endif
	  restore [r0,r3]
	  addqd -1,r0
	 endw
	 cmpd	tos,r1
	quit	eq		;Quit if invalid text
	endw
	ret

;Word pseudo-op

dw:	movqd	2,r4
	br	db1


;Double word pseudo-op

dd:	movqd	4,r4		;Size
	br	db1

;32 bit float

df:	movqd	4,r4
	br	dl1

;Long float

dl:	movzbd	8,r4
dl1:	movd	r6,r5		;Assigned buffer to R5
	movzbd	r4,r6		;Byte count to R6
	begin
	 bsr	comma
	while	fc
	 movd	r1,tos
	 bsr	cnt_r0
	 bsr	next
	 bsr	ex
	 begin
	  cmpqd	0,r0
	 while	ne
	  extsb	1(r5),r3,b_size-8+2,2
	  cmpqb	1,r3		;Must be float
	  if	ne
	   bsr	prm_err
	  else
	   bsr	dval
	  endif
	  addqd	-1,r0
	 endw
	 cmpd	tos,r1
	quit	eq		;0 length if EQ
	endw
	ret


;Put DB, DW, DD or float in (R7), build link table as needed
;(R5) holds value, R6 holds size

dval:	save	[r6]
	inssb	7,1(r5),b_mode-8,4 ;LSB/MSB mode descriptor
	bsr	byt_put
	tbitb	b_def,(r5)
	if	fc		;Done if defined
	 cmpqb	1,m_pass
	 if	eq
	  tbitb b_2pass,m_dolst ;Check list status
	 else
	  bispsrb flag_f	;Assume not linking
	  cmpqb 2,m_pass
	  if	eq
	   extsb (r5),tos,b_typ,2
	   cmpqb lbl_ext,tos
	   if	eq
	    bicpsrb flag_f
	   endif
	  endif
	 endif
	 if	fc		;Don't link if 2 pass assembly
	  extsb 1(r5),tos,b_size-8+2,2
	  cmpqb 1,tos		;Check for float
	  if	eq
	   lshd -2,r6
	   addqd -1,r6		;Code size is 0 or 1
	   orb	exp blnk_cmd+exp blnk_val+(clnkflt lsh blnkvcmd),r6
	  else
	   addqd -1,r6		;Code size is 0-3
	   orb	exp blnk_cmd+exp blnk_val+(clnkint lsh blnkvcmd),r6
	  endif
	  movb	r6,(m_lnkptr)
	  addqd 1,m_lnkptr
	 endif
	endif
	restore	[r6]
	ret

;2(R5) holds value, R6 holds size in bytes (3=variable)
;If undefined then 2(R5) points to link data
;Put into (R7) according to M_PASS and size, do error check

byt_put:
	cmpqb	3,r6
	if	eq
	 movzbd	m_dspsz,r6	;Default size
	endif
	cmpqb	1,m_pass
	beq	byt_p1
	cmpqb	2,m_pass
	if	eq
	 tbitb	b_def,(r5)
	 if	fc
	  extsb (r5),tos,b_typ,2
	  cmpqb lbl_ext,tos	;Link externals on 2nd pass
	  beq	byt_p1		;Also use BYT_P1 here
	 endif
	 br	byt_p2
	endif
	cmpb	"L",m_pass	;Link only pass
	beq	byt_p2
	cmpb	"I",m_pass
	bne	ops_ret
	br	byt_pi


;Pass 1 put routine, store size in lower 4 bits and inc R7
;Store mode in upper 4 bits

byt_p1:	tbitb	b_def,(r5)
	if	fs
	 tbitb	b_2pass,m_dolst	;Check list status
	 bfc	byt_pi		;If defined and 1 pass, just install
	else
	 cmpqb	1,m_pass
	 if	eq
	  tbitb b_2pass,m_dolst ;Check list status
	 else
	  bispsrb flag_f	;Assume not linking
	  cmpqb 2,m_pass
	  if	eq
	   extsb (r5),tos,b_typ,2
	   cmpqb lbl_ext,tos
	   if	eq
	    bicpsrb flag_f
	   endif
	  endif
	 endif
	 if	fc		;No linking if FS
	  bsr	lnkfldchk	;Prepare link data for new field
	  movd	2(r5),tos	;Push address of link field data
	  bsr	link_fld
	  save	[r7]
	  movd	2(r5),tos	;Save original value
	  movw	(r5),tos
	  movw	exp b_def+(h'2b lsh b_mode),(r5) ;Defined offset
	  movd	r7,2(r5)
	  subd	m_pcofst,2(r5)	;Just store displacement
	  movd	m_lnkptr,r7
	  movb	exp blnk_cmd+(clnk_ad7 lsh blnkgcmd),(r7)
	  addqd	1,r7
	  bsr	dsp_pi		;Store offset
	  movd	r7,m_lnkptr
	  movw	tos,(r5)
	  movd	tos,2(r5)
	  restore [r7]
	 endif
	endif
	movb	r6,(r7)
	inssb	b_mode/8(r5),(r7),4,4
	addd	r6,r7
	ret	0


dsl:	movzbd	8,r6		;Longs
	br	ds1:b

dsw:	movqd	2,r6		;2 byte units
	br	ds1:b

dsd:	movqd	4,r6		;4 byte units
	br	ds1:b

ds:	movqd	1,r6		;Storage unit
ds1:
	movd	m_symadr,r4	;Address of current symbol
	bsr	next
	if	fc
	 bsr	def_r5		;Number of R6 units for storage
	 muld	r6,r5
	else
	 movd	r6,r5		;Default size if none specified
	endif

	movd	m_amodp,r2
	cmpb	b'11010,m_amode	;Check for SB
	if	eq
	 addd	r5,(r2)
	else
	 cmpb	b'11011,m_amode	;Check for PC
	orif	eq
	 cmpb	b'10100,m_amode	;Check for Immediate, increment
	orif	eq
	 subd	r5,(r2)
	 cmpd	sidx_end,r4
	 if	hi		;Must have valid symbol name here
	  addd	t_symbl,r4
	  extsb	1(r4),r3,b_mode-8,4
	  extsb	m_amode,r5,0,4
	  cmpb	r3,r5
	  if	eq
	   cmpqb 2,m_pass
	   if	ne
	    movd (r2),2(r4)	;This is actual symbol value
	   endif
	   movd	2(r4),m_lstmod	;This is current value for listing
	  else
	   bsr	mode_err
	  endif
	 endif
	endif
	ret

rpn:	bsr	def_r5
	inssb	r5,m_radix,b_rpn,1
	ret	0

do_dspl:
	bsr	def_r5

;Must be 1,2,4

	cmpqb	4,r5
	blo	prm_ovfl
	cmpqb	3,r5
	beq	prm_ovfl
	cmpqb	0,r5
	beq	prm_ovfl

	movb	r5,m_dspsz
	ret	0

;Radix always evaluated in base 10

do_rdx:	movb	m_radix,tos
	inssb	10,m_radix,0,5
	bsr	def_r5
	movb	tos,m_radix

;Must be 2-16, negative value means signed display

	absd	r5,r4		;Radix value to R4
	addqd	-2,r4
	cmpd	16-2,r4
	blo	prm_ovfl
	addqd	2,r4
	inssb	r4,m_radix,0,5
	rotd	1,r5		;Sign bit to bit 0
	inssb	r5,m_radix,b_sign,1
	ret

set_mode:
	bsr	nxt_txt
	bfs	ops_ret
	bsr	exp_len		;Get length of expression in R0
	bsr	pad_blsb	;Get search value in R4
	save	[r1]
	addr	t_fssp,r1
	movqd	6,r0
	skpsd	u,b
	restore	[r1]
	bfc	prm_err
	addqd	-1,r0		;Convert to 0-5
	addr	m_fpptr[r0:d],m_amodp
	cmpqb	3,r0
	if	hs
	 movb	r0,m_amode
	 orb	b'11000,m_amode
	 cmpqb	0,r0
	 if	eq
	  sbitb	b_fp,m_ascond	;General FP storage
	 endif
	else
	 movb	h'14,m_amode
	 cmpqb	5,r0
	 if	eq
	  sbitb	7,m_amode	;Decrement counter
	 endif
	endif

	bsr	comma		;Check for optional new value
	bfs	ops_ret
	bsr	def_r5
	bfs	ops_ret		;Must be defined
	movd	r5,m_fpptr[r0:d] ;Set new value
	ret	0


	byte	$"FP  "
	byte	$"SP  "
	byte	$"SB  "
	byte	$"PC  "
	db	$"IMM "		;Immediate mode
t_fssp:	db	$"IMM-"		;Immediate but decrement counter


do_equ:
do_set:
	bsr	get_smad	;Name may follow if NSCGNX
	movd	r2,r4
	cmpd	sidx_end,r4
	bls	sym_und		;Must have valid symbol here
	addd	t_symbl,r4
	cmpb	pso_set,r3
	if	eq
	 inssb	lbl_tmp,(r4),b_typ,2 ;Make temporary
	endif

	bsr	next
	movzbd	10,r5
	bsr	aray_r5
	bfs	ops_ret
	bsr	ex
	tbitb	b_def,(r5)
	bfc	sym_und		;No forward references allowed

	movqd	4,r6		;Default data length
	extsd	1(r5),r2,b_size-8,4
	cmpb	h'8c,b_size/8(r5) ;Check for string
	if	eq
	 movqd	6,r6
	else
	 cmpb	h'14,t_type[r2:b] ;Check for float
	 if	eq
	  movzbd 8,r6
	 endif
	endif			;R0 holds data length

	cmpqb	2,m_pass
	if	ne		;Never on pass 2
	 extsd	1(r4),r0,b_size-8,4
	 cmpb	t_type[r2:b],t_type[r0:b] ;See if type already matches
	 if	ne
	  extsb	m_amode,r3,0,4	;Current mode
	  orb	h'20,r3		;Must be variable size too
	  cmpb	r3,1(r4)	;If not this then error
	  bne	sym_rdf
	  save	[r1]
	  extsd (r4),r0,0,5	;Length of label
	  addr	6-1(r4),r1	;Pointer to label name-1
	  addr	6-5(r4),r2
	  addd	r6,r2
	  addd	r0,r1		;Pointer to last character of name
	  addd	r0,r2		;Pointer to last target byte
	  movd	r2,tsym_end	;Last byte of symbol
	  addqd	1,tsym_end	;Next available byte
	  movd	mod_indx,tos
	  subd	lmod,tos
	  cmpqd	1,tos		;Check for last module
	  if	eq
	   movd	tsym_end,msym_end ;Only if last module
	  endif
	  movsb b		;Label adjusted as needed for more data
	  restore [r1]
	 endif
	endif

	cmpb	h'8c,1(r5)	;See if string or constant
	if	eq		;String if EQ
	 movqb	0,1(r4)		;Clear original code
	 orw	exp b_def+(h'8c lsh b_mode),(r4) ;Merge with temp status
	 movd	r4,tos		;Pointer to label in symbol table
	 subd	t_symbl,tos	;Must be offset
	 movzwd	2(r5),tos	;Length to store
	 movd	4(r5),tos	;Starting address to store
	 bsr	str_lbl		;Store string
	else			;Non-string
	 addqd	1,r6		;Length of data and 2nd designator byte
	 movd	r6,r0		;Length to compare or store
	 save	[r1]
	 addr	1(r5),r1	;Source address
	 addr	1(r4),r2	;Target address
	 cmpqb	2,m_pass	;If not 2nd pass just store value
	 if	ne
	  movsb
	  sbitb b_def,(r4)
	 else			;This is pass 2
	  extsb	(r4),r3,b_typ,2
	  cmpqb	lbl_tmp,r3
	 orif	eq		;Redefine if temporary label
;	  CMPB	8CH,B_MODE/8(R5) ;See if this is a string
;	  IF	EQ
;	   MOVD 4(R5),R1	;Pointer to stored string
;	   MOVD 4(R4),R2	;Pointer to current string
;	   MOVZWD 2(R4),R0	;Length of strings
;	   CMPW R0,2(R5)	;See if lengths match
;	   IF	EQ
;	    CMPSB
;	   ENDIF
;	  ELSE
	   cmpsb
;	  ENDIF
	  if	ne
	   bsr	sym_rdf
	  endif
	 endif
	 restore [r1]
	endif

	ret


do_push:
	lproc
	reg	[r0,r2,r3,r5]
dplbl:	blkb	2+8
	code
	addr	dplbl,r5
	bsr	ex		;Evaluate expression
	tbitb	b_def,(r5)
	if	fc
	 bsr	sym_und
	endif

	extsb	1(r5),r3,b_size-8,4
	cmpb	8,r3
	if	eq		;String text must be in safe storage
	 cmpd	4(r5),m_string
	 if	lo		;See if already above string storage
	  movzwd 2(r5),r0	;Length of string
	  movd	r0,tos
	  bsr	str_spc		;Make sure there is still room
	  if	fc
	   save	[r1]
	   movd	4(r5),r1	;Pointer to string text
	   movd	m_strptr,r2
	   movsb
	   movd	m_strptr,4(r5)	;Now it lives here
	   movd	r2,m_strptr	;Pointer updated
	   restore [r1]
	  endif
	 else
	  cmpd	4(r5),m_strptr	;Must also be below top of storage
	 orif	hs
	 endif
	endif

	bsr	math_psh	;Push it
	cmpqb	1,m_pass
	if	eq
	 tbitb	b_2pass,m_dolst	;No link if 2 pass
	 if	fc
	  extsd	1(r5),r2,b_size-8,4 ;Size and type of data
	  cmpb	14h,t_type[r2:b]
	  if	eq
	   movb	exp blnk_cmd+clnkpshl,(m_lnkptr)
	   movmd 2(r5),1(m_lnkptr),2
	   addd	9,m_lnkptr
	  else
	   cmpqb 4,t_type[r2:b]	;Check for integer
	   if	eq
	    movb exp blnk_cmd+clnkpshd,(m_lnkptr)
	    movd 2(r5),1(m_lnkptr)
	    addqd 5,m_lnkptr
	   else
	    cmpb 0ch,t_type[r2:b] ;Check for string
	    if	eq
	     save [r0,r1,r2]
	     movd m_lnkptr,r2	;Target address
	     movb exp blnk_cmd+clnkasc,(r2)
	     extsb (r5),r0,0,5	;Label length	
	     movb r0,1(r2)
	     addqd 2,r2
	     addr 2+6(r5),r1	;Label name
	     movsb
	     movd r2,m_lnkptr	;Update pointer
	     restore [r0,r1,r2]
	    else
	     bsr type_err
	    endif
	   endif
	  endif
	 endif
	endif

	pend

do_drop:
	lproc
	reg	[r5]
dplbl:	blkb	2+8
	code
	addr	dplbl,r5
	bsr	math_pop	;Drop it

	cmpqb	1,m_pass
	if	eq
	 tbitb	b_2pass,m_dolst	;No link if 2 pass
	 if	fc
	  movb	mop_drp + exp blnk_mth:#,(m_lnkptr)
	  addqd	1,m_lnkptr
	 endif
	endif

	pend

	mode	sb
last_buf:			;General storage for symbols, macros, etc.
	mode	pc

	dd	0		;Debuggable version must have room for SB size

;End of OPS32
