	print	"NUM32"

;Number and expression evalutation routines


;Convert string in R1 to value in 2(R5), status in 0(R5)
;FS on return if undefined, assumed to be number on entry

num_cnvt:
	save	[r0]
	movzbd	buf_siz,r0	;Max length
	movd	2+4(r5),tos	;Create space for 8 byte returned value
	movd	2(r5),tos	;Create space for 8 byte returned value
	movqb	2,tos		;Default type
	extsb	m_radix,tos,0,5	;Default radix if nothing specified
	bsr	dig_cnvt:d	;Evaluate number
	addd	r0,r1		;Advance R1
	movb	tos,r0		;Trash radix
	movqw	0,(r5)
	inssb	tos,1(r5),b_size-8,4 ;Move type
	movd	tos,2(r5)	;Move number
	movd	tos,2+4(r5)	;Move number
	cmpb	0f0,1(r5)	;See if undefined
	if	eq
	 movqb	-1,1(r5)	;Completely undefined
	else
	 cmpb	h'70,1(R5)	;Can't be 64 be integer either
	orif	eq
	 orw	h'400+exp b_def:#,(r5) ;Defined immediate mode
	endif
	restore	[r0]
	ret


;Evaluate number or symbol in (R1)
;Load 0(R5) with symbol table status, value
;If not a symbol, return status as defined constant

;If character is 0-9 or H' then this is a number

es:	cmpb	"+",0(r1)	;Skip leading +
	if	eq
	 addqd	1,r1
	endif

	cmpb	"-",0(r1)	;Negate following expression if -
	if	eq
	 addqd	1,r1
	 bsr	ez
	 tbitb	b_def:#,(r5)
	 bfc	return		;Error if undefined
	 save	[r2]
	 extsd	1(r5),r2,b_size-8,4 ;Variable type
	 cmpqb	4,t_type[r2:b]	;Check for integer
	 if	eq
	  negd	2(r5),2(r5)
	 else
	  cmpb	h'14,t_type[r2:b] ;Check for float
	  if	eq
	   negl	2(r5),2(r5)
	  else
	   cbitb b_def:#,(r5)	;Can't negate anything else
	  endif
	 endif
	 restore [r2]
	 ret
	endif

ez:	cmpb	"*",(r1)	;Check for current mode pointer
	if	eq
	 save	[r2]
	 movzbd	1(r1),r2	;Must be followed by delimiter to count
	 cmpb	trm_blnk:#,(m_delim)[r2:b]
	 restore [r2]
	 if	hs
	  cmpw	"$(",(r1)	;This is start of mid-string
	  if	ne
	   cmpw	"$<",(r1)	;Start of string
	   if	ne
	    cmpw "$[",(r1)	;Start of string too
	    if	ne
	     addqd 1,r1		;Advance past symbol
	     movw exp b_def+(h'20 lsh b_mode):#,(r5) ;Defined mode
	     inssb m_amode,1(r5),b_mode-8,4 ;Current mode
	     movd (m_amodp),2(r5)
	     ret
	    endif
	   endif
	  endif
	 endif
	else
	 cmpb	"`",(r1)	;Alternate mode pointer
	orif	eq
	 cmpb	"$",(r1)	;Another possibility
	orif	eq
	 cmpb	".",(r1)	;For NSCGNX
	orif	eq
	endif

	bsr	is_num:d	;See if possibly a number
	if	fc		;Number if FC
	 bsr	num_cnvt	;Convert (R1) to value in 2(R5), type in 0(R5)
	 tbitb	b_def,(r5)
	 bfc	prm_ovfl	;Invalid if FC
	 ret
	end

;If first character is quote then string

	cmpb	'"',(r1)
	if	eq
	 save	[r0,r2,r3,r4]
	 movw	h'ff lsh b_mode,(r5) ;Undefined
	 movd	r1,r3		;Save start of quoted string
	 bsr	str_len:d
	 if	fc
	  save	[r1,r2]
	  save	[r5]
	  movd	r0,r5
	  bsr	aray_r5		;Temporary string storage
	  movd	r5,r4		;Base pointer 
	  movd	r5,r2		;Target for string
	  restore [r5]
	  if	fc		;Room if FC
	   movd	r3,r1		;Start of quoted string
	   bsr	bld_quot:d
	   subd	r4,r2		;Length of string
	   movw	exp b_def+(h'8c lsh b_mode):#,(r5)
	   movd	r4,4(r5)	;Pointer to string
	   movw	r2,2(r5)	;Length of string
	  endif
	  tbitb	b_nscgnx,m_ascond
	  if	fc		;Len<5 => integer if not NSCGNX
	   cmpqd 5,r2
	   if	hi
	    movqd 0,2(r5)
	    movw exp b_def+(h'24 lsh b_mode):#,(r5) ;Integer type
	    save [r5]
	    begin
	     cmpqb 0,r2
	    while ne
	     movb (r4),2(r5)
	     addqd 1,r4
	     addqd 1,r5
	     addqb -1,r2
	    endw
	    restore [r5]
	   endif
	  else
	   cmpb	"'",(r3)	;NSCGNX character value
	  orif	eq
	  endif
	  restore [r1,r2]
	 endif
	 addd	r2,r1		;Advance past string
	 restore [r0,r2,r3,r4]
	 ret
	else
	 cmpb	"'",(r1)
	orif	eq
	endif

	tbitb	b_nscgnx,m_ascond
	if	fc		;Only if Kotekan translation
	 cmpb	"$",(r1)	;Check for string
	 if	eq
	  save	[r0,r2]
	  movw	h'ff lsh b_mode,(r5) ;Undefined
	  bsr	str_len:d
	  if	fc
	   movw	exp b_def+(h'8c lsh b_mode):#,(r5)
	   movw	r0,2(r5)	;Length of string
	   movd	r1,4(r5)	;Pointer to string
	  endif
	  addd	r2,r1		;Advance past string
	  restore [r0,r2]
	  ret
	 endif
	endif

max_s'	equ	40		;Max string size

	cmpw	"S'",(r1)	;String of comma separated values
	if	eq
	 addqd	2,r1		;Advance to actual digits
	 save	[r0,r2,r3,r4,r6]
	 movqd	0,r2		;Byte counter, 40 max
	 movd	r5,r6		;Save R5 here
	 movzbd	max_s',r5
	 bsr	aray_r5		;Need temporary working storage
	 movd	r5,r3		;Data pointer to R3
	 movd	r6,r5		;Pointer back in R5
	 if	fc
	  bsr	next:d
	  until	fs
	   bsr	ex
	   tbitb b_def,(r5)
	  quit	fc
	   save	[r0,r1]
	   extsd 1(r5),r4,b_size-8,4 ;Size and type of data
	   addr	2(r5),r1	;Default source data
	   bicpsrb flag_f	;Default is off
	   bsr	do_s'		;Concatenate next value
	   if	fc		;FS if invalid type
	    movd r2,r4		;Current total
	    addd r0,r4		;Trial total
	    cmpd max_s',r4
	    bispsrb flag_f	;In case of error
	    if	hs
	     addr r3[r2:b],r2	;Pointer to current data
	     movsb
	     movd r4,r2		;Total restore to R2
	     bicpsrb flag_f
	    endif
	   endif
	   restore [r0,r1]	;These and R4 are used by DO_S'
	  quit	fs		;Error if buffer full
	   movw	exp b_def+(h'8c lsh b_mode):#,(r5) ;Assume OK for now
	   bsr	comma
	  qend
	   movw	h'ff00,(r5)	;Undefined
	  endu
	  movw	r2,2(r5)	;Length
	  movd	r3,4(r5)	;Text pointer
	 else
	  movw	h'ff00,(r5)	;Undefined
	 endif
	 
	 restore [r0,r2,r3,r4,r6]
	 ret
	endif

	cmpw	"L'",(r1)	;Check for literal hex values
	if	eq		;This is a hex value in LSB to MSB order
	 addqd	2,r1		;Advance to actual digits
	 movw	exp b_def+(h'24 lsh b_mode):#,(r5) ;Assume OK for now
	 save	[r0,r2,r4,r5]
	 movd	r5,r4		;Save data storage here
	 movqd	0,r2		;Byte counter and index, 4 max
	 movqd	0,2(r4)		;Force high bytes to 0
	 
	 until	hs
	  addqd	1,r2
	  cmpqd	4,r2
	 quit	lo
	  lshd	8,r5
	  bsr	hex2dig
	 quit	fs
	  movb	r5,1(r4)[r2:b]	;Store from LS digit
	  movzbd (r1),r0
	  cmpb	trm_blnk:#,(m_delim)[r0:b]
	 qend
	  movw	h'ff00,(r4)	;Undefined
	 endu
	 restore [r0,r2,r4,r5]
	 ret
	endif

;Get length in R0

es_lbl:	save	[r0,r2,r3]

	bsr	length:d
	movw	h'ff00,0(r5)	;Initialize to undefined
	cmpqb	0,r0
	beq	em

	cmpqb	3,r0		;Check for "POP"
	if	eq
	 movd	(r1),r3
	 andd	h'ffffff,r3
	 cmpd	"POP",r3
	 if	eq
	  bsr	math_pop
	  br	em
	 endif
	endif

	bsr	sym2val		;Search symbol table
	if	ne
	 cmpqb	1,m_pass
	 bne	em		;Only make symbols on pass 1
	 movb	r0,tos		;Length
	 movw	h'2b lsh b_mode,tos ;Default to PC relative
	 movd	r1,tos		;Symbol name
	 movd	r3,tos		;Previous symbol pointer
	 bsr	make_sym:d	;Make new symbol table entry
	else
	 movmw	sidx_of(r2),(r5),5 ;Got a keeper, move it into (R5)
	 movd	msym_beg,r3
	 addd	t_symbl,r3	;Starting address of this module's symbols
	 cmpd	r2,r3		;See if from a previous module
	 if	lo
	  extsb	1(r5),r3,b_mode-8,4
	  cmpb	b'1010,r3	;SB relative
	  if	eq
	   inssb lbl_ext,(r5),b_typ,2
	   cbitb b_def,(r5)	;These are always undefined/external
	  else
	   cmpb	b'1011,r3	;PC relative
	  orif	eq
	  endif
	 else
	  cmpd	r2,msym_end	;Also external if from a later module
	 orif	hs
	  tbitb	2,lnk_prm	;Check for ONEMOD
	  if	fs
	   extsb 1(r5),r3,b_mode-8,4
	   cmpb	b'1010,r3	;SB relative
	   if	eq		;ONEMOD SB are all undefined external
	    inssb lbl_ext,(r5),b_typ,2
	    cbitb b_def,(r5)
	   endif
	  endif
	 endif
	endif

	tbitb	b_xrf,m_dolst	;See if cross reference required
	if	fs
	 cmpqb	1,m_pass
	 if	eq		;Only on pass 1
	  inssd	m_symadr,(m_xrflin),0,sidx_bit
	  addqd	sidx_of,m_xrflin
	  addqb	1,2(m_xrfptr)	;One more label
	 endif
	endif

;Advance past symbol in source

em:	addd	r0,r1
	restore	[r0,r2,r3]
	ret	0

;Processing subroutine for S'
;R2 holds current count, R3 holds data pointer
;R4 holds B_SIZE bits:D, (R5) holds latest defined value
;Return with R1 pointing to source data, R0 pointing to length to move
;FS on exit if undefined data type
;R4 may be altered

do_s':	CASEW	DO_S'1[r4:w]
do_s'1:	WORD	DS'0000-do_s'	;Byte integer
	word	ds'0001-DO_S'	;Word integer
	word	ds'0010-DO_S'	;Variable size integer
	word	ds'0011-DO_S'	;Dword integer
	word	ds'0011-DO_S'	;Single precision float
	word	ds'0101-DO_S'	;Double precision float
	word	ds'0010-DO_S'	;Variable size float
	word	ds'0111-DO_S'	;Undefined
	word	ds'1000-DO_S'	;Text
	word	ds'0111-DO_S'	;Undefined
	word	ds'0111-DO_S'	;Undefined
	word	ds'0111-DO_S'	;Undefined
	word	ds'0000-DO_S'	;Boolean, 1 byte
	word	ds'0011-DO_S'	;BCD 4 bytes
	word	ds'0111-DO_S'	;Undefined
	word	ds'0111-DO_S'	;Undefined

ds'0000: movqd	1,r0		;Move byte value
	ret

ds'0001: movqd	2,r0		;Move word value
	ret

ds'0010: bsr	byt_siz:d
	movd	r4,r0		;Parameter determines its own size
	bicpsrb	flag_f
	ret

ds'0011: movqd	4,r0		;Move Dword value
	ret

ds'0101: movzbd	8,r0		;Double precision float
	ret

ds'0111: bispsrb flag_f		;Undefined
	ret

ds'1000: movzwd 2(r5),r0	;Text
	movd	4(r5),r1
	ret


;Load R5 with pointer to array with size passed in R5
;FS on exit if no room, and R5 loaded with base of array

aray_r5:
	save	[r2,r3]
	addr	var_siz+var_buf,r2 ;Highest address + 1
	movd	var_ptr,r3	;Trial assignment
	addd	r3,r5
	cmpd	r5,r2
	if	ls		;OK if LS
	 movd	r5,var_ptr	;Update pointer
	 movd	r3,r5
	 bicpsrb flag_f
	else
	 addr	var_buf,r5
	 bispsrb flag_f
	end
	restore	[r2,r3]
	bfc	return
	br	mem_ovfl:d


;Expression evaluator, R1 => expression, value returned in (R5)
;Undefined values leave link data in VAR_BUF, pointer in 2(R5)
;Link data preceded byte 1 byte length

ex:	lproc
	reg	[r0,r2,r3,r4,r6,r7]
lnk_dat: blkb	256		;Link data
lnk_ptr: blkb	4		;Pointer to current link data
mbas_ptr: blkb	4		;Math stack base pointer
op_stak: blkb	16		;Op stack for 16 math operators
	code

	addr	lnk_dat+1,lnk_ptr ;Current pointer to next link data
	movd	math_ptr,mbas_ptr ;Base for evaluation

	tbitb	b_rpn,m_radix
	if	fs
	 bsr	ex1
	else
	 bsr	ex_alg
	end
	bsr	math_pop
	tbitb	b_def:#,(r5)
	if	fc		;Undefined if FC
	 cmpqb	1,m_pass
	 if	eq
	  tbitb b_2pass,m_dolst ;Check list status
	 else
	  bispsrb flag_f	;Assume not linking
	  cmpqb 2,m_pass
	  if	eq
	   extsb (r5),tos,b_typ,2
	   cmpqb lbl_ext,tos
	   if	eq
	    bicpsrb flag_f
	   endif
	  endif
	 endif
	 if	fc
	  addr	lnk_dat,r2	;Base of link data
	  movd	lnk_ptr,r3	;Next available byte of link code
	  subd	r2,r3		;Start of link data - 1
	  movb	r3,lnk_dat	;Store length
	  addqb -1,lnk_dat	;Length byte doesn't count in length
	  cmpqd 1,r3		;No data if only length byte
	  if	lo
	   movd r5,r4		;Save this for now
	   movd r1,r6		;Save this too
	   movd r3,r5		;Space required
	   bsr	aray_r5
	   movd r5,r2		;Target for data
	   movd r2,2(r4)	;Return pointer here
	   movd r3,r0		;Count
	   addr lnk_dat,r1	;Source of data
	   movsb
	   movd r4,r5
	   movd r6,r1
	  endif
	 endif
	endif
	cmpb	":",(r1)	;Check ":" indicating size/addressing mode
	if	eq
	 bsr	ex_coln
	end

	pend

ex1:	bsr	next:d
	bfs	return

;Check for termination character

	movzbd	(r1),r2
	cmpqb	trm_exp:#,(m_delim)[r2:b]
	bhs	return

;Check for math operator
	
	bsr	math_sym	;Return code + 1 in R0, R0=0 and FC if none
	bsr	do_math		;Operator code + 1 in R0
	cmpqd	0,r0
	if	ne
	 bsr	op_push
	 br	ex1		;That was a math operator if NZ
	end

	movd	r1,r2		;Save current pointer
	bsr	es
	bsr	yf		;Display error message as necessary
	bsr	math_psh	;Push value onto stack
	bsr	exp_push
	cmpd	r1,r2		;If no length, then exit
	beq	return
	br	ex1


;Load op+1 code in R0 into link data
;R5 must point to valid and empty parameter buffer

op_push:
	save	[r0]
	addqd	-1,r0		;Convert to 0-1FH
	cmpb	mop_dup:#,r0	;If DUP then push current TOS
	if	eq
	 bsr	math_pop	;Get current TOS into R5
	 bsr	math_psh	;Restore stack
	 bsr	exp_push	;Push expression
	else
	 cmpb	mop_pik:#,r0	;If PIK then push current TOS
	orif	eq
	 addb	exp blnk_mth:#,r0 ;Make math operator
	 movb	r0,(lnk_ptr)
	 addqd	1,lnk_ptr
	endif
	restore	[r0]
	ret

;Put (R5) into link data as value or pointer to label
;M_SYMADR must hold address of symbol

exp_push:
	save	[r0,r1,r2]
	tbitb	b_def:#,(r5)
	if	fs
	 extsd	1(r5),r2,b_size-8,4 ;See if float
	 cmpb	14h,t_type[r2:b]
	 if	eq
	  movb	exp blnk_cmd+clnkpshl,(lnk_ptr)
	  movmd	2(r5),1(lnk_ptr),2
	  addd	9,lnk_ptr
	 else
	  cmpqb	4,t_type[r2:b]	;Check for integer
	  if	eq
	   movb	exp blnk_cmd+clnkpshd,(lnk_ptr)
	   movd	2(r5),1(lnk_ptr)
	   addqd 5,lnk_ptr
	  else
	   cmpb 0ch,t_type[r2:b] ;Check for string
	   if	eq
	    save [r0,r1,r2]
	    movd lnk_ptr,r2	;Target address
	    movb exp blnk_cmd+clnkasc,(r2)
	    extsb (r5),r0,0,5	;Label length	
	    movb r0,1(r2)
	    addqd 2,r2
	    addr 2+6(r5),r1	;Label name
	    movsb
	    movd r2,lnk_ptr	;Update pointer
	    restore [r0,r1,r2]
	   else
	    bsr	type_err
	   endif
	  endif
	 endif
	else
	 movb	exp blnk_cmd+clnklpt,(lnk_ptr)
	 inssd	m_symadr,1(lnk_ptr),0,sidx_bit ;Store offset
	 addqd	1+sidx_of,lnk_ptr
	end
	restore	[r0,r1,r2]
	ret


;Expression evaluator for algebraic notation

ex_alg:	addr	op_stak,r6	;Base of op stack

ex_alg1:
	movqd	0,r3		;1st operator code
	movqd	0,r4		;2nd operator code
	movqd	0,r7		;Op stack index

;Check for 1 parameter operator

ex_alg2:
	bsr	next:d
	bfs	ex_exit
	movd	r1,r2		;Save original pointer
	bsr	math_sym
	cmpb	mth_1prm+1:#,r0	;See if 1 parameter operator
	ble	ex_alg5
	movd	r2,r1		;Restore original R1

;Check for opening parenthesis

	cmpb	"(",(r1)
	if	eq
	 movb	r3,r6[r7:b]	;Store on op stack
	 addqd	1,r7
	 movd	r7,2(r5)	;Op stack index
	 movw	exp b_def+h'2400:#,(r5) ;Defined constant
	 bsr	math_psh
	 movd	r6,2(r5)	;Current op stack base pointer
	 bsr	math_psh	;Save this too
	 addr	r6[r7:b],r6	;New base pointer
	 addqd	1,r1
	 br	ex_alg1
	end

	movd	r1,r2		;Save current pointer
	bsr	es
	bsr	yf		;Display error message as necessary
	bsr	math_psh	;Push value onto stack
	bsr	exp_push
	cmpd	r1,r2		;If no length, then exit
	beq	ex_exit

;Get next operand in R4 now

ex_alg3a:
	bsr	next:d
	bfs	ex_exit

;Check for closing parenthesis

	cmpb	")",(r1)
	if	eq
	 bsr	ex_exit		;Make sure this line is finished

	 movd	math_ptr,r2
	 subd	mbas_ptr,r2
	 cmpd	3*6,r2		;Need op stack data + result of ()
	 bgt	ex_exit		;No corresponding "(" if GT

	 bsr	stk_swp		;R6 to top of stack
	 bsr	math_pop
	 movd	2(r5),r6	;Old op stack base pointer
	 bsr	stk_swp
	 bsr	math_pop
	 movd	2(r5),r7	;Old op stack index

	 addqd	-1,r7
	 movzbd	r6[r7:b],r3
	 movqd	0,r4
	 addqd	1,r1
	 br	ex_alg3a
	end

	bsr	math_sym
	cmpqd	0,r0
	beq	ex_exit		;End of expression if no more operators
ex_alg5:
	movd	r0,r4

;2 operators in R3 and R4, if R3 is highest priority just do that one
; unless both are 1 parameter operators, then evaluate right to left
;Codes in register are operator code+1

ex_alg5a:
	cmpb	t_opordr-1[r3:b],t_opordr-1[r4:b]
	blo	ex_alg6
	cmpb	mth_1prm+1,r4
	bls	ex_alg6		;1 parameter ops evaluate right to left
	movd	r3,r0
	bsr	do_math
	bsr	op_push

	cmpqd	0,r7		;See if op stack is empty
	beq	ex_alg7
	addqd	-1,r7
	movzbd	r6[r7:b],r3
	br	ex_alg5a
ex_alg6:
	cmpqd	0,r3
	if	ne
	 movb	r3,r6[r7:b]
	 addqd	1,r7
	end
ex_alg7:
	movd	r4,r3
	movqd	0,r4
	br	ex_alg2

;Closing routine for EX_ALG
;Resolve any remaining operators/operands

ex_exit:
	cmpqd	0,r3		;See if any operator left in R3
	if	ne
	 movd	r3,r0
	 bsr	do_math
	 bsr	op_push
	 movqd	0,r3
	endif
	cmpqd	0,r4
	if	ne
	 movd	r4,r0
	 bsr	do_math
	 bsr	op_push
	 movqd	0,r4
	endif

	begin
	 cmpqd	0,r7		;Check for more operators
	while	ne
	 addqd	-1,r7
	 movzbd	r6[r7:b],r0
	 bsr	do_math
	 bsr	op_push
	endw
	ret


;Colon found, look for B/W/D size or */# mode descriptor

ex_coln:
	save	[r0,r2,r3,r4]
	addqd	1,r1		;Skip ":" character
	until	fc
	 movd	r1,r3		;Save current R1 in case no match
	 movd	"    ",r4
	 cmpb	"(",(r1)	;(FP),(SP),(SB) if this
	 if	eq
	  cmpb	":",-1(r1)	;Only legal right after colon
	  if	eq
	   movd	(r1),r4
	   addqd 4,r1
	  endif
	 else
	  movb	(r1),r4		;Single character with blanks if this
	  addqd	1,r1
	 endif
	 save	[r1]
	 addr	t_modex-4,r1	;Start at end of table
	 movzbd	(t_modex-t_mode)/4,r0 	;Number of entries to search
	 skpsd	u,b		;FS if match found
	 restore [r1]
	 sprb	upsr,tos	;Save F flag for ENDU
	 if	fs		;Match found if FS
	  extsd	1(r5),r2,b_size-8,4 ;Currently defined type
	  addqd	-1,r0		;Start with 0 offset
	  bsr	excolns
	 else
	  movd	r3,r1		;Restore original R1
	 endif
	 lprb	upsr,tos	;Restore F flag with match condtion
	endu
	restore	[r0,r2,r3,r4]
	ret


;Label names for addressing modes

t_mode:	dd	"(FP)"
	dd	"(SP)"
	dd	"(SB)"
	dd	"?   "
	dd	"#   "
	dd	"@   "
	dd	"X   "
	dd	"#   "
	dd	"(FP)"
	dd	"(SP)"
	dd	"(SB)"
	dd	"*   "
	dd	"$   "
	dd	"$   "
	dd	"?   "
	dd	"?   "	

;Extra for EX_COLN

	dd	"B   "
	dd	"W   "
	dd	"D   "
	dd	"E   "
	dd	"F   "
	dd	"L   "
	dd	"S   "
	dd	"Z   "
t_modex:

excolns:  casew	t_excoln[r0:w]
t_excoln:
	word	exc_fp-excolns	;:(FP)
	word	exc_sp-excolns	;:(SP)
	word	exc_sb-excolns	;:(SB)
	word	type_err-excolns ;Undefined
	word	exc_num-excolns	;:# (constant)
	word	exc_abs-excolns	;:@ (absolute address)
	word	exc_exx-excolns	;:X (external mode)
	word	exc_num-excolns	;:# (constant)
	word	exc_fp-excolns	;:(FP)
	word	exc_sp-excolns	;:(SP)
	word	exc_sb-excolns	;:(SB)
	word	exc_pc-excolns	;:* (PC relative)
	word	exc_str-excolns	;:$ (string)
	word	exc_str-excolns	;:$ (string)
	word	type_err-excolns ;Undefined
	word	type_err-excolns ;Undefined
	word	exc_byt-excolns	;:B (byte)
	word	exc_wrd-excolns	;:W (word)
	word	exc_dbl-excolns	;:D (Double word)
	word	exc_ext-excolns	;:E (external type)
	word	exc_flt-excolns	;:F (float)
	word	exc_lng-excolns	;:L (long float)
	dw	exc_sex-excolns	;:S (Sign extend)
	dw	exc_zex-excolns	;:Z (Zero extend)

;Make current variable FP relative

exc_fp:	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	8,1(r5),b_mode-8,4
	ret

;Make current variable SP relative

exc_sp:	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	9,1(r5),b_mode-8,4
	ret

;Make current variable SB relative

exc_sb:	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	10,1(r5),b_mode-8,4
	ret

;Make current variable PC relative

exc_pc:	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	11,1(r5),b_mode-8,4
	ret

;Make current variable absolute (:@)

exc_abs:
	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	5,1(r5),b_mode-8,4
	ret

;Make current variable external addressing mode (:X)

exc_exx:
	cmpqb	3,r2		;Must be integer constant
	blo	type_err
	inssb	6,1(r5),b_mode-8,4
	ret

;Make current variable external type (:E)
;Doesn't make external addressing mode, just sets external attribute

exc_ext:
	inssb	lbl_ext,(r5),b_typ,2
	bicb	b_def,(r5)	;Make undefined
	ret

;Make current variable a constant

exc_num:
	cmpqb	4,t_type[r2:b]	;OK if integer type
	if	eq
	 inssb	4,1(r5),b_mode-8,4
	else
	 cmpb	14h,t_type[r2:b] ;Check for float
	 if	eq
	  movb	24h,1(r5)
	  tbitb	b_def,(r5)	;Only convert if defined
	  if	fs
	   roundld 2(r5),2(r5)
	  endif
	 else			;Anything else is an error
	  bsr	type_err
	 endif
	endif
	ret

;Make string

exc_str:
	br	type_err	;Not supported yet

;Convert to byte

exc_byt:
	cmpqb	4,t_type[r2:b]	;OK if integer type
	if	eq
	 inssb	0,1(r5),b_size-8,4
	 cmpqb	4,1(r5)		;See if constant
	 if	eq
	  tbitb b_def,(r5)
	  if	fs
	   movxbd 2(r5),2(r5)
	  endif
	 endif
	else
	 cmpb	14h,t_type[r2:b] ;Check for float
	 if	eq
	  movqb 4,1(r5)
	  tbitb	b_def,(r5)	;Only convert if defined
	  if	fs
	   roundld 2(r5),2(r5)
	  endif
	 else			;Anything else is an error
	  bsr	type_err
	 endif
	endif
	ret

;Convert to word

exc_wrd:
	cmpqb	4,t_type[r2:b]	;OK if integer type
	if	eq
	 inssb	1,1(r5),b_size-8,4
	 cmpb	14h,1(r5)	;See if constant
	 if	eq
	  tbitb b_def,(r5)
	  if	fs
	   movxwd 2(r5),2(r5)
	  endif
	 endif
	else
	 cmpb	14h,t_type[r2:b] ;Check for float
	 if	eq
	  movb	14h,1(r5)
	  tbitb	b_def,(r5)	;Only convert if defined
	  if	fs
	   roundld 2(r5),2(r5)
	  endif
	 else			;Anything else is an error
	  bsr	type_err
	 endif
	endif
	ret

;Convert to Dword

exc_dbl:
	cmpqb	4,t_type[r2:b]	;OK if integer type
	if	eq
	 inssb	3,1(r5),b_size-8,4
	else
	 cmpb	14h,t_type[r2:b] ;Check for float
	 if	eq
	  movb	34h,1(r5)
	  tbitb	b_def,(r5)	;Only convert if defined
	  if	fs
	   roundld 2(r5),2(r5)
	  endif
	 else			;Anything else is an error
	  bsr	type_err
	 endif
	endif
	ret

;Sign extend byte or word to Dword

exc_sex:
	cmpqb	0,r2		;Check for byte
	if	eq
	 tbitb b_def,(r5)
	 if	fs
	  movxbd 2(r5),2(r5)
	 endif
	else
	 cmpqb	1,r2		;Check for word
	 if	eq
	  tbitb b_def,(r5)
	  if	fs
	   movxwd 2(r5),2(r5)
	  endif
	 else
	  bsr	type_err
	 endif
	endif
	ret

;Zero extend byte or word to Dword

exc_zex:
	cmpqb	0,r2		;Check for byte
	if	eq
	 tbitb b_def,(r5)
	 if	fs
	  movzbd 2(r5),2(r5)
	 endif
	else
	 cmpqb	1,r2		;Check for word
	 if	eq
	  tbitb b_def,(r5)
	  if	fs
	   movzwd 2(r5),2(r5)
	  endif
	 else
	  bsr	type_err
	 endif
	endif
	ret

;Convert to float

exc_flt:
	cmpb	14h,t_type[r2:b] ;OK if float
	if	eq
	 inssb	4,1(r5),b_size-8,4
	else
	 cmpqb	4,t_type[r2:b]	;Check for integer
	 if	ne
	  bsr	type_err
	 else
	  save	[r3]
	  extsb	b_mode/8(r5),r3,b_mode-8,4
	  cmpqb	4,r3		;Must be immediate mode
	  restore [r3]
	 orif	ne
	  movb	44h,1(r5)	;Make it float
	  tbitb b_def,(r5)
	  if	fs
	   movdl 2(r5),2(r5)
	  endif
	 endif
	endif
	ret

;Convert to double float

exc_lng:
	cmpb	14h,t_type[r2:b] ;OK if float
	if	eq
	 inssb	5,1(r5),b_size-8,4
	else
	 cmpqb	4,t_type[r2:b]	;Check for integer
	 if	ne
	  bsr	type_err
	 else
	  save	[r3]
	  extsb	b_mode/8(r5),r3,b_mode-8,4
	  cmpqb	4,r3		;Must be immediate mode
	  restore [r3]
	 orif	ne
	  movb	54h,1(r5)	;Make it long
	  tbitb b_def,(r5)
	  if	fs
	   movdl 2(r5),2(r5)
	  endif
	 endif
	endif
	ret


;Check for undefined symbol, adjust things accordingly

yf:	tbitb	b_def:#,0(r5)
	bfs	return		;OK if defined

	cmpb	"I",m_pass	;Everything must be defined if immediate
	if	ne
	 cmpqb	2,m_pass
	 if	eq		;Pass 2 if EQ
	  tbitb 0,lnk_prm
	  if	fs		;Undefineds declared external if FS
	   inssb lbl_ext,(r5),b_typ,2
	  endif
	 endif
	 extsb	(r5),tos,b_typ,2
	 cmpqb	lbl_ext,tos
	 beq	return		;Externals may always be undefined
	 movb	h'2b,b_mode/8(r5) ;Force PC relative mode, variable length
	 cmpqb	1,m_pass	;Error if not pass 1
	 beq	return
	endif
;Error

yd:

;If number then use "Value out of range" message

	save	[r3]
	extsb	1(r5),r3,b_mode-8,4	
	cmpqb	4,r3		;Check for constant
	restore	[r3]
	beq	prm_ovfl
	br	sym_und


;Search symbol table, R0=length, R1=string to find,
;return EQ if found, NE if not, R2 points to entry >= searched for.
;R3 => address of previous entry (pointer to following entry)
;Return address of actual label offset in M_SYMADR, T_SYMALF offset in M_SYMALF
;Search global table 1st, if not found then search local table
;If nothing found, pointers in R2 and R3 are for global table

sym2val:
	movd	t_symbl,r2
	movqd	0,m_symadr
	addr	t_symalf,r3	;Default in case of error
	movd	r3,m_symalf
	cmpqb	0,r0		;Can't be 0 length
	if	eq
	 bicpsrb flag_z
	 ret
	endif
	bsr	sym_indx	;Initialize R3 for proper index entry

	movd	r3,m_symalf
	bsr	sym2sub
	beq	return		;Got a keeper if equal

	save	[r2,r3]
	addr	t_symfp,r3	;FP label table
	bsr	sym2sub
	if	eq		;Keep FP label if found
	 adjspb -8		;Clear original R2,R3
	else
	 addr	t_symlcl,r3	;Local label table
	 bsr	sym2sub
	 if	eq		;Keep local label if found
	  adjspb -8		;Clear original R2,R3
	 else
	  restore [r2,r3]
	  addr	sidx_of(r2),m_symadr ;Pointer to 16 bit status field
	  subd	t_symbl,m_symadr ;Need offset only
	 endif
	endif
	ret


	disp	2

;Check for math operator in R1, return code+1 in R0
;R1 is advanced past symbol name if a match is found
;FS if a match found, R0=0 if none

math_sym:
	save	[r4]
	movd	r1,tos		;Save in case of no match

	bsr	pad_blnk:d	;Get search string into R4

	tbitb	b_rpn,m_radix
	if	fs
	  movzbd (r1),r0
	  cmpqb	trm_blnk,(m_delim)[r0:b] ;OK if followed by delimiter
	  movqd	0,r0		;In case of error
	  blo	math_sm1
	endif

	save	[r1]
	movzbd	mth_mop+1,r0	;Search length
	addr	t_mathop,r1
	skpsd	u
	restore	[r1]
	bfc	math_sm1
	movd	tos,r4		;Trash original R1
	restore	[r4]
	ret	0
math_sm1:
	movd	tos,r1		;No match, restore original value
	restore	[r4]
	ret	0

;Values are in order of decreasing priority

t_mathop:
	dd	"LNAD"		;LINK table address
	dd	"MDAD"		;MOD table address
	dd	"SBAD"		;SB address
	dd	"PCAD"		;PC address

	dd	"COM "
	dd	"~   "
	dd	"LOG "
	dd	"EXP "
	dd	"NOT "
	dd	"NEG "
	dd	"ABS "
	dd	"LEN "

	dd	"ASH "
	dd	"ROT "
	dd	"LSH "
	dd	"<<  "
	dd	">>  "
	
	dd	"/   "
	dd	"*   "
	dd	"-   "
	dd	"+   "
	dd	"MOD "
	dd	"%   "

	dd	"AND "
	dd	"&   "
	dd	"OR  "
	dd	"|   "
	dd	"XOR "
	dd	"^   "

	dd	"NE  "
	dd	"EQ  "
	dd	"LS  "
	dd	"HS  "
	dd	"LO  "
	dd	"HI  "
	dd	"LE  "
	dd	"GE  "
	dd	"LT  "
	dd	"GT  "

	dd	"DUP "
	dd	"DROP"
	dd	"PICK"
	dd	"SWAP"

;End of NUM32
