	PRINT	"MNU32.MAC"

;Main execution loop, repeat forever

MENU_LP:
	MOVD	EXP (BKB_TRM+1),R0 ;Termination character in R5
	ADDR	MENU,R1
	MOVZBD	VC_IGN,R5	;Terminated by this
	MOVD	DOF_BLK+DEV_SMV LSH b_iosrv,R6
	MAC_2SVC		;Load menu

 	MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	MOVD	DC_MENU+EXP DC_MNDSP,R5 ;Display menu only
	MAC_2SVC

	PROC
	REG	[]
BUF:	DS	20		;Input buffer
	CODE

	UNTIL	EQ		;Get a valid command
	 ADDR	BUF,R1
 	 MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	 MOVD	DC_MENU+EXP DC_MNEXE,R5
	 MAC_2SVC
	 CMPQB	1,R0		;Must have valid character
	 IF	EQ
	  SAVE	[R0,R1,R5]
	  MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	  MOVD	DC_WCLR,R5	;Release current window
	  MAC_2SVC
	  RESTORE [R0,R1,R5]
	  BSR	MENU_EXE	;Execution loop for commands
	  BISPSRB FLAG_Z	;Make EQ
	 ENDIF
	ENDU
	PEND

	BR	MENU_LP		;Exit loop if running debugger

MENU:
	DB	VC_SCR,VCS_PAG	;Clear screen
	DB	CR,LF,CR,LF
	DB	VC_SAT,EXP VCA_HLT+EXP VCA_REV
	DB	"Welcome to Kotekan"
	DB	VC_CAT,EXP VCA_HLT+EXP VCA_REV
	DB	CR,LF,CR,LF
	DB	VC_WIN,VCW_MENB
	DW	(EXP BKB_SWN+EXP BKB_RET+EXP BKB_CNV) LSH -16

	DB	VC_WIN,VCW_MITB,0,1,"C"
	DB	VC_SAT,EXP VCA_UND,"C",VC_CAT,EXP VCA_UND
	DB	"PU Monitor"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,CR,LF
	DB	VC_WIN,VCW_MITB,0,1,"D"
	DB	VC_SAT,EXP VCA_UND,"D",VC_CAT,EXP VCA_UND
	DB	"isk utilities"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,CR,LF
	DB	VC_WIN,VCW_MITB,0,1,"F"
	DB	VC_SAT,EXP VCA_UND,"F",VC_CAT,EXP VCA_UND
	DB	"orth"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,CR,LF
	DB	VC_WIN,VCW_MITB,0,1,"S"
	DB	VC_SAT,EXP VCA_UND,"S",VC_CAT,EXP VCA_UND
	DB	"ystem defaults"
	DB	VC_WIN,VCW_MITE
	DB	VC_WIN,VCW_MENE,0
	DB	VC_IGN

;Main menu execution routine
;(R1) holds command to execute

MENU_EXE:
	SAVE	[R0,R1,R4]
	MOVB	(R1),R4
	ADDR	T_MENEXX-1,R1
	MOVZBD	T_MENEXX-T_MENEX,R0
	SKPSB	B,U
	MOVD	R0,R3
	RESTORE	[R0,R1,R4]
MEN_EX1:
	CASEW	T_MENEXX[R3:W]

T_MENEX:
	DB	"C"
	DB	"D"
	DB	"F"
	DB	"S"
T_MENEXX:
	DW	RETRN-MEN_EX1
	DW	DO_MON-MEN_EX1
	DW	DO_DISK-MEN_EX1
	DW	DO_FORTH-MEN_EX1
	DW	DO_SYS-MEN_EX1


;Jump to debugger

DO_MON:
 	MOVD	DOF_CMD+DEV_OP LSH b_iosrv,R6
	MOVD	DC_PRGD,R5	;Call debugger
	MAC_2SVC
	RET

;Run FORTH

DO_FORTH:
 	MOVD	DOF_CMD+DEV_OP LSH b_iosrv,R6
	MOVD	DC_PRGL,R5	;Call debugger
	ADDR	FORTH_NAM,R1
	MOVQD	5,R0
	MAC_2SVC
	RET

FORTH_NAM: DB	"Forth"

;Disk sub-commands

DO_DISK:
	MOVD	EXP (BKB_TRM+1),R0 ;Termination character in R5
	ADDR	DISK_MEN,R1
	MOVZBD	VC_IGN,R5	;Terminated by this
	MOVD	DOF_BLK+DEV_SMV LSH b_iosrv,R6
	MAC_2SVC		;Load menu

	UNTIL	EQ
	 MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	 MOVD	DC_MENU+EXP DC_MNDSP,R5 ;Display menu only
	 MAC_2SVC
	 
	 PROC
	 REG	[]
BUF:	 DS	20		;Input buffer
	 CODE
	 
	 UNTIL	EQ		;Get a valid command
	  ADDR	BUF,R1
 	  MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	  MOVD	DC_MENU+EXP DC_MNEXE,R5
	  MAC_2SVC
	  CMPQB	1,R0		;Must have valid character
	  IF	EQ
	   SAVE	[R5]
	   BSR	DISK_EXE	;Execution loop for commands
	   BISPSRB FLAG_Z	;Make EQ
	   RESTORE [R5]
	  ELSE
	   CMPB	ESC,R5		;Also quit if ESC pressed
	  ENDIF
	 ENDU
	 PEND
	 
	 CMPB	ESC,R5
	ENDU

 	MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	MOVD	DC_WCLR,R5	;Release current window
	MAC_2SVC

	RET

DISK_MEN:
	DB	VC_SCR,VCS_PAG	;Clear screen
	DB	CR,LF,CR,LF
	DB	VC_SAT,EXP VCA_HLT+EXP VCA_REV
	DB	"Disk commands"
	DB	VC_CAT,EXP VCA_HLT+EXP VCA_REV
	DB	CR,LF,LF
	DB	VC_WIN,VCW_MENB
	DW	(EXP BKB_SWN+EXP BKB_RET+EXP BKB_ESC+EXP BKB_CNV) LSH -16

	DB	VC_WIN,VCW_MITB,0,1,"F"
	DB	VC_SAT,EXP VCA_UND,"F",VC_CAT,EXP VCA_UND
	DB	"ormat a disk"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,LF
	DB	VC_WIN,VCW_MITB,0,1,"L"
	DB	VC_SAT,EXP VCA_UND,"L",VC_CAT,EXP VCA_UND
	DB	"og in a disk"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,LF
	DB	VC_WIN,VCW_MITB,0,1,"R"
	DB	VC_SAT,EXP VCA_UND,"R",VC_CAT,EXP VCA_UND
	DB	"ead a file"
	DB	VC_WIN,VCW_MITE

	DB	CR,LF,LF
	DB	VC_WIN,VCW_MITB,0,1,"W"
	DB	VC_SAT,EXP VCA_UND,"W",VC_CAT,EXP VCA_UND
	DB	"rite a file"
	DB	VC_WIN,VCW_MITE

	DB	VC_WIN,VCW_MENE,0
	DB	VC_IGN

DISK_EXE:
	SAVE	[R0,R1,R4]
	MOVB	(R1),R4
	ADDR	T_DSKEXX-1,R1
	MOVZBD	T_DSKEXX-T_DSKEX,R0
	SKPSB	B,U
	MOVD	R0,R3
	RESTORE	[R0,R1,R4]
DSK_EX1:
	CASEW	T_DSKEXX[R3:W]

T_DSKEX:
	DB	"F"		;Format
	DB	"L"		;Log
	DB	"R"		;Read
	DB	"W"		;Write
T_DSKEXX:
	DW	RETRN-DSK_EX1
	DW	DSK_FMT-DSK_EX1
	DW	DSK_LOG-DSK_EX1
	DW	DSK_RD-DSK_EX1
	DW	DSK_WRT-DSK_EX1

DSK_FMT:
	MOVD	DC_LFMT,R5
 	MOVD	DOF_CMD+DEV_M1 LSH b_iosrv,R6
	MAC_2SVC
	RET

DSK_LOG:
	MOVD	DC_LOG,R5
 	MOVD	DOF_CMD+(DEV_M1+1) LSH b_iosrv,R6
	MAC_2SVC
	RET

DSK_RD:
	MOVQD	7,R0
	ADDR	FIL_NAM,R1
	MOVD	DC_OPEN,R5
	MOVD	DOF_CMD+(DEV_M1+1) LSH b_iosrv,R6
	MOVW	USR_DAT,TOS
	MAC_2SVC
	ADDR	@H'840000,R1
	MOVD	EXP BKB_TRM+H'FFFF,R0 ;Read entire file
	MOVD	DOF_BLK+(DEV_M1+1) LSH b_iosrv,R6
	MAC_2SVC
	MOVD	DC_CLOSE,R5
	MOVD	DOF_CMD+(DEV_M1+1) LSH b_iosrv,R6
	MAC_2SVC

	RET


DSK_WRT:
	MOVQD	7,R0
	ADDR	FIL_NAM,R1
	MOVD	DC_MAKE,R5
	MOVD	DOF_CMD+DEV_M1 LSH b_iosrv,R6
	MOVW	USR_DAT,TOS
	MAC_2SVC
	ADDR	@H'A00000,R1
	MOVD	H'2000+EXP BKB_CNT,R0
	MOVD	DOF_BLK+DEV_M1 LSH b_iosrv,R6
	MAC_2SVC
	MOVD	DC_CLOSE,R5
	MOVD	DOF_CMD+DEV_M1 LSH b_iosrv,R6
	MAC_2SVC

	RET

FIL_NAM:
	DB	"Kotekan"

;System defaults sub-commands

DO_SYS:
	MOVD	EXP (BKB_TRM+1),R0 ;Termination character in R5
	ADDR	SYS_MEN,R1
	MOVZBD	VC_IGN,R5	;Terminated by this
	MOVD	DOF_BLK+DEV_SMV LSH b_iosrv,R6
	MAC_2SVC		;Load menu

 	MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	MOVD	DC_MENU+EXP DC_MNDSP,R5 ;Display menu only
	MAC_2SVC

	PROC
	REG	[]
BUF:	DS	20		;Input buffer
	CODE

	UNTIL	EQ		;Get a valid command
	 ADDR	BUF,R1
 	 MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	 MOVD	DC_MENU+EXP DC_MNEXE,R5
	 MAC_2SVC
	 CMPB	ESC,R5		;Always return if this
	 IF	NE
	  BSR	SYS_EXE
	 ENDIF
	ENDU
	PEND

 	MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	MOVD	DC_WCLR,R5	;Release current window
	MAC_2SVC

	RET

SYS_MEN:
	DB	VC_SCR,VCS_PAG	;Clear screen
	DB	CR,LF,CR,LF
	DB	VC_SAT,EXP VCA_HLT+EXP VCA_REV
	DB	"System default sub-commands"
	DB	VC_CAT,EXP VCA_HLT+EXP VCA_REV
	DB	CR,LF
	DB	VC_WIN,VCW_MENB
	DW	(EXP BKB_SWN+EXP BKB_RET+EXP BKB_ESC) LSH -16

	DB	"Cursor size (0-20): "
	DB	VC_WIN,VCW_MINP
	DW (EXP BKB_DFT+EXP BKB_RET+EXP BKB_ESC+EXP BKB_EDT+EXP BKB_EKO) LSH -16
	DD	0		;Default R5
	DB	1		;Default input length
	DB	2		;Max input length
	DB	"3 "		;Default input

	DB	VC_WIN,VCW_MENE,0
	DB	VC_IGN

SYS_EXE:
	SAVE	[R0,R1]
	ADDR	T_SYSEXX-1,R1	;Item index in R4
	MOVZBD	T_SYSEXX-T_SYSEX,R0
	SKPSB	B,U
	MOVD	R0,R3
	RESTORE	[R0,R1]
SYS_EX1:
	CASEW	T_SYSEXX[R3:W]

T_SYSEX:
	DB	0		;Cursor size
T_SYSEXX:
	DW	RETRN-SYS_EX1
	DW	SYS_CSR-SYS_EX1

SYS_CSR:
	MOVL	(R1),TOS	;Space for returned value
	MOVZBW	10,TOS		;Radix, space for type
	BSR	DIG_CNVT:D
	CMPQB	2,1(SP)		;Error if not this
	IF	EQ
	 CMPD	20,2(SP)
	 IF	HS
	  SAVE	[R5]
	  MOVZBD 2+4(SP),R5	;Cursor size
	  ORD	DC_CRSR,R5
	  MOVD	DOF_CMD+DEV_SMV LSH b_iosrv,R6
	  MAC_2SVC
	  RESTORE [R5]
	 ENDIF
	ENDIF
	ADJSPB	-10
	CMPB	CR,R5		;Exit with EQ set if CR
	RET

;End of MNU32.MAC
