.oc on
 
 	z
z
 
 The Command Line
 oc off
 tc The Command Line  ......................... #
    " p mDEp mD 
 he command line prompt is a ">" character preceded by the selected radix.  A 
 ingle hex digit (2-F) indicates a radix of 2-15 and "H" designates hexadecimal.  
 ex is the default following a reset.  The command line itself may contain up to 
 20 characters, including the final carriage return.  Line feeds are optional and 
 ase is ignored except in quoted strings, but bit 7 of each character should 
 lways be 0.  The radix may be changed with the {I}mmediate command and the 
 RADIX pseudo-op explained in the assembler section.  The command line may be 
 dited with the right and left arrow keys and the delete key.  Characters are 
 utomatically inserted anywhere in the command line.
 
The    p hD" p mD |   p mDR p hD  character separates multiple commands on a single line.  A space displays 
 efore the next command begins.     p hD" p mD ||   p mDR p hD  also separates multiple commands but sends 
  CR between commands.  These delimiters don't work following a {G}o or 
 I}mmediate command.  They are most useful with breakpoint or trace command 
 ines.
 
Command line entry takes place in window 1 if it is defined with the {W}indow 
 ommand.  Command entry and editing then preserves continuous displays 
 lsewhere on the screen.  Any window (including window 1) may be selected for 
 isplay.  
 
Just pressing <RETURN> at the command prompt repeats the last command with 
 efaults used for all parameters.  This is especially useful with the {D}isplay, 
 L}ist and {T}race commands.  The {G}o, and {P}ort commands are not repeatable 
 n this way since these commands could have some rather nasty consequences if a 
 tray <RETURN> appears by accident.
 
.ix Error message
 ???" indicates an invalid command or parameter.  A specific error message may 
 lso display.
 
 Ep mD" p mD 
 oc on
 
 	NN 
 Reserved Characters
 oc off
 tc Reserved Characters  ...................... #
    " p mDEp mD 
 everal reserved characters have special delimiter functions.  These characters 
 ust not be used within symbol names but they may be used as operands when 
 nclosed in quotes.  The delimiter characters form a hierarchy.  Line delimiters 
 lso terminate an expression or operand; expression delimiters also terminate an 
 perand.
 ix Delimiter character
 
.lm 0.35"
 pm 0.35"
 
 	vv 
 File delimiters are    p hD" p mD ^D ^Z   p mDR p hD 
 
 	vv 
 Line delimiters are CR    p hD" p mD ; | { }   p mDR p hD 
 
 	vv 
 Expression delimiters are    p hD" p mD ( ) , : = [ ]   p mDR p hD 
 
 	vv 
 Operand delimiters are tab space    p hD" p mD ! * + - / < >   p mDR p hD 
 
 	vv 
 String operators are    p hD" p mD & ^ % $   p mDR p hD 
 lm 0"
 pm 0."
 pa  _	0   o5                     
  Ep mD" p mD 
 oc on
 
 	 
 Parameter Evaluation
 oc off
 tc Parameter Evaluation  ..................... #
    " p mDEp mD 
 Command parameters may be expressions using numeric values (integer or floating 
 oint), math operators, strings, symbols, registers, or addressing modes.  
 Expression evaluation defaults to algebraic but may be set to RPN with the RPN 
 seudo-op.  Use the {C}alculate command to experiment with expression evaluation.
 
If using local symbols within (FP) blocks (the default condition explained in the 
 LPROC, XPROC and PROC pseudo-ops section) only symbols from the most recent 
 FP) block listed may be calculated; if an undefined symbol error displays when 
 sing locally defined FP relative symbols, list that (FP) block and try again.
 
.ix Device parameter
 ome commands accept a virtual device name as one of the parameters.     p hD" p mD SER1   p mDR p hD  
 nd   R p hD" p mD SER2  " p mDR p hD  are the serial ports, while    p hD" p mD PRTR   p mDR p hD  is the printer or parallel port.  The 
 evice name my be followed by an   R p hD" p mD A  " p mDR p hD  or   R p hD" p mD B  " p mDR p hD  to select ASCII or binary transfers, 
 .g.   R p hD" p mD SER1A  " p mDR p hD  or   R p hD" p mD PRTRB  " p mDR p hD .  When ASCII mode is selected, incoming files must end 
 ith a ^D (ASCII EOT).  The serial ports automatically use XMODEM for binary 
 ransfers, while the parallel port uses hardware control lines; file transfer 
 ontinues until the status line changes state.
 
.ix Linker files
 ix Object code
 ix Program listings
 he specific routing for each virtual device may be selected with the {J}oin 
 ommand, and the operating system may do additional re-routing if no 
 orresponding physical device exists.     p hD" p mD PRTR   p mDR p hD  is {J}oined by default to the serial 
 ort.  Program listings automatically display via the virtual PRTR device.  
 ssembler object file output automatically sets the selected device for binary 
 ransfers.
 pa     o5                     
 
Numbers use the current default radix unless specified otherwise.  A digit larger 
 han the default radix automatically adjusts the radix.  Hexadecimal numbers may 
 e specified by a leading    p hD" p mD H'   p mDR p hD  or    p hD" p mD X'   p mDR p hD  or    p hD" p mD 0x   p mDR p hD ; or a trailing    p hD" p mD H   p mDR p hD , e.g.    p hD" p mD H'1234   p mDR p hD , 
    p hD" p mD 0x1234   p mDR p hD , or    p hD" p mD 1234H   p mDR p hD .  Decimal numbers may be specified by a leading    p hD" p mD D'   p mDR p hD , octal 
 umbers by a leading    p hD" p mD O'   p mDR p hD  or    p hD" p mD Q'   p mDR p hD .  Binary numbers may be specified either by a 
 eading    p hD" p mD B'   p mDR p hD  or a trailing    p hD" p mD B   p mDR p hD .  The trailing    p hD" p mD B   p mDR p hD  works only when the default radix is 
 ecimal and the largest digit is 1.  Floating values must include a decimal point 
 nd at least one digit on each side of the decimal point.  An optional signed 
 xponent may be specified by a trailing E, e.g.    p hD" p mD 1.23E-12   p mDR p hD .  
 
Integers may be 8, 16 or 32 bits.  Byte values must be between -H'80 and H'FF 
 nclusive.  Word values must be between -H'8000 and H'FFFF inclusive.
 
All register names displayed by the {R}egister command are allowed in 
 xpressions.  Register names evaluate to 32 bit signed integers unless specified 
 therwise.
 
Addressing modes evaluate as effective addresses (the same value obtained with 
 he ADDR opcode); the base register value is added to the displacement(s).  TOS 
 nd (SP) values depend on the setting of the stack flag in the PSR.  Addressing 
 odes evaluate to signed, 32 bit integers unless specified otherwise.
 
 Ep mD" p mD 
 oc on
 
 	ZZ 
 Math Operators
 oc off
 ix Math operator
    " p mDEp mD 
 he following operators require only a single operand.
 
.lm 0.35"
 pm 0.35"
 
 	vv 
    p hD" p mD LEN   p mDR p hD  returns the length of a string in bytes.
 

 	vv 
    p hD" p mD ABS   p mDR p hD  returns the absolute value of a floating point or integer operand.
 

 	vv 
    p hD" p mD NEG   p mDR p hD  negates a floating point or integer operand.
 

 	vv 
    p hD" p mD NOT   p mDR p hD  complements bit 0 of an integer.
 

 	vv 
    p hD" p mD EXP   p mDR p hD  raises 2 to a power (2En) which must be 0-31.     p hD" p mD EXP3   p mDR p hD  = 8.
 

 	vv 
    p hD" p mD LOG   p mDR p hD  returns the base two log of the most significant bit of the operand.  
 
 	vv 
    p hD" p mD LOG8   p mDR p hD  = 3.    p hD" p mD LOG 0   p mDR p hD  = -1.
 

 	vv 
    p hD" p mD COM   p mDR p hD  complements an integer.
 lm 0"
 pm 0"
 
   p hD" p mD ASH, ROT, LSH   p mDR p hD  function the same as their counterparts in the 32000 
 nstruction set.  Negative counts shift or rotate right while positive counts shift 
 eft.  In algebraic notation, the value to the left of the operator shifts or rotates 
 y the count to the right of the operator.  In RPN notation, the 2nd value on the 
 tack shifts or rotates by the count on top of the stack.     p hD" p mD 4LSH2   p mDR p hD  evaluates to 
 '10.
 
Arithmetic operators are    p hD" p mD MOD, +, -, *, /   p mDR p hD .  All except MOD also work with 
 loating values.
 
   p hD" p mD XOR, AND, OR   p mDR p hD  perform the expected logical operation.
 
Comparison operators are the same as their counterparts in the 32000 instruction 
 et and return a boolean result.  Only bit 0 is significant.  A true comparison   o 9   o5                     
 eturns 1 while a false comparison returns 0.  GT is true if the 2nd stack entry 
 s greater than the top stack entry.  Comparison operators work with integers, 
 loating values and strings.  Supported operators are    p hD" p mD GT, LT, GE, LE, HI, 
 O, HS, LS, EQ, NE   p mDR p hD .     p hD" p mD 2GT1   p mDR p hD  evaluates to 1.     p hD" p mD 5LS3   p mDR p hD evaluatesto0.
 
RPN operators treat the 1st value on the stack (the last valued pushed) as the 
 ource operand while the second value is the destination operand.    p hD" p mD 6 3 /   p mDR p hD  leaves 
  on the stack.  Special RPN stack operators are similar to those available in 
 orth.
 
.lm 0.35"
 pm 0.35"
 
 	vv 
    p hD" p mD SWAP   p mDR p hD  swaps the two top stack entries.
 

 	vv 
    p hD" p mD PICK   p mDR p hD  replaces the top stack entry (N) with the Nth stack entry.  The top 
 
 	vv 
 entry after the index is the zeroth entry.    p hD" p mD 0PICK   p mDR p hD  is identical to    p hD" p mD DUP   p mDR p hD  while 
 
 	vv 
    p hD" p mD 1PICK   p mDR p hD  functions like the Forth OVER operator.
 

 	vv 
    p hD" p mD DROP   p mDR p hD  removes the top stack entry.
 

 	vv 
    p hD" p mD DUP   p mDR p hD  copies the top stack entry.
 lm 0"
 pm 0"
 
 Ep mD" p mD 
 oc on
 
 	 	
 Priority among math operators
 oc off
 ix Priority among math operators
    " p mDEp mD 
 lgebraic notation uses seven priority levels among math operators.  Within a 
 riority level, operators are processed left to right.  The levels given here begin 
 ith the highest priority (those evaluated first).  Priorities may be rearranged 
 ith parentheses.  Expressions may start with parentheses unless the contents of 
 he parentheses constitutes a valid addressing mode.  (1+2+3)/2 evaluates as 3, an 
 mmediate operand, but if LABL is an SB relative symbol then (LABL+1) is 
 quivalent to 0(LABL+1(SB)).
 cp16
 
Priority levels
    p hD" p mD 
 LEN ABS NEG NOT EXP LOG COM
 
ROT LSH ASH
 
MOD * /
 
+ -
 
XOR OR AND
    p mDR p hD 
 Comparisons (   p hD" p mD GT, HS   p mDR p hD , etc.)
    p hD" p mD 
 SWAP PICK DROP DUP
    p mDR p hD 
 
Anything that is not a math operator or one of the following special expression 
 perators is assumed to be a symbol.
 
.lm 0.35"
 pm 0.35"
 
 	vv 
 A leading    p hD" p mD -   p mDR p hD  negates the following expression.
 

 	vv 
 The current mode pointer (see the MODE pseudo-op in the assembler section) 
 
 	vv 
 may be indicated by one of four different symbols:    p hD" p mD * ` . $   p mDR p hD .     p hD" p mD `   p mDR p hD  is the 
 
 	vv 
 safest since it can never be misinterpreted as something else, but the others 
 
 	vv 
 are provided for compatibility with other assemblers.     p hD" p mD *   p mDR p hD  may not be used   o 9   o5                     
 
 	vv 
 with RPN expression evaluation enabled.  The    p hD" p mD $   p mDR p hD  character must be followed by 
 
 	vv 
 an operand delimiter if it is to be correctly evaluated as the current mode 
 
 	vv 
 pointer rather than as a string designator.
 

 	vv 
 Quoted characters (single or double quotes) evaluate in one of two ways 
 
 	vv 
 depending on the context.  Fewer than five characters evaluate to an integer.  
 
 	vv 
 Five or more characters, e.g.    p hD" p mD "This is a string"   p mDR p hD , evaluate to a 
 
 	vv 
 character string.
 

 	vv 
    p hD" p mD S'   p mDR p hD  is a special designator indicating a string of comma separated values.  
 
 	vv 
 Each individual value may be a byte, word, Dword, float, long, or another 
 
 	vv 
 string e.g.    p hD" p mD S'9,"Texthere",13,10   p mDR p hD .  The maximum length is 40 
 
 	vv 
 bytes.
 lm 0"
 pm 0"
 
The symbols used in an expression determine a default addressing mode.  Numbers 
 efault to immediate mode unless specified otherwise.  Forward references default 
 o PC relative unless specified otherwise.
 
.cp2
 lm 0.35"
 pm 0.35"
 
 	vv 
 A math operation between an integer and a floating value defaults to a 
 
 	vv 
 floating value.
 

 	vv 
 A math operation between two values with the same addressing mode defaults 
 
 	vv 
 to an immediate mode value.  This allows offsets to be calculated symbolically 
 
 	vv 
 without specifying the addressing mode.  If TABL_BEG is the beginning 
 
 	vv 
 address of a table and TABL_END is the next address after the table, the 
 
 	vv 
 expression TABL_END-TABL_BEG calculates the size of the table as an 
 
 	vv 
 immediate mode operand.
 

 	vv 
 Math operations between an immediate mode value and a non-immediate mode 
 
 	vv 
 value default to the mode of the non-immediate mode value.  This allows 
 
 	vv 
 displacements to be used easily.  If LABL is an SB relative symbol, the 
 
 	vv 
 expression LABL+1 defaults to LABL+1(SB).
 
.cp3
 
 	vv 
 The default mode of a math operation on two different, non-immediate 
 
 	vv 
 addressing modes is unpredictable.
 lm 0"
 pm 0"
 
 Ep mD" p mD 
 oc on
 
 	^^ 
 Parameter designators
 oc off
 ix Parameter designator
    " p mDEp mD 
 pecial designators can specify the addressing mode, type or size of a parameter 
 f incorrect or ambiguous.  A colon and one or more designators may follow any 
 arameter without intervening spaces.   Multiple designators evaluate left to 
 ight.
 
 Ep mD" p mD 
 oc on
 
 	FF 
 Integer designators
 oc off
 ix Integer designator
    " p mDEp mD 
 lm 0.35"
 pm 0.35"
 
 	vv 
    p hD" p mD B   p mDR p hD  specifies a byte value.
 

 	vv 
    p hD" p mD W   p mDR p hD  specifies a word value.
 

 	vv 
    p hD" p mD D   p mDR p hD  specifies a double word value.
 

 	vv 
    p hD" p mD F   p mDR p hD  specifies a float.
 

 	vv 
    p hD" p mD L   p mDR p hD  specifies a long.
   o 9   o5                     
 
 	vv 
    p hD" p mD S   p mDR p hD  sign extends a byte or word integer to a 32 bit integer and should follow a 
 
 	vv 
    p hD" p mD B   p mDR p hD  or    p hD" p mD W   p mDR p hD .
 

 	vv 
    p hD" p mD Z   p mDR p hD  zero extends a byte or word integer to a 32 bit integer and should follow a 
 
 	vv 
    p hD" p mD B   p mDR p hD  or    p hD" p mD W   p mDR p hD .
 lm 0"
 pm 0"
 
Integer designators following a displacement set the size in bytes of that 
 isplacement.  Integer designators following an integer sign extend the integer.  
 nteger designators following a floating value convert the floating value to an 
 nteger.  Floating point designators following an integer convert the integer to a 
 loating value.
 
   p hD" p mD BSR SUBRT:B   p mDR p hD  specifies a byte displacement.
 
   p hD" p mD H'FFFF:BZ   p mDR p hD  evaluates as H'FF
 
 Ep mD" p mD 
 oc on
 
 	.. 
 Mode designators
 oc off
 ix Mode designator
    " p mDEp mD 
  complete addressing mode can specify SB, FP, or SP addressing mode, e.g. 
 ABEL(SB).  Other modes may use any of the following designators.
 
.lm 0.35"
 pm 0.35"
 
 	vv 
    p hD" p mD (SB)   p mDR p hD  specifies SB mode.  It must immediately follow the colon.
 

 	vv 
    p hD" p mD (FP)   p mDR p hD  specifies FP mode.  It must immediately follow the colon.
 

 	vv 
    p hD" p mD (SP)   p mDR p hD  specifies SP mode.  It must immediately follow the colon.
 

 	vv 
    p hD" p mD #   p mDR p hD  specifies an immediate mode integer value.
 

 	vv 
    p hD" p mD @   p mDR p hD  specifies absolute addressing mode.
 

 	vv 
    p hD" p mD *   p mDR p hD  specifies program memory relative mode
 

 	vv 
    p hD" p mD X   p mDR p hD  specifies external addressing mode.
 lm 0"
 pm 0"
 

   p hD" p mD MOVDLABEL:(SB),R0   p mDR p hD  treats LABEL as an SB relative symbol, regardless of 
 ow it was originally defined.     p hD" p mD MOVDLABEL:X,R0   p mDR p hD  is equivalent to 
    p hD" p mD MOVDEXT(LABEL)+0,R0   p mDR p hD .  Addressing mode and integer designators may be 
 ombined:     p hD" p mD MOVBLABL:B*,R0   p mDR p hD .
 pa  *   o5                     
  Ep mD" p mD 
 oc on
 
 	

 
 Debugger Commands
 oc off
 tc Debugger Commands  ........................ #
 ix Debugger command
    " p mDEp mD 
 ommands consist of one character and additional options or parameters as 
 ppropriate.  Multiple parameters must be separated by commas.  Defaults often 
 eplace unspecified parameters.  The {L}ist and {D}isplay commands work in this 
 ay.  The address defaults to the last address + 1, and the count and mode 
 emain unchanged.  Optional parameters may be left blank or indicated by commas.  
 he command    p hD" p mD D ,20   p mDR p hD  {d}isplays from the current default address (the first 
 arameter) with a new byte count of 20 (the second parameter); the comma 
 pecifies a default address parameter.  In the following command descriptions, 
 urly braces enclose each parameter.  Some commands, such as {D}isplay and 
 E}dit, accept size parameters indicated by {i} in the command description.  The 
 i} parameter must immediately follow the command letter; spaces are not allowed.  
 f not specified, the {i} parameter defaults to the last value used.
 
.lm 0.35"
 pm 0"
 ix Menu
    p hD" p mD ?   p mDR p hD  displays a command summary which may be printed or stored on disk for on-
 
 	vv 
 line reference.
 
.ix Assemble command
 ix Program listing
    p hD" p mD A   p mDR p hD  ({A}ssemble) can read source code line by line directly from a port, or assemble 
 
 	vv 
 source code already resident in memory.     p hD" p mD AL   p mDR p hD  assembles and lists to the 
 
 	vv 
 currently assigned PRTR device on the second pass.     p hD" p mD A2   p mDR p hD  forces a two pass 
 
 	vv 
 assembly but doesn't list anything.     p hD" p mD AC   p mDR p hD  produces a cross reference listing on 
 
 	vv 
 the second pass.     p hD" p mD AX   p mDR p hD  resets the assembler and linker and clears the symbol 
 
 	vv 
 table.     p hD" p mD A   p mDR p hD , the normal command does a single pass assembly for maximum 
 
 	vv 
 speed.  The complete command is {   p hD" p mD A   p mDR p hD  or    p hD" p mD AL   p mDR p hD  or    p hD" p mD A2   p mDR p hD  or    p hD" p mD AC   p mDR p hD } {source code 
 
 	vv 
 address or device name}, {object code address}, {module table address or 
 
 	vv 
 device name}.  When the module address is a device name, a linker file is 
 
 	vv 
 written to the selected port rather than building an executable file in 
 
 	vv 
 memory.  The object code address is still required as an intermediate buffer 
 
 	vv 
 for building the file.     p hD" p mD AC100,1000,2000   p mDR p hD  assembles source code already 
 
 	vv 
 loaded at address 100, puts the object code at address 1000 and builds a 
 
 	vv 
 module table at 2000.  The PRTR device displays the cross reference listing.  
 
 	vv 
   R p hD" p mD ASER1,2000,SER1   p mDR p hD  does a single pass assembly by reading source code 
 
 	vv 
 directly from the main serial port, and uses address 2000 as a working 
 
 	vv 
 buffer.  No listing follows, but the SER1 device receives the linker file as a 
 
 	vv 
 binary file transfer.
 
.pm 0.35"
 
 	vv 
 Once the assembly is complete, the next available address displays.  If no 
 
 	vv 
 module table address was specified, the module table must be setup manually.  
 
 	vv 
 The SB base field of the module table is automatically loaded from the SB 
 
 	vv 
 register before execution, but the link base and program base fields must be 
 
 	vv 
 initialized.  Assuming that the MOD register has already been set, just use 
 
 	vv 
 the command:    p hD" p mD EDMOD   p mDR p hD .
 
.ix Keyboard assembly
 pm 0"
    p hD" p mD AI   p mDR p hD  {address} does an immediate assembly into memory from keyboard input.  After 
 
 	vv 
 a regular assembly, any new code created with AI is treated as part of the 
 
 	vv 
 current module: The existing symbol table is used and any new symbols are 
 
 	vv 
 added which allows making patches, writing condition test routines for 
 
 	vv 
 breakpoint or trace traps, or just experimenting with the assembler.  All 
 
 	vv 
 features of the assembler may be used but the linker is not accessible.  Up 
 
 	vv 
 to 20 bytes of object code are displayed as each line is entered.  Forward 
 
 	vv 
 references are properly resolved, but displayed object code may contain 
 
 	vv 
 garbage until assembly is terminated by just pressing <RETURN> at the 
 
 	vv 
 beginning of a line.  An "A" precedes the prompt while assembling to remind 
 
 	vv 
 you that everything you say can and will be held against you by the 
 
 	vv 
 assembler.  As with the regular assembler, anything in the first column   o 9   o5                     
 
 	vv 
 (immediately following the prompt) is assumed to be a symbol.  There is no 
 
 	vv 
 way to correct errors other than starting over.
 
.pm 0.35"
 
 	vv 
 Since    p hD" p mD AI   p mDR p hD  assemblies are automatically linked through the symbol table with 
 
 	vv 
 the last module assembled, care must be taken with relative branches.  PC 
 
 	vv 
 relative symbols are assigned values relative to the beginning of the last 
 
 	vv 
 module assembled, or 0 after a reset.  If the last program assembled starting 
 
 	vv 
 at address H'4000, a PC relative symbol of H'100 has an effective address of 
 
 	vv 
 H'4100.  When assembling at absolute address H'110, the opcode    p hD" p mD BRH'100   p mDR p hD  
 
 	vv 
 branches ahead H'3FF0 bytes and not backwards H'10 bytes as was probably 
 
 	vv 
 intended.  Use symbols or an offset as the destination of relative branches or 
 
 	vv 
 subroutine calls unless you really know what you are doing.
 
.ix Breakpoint command
 pm 0"
    p hD" p mD B   p mDR p hD  ({B}reakpoint) sets or displays breakpoints.     p hD" p mD BX   p mDR p hD  clears all breakpoints.     p hD" p mD B   p mDR p hD  
 
 	vv 
 displays all breakpoints.     p hD" p mD B   p mDR p hD {breakpoint number (0-F)} displays just that 
 
 	vv 
 breakpoint.  Note that spaces are not allowed between the    p hD" p mD B   p mDR p hD  and the 
 
 	vv 
 breakpoint number which must be a single hex digit.  To set a breakpoint, 
 
 	vv 
 use the command:    p hD" p mD B   p mDR p hD {breakpoint number (0-F)}    p hD" p mD =   p mDR p hD  {address}, {count 
 
 	vv 
 (0=breakpoint disabled)}, {address of condition test (0=none)}, {command to 
 
 	vv 
 execute when the break trap is taken}.  The count defaults to one if not 
 
 	vv 
 specified, but may be any integer.  A count of zero disables that breakpoint.  
 
 	vv 
 When a breakpoint trap is taken:
 
.lm 7
 pm 7
 
 	88 
 The count is decremented if more than 1.  If the adjusted count is 1, 
 
 	88 
 program execution terminates and control returns to the debugger.
 

 	88 
 If the count has not expired the condition test address is checked.  If the 
 
 	88 
 address is 0, program execution terminates and control returns to the 
 
 	88 
 debugger.
 

 	88 
 If the condition test routine address is not 0, the subroutine is called.  
 
 	88 
 The condition test subroutine returns a condition flag in the double word 
 
 	88 
 in 4(SP).  If this returned condition flag is non-zero, execution terminates 
 
 	88 
 and control returns to the debugger.
 

 	88 
 If the returned condition flag was 0, program execution continues until the 
 
 	88 
 next trap.
 
.lm 0.35"
 pm 0.35"
 
 	vv 
 When a break trap is taken, the break number displays if one of the 16 
 
 	vv 
 permanent breakpoints caused the break.  The next instruction to execute is 
 
 	vv 
 listed and the default list address is set to the address of the next 
 
 	vv 
 instruction.     p hD" p mD B1=1000,-1,100   p mDR p hD  sets a breakpoint at address 1000.  The 
 
 	vv 
 count is H'FFFFFFFF which essentially allows a break only when the condition 
 
 	vv 
 test routine at address 100 returns a non-zero value in 4(SP).
 

 	vv 
 The breakpoint command line (if not null) executes whenever the break trap 
 
 	vv 
 is actually taken and may contain any valid debugger commands.  The length 
 
 	vv 
 of the command may not exceed 120 characters including the final carriage 
 
 	vv 
 return.  Multiple commands may be separated by    p hD" p mD |   p mDR p hD  or    p hD" p mD ||   p mDR p hD .  A watchpoint may 
 
 	vv 
 be easily defined using breakpoint options.  A multiple command line could 
 
 	vv 
 select a display window, display several memory addresses, select another 
 
 	vv 
 window, display some registers and resume execution.  The E{x}it command 
 
 	vv 
 lets you regain control at any time, or just pace the action.  
 
 	vv 
    p hD" p mD B2=1000,1,0,W2|R1|W3|R2|X|G   p mDR p hD  sets a breakpoint at address 1000.  
 
 	vv 
 Since the count is one and no condition test is specified,  the breakpoint is 
 
 	vv 
 always taken.  Once the break occurs, R1 displays in window 2 and R2 
 
 	vv 
 displays in window 3.  The E{x}it command waits for a keypress and either   o 9   o5                     
 
 	vv 
 continues with the rest of the command line (the {G}o command), or terminates 
 
 	vv 
 and returns to the monitor command prompt.
 

 	vv 
 Breakpoint parameters default to the current settings until something else is 
 
 	vv 
 specified.  To clear the command line, enter a trailing comma in the 
 
 	vv 
 appropriate position with no text following.  The comma in the command line 
 
 	vv 
 position indicates that whatever follows the comma is to be taken as the new 
 
 	vv 
 command line; if there is no text, the command line is cleared.  Without the 
 
 	vv 
 trailing comma, the current command line remains as the default.  A 
 
 	vv 
 breakpoint may be disabled by changing the break count to 0.  The command 
 
 	vv 
    p hD" p mD B0=,0   p mDR p hD  sets the count of breakpoint 0 to 0 while leaving all other parameters 
 
 	vv 
 unchanged.  The command    p hD" p mD B0=,1   p mDR p hD  re-enables breakpoint 0.  Set the condition 
 
 	vv 
 test address to 0 to disable it.
 

 	vv 
 The breakpoint condition test routine is essentially a subroutine called from 
 
 	vv 
 the address of the breakpoint before execution of the instruction at that 
 
 	vv 
 address.  The first Dword on the stack is the return address and the second 
 
 	vv 
 Dword is 0, the pre-initialized condition flag.  Otherwise, the stack is 
 
 	vv 
 unaltered.  If the break trap is not taken, the opcode at the breakpoint 
 
 	vv 
 executes next.  The condition test routine:
 lm 0"
 pm 0"
   R p hD" p mD 
 CMPD	R2,H'100
 SEQB	4(SP)
 RET
   4 p mDR p hD 
 lm .35"
 pm .35"
 
 	vv 
 breaks only if R2 is H'100.
 
.ix Opcode insertion
 
 	vv 
 The condition test routine may be traced and the break trap will be taken if 
 
 	vv 
 a non-zero value is returned in 4(SP).  Leaving the condition flag set to 0 
 
 	vv 
 essentially inserts opcodes at the breakpoint address.  Before manipulating 
 
 	vv 
 the stack, consider the breakpoint test's return address and condition flag.  
 
 	vv 
 With a hardware timer such as a 32202, elapsed time may be calculated for 
 
 	vv 
 any part of a program simply by saving the current count at the start of a 
 
 	vv 
 program routine, and then computing elapsed time and updating a running 
 
 	vv 
 subtotal at the end of the routine.  This value may be compared to the total 
 
 	vv 
 elapsed time for the entire program which can help identify bottlenecks.  All 
 
 	vv 
 registers are passed to the condition test just as the program set them and 
 
 	vv 
 any registers changed by the condition test are returned as is. This allows 
 
 	vv 
 easy patching during debugging.
 
.pm 0"
   R p hD" p mD BM =   p mDR p hD  {address}, {count (only on 32082)}, {condition} is a special command available 
 
 	vv 
 only on 32532, 32GX32 or 320xx/32082 based systems.  It activates the MMU 
 
 	vv 
 breakpoint register.  The condition must be R to break on memory read, W to 
 
 	vv 
 break on memory write, or X to cancel the breakpoint.  Note that no command 
 
 	vv 
 line is allowed with this option.  BPR1 of a 32082 may be set with the BM 
 
 	vv 
 command, followed by   R p hD" p mD RBPR1=BPR0   p mDR p hD  to copy BPR0 to BPR1, and a second BM 
 
 	vv 
 command.
 
.ix Calculate command
   R p hD" p mD C   p mDR p hD  ({C}alculate) calculates the result of any expression with the command:   R p hD" p mD C   p mDR p hD  
 
 	vv 
 {expression}.    R p hD" p mD CD   p mDR p hD  sets the radix temporarily to decimal for evaluation and 
 
 	vv 
 display,   R p hD" p mD CH   p mDR p hD  sets the radix to hexadecimal,   R p hD" p mD CB   p mDR p hD  set the radix to binary.  These 
 
 	vv 
 options may convert from one base to another, e.g.   R p hD" p mD CDH'100   p mDR p hD  displays 256. 
 
 	vv 
   R p hD" p mD CA   p mDR p hD  displays the result in ASCII.  The   R p hD" p mD C   p mDR p hD  command provides the only way to 
 
 	vv 
 display FPU registers as floating values.    R p hD" p mD CF0   p mDR p hD  displays a float, while  
 
 	vv 
   R p hD" p mD CF0:L   p mDR p hD  displays the F0/F1 register pair as a long.
 
.cp 3  o 9   o5                     
 ix Label search
   R p hD" p mD CL   p mDR p hD  finds the closest label less than or equal to the expression.  The addressing 
 
 	vv 
 mode of the symbol always matches the addressing mode of the expression.  
 
 	vv 
 The default is PC relative.
 
.ix Display command
 ix Memory display
   R p hD" p mD D   p mDR p hD {i} ({D}isplay) displays memory in bytes, words, Dwords, floats (i=F), longs (i=L) 
 
 	vv 
 or ASCII (i=A).  The   R p hD" p mD DB, DW, DD, DF, DL   p mDR p hD  commands display 16 bytes per 
 
 	vv 
 line, while the   R p hD" p mD DA   p mDR p hD  command displays 32 ASCII characters per line.  The   R p hD" p mD DB, 
 
 	vv 
 DW, DD   p mDR p hD  commands also display the ASCII equivalents.  The complete command 
 
 	vv 
 is   R p hD" p mD D   p mDR p hD {i} {starting address}, {number of bytes}.    R p hD" p mD DW   p mDR p hD  and   R p hD" p mD DD   p mDR p hD  display the most 
 
 	vv 
 significant byte first.  At the completion of the display, the default address 
 
 	vv 
 is set to the next address.    R p hD" p mD DW1000,20   p mDR p hD  displays 10 words (20 bytes) 
 
 	vv 
 starting at address 1000.  The default byte count is 40.
 
.ix Edit command
 ix Memory change
   R p hD" p mD E   p mDR p hD {i} ({E}dit) edits bytes, words, or Dwords in memory.  There are two forms of 
 
 	vv 
 the {E}dit command:   R p hD" p mD E   p mDR p hD {i} {starting address} begins a continuous edit from the 
 
 	vv 
 starting address.  The address displays with the current contents in diagonal 
 
 	vv 
 brackets.  Entering a new value automatically increments the address.  Press 
 
 	vv 
 <RETURN> at the beginning of the line to end the edit, or press <space> and 
 
 	vv 
 then <RETURN> to leave the current value unchanged and advance to the next 
 
 	vv 
 address.   The command   R p hD" p mD E   p mDR p hD {i} {address}   R p hD" p mD =   p mDR p hD  {new value} changes the contents of 
 
 	vv 
 a single address.  The {i} parameter must be specified with each {E}dit 
 
 	vv 
 command.    R p hD" p mD EB1000   p mDR p hD  begins editing bytes at address 1000 and automatically 
 
 	vv 
 advances to the next address until <RETURN> is pressed at the beginning of 
 
 	vv 
 a line.    R p hD" p mD EB1000=10   p mDR p hD  changes address 1000 to 10.  The new value may also be 
 
 	vv 
 a string:   R p hD" p mD EB100="Thisis easy"   p mDR p hD .
 
.ix Fill memory command
   R p hD" p mD F   p mDR p hD  ({F}ill) fills memory with a byte value.    R p hD" p mD F   p mDR p hD  {starting address}, {count in bytes}, 
 
 	vv 
 {byte value to fill with}.  Use the {I}mmediate command with MOVSW or MOVSD 
 
 	vv 
 for word or Dword fills.    R p hD" p mD F1000,20,5   p mDR p hD  fills addresses 1000-101F with 5.
 
.ix Go command
 ix Execute
   R p hD" p mD G   p mDR p hD  ({G}o) executes from the current PC address.  There are two forms of the {G}o 
 
 	vv 
 command.    R p hD" p mD GS   p mDR p hD  sets a temporary breakpoint at the address immediately 
 
 	vv 
 following the current instruction and then executes.  This is especially useful 
 
 	vv 
 for subroutine calls although it can be used with any opcode other than a 
 
 	vv 
 branch or jump.    R p hD" p mD G   p mDR p hD  {breakpoint #1}, {breakpoint #2} sets optional temporary 
 
 	vv 
 breakpoints which are cleared when any trap is taken.
 
.ix Hex file command
 ix Intel hex file
   R p hD" p mD H   p mDR p hD  ({H}ex) processes an Intel hex file.    R p hD" p mD HI   p mDR p hD  {source address of hex file in memory 
 
 	vv 
 or device name}, {destination address of object code} converts a hex file to 
 
 	vv 
 actual object code.  The address field of each line is added to the specified 
 
 	vv 
 destination address to get the address in memory for the resulting object 
 
 	vv 
 code.  File processing is terminated by a byte count of 0.  Checksums are 
 
 	vv 
 verified and errors are reported.    R p hD" p mD HO   p mDR p hD  {starting address}, {last address}, 
 
 	vv 
 {device name} outputs a hex file.    R p hD" p mD HISER1,1000   p mDR p hD  reads a file from the 
 
 	vv 
 serial port and places the object code at address 1000.  
 
 	vv 
   R p hD" p mD HO1000,1FFF,SER1   p mDR p hD  writes a hex file to the serial port starting at 1000 
 
 	vv 
 up to and including 1FFF.
 
.pm 0.35"
 
 	vv 
 The   R p hD" p mD HI   p mDR p hD  command can also process a file created with National Semiconductor's 
 
 	vv 
 TDS monitor.  The format for these files is a ">" followed by exactly 32 ASCII 
 
 	vv 
 hex digits (16 bytes of object code, CR and optional LF.  The file is 
 
 	vv 
 terminated by a "<" at the start of a line.  No address information or 
 
 	vv 
 checksums are included with this format.
 
.ix Immediate execution command
 pm 0"
   R p hD" p mD I   p mDR p hD  ({I}mmediate) executes any assembler command or opcode except macros.    R p hD" p mD I   p mDR p hD  
 
 	vv 
 {opcode or pseudo-op} provides a flexible way to edit memory, set the radix 
 
 	vv 
 for expression evaluation, alter registers, call subroutines, adjust the stack,   o 9   o5                     
 
 	vv 
 set the CPU config register (  R p hD" p mD ISETCFG[F,I]   p mDR p hD ) or anything else you can 
 
 	vv 
 think of.  All registers are restored before actually executing the opcode and 
 
 	vv 
 the register display is updated according to any changes made.  Remember 
 
 	vv 
 that the user flag in the PSR must be set appropriately if an opcode is only 
 
 	vv 
 allowed in supervisor mode.  As with the assembler, anything in the first 
 
 	vv 
 column (immediately following the   R p hD" p mD I   p mDR p hD  command) is assumed to be a symbol and 
 
 	vv 
 added to the current symbol table.  This command does not access the linker, 
 
 	vv 
 so external references are not allowed.  If an {I}mmediate command encounters 
 
 	vv 
 a breakpoint during execution, the debugger's internal parameters may not be 
 
 	vv 
 properly updated.  Normally this should be avoided.
 
.ix Join command
   R p hD" p mD J   p mDR p hD  ({J}oin) routes one device to another.  The complete command is:   R p hD" p mD J   p mDR p hD  {device to 
 
 	vv 
 reassign}  R p hD" p mD =   p mDR p hD {new device}.    R p hD" p mD JPRTR=SER1   p mDR p hD  routes all transfers via the PRTR 
 
 	vv 
 device to serial port 1.  Rerouting may be canceled by routing a device to 
 
 	vv 
 itself:   R p hD" p mD JPRTR=PRTR   p mDR p hD .
 
.ix List command
 ix Disassembler
   R p hD" p mD L   p mDR p hD  ({L}ist) lists opcodes symbolically.    R p hD" p mD LD   p mDR p hD  lists and also displays hex object code 
 
 	vv 
 for each instruction.    R p hD" p mD LN   p mDR p hD  does a normal listing.    R p hD" p mD L   p mDR p hD  by itself defaults to 
 
 	vv 
 whatever the last option was (  R p hD" p mD N   p mDR p hD  or   R p hD" p mD D   p mDR p hD ).  The complete command is: {  R p hD" p mD L   p mDR p hD  or   R p hD" p mD LD   p mDR p hD  or 
 
 	vv 
   R p hD" p mD LN   p mDR p hD } {starting address}, {number of opcodes to list}.  After each   R p hD" p mD L   p mDR p hD  command, 
 
 	vv 
 the default address is set to the next instruction.  A trace or break trap also 
 
 	vv 
 sets the default address.  Symbol names are shown in diagonal brackets as 
 
 	vv 
 appropriate.  Program memory relative symbols are only displayed if an exact 
 
 	vv 
 match is found.  (SB) and (FP) relative symbols are always displayed.  If an 
 
 	vv 
 exact match is not found, the nearest symbol less than the actual value 
 
 	vv 
 displays with an offset.  Local FP relative symbols are available for 
 
 	vv 
 calculation or expression evaluation only after listing.  The default option is 
 
 	vv 
 normal listing of 8 lines.
 
.ix Move command
   R p hD" p mD M   p mDR p hD  ({M}ove) moves a block of memory.   R p hD" p mD M   p mDR p hD  {source address}, {destination address}, 
 
 	vv 
 {byte count}.  The move will be either forwards or backwards as necessary.  
 
 	vv 
   R p hD" p mD M1000,1010,20   p mDR p hD  moves backwards starting with source address 101F.  
 
 	vv 
 Source data is not altered unless overwritten by the move.
 
.ix MM command
 ix Virtual memory
 pm 0.35"
 
 	vv 
   R p hD" p mD MM   p mDR p hD {  R p hD" p mD U   p mDR p hD  (user) or   R p hD" p mD S   p mDR p hD  (supervisor)} {virtual address}, {physical address}, {size in 
 
 	vv 
 bytes}, {  R p hD" p mD SR   p mDR p hD  (supervisor read) or   R p hD" p mD SW   p mDR p hD  (supervisor write) or   R p hD" p mD UR   p mDR p hD  (user read) or 
 
 	vv 
   R p hD" p mD UW   p mDR p hD  (user write),   R p hD" p mD V   p mDR p hD  (valid),   R p hD" p mD CI   p mDR p hD  (cache inhibit with a 32532 CPU)} builds page 
 
 	vv 
 translation entries in memory if you have a CPU supporting memory 
 
 	vv 
 management.  The MMU page table base registers must be properly  
 
 	vv 
 initialized.  The   R p hD" p mD U   p mDR p hD  (user) or   R p hD" p mD S   p mDR p hD  (supervisor) option must immediately follow the 
 
 	vv 
   R p hD" p mD MM   p mDR p hD  command and selects PTB0 or PTB1.  Level 2 table are built immediately 
 
 	vv 
 following level 1 tables in memory.  Only the number of tables actually 
 
 	vv 
 required by the {size} option are created.  Level 2 tables are only created 
 
 	vv 
 for valid memory:  If all memory is marked as invalid (The   R p hD" p mD V   p mDR p hD  option is not 
 
 	vv 
 specified) level 2 tables are not created at all.  This command does not alter 
 
 	vv 
 the MMU command register.  Valid and invalid memory blocks may be defined 
 
 	vv 
 in any order and changed as often as necessary.  Once everything is 
 
 	vv 
 satisfactory, enable translation as desired in the MMU.  Begin by defining all 
 
 	vv 
 memory as invalid, which guarantees that all level 1 translations access an 
 
 	vv 
 initialized entry.  Then go back and validate just those memory blocks that 
 
 	vv 
 are actually needed.  The   R p hD" p mD SR   p mDR p hD  (supervisor read only),   R p hD" p mD SW   p mDR p hD  (supervisor 
 
 	vv 
 read/write),   R p hD" p mD UR   p mDR p hD  (supervisor read/write, user read only) and   R p hD" p mD UW   p mDR p hD  (supervisor 
 
 	vv 
 read/write, user read/write) options are mutually exclusive but the   R p hD" p mD V   p mDR p hD  (valid) 
 
 	vv 
 option must always be specified for accessible memory.  Level 2 tables are 
 
 	vv 
 built as needed in the next available memory slot following level 1 tables and 
 
 	vv 
 any previously defined and still valid level 2 tables.  Kotekan does no 
 
 	vv 
 garbage collection of "abandoned" level 2 tables.  After extensive alterations,   o 9   o5                     
 
 	vv 
 start over by first invalidating all memory which "erases" all level 2 tables.  
 
 	vv 
 Then begin anew with a clean slate.  Assigning the same virtual and physical 
 
 	vv 
 address can write protect or invalidate blocks of memory.  
 
 	vv 
   R p hD" p mD MMS0,0,H'FFFFFFFF   p mDR p hD  invalidates all supervisor memory.  
 
 	vv 
   R p hD" p mD MMSH'F00000,H'F00000,H'10000,V,SR   p mDR p hD  validates and write protects 
 
 	vv 
 memory from H'F00000 to H'F0FFFF.
 
.ix Look command
 ix Search
 pm 0"
   R p hD" p mD O   p mDR p hD  (L{o}ok) searches memory for a string.    R p hD" p mD O   p mDR p hD  {starting address}, {ending address}, 
 
 	vv 
 {search string, truncated to 20 bytes}.  If the string is found, the address displays.  "No match" 
 
 	vv 
 displays if nothing is found.  The   R p hD" p mD S'   p mDR p hD  string designator is especially useful 
 
 	vv 
 here.  A second   R p hD" p mD O   p mDR p hD  command with no parameters resumes the search from the 
 
 	vv 
 next address.    R p hD" p mD O1000,2000,"CPU 32000"   p mDR p hD  looks for the string "CPU 32000" 
 
 	vv 
 starting at address 1000, and gives up if no match was found by address 
 
 	vv 
 2000.
 
.ix Port I/O command
 ix I/O
   R p hD" p mD P   p mDR p hD  ({P}ort IO) inputs a file to memory or sends a file from memory to the selected 
 
 	vv 
 device.    R p hD" p mD PI   p mDR p hD  {device name}, {destination address for file} reads a file.  After 
 
 	vv 
 reading, the next available address (the address of the ^D terminator when 
 
 	vv 
 reading from a serial port or PRTR device) displays and the default for the 
 
 	vv 
 next {P}ort command is set to the address of the termination character.  This 
 
 	vv 
 allows concatenating files in memory without intervening termination.  
 
 	vv 
   R p hD" p mD PISER1,1000   p mDR p hD  reads a file to address 1000.  If the next command were just 
 
 	vv 
   R p hD" p mD PISER1   p mDR p hD , the first character of the next file overwrites the termination 
 
 	vv 
 character of the first file.    R p hD" p mD PO   p mDR p hD  {starting address}, {ending address}, {device 
 
 	vv 
 name} transmits the block of memory to the appropriate device.
 
.ix Quick setup command
 ix MOD table
 ix Register initialization
   R p hD" p mD Q   p mDR p hD  ({Q}uick register setup/display) supports MOD tables.    R p hD" p mD QD   p mDR p hD  displays a complete 
 
 	vv 
 map of module and link tables.    R p hD" p mD QD   p mDR p hD  {module number} displays a map for the 
 
 	vv 
 selected module.    R p hD" p mD QR   p mDR p hD  {module number (default is 0)} sets the CPU MOD, PC 
 
 	vv 
 and SB registers from internally stored module data.  If the STACK pseudo-op 
 
 	vv 
 was used, the stack pointer is also initialized.    R p hD" p mD QM   p mDR p hD  {module number}   R p hD" p mD =   p mDR p hD  {MOD 
 
 	vv 
 register address} initializes the internal storage tables by reading the module 
 
 	vv 
 table from memory.  This is necessary after setting up module tables manually 
 
 	vv 
 if symbolic disassembly is to work properly.    R p hD" p mD QM0=100   p mDR p hD  reads parameters 
 
 	vv 
 from a valid MOD table set up at address 100.    R p hD" p mD QD   p mDR p hD  displays the new values 
 
 	vv 
 and   R p hD" p mD QR   p mDR p hD  initializes the CPU registers for execution.  More information is 
 
 	vv 
 contained in the "Linker" section.
 
.ix Register display command
   R p hD" p mD R   p mDR p hD  ({R}egister) displays or changes CPU, MMU or FPU registers.    R p hD" p mD R   p mDR p hD  displays all 
 
 	vv 
 CPU registers,   R p hD" p mD RM   p mDR p hD  displays all MMU registers (If supported by your CPU),   R p hD" p mD RF   p mDR p hD  
 
 	vv 
 displays all FPU registers.   R p hD" p mD R   p mDR p hD {register name} displays only that register, e.g. 
 
 	vv 
   R p hD" p mD R0   p mDR p hD  or   R p hD" p mD RMOD   p mDR p hD  or   R p hD" p mD RF0   p mDR p hD .  Spaces are not allowed between   R p hD" p mD R   p mDR p hD  and the register 
 
 	vv 
 name.    R p hD" p mD R   p mDR p hD {register name}   R p hD" p mD =   p mDR p hD  {new value} changes the contents of any register.  
 
 	vv 
 FPU register values may be changed to integers, floats, or longs.  The :L 
 
 	vv 
 suffix may be used with the floating value, e.g.   R p hD" p mD RF0=1.23:L   p mDR p hD .  Registers R0-
 
 	vv 
 R7 display using the current radix. All others, including FPU registers, 
 
 	vv 
 always display as unsigned hex integers.  To see the floating point 
 
 	vv 
 equivalent, use the {C}alculate command, e.g.   R p hD" p mD CF0   p mDR p hD  or   R p hD" p mD CF0:L   p mDR p hD .
 
.pm 0.35"
 
 	vv 
 The lower eight 32 bit FPU registers are always designated F0-F7.  The 
 
 	vv 
 upper registers of a 32381 or 32580 FPU are designated L1/L0, L3/L2, L5/L4, 
 
 	vv 
 L7/L6.  In this case the odd register designates the register pair.    R p hD" p mD RL0   p mDR p hD  
 
 	vv 
 displays bits 32-63 of the L1/L0 register pair.
 
.ix Setup command
   R p hD" p mD S   p mDR p hD  ({S}ystem setup) asks for, and changes the baud rate, which must be decimal.
 
.ix Trace command
   R p hD" p mD T   p mDR p hD  ({T}race) traces from the current PC.    R p hD" p mD TS   p mDR p hD  traces sequential opcodes and   R p hD" p mD TN   p mDR p hD    o 9   o5                     
 
 	vv 
 traces non-sequential opcodes.    R p hD" p mD T   p mDR p hD  defaults to either sequential or non-
 
 	vv 
 sequential according to the last option.  The complete command is {  R p hD" p mD T   p mDR p hD  or   R p hD" p mD TS   p mDR p hD  or 
 
 	vv 
   R p hD" p mD TN   p mDR p hD } {count}, {address of condition test routine}, {command to execute when 
 
 	vv 
 the trace trap is finally taken}.  The count, condition test and command line 
 
 	vv 
 work the same as their counterparts in the {B}reakpoint command.
 
.pm 0.35"
 
 	vv 
 When a trace trap is taken, the next instruction lists and the default list 
 
 	vv 
 address is set.  If the trace terminates because the condition test was true, 
 
 	vv 
 the remaining trace count displays.
 

 	vv 
 When tracing non-sequential instructions, the condition test and counter are 
 
 	vv 
 ignored on sequential instructions.  Branches, jumps and subroutine calls also 
 
 	vv 
 trace the following instruction (the destination of the branch or call) to 
 
 	vv 
 simplify following the action.
 
.ix Trace buffer
 
 	vv 
 Each instruction traced is automatically entered into the backtrace buffer, 
 
 	vv 
 even if the trace trap is not taken, and may be viewed with the {U}ntrace 
 
 	vv 
 command.
 
.ix Untrace command
 ix Trace buffer
 pm 0"
   R p hD" p mD U   p mDR p hD  ({U}ntrace) displays up to 1024 entries from the circular backtrace buffer.   R p hD" p mD U   p mDR p hD  
 
 	vv 
 displays the current number of entries and then displays the current 
 
 	vv 
 contents of the backtrace buffer one screen at a time.    R p hD" p mD U=   p mDR p hD  {count} sets the 
 
 	vv 
 current instruction count.  If the buffer holds 100 entries, the command   R p hD" p mD U=50   p mDR p hD  
 
 	vv 
 discards the last 50 entries.   R p hD" p mD U=0   p mDR p hD  erases and resets the buffer.    R p hD" p mD U   p mDR p hD  {count} 
 
 	vv 
 displays the last {count} entries one screen at a time.
 
.ix Validate command
 ix Memory test
   R p hD" p mD V   p mDR p hD  ({V}alidate) tests memory.   R p hD" p mD V   p mDR p hD  {starting address}, {ending address} is a  simple, 
 
 	vv 
 non-destructive read/complement/write/compare/restore test.  Dwords are 
 
 	vv 
 tested for maximum speed.  If an error occurs, the value read and value 
 
 	vv 
 written display along with the address.  Every 20 errors, the test pauses and 
 
 	vv 
 you may choose to continue or abort.    R p hD" p mD V1000,2000   p mDR p hD  checks addresses from 
 
 	vv 
 1000 to 2000.
 
.ix Window command
   R p hD" p mD W   p mDR p hD  ({W}indow) defines or selects a window.    R p hD" p mD W   p mDR p hD  {window number (0-7)} selects a 
 
 	vv 
 previously defined window.    R p hD" p mD W   p mDR p hD  {window number (0-7)}   R p hD" p mD =   p mDR p hD  {starting column (0- 
 
 	vv 
 79)}, {starting row (0-23)}, {number of columns (1-80)}, {number of rows (1-
 
 	vv 
 24)} defines a window.  When window 1 is defined, it is always selected for 
 
 	vv 
 command input and the currently selected window is used for display.   R p hD" p mD W   p mDR p hD  
 
 	vv 
 {window number}   R p hD" p mD X   p mDR p hD  resets the selected window to the full screen.    R p hD" p mD W1X   p mDR p hD  clears 
 
 	vv 
 window 1 and uses the currently selected window for command line input.  
 
 	vv 
   R p hD" p mD W1=0,D'22,D'80,2   p mDR p hD  defines a special command window in the bottom 2 lines 
 
 	vv 
 of the screen.    R p hD" p mD W2=0,0,D'80,D'22   p mDR p hD  initializes a window in the top 22 lines 
 
 	vv 
 for general display.  Leaving 2 lines for the command window displays the 
 
 	vv 
 last command line entered and also allows selecting window 1 for calculations 
 
 	vv 
 or one line displays without disturbing the main display in window 2.
 
.pm 0.35"
 
 	vv 
 Windows should not overlap unless you don't care that the portion of one 
 
 	vv 
 window overwritten by another is lost forever.  The debugger does not 
 
 	vv 
 redraw windows, it simply moves the cursor to the appropriate position and 
 
 	vv 
 sends the appropriate window command to the terminal.
 

 	vv 
 VT100 windows must always start in column 0 and be 80 columns wide as 
 
 	vv 
 these terminals do not support anything else.
 

 	vv 
 Reset initializes all windows to the full screen.
 
.ix Exit command
 pm 0"
   R p hD" p mD X   p mDR p hD  (E{x}it) displays a prompt and aborts the current multiple command line if "X"   o 9   o5                     
 
 	vv 
 is pressed, or continues execution if <space> is pressed.  This is most useful 
 
 	vv 
 with breakpoint command lines.
 
.ix Symbols command
   R p hD" p mD Y   p mDR p hD  (S{y}mbols) loads or displays the symbol table.    R p hD" p mD YO   p mDR p hD  displays the entire symbol 
 
 	vv 
 table.    R p hD" p mD YI   p mDR p hD  {PC address}, {device} loads a symbol table and sets the internal 
 
 	vv 
 disassembly tables to the value given in {PC address}.  Each   R p hD" p mD YI   p mDR p hD  command 
 
 	vv 
 initializes a new module table which may be displayed with the   R p hD" p mD QD   p mDR p hD  command.  
 
 	vv 
 The   R p hD" p mD YI   p mDR p hD  command requires the same symbol table format written by the   R p hD" p mD YO   p mDR p hD  
 
 	vv 
 command.    R p hD" p mD Y   p mDR p hD  {symbol name} displays the nearest symbol to the requested 
 
 	vv 
 name.  Subsequent   R p hD" p mD Y   p mDR p hD  commands (The default if <RETURN> is pressed) step 
 
 	vv 
 through the symbol table one entry at a time.
 
.ix Zap command
 ix Clear screen
   R p hD" p mD Z   p mDR p hD  ({Z}ap) clears the current window.
 pa  ?)   o5                     
  Ep mD" p mD 
 oc on
 
 	yy 
 Traps
 oc off
 tc Traps  .................................... #
    4 p mDEp mD 
 lm 0"
 pm 0"
 ny traps assigned to the debugger are treated like breakpoints:  The CPU status 
 s saved, register displays are updated and a message describing the trap 
 isplays.  A non-maskable interrupt push-button can interrupt a program at any 
 ime.  Registers or memory may be examined or altered before resuming execution.
 
 Ep mD" p mD 
 oc on
 
 	&& 
 Number Displays
 oc off
 tc Number Display  ........................... #
 ix Number display
 ix ASCII display
    4 p mDEp mD 
 umbers usually display in the currently selected radix and are signed or 
 nsigned as set with the RADIX pseudo-op.  Registers other than R0-R7 are 
 lways displayed in unsigned hex.  ASCII characters from H'20-H'7F display 
 ormally.  ASCII codes 0-H'1F display in dim video (green on color VT100 
 erminals), codes H'A0-H'FF display in reverse video and codes H'80-H'9F display 
 n both dim and reverse.
 
.ix Floating value display
 loating values are converted to 7 decimal digits, rounded and displayed as up to 
  digits.  Longs are converted to 15 digits, rounded and displayed as up to 14 
 igits.  Trailing zeros are always suppressed.  Scientific notation is used to 
 isplay numbers less than .1 and for numbers too large to display without it.
 
.ix String display
 trings display as comma separated byte values unless the ASCII option    p hD" p mD CA   p mDR p hD  is 
 elected.
 
.ix Error message
 Undf" indicates an undefined value.
 pa     o5                     
 