}  PL1000                                                                                                                   } .tc Assembler  ................................ #
 Ep mD" p mD 
.oc on

 	ff 
 Assembler
.oc off
   4 p mDEp mD 
Assembly continues until a ^D or ^Z character is encountered, or until a STOP 
pseudo-op is found.  Any source text immediately preceding the ^D terminator is 
ignored.  It is a good idea to include a ^D terminator even if the STOP pseudo-op 
is used because an unterminated macro, conditional assembly block or comment 
block could skip the STOP line.

When assembling directly from a port, characters are read until a CR is received.  
If the file includes a ^D terminator, a CR must follow or the line will not be 
accepted.  You must also be careful about stray characters (such as a line feed) 
after the final CR in a module.  For a two pass assembly, send the file again after 
the assembler displays the "Pass 2" message.

A single source file may contain several modules.  An ENDMOD or LINK pseudo-op 
terminates the current module; the next line is the beginning of a new module and 
the SYMBOLS and ONEMOD pseudo-ops are both reset to "false".

All 320xx/32CG16/32532/32GX32 CPU, MMU and FPU opcodes are accepted without 
any special configuration or assembler commands.

RET, RETT and RXP and addressing mode displacements default to 0 if not 
specified.

The SAVE and RESTORE opcodes and REG pseudo-op accept    p hD" p mD [ALL]   p mDR p hD  for all 8 
registers.

Spaces are not allowed within parentheses with (Rn), (SB), (SP) and (FP).

When using symbols as operands, the addressing mode need not be specified 
unless something other than the default is desired.  If LABL was defined as an 
(SB) relative symbol, the operand LABL evaluates to LABL(SB) while (LABL) is 
equivalent to 0(LABL(SB)).

Symbol names must begin in the leftmost column and may represent integers, 
floating values or strings.  A trailing colon is optional.  A trailing double colon 
declares that symbol global.  Symbol names may be up to 31 characters in length 
and all characters are significant.  The addressing mode of a symbol (determined 
by the current setting of the MODE pseudo-op) is stored as part of the symbol 
and used whenever that symbol is referenced.  During a two pass listing, a phase 
error is displayed if the value of any symbol changes, except those assigned as 
temporary values with the SET pseudo-op.  Symbol names must not contain any of 
the special delimiter characters and must not start with a digit or "@" as this is 
an addressing mode designator.

Comments may be indicated in two ways.  The assembler ignores any text to the 
right of a    p hD" p mD ;   p mDR p hD  anywhere in the line (unless enclosed in quotes).  Curly braces may 
enclose a comment block.  The opening    p hD" p mD {   p mDR p hD  must be the first character in a line 
and the    p hD" p mD }   p mDR p hD  must be the last character in a line, which allows curly braces within a 
non-comment line.  Comments in macros are stored as part of the macro text 
unless preceded by    p hD" p mD ;;   p mDR p hD .

.lm 0.35"
.pm 0.35"

 	vv 
 { This is a comment }


 	vv 
 ;This is also a comment
  o 9   o5                     

 	vv 
 {

 	vv 
 This is a comment block.

 	vv 
 Curly braces {} may be used like this.

 	vv 
 }
.lm 0"
.pm 0"

.ix Error messages
For each error, the source code line number displays followed by the nearest 
program memory relative symbol in diagonal brackets and the offending source 
code.  Any error terminates assembly after the first pass.

Following a successful single pass assembly, forward references are resolved and 
the assembly is finished.  Undefined symbols display an error message, along with 
the symbol name and the absolute address immediately following the error.  In the 
case of an out-of-range displacement, the assembler doesn't always know exactly 
where the first byte of the opcode is; the offending opcode may be several bytes 
back.  If you can't find the undefined symbol, assemble again in 2 pass mode.  A 
2 pass assembly also detects some subtle errors, such as addressing mode 
changes, that may slip by in a single pass assembly.

.ix Assembly listing
Any requested listing (other than a pass 1 listing) begins on the second pass.  A 
5 digit line number appears in the leftmost column.  The current mode pointer 
(PC, SB, FP, SP, IMM) displays as 8 unsigned hex digits in column 8. Up to 11 
unsigned hex bytes of object code start in the next column.  More than 11 bytes 
of object code don't display unless requested with the WIDTH pseudo-op.  The 
actual source code begins in column 40.  With translation enabled, the translated 
line appears rather than the original source code; all lower case letters appear in 
upper case, unless part of a quoted string, and strings are translated.

The symbol table follows any listing.  Local symbols used by the repeat macros 
(REPT, IRPC, etc.) don't appear in the symbol table, but general symbols created 
with translated LOCAL symbols do.  Local symbol translations consist of the 
backslash character followed by four hex digits.  The symbol name displays in the 
leftmost column, followed by the value, a colon, and a designator indicating the 
type of symbol:
.ix Symbol designator

.lm 0.35"
.pm 0.35"

 	vv 
   R p hD" p mD (FP)   p mDR p hD  = frame pointer relative

 	vv 
   R p hD" p mD (SB)   p mDR p hD  = static base relative

 	vv 
   R p hD" p mD (SP)   p mDR p hD  = stack pointer relative

 	vv 
   R p hD" p mD #   p mDR p hD  = immediate mode (integer or floating value)

 	vv 
   R p hD" p mD @   p mDR p hD  = absolute

 	vv 
   R p hD" p mD *   p mDR p hD  = program memory relative

 	vv 
   R p hD" p mD $   p mDR p hD  = string

 	vv 
   R p hD" p mD Macro   p mDR p hD  = macro

 	vv 
   R p hD" p mD X   p mDR p hD  = external addressing mode

 	vv 
   R p hD" p mD ?   p mDR p hD  = undefined or illegal symbol
.lm 0"
.pm 0"

The value of the symbol appears in column 16.  Immediate integer values display 
in the current radix.  Strings print as comma separated byte values.  Other 
symbol types appear in unsigned hex preceded by   R p hD" p mD H'   p mDR p hD .

If a cross reference was requested, all line numbers referencing that symbol also 
display, except the line in which the symbol was defined.  Macro expansions 
appear only if the MLIST pseudo-op enables macro listing.

.cp 5  ?6   o5                     
Source code line numbers may not always agree with the line numbers generated 
by the listing, especially in macro expansions.  Error line numbers always 
reference the source code.  Listing line numbers are simply incremented with each 
line printed.  Macro expansions naturally require more lines in the listing than in 
the source code.
.pa  ?0   o5                     
 Ep mD" p mD 
.oc on

 	tt 
 Pseudo-ops (Assembler Directives)
.oc off
.tc Pseudo-ops (Assembler Directives)  ........ #
   4 p mDEp mD 
Periods preceding the pseudo-op name are optional and ignored if present.  
Pseudo-op parameters must be integer expressions unless specified otherwise, and 
multiple parameters must be separated by commas.  For boolean parameters 
(true/false, on/off) only bit 0 is significant.  Macros may redefine Kotekan's 
pseudo-ops or simulate pseudo-ops used by other assemblers.

.lm 0.35"
.pm 0"
   p hD" p mD ABORT   p mDR p hD  {error count} sets the maximum number of errors allowed before the 

 	vv 
 assembly aborts.  The default is 40.  Multiple errors in a single line could make the total higher than the 

 	vv 
 specified limit.

   p hD" p mD ALIGN   p mDR p hD  {alignment value}, {optional displacement} aligns the current mode pointer 

 	vv 
 upward.     p hD" p mD ALIGN4   p mDR p hD  aligns the pointer to the next Dword boundary.  The 

 	vv 
 second parameter, if present, is added to the result of alignment with the 

 	vv 
 first parameter.  If the current mode pointer is H'101, then    p hD" p mD ALIGN4,2   p mDR p hD  

 	vv 
 advances the pointer to H'106.

   p hD" p mD ASCII   p mDR p hD  is equivalent to DB.

.pm 0.35"
.lm 0.35"

 	vv 
 Storage may be allocated in bytes, words, Dwords, floats or longs.  The 

 	vv 
 default size is 1 unit.  The parameter is multiplied by the size of the storage 

 	vv 
 unit (1 for bytes, 2 for words, 4 for Dwords or floats, 8 for longs).     p hD" p mD BLKD   p mDR p hD  

 	vv 
 reserves 4 bytes,    p hD" p mD BLKW2   p mDR p hD  also reserves 4 bytes.
.lm 0.35"
.pm 0"

   p hD" p mD BLKB   p mDR p hD  {optional byte count} reserves space for bytes.

   p hD" p mD BLKW   p mDR p hD  {optional word count} reserves space for words.

   p hD" p mD BLKD   p mDR p hD  {optional Dword count} reserves space for Dwords.

   p hD" p mD BLKF   p mDR p hD  {optional float count} reserves space for floats.

   p hD" p mD BLKL   p mDR p hD  {optional long count} reserves space for longs.

.lm 0"
A list of comma separated bytes, words, Dwords, floats or longs may be assembled 
directly into your object code.  The integer pseudo-ops (   p hD" p mD DB, DW, DD   p mDR p hD , etc.) also 
accept ASCII strings.  The leftmost character of an ASCII string appears at the 
lowest address.  Integers and floating values assemble least significant byte first.  
Square brackets may enclose an optional repeat count .     p hD" p mD DB[5]"",[3]0   p mDR p hD  
generates 8 bytes (5 blanks and 3 0s).  Note that no comma separates the repeat 
count and the expression to repeat.

.lm .35"
   p hD" p mD DB   p mDR p hD  {byte or string list} specifies bytes or strings:  

 	vv 
    p hD" p mD DB1,2,3,"Thisisastring"   p mDR p hD 

   p hD" p mD DW   p mDR p hD  {word or string list} specifies words or strings.

   p hD" p mD DD   p mDR p hD  {Dword or string list} specifies Dwords or strings.

   p hD" p mD DF   p mDR p hD  {float list} specifies floats.

   p hD" p mD DL   p mDR p hD  {long list} specifies longs.

   p hD" p mD BYTE   p mDR p hD  is equivalent to DB.
  o 9   o5                     
   p hD" p mD WORD   p mDR p hD  is equivalent to DW.

   p hD" p mD DBL   p mDR p hD  is equivalent to DD.

   p hD" p mD DOUBLE   p mDR p hD  is equivalent to DD.

.ix Forward reference
   p hD" p mD DISP   p mDR p hD  {size} sets the default displacement size (1, 2 or 4) for forward referenced 

 	vv 
 symbols.  After a reset, DISP defaults to 4.  This also sets the size for 

 	vv 
 branches within the conditional structures (IF/ELSE, UNTIL, WHILE).

   p hD" p mD DROP   p mDR p hD  removes the top value from the math stack.  Following a one pass assembly, 

 	vv 
 the forward reference resolver also adjusts the math stack at the appropriate 

 	vv 
 time.  As long as there was a corresponding PUSH there is never any 

 	vv 
 problem, but if not, a "Stack empty" error may result.

   p hD" p mD DS   p mDR p hD  {byte count} is equivalent to BLKB.

   p hD" p mD ENDMOD   p mDR p hD  terminates the current module and begins a new one.  This allows one 

 	vv 
 source file to contain several modules.

   p hD" p mD EQU   p mDR p hD  {integer, floating value or string expression} assigns a fixed value to the 

 	vv 
 symbol name beginning in the leftmost column.  

.ix External symbol
   p hD" p mD EXTRN   p mDR p hD  {symbol list} declares the following comma separated list of symbols to be 

 	vv 
 external to the current module.  The addressing mode of externals  defaults 

 	vv 
 to PC unless a colon delimiter is used.     p hD" p mD EXTRNLABEL1:(SB),LABEL2   p mDR p hD tags 

 	vv 
 LABEL1 as an SB relative symbol while LABEL2defaults to PC relative.  The 

 	vv 
 EXTRN pseudo-op should only be used when assembling a module separately 

 	vv 
 and writing a linker file.  If several modules are assembled or linked with the 

 	vv 
 same {A}ssemble command, the addressing mode declared or assigned by 

 	vv 
 default by the EXTRN pseudo-op must match the addressing mode assigned in 

 	vv 
 the module where the symbol is defined or an addressing mode conflict 

 	vv 
 results.  The colon delimiter is ignored if the symbol is already defined.

.ix External symbol
   p hD" p mD EXTUNDF   p mDR p hD  {boolean value}, if true, declares all undefined symbols external.  This 

 	vv 
 eliminates the need for explicit EXTRN declarations, but also prevents the 

 	vv 
 detection of accidentally undefined symbols until the final link.  The default 

 	vv 
 value is off.

   p hD" p mD FIELD [   p mDR p hD {width}   p hD" p mD ]   p mDR p hD  {value} assembles a series of comma separated bit fields.  

 	vv 
 Square brackets must enclose the width of the bit field.  The first (leftmost) 

 	vv 
 bit width/value in the source code starts at bit 0.  The sum of all field 

 	vv 
 widths cannot exceed 32 bits.  The sum of all bit fields is rounded up to the 

 	vv 
 nearest byte boundary and all unspecified bits are set to 0.  

 	vv 
    p hD" p mD FIELD[3]2,[5]7,[4]3   p mDR p hD  assembles as B'0000001100111010.

   p hD" p mD FLIST   p mDR p hD  {boolean value} lists false conditionals if on.  The default value is off.

   p hD" p mD GLOBAL   p mDR p hD  {symbol list} declares the following comma separated list of symbols 

 	vv 
 global.     p hD" p mD ::   p mDR p hD  immediately following the name also declares that symbol global.  

 	vv 
 The addressing mode defaults to PC.  A colon delimiter sets the addressing 

 	vv 
 mode of forward referenced non-PC relative symbols unless the symbol is 

 	vv 
 already defined.

   p hD" p mD GLOBL   p mDR p hD  is equivalent to GLOBAL.

   p hD" p mD LINK   p mDR p hD  {module name}, {PC address}, {SB address}, {MOD address}, {link table   o 9   o5                     

 	vv 
 address} links a file from the current assembler input device using the 

 	vv 
 appropriate binary file protocol.  All parameters default to the values stored 

 	vv 
 in the linker file.  The linker assigns defaults to any values not specified in 

 	vv 
 the file.  Commas indicate missing parameters:    p hD" p mD LINK,H'8000   p mDR p hD  keeps the 

 	vv 
 default module name, sets the PC address to H'8000 and uses defaults for all 

 	vv 
 other parameters.  The PC address must not overlap any following modules.

   p hD" p mD LIST   p mDR p hD  {boolean value} turns program listing on or off.

.ix Memory size
   p hD" p mD MEMSIZE   p mDR p hD  {new size} sets memory size.  MEMSIZE-1(SB) is the last usable address.

   p hD" p mD MLIST   p mDR p hD  {boolean value} lists macro expansions if on.  The default value is off.

   p hD" p mD MODE   p mDR p hD  {addressing mode}, {new value}  sets the current default for labels and 

 	vv 
 storage symbols to PC, SB, FP, SP, IMM or IMM-.  MODE PC restores program 

 	vv 
 memory mode which must always be used for opcodes.  IMM and IMM- allow 

 	vv 
 tables of immediate mode values.  An optional value may be used, e.g. 

 	vv 
    p hD" p mD MODEFP,5   p mDR p hD  which selects FP mode and sets the mode pointer to 5.  As 

 	vv 
 storage is allocated, the mode pointer increments for PC, SB and IMM modes, 

 	vv 
 and decrements for SP, FP and IMM- modes.

.pm .35"

 	vv 
 MODE can be used to create storage referenced indirectly, such as with a  

 	vv 
 memory relative addressing mode:
.cp12
.pm 0"
.lm 0"
.ps off

	MODE	SB		;Select SB mode
LABL1:	BLKD	2		;Create 8 bytes of storage
	MODE	IMM,0		;Start pointer at 0
LABL2:	BLKD			;No storage allocated but 
LABL3:	BLKD			; pointer increments
	MODE	PC		;Back to PC relative mode
	MOVD	LABL3(LABL1),R0	;Same as MOVD 4(LABL1),R0

.ps on
.ix Local storage
  R p hD" p mD MODE SP   p mDR p hF  can set up symbolic references using SP storage.  This allows local 
stack storage without altering the FP register:
.ps off

	MODE	SP,8
LABL1:	BLKD
LABL2:	BLKD
	MODE	PC

	ADJSPB	8		;Allocate SP storage
	MOVD	R1,LABL1	;Same as MOVD R1,4(SP)
	MOVD	R2,LABL2	;Same as MOVD R1,0(SP)
;
;	more program code here
;
	ADJSPB	-8		;Clear temporary SP storage

.ps on
  R p hD" p mD MODE IMM   p mDR p hF  can set up sequential equates:
.ps off

	MODE	IMM,0
LABL1:	BLKB			;Same as LABL1 EQU 0
LABL2:	BLKB			;Same as LABL2 EQU 1
	MODE	PC

.ps on
.pm 0"
.lm .35"
  R p hD" p mD MODULE   p mDR p hF    R p hD" p mD PB=   p mDR p hF {PC base address},   R p hD" p mD SB=   p mDR p hF {SB base address},   R p hD" p mD MB=   p mDR p hF {MOD table base 

 	vv 
 address},   R p hD" p mD LB=   p mDR p hF {Link table base address} sets the current module's link   o 9   o5                     

 	vv 
 parameters.  The module name must start in column 0 as all symbol names do.  

 	vv 
 All parameters are optional and may be specified in any order.  The linker 

 	vv 
 assigns default values to any unspecified parameters.

  R p hD" p mD NSCGNX   p mDR p hF  {boolean value} enables compatibility with National Semiconductor's GNX 

 	vv 
 Assembler when on.  The default is off.  Refer to GENIX.DOC for more 

 	vv 
 information.

.ix Static base
  R p hD" p mD ONEMOD   p mDR p hF  {boolean value} combines multiple source code files into one big module 

 	vv 
 when on.  All SB references are then consecutive starting with the base 

 	vv 
 program module.  Subroutine calls between modules work since all program 

 	vv 
 modules use the same SB register value.  During assembly, ONEMOD declares 

 	vv 
 all SB references external, even if defined in that source code file.  At link 

 	vv 
 time, all SB references receive sequential values.  If the first file linked uses 

 	vv 
 100 bytes of SB storage, the next module's SB offset starts at 100.  If 

 	vv 
 ONEMOD is false at link time, separate modules are assumed and the SB 

 	vv 
 offset resets to 0 for each new module.  ONEMOD may be true during and 

 	vv 
 assembly and false during linking.  The same linker file may be linked with 

 	vv 
 ONEMOD true or false.  The ONEMOD pseudo-op must therefore precede each 

 	vv 
 LINK pseudo-op, even though a file may have been assembled with ONEMOD 

 	vv 
 true.

  R p hD" p mD ORG   p mDR p hF  {new value} sets the current mode pointer to an absolute value.

  R p hD" p mD P1LIST   p mDR p hF  {boolean value} enables a pass 1 listing when on, but is subordinate to 

 	vv 
 the other listing commands; you must first use the LIST pseudo-op or 

 	vv 
 select an assembler option that creates a listing.  The MLIST and FLIST 

 	vv 
 options must also be set appropriately.  Once P1LIST is on, the LIST, MLIST 

 	vv 
 and FLIST options control the listing.

.pm .35"

 	vv 
 Object code listed on pass 1 may contain some garbage as forward references 

 	vv 
 have not been resolved and, if a 2 pass assembly was requested, dis

 	vv 
 placements and immediate operands have not been installed.
.pm 0"

  R p hD" p mD PSEUDO_OP   p mDR p hF  {pseudo-op and parameters} processes the following text as a pseudo- 

 	vv 
 op line.  Normally macros take priority over pseudo-ops, which allows 

 	vv 
 redefining any pseudo-op as a macro.  The PSEUDO_OP pseudo-op only 

 	vv 
 searches the pseudo-op table which allows a macro to use a pseudo-op with 

 	vv 
 the same name as the macro.  A pseudo-op may be redefined as a macro, and 

 	vv 
 then call the original pseudo-op function.  This is useful with source code 

 	vv 
 written for other assemblers that may use the same pseudo-op name for a 

 	vv 
 different function.

  R p hD" p mD PUSH   p mDR p hF  {value} pushes an integer, floating value or string onto the math stack.  

 	vv 
 Following a single pass assembly, the forward reference resolver also pushes 

 	vv 
 the value at the appropriate time.  As long as there is a corresponding DROP 

 	vv 
 pseudo-op there will never be a problem, but if not, a "Stack overflow" error 

 	vv 
 may result.

  R p hD" p mD PPRINT   p mDR p hF  {comma separated list of expressions} displays comma separated 

 	vv 
 expressions (integer, floating value, or string) on the printer.  This is 

 	vv 
 especially useful for printer initialization, such as turning on compressed 

 	vv 
 print mode.  If listing is disabled, PPRINT does nothing.  PPRINT processes 

 	vv 
 all values as PRINT does.

  R p hD" p mD PRINT   p mDR p hF  {comma separated list of expressions} displays one or more comma 

 	vv 
 separated expressions (integer, floating value, or string) on the selected   o 9   o5                     

 	vv 
 output device.  Symbol values display in ASCII.  Strings display as is.  

 	vv 
 Control characters such as a CR or LF may be placed into a string with the 

 	vv 
   R p hD" p mD S'   p mDR p hF  string designator.
  R p hD" p mD 
.lm .7"
.pm .7"

 	ll 
 PRINT "The value of LABEL is: ",LABEL
.lm .35"
.pm 0"
   p mDR p hF 
  R p hD" p mD RPN   p mDR p hF  {boolean value} selects RPN evaluation if true, or algebraic evaluation if false.  

 	vv 
 The default value is off (algebraic).

  R p hD" p mD RADIX   p mDR p hF  {new radix} sets the default radix for expression evaluation and display.  

 	vv 
 The value (2-16) must always be decimal.  Negative values (-2 through -16) 

 	vv 
 select signed display.  Positive values select unsigned display.  The default is 

 	vv 
   R p hD" p mD -10   p mDR p hF  (signed decimal).

  R p hD" p mD SET   p mDR p hF  {integer, floating value, or string} is similar to EQU but assigns a temporary 

 	vv 
 value to a symbol.  Another SET pseudo-op may redefine the same symbol.

  R p hD" p mD SPACE   p mDR p hF  is equivalent to DS.

  R p hD" p mD STACK   p mDR p hF  {stack size}, {initial stack value} initializes the SP for the current module.  

 	vv 
   R p hD" p mD STACKH'100,H'8000   p mDR p hF  initializes the stack to H'8000 and allocates 100 bytes.  

 	vv 
 If the STACK pseudo-op is used, the debugger's   R p hD" p mD QR   p mDR p hF  command loads the SP 

 	vv 
 register with the assigned value.

  R p hD" p mD STOP   p mDR p hF  terminates the source file.  It is optional if the file already ends with a ^D 

 	vv 
 or ^Z.

  R p hD" p mD SYMBOLS   p mDR p hF  {boolean value} saves all general (non-local) symbols in the linker file if 

 	vv 
 true, or only saves global symbols if false (the default).  When saving all 

 	vv 
 symbols in all modules, there can be no duplicates or the linker reports an 

 	vv 
 error.  SYMBOLS defaults to "false" at the beginning of each module.  It must 

 	vv 
 therefore be reset when assembling multiple modules with one {A}ssemble 

 	vv 
 command.

  R p hD" p mD WIDTH   p mDR p hF  {number of bytes of object code to list} controls listing of object code 

 	vv 
 when more than 11 bytes are generated by a single line.  The default is 11 

 	vv 
 which is the maximum number of bytes that can display in a single line.  

 	vv 
 Setting a higher count displays the additional bytes on consecutive lines, 11 

 	vv 
 bytes at a time in the usual object code position.

  R p hD" p mD XLAT   p mDR p hF  {boolean value} enables string translation when on.  This allows a string 

 	vv 
 symbol to be used in any position except the comment field of the source 

 	vv 
 code.  It should be used carefully since assembly time increases greatly when 

 	vv 
 every word must be checked for possible substitution.  0 length strings, such 

 	vv 
 as those assigned to null macro parameters, translate as   R p hD" p mD $<>   p mDR p hF .  All listings 

 	vv 
 display translated lines whenever translation is enabled.  This can be quite 

 	vv 
 useful for debugging, the only side effect being that lower case letters 

 	vv 
 appear in upper case.

.pm .35"

 	vv 
 All non-quoted character strings defined as string symbols translate 

 	vv 
 automatically with XLAT on as long as an operand/expression terminator or 

 	vv 
 the   R p hD" p mD &   p mDR p hF  character follows immediately.


 	vv 
 Turn off translation if not needed.  On pass 2, ALL occurrences of a string 

 	vv 
 symbol are translated.  A statement like:   R p hD" p mD SYMBLEQU$R0   p mDR p hF  translates as 

 	vv 
   R p hD" p mD R0EQU$R0   p mDR p hF  on pass 2 with XLAT is enabled.
.pa  o 9   o5                     

 	vv 
  Ep mD" p mD 
.oc on

 	cc 
 Macros
.oc off
.tc Macros  ................................... #

 	vv 
    4 p mDEp mD 
.pm 0"
.lm 0"
A variety of macros simplify many assembly tasks.  Macros may also replace 
pseudo-ops or simulate pseudo-ops used by other assemblers.

If the assembler finds an unterminated or improperly nested macro at the end of 
a pass, an error message displays along with the last source code line number 
where all macros were properly terminated.  The problem should be in the next 
macro block after that line.

Macro blocks are stored verbatim in memory.  Comments are stored too unless 
preceded by    p hD" p mD ;;   p mDR p hF .

The various repeat macros (REPT, IRP, IRPC, IRPL) execute immediately.

Local symbols, including repeat loop variables for IRP, IRPC and IRPL, are valid 
only within the current macro block and nested macros, and must not duplicate 
general (non-local) symbols, or local symbols used in outer macros.  During macro 
expansion, only local symbols are translated unless the XLAT pseudo-op enables 
general symbol translation.  Local symbols are cleared at the termination of a 
macro, or at the end of each iteration of a repeat macro.  Nested macros clear 
only their own local symbols, not those created by outer macros.

.pm 0"
.lm .35"
   p hD" p mD MACRO   p mDR p hF  {comma separated variable names} repeats a block of text with several 

 	vv 
 variables.  During macro expansion, any specified parameters are assigned to 

 	vv 
 the macro variables.  Macro parameters must be separated by commas and may 

 	vv 
 be enclosed in nestable   4 p hD" p mD []  " p mDR p hF ,   4 p hD" p mD <>  " p mDR p hF  or   4 p hD" p mD &&  " p mDR p hF .  Everything, including inner commas, 

 	vv 
 between corresponding delimiters is treated as a single parameter.  

 	vv 
 Intervening spaces are ignored unless multiple parameters appear between 

 	vv 
 commas.  In this case, the macro variable includes all characters between the 

 	vv 
 commas.  If there are more variable names than parameters, unassigned 

 	vv 
 variables translate as the null string    p hD" p mD $<>   p mDR p hF .  You can test for a null string 

 	vv 
 with:     p hD" p mD $<&LABL!>EQ$<$<>>   p mDR p hF  or    p hD" p mD 0EQLENLABL   p mDR p hF .

   p hD" p mD REPT   p mDR p hF  {repeat count} repeats the macro text the requested number of times.

   p hD" p mD IRP   p mDR p hF  {variable name}, {comma separated value list} ({I}ndefinite {R}e{P}eat) repeats 

 	vv 
 once for each value in the comma separated {value list}.  Each iteration 

 	vv 
 assigns the current value from the list to {variable name}.

   p hD" p mD IRPC   p mDR p hF  {variable name}, {string} ({I}ndefinite {R}e{P}eat by {C}haracter) repeats 

 	vv 
 once for each character in {string}.  Each iteration assigns the current 

 	vv 
 character to {variable name}.

   p hD" p mD IRPL   p mDR p hF  {comma separated parameter list} ({I}ndefinite {R}e{P}eat by {L}ine) repeats 

 	vv 
 once for each line of text until the corresponding LEND pseudo-op.  This is 

 	vv 
 equivalent to repeating a MACRO several times with different parameters.

   p hD" p mD LEND   p mDR p hF  terminates the value name list begins the actual macro text in an IRPL 

 	vv 
 macro.  

   p hD" p mD LOCAL   p mDR p hF  {comma separated parameter list} defines all symbols in the list as local; 

 	vv 
 they are valid only within that macro and nested macros.

   p hD" p mD MEXIT   p mDR p hF  {boolean value} immediately terminates the current macro if the condition is 

 	vv 
 true.  o 9   o5                     

   p hD" p mD MEND   p mDR p hF  indicates the end of the macro text.

   p hD" p mD ENDM   p mDR p hF  is equivalent to MEND.

;This macro sets DIG to the number of digits in the macro parameter
.cp10
.lm 0"
.ps off

DIGITS	MACRO	NUM
DIG	SET	1		;;Must be at least 1 digit
TEMP	 SET	10		;;First limit to try
	 REPT	10		;;Max number of reps
	  MEXIT	TEMP GT NUM	;;Done if TEMP is greater then NUM
TEMP	  SET	TEMP * 10	;;Next limit to test
DIG	  SET	DIG+1		;;Increment digit count
	 MEND			;;End of REPT
	MEND			;;End of MACRO
	DIGITS	100		;DIG = 3 (the number of digits in 100)

.ps on
;The following repeat macros define CTRL_A to CTRL_I as 1-9
.ps off

TEMP	SET	1		;;Counter
	IRPC	LET,ABCD	;;Letter designations
CTRL_&LET EQU	TEMP		;;CTRL_A-CTRL_D, & forces translation of LET
TEMP	SET	TEMP+1
	MEND

	IRP	WORD,CTRL_E,CTRL_F,CTRL_G
WORD	EQU	TEMP		;;CTRL_E - CTRL_G
TEMP	SET	TEMP+1
	MEND

	IRPL	VAL,WORD
	8,CTRL_H
	9,CTRL_I
	LEND
WORD	EQU	VAL		;;CTRL_H - CTRL_I
	MEND

.ps on
.pa  O'   o5                     
 Ep mD" p mD 
.oc on

 	00 
 Conditional Assembly
.oc off
.tc Conditional Assembly  ..................... #
   4 p mDEp mD 
Conditional assembly allows selectively assembly of different blocks of code.  
COND/CELSE/CEND blocks must be properly nested and terminated.  If not, an 
error message displays at the end of the pass, along with the last source code 
line number where all conditional assembly blocks were properly terminated.  The 
problem should be in the conditional assembly block following that line.  
Conditionals may be nested up to 16 levels, but inner COND blocks assemble only 
if the outer COND block was true (or the inner block is within the CELSE portion 
and the corresponding COND tested false).

.pm 0"
.lm .35"
   p hD" p mD COND   p mDR p hF  {boolean value} assembles the following block of code if the condition is 

 	vv 
 true.

   p hD" p mD CELSE   p mDR p hF  assembles the following block of code only if the corresponding COND block 

 	vv 
 was false.

   p hD" p mD CEND   p mDR p hF  terminates a conditional assembly block.
.cp13
.lm 0"
.ps off

FLAG1	EQU	1		;True
FLAG2	EQU	0		;False
	COND	NOT FLAG1
	 PRINT	"FLAG1 if false" ;This will not print
	CELSE
	 PRINT	"FLAG1 is true"	;This will print
	 COND	FLAG2
	  PRINT	"FLAG2 is also true" ;This will not print
	 CELSE
	  PRINT	"Only FLAG1 is true" ;This will print
	 CEND
	CEND

.ps on
.pa  "   o5                     
 Ep mD" p mD 
.oc on

 	@@ 
 Conditional Structures
.oc off
.tc Conditional Structures  ................... #
   4 p mDEp mD 
Conditional structures greatly simplify conditional branches and eliminate many 
symbols.  This is not the same as conditional assembly.  The conditional tests 
themselves are assembled, much like their counterparts in high level language.  
The conditional pseudo-ops accept any valid 32000 PSR (Processor Status Register) 
condition (GT, EQ, HS, etc.).  The DISP pseudo-op determines the displacement 
size for branches.  The END pseudo-op can terminate any of the conditional 
structures.  ENDIF, ENDU, and ENDW are equivalent alternatives which simply 
keeping track of complex nested conditionals.

Automatic error checking confirms that these structures are properly nested and 
terminated.  If not, a message displays along with the last source code line 
number where all conditional structures were properly terminated.  The problem 
should be in the next conditional structure after that line.

.ix AI command
IF/WHILE/UNTIL conditional blocks with the debugger's    p hD" p mD AI   p mDR p hF  command must be 
within +-H'800000 of the last assembly starting address (0 following an assembler 
reset).

.pm 0"
.lm .35"
   p hD" p mD IF   p mDR p hF  {PSR condition} continues with the following block of code if the condition is 

 	vv 
 true.  The program branches to ELSE if the condition is false, or to ENDIF if 

 	vv 
 no ELSE occurs.

   p hD" p mD ELSE   p mDR p hF  begins the block to execute if the corresponding IF condition is false.  

 	vv 
 This code is skipped if the original IF condition was true.

   p hD" p mD ORIF   p mDR p hF  {PSR condition} follows ELSE and branches back to the corresponding IF 

 	vv 
 block if the ORIF condition is true.  This allows executing the IF block on 

 	vv 
 any number of conditions.  If the ORIF condition is false, execution falls 

 	vv 
 through to the next instruction.  Multiple ORIFs are allowed.

   p hD" p mD ENDIF   p mDR p hF  or just    p hD" p mD END   p mDR p hF  terminates the IF/ELSE block.

   p hD" p mD UNTIL   p mDR p hF  {PSR condition} indicates the beginning of a block of code to repeat until 

 	vv 
 the specified condition is true.  The corresponding ENDU, or END pseudo-op 

 	vv 
 makes the test.  The block of code therefore always executes at least once.

.cp4
   p hD" p mD ENDU   p mDR p hF  or just    p hD" p mD END   p mDR p hF  terminates an UNTIL block.  If the corresponding UNTIL 

 	vv 
 condition is false, the program branches back to the UNTIL statement.  If the 

 	vv 
 condition is true, execution falls through to the next instruction.

   p hD" p mD BEGIN   p mDR p hF  indicates the beginning of the condition test code for the 

 	vv 
 BEGIN/WHILE/ENDW block.

   p hD" p mD WHILE   p mDR p hF  {PSR condition} branches to ENDW if the condition is false, or continues 

 	vv 
 with the next instruction if the condition is true.  The WHILE block doesn't 

 	vv 
 execute at all if the first condition tested false.

   p hD" p mD ENDW   p mDR p hF  or just    p hD" p mD END   p mDR p hF , branches unconditionally back to BEGIN where the condition 

 	vv 
 test repeats.  WHILE once again determines if the WHILE block continues.

.cp5  ?6   o5                     
   p hD" p mD QUIT   p mDR p hF  {PSR condition} aborts the current conditional block (IF, UNTIL or WHILE) if 

 	vv 
 the condition is true.  Control passes to QEND if present, or to the 

 	vv 
 corresponding END statement if QEND is missing.  Multiple QUITs are allowed 

 	vv 
 and may occur anywhere between the start of the conditional block and the 

 	vv 
 QEND (or END) statement.

   p hD" p mD QEND   p mDR p hF  executes only if a corresponding QUIT conditional was true.  QEND must be 

 	vv 
 the last conditional pseudo-op before END.
.lm 0"

The following code converts a lower case string in (R1) to upper case until a CR 
is found.  Quoted string are left as is.  ^D aborts the translation.  Z flag set 
if CR, reset if ^D
.cp30
.ps off

	BEGIN
	 MOVB	(R1),R2		;Current character to check
	 CMPQB	4,R2		;Check for ^D
	QUIT	EQ		;Error if ^D found
	 CMPB	13,R2		;Check for CR
	WHILE	NE		;Done if CR found, Z flag set
	 CMPB	'"',R2		;Check for opening quote
	 IF	EQ		;Quote routine
	  UNTIL	EQ
	   ADDQD 1,R1
	   CMPB	R2,(R1)		;Check for closing quote
	  ENDU			;Repeat until found
	 ELSE			;Not double quote
	  CMPB	"'",R2		;Single quote counts too
	 ORIF	EQ		;Do quote routine if EQ
	  CMPB	"a",R2		;Not quote, check lower case
	  IF	LS		;Possibly lower case if LS
	   CMPB	"z",R2		;Only convert a-z
	   IF	HS
	    CBITB 5,(R1)	;Make upper case
	   ENDIF
	  ENDIF
	 ENDIF
	 ADDQD	1,R1		;Advance pointer
	QEND			;End of loop, start of error code
	 BICPSRB H'40		;Reset Z to indicate the error
	ENDW			;Terminate the whole structure

.ps on
.pa  *   o5                     
 Ep mD" p mD 
.oc on

 	LL 
 Local Procedures
.oc off
.tc Local Procedures  ......................... #
   4 p mDEp mD 
Kotekan provides direct support for local procedures, the FP register, and 
parameters passed on the stack.  Beginning a procedure with XPROC, LPROC or 
PROC automatically selects FP relative addressing mode until the CODE pseudo-op.  
Just use the usual DS, BLKB, etc. storage pseudo-ops.  The assembler 
automatically generates all ENTER, EXIT, RET or RXP opcodes as necessary along 
with any required displacements.

.ix Local symbol
The XPROC, LPROC or PROC pseudo-ops accept an optional boolean value 
determining whether FP relative symbols are local or general.  If the boolean 
value is false or not specified, FP symbols are local which allows reusing the same 
symbol names with many different procedures.  The symbols are only valid until a 
the next procedure block, so care must be taken if calling subroutines that also 
use FP relative symbols.  If the boolean value is true, FP relative symbols are 
general symbols and available anywhere in the program, but each procedure must 
then use unique symbol names.

Automatic error checking ensures that each FP block is properly structured.  
Nested FP blocks are not allowed; a PROC must not occur within an LPROC block 
for instance.

.pm 0"
.lm .35"
   p hD" p mD XPROC   p mDR p hF  {boolean value} begins an external procedure block called with the CXP 

 	vv 
 opcode.  FP mode is selected.

.cp3
   p hD" p mD LPROC   p mDR p hF  {boolean value} begins a local procedure block called as a subroutine with 

 	vv 
 the BSR or JSR opcode.  FP mode is selected.

   p hD" p mD PROC   p mDR p hF  {boolean value} begins an in-line procedure block.  This allocates (FP) 

 	vv 
 storage in any block of code.  FP mode is selected.

   p hD" p mD PRET   p mDR p hF  is optional. If used, it must follow the last symbol to leave on the stack for 

 	vv 
 the calling routine; FP symbol storage between PRET and REG automatically 

 	vv 
 drops at the end of the procedure.

   p hD" p mD REG [   p mDR p hF {register list}   p hD" p mD ]   p mDR p hF  indicates the beginning of local storage.  Storage between 

 	vv 
 the beginning of the procedure and REG delimits symbol names for values 

 	vv 
 passed on the stack by the calling routine.  Storage between REG and CODE 

 	vv 
 is local storage used by the procedure block.  The register list is required 

 	vv 
 and must be enclosed in square brackets, but may be empty, i.e.    p hD" p mD []   p mDR p hF .

   p hD" p mD CODE   p mDR p hF  indicates the end of local storage and begins the actual procedure code.  PC 

 	vv 
 relative addressing mode is automatically selected here.

   p hD" p mD PEND   p mDR p hF  {optional number of bytes to clear from the stack} indicates the end of a 

 	vv 
 procedure block.  The optional byte count parameter allows returning 

 	vv 
 parameters on the stack to the calling routine; the requested number of bytes 

 	vv 
 are dropped from the stack.  Unless specified otherwise with the count 

 	vv 
 parameter or the PRET pseudo-op, all parameters passed on the stack are 

 	vv 
 cleared.  If calculating the byte count symbolically, remember that FP 

 	vv 
 decrements as storage is assigned; the first storage address defined is the 

 	vv 
 most positive.
.cp18  ?6   o5                     
.lm 0"
.ps off

	MOVQD	0,TOS
	MOVQD	1,TOS		;Set up parameters on stack
	BSR	SUBRT		;Call local procedure


SUBRT:	LPROC			;Local procedure called with BSR
VAR1:	BLKD			;VAR1 = 0 (passed on stack)
VAR2:	BLKD			;VAR2 = 1 (passed on stack)
	REG	[ALL]		;Save R0-R7
VAR3:	DS	6		;Local storage for the procedure
	CODE			;End of local storage
;
;Subroutine code goes here
;VAR1, VAR2 and VAR3 may be referenced symbolically
;
	PEND			;This does EXIT and RET opcodes
				;VAR1 and VAR2 are dropped

.ps on
A subroutine may return a value on the stack in one of two ways.  The first 
method uses the PRET pseudo-op:
.cp14
.ps off

SUBRT:	LPROC			;Local procedure called with BSR
VAR1:	BLKD			;VAR1 = 0 (passed on stack)
	PRET			;VAR1 will be returned
VAR2:	BLKD			;VAR2 = 1 (passed on stack)
	REG	[ALL]		;Save R0-R7
VAR3:	DS	6		;Local storage for the procedure
	CODE			;End of local storage
;
;Subroutine code goes here
;
	MOVQD	3,VAR1		;Return this to calling routine
	PEND			;Only VAR2 is dropped

.ps on
The second method uses the optional count parameter with the PEND pseudo-op.  
Any number of bytes may be returned regardless of how storage is allocated.  This 
example only returns one byte to the calling routine.
.ps off

SUBRT:	LPROC			;Local procedure called with BSR
VAR1:	BLKD			;VAR1 = 0 (passed on stack)
VAR2:	BLKD			;VAR2 = 1 (passed on stack)
	REG	[ALL]		;Save R0-R7
VAR3:	DS	6		;Local storage for the procedure
	CODE			;End of local storage
;
;Subroutine code goes here
;
	MOVQB	3,VAR1+3	;Only the last byte is returned
	PEND	7		;7 bytes are dropped

.ps on
.pa  4   o5                     
 Ep mD" p mD 
.oc on

 	NN 
 Strings
.oc off
.tc Strings  .................................. #
   4 p mDEp mD 
String symbols must be defined before use; forward references are not allowed 
with strings.  When the XLAT pseudo-op enables string translation, strings may 
substitute for labels, opcodes or any other field of the source code.  Macro 
expansion automatically enables local symbol string translation.  String text may 
be delimited with single or double quotes,   4 p hD" p mD []  " p mDR p hF ,   4 p hD" p mD <>  " p mDR p hF , or   4 p hD" p mD &&  " p mDR p hF .  Quoted strings are 
never altered.  Text enclosed by the other delimiters is eligable for translation, if 
enabled, and lower case to upper case conversion.

To use strings with a DB, DW or DD pseudo-op simply include the string symbol 
in the parameter list.  To translate strings within expressions, precede the symbol 
with the    p hD" p mD &   p mDR p hF  character and follow the symbol name with    p hD" p mD !   p mDR p hF  or an operand delimiter.

String operands in the source code are referenced by length and a pointer to the 
starting address in the source code line.  An EQU, SET or PUSH pseudo-op copies 
the string text to a special string storage area.  If you somehow push a string 
onto the math stack with an expression and plan to reference the string in a 
later line, the text will almost certainly be corrupted.

Quoted string of five or more characters are taken literally.  Quoted values of 
four or fewer bytes evaluate as integers.  The characters may be enclosed by 
single or double quotes but the same character (single or double quote) used to 
begin the quoted string must also end it.  This allows a double quote character 
within single quotes and a single quote character within double quotes.  
Characters within quotes are never translated and lower case letters are never 
converted to upper case.  The opening quote must immediately follow an 
operand/expression delimiter character, or an    p hD" p mD &   p mDR p hF  with translation enabled.

   p hD" p mD $   p mDR p hF  may also begin a string.  The string includes all text immediately following the 
   p hD" p mD $   p mDR p hF  character up to the next space, tab or comma.  Use the    p hD" p mD $   p mDR p hF  instead of quotes to 
get a string of 4 or fewer characters. Unlike quoted strings, characters following 
the    p hD" p mD $   p mDR p hF  are all eligible for translation and lower case characters are converted to 
upper case.  When using quotes,    p hD" p mD $"abc"   p mDR p hF , the string includes only the characters 
within the quotes.  This allows quoted strings of fewer than 5 characters.

Diagonal brackets may enclose a single string parameter defined with the    p hD" p mD $   p mDR p hF  
character.  In this case, the string includes everything within the outermost 
diagonal brackets (spaces, commas, quotes, even inner diagonal brackets).  
Characters within diagonal brackets may be translated.

.ix String extraction
The    p hD" p mD $(   p mDR p hF {position},{count}   p hD" p mD )   p mDR p hF  midstring function can extract a portion of a string.  
The {position} field is the starting position within the string and the {count} field 
is the number of characters to extract.  The string to process must immediately 
follow the closing parenthesis.  The {position} and {count} fields may be 
expressions and are automatically adjusted to keep within the actual length of the 
string.     p hD" p mD $(10,5)<AIN'TITGREAT?>   p mDR p hF  evaluates as "GREAT".

Special string operator characters allow additional capabilities.  The operators are 
only enabled within macros, or when translation is enabled with XLAT.

.cp5
.pm 0"
.lm .35"
   p hD" p mD ^   p mDR p hF  in a string takes the next character literally; no translation is done, not even 

 	vv 
 lower to upper case conversion.     p hD" p mD ^^   p mDR p hF  places the    p hD" p mD ^   p mDR p hF  character in a string.  The 

 	vv 
    p hD" p mD ^   p mDR p hF  should always be used before a quote that does not begin a quoted string.  

 	vv 
 Any text preceding the    p hD" p mD ^   p mDR p hF  character is translated as necessary before 

 	vv 
 processing the    p hD" p mD ^   p mDR p hF .  o 9   o5                     

.ix String delimiter
   p hD" p mD !   p mDR p hF  terminates a translatable string in the absence of a required delimiter.  This is 

 	vv 
 useful when combining strings and the ending position of a symbol is 

 	vv 
 ambiguous.

.ix String concatenation
   p hD" p mD &   p mDR p hF  is a translate flag which can precede strings or indicate the beginning of a 

 	vv 
 substring such as a quoted string.  The    p hD" p mD &   p mDR p hF  must be used when the beginning of 

 	vv 
 a translatable string would otherwise be ambiguous.  The    p hD" p mD &   p mDR p hF  character must 

 	vv 
 also precede a quoted string that is not immediately preceded by another 

 	vv 
 delimiter.  The string immediately preceding the    p hD" p mD &   p mDR p hF  character is translated as 

 	vv 
 necessary before processing the    p hD" p mD &   p mDR p hF .     p hD" p mD &&   p mDR p hF  can do a double translation.
.lm 0"
.ps off

STR1	EQU	"ABCDE"		;Define string 1
STR2	EQU	$<STR1>		;"STR1" evaluates as an integer
	XLAT	1		;Translation on
	DB	^"&STR2!^"	;Translates to DB "STR1"
	DB	^"&&STR2!^"	;Translates to DB "ABCDE"

.ps on
.pm 0"
.lm .35"
  R p hD" p mD %   p mDR p hF  converts the value of the following symbol to ASCII digits using the current 

 	vv 
 radix.  If the   R p hD" p mD %   p mDR p hF  does not follow an operand terminator, precede it with   R p hD" p mD &   p mDR p hF .
.lm 0"

These operators may be combined.  Suppose the symbol   R p hD" p mD VALUE   p mDR p hF  is an integer and 
the you need the ASCII equivalent of that integer in quotes.    R p hD" p mD ^"&%VALUE!^"   p mDR p hF  
can do the job.    R p hD" p mD %VALUE   p mDR p hF  evaluates   R p hD" p mD VALUE   p mDR p hF  and replaces it with an ASCII integer 
string.  The   R p hD" p mD !   p mDR p hF  ensures that the trailing   R p hD" p mD "   p mDR p hF  is not taken as part of the symbol 
name.  The quote marks must be preceded by   R p hD" p mD ^   p mDR p hF  so   R p hD" p mD &%VALUE!   p mDR p hF  isn't taken as 
literal ASCII characters.  The   R p hD" p mD &   p mDR p hF  marks the beginning of the symbol name for the 
string translator.  String symbols may be easily concatenated into bigger strings.  
If   R p hD" p mD STR1   p mDR p hF  and   R p hD" p mD STR2   p mDR p hF  are symbols for strings the statement: 
  R p hD" p mD STR3EQU$<&STR1!&STR2!>   p mDR p hF  concatenates   R p hD" p mD STR1   p mDR p hF  and   R p hD" p mD STR2   p mDR p hF  and assigns the 
valueto  R p hD" p mD STR3   p mDR p hF .
.pa  _    o5                     
 Ep mD" p mD 
.oc on

 	<< 
 Error Messages
.oc off
.tc Error Messages  ........................... #
   4 p mDEp mD 
Error messages are generally self-explanatory.  Some errors, especially invalid or 
undefined parameters, may generate several messages.  Math stack errors clear 
the stack which may cause even more errors.  Errors in unlisted macro 
expansions reference the MEND line in regular macros and the line immediately 
following the MEND line in the repeat blocks (REPT, IRP, etc.).  For this reason, a 
blank line following each MEND pseudo-op is recommended.

.lm .35"
.pm .35"

 	vv 
 "Addressing mode changed" - The addressing mode evaluated differently on 

 	vv 
 pass 2, usually caused by unspecified non-PC forward references.


 	vv 
 "Bad addressing mode" - Unrecognized addressing mode.


 	vv 
 "Bad opcode" - Invalid opcode, macro or pseudo-op.


 	vv 
 "CELSE without COND" - Improper COND structure.


 	vv 
 "CEND without COND" - Improper COND structure.


 	vv 
 "Comma expected" - Usually caused by a missing operand.


 	vv 
 "Condition mismatch" - Improperly structured IF/UNTIL/WHILE block: ELSE 

 	vv 
 within a BEGIN/WHILE block, etc.


 	vv 
 "Condition stack empty" - END without corresponding IF/UNTIL/WHILE.


 	vv 
 "Condition stack overflow" - Too many IF/UNTIL/WHILE conditional blocks.


 	vv 
 "Data type mismatch" - A math operator is used with invalid operands: adding 

 	vv 
 a string to an integer, etc.


 	vv 
 "Duplicate symbol" - A symbol is defined more than once.


 	vv 
 "Error in expression" - Syntax error in bit field, etc.


 	vv 
 "Error in procedure block" - Improper PROC/REG/CODE/PEND block, usually 

 	vv 
 caused by improper order or missing pseudo-op.


 	vv 
 "Error in string" - Improperly defined string, unbalanced quotes, diagonal 

 	vv 
 brackets, etc.


 	vv 
 "Extra text" - A non-comment field follows all required parameters.


 	vv 
 "Immediate operand not allowed" - Immediate addressing mode not allowed, 

 	vv 
 e.g.    p hD" p mD MOVD R5,5   p mDR p hF .


 	vv 
 "Integer data type required" - A string or floating operand appeared where 

 	vv 
 an integer was required.


 	vv 
 "Invalid or missing operand" - The opcode requires more operands than are 

 	vv 
 present.


 	vv 
 "Invalid parameter" - Invalid implied immediate operand.

 	vv 
 
.cp4  o 9   o5                     

 	vv 
 "Invalid parameter or value out of range" - The size or type of a parameter 

 	vv 
 is not allowed: A byte value greater than H'FF, short field value greater then 

 	vv 
 7, a floating value or string where an integer should be, etc.


 	vv 
 "Link table error" - An data error was detected during forward reference 

 	vv 
 resolution.  Possible causes are memory errors, or a scrambled linker file.


 	vv 
 "Line too long" - a source line exceeds 120 characters.


 	vv 
 "Math stack empty" - This may be caused by an improper expression or 

 	vv 
 missing parameter.


 	vv 
 "Math stack overflow" - Too many PUSHes with not enough POPs.  This may 

 	vv 
 be caused by a repeat macro run amok.


 	vv 
 "Mode error" - MODE pseudo-op is not set properly: trying to assemble 

 	vv 
 opcodes into an SB data area, etc.


 	vv 
 "Out of memory" - Too many symbols, macros, or strings.


 	vv 
 "Phase error" - a symbol has a different value on pass 2 than it had during 

 	vv 
 pass 1.  This is usually caused by allocating storage with an expression 

 	vv 
 which evaluates differently on the second pass or a macro which expands 

 	vv 
 differently on the second pass.


 	vv 
 "Redefined symbol" - EQU used with a previously defined symbol.


 	vv 
 "Relative PC out of range" - PC mode counter exceeds +-H'800000.  This is 

 	vv 
 caused by using the IF/UNTIL/WHILE structures with the    p hD" p mD AI   p mDR p hF  debugger 

 	vv 
 command at an address exceeding the allowable offset from the last assembled 

 	vv 
 object code address.


 	vv 
 "Symbol table full" - Out of memory.


 	vv 
 "Symbol undefined" - A symbol is referenced but never defined.


 	vv 
 "Unterminated conditional assembly block" - unbalanced COND/CELSE/CEND.


 	vv 
 "Unterminated FP procedure block" - Missing PEND, two consecutive PROCs, 

 	vv 
 etc.


 	vv 
 "Unterminated IF/UNTIL/WHILE block" - Improper conditional structure: 

 	vv 
 Missing END, two IFs in a row, etc.


 	vv 
 "Unterminated macro" - improper macro construction.
.lm 0"
.pm 0"
.pa  ?.   o5                     
