	print	"LNK32"

{
linker codes:
bit 7 off:
  bit 6 off => take next (0-3fff) bytes literally
  bit 6 set => bits 0-5 are math operator
bit 7 set:
  bit 6 off:
    bit 5 off => bits 0-4 are general command code
    bit 5 set => shift stack value by bits 0-4, orw with pointer
  bit 6 set =>
   bits 0-1 are size (b/w/d)
   bits 2-5 are value placement command (installed in com file from stack)
the commands must stay in this order for case opcodes to work
}

blnk_cmd equ	7		;Command bit
blnk_val equ	6		;Value command bit (BLNK_CMD set)
blnk_mth equ	6		;Math commands bit (BLNK_CMD clear)
 
;Value commands

blnksiz	equ	0		;1st bit of size
clnk_b	equ	0		;Byte
clnk_w	equ	1		;Word
clnk_d	equ	3		;Dword
clnk_f	equ	0		;Float
clnk_l	equ	1		;Long

blnkvcmd equ	2		;First bit of value command bits
clnkint	equ	0		;Link integer (LSB, MSB) command
clnkdsp	equ	1		;Link displacement command
clnkimm	equ	2		;Link immediate (MSB, LSB) command
clnkpcr	equ	3		;Link PC relative value command
clnkflt	equ	4		;Link float command
clnkfli	equ	5		;Link immediate float (MSB,LSB)
clnkcxp	equ	6		;Link CXP offset
clnkext	equ	7		;Link EXT displacement 1
clnkex2	equ	8		;Link EXT displacement 2

;General commands

blnk_or	equ	5		;OR command bit

blnkgcmd equ	0		;First bit of general command bits
clnkpshb equ	0		;Push Byte command
clnkpshw equ	1		;Push Word command
clnkpshd equ	2		;Push Dword command
clnkpshf equ	3		;Push float command
clnkpshl equ	4		;Push long float command
clnkasc	equ	5		;Push value of ASCII label (length,string)
clnkexp	equ	6		;Resolve terminated expression and push value
clnklpt	equ	7		;Push value of label pointed to by offset

;PC relative labels hold offset from base of module
clnk_ptr equ	8		;Load (M_PCPTR) with value + base address
clnk_adr equ	9		;Load (M_PCPTR) with displacement
clnk_pt7 equ	10		;Load R7 pointer with offset + base address
clnk_ad7 equ	11		;Load R7 with displacement + PCOF
clnk_end equ	12		;End of link data
clnkpshs equ	13		;Push string
clnkpshv equ	14		;Push variable length symbol/descriptor
clnkpcof equ	15		;Load new PCOF
clnkmod	equ	16		;Set new MOD number, -1 => increment


do_link::
	lproc
adr_r1:	blkb	4		;Address of link data
adr_r7:	blkb	4		;Address for object code
pcof:	blkd			;PC_OFST
	reg	[all]
here:	blkb	2+8		;2 byte status, 4 or 8 byte value
dat:	blkd			;Current data stream base pointer
modnum:	blkd			;Module of current disp.
buf:	ds	50		;Output buffer for errors
	code

	movd	lmod,r0
	muld	mod_tsiz,r0
	extsd	mod_tabl+4+4+2[r0:b],msym_beg,0,sidx_bit ;1st symbol offset
	movd	tsym_end,msym_end ;Go until end
	
	movd	adr_r1,r1
	movd	adr_r7,r7
	movd	lmod,modnum	;Current MOD
	movd	r1,dat

;Check for end of link data

	cmpqd	0,m_errct	;Don't link if assembly errors
	if	eq
	 begin
	  cmpd	max_err,m_errct	;If max errors then quit now
	 quit	lo
	  cmpb	exp blnk_cmd+clnk_end,(r1)
	 while	ne
	  addr	here,r5
	  bsr	lnk_sub		;Link one link data string
	 endw
	endif

	pend

;Link 1 link data string
;R1=>link data, R7=>object code, R5=>10 byte data value buffer
;R1, R7 updated, no other registers saved

lnk_sub:
	tbitb	blnk_cmd,(r1)
	if	fc		;Literal byte count if FC
	 tbitb	blnk_mth,(r1)	;Check for math command
	 if	fs
	  extsd (r1),r0,0,6	;Math operator
	  addqd	1,r1		;Advance link pointer
	  addqd 1,r0		;DO_MATH need operator+1
	  br	do_math:d
	 else
	  br	lnkerr
	  {
	  movzbd (r1),r0	;MSB of count
	  bicb	h'c0,r0		;Clear bits 6-7
	  lshw	8,r0		;move to MSB of R0
	  movb	1(r1),r0	;LSB of count
	  addqd	2,r1		;Advance to bytes to move
	  movd	r7,r2		;Target address
	  movsb			;Move it into place
	  movd	r2,r7		;Restore R7
	  ret
	  }
	 endif
	else
	 movb	(r1),r4
	 addqd	1,r1		;Skip over link command
	 tbitb	blnk_val,r4	;Check for value commands
	 if	fs		;Value commands if FS
	  extsd r4,r3,blnkvcmd,4 ;Actual command
	  extsd r4,r6,blnksiz,2	;Get size in R6
	  addqd 1,r6		;Number of bytes in R6
	  cmpb	clnkflt,r3
	  if	eq
	   lshd	2,r6		;Multiply by 4 to get float size
	  else
	   cmpb	clnkfli,r3	;Check for immediate float too
	  orif	eq
	  endif
	  bsr	math_pop:d	;Get value in 2(R5)
	  tbitb	b_def,(r5)
	  if	fc		;Undefined value if FC
	   cmpb	"L",m_pass
	   if	ne		;Never on link/load
	    save [r0,r1,r2]
	    bsr lnk_spac:d	;Move symbol table up as needed
	    if	fc		;OK if FC
	     movd m_lnkptr,r2	;Target address
	     movd r1,r0		;Last address + 1
	     movd dat,r1	;Source address
	     subd r1,r0		;Byte count for move
	     bsr mov_lnk	;Move data and expand symbols
	     movd r2,m_lnkptr	;Target updated
	    endif
	    restore [r0,r1,r2]
	   endif
	  else
	   movd	m_errct,tos
	   bsr	lnkv1
	   cmpd	m_errct,tos	;Check for errors
	   if	ne
	    save [r0,r1,r5,r6]
	    movb "@",r5
	    bsr	char_tx
	    movw 16,tos		;Unsigned hex
	    movd r7,tos
	    bsr	dsp_tos
	    addr buf,r1
	    movqd 0,r0
	    movd r7,r5
	    movzbd h'b,r6	;PC type
	    movd m_pcofst,tos
	    movw m_radix,tos
	    movw 16+exp b_sign+exp b_rdx,m_radix ;Signed hex with radix
	    movd pcof,m_pcofst	;Current value
	    bsr	sym_r5		;Display nearest PC symbol
	    movw tos,m_radix
	    movd tos,m_pcofst
	    bsr	str_out
	    bsr	do_cr
	    restore [r0,r1,r5,r6]
	   endif
	   tbitb b_def,(r5)
	  orif	fc		;CXP or EXT require final link resolution
	  endif
	  movd	r1,dat		;Update new base pointer
	  movd	lmod,modnum	;Current MOD
	  ret
	 else
	  tbitb blnk_or,r4	;Check for OR operation
	  if	fs
	   bsr	math_pop:d	;Value to shift in (R5)
	   extsd r4,r2,0,5	;Shift factor
	   lshd r2,2(r5)
	   orw	2(r5),(r7)
	   ret
	  else
	   extsd r4,r3,0,5	;General command to R3
lnkv3:	   casew lnkv4:b[r3:w]	
lnkv4:	   word lnkpshb-lnkv3	;Push byte
	   word lnkpshw-lnkv3	;Push word
	   word lnkpshd-lnkv3	;Push Dword
	   word lnkpshf-lnkv3	;Push float
	   word lnkpshl-lnkv3	;Push long float
	   word lnkasc-lnkv3	;Push value of ASCII label
	   word lnkerr-lnkv3	;Push evaluated expression
	   word lnklpt-lnkv3	;Push value symbol pointed to by offset
	   word lnkerr-lnkv3	;Load PC_PTR with given value + base
	   word lnkadr-lnkv3	;Load PC_PTR with value+base of 1st module
	   word lnkerr-lnkv3	;Load R7 pointer with given value + base
	   word lnk_ad7-lnkv3	;Load R7 with displacement + PCOF
	   word return-lnkv3	;End of link table
	   word lnkpshs-lnkv3	;Push string
	   word lnkpshv-lnkv3	;Load variable length symbol with descriptor
	   word lnkpcof-lnkv3	;Load new PCOF
	   word lnkmod-lnkv3	;New mod index

	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error
	   word lnkerr-lnkv3	;Link error

	  endif
	 endif
	endif

lnkv1:	casew	lnkv2:b[r3:w]
lnkv2:	word	lnkint-lnkv1	;Link integer (LSB, MSB) command
	word	lnkdsp-lnkv1	;Link displacement command
	word	byt_p2-lnkv1	;Link immediate (MSB, LSB) command
	word	lnkpcr-lnkv1	;Link PC relative value command
	word	lnkint-lnkv1	;Link float command
	word	byt_p2-lnkv1	;Link immediate float
	dw	lnk_cxp-lnkv1	;Link CXP disp.
	dw	lnkext1-lnkv1	;Link EXT disp. 1
	dw	lnkex2-lnkv1	;Link EXT disp. 2

	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error
	word	lnkerr-lnkv1	;Link error


;Move link data and expand symbols as needed
;R1 holds source, R2 holds target, R0 holds count
;R0, R1, R2 updated before exiting

mov_lnk:
	save	[r3,r4,r5]
	begin
	 cmpqd	0,r0
	while	lt
	 tbitb	blnk_cmd,(r1)	;Check for command
	 if	fc		;Not a command if FC
	  tbitb blnk_mth,(r1)	;Math operator if set
	  if	fs
	   movb	(r1),(r2)
	   addqd -1,r0
	   addqd 1,r1
	   addqd 1,r2
	  else
	   extsd (r1),r3,0,6	;MSB of count
	   lshw	8,r3
	   movb	1(r1),r3	;Number of bytes to move
	   movd	r0,r4
	   addqd 2,r3		;Include count word
	   subd	r3,r4
	   movd	r3,r0
	   movsb
	   movd	r4,r0
	  endif
	 else			;Command
	  tbitb blnk_val,(r1)	;Check for value placement command
	  if	fs		;Value placement if FS
	   movb	(r1),(r2)
	   addqd -1,r0
	   addqd 1,r1
	   addqd 1,r2
	  else
	   tbitb blnk_or,(r1)	;OR command if so
	  orif	fs		;General command if NE
	   cmpb	exp blnk_cmd+clnklpt,(r1) ;Check for symbol offset
	   if	eq
	    extsd 1(r1),r5,0,sidx_bit
	    addd t_symbl,r5	;Pointer to expression
	    tbitb b_def,(r5)
	    if	fc		;Undefined if FC
	     save [r0,r1]
	     movb exp blnk_cmd+clnkasc,(r2)
	     extsb (r5),r0,0,5 ;Length of symbol name
	     movb r0,1(r2)
	     addqd 2,r2
	     bsr lbl_nam	;Get pointer to name in R1
	     movsb		;Move name into (R2)
	     restore [r0,r1]
	    else		;Symbol defined - push value instead
	     movd msym_beg,r3
	     addd t_symbl,r3	;Starting address of this module's symbols
	     cmpd r5,r3		;See if from a previous module
	    orif lo		;External if LO
	     movd lmod,r3
	     addqd 1,r3		;Last actual mod number
	     cmpd r3,mod_indx	;See if this is the last one
	     if	lo
	      muld mod_tsiz,r3
	      extsd mod_tabl+4+4+2[r3:b],r3,0,sidx_bit ;1st symbol of next mod
	      addd t_symbl,r3
	      addqd -1,r3		;Testing for LO only
	      cmpd r3,r5
	     endif
	    orif lo
	     extsb (r5),r3,b_typ,2
	     cmpqb lbl_ext,r3
	    orif eq
	     cmpqb lbl_glb,r3
	    orif eq
	     tbitb 2,lnk_prm	;Check for ONEMOD
	     if	fs
	      extsb 1(r5),r3,b_mode-8,4
	      cmpb b'1010,r3	;SB relative
	      if ne		;ONEMOD SB are all undefined external
	       bicpsrb flag_f
	      endif
	     endif
	    orif fs
	     bsr lbl_valu
	    endif
	    addqd 1+sidx_of,r1
	    addqd -1-sidx_of,r0	;Source pointer and count adjusted
	   else
	    movd r0,r4
	    bsr lnk_len		;Get length of data to move in R0
	    addqd 1,r0		;Command counts too
	    subd r0,r4
	    movsb
	    movd r4,r0
	   endif
	  endif
	 endif
	endw
	restore	[r3,r4,r5]
	ret

;Place push command in (R2) based on symbol type in (R5)
;R3 is altered

lbl_valu:
	extsd	1(r5),r3,b_size-8,4
lbl_val1: casew	lbl_val2:b[r3:w]
lbl_val2:
	dw	lv_0-lbl_val1
	dw	lv_1-lbl_val1
	dw	lv_2-lbl_val1
	dw	lv_3-lbl_val1
	dw	lv_4-lbl_val1
	dw	lv_5-lbl_val1
	dw	lv_6-lbl_val1
	dw	lnkerr-lbl_val1
	dw	lnkerr-lbl_val1
;	DW	LV_8-LBL_VAL1
	dw	lnkerr-lbl_val1
	dw	lnkerr-lbl_val1
	dw	lnkerr-lbl_val1
	dw	lv_c-lbl_val1
	dw	lv_d-lbl_val1
	dw	lnkerr-lbl_val1
	dw	lnkerr-lbl_val1

lv_0:
lv_c:	movb	exp blnk_cmd+clnkpshb,(r2)
	movb	2(r5),1(r2)
	addqd	2,r2
	ret

lv_1:	movb	exp blnk_cmd+clnkpshw,(r2)
	movw	2(r5),1(r2)
	addqd	3,r2
	ret

lv_2:
lv_3:
lv_d:	movb	exp blnk_cmd+clnkpshd,(r2)
	movd	2(r5),1(r2)
	addqd	5,r2
	ret

lv_4:	movb	exp blnk_cmd+clnkpshf,(r2)
	movf	2(r5),1(r2)
	addqd	5,r2
	ret

lv_5:
lv_6:	movb	exp blnk_cmd+clnkpshl,(r2)
	movl	2(r5),1(r2)
	addd	9,r2
	ret

lv_8:	movb	exp blnk_cmd+clnkpshs,(r2)
	movmw	2(r5),1(r2),3
	addqd	7,r2
	ret


;Return length of general command data in R0
;R3 is used and not saved

lnk_len:
	extsd	(r1),r3,blnkgcmd,5
lnkl1:	   casew lnkl2:b[r3:w]	
lnkl2:	   word lnkln0-lnkl1	;Push byte
	   word lnkln1-lnkl1	;Push word
	   word lnkln2-lnkl1	;Push Dword
	   word lnkln3-lnkl1	;Push float
	   word lnkln4-lnkl1	;Push long float
	   word lnkln5-lnkl1	;Push value of ASCII label
	   word lnkerr-lnkl1	;Push evaluated expression
	   word lnkerr-lnkl1	;Push value symbol pointed to by offset
	   word lnkln8-lnkl1	;Load PC_PTR with given value + base
	   word lnkln9-lnkl1	;Load PC_PTR with value+base of 1st module
	   word lnklna-lnkl1	;Load R7 pointer with given value + base
	   word lnklnb-lnkl1	;Load R7 with displacement + PCOF
	   word lnklnc-lnkl1	;End of link table
	   word lnklnd-lnkl1	;Push string
	   word lnklne-lnkl1	;Load variable length symbol with descriptor
	   word lnklnf-lnkl1	;New PCOF
	   word lnkln10-lnkl1	;New MOD

	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error
	   word lnkerr-lnkl1	;Link error


lnklnc:				;End of file
lnkln0:	movqd	1,r0		;Push byte
	ret

lnkln10:			;New MOD number
lnkln1:	movqd	2,r0		;Push word
	ret

lnkln2:				;Push Dword
lnkln3:				;Push float
lnklnf:				;New PC offset
	movqd	4,r0
	ret

lnkln4:	movzbd	8,r0		;Push long float
	ret

lnkln5:				;ASCII label
	movzbd	1(r1),r0
	addqd	1,r0		;ASCII label: length, name
	ret

{
lnkln6:				;Expression
	save	[r1,r2,r3,r4]
	addqd	1,r1		;Point to start of expression
	movd	r1,r2
	movqd	-1,r0
	movd	m_delim:d,r3
	movb	trm_exp:#,r4
	skpsb	u		;Find end of expression
	addqd	1,r1		;Skip terminator
	movd	r1,r0
	subd	r2,r0		;Number of bytes in expression
	restore	[r1,r2,r3,r4]
	ret
}

;Push displacement

lnkln8:
lnkln9:
lnklna:
lnklnb:
	save	[r1,r4,r5]
	addqd	1,r1		;Advance to disp.
	movd	r1,r4		;Need pointer in R4
	bsr	r4_disp		;Get value in R5
	movd	r4,r0		;Next byte
	subd	r1,r0		;Length of disp.
	restore	[r1,r4,r5]
	ret

lnklnd:	movqd	6,r0		;Push string
	ret

lnklne:	save	[r1]
	addqd	1,r1		;Advance to symbol
	bsr	lbl_len		;Length of symbol in R0
	extsd	(r1),r1,0,5	;Don't want label length included
	subd	r1,r0		;Just length of value
	restore	[r1]
	ret

;Push byte

lnkpshb:			;Push byte
	movw	exp b_def+h'2400:#,(r5)	;Defined value
	movxbd	(r1),2(r5)
	addqd	1,r1
	br	math_psh:d

;Push word

lnkpshw:
	movw	exp b_def+h'2400:#,(r5)	;Defined value
	movxwd	(r1),2(r5)
	addqd	2,r1
	br	math_psh:d

;Push Dword

lnkpshd:
	movw	exp b_def+h'2400:#,(r5)	;Defined value
	movd	(r1),2(r5)
	addqd	4,r1
	br	math_psh:d

;Push float

lnkpshf:
	movw	exp b_def+h'6400:#,(r5)	;Defined value
	movfl	(r1),2(r5)
	addqd	4,r1
	br	math_psh:d

;Push long

lnkpshl:
	movw	exp b_def+h'6400:#,(r5)	;Defined value
	movmd	(r1),2(r5),2
	addd	8,r1
	br	math_psh:d

;Push string

lnkpshs:
	movw	exp b_def+h'8c00:#,(r5)	;Defined string
	movmw	(r1),2(r5),3
	addqd	6,r1
	br	math_psh:d

;Descriptor/symbol follows, push it

lnkpshv:
	movmw	(r1),(r5),5	;Just copy everything
	inssb	0,(r5),0,5	;Make name length 0
	save	[r0]
	save	[r1]
	movd	r5,r1		;Need 0 name length in (R1)
	bsr	lbl_len		;Length of symbol in R0
	restore	[r1]
	addd	r0,r1
	restore	[r0]
	br	math_psh:d

;Link ASCII value, (R1) = length, pointer

lnkasc:	save	[r0,r2,r3]
	movzbd	(r1),r0
	addqd	1,r1
	movd	msym_beg,tos
	until	fs
	 bsr	gsym2val:d
	quit	ne
	 addr	sidx_of(r2),r5	;Pointer into symbol table
	 addr	sidx_of+1(r2),msym_beg ;Try next symbol if undefined/external
	 tbitb	b_def,sidx_of(r2)
	qend
	 addr	here,r5
	 movw	h'ff00,here
	 cmpb	"L",m_pass
	 if	eq		;Nothing may be undefined on pass L
	  bsr	str_out		;Display label
	  bsr	sym_und1:d	;Undefined message
	 else
	  tbitb 0,lnk_prm
	 orif	fc		;Error if undefineds not external
	 endif
	endu
	movd	tos,msym_beg
	addd	r0,r1		;Advance past name
	restore	[r0,r2,r3]
	br	lnklpt1

;Offset of label follows, add to base of table and push value

lnklpt:
	extsd	(r1),r5,0,sidx_bit
	addqd	sidx_of,r1
	addd	t_symbl,r5	;R5 points to symbol
	tbitb	b_def,(r5)
	if	fc
	 cmpb	"L",m_pass
	 if	eq		;Nothing may be undefined on pass L
	  save	[r0,r1]
	  bsr	lbl_nam		;Pointer to name in R1
	  extsd	(r5),r0,0,5	;Length of symbol name
	  bsr	str_out		;Display label
	  bsr	sym_und1:d	;Undefined message
	  restore [r0,r1]
	 else
	  bispsrb flag_z	;Set EQ
	  tbitb 0,lnk_prm
	  if	fc		;OK if undefineds are external
	   extsb (r5),tos,b_typ,2
	   cmpqb lbl_ext,tos	;Must be declared external
	  endif
	 orif	ne		;Error if not external
	 endif
	endif
lnklpt1:
	movmw	(r5),here,5	;Copy to buffer
	tbitb	b_def,(r5)
	if	fc
	 inssb	lbl_ext,here,b_typ,2
	endif
	save	[r0,r2]
	
	movd	msym_beg,r2
	addd	t_symbl,r2	;Starting address of this module's symbols
	cmpd	r5,r2		;See if from a previous module
	if	lo
	 movd	r5,tos		;Symbol address
	 bsr	set_mod
	 movd	tos,modnum	;Mod number for current symbol
	 inssb	lbl_ext,here,b_typ,2
	 cmpb	"L",m_pass	;Never if final link/install pass
	 if	ne
	  cbitb b_def,here	;These are always undefined if not final pass
	 endif
	else			;See if from a later module
	 movd	lmod,r2
	 addqd	1,r2		;Last actual mod number
	 cmpd	r2,mod_indx	;See if this is the last one
	 if	lo
	  muld	mod_tsiz,r2
	  extsd	mod_tabl+4+4+2[r2:b],r2,0,sidx_bit ;1st symbol of next mod
	  addd	t_symbl,r2
	  addqd	-1,r2		;Testing for LO only
	  cmpd	r2,r5
	 endif
	orif	lo
	 tbitb	2,lnk_prm	;Check for ONEMOD
	 if	fs
	  extsb 1(r5),r2,b_mode-8,4
	  cmpb	b'1010,r2	;SB relative
	  if	ne		;ONEMOD SB are all undefined external
	   bicpsrb flag_f
	  endif
	 endif
	orif	fs
	endif

	restore [r0,r2]
	addr	here,r5		;Buffer holds adjusted value to push
	br	math_psh:d

;Evaluate terminated expression in (R1) and push value

lnkexp:	br	lnkerr

;	BSR	EX
;	ADDQD	1,R1		;Advance past terminator
;	BR	MATH_PSH:D

;Load M_PCPTR with following value (stored as displacement)

lnkadr:
	save	[r4,r5]
	movd	r1,r4		;Need pointer in R4
	bsr	r4_disp		;Get value in R5
	movd	r4,r1		;Pointer updated
	movd	r5,m_pcptr
	restore	[r4,r5]
	ret

;Load R7 with following value (stored as displacement from PCOF)

lnk_ad7:
	save	[r4,r5]
	movd	r1,r4		;Need pointer in R4
	bsr	r4_disp		;Get value in R5
	movd	r4,r1		;Pointer updated
	movd	r5,r7
	restore	[r4,r5]
	addd	pcof,r7
	ret

;Link displacement command at LNKDSP
;Link PC relative value in 2(R5)

lnkpcr:	subd	m_pcptr,2(r5)
lnkdsp:
	save	[r0,r1,r2]
	extsb	(r7),r2,4,4	;Used designated mode
	inssb	r2,1(r5),b_mode-8,4
	cmpd	lmod,modnum	;Adjust for inter-mod offset if different
	if	ne
	 movd	lmod,r0
	 muld	mod_tsiz,r0	;Offset to source mod
	 movd	modnum,r1
	 muld	mod_tsiz,r1	;Offset to target mod
	 cmpb	b'1011,r2	;Check for PC relative
	 if	eq
	  subd	mod_tabl+4+4+2+2*sidx_of+4[r0:b],2(r5) ;Source PC offset
	  addd	mod_tabl+4+4+2+2*sidx_of+4[r1:b],2(r5) ;Target PC offset
	 else
	  cmpb	b'1010,r2	;Check for SB
	  if	eq
	   tbitb 2,lnk_prm	;ONEMOD if FS
	   if	fc
	    subd mod_tabl+4+4+2+2*sidx_of+4+4[r0:b],2(r5) ;Source SB offset
	   else
	    subd mod_tabl+4+4+2+2*sidx_of+4+4,2(r5) ;Use base SB offset
	   endif
	   addd	mod_tabl+4+4+2+2*sidx_of+4+4[r1:b],2(r5) ;Target SB offset
	  endif
	 endif
	else
	 tbitb	2,lnk_prm
	orif	fs
	endif
	restore [r0,r1,r2]
	br	dsp_p2:d

;Link integer or float (LSB, MSB), value in 2(R5), length in R6

lnkint:	inssb	7,1(r5),0,4	;LSB/MSB format
	br	byt_p2:d


;Load PCOF with new value

lnkpcof:
	movd	(r1),pcof
	addqd	4,r1
	ret

;Load MOD with new value

lnkmod:
	save	[r0]
	movzwd	(r1),r0
	addqd	2,r1
	cmpqw	-1,r0		;Increment current module if so
	if	eq
	 movd	lmod,r0
	 addqd	1,r0
	endif
	movd	r0,lmod
	movd	r0,modnum
	muld	mod_tsiz,r0
	extsd	mod_tabl+4+4+2[r0:b],msym_beg,0,sidx_bit ;Symbol base offset
	movd	mod_tabl+4+4+2+2*sidx_of[r0:b],pcof ;New PC offset
	restore	[r0]
	ret

;Link 2nd EXT displacment

lnkex2:
	inssb	4,1(r5),b_mode-8,4 ;Make constant
	br	dsp_p2:d

;Link CXP displacement

lnk_cxp:
	cmpb	"L",m_pass	;Only do this on final link
	if	eq
	 save	[r2]
	 extsb	1(r5),r2,b_mode-8,3
	 cmpqb	b'011,r2	;PC relative
	 if	eq
	  movqb	b'110,r2	;EXT (CXP)
	 endif
	 cmpqb	b'110,r2	;CXP
	 if	eq
	  movd	lmod,tos
	  movw	modnum,tos
	  movb	r2,tos
	  bsr	fnd_link
	 else
	  cmpqb	b'100,r2	;Constant
	 orif	eq
	  bsr	type_err:d
	 endif
	 restore [r2]
	else
	 cbitb	b_def,(r5)	;Wait until final link
	endif

	ret

;Link EXT addressing mode

lnkext1:
	cmpb	"L",m_pass
	if	eq
	 save	[r2]
	 extsb	1(r5),r2,b_mode-8,3
	 cmpqb	b'010,r2	;SB relative
	 if	eq
	  movd	lmod,tos
	  movw	modnum,tos
	  movb	r2,tos
	  bsr	fnd_link
	 else
	  cmpqb	b'011,r2	;PC relative
	 orif	eq
	  cmpqb	b'100,r2	;Constant
	 orif	eq
	  cmpqb	b'101,r2	;Absolute
	 orif	eq
	  bsr	type_err:d
	 endif
	 restore [r2]
	else
	 cbitb	b_def,(r5)
	endif
	ret


;TOS holds address of symbol, return module number on stack

set_mod::
	lproc
adr:	blkd
	reg	[r0,r1,r2,r5]
	code

	movd	adr,r2		;Address of symbol
	subd	t_symbl,r2	;Current offset
	movd	mod_indx,r0	;Mod table count
	addr	mod_tabl+mod_tsiz,r1 ;Pointer to actual tables
	begin
	 cmpqd	1,r0
	quit	eq
	 extsd	4+4+2(r1),r5,0,sidx_bit
	 cmpd	r2,r5
	while	hs
	 addd	mod_tsiz,r1	;Next mod table
	 addqd	-1,r0
	endw
	subd	mod_indx,r0
	negd	r0,r0		;Actual MOD #
	movd	r0,adr

	pend	0


;TOS holds address of PC, return module number on stack

adr_mod::
	lproc
adr:	blkd
	reg	[r0,r1,r2]
	code

	movd	adr,r2		;Address of symbol
	movd	mod_indx,r0	;Mod table count
	addr	mod_tabl+mod_tsiz,r1 ;Pointer to actual tables
	begin
	 cmpqd	1,r0
	quit	eq
	 cmpd	r2,4+4+2+2*sidx_of(r1)
	while	hs
	 addd	mod_tsiz,r1	;Next mod table
	 addqd	-1,r0
	endw
	subd	mod_indx,r0
	negd	r0,r0		;Actual MOD #
	movd	r0,adr

	pend	0

;TOS holds address of SB, return module number on stack

sb2mod::
	lproc
adr:	blkd
	reg	[r0,r1,r2]
	code

	movd	adr,r2		;Address of symbol
	movd	mod_indx,r0	;Mod table count
	addr	mod_tabl+mod_tsiz,r1 ;Pointer to actual tables
	begin
	 cmpqd	1,r0
	quit	eq
	 cmpd	r2,4+4+2+2*sidx_of+4+4(r1)
	while	hs
	 addd	mod_tsiz,r1	;Next mod table
	 addqd	-1,r0
	endw
	subd	mod_indx,r0
	negd	r0,r0		;Actual MOD #
	movd	r0,adr

	pend	0


fnd_link::
	lproc
tmod:	blkd
tmodnum: blkw
val:	blkb
	reg	[r0,r1,r2,r3,r4,r6]
	code
	
	movb	val,r6
	cmpqb	4,r6		;If constant, keep as is
	beq	fndlnkx

	movd	tmod,r2		;Mod table index
	muld	mod_tsiz,r2	;Proper offset
	addr	mod_tabl[r2:b],r1
	addr	4+4(r1),r1	;Last entry offset
	movqd	0,r0		;Index counter
	movw	tmodnum,r2

	begin
	 movzwd	(r1),r3
	 cmpqw	-1,r3
	quit	eq
	 addd	t_cxp,r3	;Absolute pointer to current value
	 extsd	2(r3),r4,0,13	;MOD number
	 cmpw	r4,r2
	 if	eq
	  cmpd	2(r5),4(r3)	;Check values
	  if	eq
	   extsb 3(r3),r4,5,3	;Type of this MOD entry
	   cmpb	r4,r6
	   if	ne		;PC/EXT match if everything else does
	    cmpqb b'110,r4	;EXT matches PC
	    if	eq
	     cmpqb b'011,r6
	    else
	     cmpqb b'011,r4
	     if	eq
	      cmpqb b'110,r6
	      if eq
	       inssb r6,3(r3),5,3 ;PC converts to EXT for BLD_MOD
	      endif
	     endif
	    endif
	   endif
	  endif	
	 endif
	while	ne
	 movd	r3,r1		;Current pointer => last
	 addqd	1,r0
	endw
	cmpqw	-1,r3		;Nothing found if EQ
	if	eq
	 bsr	cxp_spc:d
	 if	fc
	  movd	t_cxpx,r4	;Pointer to new entry
	  movd	2(r5),4(r4)
	  movqw	-1,(r4)
	  movw	r2,2(r4)
	  inssb	r6,3(r4),5,3
	  addd	8,t_cxpx
	  subd	t_cxp,r4	;Offset from beginning
	  movw	r4,(r1)
	 endif
	endif
	movd	r0,2(r5)
fndlnkx:
	movw	exp b_def+h'2400,(r5) ;Defined constant
	bsr	dsp_p2:d

	pend


;Set base addresses in MOD_TABL
;SB follows code, Link table done by BLD_MOD
;Also set up final PC address and move code as needed
;MOD passed on stack

lnk_adr::
	lproc
modadr:	blkd			;Default MOD address
	reg	[r0,r1,r2,r3,r4]
	code

	cmpqd	0,m_errct
	bne	lnk_adrx	;Don't do it if errors occurred

	movqd	0,r3
	addr	mod_tabl,r4
	movd	4+4+2+2*sidx_of(r4),r2 ;Default PC address
	until	eq
	 extsd	4+4+2+sidx_of(r4),r1,0,sidx_bit ;Offset to module name
	 cmpd	sidx_end,r1	;See if defined
	 if	ne
	  addd	t_symbl,r1	;This was undefined external
	  movd	r3,2(r1)
	  inssb	lbl_glb,(r1),b_typ,2
	  sbitb	b_def,(r1)	;Defined global type now
	 endif
	 movd	(r4),r0		;Code size
	 movd	4+4+2+2*sidx_of(r4),r1 ;Source address
	 cmpqd	-1,4+4+2+2*sidx_of+4(r4) ;Requested address
	 if	ne		;Only if address defined
	  movd	4+4+2+2*sidx_of+4(r4),r2 ;New requested address
	 endif
	 cmpd	r1,r2		;See if program requested new code address
	 if	ne		;Program set new code address if NE
	  save	[r0,r2]
	  if	hi		;Forward move if higher
	   movsb
	  else
	   addr -1(r1)[r0:b],r1 ;Last address to move
	   addr -1(r2)[r0:b],r2 ;Last target address
	   movsb b		;Backward move
	  endif
	  restore [r0,r2]
	 endif
	 movd	r2,4+4+2+2*sidx_of(r4) ;New current PC address
	 movd	r2,4+4+2+2*sidx_of+4(r4) ;Current address now official
	 addd	r0,r2		;New default address
	 addd	mod_tsiz,r4
	 addqd	1,r3
	 cmpd	mod_indx,r3
	endu

	movd	r2,r4		;Last PC base address
	addqd	3,r4
	bicb	3,r4		;Next Dword boundary, Starting SB area

	movd	mod_indx,r0
	addr	mod_tabl+4+4+2+2*sidx_of+4+4,r1 ;Address of SB base
	addr	mod_tabl,r2	;Table base address
	movd	modadr,r3	;Default MOD table address
	begin			;Do SB blocks 1st
	 cmpqd	0,r0
	while	ne
	 cmpqd	-1,(r1)		;Don't alter if not undefined
	 if	eq
	  movd	r4,(r1)
	 endif
	 movd	(r1),r4		;Current base
	 addd	4(r2),r4	;Size of this table
	 addqd	3,r4
	 bicb	3,r4		;Next Dword boundary
	 cmpqd	-1,4(r1)	;MOD address
	 if	eq
	  movd	r3,4(r1)	;MOD address
	 endif
	 movd	4(r1),r3
	 cmpqd	-1,r3
	 if	ne
	  addd	16,r3		;Next MOD address
	 endif
	 addd	mod_tsiz,r1
	 addd	mod_tsiz,r2
	 addqd	-1,r0
	endw

lnk_adrx:
	pend


;Build mod table and link table in memory according to MOD_TABL
;Default link table address follows last SB

bld_mod::
	cmpqd	0,m_errct
	bne	return		;Don't do it if errors occurred
	save	[all]
	movd	mod_indx,r0	;Count
	addr	mod_tabl,r1	;Source address
	movd	r0,r2
	addqd	-1,r2
	muld	mod_tsiz,r2	;Offset to last entry
	addr	mod_tabl[r2:b],r2 ;R2 points to last module table
	movd	4+4+2+2*sidx_of+4+4(r2),r4 ;SB base address
	cmpqd	-1,r4
	if	ne
	 addd	4(r2),r4	;Next available address
	 addqd	3,r4
	 bicb	3,r4		;Round up to next Dword
	endif
	begin
	 cmpqd	0,r0
	while	ne
	 movd	4+4+2+2*sidx_of+4+4+4(r1),r2 ;Address of MOD table
	 cmpqd	-1,r2		;Undefined if -1
	 if	ne
	  movd	4+4+2+2*sidx_of+4+4(r1),(r2) ;SB address
	  movd	4+4+2+2*sidx_of+4+4+4+4(r1),r3 ;Link address
	  cmpqd	-1,r3
	  if	ne
	   movd	r3,r4		;Use this if defined
	  endif
	  movd	r4,4+4+2+2*sidx_of+4+4+4+4(r1) ;Link address
	  movd	r4,4(r2)	;Link address
	  movd	4+4+2+2*sidx_of+4(r1),8(r2) ;PC address
	  movqd	0,12(r2)	;Unused
	  cmpqd -1,r4
	  if	ne		;Invalid address if -1
	   addr	4+4(r1),r3	;Address of CXP/EXT table
	   begin
	    movzwd (r3),r3	;Offset to next entry
	    cmpqw -1,r3
	   while ne
	    addd t_cxp,r3	;Address of entry
	    extsd 2(r3),r5,0,13	;Module number to R5
	    muld mod_tsiz,r5
	    addr mod_tabl[r5:b],r5 ;R5 points to proper table
	    extsb 3(r3),r6,5,3	;Type
	    movd 4(r3),(r4)	;Value
	    cmpqb b'010,r6	;Check for SB type
	    if	eq
	     addd 4+4+2+2*sidx_of+4+4(r5),(r4) ;Add SB offset
	    else
	     cmpqb b'011,r6	;PC type
	     if	eq
	      addd 4+4+2+2*sidx_of+4(r5),(r4) ;Add PC offset
	     else
	      cmpqb b'110,r6	;CXP (external) type
	      if eq
	       lshd 16,(r4)	;Offset to upper 16 bits
	       movw 4+4+2+2*sidx_of+4+4+4(r5),(r4) ;Module address
	      endif
	     endif
	    endif
	    addqd 4,r4		;Next link table entry
	   endw
	  endif
	 endif
	 addd	mod_tsiz,r1	;Next module
	 addqd	-1,r0		;Decrement count
	endw
	restore	[all]
	ret


;Prepare link data for new field
;Terminate any currently active literal code string

lnkfldchk::
	ret

;Link data field with address passed on stack
;1st byte is length, link buffer must contain enough room

link_fld::
	lproc
lflbl:	blkb	4		;Address of link data
	reg	[r0,r1,r2]
	code
	movd	lflbl,r1	;Source address
	movzbd	(r1),r0
	addqd	1,r1		;Address of actual data
	movd	m_lnkptr,r2	;Target address
	movsb
	movd	r2,m_lnkptr
	pend

lnkerr::
	addqd	1,m_errct
	sbitb	31,m_errct	;Force abort now
	bsr	dsp_msg
	byte	"Link table error",cr,lf,0
	ret


;Load current code/link data from disk device
;Module/execution offset returned on stack

rd_link::
	lproc
indx:	blkd			;Module number
modpc:	blkd			;Target PC address
	reg	[all]
pc_next: blkd			;Next PC code address
tmod:	blkd			;Starting mod for linker
pc_base: blkd			;Starting PC address for linker
	code

	movd	modpc,r7
	movd	r7,pc_next	;Starting address for code
	movd	r7,pc_base	;Starting PC for linker
	movd	mod_indx,r4
	movd	r4,tmod		;Starting mod for linker
	muld	mod_tsiz,r4
	addr	mod_tabl[r4:b],r4 ;Current MOD table data

	movqd	-1,indx
	movqd	-1,modpc	;Invalid mod/offset

	until	eq		;Go until all modules processed
	 movd	mod_indx,lmod
	 addqd	1,mod_indx	;1 more MOD entry
	 movmd	dhd_mod(r7),(r4),2 ;PC and SB size
	 movqw	-1,4+4(r4)	;Link table offset (none yet)
	 movd	tsym_end,r5
	 movd	r5,msym_end	 ;Initialize end of current mod's symbols
	 extsd	4+4+2(r4),msym_beg,0,sidx_bit ;Default to preset value

	 extsd	4+4+2+sidx_of(r4),r0,0,sidx_bit
	 cmpd	sidx_end,r0
	 if	eq		;If name specified, then symbols start there
	  subd	t_symbl,r5
	  movd	r5,msym_beg	 ;Initialize start of current mod's symbols
	  inssd	r5,4+4+2(r4),0,sidx_bit ;Offset to this mod's symbols
	  cmpqb	0,4+32(r7)	;See if module name specified
	  if	ne
	   movzbd 4+32(r7),r0	;Length of name
	   addr	4+32+1(r7),r1	;Pointer to name
	   bsr	gsym2val	;See if found
	   if	eq
	    bsr	str_out		;Display label
	    bsr	dup_sym:d	;Duplicate symbol
	   else
	    movb r0,tos		;Length of name
	    movw h'2400+lbl_ext lsh b_typ,tos ;External undefined integer
	    movd r1,tos		;Pointer to name
	    movd r3,tos		;Address of previous symbol
	    bsr	make_sym:d	;New symbol
	    inssd m_symadr,4+4+2+sidx_of(r4),0,sidx_bit ;Offset to mod name
	   endif
	  endif
	 endif
	 
	 movd	pc_next,4+4+2+2*sidx_of(r4) ;Source code will start here
	 addd	(r4),pc_next	;Address for next block
	 addr	4+4+2+2*sidx_of+4(r4),r2 ;Target PC absolute address
	 addr	dhd_mod+4+4+4(r7),r1 ;Source address
	 movqb	4,r0		;Number of entries to move
	 until	eq
	  cmpqd	-1,(r2)
	  if	eq		;Address set by LINK pseudo-op takes priority
	   movd	(r1),(r2)
	  endif
	  addqd	4,r1
	  addqd	4,r2
	  addqb	-1,r0
	  cmpqb	0,r0
	 endu			;PC,SB,MOD,LINK absolute addresses moved
	 cmpd	dhd_stk(r7),m_stksiz
	 if	gt
	  movd	dhd_stk(r7),m_stksiz ;Use largest size
	 endif
	 cmpqd	0,m_stksiz+4	;This takes priority if defined
	 if	eq
	  movd	dhd_stk+4(r7),m_stksiz+4
	 endif
	 cmpqd	-1,dhd_stk+8(r7) ;Offset to execution address
	 if	ne
	  movd	mod_indx,indx
	  addqd -1,indx		;Mod for execution
	  movd	dhd_stk+8(r7),modpc ;Execution offset
	 endif

;Load symbols now
	 
	 save	[r4,r6,r7]
	 movd	dhd_pc(r7),r4	;Address of symbols
	 addd	r7,r4
	 movd	dhd_pc+4(r7),r6	;Size of symbol data
	 addd	r4,r6		;Next address
	 begin
	  cmpd	r4,r6
	 while	lo		;Still symbols coming if LO
	  extsd	(r4),r0,0,5	;Length of symbol name
	  movd	r4,r5
	  bsr	lbl_nam		;Pointer to name in R1
	  bsr	gsym2val	;See if found
	  if	eq
	   bsr	str_out		;Display label
	   bsr	dup_sym:d	;Duplicate symbol
	  else
	   movb	r0,tos		;Length of name
	   movw	(r4),tos	;Type and size
	   movd	r1,tos		;Pointer to name
	   movd	r3,tos		;Address of previous symbol
	   bsr	make_sym:d	;New symbol
	   movd	m_symadr,r2
	   addd	t_symbl,r2	;Pointer to symbol
	   movd	r4,r1
	   bsr	lbl_len		;Get length in R0
	   movsb		;Copy all data into place
	   extsb 1(r4),r5,b_size-8,4
	   cmpb	b'1000,r5	;Check for string
	   if	eq		;R1 points to string data if EQ
	    movd m_symadr,tos	;Offset to symbol
	    movzwd 2(r4),tos	;Length to store
	    movd r1,tos		;Starting address to store
	    bsr	str_lbl:d	;Store string
	   endif
	  endif
	  movd	r4,r1
	  bsr	lbl_len
	  addd	r0,r1		;Skip over symbol
	  extsb 1(r4),r5,b_size-8,4
	  cmpb	b'1000,r5	;Check for string
	  if	eq		;R1 points to string data if EQ
	   movzwd 2(r4),r0
	   addd	r0,r1		;Skip over string
	  endif
	  movd	r1,r4		;New pointer to R4
	  cmpd	max_err,m_errct	;If max errors then quit now
	 quit	lo
	 endu
	 restore [r4,r6,r7]
	 
	 cmpd	max_err,m_errct	;If max errors then quit now
	quit	lo
	 
;Now do T_SYMLNK data if present

	 save	[r4,r6,r7]
	 movd	dhd_pc+5*8(r7),r4 ;Address of disassembler data
	 addd	r7,r4
	 movd	dhd_pc+5*8+4(r7),r6 ;Size of disassembler data
	 addd	r4,r6		;Next address
	 movd	sidx_end,t_symfp ;Nothing here so far
	 movd	sidx_end,m_fpofst ;Nothing here yet
	 begin
	  cmpd	r4,r6
	 while	lo		;Still symbols coming if LO
	  cmpb	h'2e,1(r4)	;Check for T_SYMLNK entry
	  if	eq
	   movqd 0,tos		;Create room for returned entry
	   bsr	last_lnk:d	;Get next link table address
	   movd	tos,r3
	   movb	9,tos		;9 byte name
	   movw	(r4),tos
	   addr	2+4(r4),tos	;Pointer to name
	   movd	r3,tos		;Previous symbol pointer
	   bsr	make_sym
	   movd m_symadr,r2
	   addd t_symbl,r2	;Pointer to symbol
	   movd	t_symfp,2+4+1(r2) ;T_SYMFP index
	   movd	m_fpofst,2+4+1+4(r2) ;M_FPOFST index
	   movd 2(r4),2(r2)	;Store PC value
	   movd	sidx_end,t_symfp ;New table starting
	   movd sidx_end,m_fpofst ;Start over here too
	  else
	   extsd (r4),r0,0,5	;Length of symbol name
	   movd	r4,r5
	   bsr	lbl_nam		;Pointer to name in R1
	   bsr	gsym2val	;See if found
	   if	eq
	    bsr	str_out		;Display label
	    bsr	dup_sym:d	;Duplicate symbol
	   else
	    extsb (r4),r5,b_typ,2
	    cmpb lbl_tmp,r5	;See if local or general table
	    if	eq
	     inssb lbl_nrm,(r4),b_typ,2 ;Back to normal label type
	     addr t_symfp,r3
	     bsr sym2sub	;Set R2/R3 for local FP storage
	    endif
	    movb r0,tos		;Length of name
	    movw (r4),tos	;Type and size
	    movd r1,tos		;Pointer to name
	    movd r3,tos		;Address of previous symbol
	    bsr make_sym:d	;New symbol
	    movd m_symadr,r2
	    cmpd sidx_end,m_fpofst
	    if	ls
	     addr -sidx_of(m_symadr),m_fpofst ;Labels start here
	    endif
	    addd t_symbl,r2	;Pointer to symbol
	    movd 2(r4),2(r2)
	   endif
	  endif
	  movd	r4,r1
	  bsr	lbl_len
	  addd	r0,r4		;Skip over symbol
	  cmpd	max_err,m_errct	;If max errors then quit now
	 quit	lo
	 endu
	 restore [r4,r6,r7]
	 
	 cmpd	max_err,m_errct	;If max errors then quit now
	quit	lo
	 
	 movd	dhd_pc+3*8(r7),r3 ;Offset to link data
	 movd	dhd_stk+8+4(r7),r5 ;Offset to next header
	 movd	(r4),r0		;Size of PC data
	 movd	r7,r1		;Base address
	 addd	dhd_pc+2*8(r7),r1 ;Offset to PC code
	 movd	4+4+2+2*sidx_of(r4),r2 ;Target address
	 movsb			;Move into place
	 cmpqd	-2,r3		;-1=none, -2=All data in last module
	 if	hi
	  addd	r7,r3		;Absolute address
	  movd	r3,tos		;Pointer to link data
	  movd	pc_base,tos	;Code address
	  movd	pc_base,tos	;PC_OFST
	  movd	tmod,lmod	;Starting mod
	  bsr	do_link		;Link
	  movb	exp blnk_cmd+clnk_end,(m_lnkptr) ;Terminate new link data
	  movd	mod_indx,tmod	;New base mod
	  movd	pc_next,pc_base	;New base address
	 endif
	 cmpd	max_err,m_errct	;If max errors then quit now
	quit	lo
	 addd	mod_tsiz,r4
	 movd	sidx_end,4+4+2+sidx_of(r4) ;MOD name padded with 0s
	 movqd	-1,4+4+2+2*sidx_of+4(r4) ;PC address
	 movqd	-1,4+4+2+2*sidx_of+4+4(r4) ;SB address
	 movqd	-1,4+4+2+2*sidx_of+4+4+4(r4) ;MOD address
	 movqd	-1,4+4+2+2*sidx_of+4+4+4+4(r4) ;LINK address
	 addd	r5,r7		;Pointer to next module header
	 cmpqd	-1,r5
	endu			;All modules done

	pend	0

;End of LNK32
