	print	"INI32"

	extundf	y
	disp	1

;System Initialization

code::
	cond	not debug
	 jump	@eprom+(hdw_rst-$):d ;Jump to EPROM (2+4 bytes)
	 dw	0		;Pad to 8 bytes
	celse
	 br	hdw_rst:d	;1+4 bytes
	 db	0,0,0		;Pad to 8 bytes
	cend

	dd	ver_num		;Version number

;---------------------------------
; Power on hardware reset routines
;---------------------------------

hdw_rst:			;Do required hardware setup
	cond	not debug	;Don't mess with this if debugging
	 cond	cg16_edb
	  addr	@h'f400e0,r4	;LEDs
	  movb	h'22,(r4)	;LED DS2 off, /Shadow high
	  extsd	switch,r5,0,2	;DRAM jumpers
	  movd	dram_dat:w[r5:d],r5 ;Read initialization data
	  movqb	0,0(r5)		;Initialize DRAM controller
	  movb	h'23,(r4)	;/ML high now too
	  movd	2000,r5		;60ms delay required by DRAM controller
	  acbd	-1,r5,*+0
	  movd	1000,r5
	  movw	0(r5),0(r5)
	  acbd	-1,r5,*-4
	 celse
	  movqb	4,serial1+4*bus_byts ;Clear overlay bit
	 cend
	cend

;-----------------------------------
; General re-initialization routines
; Reset all CPU registers
; Setup register configuration
;-----------------------------------

code1::
	cond	not debug	;Don't change registers if debugging
	 bicpsrw h'fff		;Everything off now
	 cond	cpu032
	  setcfg []
	 cend
	 cond	cpu532
	  lprd	cfg,0
	 cend
	 lprd	sb,mon_sb
	 bispsrw flag_s		;Select user stack
	 lprd	sp,mon_spu
	 bicpsrw flag_s		;Now force supervisor stack
	 lprd	sp,mon_sps
	 lprd	intbase,mon_int
	 lprw	mod,mon_mod
	cend

	movd	heap_last-mon_sb,-4(sb) ;Size of block
	cond	op_sys
	 movd	last_mod-mon_mod,@mon_mod-4 ;Size of MOD table memory
	cend

	movd	cfg_dat,r7	;Config register value
	cond	cg16_edb
	 cbitb	cfg_f,r7	;Assume no FPU for now
	 if	fs		;No check if not wanted
	  extsb	switch,r5,2,2	;FPU jumpers
	  cmpqb	3,r5		;Both jumpers open if EQ
	  if	ne		;FPU installed if NE
	   sbitb cfg_f,r7	;Enable FPU instructions
	  endif
	 endif
	cend
	cond	dk_532
	 cbitb	cfg_f,r7	;Assume no FPU for now
	 if	fs
	  tbitb	6,switch	;1 if FPU installed
	  if	fs
	   sbitb cfg_f,r7
	  endif
	 endif
	cend
	 
;---------------------------------------------
; Reset entry point if all registers are ready
; R7 holds CFG register setting
;---------------------------------------------

reset::
	save	[r0,r1,r2,r3]	;These may hold useful information after reset
	cond	cpu532
	 cinv	a,i,d,r0	;Clear everything
	cend

	sprd	intbase,r1	;Target
	cond	not debug
	 movzbd	32-1,r0		;16 CPU traps, 16 interrupt vectors
	 addr	4(r1),r2
	 movqd	-1,(r1)
	 movsd			;Fill with -1 to invalidate
	celse
	 cond	svc_cxp
	  movqd	-1,4*5(r1)	;SVC address always initialized
	 cend
	cend

;Initialize supervisor routine
;r7 holds CFG register setting

	addr	dev_cmd:w,r1	;Address of initialization data
	addr	svc:w,r0	;Offset of service routines
	addr	svc:w,r5
	addd	svc_init-svc(r5),r5
	jsr	r5

	sprw	psr,tos		;Debugger PSR
	cond	op_sys
	 movqw	-1,r0
	celse
	 sprw	mod,r0
	 addd	dbg_mod-mon_mod,r0 ;Relative to SVC mod if debugging
	cend
	movw	r0,tos		;Debugger's MOD address
	addr	svc:w,r0
	addd	svc_last-svc(r0),r0 ;Offset to debugger
	movd	r0,tos		;PC address
	addr	tos,r4		;Parameter pointer
	movd	dc_dbgadr,r5
	movd	dev_op+dof_cmd lsh b_iosrv:#,r6
	cond	svc_cxp
	 svc
	celse
	 sprw	mod,tos
	 bsr	svc		;Simulate CXP
	cend
	adjspb	-4-2-2		;Clear stack

	restore	[r0,r1,r2,r3]
;	cond	op_sys
;	 br	buftest:d
;	celse
	 movd	dc_prgd,r5	;Call debugger
	 movd	dev_op+dof_cmd lsh b_iosrv:#,r6
	 cond	svc_cxp
	  svc
	 celse
	  sprw	mod,tos
	  bsr	svc		;Simulate CXP
	 cend
;	cend

	cond	cg16_edb
dram_dat:			 ;Init data for DRAM controller
	 dd	h'004F501c,h'0037501c,h'004F51b2,h'003751b2
	cend


;;Physical data block initialization macro
devpdat	macro	size,io,kv,ptcl,bsz,next
	 dw	size		;;Size of data block
	 cond	size ne 0	;;Use parent block if size = 0
	  dw	dat_size-2	;;Size of following initialization data
	  dw	0		;;Current column
	  dw	0		;;Current line
	  dw	0		;;Current page
	  dw	0		;;Current attributes
	  dw	chr_xsiz	;;Character x dimension in pixels
	  dw	chr_ysiz	;;Character y dimension in pixels
	  dd	ptcl		;;Protocol
	  dd	0		;;Smoc
	  db	dev_&io		;;Corresponding IO device
	  db	dev_&kv		;;Corresponding keyboard/video device
	  dd	bsz		;;Buffer pointer
	  cond	bsz eq 0
	   dd	0		;;Buffer size
	  celse
	   dd	bsz-1		;;Buffer size
	  cend
	  dd	0,0,0		;;Character count, R/W indexes
	  dd	next		;;Size of temporary line buffer
	 cend
	mend

;;Virtual data block initialization macro
devvdat	macro	siz,maxc,maxl
	 dw	siz
	 cond	siz ne 0	;;Use parent block if 0
	  dw	vdt_max-2	;;Size of initialization data
	  dw	0,0		;;Min column/row
	  dw	maxc,maxl	;;Max column/row
	  dd	0		;;Tab, CR, etc.
	 cend
	mend

;;Service routine initialization macro
devexe	macro	dev
	 dd	-1		;;Default command processor
	 irp	adr,blk,chr,sst,sio,stat,io
	  cond	$<dev> eq $<-1>
	   dd	-1		;;Parent routine if -1
	  celse
	   dd	dev!_&adr-svc	;;Unique routines here
	  cend
	 mend
	 dd	retrn-svc	;;Error routine
	 dd	retrn-svc	;;Int routine
	mend

;---------------------------
; Device initialization data
;---------------------------

dev_cmd:
	db	dev_max		;Number of defined devices
d_cnt	set	0		;Device count

dev_nul:: equ	d_cnt
	db	dev_nul,dev_nul	;Allocated device, parent device
	db	dof_max, "Null_Out", 0 ;Device name
	devpdat	dat_size,nul+1,nul+1,0,0,40
	devvdat	vdt_max,0,0
	dd	(nlo_cdatx-nlo_cdat)/4 ;Number of commands
	devexe	nlo
nlo_cdat:
	dd	dc_datb		;Return data pointer
	dd	dc_vdatb	;Return virtual data pointer
	dd	dc_r1		;Output r1, byte count in r0 via _sio
	dd	dc_dspasc	;Display r4 as ASCII with attributes
	dd	dc_getxy	;Get current xy pixel coordinates
	dd	dc_setxy	;Set new xy pixel coordinates
	dd	dc_getchr	;Get current character coordinates
	dd	dc_setchr	;Set new character coordinates
	dd	dc_relxy	;Set relative xy pixel coordinates
	dd	dc_relchr	;Set relative character coordinates
	dd	dc_vct		;Reroute
	dd	dc_unvct	;Un-reroute
	dd	dc_instnc	;Create new instance
	dd	dc_getr7	;Return r7 in r5
	dd	dc_putr7	;Install r4 as new r7
	dd	dc_open		;Open
	dd	dc_close	;Close
	dd	dc_lock		;Lock dat_next block
	dd	dc_unlok	;Unlock dat_next block
	dd	dc_binon	;Set binary file type
	dd	dc_binoff	;Binary type off
	dd	dc_binget	;Return binary file selection
nlo_cdatx:
	dd	-1		;Default default routine
	dd	nlo_cdatb-svc
	dd	nlo_cvdatb-svc
	dd	nlo_r1-svc
	dd	nlo_dspasc-svc
	dd	nlo_cgetxy-svc
	dd	nlo_csetxy-svc
	dd	nlo_cgetchr-svc
	dd	nlo_csetchr-svc
	dd	nlo_crelxy-svc
	dd	nlo_crelchr-svc
	dd	nlo_cvct-svc
	dd	nlo_cunvct-svc
	dd	nlo_cinstnc-svc
	dd	nlo_cgetr7-svc
	dd	nlo_cputr7-svc
	dd	nlo_copen-svc
	dd	nlo_cclose-svc
	dd	nlo_lock-svc
	dd	nlo_unlok-svc
	dd	nlo_binon-svc
	dd	nlo_binoff-svc
	dd	nlo_binget-svc
d_cnt	set	d_cnt+1

	db	dev_nul+1,dev_nul ;Allocated device, parent device
	db	dof_max, "Null_In", 0 ;Device name
	devpdat	dat_size,nul,nul,0,0,40
	devvdat	vdt_max,0,0
	dd	(nli_cdatx-nli_cdat)/4
	devexe	nli
nli_cdat:
	dd	dc_r1		;Input r1, byte count in r0 via _sio
	dd	dc_open		;Open
	dd	dc_close	;Close
	dd	dc_eof
nli_cdatx:
	dd	-1		;Default default routine
	dd	nli_r1-svc
	dd	nli_copen-svc
	dd	nli_cclose-svc
	dd	nli_ceof-svc
d_cnt	set	d_cnt+1

dev_op:: equ	d_cnt
	db	dev_op,dev_op	;Allocated device, parent device
	db	dof_max, "Op_Sys", 0 ;Device name
	devpdat	dat_size,op+1,op+1,0,0,40
	devvdat	vdt_max,0,0
	dd	(opo_cdatx-opo_cdat)/4
	devexe	nlo
opo_cdat:
	dd	dc_init
	dd	dc_svcad
	dd	dc_devad
	dd	dc_setcfg
	dd	dc_getcfg
	dd	dc_fpu
	dd	dc_push
	dd	dc_pop
	dd	dc_prgd
	dd	dc_dbgadr
	dd	dc_trpadr
	dd	dc_trpsb
	dd	dc_sbptr
	cond	op_sys
	 dd	dc_newbf
	 dd	dc_clrbf
 	 dd	dc_sizbf
	 dd	dc_lonbf
	 dd	dc_lofbf
	 dd	dc_uonbf
	 dd	dc_uofbf
	 dd	dc_prgx
	cend
opo_cdatx:
	dd	-1		;Default default routine
	dd	opo_cinit-svc	;Initialization
	dd	opo_csvcad-svc	;SVC absolute address
	dd	opo_cdevad-svc	;DEV_PTR contents
	dd	opo_setcfg-svc	;Set new CFG value
	dd	opo_getcfg-svc	;Return CFG setting
	dd	opo_fpu-svc	;Return FPU type
	dd	opo_push-svc	;Push onto parameter stack
	dd	opo_pop-svc	;Pop from parameter stack
	dd	opo_prgd-svc	;Call debugger
	dd	opo_dbadr-svc	;Set debugger entry point
	dd	opo_tpadr-svc	;Set trap vector
	dd	opo_trpsb-svc	;Return trapped SB
	dd	opo_sbptr-svc	;Set SB pointer for trap in r5
	cond	op_sys
	 dd	opo_newbf-svc	;Define new buffer
	 dd	opo_clrbf-svc	;Clear buffer
	 dd	opo_bufsz-svc	;Set new size
	 dd	opo_lonbf-svc	;Lock on
	 dd	opo_lofbf-svc	;Lock off
	 dd	opo_uonbf-svc	;In use on
	 dd	opo_uofbf-svc	;In use off
	 dd	opo_cprgx-svc	;Exit to Kotekan operating system
	cend
d_cnt	set	d_cnt+1

	db	dev_op		;Op_Sys_In same as Op_Sys_out
d_cnt	set	d_cnt+1

dev_smv:: equ	d_cnt
	db	dev_smv,dev_nul	;Allocated device, parent device
	db	dof_max, "SystemVideoOut", 0 ;Device name
	cond	vid340
	 devpdat serdat_size,smv+1,smk+1,<exp bdp_xof+exp bdp_cts>,128,40
	celse
	 devpdat serdat_size,smv+1,smk+1,<exp bdp_xof>,128,40
	cend
	devvdat	vdt_max,vid_xsiz-1,vid_ysiz-1
	dd	(s1o_cdatx-s1o_cdat)/4
	dd	-1		;Command processor
	dd	-1
	dd	s1o_chr-svc
	dd	s1o_sst-svc
	dd	s1o_sio-svc
	cond	vid_s1
	 dd	s1o_stat-svc
	 dd	s1o_io-svc
	celse
	 dd	s2o_stat-svc
	 dd	s2o_io-svc
	cend
	dd	-1,-1		;Err, int routines same as parent
s1o_cdat:
	dd	dc_init
	dd	dc_baud
	dd	dc_open
	dd	dc_close
	dd	dc_eof
	dd	dc_gwin
	dd	dc_gchmx
	dd	dc_cls
	dd	dc_cur
	dd	dc_atr
	dd	dc_nwn		;Set new window character size
	dd	dc_putr7	;Switch windows
	cond	op_sys
	cend
s1o_cdatx:
	dd	-1		;Default default routine
	cond	vid_s1
	 dd	s1o_cinit-svc
	 dd	s1o_baud-svc
	celse
	 dd	s2o_cinit-svc
	 dd	s2o_baud-svc
	cend
	dd	s1o_copen-svc
	dd	s1o_cclose-svc
	dd	s1o_ceof-svc
	dd	s1o_cgwin-svc
	dd	s1o_cgchmx-svc
	dd	s1o_ccls-svc
	dd	s1o_ccur-svc
	dd	s1o_catr-svc
	dd	s1o_cnwn-svc
	dd	s1o_cputr7-svc
	cond	op_sys
	cend
d_cnt	set	d_cnt+1

	db	dev_smv+1,dev_nul+1 ;Allocated device, parent device
	db	dof_max, "SystemVideoIn", 0 ;Device name
	cond	vid340
	 devpdat serdat_size,smv,smv,<exp bdp_cts>,128,40
	celse
	 devpdat serdat_size,smv,smv,<exp bdp_xof>,256,40
	cend
	devvdat	vdt_max,0,0
	dd	(s1i_cdatx-s1i_cdat)/4
	dd	-1		;Command processor
	dd	-1		;Block
	dd	-1
	dd	s1i_sst-svc
	dd	-1
	cond	vid_s1
	 dd	s1i_stat-svc
	 dd	-1
	 dd	-1
	 dd	s1i_int-svc
	celse
	 dd	s2i_stat-svc
	 dd	-1
	 dd	-1
	 dd	s2i_int-svc
	cend
s1i_cdat:
	dd	dc_baud
	dd	dc_open
	dd	dc_close
	dd	dc_on
	dd	dc_off
	dd	dc_xlat
s1i_cdatx:
	dd	-1		;Default default routine
	cond	vid_s1
	 dd	s1o_baud-svc	;Set baud rate to value in R0
	celse
	 dd	s2o_baud-svc	;Set baud rate to value in R0
	cend
	dd	s1i_copen-svc
	dd	s1i_cclose-svc
	dd	s1i_on-svc	;Device on
	dd	s1i_off-svc	;Device off
	dd	s1i_cxlat-svc
d_cnt	set	d_cnt+1

dev_smk:: equ	d_cnt
	cond	kbdibm
	 db	dev_smk,dev_nul	;Allocated device, parent device
	 db	dof_max, "SystemKeyOut", 0 ;Device name
	 devpdat dat_size,smk+1,smk+1,<exp bdp_xof>,0,40
	 devvdat vdt_max,0,0
	 dd	(sko_cdatx-sko_cdat)/4
	 dd	-1		;Command processor
	 dd	-1		;Block
	 dd	-1		;Chr
	 dd	kbo_sst-svc
	 dd	kbo_sio-svc
	 dd	kbo_stat-svc
	 dd	kbo_io-svc
	 dd	-1,-1		;Err, int routines same as parent
sko_cdat:
	 dd	dc_init
	 dd	dc_led
sko_cdatx:
	 dd	-1
	 dd	kbo_cinit-svc
	 dd	kbo_cled-svc	;Set LED status
	celse
	 db	dev_smv		;Just use video device
	cend
d_cnt	set	d_cnt+1

	cond	kbdibm
	 db	dev_smk+1,dev_nul+1 ;Allocated device, parent device
	 db	dof_max, "SystemKeyIn", 0 ;Device name
	 devpdat keydat_size,smk,smv,<exp bdp_xof>,32,40
	 devvdat vdt_max,0,0
	 dd	(ski_cdatx-ski_cdat)/4
	 dd	-1		;Command processor
	 dd	-1		;Block
	 dd	-1		;Chr
	 dd	kbi_sst-svc
	 dd	-1
	 dd	kbi_stat-svc
	 dd	kbi_io-svc
	 dd	-1
	 dd	kbi_int-svc	;Interrupt service routine
ski_cdat:
	 dd	dc_xlat
ski_cdatx:
	 dd	-1
	 dd	ski_cxlat-svc
	celse
	 db	dev_smv+1	;Just use video device
	cend
d_cnt	set	d_cnt+1

dev_sev:: equ	d_cnt
	db	dev_smv
d_cnt	set	d_cnt+1
	db	dev_smv+1
d_cnt	set	d_cnt+1

dev_sek:: equ	d_cnt
	db	dev_smk
d_cnt	set	d_cnt+1
	db	dev_smk+1	;System error devices same as message device
d_cnt	set	d_cnt+1

dev_pmv:: equ	d_cnt
	cond	cg16_edb
	 db	dev_smv
	celse
	 db	dev_pmv,dev_smv	;Allocated device, parent device
	 db	dof_max, "ProgramVideoOut", 0 ;Device name
	 devpdat serdat_size,pmk+1,pmk+1,<exp bdp_xof>,128,40
	 devvdat vdt_max,vid_xsiz-1,vid_ysiz-1
	 dd	(s2o_cdatx-s2o_cdat)/4
	 dd	-1		;Command processor
	 dd	-1,-1,-1,-1	;Blk, chr, sst, sio routines same as parent
	 cond	vid_s1
	  dd	s2o_stat-svc
	  dd	s2o_io-svc
	 celse
	  dd	s1o_stat-svc
	  dd	s1o_io-svc
	 cend
	 dd	-1,-1		;Err, int routines same as parent
s2o_cdat:
	 dd	dc_init
	 dd	dc_baud
s2o_cdatx:
	 dd	-1		;Default default routine
	 cond	vid_s1
	  dd	s2o_cinit-svc
	  dd	s2o_baud-svc
	 celse
	  dd	s1o_cinit-svc
	  dd	s1o_baud-svc
	 cend
	cend
d_cnt	set	d_cnt+1

	cond	cg16_edb
	 db	dev_smv+1
	celse
	 db	dev_pmv+1,dev_smv+1 ;Allocated device, parent device
	 db	dof_max, "ProgramVideoIn", 0 ;Device name
	 devpdat serdat_size,pmv,pmv,<exp bdp_xof>,256,40
	 devvdat vdt_max,0,0
	 dd	(s2i_cdatx-s2i_cdat)/4
	 dd	-1		;Command processor
	 dd	-1,-1,-1,-1	;Blk, chr, sst, sio routines same as parent
	 cond	vid_s1
	  dd	s2i_stat-svc
	  dd	-1
	  dd	-1
	  dd	s2i_int-svc
	 celse
	  dd	s1i_stat-svc
	  dd	-1
	  dd	-1
	  dd	s1i_int-svc
	 cend
s2i_cdat:
	 dd	dc_baud
s2i_cdatx:
	 dd	-1		;Default default routine
	 cond	vid_s1
	  dd	s2o_baud-svc	;Set baud rate to value in R0
	 celse
	  dd	s1o_baud-svc	;Set baud rate to value in R0
	 cend
	cend
d_cnt	set	d_cnt+1

dev_pmk:: equ	d_cnt
	cond	cg16_edb
	 db	dev_smk
	celse
	 db	dev_pmv
	cend
d_cnt	set	d_cnt+1

	cond	cg16_edb
	 db	dev_smk+1
	celse
	 db	dev_pmv+1
	cend
d_cnt	set	d_cnt+1

dev_pev:: equ	d_cnt
	db	dev_pmv
d_cnt	set	d_cnt+1
	db	dev_pmv+1
d_cnt	set	d_cnt+1

dev_pek:: equ	d_cnt
	db	dev_pmk
d_cnt	set	d_cnt+1
	db	dev_pmk+1	;Program error devices same as message device
d_cnt	set	d_cnt+1

dev_pr:: equ	d_cnt
	db	dev_pr,dev_nul	;Allocated device, parent device
	db	dof_max, "Printer_Out", 0 ;Device name
	devpdat	dat_size,pr+1,pr+1,0,0,40
	devvdat	vdt_max,132*chr_xsiz-1,60*chr_ysiz-1
	dd	(pro_cdatx-pro_cdat)/4
	dd	-1		;Command processor
	dd	-1
	dd	pro_chr-svc
	cond	cg16_edb
	 dd	s1o_sst-svc
	 dd	s1o_sio-svc
	 dd	s1o_stat-svc
	 dd	s1o_io-svc
	celse
	 dd	pro_sst-svc
	 dd	pro_sio-svc
	 dd	pro_stat-svc
	 dd	pro_io-svc
	cend
	dd	-1, -1		;Error, int
pro_cdat:
	dd	dc_init
	dd	dc_open
	dd	dc_close
	dd	dc_eof
	dd	dc_cls
pro_cdatx:
	dd	-1		;Default default routine
	dd	pro_cinit-svc
	dd	pro_copen-svc
	dd	pro_cclose-svc
	dd	pro_ceof-svc
	dd	pro_ccls-svc
d_cnt	set	d_cnt+1

	db	dev_pr+1,dev_nul+1 ;Allocated device, parent device
	db	dof_max, "Printer_In", 0 ;Device name
	devpdat	dat_size,pr,pr,0,0,40
	devvdat	vdt_max,0,0
	dd	(pri_cdatx-pri_cdat)/4
	dd	-1		;Command processor
	dd	pri_blk-svc
	dd	-1		;Default character routine
	dd	pri_sst-svc
	dd	pri_sio-svc
	dd	pri_stat-svc
	dd	pri_io-svc
	dd	-1, -1		;Error, int
pri_cdat:
	dd	dc_open
	dd	dc_close
pri_cdatx:
	dd	-1		;Default default routine
	dd	pri_copen-svc
	dd	pri_cclose-svc
d_cnt	set	d_cnt+1

	cond	op_sys
dev_pnt:: equ	d_cnt
	 db	dev_pnt,dev_nul	;Allocated device, parent device
	 db	dof_max, "Pointer_Out", 0 ;Device name
	 devpdat dat_size,pnt+1,pnt+1,0,0,40
	 devvdat vdt_max,vid_xsiz-1,vid_ysiz-1
	 dd	(pto_cdatx-pto_cdat)/4
	 dd	-1		;Command processor
	 dd	-1		;Block
	 dd	-1
	 dd	-1
	 dd	-1
	 dd	-1
	 dd	-1
	 dd	-1,-1		;Err, int routines same as parent
pto_cdat:
pto_cdatx:

d_cnt	 set	d_cnt+1

	 db	dev_pnt+1,dev_nul+1 ;Allocated device, parent device
	 db	dof_max, "Pointer_In", 0 ;Device name
	 devpdat dat_size,pnt,pnt,<exp bdp_mous>,128,40
	 devvdat vdt_max,vid_xsiz-1,vid_ysiz-1
	 dd	(pti_cdatx-pti_cdat)/4
	 dd	-1		;Command processor
	 dd	-1		;Block
	 dd	-1
	 dd	pti_sst-svc
	 dd	-1
	 dd	-1
	 dd	-1
	 dd	-1,-1		;Err, int routines same as parent
pti_cdat:
	 dd	dc_init
pti_cdatx:
	 dd	-1		;Default default routine
	 dd	pti_cinit-svc
d_cnt	 set	d_cnt+1
	cend

dev_m1:: equ	d_cnt
	cond	op_sys
	 db	dev_m1,dev_nul+1 ;Allocated device, parent device
	 db	dof_max, "A", 0	;Device name
	 devpdat diskdat_size,m1+1,m1+1,0,0,40
	 devvdat vdt_max,vid_xsiz-1,vid_ysiz-1
	 dd	(m1o_cdatx-m1o_cdat)/4
	 dd	-1		;Command processor
	 dd	m1o_blk-svc	;Block
	 dd	-1		;Chr
	 dd	m1o_sst-svc
	 dd	m1o_sio-svc
	 dd	m1o_stat-svc
	 dd	m1o_io-svc
	 dd	-1,-1		;Err, int routines same as parent
m1o_cdat:
	 dd	dc_init
	 dd	dc_flush
	 dd	dc_apos
	 dd	dc_rpos
	 dd	dc_open
	 dd	dc_make
	 dd	dc_close
	 dd	dc_erase
	 dd	dc_lfmt
	 dd	dc_hfmt
	 dd	dc_dupd
	 dd	dc_log
	 dd	dc_unlog
	 dd	dc_rdir
	 dd	dc_sdir
	 dd	dc_getatr
	 dd	dc_putatr
	 dd	dc_getsiz
	 dd	dc_renam
m1o_cdatx:
	 dd	-1		;Default default routine
	 dd	m1o_cinit-svc
	 dd	m1o_cflush-svc
	 dd	m1o_capos-svc
	 dd	m1o_crpos-svc
	 dd	m1o_copen-svc
	 dd	m1o_cmake-svc
	 dd	m1o_cclose-svc
	 dd	m1o_cerase-svc
	 dd	m1o_clfmt-svc
	 dd	m1o_chfmt-svc
	 dd	m1o_cdupd-svc
	 dd	m1o_clog-svc
	 dd	m1o_cunlog-svc
	 dd	m1o_sdir-svc
	 dd	m1o_s1dir-svc
	 dd	m1o_cgetatr-svc
	 dd	m1o_cputatr-svc
	 dd	m1o_cgetsiz-svc
	 dd	m1o_crenam-svc
	celse
	 db	dev_pr
	cend
d_cnt	set	d_cnt+1

	cond	op_sys
	 db	dev_m1+1,dev_m1 ;Allocated device, parent device
	 db	dof_max, "A", 0 ;Device name
	 devpdat diskdat_size,m1,m1,0,0,40
	 devvdat vdt_max,vid_xsiz-1,vid_ysiz-1
	 dd	(m1i_cdatx-m1i_cdat)/4
	 dd	-1		;Command processor
	 dd	m1i_blk-svc	;Block
	 dd	-1		;Chr
	 dd	m1i_sst-svc
	 dd	m1i_sio-svc
	 dd	m1i_stat-svc
	 dd	m1i_io-svc
	 dd	-1,-1		;Err, int routines same as parent
m1i_cdat:
	 dd	dc_init
	 dd	dc_open
	 dd	dc_make
	 dd	dc_close
	 dd	dc_apos
	 dd	dc_rpos
m1i_cdatx:
	 dd	-1		;Default default routine
	 dd	m1i_cinit-svc
	 dd	m1i_copen-svc
	 dd	m1i_cmake-svc
	 dd	m1i_cclose-svc
	 dd	m1i_capos-svc
	 dd	m1i_crpos-svc
	celse
	 db	dev_pr+1
	cend
d_cnt	set	d_cnt+1

dev_max	equ	d_cnt		;Number of defined devices

;End of INI32
