;;GNXMACRO.ASM - March 16, 1990
;;Placed into the public domain by Digital Arts
;;Kotekan macros for GNX source code
;;Refer to GENIX.DOC for more information

{
These macros are intended for use with source code originally written
for National Semiconductor's GNX assembler.

The locals macro allows limited use of the GNX 1-9 temporary
labels.  It should be added to all GNX macro definitions using these
temporary labels.  It also translates the 1b/1f-9b/9f symbols. It
will not work reliably with:
  nested macros
  macros using the same digit more than once
If the digits 1-9 also appear by themselves as parameters within
the macro (e.g addqd 1,r0), a leading 0 or $ (if nscgnx is true)
should be added to prevent extraneous translations.
-1 must also be changed to -01, etc.
The last line of the GNX macro definition should be:
	xlat	0	# This disables further translation
The same source code should assemble with GNX as long as 
locals and xlat are defined as null macros.

The easiest way to understand the following macros is to use them.
Set LIST, P1LIST, and MLIST on which will display all symbol
translations on the first pass.

.section is just a null macro.  If you need it, refer to the dsect
and sav_dsect macros as a guide.
}

	nscgnx	0		;Need this off for now

locals	macro		;;Define unique translations for 1-9, 1b/1f-9b/9f
	 nscgnx	0
	 local	__1,__2,__3,__4,__5,__6,__7,__8,__9 ;;Get unique symbols
	 irpc	num,123456789
num	  set	$<&__&num>
num!b	  set	$<&__&num>
num!f	  set	$<&__&num>
	 mend
	 xlat	01	;;Translation on for duration of outer macro
	 nscgnx	01	;;Turn this on again
	mend

list	macro		;;Convert to equivalent
	 pseudo_op list 1
	mend

nolist	macro		;;Convert to equivalent
	 pseudo_op list 0
	mend

eject	macro		;;Convert to equivalent
	 pprint	s'12
	mend

	irp	psop,xdd,xpd
psop	 macro		;;Kotekan doesn't need these
	 mend
	mend

	irp	psop,title,subtitle,width
psop	 macro		;;Not supported
	 mend
	mend

comm	macro	sym	;;Compatible
	 extern	sym:(sb)
	mend
	
dsect	macro	sym,expr,spec	;;Functional equivalent
	 sav_dsect		;;Save any current status
	 nscgnx	0
	 cond	$<expr> ne $<$<>> ;;Check for null parameter
sym	  set	expr:#		;;New current value
	  cond	$<spec> eq $<$<>> ;;Check for null parameter
	   cond	expr lt 0	;;Decrement if negative value
__&sym!imm  set	$<imm->		;;Save inc/dec status
	    mode imm-,expr
	   celse
__&sym!imm  set	$<imm>
	    mode imm,expr
	   cend
	  celse
	   cond	$<spec> eq $"-"	;;Check for decrement option
__&sym!imm  set	$<imm->		;;Save inc/dec status
	    mode imm-,expr
	   celse
	    cond $<spec> eq $"+" ;;Check for increment option
__&sym!imm   set $<imm>
	     mode imm,expr
	    celse
	     print "Invalid dsect inc/dec option"
	    cend
	   cend
	  cend
	 celse			;;expr is null
	  xlat	1
	  mode	&__&sym&imm,sym	;;Restore previous value
	  xlat	0
	 cend
__dsect	 set	$<sym>		;;Current section name
	 xlat	1
__!mode set	$<&__&sym&imm>
	 xlat	0
	 nscgnx	1
	mend

sav_dsect macro			;;Save current dsect as necessary
	 nscgnx	0
	 xlat	1
	 cond	$<&__dsect> ne $<$<>> ;;See if dsect is active
&__dsect  set	`		;;Update current pointer if so
	 cend
	 xlat	0
__dsect	 set	$<>		;;dsect inactive now
	 nscgnx	1
	mend

text	macro			;;Functional equivalent
	 sav_dsect		;;Save current dsect as necessary
	 nscgnx	0
	 mode	pc
__mode	 set	$"pc"
	 nscgnx	1
	mend

data	macro			;;Put this into PC area
	 sav_dsect		;;Save current dsect as necessary
	 nxcgnx	0
	 mode	pc
__mode	 set	$"pc"
	 nscgnx	1
	mend

bss	macro	sym,valu,algn	;;Put this into SB area
	 nscgnx	0
	 mode	sb
	 cond	$<algn> ne $<$<>> ;;Check for null parameter
	  align	algn
	 cend
sym:	 ds	valu
	 xlat	1
	 mode	&__mode		;;Restore original mode
	 xlat	0
	 nscgnx	1
	mend

udata	macro			;;Put this into SB area
	 sav_dsect		;;Save current dsect as necessary
	 nscgnx	0
	 mode	sb
__mode	 set	$"sb"
	 nscgnx	1
	mend

static	macro			;;Functional equivalent
	 sav_dsect		;;Save current dsect as necessary
	 nscgnx	0
	 mode	sb
__mode	 set	$"sb"
	 nscgnx	1
	mend

link	macro			;;Kotekan doesn't need this
	mend

{
A section macro may be added if needed.  Refer to dsect and
sav_dsect as a guide.
}

	irp	psop,section,ident,modentry,file
psop	 macro		;;Not supported
	 mend
	mend

	irp	psop,def,dim,line,scl,size,tag,type,val,endef
psop	 macro		;;Not supported
	 mend
	mend

ln	macro		;;Not supported
	mend

__dsect	set	$<>	;Initialize to null string
__mode	set	$"pc"	;Start with .text (PC mode)

	extundf	1	;Undefined references assumed external
	nscgnx	1	#Enable GNX support
	text		#Start with this
