	print	"EQU32"

y::	equ	1
n::	equ	not y
	symbols	n
don::	equ	y		;My version
vidansi:: equ	y		;ANSI video
kbdansi:: equ	y		;ANSI keyboard
videxec:: equ	n		;Executive video
vid340:: equ	not vidansi	;TI34010 video
kbdibm:: equ	not kbdansi	;IBM AT type direct connect keyboard
key_s1:: equ	y		;Keyboard on serial port 1 if true, 2 if false
vid_s1:: equ	not vid340	;Video on serial port 1 if true, 2 if false
debug::	equ	y		;Debuggable version
cpu032:: equ	n		;32008/32016/32032/32CG16 CPU
w_mmu:: equ	y		;CPU with MMU
cg16_edb:: equ	n		;32CG16 Evaluation/Development board
dk_532:: equ	y		;32532 Designer Kit
ww_032:: equ	n		;My wire-wrapped 32032
p_8255:: equ	not cg16_edb	;8255 parallel port
cpu532:: equ	not cpu032	;32532 CPU
mmu082:: equ	cpu032		;32082 MMU (for assembly/disassembly only)
mmu532:: equ	cpu532		;32532 CPU/MMU (for assembly/disassembly only)

op_sys:: equ	n		;Full scale operating system
sim_fpu:: equ	n		;FPU software simulation

datemsg:: equ	"32032 8/1/91"	;ASCII version
ver_num:: equ	h'02032000	;CPU/Type ww, Vxx.yy, options zz
				;ww = CPU type:
				;  08/06/02 = 32008/32016/32032
				;  32=32332
				;  52=32532
				;  76=32CG16
				;  66=32FX16
				;  72=32GX32
				;zz options:
				;  xxxxxxx1=FPU simulation

svc_cxp:: equ	y		;SVC if true, CXP if false

	cond	cpu532
cfg_dat::  equ	b'101011110111	;Vectored interrupts, MMU, FPU, cache on
	celse
	 cond	w_mmu
cfg_dat:: equ	b'0111		;Vectored interrupts, MMU, FPU
	 celse
cfg_dat:: equ	b'11		;Vectored interrupts, FPU
	 cend
	cend

drv_max:: equ	2		;Number of floppy disk drives
hilite:: equ	32		;VT100 dim parameter (green foreground)
int_second:: equ 25		;25 interrupts per second from ICU L counter
prt_wid:: equ	132		;Maximum list width
win_max:: equ	8		;Number of windows for system
	cond	op_sys
app_max:: equ	8		;Max number of applications
	celse
app_max:: equ	1
	cend

;System specifications and memory map

	cond	vid340		;Pixel dimensions if true
vid_xsiz:: equ	720		;X screen dimension in pixels	
vid_ysiz:: equ	504		;Y screen dimension in pixels
chr_xsiz:: equ	8		;X character size in pixels
chr_ysiz:: equ	12		;Y character size in pixels
	celse			;No pixels, use character dimensions
vid_xsiz:: equ	80		;X screen dimension
vid_ysiz:: equ	49		;Y screen dimension
chr_xsiz:: equ	1		;X character size
chr_ysiz:: equ	1		;Y character size
	cend

	cond	cg16_edb
bus_byts:: equ	2		;Width of data bus in bytes
	celse
bus_byts:: equ	4
	cend

	cond	cg16_edb
bd_rate	 equ	8000000/16	;Frequency of baud clock
	celse
bd_rate	 equ	1843200/16	;Frequency of baud clock
	cend

	cond	op_sys

lomem::	equ	0:@		;Operating system low memory
lo_size:: equ	h'8000
heap::	 equ	h'880000:@	;Operating system heap (working memory)
heap_siz:: equ	h'80000		;Available memory for heap

	 mode	imm,lomem
mon_int:: ds	4*(16+16)
	  ds	4		;MOD table header
mon_mod::
	 mode	imm-,lomem+lo_size
mon_sps::			;Supervisor stack pointer builds down
mon_spu:: ds	h'1000		;User stack pointer
last_mod:: ds	h'1000
	 mode	imm,heap
	 ds	4		;Size of SB block
mon_sb:: ds	heap_siz-4
heap_last::

	celse

lomem::	 equ	h'8000:@	;EPROM monitor RAM base
lo_size:: equ	h'18000
heap::	 equ	lomem
heap_siz:: equ	lo_size

	mode	imm,lomem
mon_int:: ds	4*(16+16)
mon_mod:: ds	16
dbg_mod:: ds	16
last_mod::
	  ds	4		;Size of SB block
mon_sb::
	mode	imm-,lomem+lo_size
mon_sps::			;Supervisor stack pointer builds down
mon_spu:: ds	h'1000		;User stack pointer
heap_last:: ds	h'1000

	cend

	mode	pc

	stack	1,mon_sps

	cond	cg16_edb
eprom::	 equ	h'800000:@	;Address of EPROM (jumped to from 0)
serial1:: equ	h'f40020:@	;Serial port 1
serial2:: equ	h'f40020:@	;Only one serial port here
pdata::  equ	h'f40040:@	;Centronics input port
switch:: equ	h'f40060:@	;DRAM/FPU status switches
	celse
	 cond	dk_532 and don
eprom::	  equ	h'a00000:@	;Address of EPROM (jumped to from 0)
p_disk::  equ	h'c00000:@	;Floppy disk controller port
p_kbd::   equ	h'c00100:@	;AT type keyboard port
m_watch:  equ	h'f00000:@	;Address of SmartWatch chip
	 celse
eprom::	  equ	h'f00000:@	;Address of EPROM (jumped to from 0)
	 cend
serial1:: equ	h'fe0000:@	;Serial port 1
	 cond	ww_032
serial2:: equ	h'fe0080:@	;Serial port 2 on my 32032 board
	 celse
serial2:: equ	h'fe0081:@	;Serial port 2 on NSC boards
	 cend
pdata::  equ	h'fe8000:@	;8255 channel A data port
pdatb::	 equ	pdata+bus_byts	;8255 channel B
pdatc::	 equ	pdata+2*bus_byts ;8255 channel C
pctr::	 equ	pdata+3*bus_byts ;8255 control port

switch:: equ	h'fe8081:@	;Baud rate/FPU switches
				;Bits 0-2 set serial 1 baud rate:
				;  000 = 115200; 001 = 57600
				;  010 = 38400;  011 = 28800
				;  100 = 19200;  101 = 9600
				;  110 = 7200;   111 = 4800
				;Bits 3-5 set serial 2 baud rate
				;Bit 6 sets FPU if 1, no FPU if 0
	cend

;ICU equates
	cond	cpu032
icu_adr: equ	h'fffe00:@	;ICU base address
	cend
	cond	cpu532
icu_adr: equ	h'fffffe00:@	;32 bit ICU base address
	cend
;Centronics strobe sets ICU bit on falling edge (inverted by hardware)
cen_stb: equ	5		;ICU bit position for strobe
;Centronics INIT line is active low
cen_init: equ	6		;ICU bit position for init

{ 8255 equates

*** centronics emulation pb = input mode 1 ***
command byte: b'10010111
b0-b7 are data lines (inputs)
c0 = interrupt, c1 = handshake out, c2 = handshake in, c3 = general input
c4, c5, c6, c6 are general outputs

c1 = busy (normally low, data accepted)
c2 = /strobe (normally high, data valid)
c3 = /init (normally high, end-of-file from computer)
c4 = /acknowledge (normally high, pulsed low before data is read)
c5 = paper out (normally low)
c6 = select (normally high, end-of-file acknowledge to computer)
c7 = /fault (normally high)

*** centronics output pb = output mode 1 ***
command byte: b'10010101
b0-b7 are data lines (outputs)
c1 = not used for printer; /data valid (for computer)
c2 = /acknowledge (normally high, data accepted)
c3 = busy from printer; /eof (end-of-file acknowledge from computer) 
c4 = not used
c5 = not used
c6 = /strobe for printer; /eof (end-of-file to computer)
c7 = not used
}

flag_c:: equ	1		;Carry
flag_t:: equ	2		;Trace
flag_l:: equ	4		;Low
flag_v:: equ	h'10		;Overflow trap enable
flag_f:: equ	h'20		;Flag
flag_z:: equ	h'40		;Zero
flag_n:: equ	h'80		;Negative
flag_u:: equ	h'100		;User flag
flag_s:: equ	h'200		;Stack
flag_p:: equ	h'400		;Trace pending
flag_i:: equ	h'800		;Interrupt enable

cfg_i::	equ	0		;Vectored interrupt bit of CFG register
cfg_f::	equ	1		;FPU bit of CFG register
cfg_m::	equ	2		;MMU bit of CFG register
cfg_c::	equ	3		;Custom bit of CFG register
cfg_de:: equ	8		;Direct exception bit of CFG register
cfg_dc:: equ	9		;Data cache bit of CFG register
cfg_ldc:: equ	10		;Lock data cache bit of CFG register
cfg_ic:: equ	11		;Instruction cache bit of CFG register
cfg_lic:: equ	12		;Lock instruction cache bit of CFG register

	rpn	1
	push	1
	irpc	let,abcdefghijklmnopqrstuvwxyz
ctrl_&let:: equ	dup 1 + swap
	mend
	drop
	rpn	0

soh::	equ	ctrl_a
eot::	equ	ctrl_d
ack::	equ	ctrl_f
bksp::	equ	ctrl_h
tab::	equ	ctrl_i
lf::	equ	ctrl_j
ff::	equ	ctrl_l
cr::	equ	ctrl_m
xoff::	equ	ctrl_s
xon::	equ	ctrl_q
nak::	equ	ctrl_u
esc::	equ	27

;IO equates

{ I/O device interface:
All registers preserved unless returning a value

r0 holds length of data block in (r1)
r1 is data block pointer
r2 is reserved
r3 is svc scratch register, restored on exit
r4 holds extra parameters or address of extra parameters
r5 holds command or data value
r6: bits 0-7 holds device index to master dispatch table
    bits 8-15 hold index to requested offset within i/o block
    b_ionam set if r7 specifies named routine
  on exit, r6 holds completion status, 0=successful, <>0=error code
r7 loaded by svc with address of i/o block (offset 0), restored on exit
}

name_siz:: equ	32		;Max length for names

b_iodev:: equ	0		;Device (bit 0 set for input, clear for output)
b_iosrv:: equ	8		;Offset for service routine index
b_ionam:: equ	31		;Set if R7 holds handle for device

;Format of dynamic device buffers, data following name
	mode	imm,0
lnk_indx:: blkb			;Device index
lnk_base:: blkd			;Base r7
lnk_r7:: blkd			;Previous r7 value
lnk_hnd:: blkd			;Handle for this block
lnk_last::			;Last+1

;ID tokens for device blocks
	org	0
lnt_base:: blkb			;Base block, not in heap
lnt_route:: blkb		;Reroute token
lnt_link:: blkb			;Link token
lnt_chain:: blkb		;Chain token
lnt_instnc:: blkb		;Instance token

	org	0

dof_id:: ds	1
dofid_dev equ	0	;Byte offset of Device R7 index:b field
dofid_max equ	1	;Byte offset of Dof_max:b field

dof_bdat:: ds	1	;Base data block common to all related devices/instances
dof_dat:: ds	1	;Physical device data block
dof_vdat:: ds	1	;Virtual device data block
dof_lnk:: ds	1	;Handle for link data (-1 = none)
dof_cdat:: ds	1	;Command data block
dof_cmd:: ds	1	;Device command processor
dof_blk:: ds	1	;Block I/O routine
dof_chr:: ds	1	;Character I/O with translation/system update
dof_sst:: ds	1	;Software status
dof_sio:: ds	1	;Software I/O
dof_stat:: ds	1	;Device hardware status fetch
dof_io:: ds	1	;Device hardware I/O routine
dof_err:: ds	1	;Device error routine
dof_int:: ds	1	;Interrupt processor
dof_max::		;Total storage size

;0 terminated device name follows

;DOF_DAT data block

	org	0

dat_siz:: ds	2	;Size of data block in bytes

;Dat_wmin - dat_wmax are unique for each defined window
dat_wmin::		;1st window parameter to save
dat_col:: ds	4	;Current character column
dat_line:: equ	dat_col+2 ;Current line
dat_page:: ds	2	;Current page
dat_vca:: ds	2	;Currently selected attributes
dat_chrx:: ds	2	;X pixels per character
dat_chry:: ds	2	;Y pixels per character
dat_wmax::		;Last window parameter to save

dat_xoff::
dat_ptcl:: ds	4	;Protocol (XOFF, etc.)
; Bits 0-23 are device specific
; Bits 24-31 are general controls common to all devices
bdp_opn:: equ	24	;Device is open and initialized
bdp_eof:: equ	25	;End of file encountered
bdp_lok:: equ	26	;Locked when open if set
bdp_bin:: equ	27	;Binary file transfers with handshaking eof if set
; XOFF/PTCL status bits
; Bits 0-7 are character to wait for before resuming transmission
;Serial ports
bdp_cts:: equ	16	;RTS/CTS hardware protocol
bdp_xof:: equ	17	;XOFF enabled if set
bdp_xmo:: equ	18	;XMODEM protocol if set
bdp_xmc:: equ	bdp_xmo+1 ;XMODEM CRC mode if set
bdp_win:: equ	20	;3 bit window selection if not op_sys
;Mouse
bdp_mous:: equ	23	;Mouse enabled if set
;Disk
bdp_wld:: equ	0	;Suppress "wild card" characters in file names if set
bdp_lc:: equ	1	;Suppress lc to uc conversion in file names if set
bdp_?::	equ	2	;"?" matches "." too if set

dat_smoc:: ds	4	;Device busy/lock status
			;Bits 0-15 are device/service index from r6:w
			;Bits 16-23 are application number in service
bsm_bsy	equ	24	;Device busy if set
bsm_cmd equ	25	;Multi-character command if set
bsm_lok equ	26	;Device locked if set (copied to bsy after I/O)
bsm_rok	equ	27	;Read OK, even if locked
bsm_wok	equ	28	;Write OK, even if locked

dat_io:: ds	1	;Corresponding I/O device
dat_kv:: ds	1	;Corresponding keyboard/video device
dat_bpt:: ds	4	;Buffer pointer
dat_bsz:: ds	4	;Buffer size (power of 2 - 1)
dat_bchr:: ds	4	;Number of characters currently in buffer
dat_brdx:: ds	4	;Buffer read index
dat_bwtx:: ds	4	;Buffer write index

dat_next:: ds	4	;Pointer to temporary line buffer
dat_size::		;Size in bytes of data block

;Serial routine extensions to data block
	org	dat_size
dat_xmich:: blkw	;XMODEM input character counter
dat_xmoch:: blkw	;XMODEM output character counter
dat_xmblk:: blkd	;XMODEM block number
dat_xmcrc:: blkw	;XMODEM crc
dat_cursor:: blkw	;Cursor type/size
serdat_size::		;Size of serial port data block

;IBM AT keyboard extensions to data block

	org	dat_size
dat_image:: ds (h'84+7)/8 ;Bit map of keys pressed
keydat_size::		;Size of data block

;Disk extensions to data block

	org	dat_size
dat_did:: blkd		;Handle to Disk ID data
dat_ssiz:: blkd		;Sector size
dat_bufh:: blkd		;Handle to data and bupd buffer
dat_absbf:: blkd	;Absolute starting byte of data in buffer
dat_absch:: blkd	;Number of characters loaded into buffer at (dat_bpt)
dat_bdat:: blkd		;Pointer to base dat parameters
dat_bupd:: blkd		;Pointer to change flags
dat_dir:: blkd		;Pointer to directory
dat_dirt:: blkw		;File/data type from directory
dat_fato:: blkw		;Offset of current FAT entry
dat_fatr:: blkw		;Relative cluster in current file
dat_motor:: blkd	;Pointer to motor timer word
dat_dctr:: blkd		;Controller parameters
diskdat_size::		;Size of disk data block

;dctr bits
	org	0
bdp_drv:: ds	8	;Drive select code for this disk
bdp_bdrv:: ds	8	;Base value written to controller
bdp_rate:: ds	2	;Rate select code
bdp_brate:: ds	2	;Base value written to controller
bdp_on:: blkb		;Controller in use if set
bdp_ch1:: ds	drv_max*2 ;Disk 1 changed if set
bdp_wp1:: equ	bdp_ch1+1 ;Disk 1 write protect status


;DOF_VDAT data block

	org	0

vdt_siz:: ds	2	;Table size in bytes
vdt_wmin::		;Minimum window parameter to save
vdt_minc:: ds	4	;Starting column (from 0)
vdt_minl:: equ vdt_minc+2 ;Starting line (from 0)
vdt_maxc:: ds	4	;Max relative column
vdt_maxl:: equ	vdt_maxc+2 ;Max relative row
vdt_wmax::		;Last window parameter to save
vdt_tab:: ds	4	;Tab, CR, FF, etc. translation
vdt_max::		;Total size of VDAT table

win_last equ	dat_wmax-dat_wmin+vdt_wmax-vdt_wmin

	mode	pc

;Bit 0 must be data not ready
	mode	imm,0
bstat_rd:: blkb		;Data not ready if set   
bstat_na:: blkb		;Not available if set    
bstat_nr:: blkb		;Device not ready if set
bstat_xf:: blkb		;XOFF or other hold if set
bstat_ef:: blkb		;End of file or transmission if set
bstat_il:: blkb		;Illegal device or command
bstat_iu:: blkb		;In use (locked) if set
bstat_fe:: blkb		;Fatal error if set
bstat_re:: blkb		;Recoverable error if set
	mode	pc

{
Character codes:
  0-h'7f are standard ASCII characters
  h'80 - h'9f are commands
    video/keyboard control codes (80-8f) processed by video unit
    90-9f processed by operating system
  h'a0 - h'bf are extended characters:
    bits 0-4 are upper 5 bits of 13 bit code, another byte follows
  h'c0 - h'ff are alternate characters
  h'100 - h'1fff are extended characters
!!! do_vc routine uses table based on this order !!!
}

vc_ign:: equ	h'80		;Ignore this code
vc_lit:: equ	h'81		;Take next character literally
;vc_rept:: equ	h'82		;Repeat: character, count:disp. follows
;vc_lbrk:: equ	h'83		;Possible line break
;vc_pbrk:: equ	h'84		;Possible page break
vc_scr:: equ	h'85		;Screen command (clear, etc), data follows
; !!!T_SCRVC uses following codes in this order!!!
vcs_base:: equ	' '+1		;Base value for screen commands
	mode	imm,vcs_base
vcs_tab:: blkb			;Space once or until horiz. pos.:B reached
vcs_nln:: blkb			;CR if not at beginning of line
vcs_pag:: blkb			;New page
vcs_cur:: blkb			;Position to col:B,row:B
vcs_pix:: blkb			;Position to pixel col:w,row:w
vcs_win:: blkb			;Set pixel window size upper left:d, size:d
vcs_crsr:: blkb			;Set cursor size/type

	mode	pc
vc_sat:: equ	h'86		;Set attribute (code follows)
vc_cat:: equ	h'87		;Clear attribute (code follows)
vc_tat:: equ	h'88		;Toggle attribute (code follows)
vca_dim:: equ	0		;Dim attribute
vca_hlt:: equ	1		;Hilite attribute
vca_alt:: equ	2		;Alternate color
vca_rev:: equ	3		;Reverse
vca_flsh:: equ	4		;Flash
vca_und:: equ	5		;Underline
vca_itl:: equ	6		;Italics
vca_bld:: equ	7		;Bold

vc_win:: equ	h'89		;Window command
;These sub-commands must stay in this order
;vcw_base:: equ	h'21		;Base address for sub-commands
;vcw_wint:: equ	h'21		;Text screen/window selection
;vcw_swnt:: equ	h'22		;Text sub-window selection
;vcw_winp:: equ	h'23		;Pixel screen/window selection
;vcw_swnp:: equ	h'24		;Pixel sub-window selection
;vcw_blkl:: equ	h'25		;Linear block selection
;vcw_blkc:: equ	h'26		;Columnar block selection

vcw_pix:: equ	h'80		;Clear for pixel, set for character
vcw_bdr:: equ	b'000*16	;Border command
vcw_fil:: equ	b'001*16	;File command
vcw_blk:: equ	b'010*16	;Block command (linear or columnar)
vcw_win:: equ	b'011*16	;Screen/window command
vcw_swn:: equ	b'100*16	;Sub-window command
vcw_lin:: equ	b'101*16	;Line command
vcw_wrd:: equ	b'110*16	;Word command
vcw_chr:: equ	b'111*16	;Character command
vcw_mov:: equ	b'00*4		;Move command
vcw_scrl:: equ	b'01*4		;Scroll command
vcw_ins:: equ	b'10*4		;Insert command
vcw_del:: equ	b'11*4		;Delete command
vcw_lft:: equ	b'00		;Left
vcw_rt:: equ	b'01		;Right
vcw_up:: equ	b'10		;Up
vcw_dn:: equ	b'11		;Down

vc_menu:: equ	h'8a		;Menu structure terminated by men_x
men_base:: equ	' '+1		;Base index
	mode	imm,men_base

men_mitb:: blkb			;Begin a menu item, men_x
men_minp:: blkb			;Menu line input position, men_x
men_mcst:: blkb			;Comma separated strings input, men_x

men_cur:: blkb			;Upper left corner in pixels :d
men_tdsp:: blkb			;Text for immediate display, men_x
men_tinp:: blkb			;Field and default text for string input, men_x
men_sel:: blkb			;Select string for _mitb, men_x
men_ret:: blkb			;Return string for _mitb if selected, men_x
men_r0:: blkb			;R0/r5 value for string input :q
men_sub:: blkb			;Subroutine address called immediately :d

men_nxt:: blkb			;Next selection index :w
men_dat:: blkb			;Data field, length:w
men_id:: blkb			;ID field for return, length:w
men_x:: blkb			;End of string, item, structure, if ambiguous

	mode	pc

;These are normally sent from keyboard or other input device
;vc_fk:: equ	h'90		;Function key code follows
;vc_abt:: equ	h'91		;Abort current program
;vc_sus:: equ	h'92		;Suspend on/off/return status
;vc_esc:: equ	h'93		;Video/keyboard escape sequence follows
;vc_exe:: equ	h'94		;Command follows (screen dump, etc)
;vc_dbg:: equ	h'95		;Call debugger
vc_strx:: equ	h'97		;End of string/menu item/etc.
vc_xlin:: equ	h'98		;End of line (input complete), don't display
vc_xpag:: equ	h'99		;End of page (input complete), don't display
vc_xfil:: equ	h'9a		;End of file

;Commands for I/O devices
bdv_cmd:: equ	31		;Actual command if set
bdv_more:: equ	30		;More data follows	
bdv_flg:: equ	24		;Flag bits
bdv_stat:: equ	22		;Load/return status, on/off, open/close
bdv_typ:: equ	18		;Type or class offset 
bdv_stof:: equ	14		;Sub-type offset
bdv_cof:: equ	8		;Command offset

;Mask for actual command
bdv_mask:: equ	exp bdv_cmd+((exp (bdv_flg-bdv_cof)-1) lsh bdv_cof)

{
command in r5 sent via command vector in device table
  bits 0-7 [8] are data/specifier
  bits 8-21 are command (lowest is 1)
    bits 8-13 [6] are specific command
    bits 14-17 [4] are sub-type
    bits 18-21 [4] for type or class
      0=system, 1=enable, 2=data, 3=initialization, 4=preparation, 5=command
      6=cpu/fpu
      12-15 reserved for dynamically loaded devices
  bits 22-23 [2]:
    00 = command/load status
    01 = return status in r5
    10 = boolean off, close
    11 = boolean on, open
  bits 24-29 [6] are flag/status bits
  bit 30 set if data follows (byte count in bits 0-7)
  bit 31 set for command, reset if data

Additional parameters usually in r4 or (r4)
Returned values usually in r5
}
	
dc_vct:: equ	(1 lsh 8)+(0 lsh 14)+(0 lsh 18)+(3 lsh 22)+exp 31
	;Change device vector to reroute I/O
dc_unvct:: equ	(1 lsh 8)+(0 lsh 14)+(0 lsh 18)+(2 lsh 22)+exp 31
	;Restore device vector to un-reroute I/O
dc_datb:: equ	(2 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Load R5 with base address of data block
dc_svcad:: equ	(3 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Load R5 with address SVC
dc_devad:: equ	(4 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Load R5 with base address DEV_PTR block
dc_vdatb:: equ	(5 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Load R5 with base address of virtual data block
dc_instnc:: equ	(6 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Create new instance
dc_getr7:: equ	(7 lsh 8)+(0 lsh 14)+(0 lsh 18)+(1 lsh 22)+exp 31
	;Return current r7 handle in r5
dc_putr7:: equ	(7 lsh 8)+(0 lsh 14)+(0 lsh 18)+(0 lsh 22)+exp 31
	;Install r4 as new r7 default handle


dc_newbf:: equ	(1 lsh 8)+(1 lsh 14)+(0 lsh 18)+(3 lsh 22)+exp 31
	;Request new buffer from heap, return handle in R5
dc_fusr:: equ	bdv_flg
dc_clrbf:: equ	(1 lsh 8)+(1 lsh 14)+(0 lsh 18)+(2 lsh 22)+exp 31
	;Release buffer, handle in r4
dc_sizbf:: equ	(2 lsh 8)+(1 lsh 14)+(0 lsh 18)+(0 lsh 22)+exp 31
	;Set new size3, r4=> handle:d, new size:d
dc_lonbf:: equ	(3 lsh 8)+(1 lsh 14)+(0 lsh 18)+(3 lsh 22)+exp 31
	;Lock buffer with address in r4
dc_lofbf:: equ	(3 lsh 8)+(1 lsh 14)+(0 lsh 18)+(2 lsh 22)+exp 31
	;Unlock buffer with address in r4
dc_uonbf:: equ	(4 lsh 8)+(1 lsh 14)+(0 lsh 18)+(3 lsh 22)+exp 31
	;Set in use flag for buffer in r4
dc_uofbf:: equ	(4 lsh 8)+(1 lsh 14)+(0 lsh 18)+(2 lsh 22)+exp 31
	;Clear in use flag for buffer in r4


dc_rx:: equ	(1 lsh 8)+(0 lsh 14)+(1 lsh 18)+(0 lsh 22)+exp 31
	;Check hardware for new RX, buffer if received
dc_on:: equ	(2 lsh 8)+(0 lsh 14)+(1 lsh 18)+(3 lsh 22)+exp 31
	;Opened device enabled (XON, etc.)
dc_off:: equ	(2 lsh 8)+(0 lsh 14)+(1 lsh 18)+(2 lsh 22)+exp 31
	;Opened device on hold (XOFF etc.)

dc_lock:: equ	(1 lsh 8)+(1 lsh 14)+(1 lsh 18)+(3 lsh 22)+exp 31
	;Lock dat_next buffer
dc_unlok:: equ	(1 lsh 8)+(1 lsh 14)+(1 lsh 18)+(2 lsh 22)+exp 31
	;Unlock dat_next buffer

dc_led:: equ	(1 lsh 8)+(2 lsh 14)+(1 lsh 18)+(0 lsh 22)+exp 31
	;Set keyboard LEDs


dc_r1:: equ	(1 lsh 8)+(0 lsh 14)+(2 lsh 18)+(0 lsh 22)+exp 31
	;Data R1 via _sio routine, number of bytes in R0, LSB 1st
dc_dspasc:: equ	(2 lsh 8)+(0 lsh 14)+(2 lsh 18)+(0 lsh 22)+exp 31
	;Display character in r4 as ASCII with attributes as needed

dc_push:: equ	(1 lsh 8)+(1 lsh 14)+(2 lsh 18)+(0 lsh 22)+exp 31
	;Push values onto parameter stack, R0=length, R1=buffer pointer
dc_pop:: equ	(2 lsh 8)+(1 lsh 14)+(2 lsh 18)+(0 lsh 22)+exp 31
	;Pop values from parameter stack, R0=length, R1=buffer pointer

dc_xlat:: equ	(1 lsh 8)+(2 lsh 14)+(2 lsh 18)+(0 lsh 22)+exp 31
	;Translate _sio to _chr: R0=length, R1=value


dc_init::  equ	(1 lsh 8)+(0 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Master device initialization

dc_lfmt:: equ	(1 lsh 8)+(1 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Low level format a disk
dc_hfmt:: equ	(2 lsh 8)+(1 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Low level format a disk

dc_baud:: equ	(1 lsh 8)+(2 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Set serial port baud rate

dc_nwn:: equ	(1 lsh 8)+(3 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Set new character size for current window

dc_crsr:: equ	(1 lsh 8)+(4 lsh 14)+(3 lsh 18)+(0 lsh 22)+exp 31
	;Define cursor


dc_open:: equ	(1 lsh 8)+(0 lsh 14)+(4 lsh 18)+(3 lsh 22)+exp 31
	;Open device, can't create new files
dc_close:: equ	(1 lsh 8)+(0 lsh 14)+(4 lsh 18)+(2 lsh 22)+exp 31
	;Close device
dc_cltrk:: equ	bdv_flg		;Truncate existing file if set
dc_flush:: equ	(2 lsh 8)+(0 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Flush device, but leave open
dc_make:: equ	(3 lsh 8)+(0 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Open but create new file
dc_erase:: equ	(4 lsh 8)+(0 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Erase file
dc_eof:: equ	(5 lsh 8)+(0 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;End-of-file
dc_binon:: equ	(6 lsh 8)+(0 lsh 14)+(4 lsh 18)+(3 lsh 22)+exp 31
	;Binary file type selected
dc_binoff:: equ	(6 lsh 8)+(0 lsh 14)+(4 lsh 18)+(2 lsh 22)+exp 31
	;Binary file type off
dc_binget:: equ	(6 lsh 8)+(0 lsh 14)+(4 lsh 18)+(1 lsh 22)+exp 31
	;Return binary file selection

dc_log:: equ	(1 lsh 8)+(1 lsh 14)+(4 lsh 18)+(3 lsh 22)+exp 31
	;Log in disk parameters, FAT, directory
dc_unlog:: equ	(1 lsh 8)+(1 lsh 14)+(4 lsh 18)+(2 lsh 22)+exp 31
	;Invalidate disk parameters, FAT, directory
dc_dupd:: equ	(2 lsh 8)+(1 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Update disk FAT, directory

dc_rdir:: equ	(1 lsh 8)+(2 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Next directory
	;R0/R1 hold name for match, R0=-1 if justed incrementing
	;R5 LSB holds DIRB_TYP
dc_sdir:: equ	(2 lsh 8)+(2 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Search directory, @pointer in R1, length of name in R0
	;R5 LSB holds DIRB_TYP
	;Directory stays closed, just returns file presence/absence

dc_apos:: equ	(1 lsh 8)+(3 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Position file pointer to absolute byte position in r4
dc_rpos:: equ	(2 lsh 8)+(3 lsh 14)+(4 lsh 18)+(0 lsh 22)+exp 31
	;Position file pointer to relative byte position in r4


dc_prgd:: equ	(1 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Call debugger
dc_dbgadr:: equ	(2 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Load entry address for debugger, (r4) holds PC, MOD, PSR
dc_dbgpc:: equ	bdv_flg ;R4 holds PC only if set
dc_prgn:: equ	(3 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Start a new application
dc_prgx:: equ	(4 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Exit current application
dc_prgl:: equ	(5 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Launch a new program in current application
dc_prgr:: equ	(6 lsh 8)+(0 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Exit current program to operating system

dc_renam:: equ	(1 lsh 8)+(1 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Rename file - R0/R1=name, R5:B=attributes
dc_putatr:: equ	(2 lsh 8)+(1 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;R0/R1=name, R5:B=current attribute for search
	;Set new file attributes (passed in r4)
dc_getatr:: equ	(2 lsh 8)+(1 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;R0/R1=name, R5:B=current attribute for search
	;Return file attributes:W in R5
dc_getsiz:: equ	(3 lsh 8)+(1 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;R0/R1=name, R5:B=current attribute for search
	;Return file size in R5

dc_gwin:: equ	(1 lsh 8)+(2 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return number of current window

dc_gchmx:: equ	(1 lsh 8)+(3 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return max x/y character coordinates

dc_cls:: equ	(1 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Clear screen/new page
dc_cur:: equ	(2 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Cursor position
dc_atr:: equ	(3 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set attributes
dc_setxy:: equ	(4 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set new xy pixel coordinates
dc_getxy:: equ	(4 lsh 8)+(4 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return current xy pixel coordinates
dc_setchr:: equ	(5 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set new character coordinates
dc_getchr:: equ	(5 lsh 8)+(4 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return current character coordinates
dc_setmxy:: equ	(6 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set new mouse xy pixel coordinates
dc_getmxy:: equ	(6 lsh 8)+(4 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return current mouse xy pixel coordinates
dc_setmchr:: equ (7 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set new mouse character coordinates
dc_getmchr:: equ (7 lsh 8)+(4 lsh 14)+(5 lsh 18)+(1 lsh 22)+exp 31
	;Return current mouse character coordinates
dc_relxy:: equ	(8 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set relative xy pixel coordinates
dc_relchr:: equ	(9 lsh 8)+(4 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Set relative character coordinates

dc_menu:: equ	(1 lsh 8)+(5 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Display or execute menu, handle in r4
dc_mndsp:: equ	bdv_flg		;Draw window if set
dc_mnexe:: equ	bdv_flg+1	;Execute window if set
dc_clrm:: equ	(2 lsh 8)+(5 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Clear menu, handle in r4

dc_msel:: equ	(0 lsh 8)+(6 lsh 14)+(5 lsh 18)+(0 lsh 22)+exp 31
	;Menu selection command inserted into bits 8-15:
{
	mode	imm,1
men_cur:: blkb		;Upper left pixel cursor position:d
men_hlt:: blkb		;Hilite attribute:w
men_tdsp:: blkb		;Immediate display of following text until men_x
men_r0:: blkb		;Default r0/r5 for string input:q
men_tinp:: blkb		;Text field and default text for input, size:w
men_sel:: blkb		;Selection string, men_x
men_ret:: blkb		;Return string if selected, men_x
men_nxt:: blkb		;Next selection index:w
men_sub:: blkb		;Call subroutine, absolute address:d (r5=> data)
men_dat:: blkb		;Data field, length:w
men_id:: blkb		;ID field, length:w
men_x::	blkb		;Last valid command+1
	mode	pc
}	
	
dc_setcfg:: equ	(1 lsh 8)+(0 lsh 14)+(6 lsh 18)+(0 lsh 22)+exp 31
	;Set new CFG value from r4
dc_getcfg:: equ	(1 lsh 8)+(0 lsh 14)+(6 lsh 18)+(1 lsh 22)+exp 31
	;Return CFG in R5

dc_fpu:: equ	(1 lsh 8)+(1 lsh 14)+(6 lsh 18)+(1 lsh 22)+exp 31
	;Return FPU type in R5

dc_trpadr:: equ	(1 lsh 8)+(2 lsh 14)+(6 lsh 18)+(0 lsh 22)+exp 31
	;Set trap service address
dc_trppc:: equ	bdv_flg ;R4 holds PC only if set
dc_trpsb:: equ	(2 lsh 8)+(2 lsh 14)+(6 lsh 18)+(1 lsh 22)+exp 31
	;Return trapped SB
dc_sbptr:: equ	(3 lsh 8)+(2 lsh 14)+(6 lsh 18)+(0 lsh 22)+exp 31
	;Set trapped SB storage pointer


{
keyboard status bits passed in r0 to dof_blk routine
  bits 0-15 are character count for output if bkb_cnt is set
    max input length for input, -1 = infinite
    termination count for input if bkb_cnt is set
  bits 16-31 are status bits:
}

	mode	imm-,32
bkb_28:: blkb			;Termination on 28 bit count in r0 if set
bkb_bin:: blkb			;Binary file if set
	blkb			;Reserved
	blkb			;Reserved

;These are active only if bkb_28 is clear

bkb_cnt:: blkb			;Termination on 16 bit count in R0 if set
bkb_tr5:: blkb			;Terminate on character in r5

bkb_edt:: blkb			;Editing enabled if set
bkb_cnv:: blkb			;Lower to upper case conversion if set
bkb_eko:: blkb			;Echo characters if set
bkb_ekt:: blkb			;Echo termination if set

;These are active when EDT is set
;R5 must hold termination character

	mode	imm,16

bkb_esc:: blkb			;Quit and zap entry if ESC pressed
bkb_ret:: blkb			;Also exit if RET pressed

;These are active when EDT is clear

	org	16

bkb_trm:: blkb			;Handshaking termination on end of file
bkb_hlt:: blkb			;Halt (XOFF etc.) after input is complete

	mode	pc


;*********************************
;* Assembler/debugger parameters *
;*********************************

buf_siz:: equ	120		;Default size for input buffers
mon_src:: equ	h'800000	;Default source code load address

	cond	debug
prompt:: equ	"#"		;Prompt character for debuggable version
	celse
prompt:: equ	">"		;Prompt character for EPROM version
	cend

nscgnx:: equ	y		;Compatible with NSC GNX assembler

sidx_bit:: equ	21		;Number of bits in index entry
sidx_of:: equ	(sidx_bit+7)/8	;Number of bytes for index entry
sidx_end:: equ	exp sidx_bit-1	;Code for end of linked table

{
symbol table: 8, 10, or 12 bytes + label length per entry:

sidx_of bytes offset from t_symbl to next alpha entry, -1 terminates
16 bits status:
 bits 0-4 are length of symbol name
 bits 5-6 are designator:
  00 = normal
  01 = temporary
  10 = global
  11 = external
 bit 7 is undefined bit
bits 8-11 are addressing mode (bit 10 clear = relative (pc,sb,etc.))
 0000 = (fp), 0001 = (sp), 0010 = (sb)
 0100 = constant (msb,lsb immediate), 0101 = absolute (@)
 0110 = ext, 0111 = constant (lsb,msb operand)
 1000 = fp, 1001 = sp, 1010 = sb, 1011 = pc (*)
 1100 = literal text, 1101 = text expression, 1110 = link data
 1111 = undefined
bits 12-15 = size and type of data
 0000 = byte, 0001 = word, 0010 = variable size, 0011 = dword
 0100 = 32 bit float, 0101 = 64 bit, 0110 = variable size float/double
 1000 = 2 byte length, 4 byte pointer
 1010 = 4 byte text pointer to terminated single line text
 1011 = 4 byte pointer to terminated multi-line text
 1100 = boolean, (4 bytes, only bit 0 is significant)
 1101 = bcd (4 bytes, 8 digits)
 1110 = 4 byte pointer to descriptor, data
 1111 = undefined
4 bytes for value, 6 bytes for string (length/pointer), 8 bytes for float
n bytes symbol name
}

b_typ::	equ	5		;First bit of 2 bit type designator
b_def::	equ	7		;Defined bit for symbols
b_mode:: equ	8		;First bit of addressing mode typ
b_size:: equ	12		;First bit of size/type

lbl_nrm:: equ	0		;Normal label
lbl_tmp:: equ	1		;Temporary label
lbl_glb:: equ	2		;Global label
lbl_ext:: equ	3		;External label

;Descriptors for B_SIZE=0E
dsc_mod:: equ	1		;Module - PC, SB, MOD, LINK follow

;Status bits for radix/display routines

b_rpn::	equ	5		;RPN on bit, must be in lower byte
b_sign:: equ	6		;Set if signed, must be bit 0-7
b_fld::	equ	7		;Set if M_RFLD = field size, M_RPAD = padding
b_asc::	equ	8		;Set if ASCII display requested
b_rdx::	equ	9		;Set if H' or B' radix should be included
b_dig::	equ	10		;Set if M_RDIG holds digit count
b_zro::	equ	11		;Set if leading 0s should be included
b_buf::	equ	12		;Set if using R0/R1 buffer instead of display
b_pls::	equ	13		;Display "+" if signed and positive
b_lit::	equ	14		;Set for literal (no attrib.), B_ASC=1

;Math operators must be in this order for T_DOMATH
;Higher numbers have higher priority

;Stack operators
mop_swp:: equ	0		;Swap
mop_pik:: equ	1		;Pick
mop_drp:: equ	2		;Drop
mop_dup:: equ	3		;Dup
mth_sop:: equ	3		;Highest stack op

;Comparison
mop_gt:: equ	4		;Greater than
mop_lt:: equ	5		;Less than
mop_ge:: equ	6		;Greater or equal
mop_le:: equ	7		;Less or equal
mop_hi:: equ	8		;Unsigned higher
mop_lo:: equ	9		;Unsigned lower
mop_hs:: equ	10		;Unsigned higher or same
mop_ls:: equ	11		;Unsigned lower or same
mop_eq:: equ	12		;Equal
mop_ne:: equ	13		;Not equal
mth_cop:: equ	13		;Highest compare op

;Logical
mop_xor1:: equ	14		;^
mop_xor:: equ	15		;XOR
mop_or1:: equ	16		;|
mop_or:: equ	17		;OR
mop_and1:: equ	18		;&
mop_and:: equ	19		;AND

;Arithmetic
mop_mod1:: equ	20		;%
mop_mod:: equ	21		;Mod
mth_f0op:: equ	22		;Lowest possible float op
mop_add:: equ	22		;Add
mop_sub:: equ	23		;Subtract
mop_mlt:: equ	24		;Multiply
mop_div:: equ	25		;Divide
mth_fmop:: equ	25		;Max possible 2 parameter float op

;Rotates and shifts
mop_lsh1:: equ	26		;>>
mop_lsh2:: equ	27		;<<
mop_lsh:: equ	28		;Logical shift
mop_rot:: equ	29		;Rotate
mop_ash:: equ	30		;Arithmetic shift

;Single operand operators
mth_1prm:: equ	31		;First single operator operand

mop_len:: equ	31		;Length of string
mop_abs:: equ	32		;Absolute value
mop_neg:: equ	33		;Negate
mop_not:: equ	34		;Not (XOR 1)
mop_exp:: equ	35		;Exponent
mop_log:: equ	36		;Logarithm
mop_com1:: equ	37		;~
mop_com:: equ	38		;Complement

mop_0ad:: equ	39		;Minimum address op
mop_pca:: equ	39		;PC address of module
mop_sba:: equ	40		;SB address of module
mop_mda:: equ	41		;MOD address of module
mop_lna:: equ	42		;LINK address of module

mth_mop:: equ	42		;Max math operator

;Termination character codes

trm_fil:: equ	0		;File termination code
trm_cr:: equ	1		;Actual end of physical line
trm_lin:: equ	2		;End of text in line
trm_str:: equ	3		;String terminator but not copied by SKP_SPC
trm_exp:: equ	4		;End of expression
trm_wrd:: equ	5		;End of word
trm_blnk:: equ	6		;Inter-word blank
trm_nul:: equ	7		;Null character (ignored)
trm_inst:: equ	8		;Intra word separater


;************************************
;* Full operating system parameters *
;************************************

max_timer:: equ	8		;Number of timers
	mode	imm,0
tim_cnt:: blkw			;Current count (0=inactive)
tim_rld:: blkw			;Reload count (when count decrements to 0)
tim_adr:: blkd			;Service routine address
tim_stat:: blkb			;Status byte
btim_use:: equ	0		;In use bit if set
btim_adr:: equ	1		;Valid service address if set
tim_last::			;Last address+1
	mode	pc


{
disk file headers: (offsets are from start of file, -1 = none)
  4 bytes file/system id (1st byte is same as directory id)
  32 bytes length/name of associated parameter file:
    window, svc re-route data, default directory, command chain, etc.
  32 bytes length/name of module
  8 bytes additional local module id
    bit 0 is onemod for loader, ignored by linker
  8 bytes offset:d/size:d of symbols
  8 bytes offset:d/size:d of string data
  8 bytes offset:d/size:d of pc relative code
  8 bytes offset:d/size:d of link data (m_link)
  8 bytes offset:d/size:d of cpu mod (t_cxp) table link data
  8 bytes offset:d/size:d of disassembly data (t_symlnk)
  8 bytes offset:d/size:d of line number data
  8 bytes size:d/address:d of stack (-1/0 = nothing for this module)
  4 bytes offset to execution address (from pc code, -1 = not executable)
  4 bytes offset to next header (if multiple modules in file)
  contents of mod_tabl for this module (without link, symbol, name offset)
 symbols
 strings
 pc relative code
 link data
 cxp data
 disassembly data
 line numbers
next header
}

dhd_pc:: equ	4+32+32+8	;Offset to PC offset/size
dhd_stk:: equ	dhd_pc+7*8	;Offset to stack, execution, next header
dhd_mod:: equ	dhd_stk+8+4+4	;Offset to MOD_TABL data

usr_exe:: equ	b'010001000	;User executable file ID byte
usr_dat:: equ	b'010001100	;User data file ID byte

;End of EQU32
