	print	"DISK"

{
disk format:
  track/sector 0: disk id (did_siz bytes)
  fat #1 (variable size)
  optional fat #2 (variable size)
  directory (variable size)
 all above data in reserved fat clusters

To do:
  verify disk in drive by calling ID routine and setting timer/interrupt
}

;Disk directory fields:

	mode	imm,0

dir_name: ds	name_siz	;Name with trailing 0
dir_size: blkd			;File size in bytes (all segments, all disks)
dir_date: blkd			;Date last written
dir_fat1: blkw			;Initial FAT index
dir_fata: blkw			;Absolute FAT number if multi-disks
dir_ext1: blkw			;Unit index to supplementary file (-1 if none)
dir_bits: blkw			;Status bits
dir_siz: 			;Directory size

;dir_bits values

	org	0

dirb_typ: ds	5		;File type
dirt_nul: equ	b'00000		;Null (not unerasable), matches any
dirt_mrg: equ	b'00001		;Morgue for dead sectors
dirt_vrm: equ	b'00010		;Virtual memory file
dirt_vrd: equ	b'00011		;Virtual device file

dirt_svc: equ	b'00100		;SVC extension/modification
dirt_dir: equ	b'00101		;Directory file
dirt_sup: equ	b'00110		;Supplementary directory file

dirt_exe: equ	b'01000		;Executable program file
dirt_ovr: equ	b'01001		;Executable overlay file
dirt_asc: equ	b'01010		;Executable ASCII command file

dirt_dat: equ	b'01100		;Data file
dirt_cfg: equ	b'01101		;Configuration file
dirt_tmp: equ	b'01110 	;Temporary (intermediate) file

dirt_idx: equ	b'11100		;Index to another directory
dirt_atr: equ	b'11101		;Attributes in supplementary file
dirt_fat: equ	b'11110		;FAT
dirt_did: equ	b'11111		;Disk ID

dirb_usr: ds	3		;User/system/boot
				;000 = boot file
				;001 = system file
				;010 = user file

dirb_ro: ds	2		;Protection status
				;00 = User read/write/erase
				;01 = User read only
				;10 = User execute only
				;11 = Supervisor access only

	ds	1		;Spare
dirb_hid: ds	1		;Hidden file if set
dirb_ark: ds	1		;Archived if set
dirb_bak: ds	1		;Backup file if set
dirb_val: ds	1		;Valid directory entry (not erased)
dirb_opn: ds	1		;File open if set

;Disk ID fields

	org	0

did_vers: ds	4+name_siz	;Operating system version number:d, ASCII name
did_name: ds	dir_siz		;Disk data uses filename format

did_ssiz: blkd			;Minimum data block size (sector size in bytes)
did_tsiz: blkd			;Size of 2nd physical division (track size)
did_ysiz: blkd			;Size of 3rd physical division (cylinder size)
did_ksiz: blkd			;Total disk size in bytes

did_boot: blkd			;Offset to boot block
did_bsiz: blkd			;Size of boot block

did_csiz: blkd			;Cluster size in bytes

did_cbit: blkb			;Number of bits per FAT entry
				;  MSB is "valid" flag
did_fmax: blkw			;Number of clusters in FAT table
did_fmin: blkw			;Reserved FAT clusters
did_fat1: blkd			;Offset in bytes to FAT 1
did_fat2: blkd			;Offset in bytes to FAT 2 (same as fat1 if none)

did_dsiz: blkb			;Size of directory entry in bytes
did_dmax: blkw			;Number of directory entries
did_ddir: blkd			;Offset in bytes to root directory

did_sup: blkd			;Size of supplementary cluster unit in bytes
did_nsup: blkd			;Total size of all supplementary data

did_last:			;Size required for memory image
did_siz: equ	256		;Size of disk ID data field

{
date/time format (4 bytes)
  7 bit year
  4 bit month
  5 bit day

  5 bit hours
  6 bit minutes
  5 bit seconds/2
}

sct_siz: equ	1024		;Sector size in bytes
sct_clst: equ	2		;Sectors/cluster
sct_trk: equ	5		;Sectors/track
disk_sid: equ	2		;Sides/disk
trk_sid: equ	40		;Cylinders/side
;
dir_cnt: equ	64		;Minimum number of directories
fat_bits: equ	12		;Number of bits per FAT entry, MSB is "valid" flag
sup_byts: equ	64		;Size of supplementary directory units
;
cls_size: equ	sct_siz*sct_clst ;Number of bytes in a cluster
dsiz_byt: equ	sct_siz*sct_trk*disk_sid*trk_sid ;Size of disk in bytes
dsiz_cls: equ	dsiz_byt/cls_size ;Size of disk in clusters
;
fat_size: equ	(dsiz_cls*fat_bits+7)/8 ;FAT size
rsv_size: equ	(did_siz+2*fat_size+dir_cnt*dir_siz+cls_size-1)/cls_size ;Reserved clusters
num_dirs: equ	(rsv_size*cls_size-(did_siz+2*fat_size))/dir_siz ;Max directories

	mode	pc

;*****************************************
;* Hardware specific read/write routines *
;*****************************************

	disp	2

;-----------------------------------------
; Write bytes in r4, count in r5 to p_disk
;-----------------------------------------

w_pdsk:
	save	[r2,r4,r5]
	until	eq
	 until	fs
	  tbitb	7,p_disk+4*bus_byts ;Main status register
	 endu
	 movb	r4,p_disk+5*bus_byts ;Write byte
	 rotd	-8,r4
	 addqb	-1,r5
	 cmpqb	0,r5
	endu
	movqd	0,r6
	restore	[r2,r4,r5]
	ret


;--------------------------------------
; Read from p_disk, r5 holds byte count
; Return value in r5
;--------------------------------------

r_pdsk:
	save	[r2,r4]
	movqd	0,r4		;Initialize return value
	until	eq
	 until	fs
	  tbitb	7,p_disk+4*bus_byts ;Main status register
	 endu
	 lshd	8,r4
	 movb	p_disk+5*bus_byts,r4 ;Read byte
	 addqb	-1,r5
	 cmpqb	0,r5
	endu
	movd	r4,r5
	movqd	0,r6
	restore	[r2,r4]
	ret


m1o_cinit:
	save	[r3,r4,r5]
	bsr	m1o_cunlog
	movd	4*dof_bdat(r7),r3
	movd	1 lsh (bdp_bdrv+2),dat_dctr(r3) ;Reset bit high
	movd	4*dof_dat(r7),r3 ;Set for 250Kbps, motor, reset bits
	movd	h'14 lsh bdp_drv+2 lsh bdp_rate+1 lsh (bdp_bdrv+2),dat_dctr(r3)

	movqb	0,p_disk+2*bus_byts ;Reset controller
	sbitb	7,icu_adr+3*bus_byts ;Level triggered
	sbitb	7,icu_adr+5*bus_byts ;Active high from 8473 INT pin
	movqb	4,p_disk+2*bus_byts ;Clear register

	movd	h'1d003,r4	;Specify command, 6ms step, no DMA
	movqd	3,r5
	bsr	w_pdsk

	movd	h'd1002201,r4	;Mode, Implied seek, IBM format, no wild
	movqd	4,r5
	bsr	w_pdsk
	movqd	0,r4
	movqb	1,r5
	bsr	w_pdsk

	movqd	0,r4
	bsr	opo_timer
	movd	r5,dat_motor(r3) ;Pointer to motor timer
	addr	motor_off,tim_adr(r5) ;Service address
	sbitb	btim_adr,tim_stat(r5) ;Valid service address
	movzbd	int_second/2,r4	;Twice each second
	bsr	opo_timer
	addr	chg_chek,tim_adr(r5)
	sbitb	btim_adr,tim_stat(r5) ;Valid service address

	restore	[r3,r4,r5]
	ret


;-----------------
; Low level format
;-----------------

m1o_clfmt:
	save	[r0,r1,r2,r3,r4,r5]
	bsr	dsk_home	;Start at cylinder 0
	bsr	sel_drive
	movd	4*dof_dat(r7),r2
	extsd	dat_dctr+bdp_drv/8(r2),r3,bdp_drv mod 8,2 ;Requested drive

	movqd	0,r1		;Start with cylinder 0
	until	eq		;Cylinder loop
	 movzbd	r1,r1		;Keep only cylinder
	 until	ls		;Track loop
	  movzwd r1,r1		;Keep only cylinder, head
	  ord	h'3010000,r1	;Sector, sector size
	  movqb	4,r0		;Number of bytes to write per sector
	  movd	h'503004d,r4	;Format command
	  movw	r1,r5
	  movqb	0,r5
	  lshw	-6,r5		;Head to bit 2
	  orb	r3,r5		;Drive selection
	  lshw	8,r5
	  orw	r5,r4
	  movqd	4,r5
	  bsr	w_pdsk		;1st four bytes of command
	  sprw	psr,tos
	  bicpsrw flag_i	;Interrupts off now
	  movzwd h'6d64,r4	;Gap length and fill character
	  movqd	2,r5
	  bsr	w_pdsk		;Write rest of command
	  until	fs
	   tbitb 5,p_disk+4*bus_byts
	  endu			;Wait for execution phase
	  begin			;Sector loop
	   movb	p_disk+4*bus_byts,r5
	   tbitb 5,r5
	  while	fs		;Still going if fs
	   tbitb 7,r5		;See if it wants a byte yet
	   if	fs
	    movb r1,p_disk+5*bus_byts ;Next sector ID byte
	    rotd -8,r1
	    addqb -1,r0
	    cmpqb 0,r0
	    if	eq
	     movqb 4,r0
	     addd h'10000,r1	;Next sector
	    endif
	   endif
	  endw
	  lprw	psr,tos		;Restore previous interrupt status
	  bsr	get_stat
	  cmpqd	0,r6
	  if	eq		;Verify track if OK so far
	   movzbd h'51,r4	;Scan equal
	   movw	r1,r5
	   movqb 0,r5
	   lshw	-6,r5		;Head to bit 2
	   orb	r3,r5		;Drive selection
	   lshw	8,r5
	   orw	r5,r4		;2nd byte of command
	   movzbd r1,r5		;Track
	   lshd	16,r5
	   ord	r5,r4		;Track to byte 3
	   movzwd r1,r5
	   movqb 0,r5
	   lshd	16,r5		;Head
	   ord	r5,r4
	   movqd 4,r5
	   bsr	w_pdsk		;1st four bytes of command
	   movd	h'64050301,r4
	   movqd 4,r5
	   bsr	w_pdsk		;Next four bytes of command
	   sprw	psr,tos
	   bicpsrw flag_i	;Interrupts off now
	   movqb 1,r4		;Step size
	   movqd 1,r5
	   bsr	w_pdsk		;Write rest of command
	   until fs
	    tbitb 5,p_disk+4*bus_byts
	   endu			;Wait for execution phase
	   begin		;Head loop
	    movb p_disk+4*bus_byts,r5
	    tbitb 5,r5
	   while fs		;Still going if fs
	    tbitb 7,r5		;See if it wants a byte yet
	    if	fs
	     movb h'6d,p_disk+5*bus_byts ;Compare with this
	    endif
	   endw
	   lprw	psr,tos		;Restore previous interrupt status
	   bsr	get_stat
	  endif
	  cmpqd	0,r6
	 quit	ne
	  addw	h'100,r1	;Next head
	  cmpw	h'200,r1
	 endu
	 cmpqd	0,r6
	quit	ne
	 addqb	1,r1
	 cmpb	trk_sid,r1
	 if	hi		;Step to next cylinder if hi
	  movb	r1,r5		;Next cylinder
	  bsr	drv_off		;Seek expects this off
	  bsr	seek
	  cmpqd	0,r6
	  if	eq
	   bsr	sel_drive	;Seek de-selects, keep it going
	  endif
	 endif
	 cmpqd	0,r6
	quit	ne
	 cmpb	trk_sid,r1
	endu
	bsr	drv_off
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;----------------------------------------
; Read one ID field and return ID in r5
; R5 holds 2nd byte of command
; Return track, head, sector, sector size
; Drive assumed selected and ready
;----------------------------------------

read_id:
	save	[r4]
	movd	r5,r4
	lshw	8,r4		;2nd byte of command
	movb	h'4a,r4		;1st byte of command
	movqd	2,r5
	bsr	w_pdsk		;Send command
	movqd	3,r5
	bsr	r_pdsk		;Status registers
	movd	r5,r4
	movqd	4,r5
	bsr	r_pdsk		;Requested info to r5
	movd	r4,r6		;Status registers
	andd	h'c00000,r6	;OK if 0
	cmpqd	0,r6
	if	ne
	 movzwd	exp bstat_re,r6	;Assume recoverable error
	endif
	restore	[r4]
	ret


;-------------------------------------------
; Identify drive format and setup DID fields
; Installs buffer if none defined
;-------------------------------------------

disk_id:
	save	[r0,r1,r2,r3,r4,r5]
	bsr	dsk_home	;Always use cylinder 0
	bsr	sel_drive	;Drive on
	movd	4*dof_dat(r7),r3

	sprw	psr,tos
	bicpsrw	flag_i		;Interrupts off now
	extsd	dat_dctr+bdp_drv/8(r3),r5,bdp_drv mod 8,2 ;Requested drive
	bsr	read_id		;Read 1st ID mark
	movd	r5,r2		;1st sector read
	movd	r5,r0		;Lowest sector
	movd	r5,r1		;Highest sector
	until	eq
	 extsd	dat_dctr+bdp_drv/8(r3),r5,bdp_drv mod 8,2 ;Requested drive
	 bsr	read_id
	 cmpqd	0,r6
	quit	ne
	 cmpd	r5,r0
	 if	lo
	  movd	r5,r0		;New lowest sector
	 endif
	 cmpd	r5,r1
	 if	hi
	  movd	r5,r1		;New highest sector
	 endif
	 cmpd	r5,r2		;Read IDs until original sector found again
	endu	
	lprw	psr,tos		;Restore interrupt status
	cmpqd	0,r6
	if	eq
	 lshd	-8,r0		;Sector to LSB
	 lshd	-8,r1
	 subb	r0,r1
	 movzbd	r1,r1
	 addqb	1,r1		;Number of sectors in r1
	 movzbd	128,r0
	 begin
	  cmpqb	0,r5
	 while	ne
	  addd	r0,r0
	  addqb	-1,r5
	 endw			;Sector size in r0
	 muld	r0,r1		;Track size
	 movd	r1,r2		;Cylinder size if single-sided
	 extsd	dat_dctr+bdp_drv/8(r3),r5,bdp_drv mod 8,2 ;Requested drive
	 sbitb	2,r5		;Side 1
	 bsr	read_id
	 cmpqd	0,r6		;2 sides if eq
	 if	eq
	  addd	r2,r2		;2 tracks/cylinder
	 endif
	 cmpqd	0,dat_bsz(r3)	;Use existing buffer if defined
	 if	eq		;Get new buffer if not defined
	  movd	r0,r4		;Sector size
	  movqd	0,r5		;Supervisor mode
	  bsr	opo_newbf
	  cmpqd	0,r6
	  if	eq
	   movd	r5,r4
	   bsr	opo_lonbf
	   movd	r5,dat_bufh(r3)
	   movd	(r5),dat_bpt(r3) ;Buffer here
	   movd	4(r5),dat_bsz(r3)
	   addqd -1 dat_bsz(r3)
	   movqd 0,dat_bchr(r3)	;Buffer empty
	   movd	(r5),dat_did(r3)
	   movqd 0,dat_absch(r3) ;Buffer empty
	  endif
	 endif
	 cmpqd	0,r6		;Make sure everything still OK
	 if	eq
	  movw	dirt_did,dat_dirt(r3)
	  movd	dat_did(r3),r4
	  movd	r0,dat_ssiz(r3)
	  movd	r0,did_ssiz(r4)	;Store sector size
	  movd	r1,did_tsiz(r4)
	  movd	r2,did_ysiz(r4)	;Cylinder same as track if only one side
	  movqd	0,r4
	  bsr	m1o_cfill	;Now read whole sector into buffer
	  movd	dat_did(r3),r4
	  movd	r0,did_ssiz(r4)
	  movd	r1,did_tsiz(r4)
	  movd	r2,did_ysiz(r4)	;Restore in case disk was just formatted
	 endif
	endif

	movd	r6,r0		;Return this status
	bsr	drv_off		;De-select
	movd	r0,r6
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;----------------------------------
; Select disk drive and start motor
;----------------------------------

sel_drive:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_bdat(r7),r2 ;Base data block
	movd	4*dof_dat(r7),r3 ;Physical data pointer
	until	fc
	 sbitb	bdp_on,dat_dctr(r2) ;Set "in use" bit
	endu
	extsb	dat_dctr+bdp_rate/8(r3),r5,bdp_rate mod 8,2 ;Rate select bits
	inssb	r5,dat_dctr+bdp_brate/8(r2),bdp_brate mod 8,2 ;Rate select bits
	movb	r5,p_disk+7*bus_byts ;Set data rate
	extsb	dat_dctr+bdp_drv/8(r3),r0,bdp_drv mod 8,8 ;Select bits
	extsb	dat_dctr+bdp_bdrv/8(r2),r1,bdp_bdrv mod 8,8 ;Current selection
	andb	h'f4,r1		;Keep only motor, reset bits
	movb	r0,r4
	orb	r1,r4
	inssb	r4,dat_dctr+bdp_bdrv/8(r2),bdp_bdrv mod 8,8 ;New selection
	movb	r4,p_disk+2*bus_byts ;Select drive, motor on
	movd	dat_motor(r3),r5 ;Pointer to motor timer word
	andb	r0,r1
	andb	h'f0,r1		;Only check motor bits
	cmpqb	0,r1		;Drive already on if ne
	if	eq		;Select this drive if eq
	 cbitb	btim_adr,tim_stat(r5) ;Don't want motor off routine called
	 movb	int_second*3/4,(r5) ;Startup time
	 until	eq
	  cmpqb	0,(r5)
	 endu
	endif
	movb	2*int_second,(r5) ;Start or reset timer
	sbitb	btim_adr,tim_stat(r5) ;Enable motor off service routine
	restore	[r0,r1,r2,r3,r4,r5]
	movqd	0,r6
	ret


;----------------
; De-select drive
;----------------

drv_off:
	save	[r0,r1,r2,r3]
	movd	4*dof_dat(r7),r3
	movd	4*dof_bdat(r3),r2 ;Base data block

;Re-select since interrupt status may have changed

	extsb	dat_dctr+bdp_drv/8(r3),r0,bdp_drv mod 8,8 ;Select bits
	extsb	dat_dctr+bdp_bdrv/8(r2),r1,bdp_bdrv mod 8,8 ;Current selection
	andb	h'f4,r1		;Keep only motor, reset bits
	orb	r0,r1
	inssb	r1,dat_dctr+bdp_bdrv/8(r2),bdp_bdrv mod 8,8 ;New selection
	movb	r1,p_disk+2*bus_byts ;Update interrupt status
	cbitb	bdp_on,dat_dctr(r2) ;No longer in use
	restore	[r0,r1,r2,r3]
	ret


;-----------------------------
; Turn off motor if not in use
; Uses interrupt clock
;-----------------------------

	disp	1

motor_off:
	movd	r3,tos
	movd	4*dev_m1(dev_ptr),r3 ;R7 pointer
	movd	4*dof_bdat(r3),r3 ;Base data block
	sbitb	bdp_on,dat_dctr(r3) ;See if in use
	if	fc		;Drive inactive if fc
	 inssb	4,dat_dctr+bdp_bdrv/8(r3),bdp_bdrv mod 8,8 ;Everything off
	 movqb	4,p_disk+2*bus_byts ;Motors off, reset bit high
	 cbitb	bdp_on,dat_dctr(r3) ;Free again
	else			;Reset timer if fs
	 movd	dat_motor(r3),r3 ;Pointer to motor timer word
	 movb	2*int_second,(r3) ;Reset timer
	endif
	movd	tos,r3
	ret


;Wait for end of seek or home
;R3 must hold dat pointer, interrupt disabled on exit
;Return status in r5

seek_end:
	until	fs
	 tbitb	7,icu_adr+7*bus_byts ;Wait for interrupt
	endu
	movb	8,p_disk+5*bus_byts ;Sense interrupt command
	movqd	2,r5
	bsr	r_pdsk
	cbitb	bdp_drv+3,dat_dctr(r3) ;Interrupt off again
	bsr	drv_off		;De-select drive now
	movd	r5,r6
	andd	h'c000,r6	;Normal completion if eq
	cmpqd	0,r6
	if	ne
	 movzwd	exp bstat_re,r6	;Assume recoverable error
	endif
	ret


;----------
; Home head
;----------

dsk_home:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	sbitb	bdp_drv+3,dat_dctr(r3) ;Interrupt enabled for now
	bsr	sel_drive	;Select drive
	extsd	dat_dctr+bdp_drv/8(r3),r4,bdp_drv mod 8,2 ;Requested drive
	lshw	8,r4
	movqb	7,r4		;Recalibrate command
	movqd	2,r5
	movb	h'f,icu_adr+7*bus_byts ;Clear any previous interrupt
	bsr	w_pdsk		;Send command
	bsr	seek_end
	cmpqd	0,r6
	if	ne
	 tbitb	8+4,r5		;Equipment check
	 if	fs
	  movzbd exp bstat_fe,r6 ;No track 0 signal from drive
	 endif
	endif
	restore	[r3,r4,r5]
	ret


;-----------------
; Seek track in r5
;-----------------

seek:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3 ;Data pointer
	sbitb	bdp_drv+3,dat_dctr(r3) ;Interrupt enabled for now
	bsr	sel_drive	;Select drive
	extsd	dat_dctr+bdp_drv/8(r3),r4,bdp_drv mod 8,2 ;Requested drive
	lshw	8,r4
	movb	h'f,r4		;Seek command
	lshd	16,r5
	ord	r5,r4		;Track to byte 3
	movqd	3,r5
	movb	h'f,icu_adr+7*bus_byts ;Clear any previous interrupt
	bsr	w_pdsk		;Send command
	bsr	seek_end
	restore	[r3,r4,r5]
	ret

	disp	2

;------------------------------------
; Check for disk change in all drives
;------------------------------------

chg_chek:
	save	[all]
	movd	4*dev_m1(dev_ptr),r7 ;R7 pointer
	movd	4*dof_bdat(r7),r3 ;Base data block
	sbitb	bdp_on,dat_dctr(r3) ;See if in use
	if	fc		;Can't check if in use
	 extsd	dat_dctr+bdp_bdrv/8(r3),r0,bdp_bdrv mod 8,8 ;Select bits
	 movqd	4+drv_max-1,r2	;Highest motor select bit
	 movqd	4+drv_max-1,r1	;Highest select code and reset bit
	 until	gt
	  tbitb	r2,r0		;See if motor on
	  if	fc		;Skip check if motor on
	   sbitb r2,r1
	   movb	r1,p_disk+2*bus_byts ;Select drive
	   movqb 4,p_disk+5*bus_byts ;Sense drive status
	   until fs
	    tbitb 7,p_disk+4*bus_byts ;Wait until ready for 2nd byte
	   endu
	   extsd r1,r4,0,2	;Drive selection
	   movb r4,p_disk+5*bus_byts ;2nd byte is drive selection
	   until fs
	    tbitb 7,p_disk+4*bus_byts ;Wait for status byte
	   endu
	   extsb p_disk+5*bus_byts,r5,6,1 ;Write protect status
	   movb	r0,p_disk+2*bus_byts ;Original status
	   addb	r4,r4		;Offset to ch/wp pair
	   addb	bdp_wp1,r4	;Bit offset to selected drive write protect
	   extb	r4,dat_dctr(r3),r6,1 ;Previous status
	   insb	r4,r5,dat_dctr(r3),1 ;Update current status
	   xorb	r5,r6		;See if it changed
	   tbitb 0,r6
	   if	fs		;Disk changed if fs
	    addqb bdp_ch1-bdp_wp1,r4 ;Offset to change status
	    sbitb r4,dat_dctr(r3) ;Update change status
	   endif
	   cbitb r2,r1
	  endif
	  addqb	-1,r2
	  addqb	-1,r1
	  cmpqb	4,r1
	 endu
	 cbitb	bdp_on,dat_dctr(r3) ;Free again
	endif
	restore	[all]
	ret


;-------------------------------------
; 1st byte of read/write command given
; R4 holds absolute starting byte
; Finish command to disk controller
; Interrupts assumed off
; Wait for execution phase
;-------------------------------------

set_sctr:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2	;Pointer to DID parameters
	movd	r4,r0
	divd	did_ysiz(r2),r4	;Starting cylinder
	lshw	8,r4		;2nd byte is track
	modd	did_ysiz(r2),r0	;Absolute byte within cylinder
	movd	r0,r1
	divd	did_tsiz(r2),r1	;Head selection
	modd	did_tsiz(r2),r0	;Absolute byte within track
	divd	did_ssiz(r2),r0	;Sector within track
	addqd	1,r0		;Start with sector 1
	rotd	-8,r0		;Sector to byte 4
	ord	r0,r4
	extsb	dat_dctr+bdp_drv/8(r3),r4,bdp_drv mod 8,2 ;Drive selection
	movb	r1,r5
	lshb	2,r5		;Head selection to bit 2
	orb	r5,r4		;Merge in drive selection
	sbitb	7,r4		;Implied seek
	lshd	16,r1
	ord	r1,r4		;Head
	movqd	4,r5
	bsr	w_pdsk		;2nd 4 bytes of command
	lshd	-16,r4		;Ending sector to 2nd byte
	movd	did_ssiz(r2),r1	;Sector size
	lshd	-7,r1
	movqb	0,r4		;Byte code for 128 bytes per sector
	begin
	 tbitb	0,r1
	while	fc
	 lshd	-1,r1
	 addqb	1,r4		;Sector size in byte 0
	endw			;Size code is (log of size)-7
	ord	100 lsh 16,r4	;Intersector gap length to byte 3
	cmpqb	0,r4
	if	eq
	 ord	128 lsh 24,r4	;Data length in byte 4
	else
	 ord	h'ff000000,r4	;Data length not used
	endif
	movqd	4,r5
	bsr	w_pdsk
	until	fs
	 tbitb	5,p_disk+4*bus_byts ;Start of execution phase
	endu
	movqd	0,r6

	restore	[r0,r1,r2,r3,r4,r5]
	ret


;----------------------------
; Read/write command complete
; Return status in r5
;----------------------------

get_stat:
	save	[r1]

	movqb	3,r5		;Status register bytes to read
	bsr	r_pdsk
	cbitb	15,r5		;TC error, not applicable without DMA
	cmpd	h'400000,r5	;Check for other errors
	if	eq
	 movqd	0,r5
	endif
	movd	r5,r1		;Save here
	cmpqd	0,r6
	if	eq
	 movqb	4,r5		;Remaining bytes to read
	 bsr	r_pdsk
	endif
	movd	r1,r5		;Return code
	cmpqd	0,r6
	if	eq		;All status bytes read successfully if eq
	 andd	h'c00000,r1	;OK if 0
	 cmpqd	0,r1
	 if	ne
	  sbitb	bstat_re,r6	;Assume recoverable error
	  movd	r5,r1
	  andw	h'8240,r1	;End of track, write protect, control mark
	  cmpqw	0,r1
	  if	ne
	   movzbd exp bstat_fe,r6 ;Fatal error
	  endif
	 endif
	endif

	restore	[r1]
	ret


;-------------------------------------------
; Flush buffer, write updated data as needed
;-------------------------------------------

m1o_cflush:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_ssiz(r3),r5
	movd	dat_absch(r3),r0 ;Total size of buffer
	addqd	-1,r0		;Highest offset
	divd	r5,r0		;Highest sector offset
	movqd	0,r6
	begin
	 cmpqd	0,r6
	quit	ne		;Error if ne
	 cmpqd	0,r0
	while	le
	 movd	dat_bupd(r3),r1
	 tbitb	r0,(r1)		;See if buffer altered
	 if	fs		;Changed if fs
	  bsr	sel_drive
	  movd	dat_ssiz(r3),r1	;Sector size
	  muld	r0,r1		;Offset for this operation
	  movd	dat_absbf(r3),r4
	  addd	r1,r4		;Address for write
	  movb	b'01000101,p_disk+5*bus_byts ;Write data command
	  addd	dat_bpt(r3),r1 ;Address of data
	  sprw	psr,tos
	  bicpsrw flag_i	;Interrupts off for disk operations
	  bsr	set_sctr	;Finish command according to r4
	  cmpqd 0,r6
	  if	eq
	   begin
	    movb p_disk+4*bus_byts,r2
	    tbitb 5,r2		;End of execution phase if fc
	   while fs
	    tbitb 7,r2		;Data ready if set
	    if	fs
	     movb (r1),p_disk+5*bus_byts ;Write data
	     addqd 1,r1
	    endif
	   endw
	   bsr	get_stat	;Set completion status in r6
	   cmpqd 0,r6
	   if	eq
	    movd dat_bupd(r3),r1
	    cbitb r0,(r1)	;Mark unchanged
	   endif
	  endif
	  lprw	psr,tos		;Restore previous interrupt status
	  bsr	drv_off		;De-select drive
	 endif
	 addqd	-1,r0
	endw
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-------------------------------------------
; Clear buffer, write updated data as needed
;-------------------------------------------

m1o_cclear:
	save	[r2,r3]
	call	m1o_cflush
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r2
	movqd	0,dat_bchr(r3)	;Clear buffers
	movqd	0,dat_absch(r3)
	movqd	0,dat_brdx(r3)
	movqd	0,dat_bwtx(r3)	;Reset read/write indexes
	movqd	0,dat_bchr(r2)	;These too
	movqd	0,dat_absch(r2)
	movqd	0,dat_brdx(r2)
	movqd	0,dat_bwtx(r2)
	restore	[r2,r3]
	ret


;-----------------------------------
; Fill buffer, r4 = absolute address
;-----------------------------------

m1o_cfill:
	save	[r0,r1,r2,r4]
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	bsr	m1o_cclear	;Clear buffer
	movzwd	exp bstat_re,r6	;Assume recoverable error
	movd	dat_ssiz(r3),r5
	movd	r4,r1
	divd	r5,r1
	muld	r5,r1		;Actual starting position
	movd	r1,dat_absbf(r3) ;New absolute address
	subd	r1,r4
	movd	r4,dat_brdx(r3)
	movd	r4,dat_bwtx(r3)
	movd	r4,dat_bchr(r3)	;Offset to start of requested data
	movd	dat_bsz(r3),r0
	addqd	1,r0		;Total size of buffer
	divd	r5,r0		;Number of physical sectors in buffer
	addqd	-1,r0		;Index of highest sector in buffer
	movqd	0,r6
	begin
	 cmpqd	0,r6
	quit	ne		;Error if ne
	 cmpqd	0,r0
	while	le
	 bsr	sel_drive
	 movd	dat_ssiz(r3),r1	;Sector size
	 muld	r0,r1		;Offset to current sector
	 movd	dat_absbf(r3),r4
	 addd	r1,r4		;Address for write
	 addd	dat_bpt(r3),r1 ;Target address in buffer
	 movb	b'01000110,p_disk+5*bus_byts ;Read data command
	 sprw	psr,tos
	 bicpsrw flag_i		;Interrupts off for disk operations
	 bsr	set_sctr	;Finish command according to r4
	 cmpqd	0,r6
	 if	eq
	  begin
	   movb p_disk+4*bus_byts,r2
	   tbitb 5,r2		;End of execution phase if fc
	  while	fs
	   tbitb 7,r2		;Data ready if set
	   if fs
	    movb p_disk+5*bus_byts,(r1) ;Read data
	    addqd 1,r1
	   endif
	  endw
	  bsr	get_stat	;Set completion status in r6
	  cmpqd 0,r6
	  if	eq
	   addd dat_ssiz(r3),dat_absch(r3) ;One more block in buffer
	   movd dat_bupd(r3),r1
	   cbitb r0,(r1)	;Unchanged
	  endif
	 endif
	 lprw	psr,tos		;Restore previous interrupt status
	 bsr	drv_off		;De-select drive
	 addqd	-1,r0
	endw
	movd	4*dof_dat(r7),r2
	movd	dat_brdx(r3),dat_brdx(r2)
	movd	dat_bwtx(r3),dat_bwtx(r2)
	movd	dat_bchr(r3),dat_bchr(r2)
	restore [r0,r1,r2,r4]
	ret


;*************************
;* General disk routines *
;*************************

;------------------------------------
; Mark buffer offset in r4 as updated
;------------------------------------

m1o_csetupd:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Use base data pointer
	cmpd	dat_absch(r3),r4 ;Must be in range
	if	hi
	 divd	dat_ssiz(r3),r4	;Sector offset
	 movd	dat_bupd(r3),r5	;Pointer to change flags
	 sbitb	r4,(r5)		;Mark changed
	endif
	restore	[r3,r4,r5]
	ret


;------------------------------------------------------
; Return r7 base pointer in r7, r5 holds requested type
; Always return output r7
;------------------------------------------------------

get_r7:
	save	[r3]
	tbitb	b_iodev,svc_r6	;Use output device
	if	fs		;Input if fs
	 movd	4*dof_dat(r7),r3
	 movzbd dat_io(r3),r7
	 movd	(dev_ptr)[r7:d],r7
	endif
	begin
	 movd	4*dof_dat(r7),r3
	 movd	dat_bdat(r3),r3	;Base data pointer
	 cmpb	dat_dirt(r3),r5
	quit	eq		;Found if eq
;	 cmpqb	lnt_base,4*dof_id+3(r7)
	while	ne
	 movzbd	4*dof_id+dofid_max(r7),r3 ;Dof_max
	 movd	name_siz+lnk_r7(r7)[r3:d],r7
	endw
	restore	[r3]
	ret


;-----------------------------------------------------
; Return buffer pointer in r5, r5 holds requested type
;-----------------------------------------------------

data_bfr:
	save	[r3,r7]
	bsr	get_r7		;Get r7 pointer
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_bpt(r3),r5
	addd	dat_brdx(r3),r5	;Offset from base
	restore	[r3,r7]
	ret


;--------------------------------------
; Return next cluster in r5, -1 if none
; R5 holds current cluster
;--------------------------------------

get_clstr:
	save	[r0,r1,r2,r3,r4]
	movd	r5,r4		;Save here
	movzbd	dirt_fat,r5
	bsr	data_bfr	;Get pointer to buffer in r5
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_did(r3),r2	;Pointer to DID parameters
	movzbd	did_cbit(r2),r1	;Bit size of a FAT entry
	muld	r1,r4		;Bit offset to current FAT entry
	extd	r4,(r5),r5,16	;Read max possible number of bits
	subd	32+1,r1		;Negate unwanted bits and "valid" bit
	movqd	-1,r0
	lshd	r1,r0		;Bit mask for next entry
	andd	r0,r5
	cmpd	r0,r5		;End of the line if eq
	if	eq
	 movqd	-1,r5
	endif
	restore [r0,r1,r2,r3,r4]
	ret


;R4 holds FAT bit index, mark it changed

fat_change:
	save	[r1,r3,r4,r5,r7]
	movd	r4,r1		;Save bit index
	movzbd	dirt_fat,r5
	bsr	get_r7		;Get FAT r7
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	lshw	-3,r4		;Byte offset
	addd	dat_brdx(r3),r4	;Base offset to 1st FAT entry
	bsr	m1o_csetupd

	movd	dat_did(r3),r5
	movzbd	did_cbit(r5),r4	;Bits in a FAT entry
	addr	-1(r1)[r4:b],r4	;Valid bit could be in next sector
	lshw	-3,r4		;Convert to byte offset
	addd	dat_brdx(r3),r4	;Base offset to 1st FAT entry
	bsr	m1o_csetupd

	restore	[r1,r3,r4,r5,r7]
	ret


;-----------------------------------------
; R5 holds cluster number, clear valid bit
;-----------------------------------------

clr_clstr:
	save	[r1,r2,r3,r4,r5]
	movd	r5,r4
	movzbd	dirt_fat,r5
	bsr	data_bfr	;Base address of buffer in r5
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_did(r3),r2
	movzbd	did_cbit(r2),r1	;Bits in a FAT entry
	muld	r1,r4		;Bit offset
	addr	-1(r4)[r1:b],r1	;Valid bit of requested cluster
	cbitd	r1,(r5)
	bsr	fat_change	;Mark FAT index in r4 as changed
	restore [r1,r2,r3,r4,r5]
	ret


;-------------------------------------
; Chain cluster in r4 to cluster in r5
;-------------------------------------

put_clstr:
	save	[r0,r1,r2,r3,r4,r5]

	movd	r5,r0		;New cluster to add
	movzbd	dirt_fat,r5
	bsr	data_bfr	;Base address of buffer in r5
	movd	4*dof_dat(r7),r2
	movd	dat_bdat(r2),r2	;Base data pointer
	movd	dat_did(r2),r2
	movzbd	did_cbit(r2),r2	;Bits in a FAT entry
	muld	r2,r4		;Bit offset
	extd	r4,(r5),r1,16	;Read max possible number of bits
	addqd	-1,r2		;Bit offset to valid bit
	sbitb	r2,r0		;Set valid bit
	subd	32-1,r2		;Negate unwanted bits
	movqd	-1,r3
	lshd	r2,r3
	andd	r3,r0
	bicd	r3,r1
	ord	r0,r1
	insd	r4,r1,(r5),16
	bsr	fat_change	;Mark FAT entry as changed

	restore [r0,r1,r2,r3,r4,r5]
	ret

nfat_sub:
	movd	r5,tos		;Save original
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_did(r3),r2
	cmpw	did_fmax(r2),r5
	if	ls		;Invalid if ls
	 movzwd	did_fmin(r2),r5	;Start with first possible cluster
	endif
	movd	r5,r4		;Working cluster index
	movzwd	did_fmax(r2),r0	;Number of clusters
	movzbd	did_cbit(r2),r1	;Bits in a FAT entry
	movzbd	dirt_fat,r5
	bsr	data_bfr
	movd	r5,r2		;Start of buffer here
	muld	r1,r0		;Max offset+1
	addqd	2,r4
	muld	r1,r4		;Bit offset of 2nd following cluster
	addqd	-1,r4		;Valid bit of next possible cluster
	addqd	1,r5		;Next possible cluster index
	begin
	 movzbd	exp bstat_fe,r6	;Assume fatal error if disk full
	 cmpd	r4,r0		;Must be below max
	quit	hi
	 movqd	0,r6		;Assume OK
	 sbitb	r4,(r2)
	while	fs
	 addqd	1,r5
	 addd	r1,r4		;Advance to next cluster
	endw
	movd	tos,r0		;Original starting cluster
	cmpqd	0,r6
	if	eq
	 movd	r5,r4		;Cluster to write to
	 movqw	-1,r5
	 bsr	put_clstr	;Nothing follows
	 movd	r4,r5		;Restore r5
	 movd	dat_did(r3),r2
	 cmpw	did_fmax(r2),r0
	 if	hi		;Valid starting cluster if hi
	  movd	r0,r4
	  bsr	put_clstr	;Previous cluster chains to new one
	 endif
	endif
	ret


;-------------------------------------------------
; Get and setup new FAT block
; R5 holds current cluster, or -1 if first cluster
; New cluster returned in r5, chained in FAT
;-------------------------------------------------

nxt_fat:
	save	[r0,r1,r2,r3,r4]
	bsr	nfat_sub	;Search from r5
	cmpqd	0,r6
	if	ne		;Search from beginning if nothing yet
	 movqd	-1,r5		;Invalid entry wraps to beginning
	 bsr	nfat_sub
	endif
	restore [r0,r1,r2,r3,r4]
	ret


;----------------------------------
; Clear all clusters to end of file
; Start with cluster in r5
;----------------------------------

era_eof:
	save	[r4,r5]

	movd	r5,tos
	until	eq
	 bsr	clr_clstr	;Clear current cluster
	 bsr	get_clstr	;Get next cluster
	 cmpqd	-1,r5		;No more if -1
	endu
	movd	tos,r4		;Initial cluster
	movqd	-1,r5
	bsr	put_clstr	;Current cluster is last
	
	restore	[r4,r5]
	ret


;---------------------------------------------------------
; Convert data buffer index in r4 to relative file address
;---------------------------------------------------------

idx2rel:
	save	[r1,r2,r3]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	movzwd	dat_fatr(r3),r1
	muld	did_csiz(r2),r1	;Number of bytes to start of this cluster
	addd	r1,r4
	movd	dat_absbf(r3),r1 ;Start of buffer
	modd	did_csiz(r2),r1 ;Byte count from start of cluster
	addd	r1,r4		;Relative file index
	restore	[r1,r2,r3]
	ret


;-------------------------------------
; Mark current directory entry changed
;-------------------------------------

dir_change:
	save	[r2,r3,r4,r5,r7]
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r3	;Base data pointer
	movd	dat_did(r3),r2
	movd	dat_dir(r3),r4	;Pointer to current entry
	movzbd	dirt_dir,r5
	bsr	get_r7
	movd	4*dof_dat(r7),r3
	subd	dat_bpt(r3),r4	;Make offset from base
	bsr	m1o_csetupd
	movzbd	did_dsiz(r2),r5
	addr	-1(r4)[r5:b],r4	;Address of last byte
	bsr	m1o_csetupd	;In case it spans sectors
	restore	[r2,r3,r4,r5,r7]
	ret


;-----------------
; Update directory
;-----------------

dir_updt:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	movd	dat_dir(r3),r1	;Pointer to directory
	movzwd	dat_fatr(r3),r5
	muld	did_csiz(r2),r5	;Number of bytes to start of this cluster
	movd	dat_bdat(r3),r4	;Base data pointer
	movd	dat_absbf(r4),r4 ;Start of buffer
	modd	did_csiz(r2),r4 ;Byte count from start of cluster
	addd	r4,r5
	addd	dat_bchr(r3),r5	;Number of bytes in this cluster
	cmpd	dir_size(r1),r5
	if	lo
	 movd	r5,dir_size(r1)	;File extended, update directory
	 bsr	dir_change	;Mark directory changed
	endif
	restore	[r1,r2,r3,r4,r5]
	ret


;----------------------------------------------
; Compare (R1),(R2), dat_ptcl holds procedures
; bdp_wld set suppresses wildcards "?" and "*"
; bdp_lc set suppresses LC to UC translation
; "?" in (R1) matches any (R2) except "."
;   bdp_? set matches "?" to "." too
; "*" in (R1) matches until next "." in R2
; Flags set according to CMPB (R1),(R2) on exit
;----------------------------------------------

cmp_case:
	save	[r0,r3,r4,r5]
	movd	4*dof_dat(r7),r0
	movd	dat_ptcl(r0),r0	;Protocol bits
	movb	name_siz,r0	;Max possible length for (r1) string
	movb	r0,r5		;Max possible length for (r2) string
	begin
	 movb	r0,r3
	 andb	(r1),r3		;Done if either is 0
	 movb	r5,r4
	 andb	(r2),r4		;Done if either is 0
	 cmpqb	0,r3
	quit	eq
	 cmpqb	0,r4
	quit	eq
	 movb	(r1),r3
	 movb	(r2),r4
	 tbitb	bdp_lc,r0	;LC to UC suppressed if set
	 if	fc
	  cmpb	"a",r3
	  if	ls
	   cmpb	"z",r3
	   if	hs
	    subb "a"-"A",r3
	   endif
	  endif
	  cmpb	"a",r4
	  if	ls
	   cmpb	"z",r4
	   if	hs
	    subb "a"-"A",r4
	   endif
	  endif
	 endif
	 tbitb	bdp_wld,r0	;Wildcards ignored if set
	 if	fc
	  cmpb	"*",r3
	  if	eq		;Skip (r2) characters until "."
	   begin
	    cmpb ".",(r2)
	   quit eq
	    cmpqb 1,r5		;Don't exhaust string here
	   quit	hs
 	    cmpqb 0,1(r2)	;Don't skip terminating 0
	   while ne
	    addqd 1,r2
	    addqb -1,r5
	   endu
	   movb	r3,r4		;Anything matches here
	  else
	   cmpb	"?",r3
	   if	eq
	    tbitb bdp_?,r0	;Match anything if set
	    if	fs
	     movb r3,r4		;Anything matches
	    else
	     cmpb ".",r4	;Match anything but this
	    orif ne
	    endif
	   endif
	  endif
	 endif
	 cmpb	r3,r4
	while	eq
	 addqd	1,r1
	 addqd	1,r2
	 addqb	-1,r0
	 addqb	-1,r5
	endw
	cmpb	r3,r4		;Set flags according to final result
	restore	[r0,r3,r4,r5]
	ret
	

;**************************
;* System output routines *
;**************************

;---------------------------------------------------
; Test ready status and make sure buffer is in range
;---------------------------------------------------

m1o_stat:
m1o_sst:
	save	[r2,r3,r4]
	movd	4*dof_dat(r7),r3
	movd	dat_bdat(r3),r2
	movqd	0,r6		;Assume OK
	tbitb	bdp_opn,dat_ptcl(r3)
	if	fc
	 sbitb	bstat_nr,r6
	else
	 extsd	dat_dctr+bdp_drv/8(r3),r4,bdp_drv mod 8,2 ;Requested drive
	 addb	r4,r4		;Offset to ch/wp pair
	 addb	bdp_ch1,r4
	 tbitb	r4,dat_dctr(r2)	;Test for disk change
	orif	fs
	 movd	dat_bwtx(r3),r4	;Current count
	 cmpd	dat_absbf(r3),dat_absbf(r2) ;Must still be same
	 if	ne
	  cmpqd	-1,dat_dir(r3)
	  if	eq		;Absolute positioning if eq
	   addd	dat_absbf(r3),r4 ;Convert to absolute address
	   bsr	m1o_capos	;Position pointer according to r4
	  else
	   bsr	idx2rel		;Convert r4 to file relative address
	   bsr	m1o_crpos
	  endif
	 else
	  cmpd	dat_absch(r3),r4
	 orif	ls		;Buffer full if ls, flush and refill
	 endif
	endif
	restore	[r2,r3,r4]
	ret


m1o_io:
m1o_sio:
	save	[r0,r1,r2,r3,r4]
	movd	4*dof_sst(r7),r4
	jsr	r4
	cmpqd	0,r6
	if	eq
	 movd	4*dof_dat(r7),r3 ;Address of data block
	 movd	dat_bdat(r3),r2
	 movd	dat_bwtx(r3),r4	;Current count
	 movd	dat_bpt(r2),r1	;Buffer pointer
	 movb	r5,r1[r4:b]
	 movd	r4,r0
	 divd	dat_ssiz(r2),r0	;Sector offset
	 movd	dat_bupd(r2),r1	;Pointer to change flags
	 sbitb	r0,(r1)		;Mark changed
	 addqd	1,r4		;Increment pointer
	 movd	r4,dat_bwtx(r3)	;New data pointer
	endif
	restore	[r0,r1,r2,r3,r4]
	ret
	

m1o_blk:
	tbitb	bkb_bin,r0
	if	fs		;Fast routine only for binary files
	 tbitb	bkb_28,r0
	 if	fs
	  andd	h'fffffff,r0	;Count in bits 0-27 if fs
	 else
	  save	[r0]
	  bicd	exp bkb_cnt+exp bkb_bin+h'ffff,r0 ;Ignore these for now
	  cmpqd	0,r0		;16 bit count in r0 if eq
	  restore [r0]
	  if	eq
	   movzwd r0,r0
	  else
	   bispsrb flag_f	;Use fast routine
	  endif
	 endif
	endif
	bfc	nlo_blk		;Only fast file read here

	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	begin
	 movd	4*dof_sst(r7),r4
	 jsr	r4
	 cmpqd	0,r6		;Error if ne, quit now
	quit	ne
	 cmpqd	0,r0
	while	ne
	 movd	dat_bwtx(r3),r2	;Target address
	 movd	dat_absch(r3),r5
	 subd	r2,r5		;Max number of characters to write
	 cmpd	r5,r0		;See if all there
	 if	hi
	  movd r0,r5		;Don't write more than this
	 endif
	 subd	r5,r0		;Remaining character count in r0
	 movd	r0,tos
	 movd	r5,r0		;Number of bytes here
	 movd	dat_bdat(r3),r5
	 save	[r0,r2]
	 addd	dat_bpt(r5),r2	;Target address
	 addd	r0,dat_bwtx(r3)	;Update this
	 movsb			;Overwrite any data already in buffer
	 restore [r0,r2]	;Starting offset, byte count
	 addr	-1(r2)[r0:b],r0	;Last byte written
	 divd	dat_ssiz(r5),r0	;Index of last sector
	 divd	dat_ssiz(r5),r2	;Starting sector index
	 movd	dat_bupd(r5),r5	;Pointer to change flags
	 until hi
	  sbitb r2,(r5)	;Mark changed
	  addqd 1,r2		;Next bit
	  cmpb r2,r0
	 endu
	 movd	tos,r0		;Remaining byte count
	endw
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;---------------------------------------------------
; Search for buffer with absolute data address in r4
; R5 holds starting r7 value on entry
; Return pointer in r5 if found, -1 if not found
;---------------------------------------------------

buf_srch:
	save	[r1,r2,r3,r5]
;	cmpqb	lnt_base,4*dof_id+3(r5)
	if	ne
	 movzbd	4*dof_id+dofid_max(r5),r2 ;Dof_max
	 movd	name_siz+lnk_base(r5)[r2:d],r5
	endif			;R5 holds base
	begin
	 movd	4*dof_bdat(r5),r3
	 movd	dat_absbf(r3),r1
	 cmpd	r1,r4
	 if	ls		;Out of range if hi
	  addd	dat_absch(r3),r1 ;Last address in buffer+1
	  addqd	-1,r1
	  cmpd	r4,r1
	 endif
	while	hi		;Out of range if hi
	 movd	4*dof_lnk(r5),r5 ;Next instance in chain
	 cmpqd	-1,r5
	quit	eq
	endw
	restore	[r1,r2,r3,r5]
	ret


;------------------------------------------
; Position absolute output pointer from r4
;------------------------------------------

m1o_capos:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	r7,r5
	bsr	buf_srch	;Look for another write buffer in use
	movzbd	exp bstat_iu,r6	;Assume in use
	cmpqd	-1,r5		;No match if eq
	if	eq
	 movzbd	dat_io(r3),r5
	 movd	(dev_ptr)[r5:d],r5 ;Corresponding input device
	 bsr	buf_srch	;Look for active read buffer
	 movqd	0,r6		;Assume OK
	 cmpqd	-1,r5		;No match if eq
	 if	eq
	  movd	r3,dat_bdat(r3)	;No buffer in use, start a new one
	  bsr	m1o_cfill
	 else
	  movd	4*dof_dat(r5),r5
	  movd	dat_bdat(r5),r5
	  movd	r5,dat_bdat(r3)
	  movd	dat_absbf(r5),dat_absbf(r3)
	  movd	dat_absch(r5),dat_absch(r3) ;New instance is same
	  subd	dat_absbf(r3),r4 ;Offset from start of buffer
	  movd	r4,dat_bwtx(r3)	;Set write pointer
	  movd	r4,dat_brdx(r3)
	  movd	r4,dat_bch(r3)
	 endif
	endif
	restore	[r3,r4,r5]
	ret


;----------------------------------------------------------
; R4 holds relative position, setup fatr, fato,
;   return absolute address in r4
;----------------------------------------------------------

rpos:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	;
	movqd	0,r6		;Assume OK
	movd	r4,r5
	divd	did_csiz(r2),r5	;Requested relative cluster
	cmpw	dat_fatr(r3),r5
	if	ne		;See if same cluster
	 addr	-1(r5),r0
	 cmpw	dat_fatr(r3),r0	;See if next cluster
	 if	eq
	  movw	dat_fato(r3),r5
	  bsr	get_clstr	;Get next cluster
	  cmpqd	-1,r5
	  if	eq
	   movzwd dat_fato(r3),r5
	   bsr	nxt_fat		;Extending file, get new cluster
	  endif
	  cmpqd	0,r6
	  if	eq
	   movw	r5,dat_fato(r3)
	   addqw 1,dat_fatr(r3)	;Update these
	  endif
	 else
	  movd	r5,r0		;Relative cluster index
	  movd	dat_dir(r3),r1
	  movzwd dir_fat1(r1),r5 ;Initial absolute fat
	  movw	r5,dat_fato(r3)
	  movqw	0,dat_fatr(r3)	;Start at beginning
	  begin
	   cmpqw 0,r0
	  while	ne
	   movw	dat_fato(r3),r5
	   bsr	get_clstr	;Get next cluster
	   cmpqd -1,r5
	   if	eq
	    movzwd dat_fato(r3),r5
	    bsr	nxt_fat		;Extending file, get new cluster
	   endif
	   cmpqd 0,r6
	  quit	ne		;Quit now if error
	   movw	r5,dat_fato(r3)
	   addqw 1,dat_fatr(r3)	;One more cluster
	   addqw -1,r0
	  endw
	 endif
	endif
	movzwd	dat_fato(r3),r5	;Absolute cluster
	muld	did_csiz(r2),r5
	modd	did_csiz(r2),r4
	addd	r5,r4		;Absolute requested position
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;---------------------------------------
; Position file relative pointer from r4
;---------------------------------------

m1o_crpos:
	save	[r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	bsr	dir_updt	;Update size as needed
	bsr	rpos
	bsr	m1o_capos	;Now do absolute position
	cmpqd	0,r6
	if	eq
	 movzwd	dat_fato(r3),r5	;Absolute cluster
	 muld	did_csiz(r2),r5
	 addd	did_csiz(r2),r5	;Last address of cluster+1
	 subd	dat_absbf(r3),r5 ;Maximum number of valid characters
	 cmpd	dat_absch(r3),r5
	 if	hi
	  movd	r5,dat_absch(r3) ;Can't go past end of cluster
	 endif
	endif
	restore	[r2,r3,r4,r5]
	ret


;-----------------------------------------------------
; Open existing file, R1 => holds file name
; Use default drive/directory if not specified in name
; R4 holds dir_bits:w
;-----------------------------------------------------

m1o_copen:
	bsr	m1i_copen
	cmpqd	0,r6
	if	eq
	 bsr	nli_copen
	endif
	ret


;-----------------------------------------------------
; Create new output file, R1 => file name
; Use default drive/directory if not specified in name
; R4 holds dir_bits:w
;-----------------------------------------------------

m1o_cmake:
	bsr	m1i_cmake
	ret


;-----------
; Close file
;-----------

m1o_cclose:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	cmpqd	-1,dat_dir(r3)
	if	ne
	 tbitb	dc_cltrk,r5	;Truncate any remaining characters if set
	 if	fs
	  movzwd dat_fato(r3),r5 ;Current absolute cluster
	  bsr	get_clstr	;Next cluster
	  cmpqd	-1,r5		;No more if eq
	  if	eq
	   bsr	era_eof
	  endif
	  movd	dat_dir(r3),r1	;Pointer to directory
	  movqd	0,dir_size(r1)	;Update will overwrite this
	 endif
	 bsr	dir_updt	;Update size as needed
	 movd	dat_dir(r3),r5
	 cbitb	dirb_opn,dir_bits(r5)
	endif
	bsr	m1o_cflush	;Clear buffers as needed
	bsr	nlo_cclose
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-----------
; Erase file
;-----------

m1o_cerase:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_dir(r3),r1	;Pointer to directory
	movzwd	dir_fat1(r1),r5
	bsr	era_eof		;Clear all clusters after 1st one
	cbitb	dirb_val,dir_bits(r1) ;Zap this entry
	bsr	dir_change	;Mark directory changed
	bsr	m1o_cdupd	;Write FAT, directory
	restore	[r1,r2,r3,r4,r5]
	ret


;Fill buffer with 0s and mark updated

buf_0:
	save	[r0,r1,r2,r3]
	movd	4*dof_dat(r7),r3
	movd	dat_bpt(r3),r1	;Pointer to data field
	movd	dat_bsz(r3),r0	;Size of buffer-1
	movqb	0,(r1)
	addr	1(r1),r2
	movsb			;Fill buffer with 0s

	movd	dat_bsz(r3),r0
	divd	dat_ssiz(r3),r0	;Highest sector index
	movd	dat_bupd(r3),r1
	until	gt
	 sbitb	r0,(r1)
	 addqd	-1,r0
	 cmpqd	0,r0
	endu			;Mark entire buffer updated
	restore	[r0,r1,r2,r3]
	ret


sys_name: db	'Kotekan', 0

;------------------
; High level format
;------------------

m1o_chfmt:
	save	[r0,r1,r2,r3,r4,r5,r7]

	bsr	m1o_cunlog	;Undo everything
	movd	4*dof_dat(r7),r3
	bsr	dsk_home	;Home disk
	bsr	sel_drive
	bsr	read_id
	bsr	drv_off
	movzbd	128,r4
	begin
	 cmpqb	0,r5
	while	ne
	 addd	r4,r4
	 addqb	-1,r5
	endw			;Sector size in r4
	movd	r4,dat_ssiz(r3)	;This must be valid

	movd	rsv_size*cls_size,r0 ;Size of reserved data fields
	bsr	new_file	;Create buffer block
	movd	4*dof_dat(r7),r3
	movd	dat_bpt(r3),dat_did(r3)
	movw	dirt_did,dat_dirt(r3)

	bsr	disk_id		;Setup DID for m1o_capos
	movqd	0,r4
	bsr	m1o_capos	;Read DID from disk
	bsr	buf_0		;0 buffer and mark updated
	bsr	disk_id		;Setup DID sector/track/cylinder/disk size

	movd	4*dof_dat(r7),r3
	movd	dat_bpt(r3),r5

	movd	ver_num,did_vers(r5) ;Operating system version
	addr	4(r5),r2
	addr	sys_name,r1
	movzbd	32,r0
	movqd	0,r4
	movsb	u		;Copy name into place
	addr	did_name(r5),r2	;Pointer to directory field

	addr	sys_name,r1
	movzbd	32,r0
	movqd	0,r4
	movsb	u		;Copy name into place
	addr	did_name(r5),r2	;Pointer to directory field
	movd	dsiz_byt,dir_size(r2) ;Size of disk
	bsr	smt_read	;Get time and date in r4
	movd	r4,dir_date(r2)
	movqw	-1,dir_ext1(r2)
	movqw	-1,dir_bits(r2)

	movd	cls_size,did_csiz(r5) ;Cluster size in bytes
	movb	fat_bits,did_cbit(r5) ;Total bits in one FAT index
	movw	dsiz_cls,did_fmax(r5) ;Total clusters on disk
	movw	rsv_size,did_fmin(r5) ;Number of reserved clusters
	movd	did_siz,did_fat1(r5) ;Offset in bytes to FAT 1
	movd	did_siz+fat_size,did_fat2(r5) ;Offset in bytes to FAT 2

	movb	dir_siz,did_dsiz(r5) ;Size of one directory entry in bytes
	movw	num_dirs,did_dmax(r5) ;Number of directory entries
	movd	did_siz+2*fat_size,did_ddir(r5) ;Offset in bytes to directory
	movd	sup_byts,did_sup(r5) ;Size of one supplementary entry

	movw	dirt_fat,dat_dirt(r3) ;Now make this a FAT buffer
	movd	did_siz,dat_brdx(r3)
	movd	did_siz,dat_bwtx(r3)
	movd	did_siz,dat_bchr(r3) ;Offset to start of FAT
	movd	rsv_size,r0	;Number of reserved clusters
	movqd	0,r4
	movqd	1,r5
	until	eq
	 bsr	put_clstr
	 movd	r5,r4
	 addqd	1,r5
	 addqw	-1,r0
	 cmpqw	0,r0
	endu

	bsr	m1o_cflush	;Write disk buffer
	bsr	m1o_clog	;Re-log for real now
	
	restore	[r0,r1,r2,r3,r4,r5,r7]
	ret


;---------------------------
; Update disk FAT, directory
;---------------------------

m1o_cdupd:
	save	[r5,r7]
	begin
;	 cmpqb	lnt_base,4*dof_id+3(r7)
	while	ne
	 bsr	m1o_cflush	;Flush buffer
	 movzbd	4*dof_id+dofid_max(r7),r5 ;Dof_max
	 movd	name_siz+lnk_r7(r7)[r5:d],r7 ;Pointer to previous block
	endw
	restore	[r5,r7]
	ret

@@@
;----------------------------------------------------------
; R6 holds device index, create new instance and initialize
; R0 holds size of data buffer, return r7 pointer in r5
;----------------------------------------------------------

new_fsub:
	save	[r0,r1,r2,r3,r4,r7]
	movqd	0,r4		;No extra space needed
	movd	dc_instnc,r5
	orw	dof_cmd lsh b_iosrv,r6
	bsr	bsr_svc		;Return new pointer in r5
	cmpqd	0,r6
	if	eq
	 movd	r5,r7		;Save here
	 movd	4*dof_dat(r7),r3 ;New data pointer
	 movd	4*dof_bdat(r7),r2
	 cbitb	bdp_opn,dat_ptcl(r2) ;Not open
	 movqd	-1,dat_absbf(r3) ;Invalid
	 movqd	0,dat_absch(r3) ;Nothing yet
	 movqw	0,dat_fatr(r3) ;Start at relative position 0
	 movqd	-1,dat_dir(r3)	;Invalid
	 cmpqd	0,r0		;See if data block defined
	 if	ne
	  movd	dat_ssiz(r3),r2
	  addr	-1(r0)[r2:b],r0	;Add ssiz-1
	  divd	r2,r0
	  muld	r2,r0		;Round up to nearest sector size
	  movd	r0,r4		;Extra size required
	  divd	r2,r4		;Size of dat_bupd field in bits
	  addqd	7,r4		;Round up to byte boundary
	  lshd	-3,r4		;Size in bytes
	  addd	r0,r4		;Total size requirements
	  movqd	0,r5		;Supervisor mode
	  bsr	opo_newbf
	  cmpqd	0,r6
	  if	eq
	   movd	r5,r4
	   bsr	opo_lonbf	;Lock buffer	
	   movd	r5,dat_bufh(r3)
	   movd	(r5),dat_bpt(r3) ;Buffer here
	   movd	(r5),dat_bupd(r3)
	   addd	r0,dat_bupd(r3)	;Update field follow data buffer
	   addr	-1(r0),dat_bsz(r3) ;Size of buffer
	   movd	(r5),r1		;Buffer address
	   addr	4(r1),r2
	   movd	4(r5),r0	;Buffer size
	   lshd	-2,r0		;Size in Dwords
	   addqd -1,r0		;Remaining Dwords after 1st
	   movqd 0,(r1)
	   movsd		;Fill buffer with 0s
	  endif
	 endif
	endif
	movd	r7,r5		;Return base address here
	restore	[r0,r1,r2,r3,r4,r7]
	ret


;-----------------------------------------
; Create child block from current r7
; r0 holds buffer size
;-----------------------------------------

new_file:
	save	[r0,r2,r3,r4,r5]
	movzbd	svc_r6,r6
	cbitb	b_iodev,r6	;Make output device
	movd	r6,r4		;Save here
	bsr	new_fsub
	cmpqd	0,r6
	if	eq
	 movd	r5,r2		;Save input base
	 movd	r4,r6
	 sbitb	b_iodev,r6	;Input file
	 movqd	0,r0		;Input uses output data block, no new buffer
	 bsr	new_fsub
	 cmpqd	0,r6
	 if	eq
	  movd	4*dof_dat(r2),4*dof_dat(r5) ;Use same data block
	  movd	r2,(dev_ptr)[r4:d] ;Install output block
	  sbitb	b_iodev,r4	;Input index
	  movd	r5,(dev_ptr)[r4:d] ;Install input block
	  movzbd svc_r6,r4	;Input/Output selector
	  movd	(dev_ptr)[r4:d],r7 ;New r7 too
	 endif
	endif	
	restore	[r0,r2,r3,r4,r5]
	ret


;------------------------------------------
; Log in disk
; Load disk parameters, FAT, root directory
; R7, default file set to root directory
;------------------------------------------

m1o_clog:
	save	[r0,r1,r3,r4,r5]
	bsr	m1o_cunlog	;Undo any past activity
	movd	4*dof_dat(r7),r3
	bsr	dsk_home	;Home disk
	bsr	sel_drive
	bsr	read_id
	bsr	drv_off
	movzbd	128,r4
	begin
	 cmpqb	0,r5
	while	ne
	 addd	r4,r4
	 addqb	-1,r5
	endw			;Sector size in r4
	movd	r4,dat_ssiz(r3)	;This must be valid

	movd	did_siz,r0	;Size of buffer required
	bsr	new_file	;Create child block
	movd	4*dof_dat(r7),r3
	movd	dat_bpt(r3),dat_did(r3)
	movw	dirt_did,dat_dirt(r3)
	bsr	disk_id		;Setup DID sector/track/cylinder size

	movqd	0,r4
	bsr	m1i_capos	;Read DID from disk
	bsr	disk_id		;Always taken from disk in case DID invalid

	movd	dat_did(r3),r1	;Pointer to DID data
	movzbd	did_cbit(r1),r0	;Size of a FAT entry in bits
	movzwd	did_fmax(r1),r5	;Total size of FAT in clusters
	muld	r5,r0		;Size of FAT in bits
	addqd	7,r0
	lshd	-3,r0		;Size of FAT in bytes
	bsr	new_file	;Setup FAT child block
	movd	4*dof_dat(r7),r3
	movw	dirt_fat,dat_dirt(r3)
	movd	dat_did(r3),r1
	movd	did_fat1(r1),r4
	bsr	m1i_capos
	
	movd	dat_did(r3),r1	;Pointer to DID data
	movzbd	did_dsiz(r1),r0	;Size of a directory entry in bytes
	movzwd	did_dmax(r1),r5	;Number of directory entries
	muld	r5,r0		;Total directory size in bytes
	bsr	new_file	;Setup root directory child block
	movd	4*dof_dat(r7),r3
	movd	dat_bpt(r3),dat_dir(r3)
	movw	dirt_dir,dat_dirt(r3)
	movd	dat_did(r3),r1
	movd	did_ddir(r1),r4
	bsr	m1i_capos
	addd	dat_brdx(r3),dat_dir(r3)

	extsd	dat_dctr+bdp_drv/8(r3),r0,bdp_drv mod 8,2 ;Requested drive
	addb	r0,r0		;Offset to ch/wp pair
	addb	bdp_ch1,r0
	movd	4*dof_bdat(r7),r3
	cbitb	r0,dat_dctr(r3)

	restore	[r0,r1,r3,r4,r5]
	ret


;---------------------------------------
; Unlog (cancel) current disk parameters
;---------------------------------------

m1o_cunlog:
	save	[r3,r4,r5]
	begin
;	 cmpb	lnt_base,4*dof_id+3(r7)
	while	ne
	 movzbd	svc_r6,r6
	 orw	dof_cmd lsh b_iosrv,r6
	 movd	dc_close,r5
	 bsr	bsr_svc		;Close files
	 movd	4*dof_dat(r7),r3
	 movd	dat_bufh(r3),r4
	 bsr	opo_clrbf	;Release data/update buffer
	 bsr	nlo_cunvct	;Unlink this entry
	endw
	movd	4*dof_dat(r7),r3
	movd	4*dof_bdat(r7),r4
	extsd	dat_dctr+bdp_drv/8(r3),r5,bdp_drv mod 8,2 ;Requested drive
	addb	r5,r5		;Offset to ch/wp pair
	addb	bdp_ch1,r5
	sbitb	r5,dat_dctr(r4)
	movqd	-1,dat_did(r3)	;Invalid did
	movqd	-1,dat_bufh(r3)	;Invalid buffer
	movqd	-1,dat_absbf(r3) ;Invalid
	movqd	0,dat_absch(r3)	;Nothing in buffer
	movqd	-1,dat_bupd(r3)
	movqd	-1,dat_dir(r3)
	restore	[r3,r4,r5]
	ret


;---------------------------------------
; Advance to next valid directory entry
; Return pointer in r1, attributes in r5
;---------------------------------------

m1o_nxdir:
	save	[r2,r3,r4]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	movzbd	did_dsiz(r2),r4	;Size in bytes of one entry
	movzwd	did_dmax(r2),r2	;Number of entries
	muld	r4,r2		;Max directory offset+1
	movd	dat_dir(r3),r1
	until	fs
	 addd	r4,r1		;Advance to next entry
	 movqd	-1,r6		;Assume error
	 cmpd	r1,r2
	quit	hs
	 addd	r4,dat_dir(r3)
	 movqd	0,r6		;Assume OK
	 movzwd	dir_bits(r1),r5	;Return attributes here
	 tbitb	dirb_val,dir_bits(r1)
	endu
	restore	[r2,r3,r4]
	ret


;---------------------------------------
; Reset to first valid directory entry
; Return pointer in r1, attributes in r5
;---------------------------------------

m1o_1stdir:
	save	[r3]
	movzbd	dirt_dir,r5
	bsr	data_bfr	;Get pointer to directory buffer in r5
	movd	4*dof_dat(r7),r3
	movd	r5,dat_dir(r3)
	tbitb	dirb_val,dir_bits(r5)
	movzwd	dir_bits(r5),r5
	if	fc
	 bsr	m1o_nxdir	;If 1st not valid, try next
	endif
	restore	[r3]
	ret


;------------------------------------------------
; Find next matching directory entry
; R1 => name, r4 holds attributes (0 matches any)
; Return actual name in r1, attributes in r5
;------------------------------------------------

m1o_sdir:
	save	[r2]
	movd	r1,r2		;Save pointer here
	until	eq
	 bsr	m1o_nxdir	;Get next valid directory
	 cmpqd	0,r6
	quit	ne
	 cmpqb	0,r5
	 if	ne
	  cmpb	r4,r5
	 endif
	 if	eq
	  bsr	cmp_case	;Compare strings
	 endif
	endu
	restore	[r2]
	ret


;------------------------------------------------
; Find first matching directory entry
; R1 => name, r4 holds attributes (0 matches any)
; Return actual name in r1, attributes in r5
;------------------------------------------------

m1o_s1dir:
	save	[r2]
	movd	r1,r2		;Save pointer here
	bsr	m1o_1stdir	;Get next valid directory
	cmpqd	0,r6
	if	eq
	 cmpqb	0,r5
	 if	ne
	  cmpb	r4,r5
	 endif
	 if	eq
	  bsr	cmp_case	;Compare strings
	 endif
	 if	ne
	  bsr	m1o_sdir	;Search for next if 1st doesn't match
	 endif
	endif
	restore	[r2]
	ret


;----------------------------------
; Get file attributes, return in R5
;----------------------------------

m1o_cgetatr:
	movd	4*dof_dat(r7),r5
	movzwd	dat_dirt(r5),r5
	ret


;--------------------------------
; Set new file attributes from r4
;--------------------------------

m1o_cputatr:
	save	[r2,r3,r4,r7]
	movd	4*dof_dat(r7),r3
	movd	dat_dir(r3),r2
	inssb	r4,dat_dirt(r3),0,5
	inssb	r4,dir_bits(r2),0,5
	bsr	dir_change	;Mark directory changed
	restore	[r2,r3,r4,r7]
	ret


;----------------------------
; Get file size, return in R5
;----------------------------

m1o_cgetsiz:
	save	[r2,r3]
	movd	4*dof_dat(r7),r3
	movd	dat_dir(r3),r2
	movd	dir_size(r2),r5
	restore	[r2,r3]
	ret


;----------------------------
; Rename file, r1 => new name
;----------------------------

m1o_crenam:
	save	[r0,r1,r2,r3,r4,r7]
	bsr	nlo_csetnm	;Rename current buffer
	movd	4*dof_dat(r7),r3
	movd	dat_dir(r3),r2
	addr	4*dof_max(r7),r1 ;Source
	addr	dir_name(r2),r2	;Target address
	movzbd	name_siz,r0
	movsb
	bsr	dir_change	;Mark directory changed
	restore	[r0,r1,r2,r3,r4,r7]
	ret


;*************************
;* System input routines *
;*************************

m1i_stat:
m1i_sst:
	movd	r3,tos
	movd	4*dof_dat(r7),r3
	movqd	0,r6		;Assume OK
	tbitb	bdp_opn,dat_ptcl(r3
	if	fc		;Error if not open
	 sbitb	bstat_nr,r6
	else
	 tbitb	bdp_eof,dat_ptcl(r3)
	 if	fs		;Error if eof
	  sbitb	bstat_ef,r6
	 endif
	endif
	movd	tos,r3
	ret


m1i_io:
m1i_sio:
	save	[r0,r1,r2,r3,r4]
	movd	4*dof_sst(r7),r4
	jsr	r4
	cmpqd	0,r6
	if	eq
	 movd	4*dof_dat(r7),r3 ;Address of data block
	 movd	dat_bdat(r3),r2
	 movd	dat_brdx(r3),r4	;Current count
	 cmpd	dat_absbf(r3),dat_absbf(r2) ;Must still be same
	 if	ne
	  cmpqd	-1,dat_dir(r3)
	  if	eq		;Absolute positioning if eq
	   addd	dat_absbf(r3),r4 ;Convert to absolute address
	   bsr	m1o_capos	;Position pointer according to r4
	  else
	   bsr	idx2rel		;Convert r4 to file relative address
	   bsr	m1o_crpos
	  endif
	  movd	dat_bdat(r3),r2	;May have changed
	  movd	dat_brdx(r3),r4	;New index
	 else
	  cmpd	dat_absch(r3),r4
	 orif	ls		;Buffer full if ls, flush and refill
	 endif
	 cmpqd	0,r6		;Error if ne
	 if	eq
	  movd	dat_bpt(r2),r1	;Buffer pointer
	  movzbd r1[r4:b],r5
	  addqd	1,dat_brdx(r3)	;New data pointer
	 endif
	endif
	restore	[r0,r1,r2,r3,r4]
	ret
	

m1i_blk:
	tbitb	bkb_bin,r0
	if	fs		;Fast routine only for binary files
	 tbitb	bkb_28,r0
	 if	fs
	  andd	h'fffffff,r0	;Count in bits 0-27 if fs
	 else
	  save	[r0]
	  bicd	exp bkb_cnt+exp bkb_bin+h'ffff,r0 ;Ignore these for now
	  cmpqd	0,r0		;16 bit count in r0 if eq
	  if	eq
	   movzwd r0,r0
	   bispsrb flag_f	;Use fast routine
	  endif
	  restore [r0]
	 endif
	endif
	bfc	nli_blk		;Only fast file read here

	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_sst(r7),r4
	jsr	r4
	cmpqd	0,r6
	if	eq
	 movd	4*dof_dat(r7),r3
	 movqd	0,r6		;OK so far
	 begin
	  cmpqd	0,r6		;Error if ne, quit now
	 quit	ne
	  cmpqd	0,r0
	 while	ne
	  movd	dat_bdat(r3),r2
	  movd	dat_brdx(r3),r4	;Current count
	  cmpd	dat_absbf(r3),dat_absbf(r2) ;Must still be same
	  if	ne
	   cmpqd -1,dat_dir(r3)
	   if	eq		;Absolute positioning if eq
	    addd dat_absbf(r3),r4 ;Convert to absolute address
	    bsr	m1o_capos	;Position pointer according to r4
	   else
	    bsr	idx2rel		;Convert r4 to file relative address
	    bsr	m1o_crpos
	   endif
	  else
	   cmpd	dat_absch(r3),r4
	   orif	ls		;Buffer full if ls, flush and refill
	  endif
	  cmpqd	0,r6
	 quit	ne
	  movd	r1,r2		;Target address
	  movd	dat_brdx(r3),r1	;Source address
	  movd	dat_absch(r3),r5
	  subd	r1,r5		;Number of needed characters in buffer
	  cmpd	r5,r0		;See if all there
	  if	hi
	   movd r0,r5		;Don't read more than this
	  endif
	  subd	r5,r0		;Remaining character count in r0
	  movd	r0,tos
	  movd	r5,r0		;Number of bytes here
	  movd	dat_bdat(r3),r5
	  addd	dat_bpt(r5),r1	;Source address
	  addd	r0,dat_brdx(r3)	;Update this
	  movsb			;Read data already in buffer
	  movd	r2,r1		;Update r1
	  movd	tos,r0		;Remaining byte count
	 endw
	endif
	restore	[r0,r1,r2,r3,r4,r5]
	ret


;-----------
; Initialize
;-----------

m1i_cinit:
	save	[r3]
	movd	4*dof_dat(r7),r3
	movzbd	dat_io(r3),r3
	movd	(dev_ptr)[r3:d],r3 ;Output R7 pointer
	movd	4*dof_bdat(r3),4*dof_bdat(r7) ;Input uses same bdat
	restore	[r3]
	ret


;----------------------------------------
; Position absolute input pointer from r4
;----------------------------------------

m1i_capos:
	save	[r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	r7,r5
	bsr	buf_srch	;Look for another write buffer in use
	movqd	0,r6		;Assume OK
	cmpqd	-1,r5		;No match if eq
	if	ne
	 movd	4*dof_dat(r5),r5
	 movd	dat_bdat(r5),r5
	 movd	r5,dat_bdat(r3)
	 movd	dat_absbf(r5),dat_absbf(r3)
	 movd	dat_absch(r5),dat_absch(r3) ;New instance is same
	 subd	dat_absbf(r3),r4 ;Offset from start of buffer
	 movd	r4,dat_bwtx(r3)	;Set write pointer
	 movd	r4,dat_brdx(r3)
	 movd	r4,dat_bch(r3)
	else
	 movzbd	dat_io(r3),r5
	 movd	(dev_ptr)[r5:d],r5 ;Corresponding output device
	 bsr	buf_srch	;Look for active read buffer
	 cmpqd	-1,r5		;No match if eq
	orif	ne
	 movd	r3,dat_bdat(r3)	;No buffer in use, start a new one
	 bsr	m1o_cfill
	endif
	restore	[r3,r4,r5]
	ret


;---------------------------------------------
; Set pointers to relative file position in r4
; Don't go past end of file
;---------------------------------------------

m1i_crpos:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	movd	dat_did(r3),r2
	movd	dat_dir(r3),r1	;Pointer to directory
	cmpd	dir_size(r1),r4
	if	ls		;Past end of file if ls
	 movd	4*dof_bdat(r7),r5
	 sbitb	bdp_eof,dat_ptcl(r5)
	 movzbd exp bstat_ef,r6
	else
	 bsr	dir_updt	;Update size as needed
	 bsr	rpos
	 bsr	m1i_capos	;Now do absolute position
	 cmpqd	0,r6
	 if	eq
	  movzwd dat_fato(r3),r5 ;Absolute cluster
	  muld	did_csiz(r2),r5
	  addd	did_csiz(r2),r5	;Last address of cluster+1
	  subd	dat_absbf(r3),r5 ;Maximum number of valid characters
	  cmpd	dat_absch(r3),r5
	  if	hi
	   movd	r5,dat_absch(r3) ;Can't go past end of cluster
	  endif
	  movqd	0,r4
	  bsr	idx2rel		;Relative count of first byte in buffer
	  movd	dir_size(r1),r5
	  subd	r4,r5		;Max size in buffer
	  cmpd	dat_absch(r3),r5
	  if	hi
	   movd	r5,dat_absch(r3) ;Can't go past end of file
	  endif
	 endif
	endif
	restore	[r1,r2,r3,r4,r5]
	ret


;----------------------------------------
; R1 holds file name, r4 holds DIR_BITS:w
;----------------------------------------

m1i_copen:
	save	[r2,r3]
	movd	4*dof_bdat(r7),r2
	movd	4*dof_dat(r7),r3
	extsd	dat_dctr+bdp_drv/8(r3),r3,bdp_drv mod 8,2 ;Requested drive
	addb	r3,r3		;Offset to ch/wp pair
	addb	bdp_ch1,r3
	tbitb	r3,dat_dctr(r2) ;See if disk changed
	if	fs
	 bsr	m1o_clog
	endif
	cmpqd	0,r6		;Success if 0
	if	eq
	 bsr	nli_copen
	endif
	ret


;------------------------------------
; Create new input file
; R1 holds file name, r4 holds type:w
;------------------------------------

m1i_cmake:
;	bsr	make_sub
	cmpqd	0,r6		;Success if 0
	if	eq
	 bsr	m1i_copen
	endif
	ret


;-----------
; Close file
;-----------

m1i_cclose:
	save	[r0,r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3
	cmpqd	-1,dat_dir(r3)
	if	ne
	 bsr	dir_updt	;Update size as needed
	 movd	dat_dir(r3),r5
	 cbitb	dirb_opn,dir_bits(r5)
	endif
	bsr	m1o_cflush	;Clear buffers as needed
	bsr	nli_cclose
	restore	[r0,r1,r2,r3,r4,r5]
	ret

;End of DISK
