	print	"DIS32"

;Display one line of disassembly at address R4

dis_dsp:
	lproc
	reg	[]
buf:	ds	h'80
	code

	movd	r4,tos
	bsr	pc_mod

	movd	r4,m_pcptr	;Save address of current opcode

;Locate FP base for labels

	movqd	-1,m_fpofst	;Null base offset
	movd	sidx_end,t_symfp ;No local labels yet
	addr	t_symlnk,r2
	movd	msym_beg,r5
	addd	t_symbl,r5	;Lowest possible address
	movd	msym_end,r6	;Must be less than this
	begin
	 extsd	(r2),r2,0,sidx_bit
	 cmpd	sidx_end,r2
	quit	eq
	 addd	t_symbl,r2	;Next address to check
	 cmpd	r2,r6		;Must be less than R6
	quit	hs
	 cmpd	r2,r5
	 if	hs		;Not current module yet if LO
	  movd	sidx_of+2(r2),r3
	  addd	m_pcofst,r3	;Current address
	  cmpd	r3,r4
	 endif
	while	ls
	 cmpd	r2,r5
	 if	hs
	  cmpb	lcod_fp,sidx_of+2+4(r2)
	  if	eq		;Name holds type:B, T_SYMFP
	   movd	sidx_of+2+4+1(r2),t_symfp ;1st alpha name
	   movd	sidx_of+2+4+1+4(r2),m_fpofst ;Base address index
	   addd	t_symbl,m_fpofst ;Absolute base address
	  endif
	 endif
	endw

	addr	buf,r1
	movqd	0,r0

;Convert pointer in R4 to address label

	movd	r4,r5
	bsr	byt_4r5

;Put label in if any defined (exact match only)

	subd	m_pcofst,r5	;Subtract M_PCOFST as this is PC relative
	movb	h'b,r6		;PC relative symbol
	save	[r0,r1]
	bsr	val2sym		;Search current module's symbols only
	restore	[r0,r1]

	cmpqd	-1,m_symadr
	if	ne		;Got an exact or near match
	 cmpd	r5,2(m_symadr)	;Need exact match here
	 if	eq
	  movd	r1,tos
	  movd	r0,r3
	  addr	r1[r0:b],r2	;Target for name
	  extsd	(m_symadr),r0,0,5 ;Length of name
	  addr	6(m_symadr),r1	;Pointer to symbol
	  addd	r0,r3		;Length of symbol name
	 
	  movb	"<",(r2)
	  addqd	1,r2
	  addqd	1,r3		;length of <
	  movsb			;Move into place
	  movd	tos,r1		;Pointer back to R1
	  movd	r3,r0		;Length back to R0
	 
	  movb	">",r1[r0:b]
	  addqd	1,r0
	 endif
	endif

	movw	": ",r1[r0:b]
	addqd	2,r0

	movd	var_ptr,tos	;Save temporary buffer
	bsr	dis_sb
	movd	tos,var_ptr	;Clear anything used here

	bsr	str_out		;Display string and that's it
	bsr	do_cr

	pend


;Disassemble with hex dump from R4

disasm:	lproc
	reg	[]
buf:	ds	h'80
	code

	movd	r4,tos		;Save starting R4
	bsr	dis_dsp		;Display opcodes
	movd	tos,r6		;Starting address

	addr	buf,r1
	movb	9,(r1)
	movqd	1,r0
	until	eq
	 movb	(r6),r5
	 bsr	byt_1r5
	 addqd	1,r6
	 cmpd	r6,r4
	endu

	bsr	str_out
	bsr	do_cr

	pend


;Subroutine to build disassembly string in R1, length in R0
;R4 => object code

dis_sb:

;Get format code/index in R5, opcode in R3, format parameters in R6,
;short field in R7, advance past opcode prefix if present,
;branch to appropriate format routine

	movd	0(r4),r2

;If bits 0-1 are not 10 then 2 byte integer opcode

	extsd	r2,r3,0,2
	cmpqb	2,r3
	beq	dfmt_08

;This is formats 2-4 (2 byte integer opcodes)

	extsd	r2,r3,2,2
	movqd	4,r5
	cmpqb	3,r3		;Format 4 if not 3
	bne	got_dfmt	;Got format in MS nibble of R5 if NE

;This is format 2 or 3

	extsd	r2,r3,4,3
	movqd	3,r5
	cmpqb	7,r3
	beq	got_dfmt	;Format 3 if 7
	movqd	2,r5		;Format 2
	br	got_dfmt

dfmt_08:			;This must be 0,1 or 5-F

;nnnn1010 = format 0
fmt_0:	movqd	0,r5
	extsd	r2,r3,0,4
	cmpb	h'a,r3
	beq	got_dfmt

;nnnn0010 = format 1
fmt_1:	movqd	1,r5
	cmpqb	2,r3
	beq	got_dfmt

;0E=R5
fmt_5:	movqd	5,r5
	cmpb	h'e,r2
	beq	got_dfmt

fmt_6:	movqd	6,r5
	cmpb	h'4e,r2
	beq	got_dfmt

fmt_7:	movqd	7,r5
	cmpb	h'ce,r2
	beq	got_dfmt

fmt_8:	movzbd	8,r5
	extsd	r2,r3,0,6
	cmpb	h'2e,r3
	beq	got_dfmt

fmt_9:	movzbd	9,r5
	cmpb	h'3e,r2
	beq	got_dfmt

fmt_b:	movzbd	h'b,r5
	cmpb	h'be,r2
	beq	got_dfmt

fmt_c:	movzbd	h'c,r5
	cmpb	h'fe,r2
	beq	got_dfmt

fmt_e:	movzbd	h'e,r5
	cmpb	h'1e,r2
	beq	got_dfmt

;Invalid format

dfmt_err:
	movd	"????",r1[r0:b]
	addqd	4,r0
	addqd	1,r4
	bispsrb	flag_f		;Set F to indicate error
	ret	0


;R5 holds format code, get format parameters in R6, opcode in R3, short in R7
;Advance past prefix if any

got_dfmt:
	movzwd	t_fmtp:d[r5:w],r6 ;Format parameters in R6
	lshd	4,r5		;Move format to MS nibble of R5

	extsb	r6,r2,0,2	;Opcode length
	cmpqb	3,r2
	bne	got_dfop	;Advance to op field if NE
	addqd	1,r4		;Advance past opcode prefix
got_dfop:
	extsd	r6,r2,5,3	;Offset to op field
	cmpqd	0,r2		;Don't do op here if 0
	beq	got_dfsh	;Advance to short field if EQ
	extd	r2,0(r4),r3,4	;Op field in R3
	orb	r3,r5		;Complete format/op index value in R5
	movb	r5,m_opcod	;Store opcode code

;Ready for short field now

got_dfsh:
	movzwd	r6,r2
	lshd	-8,r2		;Bits 8-F to 0-7
	bicb	h'f8,r2		;Offset to short field in R2
	cmpqb	0,r2
	beq	got_dfbr	;No short field if 0
	extd	r2,0(r4),r7,4	;Short field to R7

;All registers set, branch to appropriate routine

got_dfbr:
	extsd	r5,r2,4,4	;Format code to R2
got_dfcs:
	casew	gotdftb[r2:w]
gotdftb:
	.word	dfmt_0-got_dfcs
	.word	dfmt_1-got_dfcs
	.word	dfmt_2-got_dfcs
	.word	dfmt_3-got_dfcs
	.word	dfmt_4-got_dfcs
	.word	dfmt_5-got_dfcs
	.word	dfmt_6-got_dfcs
	.word	dfmt_7-got_dfcs
	.word	dfmt_8-got_dfcs
	.word	dfmt_9-got_dfcs
	.word	dfmt_a-got_dfcs
	.word	dfmt_b-got_dfcs
	.word	dfmt_c-got_dfcs
	.word	dfmt_d-got_dfcs
	.word	dfmt_e-got_dfcs
	.word	dfmt_f-got_dfcs

;Put tab or space after name depending on R0

tab_name:
	cmpb	16,r0
	if	ls
	 movb	" ",r1[r0:b]
	else
	 movb	9,r1[r0:b]
	endif
	addqd	1,r0
	ret


;R5 holds format/op index value, R2:D holds first letter of opcode mnemonic
;R6 holds format parameters, R4 => opcode, put complete op name into (R1)
;FS on exit if error, M_INT, M_SIZ, M_FLT loaded

op_name:
	save	[r2,r3,r7]
	extsb	0(r4),m_int,0,2
	movb	m_int,m_siz
	addqb	1,m_siz		;Integer size

	extsb	0(r4),m_flt,2,1	;1 for F, 0 for L

;If bit 3 set in R6 then set M_SIZ according to F/L field

	tbitb	3,r6		;See if bit 0 is F/L bit
	bfc	op_nmt
	extsb	0(r4),m_flt,0,1	;Initialize float field according to B0
	notb	m_flt,m_siz
	mulb	4,m_siz		;Make 0 if F, 4 if L
	addqb	4,m_siz		;4 if F, 8 if L
op_nmt:

;Get pointer to name table in R7

	save	[r2]
	subb	"A",r2
	movxwd	t_alpha:d[r2:w],r3 ;Offset from T_OP_A
	restore	[r2]
	addr	t_op_a:d,r7
	addd	r3,r7		;R7 => table to use
op_nm1:	movzbd	0(r7),r3	;Length of name
	addqd	2,r7		;Advance to first name
op_nm2:	cmpb	r5,r7[r3:b]	;Compare format/op index
	beq	op_nm3		;Got name in (R7), length in R3 if EQ

;No match yet, try next name

	addd	r3,r7		;Advance past name
	addqd	1,r7		;Advance past format/op
	cmpb	"A",0(r7)	;If < A then new group starting
	bls	op_nm2		;Still more in this group

	cmpb	r2,2(r7)	;Make sure 1st letters still match
	beq	op_nm1
	bispsrb	flag_f		;Set F in case of error

op_nmx:	restore	[r2,r3,r7]
	ret	0

;Got name in (R7), length in R0 - move into R1

op_nm3:	cmpb	"a",0(r7)
	bls	op_nm4		;Special coding required for i/f/cc
	movb	0(r7),r1[r0:b]
op_nmnx:
	addqd	1,r7
	addqd	1,r0
	acbd	-1,r3,op_nm3
	br	op_nmx
	bicpsrb	flag_f		;Success, F must be reset

op_nm4:	cmpb	"i",0(r7)
	bne	op_nmf		;Not integer if NE

;Integer field

	bsr	set_bwd
	br	op_nmnx

set_bwd:
	movb	"B",r1[r0:b]
	cmpqb	1,m_siz
	beq	return
	movb	"W",r1[r0:b]
	cmpqb	2,m_siz
	beq	return
	movb	"D",r1[r0:b]
	ret	0

op_nmf:
	cmpb	"f",0(r7)
	bne	op_nmcc		;Not floating if NE

	movb	"F",r1[r0:b]
	cmpqb	1,m_flt
	beq	op_nmnx
	movb	"L",r1[r0:b]
	br	op_nmnx

;"cc" is condition field

op_nmcc:
	save	[r3,r7]
	addr	t_cond:d,r7	;Condition codes
	extsd	m_cond,r3,0,4	;Condition code to R3
	negd	r3,r3
	addd	h'd,r3		;Op 13 is index 0, op 0 is index 13
	movw	r7[r3:w],r1[r0:b]
	restore	[r3,r7]
	addqd	1,r7		;Advance past 1st "c"
	addqd	1,r0
	addqd	-1,r3
	br	op_nmnx

;Do gen modes, bit 11 set in R6 for gen 1, bit 12 set for gen 2
;Put gen codes in (R1), R4=> opcodes, advance past opcodes

dis_fld:
	save	[r5]
	addqd	1,r4		;Always at least one byte
	extsb	r6,r5,0,2	;Size of opcode
	cmpqb	1,r5
	beq	disflg		;Done if only one byte
	addqd	1,r4		;Prefix already done if 3 bytes

disflg:	tbitb	h'b,r6
	bfc	dis_fld2	;No gen 1 if FC
	extsd	-1(r4),r5,3,5

;If both gens needed, use DIS_GEN2

	tbitb	h'c,r6
	bfc	dis_fld1
	save	[r6]
	extsd	-2(r4),r6,6,5
	bsr	dis_gen2
	restore	[r6]
	br	dis_fldx
dis_fld1:
	bsr	dis_gen
dis_fld2:
	tbitb	h'c,r6
	bfc	dis_fldx	;No gen 2 if FC
	extsd	-2(r4),r5,6,5
	bsr	dis_gen
dis_fldx:
	restore	[r5]
	ret	0


;These are specific format routines

dfmt_2:	cbitb	3,r3		;Only 3 byte op field
	cbitb	3,r5
	movb	r5,m_opcod
	movb	r7,m_cond	;Short field is condition code

	movzbd	t_fm2[r3:b],r2
	bsr	op_name		;Store mnemonic in R1
	bsr	tab_name

	cmpb	3,r3		;Skip short field if Scond
	beq	dfmt2d

;Check for SPR, LPR (index = 2 or 6)

	extsb	r3,r2,0,2
	cmpqb	2,r2
	bne	dfmt2b

;This is SPR or LPR, store register name

	negd	r7,r7
	addd	h'f,r7		;Short 0 is offset F, short F is offset 0
	movd	t_shreg:d[r7:d],r1[r0:b]
	addqd	4,r0
	bsr	trl_blnk	;Remove trailing blanks
	br	dfmt2c		;Skip short parameter
dfmt2b:
	lshb	4,r7
	ashb	-4,r7		;Bit 3 is sign bit
	movxbd	r7,r7
	save	[r5]
	movd	r7,r5
	bsr	sgn_r5		;Always signed
	restore	[r5]

dfmt2c:	movb	",",r1[r0:b]
	addqd	1,r0
dfmt2d:	bsr	dis_fld		;Do gens

;If ACB then offset follows

	cmpqb	4,r3
	bne	return

	movd	",*",r1[r0:b]
	addqd	2,r0
	br	sgn_ofs

;Op 111 not allowed, looks like format 3

t_fm2:	.byte	"ACSSAML"


dfmt_3:	movzbd	t_fm3[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err

	bsr	op_name
	bsr	tab_name
	br	dis_fld

t_fm3:	.byte	"C?B?J?B???A?J?C?"


dfmt_4:	movzbd	t_fm4[r3:b],r2

;Check for LXPD

	cmpb	9,r3		;ADDR or LXPD if 9
	bne	dfmt4a
	extsb	1(r4),r7,3,5	;Get gen 1
	cmpb	h'16,r7		;EXT mode
	bne	dfmt4a
	movd	"LXPD",r1[r0:b]
	addqd	4,r0
	br	dfmt4b

dfmt4a:	bsr	op_name

dfmt4b:	bsr	tab_name
	br	dis_fld

;op nn11 not allowed, looks like format 2

t_fm4:	.byte	"ACB?AMO?SAA?STX?"

;These are non-integer or 3 byte opcodes

dfmt_0:	movb	r3,m_cond	;Op index is conditional parameter
	cmpb	h'f,r3
	beq	dfmt_err
	movzbd	"B",r2

;If op is not BR (H'E) then op=0

	cmpb	h'e,r3
	beq	dfmt0a
	movqd	0,r3
	bicb	h'f,r5

dfmt0a:	bsr	op_name
	addqd	1,r4		;Advance past opcode
	bsr	tab_name

	movb	"*",r1[r0:b]
	addqd	1,r0
	br	sgn_ofs

dfmt_1:	movzbd	t_fm1[r3:b],r2
	bsr	op_name
	addqd	1,r4		;Advance past opcode

;Done if NOP, WAIT, DIA, FLAG, SVC, BPT (R3=A-F)

	cmpb	h'a,r3
	bls	return
	cmpqb	5,r3		;Done if RETI
	beq	return

	bsr	tab_name

;If BSR then PC offset needed

	cmpqb	0,r3
	bne	dfmt1a
	movb	"*",r1[r0:b]
	addqd	1,r0
	br	sgn_ofs

dfmt1a:
;Just need offset if RET, CXP, RXP, RETT (1-4)

	cmpqb	4,r3
	bhs	ofset

;Register map if SAVE, RESTORE, ENTER, EXIT (6-9)

	movb	0(r4),r2	;Register bit map to R2
	addqd	1,r4
	movb	"[",r1[r0:b]
	addqd	1,r0

	movb	8,r7		;Counter
	movb	"0",r5		;Start with R0
	movqb	1,r6		;Register increment

;Start with R0 if index is even

	tbitb	0,r3
	bfc	dfmt1b

;Start with R7, go backwards

	movb	"7",r5
	movqb	-1,r6

;Test current bit

dfmt1b:	tbitb	0,r2
	bfc	dfmt1c
	movd	"R ,",r1[r0:b]
	movb	r5,1(r1)[r0:b]
	addqd	3,r0

;Next bit

dfmt1c:	rotb	-1,r2		;Next bit to bit 0
	addb	r6,r5		;Next register name
	acbb	-1,r7,dfmt1b

	bsr	trl_coma	;Remove any trailing comma
	movb	"]",r1[r0:b]
	addqd	1,r0

;If ENTER then offset follows

	cmpb	8,r3
	bne	return
	movb	",",r1[r0:b]
	addqd	1,r0
	br	ofset

t_fm1:	.byte	"BRCRRRSREENWDFSB"

dfmt_5:	cmpb	h'f,r3
	bls	dfmt_err
	movzbd	t_fm5[r3:b],r2
	bsr	op_name
	addqd	2,r4		;Advance past opcode, prefix done
	cmpqb	2,r3		;See if this is SETCFG (R3=2)
	if	eq
	 bsr	tab_name
	 movb	"[",(r1)[r0:b]
	 addqd	1,r0
	 movqb	4,r2		;Counter
	 movd	"IFMC",r6	;Config list
dfmt5a:	 tbitb	0,r7
	 if	fs
	  movb	r6,r1[r0:b]
	  movb	",",1(r1)[r0:b]
	  addqd	2,r0
	 endif
	 rotd	-8,r6
	 rotb	-1,r7
	 acbb	-1,r2,dfmt5a
	 bsr	trl_coma	;Remove trailing commas
	 movb	"]",r1[r0:b]
	 addqd	1,r0
	else
	 cmpqb	3,r3		;0,1,3 are string opcodes
	 if	hs
	  tbitb	0,r7		;Default mnemonic is xxxxT
	  if	fc
	   addqd -1,r0		;Backup to B/W/D position
	   bsr	set_bwd
	   addqd 1,r0		;Ready to continue now
	  endif
	  bsr	tab_name
	  tbitb	1,r7
	  if	fs
	   movw	"B,",r1[r0:b]
	   addqd 2,r0
	  endif
	  lshb	-2,r7		;UW field only
	  cmpb	1,r7
	  if	eq
	   movb "W",r1[r0:b]
	   addqd 1,r0
	  endif
	  cmpb	3,r7
	  if	eq
	   movb	"U",r1[r0:b]
	   addqd 1,r0
	  endif
	  bsr	trl_coma	;Remove trailing commas
	  bsr	trl_blnk	;Remove trailing blanks/tabs
	 else
	  cmpb	9,r3		;TBITS
	  if	eq
	   bsr	tab_name
	   addb	"0",r7
	   movb	r7,r1[r0:b]	;0 or 1 option
	   addqd 1,r0
	  else
	   tbitb 0,r3		;BITBLT and BITWT are even
	   if	fc
	    cmpb 8,r3		;BITWT
	    if	ne		;Need BITBLT options if NE
	     cmpb h'C,R3	;BBFOR doesn't use options
	     if	ne
	      bsr tab_name
	      tbitb 0,r7	;-S if set, S if clear
	      if fs
	       movb "-",r1[r0:b]
	       addqd 1,r0
	      endif
	      movw "S,",r1[r0:b]
	      addqd 2,r0
	      movw "IA",r1[r0:b] ;Try this 1st
	      tbitb 2,r7	;DA if set, IA if clear
	      if fs
	       movb "D",r1[r0:b]
	      endif
	      addqd 2,r0
	     endif
	    endif
	   endif
	  endif
	 endif
	endif
	ret

t_fm5:	.byte	"MCSSBEBMBTBSBSB"

;Format 6 if LSB=4E

dfmt_6:	movzbd	t_fm6[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err
	bsr	op_name
	bsr	tab_name

;If ROT, ASH, LSH then M_SIZ=1

	cmpqb	5,r3		;LSH
	beq	dfmt6a
	cmpqb	1,r3		;ROT or ASH if HS
	blo	dis_fld
dfmt6a:	movqb	1,m_siz
	br	dis_fld

t_fm6:	.byte	"RACC?LSSNN?SACIA"


;Format 7 if LSB = CE

dfmt_7:	movzbd	t_fm7[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err
	bsr	op_name
	bsr	tab_name
	bsr	dis_fld

;Check for MOVM, CMPM, INSS, EXTS

	cmpqb	3,r3
	blo	return
	movb	",",r1[r0:b]
	addqd	1,r0
	cmpqb	1,r3		;MOVM or CMPM if HS
	blo	dfmt7a		;INSS or EXTS if LO

;MOVM OR CMPM, Get displacement in R5

	bsr	r4_disp
	divb	m_siz,r5	;Count = displacement/size + 1
	addqd	1,r5
	br	pos_asci	;Always positive
dfmt7a:

;Display offset/length parameters now
;Following byte: bits 5-7=size, bits 0-4=length-1

	movw	"0,",r1[r0:b]
	extsd	0(r4),r5,5,3
	addb	r5,r1[r0:b]
	addqd	2,r0

	extsd	0(r4),r5,0,5
	addqd	1,r5
	bsr	pos_asci
	addqd	1,r4
	ret	0

t_fm7:	.byte	"MCIEMMMMMM?DQRMD"

;Format 8 if n0101110

dfmt_8:	cbitb	3,r7		;Short field only 3 bits

;LS bits of op are bits 6-7 of -1(R4), MS bit is bit 2 of 0(R4)

	extsd	0(r4),r3,2,1
	lshw	8,r3		;Bit 0 to bit 8
	movb	-1(r4),r3	;Op in bit 6-8 now
	lshw	-6,r3		;Move to bits 0-2
	inssb	r3,r5,0,4
	movb	r5,m_opcod
	cmpqb	6,r3
	blo	dfmt_err

	movzbd	t_fm8[r3:b],r2
	bsr	op_name

;Check for MOVSUi or MOVUSi

	cmpqb	6,r3
	bne	dfmt_81
	cmpqb	1,r7		;If Reg = 1 then MOVSUi, name is OK
	beq	dfmt_81
	movw	"US",-3(r1)[r0:b]

dfmt_81:
	bsr	tab_name

	cmpb	5,r3
	bls	dis_fld		;If not FFS, MOVSU, MOVUS then Reg needed

	movd	"R0,",r1[r0:b]
	addb	r7,1(r1)[r0:b]
	addqd	3,r0

	bsr	dis_fld

;Done if not EXT or INS

	cmpb	1,r3
	beq	return
	cmpb	3,r3
	bls	return

;EXT or INS, length needed

	movb	",",r1[r0:b]
	addqd	1,r0
	br	ofset

t_fm8:	.byte	"ECICIFM"


dfmt_9:	cbitb	3,r3
	cbitb	3,r5		;Op index is only 3 bits
	movb	r5,m_opcod
	movzbd	t_fm9[r3:b],r2
	bsr	op_name
	bsr	tab_name

	cmpqb	0,r3		;Normal if MOVif
	beq	dis_fld

;If ROUND, TRUNC, FLOOR then size is float size

	notb	m_flt,m_siz
	mulb	4,m_siz		;F=0, L=4
	addqb	4,m_siz		;F=4, L=8

	cmpqb	4,r3		;ROUNDfi
	beq	dis_fld
	cmpqb	5,r3		;TRUNCfi
	beq	dis_fld
	cmpqb	7,r3		;FLOORfi
	beq	dis_fld

;Check for MOVFL

	movqb	1,m_flt
	movqb	4,m_siz
	cmpqb	3,r3
	beq	dis_fld

;Check for MOVLF

	movqb	0,m_flt
	movb	8,m_siz
	cmpqb	2,r3
	beq	dis_fld

;This is LFSR or SFSR, register gen is always 0

	movqb	3,m_int		;Always 4 bytes
	movqb	4,m_siz

;If LFSR then gen2 is fixed at 0

	cbitb	12,r6		;Gen 2 off
	cmpqb	1,r3
	beq	dis_fld

;This is SFSR

	sbitb	12,r6		;Gen 2 on
	cbitb	11,r6		;Gen 1 off
	br	dis_fld

t_fm9:	.byte	"MLMMRTSF"



dfmt_b:	movzbd	t_fmb[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err

	bsr	op_name
	bsr	tab_name
	br	dis_fld

t_fmb:	.byte	"AMC?SN??D???MA??"

dfmt_c:	movzbd	t_fmc[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err

	bsr	op_name
	bsr	tab_name
	br	dis_fld

t_fmc:	.byte	"SSPDSL????M?????"


dfmt_e:	movzbd	t_fme[r3:b],r2
	cmpb	"?",r2
	beq	dfmt_err
	bsr	op_name
	bsr	tab_name

	movqb	3,m_int
	movqb	4,m_siz
	cmpqb	1,r3		;Check for RDVAL or WRVAL
	bhs	dis_fld

	cmpb	9,r3		;Check for CINV
	if	eq
	 save	[r2,r6]
	 movqb	3,r2		;Counter
	 movd	"DIA ",r6	;Config list
	 until	eq
	  tbitb	0,r7
	  if	fs
	   movb	r6,r1[r0:b]
	   movb	",",1(r1)[r0:b]
	   addqd 2,r0
	  endif
	  rotd	-8,r6
	  rotb	-1,r7
	  addqb	-1,r2
	  cmpqb	0,r2
	 endu
	 restore [r2,r6]
	 br	dis_fld
	endif

;Register required in short field

	negd	r7,r7
	addd	h'f,r7		;Short 0 is offset F, short F is offset 0
	movd	t_mreg:d[r7:d],r1[r0:b]
	addqd	4,r0
	bsr	trl_blnk	;Remove trailing blanks
	cond	mmu532
	 cmpqb	1,r7		;IVAR1=0, IVAR0=1
	 if	hs
	  xorb	"0"+1,r7
	  movb	r7,r1[r0:b]
	  addqd	1,r0
	 endif
	cend
	movb	",",r1[r0:b]
	addqb	1,r0
	br	dis_fld

t_fme:	.byte	"RWLS?????C??????"


;All these are undefined formats

dfmt_a:
dfmt_d:
dfmt_f:
	br	dfmt_err


;Display signed offset
;Search symbol table, if no match display absolute address

sgn_ofs:
	save	[r2,r5,r6]

	bsr	sgn_asc		;Display signed offset, return in R5
	addd	m_pcptr,r5	;Add offset to current PC

	movb	"<",r1[r0:b]
	addqd	1,r0
	addr	r1[r0:b],r2	;Current target pointer to R2

;Search symbol table for PC label with value in R5

	movd	r1,tos		;Save current base pointer
	movd	r0,tos		;Save current offset
	save	[r5]		;Save absolute address for display
	movd	lmod,tos
	movd	msym_beg,tos
	movd	msym_end,tos
	movd	msb_mod,tos
	movd	m_pcofst,tos
	movd	r5,tos
	bsr	pc_mod		;May be in any module
	subd	m_pcofst,r5	;Subtract PC offset to get symbol value
	movzbd	h'b,r6		;PC label
	bsr	val2sym
	movd	tos,m_pcofst
	movd	tos,msb_mod
	movd	tos,msym_end
	movd	tos,msym_beg
	movd	tos,lmod
	cmpd	r5,2(m_symadr)	;Exact match only
	restore	[r5]
	bne	sgn_of2		;No label if NE
	cmpqd	-1,m_symadr
	beq	sgn_of2		;Not found if EQ, just display address

;Symbol found

	extsd	(m_symadr),r0,0,5 ;Length to R0
	addr	6(m_symadr),r1	;Pointer to R1
	addd	r0,tos		;Update current R0 offset
	movsb
	movd	tos,r0		;Restore updated R0
	movd	tos,r1		;Restore R1
	br	sgn_ofx

;Just display absolute address

sgn_of2:
	movd	tos,r0		;Restore R0
	movd	tos,r1		;Restore R1
	bsr	pos_asci
sgn_ofx:
	movb	">",r1[r0:b]
	addqd	1,r0
	restore	[r2,r5,r6]
	ret	0


;Display displacement offset in (R4)
ofset:	save	[r5]
	bsr	r4_disp
	bsr	sgn_asci
	restore	[r5]
	ret	0


;Remove trailing blanks and tabs from (R1), index in R0

trl_blnk:
	save	[r1,r3,r4]
	movd	m_delim:d,r3
	movqb	trm_blnk,r4
	addr	-1(r1)[r0:b],r1	;Point to last valid character
	skpst	b,w
	restore	[r1,r3,r4]
	ret	0

;Remove trailing commas from (R1), index in R0

trl_coma:
	save	[r4]
	movb	",",r4
	bsr	trail_x		;Remove trailing value in R4
	restore	[r4]
	ret	0


;Remove trailing value in R4 from string in R1, index in R0

trail_x:
	save	[r1]
	addr	-1(r1)[r0:b],r1	;Point to last actual character
	skpsb	b,w
	restore	[r1]
	ret	0


;Convert byte in R5 to general addressing mode in (R1)

dis_gen:

;If no indexing, just do mode

	cmpb	h'1c,r5
	bhi	dsgnsub

;This is indexed

	save	[r6]
	movb	r5,tos
	movb	0(r4),tos

;Advance to real mode

	extsd	0(r4),r5,3,5	;Gen mode in R5
	addqd	1,r4
	bsr	dsgnsub

	movb	tos,r6		;Restore gen mode/register
	movb	tos,r5		;Index size
	bsr	gen_indx
	restore	[r6]
	ret	0


;R5 = index size, R6 = mode/register

gen_indx:
	save	[r3]
	movd	"[R0:",r1[r0:b]
	extsd	r6,r3,0,3	;Register
	addb	r3,2(r1)[r0:b]
	extsd	r5,r3,0,2	;Index size
	movb	t_bwdq[r3:b],4(r1)[r0:b]
	movb	"]",5(r1)[r0:b]
	addqd	6,r0
	restore	[r3]
	ret	0

t_bwdq:	.byte	$"BWDQ"


;Do 2 GNs 1st in R5, 2nd in R6

dis_gen2:
	save	[r5,r6,r7]
	movqb	0,m_genm	;Gen 1-1

;Check for 2nd index mode

	cmpb	h'1c,r6
	bls	dsgn2a

;2nd gen not indexed

	bsr	dis_gen		;Do 1st mode
	movb	",",r1[r0:b]
	addqd	1,r0
	movb	r6,r5
	movqb	1,m_genm	;2nd gen now
	bsr	dsgnsub
	br	dsgnx

;2nd gen is indexed

dsgn2a:

;See if 1st mode is also indexed

	cmpb	h'1c,r5
	bls	dsgn2b

;2nd mode indexed, 1st mode not

	movb	0(r4),tos
	addqd	1,r4
	bsr	dsgnsub
	movb	",",r1[r0:b]
	addqd	1,r0

	movb	tos,r7		;2nd gen/register
	extsd	r7,r5,3,5	;2nd gen mode to R5
	movqb	1,m_genm	;2nd gen
	bsr	dsgnsub

	movb	r6,r5		;Index size to R5
	movb	r7,r6		;2nd gen/register

	bsr	gen_indx
	br	dsgnx

;Both gens indexed

dsgn2b:	movb	1(r4),tos	;2nd gen/register
	movb	r6,tos		;2nd index size

	movb	0(r4),tos	;1st gen/register
	addqd	2,r4		;Skip to displacements

	movb	r5,r7
	extsd	-2(r4),r5,3,5
	bsr	dsgnsub
	movb	r7,r5		;Restore original R5

	movb	tos,r6
	bsr	gen_indx

	movb	",",r1[r0:b]
	addqd	1,r0

	movb	tos,r7		;2nd index size
	movb	tos,r6		;2nd gen/register
	extsd	r6,r5,3,5
	bsr	dsgnsub
	movb	r7,r5
	bsr	gen_indx

dsgnx:	restore	[r5,r6,r7]
	ret	0

;Gen mode in R5, put opcode mnemonic into (R1)

dsgnsub:

;Check for register

	cmpb	8,r5
	bls	dsgns1

	movw	"R0",r1[r0:b]
	addb	r5,1(r1)[r0:b]
	save	[r2]
	extsb	m_opcod,r2,4,4	;Format
	cmpb	11,r2
	if	eq
	 movb	"F",r1[r0:b]	;This is a float
	 cmpqb	0,m_flt		;Check for long
	 if	eq
	  movb	"L",r1[r0:b]
	 endif
	else
	 cmpb	12,r2		;32381 extensions
	orif	eq
	 cmpb	9,r2
	 if	eq		;Possibly F0-F7 if EQ
	  extsd	m_opcod,r2,0,4	;Get op within format now
	  lshd	1,r2		;Multiply by 2
	  inssb	m_genm,r2,0,1	;LSB provided by M_GENM
	  movb	t_rf[r2:b],r1[r0:b]
	  cmpqb	0,m_flt		;Check for long
	  if	eq
	   cmpqb b'101,r2	;Op index 2, gen2 (MOVLF)
	   if	ne
	    cmpb "F",r1[r0:b]	;Only if FPU register
	    if	eq
	     movb "L",r1[r0:b]
	    endif
	   endif
	  else
	   cmpqb b'111,r2	;Op index 3, gen2 (MOVFL)
	  orif	eq
	  endif
	 endif
	endif
	restore	[r2]		;Remove value from stack

	addqd	2,r0
	ret

t_rf:	db	"RFRRFFFFFRFRRRFR" ;FPU/CPU register selection

dsgns1:

;Check for register relative

	cmpb	h'10,r5
	bls	dsgns2

;Display offset

	bsr	ofset
	movd	"(R0)",r1[r0:b]
	save	[r5]
	andb	7,r5
	addb	r5,2(r1)[r0:b]
	restore	[r5]
	addqd	4,r0
	ret	0

dsgns2:

;Check for memory relative

	cmpb	h'13,r5
	bls	dsgns3

;Get disp 1 in R5

	save	[r5,r6]
	movd	r5,r6		;Gen code in R6
	bsr	r4_disp		;Disp 1 in R5

;Display disp 2

	bsr	ofset
	movb	"(",r1[r0:b]
	addqd	1,r0

	bsr	dsgnms		;Memory space subroutine

	movb	")",r1[r0:b]
	addqd	1,r0
	restore	[r5,r6]
	ret	0

dsgns3:

;Check for immediate

	cmpb	h'14,r5
	bne	dsgns4

	save	[r3,r5]
	movzbd	10,r5
	bsr	aray_r5
	movzbd	m_siz,r3	;Need size in R3 now
	tbitb	b_sign,m_radix
	if	fs		;Sign extend if signed
	 movxbd	(r4),2(r5)	;Set upper bits if shorter then Dword
	else			;0 extend if unsigned
	 movzbd	(r4),2(r5)
	endif
	until	eq
	 movb	(r4),1(r5)[r3:b]
	 addqd	1,r4
	 addqb	-1,r3
	 cmpqb	0,r3
	endu

	extsb	m_opcod,r3,4,4	;Format of opcode
	cmpb	11,r3		;Always float if EQ
	if	eq
	 movw	exp b_def+(h'54 lsh b_mode),(r5) ;Defined long
	 cmpqb	4,m_siz		;See if float or long
	 if	eq		;Extend to long if 32 bit float
	  inssb	4,1(r5),b_size-8,4 ;32 bit float
	  movfl	2(r5),2(r5)
	 endif
	else
	 cmpb	h'91,m_opcod	;MOVif or LFSR always integer
	 if	lo
	  cmpb	m_opcod,h'98
	 endif
	orif	lo
	 movw	exp b_def+(h'24 lsh b_mode),(r5) ;Defined constant
	endif

dsgnim:	movw	m_radix,tos	;Current radix
	andw	h'1f+(exp b_sign),tos ;Only keep sign bit and radix
	orw	exp b_rdx +(exp b_buf),tos
	bsr	dsp_2r5
	restore	[r3,r5]
	ret	0

dsgns4:

;Check for absolute

	cmpb	h'15,r5
	bne	dsgns5

	movb	"@",r1[r0:b]
	addqd	1,r0
	br	ofset

dsgns5:

;Check for EXT

	cmpb	h'16,r5
	bne	dsgns6

	movd	"EXT(",r1[r0:b]
	addqd	4,r0
	bsr	ofset
	movb	")",r1[r0:b]
	addqd	1,r0

	save	[r5]		;SGN_ASC return value in R5
	bsr	sgn_asc
	restore	[r5]
	ret	0

dsgns6:

;Check for TOS

	cmpb	h'17,r5
	bne	dsgns7
	movd	"TOS",r1[r0:b]
	addqd	3,r0
	ret	0

dsgns7:

;Check for PC relative

	cmpb	h'1b,r5
	beq	dsgnpc

;Check for undefined opcode

	cmpb	h'18,r5
	bgt	dfmterr
	cmpb	h'1a,r5
	blt	dfmterr

;This is memory space

	save	[r5,r6]
	movb	r5,r6		;Register in R7
	bsr	r4_disp		;Get value in R5
	bsr	dsgnms		;Display value and register
	restore	[r5,r6]
	ret	0

dfmterr:
	movw	"??",r1[r0:b]
	addqd	2,r0
	ret	0

;Value in R5, gen code in R6, do memory space

dsgnms:
	bsr	sgn_asci	;Display it signed

	save	[r5,r6]
	andb	3,r6
	addb	8,r6

	movd	lmod,tos
	movd	msym_beg,tos
	movd	msym_end,tos
	movd	msb_mod,tos
	movd	m_pcofst,tos
	cmpb	10,r6		;Check for SB relative
	if	eq
	 tbitb	2,lnk_prm	;Check for ONEMOD
	 if	fc
	  addd	msb_mod,r5	;Make absolute within current module
	 else
	  addd	4+4+2+2*sidx_of+4+4+mod_tabl,r5 ;Absolute from 1st module
	 endif
	 movd	r5,tos
	 bsr	sb_mod		;May be in any module
	 subd	msb_mod,r5	;Subtract SB offset to get symbol value
	endif
	bsr	sym_r5		;Display symbol if there
	movd	tos,m_pcofst
	movd	tos,msb_mod
	movd	tos,msym_end
	movd	tos,msym_beg
	movd	tos,lmod

	negb	r6,r6
	addb	h'f,r6		;Need to reverse index
	movzbd	r6,r6

;Do register now

	movd	"(  )",r1[r0:b]
	movw	t_shreg:d[r6:d],1(r1)[r0:b]
	addqd	4,r0
	restore	[r5,r6]
	ret	0

;This is PC relative

dsgnpc:	movb	"*",r1[r0:b]
	addqd	1,r0
	br	sgn_ofs

;End of DIS32
