	print	"DEV32"

	disp	1

mac_pst	macro			;;Set F if character ready
	 cond	cg16_edb	;;CG16 board
	  tbitb	cen_stb,6*bus_byts+icu_adr ;;Check centronics port
	 cend			;;
	 cond	p_8255		;;8255 I/O
	  tbitb	0,pdatc		;;Check 8255 port
	 cend			;;
	mend

mac_pnd	macro			;;Set F if end-of-file true
	 cond	cg16_edb	;;
	  tbitb cen_init,6*bus_byts+icu_adr ;;See if terminated
	 cend			;;
	 cond	p_8255		;;
	  comb	pdatc,tos	;;Invert bits
	  tbitb	3,(sp)		;;FS IF /Init input low (end-of-file)
	  adjspb -1		;;Clear stack
	 cend			;;
	mend

mac_prd	macro	siz,dst		;;Read from printer device to DST:SIZ
	 cond	cg16_edb	;;
	  sbitb	cen_stb,2*bus_byts+icu_adr ;;Must be level triggered to reset
	  movqb	cen_stb,6*bus_byts+icu_adr ;;Clear status bit
	  cbitb	cen_stb,2*bus_byts+icu_adr ;;Restore edge triggering
;	  movb	b'11101000,pdata ;;ACK low
;	  movb	b'11101001,pdata ;;ACK high again
	  cond	$&siz eq $b	;;Byte read
	   movb	pdata,dst	;;
	  celse			;;
	   movzb&siz pdata,dst	;;Word or Dword read
	  cend			;;
	 cend			;;
	 cond	p_8255		;;
;	  movb	2*4,pctr	;;Pulse Ack low
;	  movb	2*4+1,pctr	;;Make high again
	  cond	$&siz eq $b	;;
	   movb	pdatb,dst	;;Byte read
	  celse			;;
	   movzb&siz pdatb,dst	;;Word or Dword read
	  cend			;;
	 cend			;;
	mend

mac_pxt	macro			;;Acknowlege end-of-file
	 cond	cg16_edb	;;
	  movb	b'11100001,pdata ;;Select low in acknowledgment
	  until	fc		;;Wait for INIT to return high
	   movqb cen_init,6*bus_byts+icu_adr ;;Clear status bit
	   tbitb cen_init,6*bus_byts+icu_adr ;;See if still there
	  endu			;;
	  movb	b'11101001,pdata ;;Select high again
	 cend			;;
	 cond	p_8255		;;
	  movb	6*2,pctr	;;Select low in acknowledgment
	  until	fs		;;Wait for INIT to return high
	   tbitb 3,pdatc	;;See if still there
	  endu			;;
	  movb	6*2+1,pctr	;;Select high again
	 cend			;;
	mend

macpoff	macro			;;Parallel port disabled
	 cond	cg16_edb
	  movb	b'11101001,pdata ;;PE low; SLCT,ERR,ACK high; BUSY,INT enabled
	  sbitb	cen_stb,2*bus_byts+icu_adr ;;Must be level triggered to reset
	  movqb	cen_stb,6*bus_byts+icu_adr ;;Clear status bit
	  cbitb	cen_stb,2*bus_byts+icu_adr ;;Restore edge triggering
	  movqb	cen_init,6*bus_byts+icu_adr ;;Clear status bit
	  cmpqb	0,pdata	;;Read data port to clear it
	 cend
	 cond	p_8255
	  movb b'10011011,pctr ;All lines inputs, A/B mode 0
	 cend
	mend

macpin	macro			;;Parallel port set for input
	 cond	cg16_edb
	  macpoff
	 cend
	 cond	p_8255
	  movb	b'10010111,pctr	;;B=mode 1 in, A=mode 0 in, C low=in, C hi=out
	  movb	b'11010000,pdatc ;;/Fault, Select, PE, /Ack
	  movqb 2*1,pctr	;;Set IBF and interrupt bits low
	  movqb 2*2+1,pctr	;;INTE allows reading INTR bit
	 cend
	mend

macpout	macro			;;Parallel port set for output
	 cond	p_8255
	  movb	b'10010101,pctr	;;B=mode 1 out, A=mode 0 in, C low=in, C hi=out
	  movb	b'01000000,pdatc ;;/Strobe high
	  movqb 2*1+1,pctr	;;Set /OBF and interrupt bits high
	  movqb 2*2+1,pctr	;;INTE allows reading INTR bit
	 cend
	mend

;----------------
;Printer routines
;----------------

;Printer input status routine

pri_sst:
pri_stat:
	mac_pst			;Check status, FS if character ready
	sfcd	r6
	disp	2
	if	fc		;Nothing there yet if FC
	disp	1
	 mac_pnd		;Check for end-of-file
	 if	fs
	  mac_pxt
	  movd	4*dof_bdat(r7),tos
	  sbitb	bdp_eof,dat_ptcl((sp))
	  adjspb -4		;Drop stack value
	 endif
	 movd	4*dof_bdat(r7),tos
	 tbitb	bdp_eof,dat_ptcl((sp))
	 adjspb -4		;Drop stack value
	 if	fs
	  sbitb bstat_ef,r6
	 endif
	endif
	ret

pri_io:
pri_sio:
	save	[r4]
	movd	4*dof_stat(r7),r4 ;Address of status routine
	until	fs
	 jsr	r4
	 cmpqd 0,r6
	quit	eq		;Get a character if EQ
	 tbitb bstat_ef,r6	;Check for end-of-file
	qend
	 mac_prd d,r5		;Read character to R5:D
	endu
	restore [r4]
	ret


;Printer input block routine
;R0 holds status bits, input length
;R1 points to start of buffer

pri_blk:
	save	[r0]
	bicd	exp bkb_hlt+exp bkb_bin+h'ffff,r0 ;Ignore these for now
	cmpd	exp bkb_tr5,r0	;Termination on R5
	if	ne
	 cmpd	exp bkb_trm,r0	;Termination on EOF
	endif
	restore	[r0]
	bne	nli_blk		;Only fast file read here

	save	[r1,r2,r3,r4,r5]
	cmpqw	-1,r0		;Check for infinite length
	tbitb	bkb_trm,r0	;EOF termination if set
	if	eq
	 movd	h'7fffffff,r0	;Infinite length
	else
	 movzwd	r0,r0		;Max input length
	endif

	movd	r0,tos		;Starting count
	if	fc		;EOF termination if FS
	 until eq
	  until fs
	   mac_pst		;Check input status
	  endu			;Wait for something
	  mac_prd b,r4
	  movb r4,(r1)
	  cmpqd 1,r0		;See if more room
	  if	lt		;Don't write past defined buffer
	   addqd 1,r1		;Advance pointer
	  endif
	  addqd -1,r0		;Decrement counter
	  cmpb r4,r5
	 endu
	disp	2
	else
	disp	1
	 until fs
	  mac_pst		;FS if a character is ready
	  if	fs		;Got one if FS
	   mac_prd b,(r1)	;Read character to R1:B
	   cmpqd 1,r0		;See if more room
	   if	lt		;Don't write past defined buffer
	    addqd 1,r1		;Advance pointer
	   endif
	   addqd -1,r0		;Decrement counter, clear F
	  else
	   mac_pnd		;Check for end-of-file
	  endif
	 endu
	 mac_pxt
	 movd	4*dof_bdat(r7),r1
	 sbitb	bdp_eof,dat_ptcl(r1)
	endif
	
	negd	r0,r0
	addd	tos,r0		;Number of characters read
	restore	[r1,r2,r3,r4,r5]
	movqd	0,r6		;Success
	ret


pro_cinit:
	macpoff
	ret


;Open printer device for input

pri_copen:
	save	[r3]

	movd	4*dof_bdat(r7),r3 ;Data pointer
	tbitb	bdp_opn,dat_ptcl(r3) ;See if already open
	if	fc
	 macpin
	endif
	bsr	nli_copen

	restore [r3]
	ret


pri_cclose:
	bsr	nli_cclose
	macpoff
	ret

pro_sst:
pro_stat:
	cond	p_8255
	 tbitb	3,pdatc		;Check BUSY
	 sfsd	r6		;BUSY low = ready for data
	cend
	ret

pro_sio:
pro_io:
	cond	p_8255
	 until	fc
	  tbitb	3,pdatc		;Wait for BUSY low
	 endu			;Wait until not busy
	 movb	r5,pdatb	;Output character
	 movb	2*6,pctr	;Set strobe low
	 movb	2*6+1,pctr	;Set strobe high again
	cend
	ret


;Send character from R5
;R7 holds base address of device block

	disp	2

pro_chr:
	save	[r0,r1,r2,r3,r4,r5]

	bsr	nlo_chrbsy
	cmpqd	0,r6		;Character done if eq
	if	ne
	 movd	4*dof_dat(r7),r3
	 cmpb	ff,r5		;Check for new page
	 if	eq
	  movb	vc_scr,r5
	  bsr	pro_chr
	  movb	vcs_pag,r5
	  bsr	pro_chr
	 else
	  cmpb	tab,r5		;Expand tabs to printer
	  if	eq
	   movzwd dat_col(r3),r5
	   bsr	pix2chr
	   movd r5,r4
	   addw 8,r4
	   bicb 7,r4		;Advance to next tab stop
	   subw r5,r4
	   movzbd " ",r5
	   until eq
	    bsr s1o_chr
	    addqw -1,r4
	    cmpqw 0,r4
	   endu
	  else
	   cmpb lf,r5
	   if	ne
	    bsr s1o_chr	;Just send as is
	   else
	    movd 4*dof_vdat(r7),r1 ;Vdat pointer
	    movw dat_line(r3),r4
	    addw dat_chry(r3),r4 ;Start of next line
	    cmpw vdt_maxl(r1),r4 ;See if this is last line
	   orif ge
	    movqw 0,dat_line(r3) ;Don't want an endless loop
	    movqd 6+1,r0	;Original lf and 6 more at end of page
	    until eq
	     movb lf,r5
	     bsr pro_chr
	     addqb -1,r0
	     cmpqb 0,r0
	    endu
	    movqw 0,dat_line(r3)
	    addqw 1,dat_page(r3)
	   endif
	  endif
	 endif
	endif
	restore	[r0,r1,r2,r3,r4,r5]
	ret

	disp	1

;------------------------------------
; Do form feed for "new page" command
;------------------------------------

pro_ccls:
	save	[r4,r5]
	movd	4*dof_sio(r7),r4
	movzbd	ff,r5
	jsr	r4
	restore	[r4,r5]
	ret


;Printer output command processor

pro_copen:
	save	[r3]

	movd	4*dof_bdat(r7),r3 ;Data pointer
	tbitb	bdp_opn,dat_ptcl(r3) ;See if already open
	if	fc
	 macpout
	endif
	bsr	nlo_copen

	restore [r3]
	ret


pro_cclose:
	bsr	nlo_cclose
	macpoff
	ret


;--------------------
; Printer end of file
;--------------------

pro_ceof:
	cond	p_8255
	 save	[r3]
	 movd	4*dof_bdat(r7),r3
	 tbitb	bdp_bin,dat_ptcl(r3) ;Check for binary transfer
	 if	fs
	  sbitb	bdp_eof,dat_ptcl(r3)
	  if	fc		;Only if not already done
	   movb	6*2,pctr	;End-of-file low
	   until fc		;Wait for ack from computer
	    tbitb 3,pdatc	;See if there yet
	   endu
	   movb	6*2+1,pctr	;End-of-file high again
	  endif
	 endif
	 restore [r3]
	cend
	ret


;-------------------
; XMODEM sst routine
;-------------------

	disp	2

xmi_sst:
	save	[r2,r3,r4,r5]
	movd	4*dof_bdat(r7),r3 ;Data pointer
	movw	dat_xmoch(r3),r5
	andw	dat_bchr(r3),r5
	cmpqw	0,r5		;See if anything to read in buffer
	seqd	r6
	if	eq		;Just return status if readable data
	 movqw	0,dat_xmoch(r3)	;Cancel output now
	 movqd	0,dat_bchr(r3)	;Clear buffer
	 movqd	0,dat_bwtx(r3)
	 movqd	0,dat_brdx(r3)	;Resynchronize pointers
	 tbitb	bdp_eof,dat_ptcl(r3) ;Check for end of file
	 if	fs
	  sbitb	bstat_ef,r6
	 else
	  cmpqd 0,dat_xmblk(r3) ;Check for file in progress
	  if	ne		;File in progress, send ACK
	   save [r3,r6]
	   movzbd dat_io(r3),r6
	   orw	dof_io lsh b_iosrv,r6
	   movzbd ack,r5
	   bsr	bsr_svc
	   restore [r3,r6]
	  else			;File hasn't started yet
	   until eq
	    save [r3,r6]
	    movzbd dat_io(r3),r6
	    orw dof_io lsh b_iosrv,r6
	    movzbd nak,r5
	    bsr bsr_svc
	    restore [r3,r6]
	    movd 4*dof_stat(r7),r4 ;Receive status
	    movd 70000,r2	;Substantial delay
	    begin
	     jsr r4
	     cmpqd 0,r6	;Wait for transmission to start
	    quit eq
	     cmpqd 0,r2
	    while ne
	     addqd -1,r2
	    endw
	    cmpqd 0,r6
	   endu
	   movqd 1,dat_xmblk(r3) ;Block 1 is about to begin
	  endif

	  movd	4*dof_io(r7),r4 ;Character receive routine
	  movqw 0,dat_xmcrc(r3) ;Initialize checksum
	  jsr	r4
	  cmpqb eot,r5		;Check for end of file
	  if	eq
	   movd	4*dof_bdat(r7),r5
	   sbitb bdp_eof,dat_ptcl(r5) ;End of file/transmission
	   save [r3,r6]
	   movzbd dat_io(r3),r6
	   orw	dof_io lsh b_iosrv,r6
	   movzbd ack,r5
	   bsr	bsr_svc
	   restore [r3,r6]
	   movzbd exp bstat_ef,r6
	  else
	   until eq
	    cmpqb soh,r5
	    if	ne
	     movqb -1,dat_xmcrc+1(r3) ;Error already
	    endif
	    jsr	r4
	    cmpb r5,dat_xmblk(r3) ;Should be current block
	    if	ne
	     movqb -1,dat_xmcrc+1(r3)
	    endif
	    jsr	r4
	    comb r5,r5
	    cmpb r5,dat_xmblk(r3)
	    if	ne
	     movqb -1,dat_xmcrc+1(r3)
	    endif		;Ready for actual character now
	    ;
	    movb 128,r2		;Number of characters to read
	    until eq
	     jsr r4		;Read a character
	     addb r5,dat_xmcrc(r3) ;Update checksum
	     addqb -1,r2
	     cmpqb 0,r2
	    endu
	    jsr	r4		;Get checksum
	    subb dat_xmcrc(r3),r5 ;Checksum must match
	    orb	dat_xmcrc+1(r3),r5 ;Can't have earlier errors either
	    cmpqb 0,r5
	    if	ne
	     save [r3,r6]
	     movzbd dat_io(r3),r6
	     orw dof_io lsh b_iosrv,r6
	     movzbd nak,r5
	     bsr bsr_svc
	     restore [r3,r6]
	     jsr r4		;Read next character
	     bicpsrb flag_z	;Make ne
	    endif
	   endu
	  
	   subd 129,dat_brdx(r3)
	   andd dat_bsz(r3),dat_brdx(r3) ;Backup to valid data
	   movzbd 128,dat_bchr(r3) ;Release this block to read routine
	   movqw -1,dat_xmoch(r3) ;Enable output now
	   addqd 1,dat_xmblk(r3) ;Increment block number
	   movqd 0,r6		;Success
	  endif
	 endif
	endif
	restore	[r2,r3,r4,r5]
	ret


;--------------------------------
; XMODEM character output routine
;--------------------------------

	disp	2

xmo_sio:
	save	[r1,r2,r3,r4,r5]
	movd	4*dof_dat(r7),r3 ;Data pointer
	movzwd	dat_xmoch(r3),r2
	addd	dat_xmblk(r3),r2 ;Check for 1st character of file
	cmpqd	0,r2
	if	eq		;Wait for NAK from transmitter if EQ
	 movd	4*dof_bdat(r7),r2
	 cbitb	bdp_xmc,dat_ptcl(r2) ;XMODEM CRC off
	 save	[r3,r5,r6,r7]
	 movzbd	dat_io(r3),r6
	 orw	dof_sio lsh b_iosrv,r6
	 until	eq
	  save	[r3,r6]
	  bsr	bsr_svc		;Wait until receiver ready
	  restore [r3,r6]
	  cmpb	nak,r5
	  if	ne
	   cmpb	"C",r5		;CRC protocol
	   if	eq
	    movd 4*dof_bdat(r7),r5
	    sbitb bdp_xmc,dat_ptcl(r5) ;XMODEM CRC on
	   endif
	  endif
	 endu
	 restore [r3,r5,r6,r7]
	 movqd	1,dat_xmblk(r3)	;Block 1 is about to begin
	endif
	
	movd	4*dof_io(r7),r4 ;Character send routine
	cmpqw	0,dat_xmoch(r3)	;Check for beginning of block
	if	eq
	 movqw	0,dat_xmcrc(r3)	;Initialize checksum
	 save	[r5]
	 movqd	soh,r5
	 jsr	r4		;Start of block
	 movzbd dat_xmblk(r3),r5 ;Block number
	 jsr	r4
	 comb	r5,r5		;Complement of block number
	 jsr	r4
	 restore [r5]
	endif
	movzwd	dat_xmoch(r3),r4 ;Write index
	movd	dat_bpt(r3),r2	;Buffer pointer
	movb	r5,r2[r4:b]	;Store character just received
	addqd	1,r4
	movw	r4,dat_xmoch(r3) ;New data pointer
	movd	4*dof_bdat(r7),r2
	tbitb	bdp_xmc,dat_ptcl(r2) ;Check for CRC mode
	if	fc
	 addb	r5,dat_xmcrc(r3) ;Update checksum
	else
	 movzwd dat_xmcrc(r3),r2 ;CRC is word
	 lshw	8,r5		;Need byte in upper 16 bits
	 xorw	r5,r2
	 movw	h'1021,r1	;XOR with this as needed
	 movb	8,r5
	 until	eq
	  addw	r2,r2
	  if	cs
	   xorw r1,r2
	  endif
	  addqb -1,r5
	  cmpqb 0,r5
	 endu
	 movw	r2,dat_xmcrc(r3)
	 lshw	-8,r5		;Restore R5
	endif
	movd	4*dof_io(r7),r4
	jsr	r4		;Send character in R5
	cmpb	128,dat_xmoch(r3) ;See if block is complete
	if	eq
	 begin
	  movd	4*dof_bdat(r7),r2
	  tbitb bdp_xmc,dat_ptcl(r2) ;Check for CRC mode
	  if	fc		;Checksum if FC
	   movzbd dat_xmcrc(r3),r5 ;Checksum
	   jsr	r4
	  else
	   movzbd dat_xmcrc+1(r3),r5 ;CRC MSB
	   jsr	r4
	   movzbd dat_xmcrc(r3),r5 ;CRC LSB
	   jsr	r4
	  endif
	  save	[r3,r6]
	  movzbd dat_io(r3),r6
	  orw	dof_sio lsh b_iosrv,r6
	  bsr	bsr_svc		;Wait for response
	  restore [r3,r6]
	  cmpb	ack,r5
	 while	ne
	  movqd soh,r5
	  jsr	r4		;Start of block
	  movb	dat_xmblk(r3),r5 ;Block number
	  jsr	r4
	  comb	r5,r5		;Complement of block number
	  jsr	r4
	  movd	dat_bpt(r3),r1	;Buffer pointer
	  movb	128,r2		;Data count
	  until eq		;Re-send data
	   movzbd (r1),r5
	   jsr	r4
	   addqd 1,r1
	   addqb -1,r2
	   cmpqb 0,r2
	  endu
	 endw
	 addqd	1,dat_xmblk(r3)	;Increment block number
	 movqw	0,dat_xmoch(r3)	;Reset character counter
	endif

	restore	[r1,r2,r3,r4,r5]
	movqd	0,r6
	ret


;***************************************
;* IBM AT type direct connect keyboard *
;***************************************

	cond	kbdibm

;Translation table for incoming keyboard make codes
;Bit 7 assumed stripped

	radix	16
kbd_xlat:
;No shift
	dw	0,0,0,0,'-',0,0,87,01b,0,0,0,0,9,'`',8f
	dw	0,91,92,0,94,'q','1',97,0,99,'z','s','a','w','2',9f
	dw	0,'c','x','d','e','4','3',0a7,0,' ','v','f','t','r','5',0af
	dw	0,'n','b','h','g','y','6',0b7,0,0b9,'m','j','u','7','8',0bf
	dw	0,',','k','i','o','0','9',0c7,0,'.','/','l',';','p','-',0cf
	dw	0,0,"'",0,'[','=',0d6,0d7,0d8,0d9,0d,']','\',0,0de,0df
	dw	(vcw_chr+vcw_mov+vcw_dn) lsh 8 + vc_win
	dw	(vcw_chr+vcw_mov+vcw_lft) lsh 8 + vc_win
	dw	0e2
	dw	(vcw_chr+vcw_mov+vcw_up) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_del+vcw_rt) lsh 8 + vc_win
	dw	0e5
	dw	(80+vcw_chr+vcw_del+vcw_lft) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_ins+vcw_rt) lsh 8 + vc_win
	dw	0,'1'
	dw	(vcw_chr+vcw_mov+vcw_rt) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_mov+vcw_lft) lsh 8 + vc_win
	dw	'7',0ed,0ee,0ef
	dw	(80+vcw_chr+vcw_ins+vcw_rt) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_del+vcw_rt) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_mov+vcw_dn) lsh 8 + vc_win
	dw	'5'
	dw	(80+vcw_chr+vcw_mov+vcw_rt) lsh 8 + vc_win
	dw	(80+vcw_chr+vcw_mov+vcw_up) lsh 8 + vc_win
	dw	0f6,'/'
	dw	0,0d,'3',0,'+','9','*',0
kbd_shxlt:
;Shift
	dw	0,0,0,0,'-',0,0,87,01b,0,0,0,0,9,'~',8f
	dw	0,91,92,0,94,'Q','!',97,0,99,'Z','S','A','W','@',9f
	dw	0,'C','X','D','E','$','#',0a7,0,' ','V','F','T','R','%',0af
	dw	0,'N','B','H','G','Y','^',0b7,0,0b9,'M','J','U','&','*',0bf
	dw	0,'<','K','I','O',')','(',0c7,0,'>','?','L',':','P','_',0cf
	dw	0,0,'"',0,'{','+',0d6,0d7,0d8,0d9,0d,'}','|',0,0de,0df
	dw	(vcw_chr+vcw_mov+vcw_dn) lsh 8 + vc_win
	dw	(vcw_chr+vcw_mov+vcw_lft) lsh 8 + vc_win
	dw	0e2
	dw	(vcw_chr+vcw_mov+vcw_up) lsh 8 + vc_win
	dw	(vcw_chr+vcw_del+vcw_rt) lsh 8 + vc_win
	dw	0e5,07f
	dw	(80+vcw_chr+vcw_ins+vcw_rt) lsh 8 + vc_win
	dw	0,'1'
	dw	(80+vcw_chr+vcw_mov+vcw_rt) lsh 8 + vc_win
	dw	'4','7',0ed,0ee,0ef
	dw	'0','.','2','5','6','8',0f6,'/',0,0d,'3',0,'+','9','*',0
	radix	10

kbo_stat:
kbo_sst:
	movqd	0,r6		;Always ready to output
	ret


;Delay about 100us, r0 altered

kb_delay:
	movw	120,r0
	until	eq
	 cmpqb	0,p_kbd+bus_byts ;14 clock minimum
	 addqw	-1,r0
	 cmpqw	0,r0
	endu			;Delay about 333us
	ret

kbo_io:
	save	[r0,r1,r2]

	movb	b'00000001,p_kbd+3*bus_byts ;RTS high, DTR high, RX off, TX on
	sbitb	6,icu_adr+11*bus_byts	;Set mask to disable interrupt
	sprb	psr,r2		;Save interrupt status

	bsr	kb_delay	;Short delay
	movb	r5,p_kbd	;Write character
	sbitb	5,p_kbd+3*bus_byts ;RTS low, TxClk line high

	bsr	kb_delay	;Short delay
	cbitb	5,p_kbd+3*bus_byts ;RTS high, TxClk line low
	bsr	kb_delay	;Short delay
	sbitb	5,p_kbd+3*bus_byts ;RTS low, TxClk line high

	sbitb	2,p_kbd+3*bus_byts ;Enable receiver again
	bsr	kb_delay	;Short delay
	cbitb	5,p_kbd+3*bus_byts ;RTS high, TxClk line low, TxData low
	bsr	kb_delay	;Short delay
	sbitb	1,p_kbd+3*bus_byts ;DTR low, Release kbd clock line
	until	fs
	 tbitb	1,p_kbd+bus_byts ;Wait to receive echo
	endu

	bsr	kb_delay	;Short delay
	movqb	3,r1		;More clocks to clear things
	until	eq
	 sbitb	5,p_kbd+3*bus_byts ;RTS low, TxClk line high
	 bsr	kb_delay	;Short delay
	 cbitb	5,p_kbd+3*bus_byts ;RTS high, TxClk line low
	 bsr	kb_delay	;Short delay
	 addqb	-1,r1
	 cmpqb	0,r1
	endu

	cbitb	1,p_kbd+3*bus_byts ;DTR high, clock low
	movb	p_kbd,r0	;Fetch character just sent
	cmpqb	0,p_kbd+bus_byts ;Clear DSR change bit
	movb	b'00010000,p_kbd+3*bus_byts ;RTS high, DTR high, RX off, TX off
	tbitb	log flag_f,r2	;See if interrupt was enabled
	if	fc		;It was enabled if fc
	 cbitb	6,icu_adr+11*bus_byts ;Clear mask to enable interrupt
	endif
	movb	b'00010110,p_kbd+3*bus_byts ;RTS high, DTR low, RX on, TX off

	restore	[r0,r1,r2]
	movqd	0,r6
	ret


kbo_sio:
	save	[r2,r3,r4]
	movd	4*dof_dat(r7),r3
	sbitb	6,icu_adr+11*bus_byts	;Set mask to disable interrupt

	tbitb	2,p_kbd+bus_byts ;Change in DSR if character coming
	if	fs		;Character coming if fs
	 until	fs
	  tbitb	1,p_kbd+bus_byts ;Wait for character to come in
	 endu
	 movzbd	dat_io(r3),r6
	 orw	dof_sst lsh b_iosrv,r6
	 bsr	bsr_svc		;Read and store character
	endif

	movd	4*dof_io(r7),r4
	jsr	r4		;Send character in r5

	movzbd	dat_io(r3),r6
	orw	dof_io lsh b_iosrv,r6
	bsr	bsr_svc		;Read response

	cbitb	6,icu_adr+11*bus_byts ;Clear mask to enable interrupt
	restore	[r2,r3,r4]
	movqd	0,r6
	ret

;Set keyboard LEDs according to r5

kbo_cled:
	movb	r5,tos
	movzbd	0ed,r5		;LED command
	bsr	kbo_sio
	movzbd	tos,r5		;Requested status
	bsr	kbo_sio
	ret


kbi_stat:
	tbitb	1,p_kbd+bus_byts ;Character received if fs
	sfcd	r6
	ret


kbi_io:
	until	fs
	 tbitb	1,p_kbd+bus_byts ;Character received if fs
	endu
	movzbd	p_kbd,r5
	movqd	0,r6
	ret


;Status keys (caps, shift, control, alt)

t_keystat:
	db	h'12		;Left shift
	db	h'59		;Right shift
	db	h'11		;Left control
	db	h'19		;Left alt
	db	h'58		;Right control
	db	h'39		;Right alt
t_ktog:				;These are toggles
	db	h'14		;Caps lock
	db	h'76		;Num lock
t_kstx:

;Store r5 in buffer, r1,r4 altered
;r3 must holds dof_dat

kbi_putr5:
	ret

	disp	1

kbi_sst:
	movd	r3,tos
	movd	4*dof_dat(r7),r3
	cmpqd	0,dat_bchr(r3)
	seqd	r6
	movd	tos,r3
	ret

	disp	2

kbi_int:
	save	[r0,r1,r3,r4,r5]

	movd	4*dof_dat(r7),r3
	tbitb	1,p_kbd+bus_byts ;Character received if fs
	if	fs
	 movd	4*dof_io(r7),r4
	 jsr	r4
	 cmpb	h'f0,r5		;Check for break code
	 if	ne		;Keypress if ne
	  cmpb	h'84,r5		;Highest actual keypress
	  if	hs
	   movzbd t_kstx-t_keystat,r0
	   addr t_keystat,r1
	   movd r5,r4
	   skpsb u		;Search for status key
	   if	fs		;Got a match if fs
	    cmpb t_kstx-t_ktog,r0 ;These are toggles
	    if	hs
	     ibitb r5,dat_image(r3) ;Toggle this
	     cmpb h'14,r5	;Check for caps lock
	     if eq
	      movd dc_led,r5
	      tbitb h'14,dat_image(r3) ;Check CAPS
	      if fs
	       sbitb 2,r5
	      endif
	      tbitb h'76,dat_image(r3) ;Check Num Lock
	      if fs
	       sbitb 1,r5
	      endif
	      movzbd dat_io(r3),r6
	      orw dof_cmd lsh b_iosrv,r6
	      bsr bsr_svc	;Send command
	     else
	      cmpb h'76,r5	;Num lock
	     orif eq
	     endif
	    else
	     sbitb r5,dat_image(r3) ;Only these are turned on
	    endif
	   else			;Not special control key
	    movd dat_bwtx(r3),r4 ;Write index
	    movd dat_bpt(r3),r1	;Buffer pointer
	    movb r5,r1[r4:b]	;Store character just received
	    addqd 1,r4		;Increment pointer
	    andd dat_bsz(r3),r4	;Wrap around as needed
	    movd r4,dat_bwtx(r3) ;New data pointer
	    addqd 1,dat_bchr(r3) ;Increment character count
	   endif
	  endif
	 else			;This is break code
	  jsr	r4		;Get key
	  cbitb	7,r5
	  cbitb r5,dat_image(r3) ;Turn if off now
	 endif
	endif
	restore	[r0,r1,r3,r4,r5]
	ret


int_kbi:
	save	[r4,r6,r7]
	bispsrw	flag_i		;Service other interrupts here
	movd	4*(dev_smk+1)(dev_ptr),r7 ;Base address
	movd	4*dof_int(r7),r4
	jsr	r4
	restore	[r4,r6,r7]
	reti


ski_cxlat:
	save	[r2,r3,r4]
	movqd	0,r6		;Assume OK
	movd	4*dof_dat(r7),r3
	movqb	0,r2		;Assume no shift
	cmpb	h'70,r1		;Check for number pad key
	if	ls		;Definately numeric keypad if ls
	 tbitb	h'76,dat_image(r3) ;See if Num Lock is down
	 if	fs
	  movqb 1,r2		;Treat this as shift
	 endif
	else
	 cmpb	h'69,r1
	orif eq
	 cmpb	h'6b,r1
	orif	eq
	 cmpb	h'6c,r1
	orif	eq
	endif
	cbitb	7,r1
	tbitb	h'12,dat_image(r3) ;Left shift
	if	fs
	 ibitb	0,r2		;Invert shift status
	else
	 tbitb	h'59,dat_image(r3) ;Right shift
	orif fs
	endif
	tbitb	0,r2		;Shift status
	if	fs
	 movw	kbd_shxlt[r1:w],r1
	else
	 movw	kbd_xlat[r1:w],r1 ;No shift
	endif
	movqd	2,r0		;Return as is if > 80
	cmpw	h'80,r1
	if	hi
	 tbitb	h'14,dat_image(r3) ;Caps lock
	 if	fs
	  cmpb	'a',r1	;Only convert a-z
	  if	ls
	   cmpb	'z',r1
	   if	hs
	    cbitb 5,r1	;Make upper case
	   endif
	  endif
	 endif
	 tbitb	h'11,dat_image(r3) ;Left control
	 if	fs
	  andb	h'1f,r1
	 else
	  tbitb	h'58,dat_image(r3) ;Right control
	 orif	fs
	 endif
	 tbitb	h'19,dat_image(r3) ;Left alt
	 if	fs
	  sbitb	7,r1
	 else
	  tbitb h'39,dat_image(r3) ;Right alt
	 orif	fs
	 endif
	 movqd	1,r0	;Only 1 character
	endif
	restore	[r2,r3,r4]
	ret


;Initialization string
kbinit:
	db	h'f6		;Restore default settings
	db	h'f0,3		;Mode 3
	db	h'ed,0		;All LEDs off
	db	h'f3,b'00001000	;250ms delay, 15 repeats/second
	db	h'fb,h'6b	;4/left typematic
	db	h'fb,h'71	;./del typematic
	db	h'fb,h'72	;2/down typematic
	db	h'fb,h'74	;6/right typematic
	db	h'fb,h'75	;8/up typematic
	db	h'fd,h'14	;Caps Lock make only
	db	h'fc,h'39	;Right alt make/break
	db	h'fc,h'58	;Right Ctrl make/break
	db	h'f4		;Clear buffer and start scanning
kbinitx:

kbo_cinit:
	save	[r0,r1,r2,r3,r4,r5]

	movb	b'01011101,p_kbd+2*bus_byts ;8O1, 1x Baud
	movqb	0,p_kbd+2*bus_byts ;External clocks
	movb	b'00010100,p_kbd+3*bus_byts ;Rx enabled, RTS high, DTR high
	sbitb	1,p_kbd+3*bus_byts ;DTR low now
	cmpqb	0,p_kbd+bus_byts ;Clear /DSR change status bit
	cmpqb	0,p_kbd		;Read data port to clear it

	movzbd	h'1e,r5			;Vector index
	addr	int_kbi,r4		;Absolute address
	sprd	mod,r2
	sprd	psr,r3
	bsr	instal_trp		;Set trap address

	cbitb	6,icu_adr+3*bus_byts	;Edge triggered
	sbitb	6,icu_adr+5*bus_byts	;Rising edge
	cbitb	6,icu_adr+11*bus_byts	;Clear mask to enable interrupt

	movd	(exp bkb_cnt)+(exp bkb_bin)+kbinitx-kbinit,r0
	addr	kbinit,r1
	bsr	nlo_blk		;Send initialization string

	restore	[r0,r1,r2,r3,r4,r5]
	ret

	cend

;End of DEV32
