	print	"CON32"

	disp	1

;IO interface routines

;Macro to call supervisor routine

mac_svc	macro
	cond	svc_cxp
	 svc
	celse
	 cxp	0
	cend
	mend

mac_cmd	macro	cmd,dvc
	cond	$<dvc> eq $<$<>> ;;If no device
	 movd	cmd,r5
	 bsr	sys_cmd
	celse			;;Device required too
	 movd	r6,tos
	 movzbd	dvc,r6
	 movd	cmd,r5
	 bsr	sys_cmd
	 movd	tos,r6
	cend
	ret
	mend

;------------------------------
; Do system command:
;   device in r6, command in r5
;------------------------------

sys_cmd:
	movd	r6,tos
	orw	dof_cmd lsh b_iosrv,r6
	mac_svc
	movd	tos,r6
	ret


;---------------------------------------
; As above but load r6 with dev_op first
;---------------------------------------

sys_cmdop:
	movd	r6,tos
	movzbd	dev_op,r6
	bsr	sys_cmd
	movd	tos,r6
	ret


;Exit to operating system

sys_xit::
	mac_cmd	dc_prgx,dev_op	;Exit to system


;Transmit character in R5 via device in TX_DEV

char_tx::
	save	[r5,r6]
	movzbd	tx_dev,r6
	movzbd	r5,r5
	orw	dof_chr lsh b_iosrv,r6
	mac_svc
	restore	[r5,r6]
	ret

;Receive character into R5 via system message routine

char_rx::
	save	[r6]
	movd	(dev_smk+1)+dof_chr lsh b_iosrv,r6
	mac_svc
	restore	[r6]
	ret


;Get current window number in R5

get_win::
	mac_cmd	dc_gwin,dev_smv	;Command to return window number


;Get max character x/y in r5

g_chrmax::
	mac_cmd	dc_gchmx,dev_smv ;Command to get max character x/y


;Get CFG, return in R5

get_cfg::
	mac_cmd	dc_getcfg,dev_op


;Get FPU type, return in R5

get_fpu::
	mac_cmd	dc_fpu,dev_op


;Set debugger entry address from r4

set_dbgadr::
	save	[r6]
	movd	dev_op+dof_cmd lsh b_iosrv,r6
	movd	dc_dbgadr + exp dc_dbgpc,r5 ;Use default MOD, PSR
	mac_svc
	restore	[r6]
	ret


;Set trap service address from r4

set_trpadr::
	save	[r6]
	movd	dev_op+dof_cmd lsh b_iosrv,r6
	ord	dc_trpadr+exp dc_trppc,r5 ;Use default MOD, PSR
	mac_svc
	restore	[r6]
	ret

;Set trapped SB storage address from r4

set_sbadr::
	ord	dc_sbptr,r5	;Device number in bits 0-7
	br	sys_cmdop


;Fetch trapped SB value

get_sb:
	mac_cmd	dc_trpsb,dev_op


;Clear screen

clr_scr::
	save	[r5]
	movzbd	vc_scr,r5
	bsr	char_tx
	movzbd	vcs_pag,r5
	bsr	char_tx
	restore	[r5]
	ret


;Select window in R5:D
;Device is system message

set_wndw::
	save	[r4,r5,r6]
	movb	r5,m_windx	;Current selection
	movzbd	r5,r4		;Window number
	movd	m_windat[r4:d],r4 ;Handle or index
	movzbd	dev_smv,r6
	movd	dc_putr7,r5
	bsr	sys_cmd
	restore	[r4,r5,r6]
	ret


;Define window number in R5:D
;Parameters on stack 1st col:b, 1st row:b, Max col:B, Max row:B
;Switch in new window and clear it

new_wndw::
	lproc
row:	ds	1		;Number of rows
col:	ds	1		;Number of columns
row1:	ds	1		;Absolute upper left row
col1:	ds	1		;Absolute upper left column
	reg	[r0,r4,r5,r6]
	code

	movb	r5,m_windx	;Current selection
	movzbd	r5,r0		;Window number
	movd	m_windat[r0:d],r4 ;Handle or index
	cmpqd	-1,r4		;Create new instance if not yet defined
	if	eq
	 movzbd	dev_smv,r6
	 movd	dc_instnc,r5
	 bsr	sys_cmd		;Create new instance
	 movd	r5,m_windat[r0:d] ;Returned handle or index
	 movd	r5,r4
	 movzbd	dev_smv,r6
	 movd	dc_putr7,r5
	 bsr	sys_cmd		;Make this instance current
	else
	 bsr	set_wndw	;Just select window if already defined
	endif
	movd	col1,r4		;Window parameters
	movzbd	dev_smv,r6
	movd	dc_nwn,r5	;Now define new parameters
	bsr	sys_cmd

	pend


;Receive a line via device in R6
;R1 => buffer
;R1 advanced if first character is line feed
;Device off at end of line
;R0 must hold max input length

blk_in::
	save	[r5,r6]
	ord	exp bkb_tr5+exp bkb_hlt,r0 ;Halt on R5
	orw	dof_blk lsh b_iosrv,r6 ;Block input
	movzbd	cr,r5		;Wait for this
	mac_svc
	restore	[r5,r6]
	cmpb	lf,(r1)
	if	eq
	 addqd	1,r1
	 addqd	-1,r0
	endif
	ret

;Read a file from device in R6, device already open
;R0 holds upper bits of r0 and termination character if any

rd_file::
	save	[r5,r6]
	movzbd	r0,r5		;Termination if any
	movqw	-1,r0		;Infinite length
	orw	dof_blk lsh b_iosrv,r6 ;Block input
	movd	r0,tos		;Save status bits
	mac_svc
	movd	tos,r5
	tbitb	bkb_tr5,r5
	if	fs		;Check for termination character
	 addqd	-1,r0		;Termination character doesn't count
	endif
	restore	[r5,r6]

	ret

;Write a file to device in R6
;R1 => data, R0 holds count
;R5 holds upper bits of r0

wrt_file::
	save	[r2,r6]
	orw	dof_blk lsh b_iosrv,r6 ;Block output
	movd	r0,r2		;16 bit max count for SVC output
	lshd	-15,r2		;MSW of count
	addqd	1,r2		;Remainder in r0 counts too
	andd	h'7fff,r0	;LSW of count

	until	eq
	 save	[r2,r5,r6]
	 movw	r0,r5		;Lower bits of r0
	 movd	r5,r0		;Upper bits of r0
	 ord	exp bkb_cnt,r0	;Halt on count in R0
	 mac_svc
	 restore [r2,r5,r6]
	 movw	h'8000,r0	;32K chunks from now on
	 addqd	-1,r2
	 cmpqd	0,r2
	endu

	restore	[r2,r6]
	ret


;Send open command to device in R6:D (bits 0-7)

	disp	2

dev_open::
	save	[r4,r5,r6]
	cond	op_sys
	 orw	dof_cmd lsh b_iosrv,r6
	 movd	dc_open,r5
	 cmpb	dev_m1+1,r6	;Check for disk input
	 if	eq
	  orb	usr_exe,r5
	  mac_svc
	 else
	  cmpb	dev_m1,r6	;Check for disk output
	  if	eq
	   movd	dc_sdir+usr_exe,r5 ;Search directory
	   save	[r6]
	   addqw 1,r6		;Advance to input device
	   mac_svc
	   cmpqd 0,r6		;Found if EQ
	   restore [r6]
	   if	eq
	    movd dc_open+usr_exe,r5 ;Open existing file
	    mac_svc
	   else
	    movd dc_make,r5	;Create new file
	    movw usr_exe,r4	;File type
	    mac_svc
	   endif
	  else			;Not disk file
	   mac_svc
	   movqd 0,r6		;Always OK here
	  endif
	 endif
	 bicpsrb flag_f		;Assume OK
	 cmpqd	0,r6
	 if	ne
	  bispsrb flag_f
	 endif
	celse
	 orw	dof_cmd lsh b_iosrv,r6
	 movd	dc_open,r5
	 mac_svc
	 bicpsrb flag_f		;OK
	cend
	restore	[r4,r5,r6]
	ret

	disp	1

;Send close command to device in R6:D (bits 0-7)

dev_clos::
	movd	r5,tos
	movd	dc_close+exp dc_cltrk,r5 ;Close and truncate a disk file
	bsr	sys_cmd
	movd	tos,r5
	ret


dev_binon::
	movd	r5,tos
	movd	dc_binon,r5	;Binary type on
	bsr	sys_cmd
	movd	tos,r5
	ret


dev_binoff::
	movd	r5,tos
	movd	dc_binoff,r5	;Binary type off
	bsr	sys_cmd
	movd	tos,r5
	ret


dev_binget::
	mac_cmd	dc_binget	;Return current binary selection


;Set default filename
;R0/R1 holds name, R5 holds attributes

dev_fname:
	save	[r4,r5,r6]
	movd	dev_m1+dof_cmd lsh b_iosrv,r6
	movd	r5,r4		;Save attributes
	movd	dc_instnc,r5	;Set file name
	mac_svc
	restore	[r4,r5,r6]
	ret


;Send on command to device in R6:D (bits 0-7)

dev_on::
	movd	r5,tos
	movd	dc_on,r5
	bsr	sys_cmd
	movd	tos,r5
	ret


;Send off command to device in R6:D (bits 0-7)

dev_off::
	movd	r5,tos
	movd	dc_off,r5
	bsr	sys_cmd
	movd	tos,r5
	ret


;Set new device routing
;R0:D=device to change, R1:D=device to route to

dev_rte::
	save	[r5,r6]
	movd	dc_vct,r5	;Assume routing to new device
	cmpb	r0,r1		;Un-routing if eq
	if	eq
	 movd	dc_unvct,r5
	endif
	movb	r1,r5		;New index passed here
	movd	dof_cmd lsh b_iosrv,r6
	movb	r0,r6		;Old index passed here
	mac_svc
	restore	[r5,r6]
	ret


;Set baud rate in R5, device in R6:D (bits 0-7)

set_baud::
	save	[r0,r4,r5,r6]
	movd	r5,r4		;SVC needs baud rate here
	orw	dof_cmd lsh b_iosrv,r6
	movd	dc_baud,r5
	mac_svc
	restore	[r0,r4,r5,r6]
	ret

;Input line from system keyboard device
;R1=>buffer, R0 holds max length

lin_ins:
	cmpqw	-1,r0		;OK if infinite length
	if	ne
	 addqw	-1,r0		;Leave room for termination character
	endif
	save	[r6]
	movd	(dev_smk+1)+dof_blk lsh b_iosrv,r6
	movd	cr,r5		;Termination character

;Wait for CR, echo all, editing commands enabled

	ord	exp bkb_ekt+exp bkb_eko+exp bkb_tr5+exp bkb_edt,r0
	mac_svc
	restore	[r6]
	ret


;Send CR to console, don't alter anything

do_cr::	sprb	upsr,tos
	save	[r5]
	movb	cr,r5
	bsr	char_tx
	movb	lf,r5
	bsr	char_tx
	restore	[r5]
	lprb	upsr,tos
	ret


;Display string on stack until H'0

dsp_msg::
	save	[r0,r1,r5,r6]

	movd	16(sp),r1
	movzbd	tx_dev,r6
	orw	dof_blk lsh b_iosrv,r6
	movd	exp bkb_tr5,r0 ;Terminator in R5
	movqd	0,r5
	mac_svc
	movd	r1,16(sp)

	restore	[r0,r1,r5,r6]
	ret


;Pause: space key = continue, "X" = abort now
;FS if ESC, FC otherwise

pause::	save	[r5]
	bsr	dsp_msg
	byte	'Press space to continue, "X" to abort ',0

	until	eq
	 bsr	char_rx		;Get a character in R5
	 cmpb	" ",r5
	 bicpsrb flag_f		;Flag clear if space
	 if	ne
	  cmpb	"X",r5		;Check for "X"
	  bispsrb flag_f	;Flag set if "X"
	  if	ne
	   cmpb	"x",r5		;This aborts too
	  endif
	 endif
	endif

	bsr	do_cr		;Send CR, no flags altered
	restore [r5]
	ret


;Display any 2(R5) according to (R5) and temporary M_RADIX on stack
;R0/R1 holds index,buffer if not displaying

dsp_2r5::
	lproc
radx:	ds	2
	reg	[r4]
	code

	movd	2+4(r5),tos
	movd	2(r5),tos
	tbitb	b_def,(r5)
	if	fs
	 extsb	1(r5),tos,b_size-8,4 ;Type
	else
	 movb	h'f,tos		;Undefined type
	endif
	movb	m_rpad,tos
	movb	m_rfld,tos
	movw	radx,tos
	addr	char_tx,r4
	bsr	num_tos:d

	pend


;R1 points to terminated string
;R4 holds terminator
;Convert to pointer in R1, length in R0
;Length does not include terminator

strx_len::
	save	[r1]

	movqd	-1,r0
	skpsb	u		;Find terminator

;Complement of remaining count is length

	comd	r0,r0

	restore	[r1]
	ret	0


;R1 points to 0 terminated string
;Convert using STRX_LEN

str0_len::
	save	[r4]
	movqb	0,r4
	bsr	strx_len
	restore	[r4]
	ret	0

;Output string in R1, length in R0
;On exit, R1 points to next byte, R0 = 0

str_out::
	save	[r6]
	movzbd	tx_dev,r6
	orw	dof_blk lsh b_iosrv,r6
	sbitb	bkb_cnt,r0	;Terminate on count
	mac_svc
	restore	[r6]
	movqd	0,r0
	ret


;Display via NUM4_TOS
;Stack holds radix:w and integer:D

dsp_tos::
	lproc
radx:	blkw			;Radix to use
int:	blkd			;Integer to display
	reg	[r4]
	code
	movd	int,tos
	movb	m_rpad,tos	;Padding character
	movb	m_rfld,tos	;Field size
	movw	radx,tos
	addr	char_tx,r4	;Display routine
	bsr	num4_tos:d
	pend


;Convert hex digits in R5 to value in LSB of R5
;FS if conversion error

hex_dig::
	subb	"0",r5
	cmpb	9,r5
	bicpsrb	flag_f		;Clear F
	bhs	return

;Greater than 9, original value must have been "A"-"F"

	subb	7,r5		;F is clear
	cmpb	h'f,r5
	blo	hexdigx		;Invalid digit if result > FH
	cmpb	h'a,r5
	bls	return		;Keeper if A-F
hexdigx::
	bispsrb	flag_f		;Error
	ret	0


;Convert 2 ASCII characters in (R1) to hex digits in LSB of R5
;R1 incremented if success, FS if error and R1 not advanced

hex2dig::
	movb	0(r1),r5
	bsr	hex_dig
	bfs	return
	addqd	1,r1		;Advance to next digit
	lshb	4,r5		;Move digit to upper nibble
	movb	r5,tos
	movb	0(r1),r5
	bsr	hex_dig
	orb	tos,r5		;Complete number in R5
	bfs	return
	addqd	1,r1
	bicpsrb	flag_f
	ret	0


;Convert 4 ASCII characters in (R1) to word in R5
;R1 incremented and FC if success, FS and R1 points to error if any

hex4dig::
	bsr	hex2dig
	bfs	return
	lshw	8,r5		;LSB to MSB of word
	br	hex2dig


;Display value in R5, signed, leading 0s suppressed

dsp_r5::
	movw	m_radix,tos	;Radix
	andw	exp b_sign+h'1f,(sp) ;Just keep sign and radix
	movd	r5,tos
	bsr	dsp_tos

	ret

;Concatenate hex value in R5 to string in R1, R0 = length
;Stack holds number of digits

r5_asc::
	lproc
dig:	blkb	1
	reg	[r2,r3,r4,r5,r6]
	code

	movd	r5,tos
	movb	"0",tos		;Padding character
	movb	dig,tos		;Field size
	movw	16+exp b_fld+exp b_buf,tos ;Hex, pad with 0s, (R1) buffer
	addr	char_tx,r4	;Display routine
	bsr	num4_tos:d
	pend


;Concatenate LSB of R5 to string in R1 as 2 unsigned hex digits

byt_1r5::
	save	[r5]
	andd	h'ff,r5
	movqb	2,tos		;Number of digits
	bsr	r5_asc		;Convert to ASCII string
	restore	[r5]
	ret

;Concatenate LSW of R5 to string in R1 as 4 unsigned hex digits

byt_2r5::
	save	[r5]
	andd	h'ffff,r5
	movqb	4,tos		;Number of digits to use
	bsr	r5_asc		;Convert to ASCII string
	restore	[r5]
	ret

;Concatenate 3 LSBs of R5 to string in R1 as 6 unsigned hex digits

byt_3r5::
	save	[r5]
	andd	h'ffffff,r5
	movqb	6,tos		;Number of digits to use
	bsr	r5_asc		;Convert to ASCII string
	restore	[r5]
	ret

;Concatenate R5 to string in R1 as 8 unsigned hex digits

byt_4r5::
	movb	8,tos		;Number of digits
	bsr	r5_asc
	ret

lead0sub::

;If only 1 character in string, nothing to do

	cmpqb	1,r0
	bhs	return

	save	[r1,r2,r4]
	movd	r1,r2		;Save beginning of string
	addqd	-1,r0		;Always keep last 0

	movb	"0",r4
	skpsb	w

;R0 holds remaining length-1

	addqb	1,r0		;Always keep last character in string

;R0 is remaining length
;R1 points to 1st character to keep
;R2 points to beginning of string

	save	[r0]
	movsb
	restore	[r0]

	restore	[r1,r2,r4]
	ret	0


;Remove leading 0s from string in R1, R0 holds length
;If 1st character is "-", that is skipped

lead0::
	cmpqd	0,r0
	beq	return

	cmpb	"-",0(r1)
	bne	lead0sub

;This is negative, bypass "-"

	addqd	1,r1
	addqd	-1,r0
	bsr	lead0sub
	addqd	1,r0		;Inc length for "-"
	addqd	-1,r1		;Backup to real beginning
	ret	0


;Display R5 as signed hex value in (R1)
;Radix included as appropriate

ascii::	movw	m_radix,tos	;Radix
	andw	exp b_sign+h'1f,(sp) ;Just keep sign and radix
	orw	exp b_buf+exp b_rdx,(sp) ;R0/R1 buffer, display radix
	movd	r5,tos
	bsr	dsp_tos
	ret


;Force signed display of value in R5 to (R1)
;Also display radix

sgn_asci::
	movw	m_radix,tos	;Radix
	andw	h'1f,(sp)	;Just keep radix
	orw	exp b_sign+exp b_buf+exp b_rdx,(sp) ;R0/R1 buffer, sign, radix
	movd	r5,tos
	bsr	dsp_tos
	ret

;Force unsigned display of value in R5 to (R1)
;Also display radix

pos_asci::
	movw	m_radix,tos	;Radix
	andw	h'1f,(sp)	;Just keep radix
	orw	exp b_buf+exp b_rdx,(sp) ;R0/R1 buffer, radix
	movd	r5,tos
	bsr	dsp_tos
	ret


;Display signed (+/-) offset in (R4) to R1, return value in R5
;Also display radix

sgn_asc::
	bsr	r4_disp		;Get offset in R5

	movw	m_radix,tos	;Radix
	andw	h'1f,(sp)	;Just keep radix
	orw	exp b_pls+exp b_sign+exp b_buf+exp b_rdx,(sp) ;Buf,+/-, radix
	movd	r5,tos
	bsr	dsp_tos
	ret


;Convert value in R5 to signed string in R1
;R0 holds length

sgn_str::
put_r5::
	movw	m_radix,tos	;Radix
	andw	exp b_sign+h'1f,(sp) ;Just keep sign and radix
	sbitb	b_buf,(sp)	;R0/R1 buffer
	movd	r5,tos
	bsr	dsp_tos

	ret


;Put value in R5 into R1 string according to M_RADIX
;Number is always positive, leading 0s suppressed

pos_r5::
	movw	m_radix,tos
	cbitb	b_sign,m_radix
	bsr	put_r5
	movw	tos,m_radix
	ret


;Put value in R5 into R1 string according to M_RADIX
;Number is always signed, leading 0s suppressed

sgn_r5::
	movw	m_radix,tos
	sbitb	b_sign,m_radix
	bsr	put_r5
	movw	tos,m_radix
	ret


;TOS holds integer, display according to M_RADIX
;R0/R1 holds index,buffer if not displaying

fmt_tos::
	lproc
int:	ds	4
	reg	[]
	code
	movw	m_radix,tos
	movd	int,tos
	bsr	dsp_tos		;Display according to M_RADIX passed on stack
	pend


;Display 2(R5) according to (R5) and M_RADIX
;R0/R1 holds index,buffer if not displaying

fmt_2r5::
	movw	m_radix,tos
	bsr	dsp_2r5		;Pass temporary radix on stack
	ret


;Display character in R5 as ASCII with attributes

dsp_asc::
	save	[r4]
	movzbd	r5,tos		;Just LSB
	movqw	0,tos		;Padding character, field size
	movw	exp b_asc,tos	;ASCII display
	addr	char_tx,r4	;Display routine
	bsr	num4_tos:d
	restore	[r4]
	ret


;Put ASCII character in R5 into string in R1, length in R0
;Values < 20H are dim
;Values > 7FH are inverse

put_asc::
	save	[r4]
	movzbd	r5,tos		;Just LSB
	movqw	0,tos		;Padding character, field size
	movw	exp b_asc+exp b_buf,tos	;ASCII display, (R1) buffer
	addr	char_tx,r4	;Display routine
	bsr	num4_tos:d
	restore	[r4]
	ret

	disp	2

;End of CON32
