	print	"CSB32"

{
common sb storage
this must be the first sb storage in mon32 and
svc32 if the full operating system is used
}

	mode	sb,0		;Start again from 0 if separate SB

sb_beg:				;Define start of SB area

;Pass counter 1, 2, I=Immediate, L=Link
m_pass:	blkb			;Pass counter
m_errct: blkd
max_err: blkb	4		;Max errors before aborting assembly
tx_dev:	blkb			;Device code for I/O

;Math stack:
;Each entry is 2 status bytes and 4 operand bytes
;Strings and floats require 2 entries each
math_ptr: blkb	4		;Index to next available entry
math_siz equ	40*(2+4)	;40 entries on stack
math_stk: blkb	math_siz	;Actual storage
m_radix: .blkb	2		;Default radix for number conversion
				;Bits 0-4 holds actual radix
m_rfld:	blkb			;Field size
m_rpad:	blkb			;Padding character for field
m_rdig:	blkb			;Digit count for display

;These 4 locations must be consecutive and in this order
m_fpptr: .blkb	4		;Current FP base pointer
m_spptr: .blkb	4		;Current SP base pointer
m_sbptr: .blkb	4		;Current SB pointer
m_pcptr: .blkb	4		;PC at beginning of opcode
m_imptr: blkd			;Immediate mode pseudo-pointer
m_imdptr: blkd			;Immediate mode decrementing pointer

m_pcofst: blkd			;Program counter offset
m_fpofst: blkd			;Frame pointer offset
t_symfp: blkd			;Index to local FP symbols
t_symlnk: blkd			;Index to link symbols

mod_max	equ	40		;Max number of modules that can be loaded
mod_indx: blkd			;Number of entries in MOD_TBL
lmod:	blkd			;Current module number
{
internal mod table format:
code size:d, sb size:d
offset to 1st link table entries:w
offset of 1st symbol in this module:sidx_of, offset of module name:sidx_of
current m_pcofst address of code as assembled in memory:d
pc address:d, sb address:d, mod address:d, link table address:d
}
mod_tsiz equ	4+4+2+2*sidx_of+4+4+4+4+4
mod_tabl: ds	mod_max*mod_tsiz
m_stksiz: blkd	2		;Size of SP block, last address of block
				;Size=-1 => undefined; Address=0 => relocatable

m_string: blkb	4		;String storage base address
m_strptr: blkb	4		;String storage current top

t_cxp:	blkd			;CXP/EXT link table data beginning
t_cxpx:	blkd			;End of CXP table

m_xrf:	blkd			;Base address of XREF data
m_xrfptr: blkb	4		;Pointer to start of current XREF field
m_xrflin: blkd			;Pointer to current XREF field

m_lnkptr: blkb	4		;Pointer to next link entry
m_link:	blkb	4		;Beginning of link buffer
m_linkm: blkd			;Start of current module's link data
lnk_prm: blkb			;Linker parameters
				;Bit 0 set if undefined symbols external
				;Bit 1 set if all general symbols included
				;Bit 2 set if all one big module
t_symbl: blkb	4		;Pointer to start of symbol table
tsym_end: blkb	4		;Pointer to next byte for symbol table
t_symalf: blkb	sidx_of*13*("Z"-"A"+1) ;Word index for A-Z symbols
				;13 indeces per word, by 2nd letter
m_symadr: blkd			;Address of last address mode symbol
msym_beg: blkd			;Start of current module's symbols (offset)
msym_end: blkd			;Address of end of current module's symbols

mem_siz: blkd			;Last address for symbol table (SB size)

m_delim: blkd			;Address of T_DELIM table (NSC or Kotekan)
m_delim2: blkd			;Address of T_DELIM2

	mode	pc

;End of CSB32
