	print	"DAT32"

{
routines common to operating system and debugger/assembler/linker
  includes routines needed for loading files
}

return:	ret

;Return next available address in link symbol table on stack

last_lnk:
	lproc
buf:	ds	4		;Return address here
	reg	[r3,r5]
	code

	addr	t_symlnk,r3
	begin
	 extsd	(r3),r5,0,sidx_bit
	 cmpd	sidx_end,r5
	while	ne		;Find last entry
	 movd	r5,r3
	 addd	t_symbl,r3
	endw
	movd	r3,buf
	pend	0


;Math op priority table
;Same order as above values, assigns precedence for algebraic notation
;Highest number has highest priority

	db	0		;EX_ALG uses code+1 as index
t_opordr::
	db	1,1,1,1		;Stack
	db	2,2,2,2,2,2,2,2,2,2 ;Comparisons
	db	3,3,3,3,3,3	;logical
	db	5,5,4,4,5,5	;Arithmetic
	db	6,6,6,6,6	;Shifts
	db	7,7,7,7,7,7,7,7 ;One parameter
	db	7,7,7,7		;Module addresses

;Table of addressing modes for each of 16 B_SIZE designators
;Table entry AND 0FH = addressing mode
;4 = integer, 14H = float, 0C = string, 0F = invalid

t_type::
	db	4,4,4,4,14h,14h,14h,0fh,0ch,0fh,0fh,0fh,4,4,4,0fh

;R0 holds op code + 1, do operation
;Just return if R0=0, error if R0 out of range

do_math::
	cmpqd	0,r0
	beq	return
	cmpb	mth_mop+1,r0
	blo	bad_txt:d

	proc
	reg	[r0,r1,r2,r3,r4,r5,r6]
buf1:	ds	2+10		;Working memory for 1st parameter
buf2:	ds	2+10		;Working memory for 2nd parameter
	code

	addqd	-1,r0		;Actual op number
	addr	buf1,r5
	addr	buf2,r6

	movd	math_ptr,r1	;Stack index
	addr	math_stk,r2	;Base pointer

	cmpb	mth_sop,r0	;Highest stack operator
	if	hs		;Just do it if stack operator
	 bsr	do_mth1
	else			;Must be at least one entry on stack
	 bsr	math_pop	;Get 1st parameter in R5
	 extsd	1(r5),r3,b_size-8,4 ;Type for top stack entry
	 movb	t_type[r3:b],r3
	 cmpb	mth_1prm,r0
	 if	ls		;1 parameter operator if LS
	  tbitb b_def,(r5)	;Must be defined
	  if	fs
	   cmpqb 4,r3		;Set flags according to integer type
	   bsr	do_mth1
	  endif
	 else			;2 parameters required
	  movd 	r5,r6		;1st parameter to R6
	  addr	buf2,r5		;Buffer for 2nd parameter
	  bsr	math_pop
	  extsd	1(r5),r4,b_size-8,4 ;Type for 2nd stack entry
	  movb	t_type[r4:b],r4
	  tbitb b_def,(r5)	;Must be defined
	  if	fs
	   tbitb b_def,(r6)
	   if	fs
	    cmpb r3,r4
	    if	ne
	     cmpqb 4,r4		;At least one must be integer
	     if eq
	      cmpb 14h,r3	;This may be a float
	      if eq
	       movdl 2(r5),2(r5)
	       movb h'64,b_mode/8:#(r5)
	       movb h'14,r4	;Make float
	      else
	       cmpb h'c,r3	;May be string
	       if eq
	        cmpqw 4,2(r6)	;No more than 4 characters
	        if hs
	         save [r0,r1,r6]
	         movb 2(r6),r0	;Length of string
	         movd 2+2(r6),r1 ;Pointer to string
	         movqd 0,2(r6)	;Must be 0 extended
	         begin
	          cmpqb 0,r0
	         while ne
	          movb (r1),2(r6)
	          addqd 1,r1
	          addqd 1,r6
	          addqb -1,r0
	         endw
	         restore [r0,r1,r6]
	         movb h'24,b_mode/8:#(r6)
	         movqb 4,r3	;Make integer
	        endif
	       endif
	      endif
	     else
	      cmpqb 4,r3	;This must be integer
	      if eq
	       cmpb 14h,r4	;Check for float and int
	       if eq
	        movdl 2(r6),2(r6)
	        movb h'64,b_mode/8:#(r6)
	        movb h'14,r3	;Make float
	       else
	        cmpb h'c,r4	;May be string
	        if eq
	         cmpqw 4,2(r5)	;No more than 4 characters
	         if hs
	          save [r0,r1,r5]
	          movb 2(r5),r0	;Length of string
	          movd 2+2(r5),r1 ;Pointer to string
	          movqd 0,2(r5)	;Must be 0 extended
	          begin
	           cmpqb 0,r0
	          while ne
	           movb (r1),2(r5)
	           addqd 1,r1
	           addqd 1,r5
	           addqb -1,r0
	          endw
	          restore [r0,r1,r5]
	          movb h'24,b_mode/8:#(r5)
	          movqb 4,r4	;Make integer
	         endif
	        endif
	       endif
	      endif
	     endif
	    endif
	    cmpb r3,r4		;Set EQ if both same type
	    bsr do_mth1		;Ready for actual math now
	   endif
	  endif
	  
;Adjust status of R5 before PUSHing
	  
	  movb	(r6),r3
	  orb	com (exp b_def):#b,r3 ;All but defined flag must be set
	  andb	r3,(r5)		;AND defined bits of two parameters
	  extsb	1(r6),r3,b_mode-8,4
	  cmpqb	4,r3		;If source is constant, leave dest. as is
	  if	ne		;Source not constant
	   extsb 1(r5),r4,b_mode-8,4
	   cmpqb 4,r4
	   if	eq
	    movb 1(r6),1(r5)	;If dest. is constant use source mode
	   else
	    movb h'24,1(r5)	;If neither is constant then make constant
	   endif
	  endif
	  extsb (r6),r3,b_typ,2
	  cmpqb	lbl_ext,r3	;If source is external then dest. is too
	  if	eq
	   inssb lbl_ext,(r5),b_typ,2
	  endif
	 endif
	 bsr	math_psh	;Put result back on stack
	endif

	pend
	ret

;1 parameter operators: R5 holds parameter, R3 holds type
;2 parameter operators: R6=source, R3=type; R5=dest, R4=type

do_mth1::
	casew	t_domath[r0:w]

t_domath:
	word	math_swp-do_mth1
	word	math_pik-do_mth1
	word	math_drp-do_mth1
	word	math_dup-do_mth1

	word	math_gt-do_mth1
	word	math_lt-do_mth1
	word	math_ge-do_mth1
	word	math_le-do_mth1
	word	math_hi-do_mth1
	word	math_lo-do_mth1
	word	math_hs-do_mth1
	word	math_ls-do_mth1
	word	math_eq-do_mth1
	word	math_ne-do_mth1

	word	math_xor-do_mth1
	word	math_xor-do_mth1
	word	math_or-do_mth1
	word	math_or-do_mth1
	word	math_and-do_mth1
	word	math_and-do_mth1

	word	math_mod-do_mth1
	word	math_mod-do_mth1
	word	math_add-do_mth1
	word	math_sub-do_mth1
	word	math_mlt-do_mth1
	word	math_div-do_mth1

	word	math_lshr-do_mth1
	word	math_lsh-do_mth1
	word	math_lsh-do_mth1
	word	math_rot-do_mth1
	word	math_ash-do_mth1

	word	math_len-do_mth1
	word	math_abs-do_mth1
	word	math_neg-do_mth1
	word	math_not-do_mth1
	word	math_exp-do_mth1
	word	math_log-do_mth1
	word	math_com-do_mth1
	word	math_com-do_mth1

	word	math_pca-do_mth1
	word	math_sba-do_mth1
	word	math_mda-do_mth1
	word	math_lna-do_mth1

stk_drp::
	save	[r0]
	movqd	mop_drp+1,r0
	bsr	do_math
	restore	[r0]
	ret	0

math_drp::
	br	math_pop

stk_dup::
	save	[r0]
	movqd	mop_dup+1,r0
	bsr	do_math
	restore	[r0]
	ret	0

math_dup::
	bsr	math_pop
	bsr	math_psh
	br	math_psh

stk_swp::
	save	[r0]
	movqd	mop_swp+1,r0
	bsr	do_math
	restore	[r0]
	ret	0

;Swap 2 top stack entries

math_swp::
	bsr	math_pop
	movd	r5,tos
	movd	r6,r5		;Address of 2nd buffer
	bsr	math_pop
	movd	r5,r6
	movd	tos,r5
	bsr	math_psh
	movd	r6,r5
	br	math_psh


stk_pik::
	save	[r0]
	movqd	mop_pik+1,r0
	bsr	do_math
	restore	[r0]
	ret	0


;First value on stack is index to value to copy, replacing index
;0 copies entry below index, 1 copies next, etc.
;0 PICK is identical to DUP

math_pik::
	bsr	math_pop	;Get index in 2(R5)
	tbitb	b_def,(r5)
	if	fc
	 bsr	type_err
	else
	 extsb	1(r5),r3,b_size-8,4 ;Must be integer
	 cmpqb	3,r3
	orif	lo		;Error if non-integer
	 movd	math_ptr,r3	;Index to current entry
	 addr	math_stk,r6	;Base address
	 addr	-6(r6)[r3:b],r3	;Pointer to top entry
	 begin
	  cmpqd	0,2(r5)		;See if selected entry reached yet
	 while	ne
	  extsd	1(r3),r4,b_size-8,4 ;Variable type
	  cmpb	14h,t_type[r4:b]
	  if	eq
	   addqd -6,r3		;Two entries used for float
	  else
	   cmpb	0ch,t_type[r4:b]
	  orif	eq
	  endif
	  cmpd	r3,r6
	 quit	lo		;Must still point to valid entry
	  addqd	-6,r3		;Backup to previous entry
	  addqd	-1,2(r5)
	 endw
	 cmpd	r3,r6		;Must still in range
	orif	lo
	 extsd	1(r3),r4,b_size-8,4 ;See what kind of entry this is
	 cmpb	14h,t_type[r4:b]
	 if	eq
	  movmw	(r3),(r5),3	;LS part with ID is first on stack
	  movd	-6(r3),6(r5)	;MS portion last
	 else
	  cmpb	0ch,t_type[r4:b]
	 orif	eq
	  movmw	(r3),(r5),3	;Copy single entry parameter
	 endif
	endif
	br	math_psh	;Push new entry


math_add::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	if	eq
	 addd	2(r6),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 addl	2(r6),2(r5)
	endif
	ret

math_sub::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	if	eq
	 subd	2(r6),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 subl	2(r6),2(r5)
	endif
	ret

math_mlt::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	if	eq
	 muld	2(r6),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 mull	2(r6),2(r5)
	endif
	ret

math_div::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	if	eq
	 divd	2(r6),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 divl	2(r6),2(r5)
	endif
	ret

math_mod::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	modd	2(r6),2(r5)
	ret

math_ash::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	ashd	2(r6),2(r5)
	ret

math_rot::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	rotd	2(r6),2(r5)
	ret

math_lshr::
	negd	2(r6),2(r6)	;Right shift by positive value in (R6)
math_lsh::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	lshd	2(r6),2(r5)
	ret

math_and::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	andd	2(r6),2(r5)
	ret

math_or::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	ord	2(r6),2(r5)
	ret

math_xor::
	bne	typ_er1		;Both types must match
	cmpqb	4,r3		;Check for integer first
	bne	typ_er1
	xord	2(r6),2(r5)
	ret

math_abs::
	cmpqb	4,r3		;Check for integer first
	if	eq
	 absd	2(r5),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 absl	2(r5),2(r5)
	endif
	ret

math_neg::
	cmpqb	4,r3		;Check for integer first
	if	eq
	 negd	2(r5),2(r5)
	else
	 cmpb	14h,r3		;Check for float
	 bne	typ_er1
	 negl	2(r5),2(r5)
	endif
	ret


math_not::
	bne	typ_er1		;Must be integer type
	notd	2(r5),2(r5)
	ret

math_com::
	bne	typ_er1		;Must be integer type
	comd	2(r5),2(r5)
	ret

;Raise 1 to power on stack, base 2

math_exp::
	bne	typ_er1		;Must both be ingeters
	cmpqb	4,r3
	bne	typ_er1		;Must be integer
	movd	2(r5),r6	;Rotation count
	movqb	1,2(r5)
	lshd	r6,2(r5)
	ret

;Return LOG base 2 of most significant bit on stack

math_log::
	bne	typ_er1		;Must both be ingeters
	cmpqb	4,r3
	bne	typ_er1		;Must be integer
	movd	2(r5),r6	;Value to get log of
	movzbd	h'1f,2(r5)	;Initial log

;Rotate 2(R5) until carry set or LOG becomes -1

	until	gt		;Until log becomes -1
	 addd	r6,r6
	quit	cs		;Got a keeper if CS
	 addqd	-1,2(r5)
	 cmpqd	0,2(r5)
	endu
	ret

;Return length of string

math_len::
	cmpb	0ch,r3
	bne	typ_er1		;Must be string
	movzwd	2(r5),2(r5)
	movw	exp b_def+(h'24 lsh b_mode),(r5) ;Return a constant
	ret

math_pca::
math_sba::
math_mda::
math_lna::
	bne	typ_er1		;Must be integer type
	movd	2(r5),r6	;Module number
	cmpd	mod_max,r6
	bls	typ_er1
	muld	mod_tsiz,r6	;Offset to proper module's data
	addd	4+4+2+2*sidx_of+4,r6 ;Base of PC/SB/MOD/LINK data

	save	[r0]
	subb	mop_0ad,r0	;Convert to index
	lshb	2,r0		;Multiply by 4
	addd	r0,r6		;Complete index now in R6
	movd	mod_tabl[r6:b],2(r5) ;Fetch value
	restore	[r0]
	cmpqd	-1,2(r5)	;This is undefined
	if	eq
	 cbitb	b_def,(r5)
	 addqd	1,m_errct
	 bsr	dsp_msg:d
	 db	"Undefined PC/SB/MOD base address",cr,lf,0
	endif
	ret

math_gt::
	bsr	math_cmp	;Compare R5,R6
	sgtd	2(r5)
	ret

math_lt::
	bsr	math_cmp	;Compare R5,R6
	sltd	2(r5)
	ret

math_ge::
	bsr	math_cmp	;Compare R5,R6
	sged	2(r5)
	ret

math_le::
	bsr	math_cmp	;Compare R5,R6
	sled	2(r5)
	ret

math_hi::
	cmpb	14h,r3		;Can't be float here
	beq	typ_er1
	bsr	math_cmp	;Compare R5,R6
	shid	2(r5)
	ret

math_lo::
	cmpb	14h,r3		;Can't be float here
	beq	typ_er1
	bsr	math_cmp	;Compare R5,R6
	slod	2(r5)
	ret

math_hs::
	cmpb	14h,r3		;Can't be float here
	beq	typ_er1
	bsr	math_cmp	;Compare R5,R6
	shsd	2(r5)
	ret

math_ls::
	cmpb	14h,r3		;Can't be float here
	beq	typ_er1
	bsr	math_cmp	;Compare R5,R6
	slsd	2(r5)
	ret

math_eq::
	bsr	math_cmp	;Compare R5,R6
	seqd	2(r5)
	ret

math_ne::
	bsr	math_cmp	;Compare R5,R6
	sned	2(r5)
	ret

;Compare integers, floats or strings in (R5) and (R6)

math_cmp::
	bne	typ_er1		;Both types must match
	movw	exp b_def+(h'c4 lsh b_mode),(r5) ;Make it boolean
	cmpqb	4,r3		;Check for integer 1st
	if	eq
	 cmpd	2(r5),2(r6)
	else
	 cmpb	14h,r3		;Check for float
	 if	eq
	  cmpl	2(r5),2(r6)
	 else
	  cmpb	0ch,r3		;Try string now
	  if	eq
	   save	[r0,r1,r2,r3,r4]
	   movw exp b_def+(h'c4 lsh b_mode),(r5) ;Return boolean in (R5)
	   movw exp b_def+(h'c4 lsh b_mode),(r6) ;Modes must match
	   movzwd 2(r5),r3	;Length of destination string
	   movzwd 2(r6),r4	;Length of source string
	   movd	4(r5),r1	;Dest string
	   movd	4(r6),r2	;Source string
	   movd	r3,r0		;Try dest length 1st
	   cmpd	r3,r4
	   if	eq
	    cmpsb		;Straight compare if equal lengths
	   else
	    cmpd r3,r4
	    if	ls
	     cmpsb
	     if	eq		;Can't be EQ because R5 shorter
	      bicpsrb flag_z	;NE, R5 LT R6
	     endif
	    else
	     movd r4,r0		;Use shorter length
	     cmpsb
	     if	eq		;Can't be EQ because R6 shorter
	      bicpsrb flag_z
	      bispsrb h'84	;NE, R5 GT R6
	     endif
	    endif
	   endif
	   restore [r0,r1,r2,r3,r4]
	  else
	   bsr	typ_er1		;Anything else is no good
	  endif
	 endif
	endif
	ret

;See if (R1) is a number
;IS_NUM checks for leading B', D', F', H', L', O', Q', X' or digit
;IS_NUM1 checks for leading digit only
;FS on exit if not

	disp	1

is_num::
	cmpb	"'",1(r1)	;Check for radix designator
	if	eq
	 cmpb	"B",(r1)	;Binary radix
	 if	eq
	  bicpsrb flag_f	;Assume true for now
	  ret
	 else
	  cmpb	"D",(r1)	;Decimal radix
	 orif	eq
	  cmpb	"H",(r1)	;Hex radix
	 orif	eq
	  cmpb	"O",(r1)	;Octal
	 orif	eq
	  cmpb	"Q",(r1)	;Octal
	 orif	eq
	  cmpb	"X",(r1)	;Another hex
	 orif	eq
	  bispsrb flag_f
	  ret
	 endif
	endif
is_num1::
	bispsrb flag_f		;Assume false for now
	cmpb	"0",(r1)
	if	ls		;Can't be digit if HI
	 cmpb	"9",(r1)
	 if	hs		;Valid only if 0-9
	  bicpsrb flag_f	;Got a keeper for sure
	 endif
	endif
	ret

	disp	2

;Convert ASCII number in (R1), length in R0, to binary value on stack
;SP+2: Returned number (8 bytes integer, float or 64 bit integer)
;SP+1: Type (MSIZE attributes, 0F if undefined)
;SP+0: Radix
;Check until invalid character found
;Above values updated and returned by routine

dig_cnvt::
	lproc
num:	ds	8		;Actual storage for returned value
type:	blkb			;Default type, updated on exit
radx:	blkb			;Default radix, updated on exit
	reg	[r2,r3,r4,r5,r6,r7]
fpr0:	blkd 			;Original R0
fpr1:	blkd 			;Original R1
	code

	movd	r1,tos		;Must be restore at end
	movd	r0,tos		;Needed at end

	movzbd	h'f,r2		;Largest acceptable digit
	movb	r2,type		;Undefined for now
	movqd	0,r3		;Largest digit starts at 0
	movzbd	radx,r4		;Default radix

	cmpb	"+",(r1)
	if	eq
	 cmpqd	1,r0
	 if	ls
	  addqd	1,r1
	  addqd	-1,r0
	 endif
	else
	 cmpb	"-",(r1)
	 if	eq
	  cmpqd	1,r0
	  if	ls
	   addqd 1,r1
	   addqd -1,r0
	   sbitb 7,radx
	  endif
	 endif
	endif

	movd	r0,fpr0		;Save original
	movd	r1,fpr1		;Save this too
	cmpb	"'",1(r1)	;Check for radix specification
	if	ne
	 cmpb	"0",(r1)
	 if	ne
	  movd	r0,r5		;R5 is old R0 before conversion
	  bsr	dig_cnvs	;Just convert now to value in R6R7
	  cmpqd	0,r0		;See if line exhausted
	  if	eq
	   cmpb	"B",-1(r1)	;Possible binary if ending B
	   if	ne
	    cmpb r3,r4		;See if largest digit > radix
	    if	hi
	     cmpb 10,r3
	     if	hi
	      movb 10,r4	;Make decimal if that is enough
	      movb 9,r2
	     else
	      movb 16,r4	;Hex always works
	      movb 0f,r2
	     endif
	     movd fpr0,r0
	     movd fpr1,r1
	     movd r0,r5
	     bsr dig_cnvs	;Re-convert
	    endif
	   else			;See if all digits are 0 or 1
	    cmpb 10,r4
	   orif	lo		;Can't be binary if radix > 10
	    save [r0]
	    addqd 1,r0
	    cmpd r0,fpr0	;Can't be binary if only one character
	    restore [r0]
	   orif	eq
	    save [r3,r4,r6,r7]	;Save current values
	    movd r1,tos
	    movd r0,tos
	    movqd 2,r4		;Binary radix
	    movqd 1,r2		;Largest digit
	    movd fpr0,r0
	    movd fpr1,r1
	    bsr	dig_cnvs
	    addqd -1,r0		;Last B not converted
	    cmpd r0,(sp)	;See if length is same this way
	    movd tos,r0
	    movd tos,r1
	    if	eq
	     adjspb -4*4	;Disregard old values if binary
	    else
	     restore [r3,r4,r6,r7] ;Restore old values if not binary
	    endif
	   orif	ne		;Not binary if NE
	   endif
	  else
	   cmpb	"H",(r1)	;See if hex requested
	   if	eq
	    movb 16,r4		;Re-evaluate string as hex
	    movd fpr0,r0
	    movd fpr1,r1		;Back to beginning
	    movd r0,r5
	    bsr	dig_cnvs
	    addqd 1,r1
	    addqd -1,r0		;Skip trailing "H"
	    addqd -1,r5		;Keep this current
	    bispsrb flag_z	;Set EQ
	   else
	    cmpb ".",(r1)	;Possible float
	    if	eq
	     cmpb 9,r3		;Can't have digits more than 9
	     if	hs
	      movb 10,r4	;Re-evaluate string as decimal
	      movb 9,r2		;Nothing larger than this
	      movd fpr0,r0
	      movd fpr1,r1	;Back to beginning
	      bsr dig_cnvs
	      addqd 1,r1
	      addqd -1,r0	;Skip "."
	      movd r0,r5	;Digits to right of decimal
	      bsr dig_cnv1	;Merge in with previous digits
	      comd r0,r3	;Don't count "." as a digit
	      addd fpr0,r3	;Number of digits in mantissa
	      cmpd 16,r3	;Max number of digits in mantissa
	     quit lo
	      movd r6,r3
	      ord r7,r3
	      cmpqd 0,r3	;See if mantissa is 0
	      if ne
	       movd r0,r3	;Remaining digits
	       subd r5,r3	;Negate digits right of decimal (exponent)
	      endif
	      movd r6,num
	      movd r7,num+4	;Save mantissa
	      movd r3,tos	;Default exponent
	      movqd 0,r6	;Default E exponent
	      cmpb "E",(r1)
	      if eq
	       cmpqd 0,r0
	       if lo
	        addqd 1,r1
	        addqd -1,r0	;Skip "E"
	        cmpb "-",(r1)
	        if eq
	         cmpqd 0,r0
	         if lo
	          addqd 1,r1
	          addqd -1,r0
	          bsr dig_cnvs
	          negd r6,r6
	         endif
	        else
	         bsr dig_cnvs
	        endif
	       endif
	      endif
	      addd tos,r6	;Complete exponent now in R6
	      absd r6,r3
	      cmpw 308,r3	;Max possible exponent
	     quit lo
	      sfsr tos
	      lfsr 0		;Trap enables off
	      movl f0,tos
	      movl f2,tos
	      movdl num+4,f0	;MSDword
	      movdl 65536,f2	;Multiplier
	      mull f2,f2	;Multiplier for MSDword
	      mull f0,f2
	      movzwd num+2,tos	;Must be unsigned
	      movdl tos,f0
	      mull 65536.0,f0
	      addl f0,f2
	      movzwd num,tos	;Must be unsigned
	      movdl tos,f0	;LSDword
	      addl f0,f2	;Complete mantissa in F2
	      movl f2,tos	;Mantissa
	      movw r6,tos	;Exponent
	      bsr exp_flt	;Adjust value by exponent
	      movd tos,r6	;LSDword
	      movd tos,r7
	      movl tos,f2
	      movl tos,f0
	      lfsr tos
	      movzbd "F",r4
	      bispsrb flag_z	;Set EQ
	     qend
	      bicpsrb flag_z	;Make NE
	     endif
	    endif
	   endif
	  orif	ne
	  endif
	 else
	  cmpqd	2,r0		;Must be at least 2 characters
	 orif	hi
	  cmpb	"X",1(r1)
	  if	eq
	   addqd 2,r1
	   addqd -2,r0
	   movzbd 16,r4		;This is new radix
	   movzbd 15,r2		;Max digit
	   movd	r0,r5		;R5 is old R0 before conversion
	   bsr	dig_cnvs	;Just convert now to value in R6R7
	   bispsrb flag_z	;Success
	  endif
	 orif	ne
	 endif
	else
	 cmpqd	2,r0		;Must be at least 2 characters
	orif	hi
	 movqd	2,r5		;Binary radix
	 cmpb	"B",(r1)
	 if	eq
	  addqd 2,r1
	  addqd -2,r0
	  movd	r5,r4		;This is new radix
	  movd	r5,r2
	  addqd -1,r2		;New max digit
	  movd	r0,r5		;R5 is old R0 before conversion
	  bsr	dig_cnvs	;Just convert now to value in R6R7
	  bispsrb flag_z	;Success
	 else
	  movb	10,r5		;Try decimal radix
	  cmpb	"D",(r1)
	 orif	eq
	  movb	16,r5		;Hex radix
	  cmpb	"H",(r1)
	 orif	eq
	  cmpb	"X",(r1)
	 orif	eq
	  movb	8,r5
	  cmpb	"O",(r1)
	 orif	eq
	  cmpb	"Q",(r1)
	 orif	eq
	 endif
	orif	ne		;Try standard conversion routine
	endif

	movd	r6,num		;Store LSDword
	movd	r7,num+4	;MSDword
	cmpd	r5,r0		;Invalid number if same
	if	hi
	 cmpb	"F",r4		;Check for float
	 if	eq
	  movqb	6,type
	 else
	  cmpqd 0,r7		;Error if overflow
	  if	eq
	   movqb 2,type		;Integer type
	  else
	   movqb 7,type		;64 bit integer
	  endif
	 endif
	endif

	tbitb	7,radx		;See if negative
	if	fs
	 cmpqb	6,type		;Check for float
	 if	eq
	  negl	num,num
	 else
	  negd	num,num
	  addcd	0,num+4
	  negd	num+4,num+4
	 endif
	endif

	movb	r4,radx
	negd	r0,r0		;Remaining characters
	addd	tos,r0		;Number of evaluated characters
	movd	tos,r1
	pend	0

	disp	1

;Convert digits in (R1), length in R0 until invalid digit found
;R2 = largest acceptable digit, R4 holds radix for conversion
;Update R3 with largest digit found, return value in R6R7
;Enter at DIG_CNV1 if R6R7 already initialized

dig_cnvs::
	movqd	0,r6
	movqd	0,r7
dig_cnv1::
	save	[r5]
	begin	
	 cmpqd	0,r0		;Check length
	quit	eq
	 movb	(r1),r5
	 subb	"0",r5
	 cmpb	9,r5
	 if	lo
	  cmpb	10+7,r5		;Must be at least "A"
	  if	ls
	   addqb -7,r5
	   cmpb	r5,r2
	  endif
	 else
	  cmpb	r5,r2		;Just check against R2 if 0-9
	 endif
	while	ls		;Keeper so far, advance to next digit
	 addqd	-1,r0		;One more here
	 addqd	1,r1
	 muld	r4,r7		;Multiply MSDwords
	 movd	r7,tos
	 movqd	0,r7
	 meid	r4,r6		;Multiply LSDwords
	 addd	tos,r7		;Add everything together
	 addd	r5,r6
	 addcd	0,r7		;New 64 bit subtotal
	 cmpb	r5,r3		;Check for new max digit
	 if	hi
	  movb	r5,r3		;New largest digit
	 endif
	endw

	restore	[r5]
	ret

	disp	2

;TOS holds temporary M_RADIX:W, integer to display, field size and padding
;R0/R1 holds index,buffer if not displaying
;R6,R7 must not be altered, R4 holds address of routine to display R5

num4_tos::
	lproc
int:	blkd			;Integer to display
fppad:	blkb			;Padding character
fpfld:	blkb			;Field size
radx:	blkw			;Temporary M_RADIX value to use
	reg	[r2,r3,r5]
pfx:	blkd			;Prefix
pfxlen:	blkb			;Prefix length
	code

	movqd	0,r2		;Offset for leading characters
	movqd	0,r3		;Leading characters stored here for now
	movd	int,r5		;Integer to display

	tbitb	b_sign,radx	;See if signed display requested
	if	fs
	 cmpqd	0,r5		;See if negative
	 if	gt
	  absd	r5,r5
	  insb	r2,"-",r3,8	;Display leading "-"
	  addb	8,r2
	 else
	  tbitb	b_pls,radx
	  if	fs
	   insb	r2,"+",r3,8	;Display leading "+"
	   addb	8,r2
	  endif
	 endif
	endif

	save	[r4,r6]
	extsd	radx,r4,0,5	;Current radix to R4
	tbitb	b_rdx,radx	;See if radix display requested
	if	fs
	 movw	"H'",r6		;Hex radix
	 cmpb	16,r4		;Check for hex first
	 if	eq
	  cmpd	r5,r4
	  if	hs		;Display leading "H'" if HS
	   insw	r2,r6,r3,16	;Display radix
	   addb	16,r2
	  else
	   cmpd	9,r5		;Always display H' if more than 9
	  orif	lo
	  endif
	 else
	  movw	"B'",r6
	  cmpqd 2,r4		;Check for binary
	 orif	eq
	 endif
	endif
	movd	r3,pfx		;Actual prefix, 0 if none
	lshd	-3,r2		;Actual length in bytes
	movb	r2,pfxlen	;Length if bytes of prefix

;Get length of integer to display, R5 holds integer, R4 holds radix
;Count will be in R2, R3 will hold beginning divisor

	tbitb	b_asc,radx	;Check for ASCII display
	if	fc		;Not ASCII if FC
	 movqd	1,r2		;Initial digit count
	 movqd	1,r3		;Initial divisor
	 begin
	  movd	r5,tos
	  movd	r4,tos
	  movd	r5,r4
	  movqd	0,r5
	  deid	r3,r4
	  movd	tos,r4
	  cmpd	r5,r4
	  movd	tos,r5
	 while	hs		;Go until MS digit is less than radix
	  addqd	1,r2
	  muld	r4,r3
	 endw
	else			;Display in ASCII with attributes
	 movqd	0,r2		;Initialize length
	 save	[r5]
	 until	eq
	  lshd	-8,r5
	  addqd	1,r2
	  cmpqd	0,r5		;Continue until upper bits are all 0
	 endu
	 restore [r5]
	endif
	restore	[r4,r6]

	tbitb	b_fld,radx	;See if padding required
	if	fs
	 save	[r2,r5]
	 addb	pfxlen,r2	;Total displayable characters
	 negd	r2,r2
	 addb	fpfld,r2	;Padding characters required
	 begin
	  cmpqb	0,r2
	 while	lt
	  movzbd fppad,r5
	  bsr	nm4_sbr
	  addqb	-1,r2
	 endw
	 restore [r2,r5]
	endif

	save	[r3,r5]
	movd	pfx,r3
	begin			;Display any prefix required
	 cmpqd	0,r3
	while	ne
	 movzbd	r3,r5
	 bsr	nm4_sbr
	 lshd	-8,r3
	endw
	restore	[r3,r5]

;Ready to display, R5 holds value, R3 holds initial divisor, R2 holds count

	tbitb	b_asc,radx
	if	fc		;No ASCII display if FC
	 movd	r5,r2		;LSDword (remainder) of value
	 movd	r3,r5		;Current divisor
	 until	eq
	  movqd	0,r3		;MSDword of dividend
	  deid	r5,r2		;R3rR2 = R3R2/R5
	  addb	"0",r3		;Quotient converted to ASCII
	  cmpb	"9",r3
	  if	lo
	   addqb 7,r3		;Make A-F as needed
	  endif
	  save	[r5]
	  movzbd r3,r5
	  bsr	nm4_sbr
	  restore [r5]
	  extsd	radx,r3,0,5	;Radix is divisor for R5
	  movd	r4,tos
	  movd	r5,r4
	  movqd	0,r5
	  deid	r3,r4		;Unsigned division, quotient in r5
	  movd	tos,r4
	  cmpqd	0,r5		;Continue until quotient is 0
	 endu
	else
	 movd	r5,r3		;Value to display is safe here
	 until	eq
	  movqb 0,r2		;All attributes off
	  tbitb	b_lit,radx	;Check for literal ASCII
	  if	fc		;Use attributes if no B_LIT
	   cbitb 7,r3
	   if	fs
	    sbitb vca_rev,r2	;Reverse attribute on
	   endif
	   cmpb	" ",r3		;If < 20H then turn on dim video
	   if	hi
	    sbitb vca_dim,r2
	    addb "@",r3		;Make it displayable
	   endif
	   cmpqb 0,r2
	   if	ne		;Attributes required if NE
	    movzbd vc_sat:#,r5	;Set attribute command
	    bsr	nm4_sbr
	    movb r2,r5		;Attributes to set
	    bsr	nm4_sbr		;Set attributes
	   endif
	  endif
	  movzbd r3,r5		;Actual character now
	  bsr	nm4_sbr
	  cmpqb	0,r2
	  if	ne
	   movb	vc_cat:#,r5	;Clear attribute command
	   bsr	nm4_sbr
	   movb	r2,r5
	   bsr	nm4_sbr
	  endif
	  lshd	-8,r3
	  cmpqd	0,r3
	 endu
	endif

	pend

;R4 holds address of display routine if not putting R5 into buffer in R0/R1

nm4_sbr::
	tbitb	b_buf,radx
	if	fs
	 movb	r5,r1[r0:b]
	 addqd	1,r0
	 ret
	endif
	jump	r4


;Display any NUM:L according to TYP, M_RADIX, PAD, FLD size on stack
;32 bit float must be stored on stack as 64 bit long float
;R0/R1 holds index,buffer if not displaying
;R6/R7 must not be altered, R4 holds address of display routine

num_tos::
	lproc
num:	ds	8		;Value to display
typ:	blkb			;Type of number
fppad:	blkb
fpfld:	blkb
radx:	blkw			;Radix
	reg	[r2,r3,r5]
expo:	ds	4		;Decimal exponent
float:	ds	8		;Adjusted float to display
	code

	cmpb	0f,typ		;See if defined
	if	eq
	 bsr	r5_und
	else
	 movzbd	typ,r2
	 bsr	dsp2r5c
	endif

	pend

dsp2r5c::
	casew	t_dsp2r5[r2:w]
t_dsp2r5:
	dw	r52_0000-dsp2r5c ;Byte integer
	dw	r52_0000-dsp2r5c ;Word integer
	dw	r52_0000-dsp2r5c ;Variable integer
	dw	r52_0000-dsp2r5c ;Dword integer
	dw	r52_0100-dsp2r5c ;32 bit float
	dw	r52_0100-dsp2r5c ;64 bit float
	dw	r52_0100-dsp2r5c ;Variable size float
	dw	r5_und-dsp2r5c	;Undefined
	dw	r52_1000-dsp2r5c ;String
	dw	r5_und-dsp2r5c	;Undefined
	dw	r5_und-dsp2r5c	;Undefined
	dw	r5_und-dsp2r5c	;Undefined
	dw	r52_0000-dsp2r5c ;Boolean
	dw	r5_und-dsp2r5c	;Undefined
	dw	r5_und-dsp2r5c	;Undefined
	dw	r5_und-dsp2r5c	;Undefined

;Display integer

r52_0000::
	movd	num,tos
	movd	radx,tos	;PAD, FLD, RADX
	bsr	num4_tos
	ret

;Display float, 64 bits in NUM(FP)

r52_0100::
	save	[r0,r1]

	movzbd	52,r2		;1st bit of exponent
	extd	r2,num,r2,11	;Exponent in R4
	subd	1023,r2		;Subtract offset
	muld	19728,r2
	ashd	-16,r2		;Log2 * exponent in R4 (10s exponent)
	movw	r2,expo

	movl	num,tos		;Float to display
	negw	r2,r2		;Divide if positive, mult. if negative
	movw	r2,tos
	bsr	exp_flt		;Multiply float by 10s exponent
	movl	tos,float

	sfsr	tos		;Save original
	lfsr	0		;Don't want any traps taken
	movl	f0,tos
	movl	f2,tos
	movl	float,f0
	movbl	10,f2		;Ready for any adjustments needed
	movzbd	52,r3		;First bit of exponent
	extd	r3,float,r3,11
	subd	1023,r3		;Should be between 0 and 3 inclusive
	if	cs		;Too small if carry
	 mull	f2,f0		;One more here
	 addqw	-1,expo		;One less here
	else
	 extsd	float+6,r2,0,4
	 lshd	-1,r2
	 sbitb	3,r2		;MS digit of number in R2
	 addqd	-3,r3
	 lshd	r3,r2		;Multiply by any exponent beyond 3
	 cmpd	9,r2		;MS digit can't be bigger than this
	 if	lo
	  divl	f2,f0		;One less here
	  addqw	1,expo		;One more here
	 endif
	endif
	movl	f0,float
	movl	tos,f2
	movl	tos,f0
	lfsr	tos		;FPU restored

;Treat as fixed point now, 4 bits left of decimal point

	movqb	0,r2
	inssd	float,r2,3,32-3	;LS bits of mantissa (leave last 3 bits 0)
	movzbd	32-3,r3		;Start of last 24 bits
	extd	r3,float,r3,52-29 ;MS bits of mantissa
	sbitb	52-29,r3	;Implied leading 1

	movzbd	52,r5
	extd	r5,float,r5,11
	subd	1023,r5		;Fixed point exponent
	negd	r5,r5
	addqd	3,r5
	movzbd	31,r0
	begin
	 cmpqb	0,r5
	while	ne
	 lshd	-1,r2
	 insd	r0,r3,r2,1	;Rotate LSB of R3 to MSB of R2
	 lshd	-1,r3
	 addqb	-1,r5
	endw

;56 bit fixed point mantissa now in R2,R3, 4 bits to left of decimal point
;Load 15 BCD digits into R0,R1

	save	[r4,r6]
	movqd	0,r0
	movqd	0,r1
	movzbd	52-32,r6	;Bit to extract from
	movb	15,r4		;Digit counter
	until	eq
	 lshd	4,r1		;R1 shifted left
	 movzbd	28,r5
	 extb	r5,r0,tos,4
	 orb	tos,r1		;Upper 4 bits of R0 carried to R1
	 lshd	4,r0		;R0 shifted left
	 extb	r6,r3,tos,4	;Next digit merged in
	 orb	tos,r0
	 insd	r6,0,r3,4	;Zap bits just extracted
	 muld	10,r3
	 movd	r3,r5
	 movqd	0,r3
	 meid	10,r2
	 addd	r5,r3		;Mantissa = mantissa*10
	 addqb	-1,r4
	 cmpqb	0,r4
	endu			;R0/R1 holds BCD mantissa
	restore	[r4,r6]

;Round ASCII value according to 15th digit, only display 14 max

	bicpsrb	1		;Clear carry
	cmpqb	4,typ		;See if float or long
	if	eq
	 addpd	5,r1		;Round from 7th digit
	 movqd	0,r0
	 inssb	0,r1,0,4	;Zap lower 9 digits
	else
	 addpd	5,r0		;Round according to last digit
	 addpd	0,r1
	endif

	cmpd	h'fffffff,r1	;See if 16th digit resulted from carry
	if	hs		;Rotate if MS digit is 0
	 lshd	4,r1		;R1 shifted left
	 movzbd	28,r5
	 extb	r5,r0,tos,4
	 orb	tos,r1		;Upper 4 bits of R0 carried to R1
	 lshd	4,r0		;R0 shifted left
	else
	 addqw	1,expo		;*10 if carry produced
	endif
	movqb	0,r0		;Garbage in last 2 characters
	movd	r0,r2
	movd	r1,r3		;BCD to R2R3

	cmpqb	4,typ		;Check for 32 bit float or long
	if	eq
	 movqw	6,r5		;Display length for 32 bits
	else
	 movw	14,r5		;Display length for 64 bits
	endif

	cmpqw	0,expo
	if	le		;Exp is positive if LE
	 addqw	-1,r5		;One less than max
	 cmpw	r5,expo		;Max exp completely displayable
	 if	ge
	  movb	expo,r5
	  addqb	1,r5		;Actual digits to left of decimal
	  movqw	0,expo		;Nothing left here
	 else
	  movqb	1,r5
	 endif
	else			;Exponent is negative
	 cmpw	-1,expo		;Only value displayable without E
	 if	ne		;Use standard scientific notation here
	  movqb	1,r5
	 else
	  movqb	0,r5
	  movqw 0,expo		;Nothing left of EXPO
	 endif
	endif			;R5 = digit count to left of decimal

;Ready to display value now
;Check for 0 (special case)

	movd	num+4,r0
	cbitb	31,r0		;Clear sign bit
	ord	num,r0		;Float is 0 if all bits are 0
	cmpqd	0,r0
	if	eq
	 movqw	0,expo
	 movqb	1,r5
	 movqd	0,r3
	 movqd	0,r2		;Everything is 0
	endif
	restore	[r0,r1]

	tbitb	63,num		;Check sign of number
	if	fs
	 save	[r5]
	 movzbd	"-",r5
	 bsr	nm4_sbr
	 restore [r5]
	endif

	begin
	 cmpqb	0,r5
	while	lt
	 save	[r5]
	 movzbd	28,r5		;Bit to extract BCD digits from
	 extd	r5,r3,r5,4
	 addb	"0",r5
	 bsr	nm4_sbr
	 movzbd	28,r5		;Bit to extract BCD digits from
	 lshd	4,r3		;R3 shifted left
	 extb	r5,r2,tos,4
	 orb	tos,r3		;Upper 4 bits of R2 carried to R3
	 lshd	4,r2		;R2 shifted left
	 restore [r5]
	 addqb	-1,r5
	endw

	movzbd	".",r5
	bsr	nm4_sbr

	until	eq		;Always display at least once
	 movzbd	28,r5		;Bit to extract BCD digits from
	 extd	r5,r3,r5,4
	 addb	"0",r5
	 bsr	nm4_sbr
	 lshd	4,r3		;R3 shifted left
	 movzbd	28,r5		;Bit to extract BCD digits from
	 extb	r5,r2,tos,4
	 orb	tos,r3		;Upper 4 bits of R2 carried to R3
	 lshd	4,r2		;R2 shifted left
	 movd	r2,tos
	 ord	r3,tos
	 cmpqd	0,tos		;Stop if only trailing 0s left
	endu

;Ready for exponent

	cmpqw	0,expo
	if	ne
	 movzbd	"E",r5
	 bsr	nm4_sbr
	 movxwd	expo,tos
	 movd	radx,tos	;PAD, FLD, RADX
	 andw	exp b_buf,tos	;Only keep this
	 orw	10+(exp b_sign),tos ;Signed decimal
	 bsr	num4_tos
	endif

	ret

;Display string

r52_1000::
	movzwd	num,r2		;Length of string
	movd	2+num,r3	;Pointer to string
	begin
	 cmpqd	0,r2
	while	lt
	 movzbd	(r3),tos
	 movd	radx,tos	;PAD, FLD, RADX
	 bsr	num4_tos
	 addqd	1,r3
	 addqd	-1,r2
	 tbitb	b_asc,radx	;See if ASCII display selected
	 if	fc
	  cmpqd	0,r2		;See if more coming
	  if	lt
	   movzbd ",",tos	;Comma separates individual bytes
	   movd	radx,tos	;PAD, FLD, RADX
	   andw	exp b_buf,(sp)	;Preserve this only
	   sbitb b_asc,(sp)
	   bsr	num4_tos
	  endif
	 endif
	endw
	ret

;Undefined data type

r5_und::
	movd	"Undf",tos
	movd	radx,tos	;PAD, FLD, RADX
	andw	exp b_buf,(sp)	;Preserve this only
	sbitb	b_asc,(sp)
	bsr	num4_tos
	ret


;TOS holds float:L, signed 10s exponent:W
;Return adjusted float on stack

exp_flt::
	lproc
float:	ds	8		;Long float
expo:	ds	2		;Signed 10s exponent
	reg	[r2]
	code

	movd	float,r2
	ord	float+4,r2
	cmpqd	0,r2
	if	ne
	 cmpqd	0,expo
	endif
	if	ne
	 sfsr	tos
	 lfsr	0		;Don't want traps here
	 movl	f0,tos
	 movl	f2,tos
	 
	 movbl	10,f0		;Sequential exponent
	 movbl	1,f2		;Accumulated exponent
	 absw	expo,r2		;Exponent to convert
	 until	eq
	  tbitb	0,r2
	  if	fs
	   mull	f0,f2		;New accumulated value
	  endif
	  lshw	-1,r2
	  cmpqw	0,r2
	  if	lt
	   mull	f0,f0		;Next multiplier, FPU overflow 9th time
	  endif
	 endu
	 movl	float,f0
	 tbitb	15,expo		;Check sign of exponent
	 if	fc		;Multiply if positive
	  mull	f2,f0		;Adjusted float
	 else
	  divl	f2,f0
	 endif
	 
	 movl	f0,float
	 movl	tos,f2
	 movl	tos,f0
	 lfsr	tos		;Everything restored
	endif

	pend	float-expo	;Return float on stack


;Pop a value to (R5)
;Strings and floats pop 2 stack entries

math_pop::
	save	[r1,r2,r3]
	movd	math_ptr,r1	;Stack index
	addr	math_stk,r2	;Base pointer
	movw	h'ff00,(r5)	;Make undefined for now

	cmpqd	6,r1
	if	ls
	 movmw	-6(r2)[r1:b],(r5),3 ;LS portion with designator first
	 extsb	1(r5),r3,b_size-8,4 ;See what kind of label this is
	 cmpb	8,r3
	 if	eq		;Strings required 2 stack entries
	  addqd	-6,r1
	  cmpqd 6,r1		;Another entry required
	  if	ls
	  movd	-6(r2)[r1:b],6(r5) ;MS portion comes off last
	  else
	   movw	h'ff00,(r5)	;Make undefined
	  endif
	 else
	  andb	b'1100,r3
	  cmpqb	b'0100,r3	;Check for float
	 orif	eq
	 endif
	endif

	addqd	-6,r1
	bsr	math_chk
	movd	r1,math_ptr
	restore	[r1,r2,r3]
	ret


;Push value in (R5) onto stack
;Strings or floats will push 2 values

math_psh::
	save	[r1,r2,r3]
	movd	math_ptr,r1	;Stack index
	addr	math_stk,r2	;Base pointer
	addqd	6,r1
	bsr	math_chk
	extsb	1(r5),r3,b_size-8,4 ;See what kind of label this is

	cmpb	8,r3
	if	eq		;Strings required 2 stack entries
	 addqd	6,r1
	 bsr	math_chk
	 movd	6(r5),-12(r2)[r1:b] ;MS portion goes first
	 movmw	(r5),-6(r2)[r1:b],3 ;LS portion with ID last on, first off
	else
	 andb	b'1100,r3
	 cmpqb	b'0100,r3	;Check for float
	orif	eq
	 movmw	(r5),-6(r2)[r1:b],3
	endif

	movd	r1,math_ptr
	restore	[r1,r2,r3]
	ret


math_chk::

;If R1<0 then stack underflow

	cmpqd	0,r1
	ble	math_ck1

	addqd	1,m_errct
	bsr	dsp_msg:d
	.byte	"Math stack empty",cr,lf,0
	movqd	0,r1		;Restore to 0
	ret	0

math_ck1::
	cmpd	math_siz,r1
	bhs	return
	addqd	1,m_errct
	bsr	dsp_msg:d
	.byte	"Math stack overflow",cr,lf,0
	movqd	0,r1		;Restore to 0
	ret	0


;R1 => 16 bit label status field
;Return length in R0

lbl_len::
	save	[r2]
	movqd	2+4,r2		;Normal label overhead

	extsb	1(r1),r0,b_size-8,4 ;Type (float, string, other)
	cmpb	b'1000,r0	;Check for string
	if	eq
	 addqd	2,r2		;Length for string
	else
	 bicb	b'11,r0
	 cmpqb	b'0100,r0	;Float if EQ
	 if	eq
	  addqd	4,r2
	 endif
	endif
	extsd	(r1),r0,0,5	;Length of name
	addd	r2,r0

	restore	[r2]
	ret

;2(R5) points to label
;Get pointer to name field in R1

lbl_nam::
	extsb	1(r5),r1,b_size-8,4 ;Type (float, string, other)
	cmpb	b'1000,r1	;Check for string
	if	eq
	 movqd	6,r1		;Length of string
	else
	 bicb	b'11,r1
	 cmpqb	b'0100,r1	;Float if EQ
	 if	eq
	  movzbd 8,r1
	 else
	  movqd	4,r1		;Standard length
	 endif
	endif
	addr	2(r5),tos
	addd	tos,r1		;Pointer to name now in R1
	ret


;Immediate pass mode, do error check first

byt_pi::
	save	[r4]
	extsb	1(r5),tos,b_size-8+2,2
	cmpqb	1,tos		;Check for float
	if	eq
	 bsr	flt_siz
	else
	 bsr	byt_siz		;Get required size for R5 in R4
	endif
	cmpd	r4,r6
	restore	[r4]
	if	hi
	 bsr	prm_ovfl	;Parameter overflow
	endif

byt_ok::
	save	[r3,r5,r6]

;Check mode, LSB/MSB or MSB/LSB

	extsb	1(r5),r3,b_mode-8,4 ;Mode descriptor
	cmpqb	7,r3		;See if reverse required
	if	eq		;LSB/MSB
	 until	eq
	  movb	2(r5),(r7)
	  addqd	1,r7
	  addqd	1,r5
	  addqb	-1,r6
	  cmpqb	0,r6
	 end
	else			;MSB/LSB
	 until	eq
	  movb	1(r5)[r6:b],(r7)
	  addqd	1,r7
	  addqb	-1,r6
	  cmpqb	0,r6
	 end
	endif
	restore	[r3,r5,r6]
	ret

;Pass 2 put routine, verify size and put value
;Stored mode and size must match requested size exactly

byt_p2::
	save	[r2,r3,r4]
	extsd	(r7),r2,0,4	;Size
;	EXTSB	(R7),R3,4,4	;Mode
;	EXTSB	1(R5),R4,B_MODE-8,4 ;Mode must match too
;	CMPB	R3,R4
;	IF	NE
;	 BSR	MOD_ER
;	ENDIF
	cmpb	r6,r2		;Size must still match
	movd	r2,r6		;Always use stored size
	restore	[r2,r3,r4]
	beq	byt_pi
	bsr	prm_ovfl	;Doesn't fit in provided size
	br	byt_ok		;Skip size check now


;Displacement pass 2 put routine, verify size and put value
;Stored size must allow for actual size

dsp_p2::
	extsd	(r7),r6,0,4	;Always use stored size

;Make sure R5 will fit into size in R6

dsp_p2a::
	save	[r3,r4]
;	EXTSB	(R7),R3,4,4	;Stored mode
;	EXTSB	B_MODE/8(R5),R4,0,4 ;Current mode
;	CMPB	R3,R4
;	IF	NE
;	 BSR	MOD_ER
;	ENDIF
	bsr	dsp_byt		;Get minimum size for R5 in R4
	cmpd	r4,r6		;Minimum size in R4
	restore	[r3,r4]
	if	hi
	 bsr	prm_ovfl	;Doesn't fit in provided size
	endif
	bsr	dsp_adj		;Adjust R5 for size in R6
	br	byt_ok:d	;Skip size check, just shift into (R7)


dsp_byt::
	tbitb	h'1f,2(r5)	;See if positive
	bfs	dsp_sneg	;Negative if FS

	movqd	1,r4
	cmpd	h'3f,2(r5)
	bhs	return

	movqd	2,r4
	cmpd	h'1fff,2(r5)
	bhs	return

	movqd	4,r4
	tbitb	h'1e,2(r5)
	bfc	return		;Error if FS

	br	prm_ovfl

dsp_sneg::
	movqd	4,r4
	tbitb	h'1e,2(r5)
	bfc	prm_ovfl	;Too negative if FC

	cmpd	-h'2000,2(r5)
	bgt	return

	movqd	2,r4
	cmpd	-h'40,2(r5)
	bgt	return

	movqd	1,r4
	ret	0

;Adjust value in 2(R5) according to size in R6

dsp_adj::
	ord	h'c0000000,2(r5)
	cmpqb	4,r6
	beq	return

	andd	h'bfff,2(r5)
	sbitb	h'f,2(r5)
	cmpqb	2,r6
	beq	return

	andd	h'7f,2(r5)
	ret	0


;Return minimum size of float in 2(R5)
;R6 holds 4 or 8 for intended size, if 4 then MOVLF
;Float in 2(R5) on entry must be 64 bit long

flt_siz::
	save	[r3]
	extsd	2+6(r5),r3,52-48,11 ;Get exponent
	cmpqd	0,r3		;0 is 32 bit
	if	ne
	 subd	1023-126,r3	;Exponent offset - most neg 32 bit exponent
	endif
	cmpd	h'fd,r3		;Largest possible exponent for 32 bit value
	if	hs
	 movqd	4,r4
	 cmpqb	4,r6		;If 32 bit desired, convert it here
	 if	eq
	  movlf	2(r5),2(r5)
	 endif
	else
	 movzbd	8,r4
	endif
	restore	[r3]
	ret

;Return size of 2(R5) in R4 (1,2,4)

byt_siz::
	movqd	1,r4
	cmpd	h'ff,2(r5)
	bhs	return
	movqd	2,r4
	cmpd	h'ffff,2(r5)
	bhs	return
	movqd	4,r4
	tbitb	h'1f,2(r5)
	bfc	return

;These are negative values

	cmpd	-h'8000,2(r5)
	bgt	return
	movqd	2,r4
	cmpd	-h'80,2(r5)
	bgt	return
	movqd	1,r4
	ret	0
;Convert (R4) to displacement in R5
r4_disp::

;Try one byte first

	tbitb	7,0(r4)
	bfs	r4_dsp1		;2 or 4 bytes if FS

;1 byte fer shure

	movb	0(r4),r5
	addqd	1,r4
	lshb	1,r5
	ashb	-1,r5
	movxbd	r5,r5
	ret	0

;2 or 4 byte value
r4_dsp1::

;Check for 2 bytes

	tbitb	6,0(r4)
	bfs	r4_dsp2		;4 bytes if FS

;This is 2 byte value

	movb	0(r4),r5
	lshw	8,r5
	movb	1(r4),r5
	addqd	2,r4
	lshw	2,r5
	ashw	-2,r5
	movxwd	r5,r5
	ret	0

;4 byte disp.

r4_dsp2::
	movb	0(r4),r5
	lshd	8,r5
	movb	1(r4),r5
	lshd	8,r5
	movb	2(r4),r5
	lshd	8,r5
	movb	3(r4),r5
	lshd	2,r5
	ashd	-2,r5
	addqd	4,r4
	ret	0


;Search general symbol table only
;Works like SYM2VAL but only searches general table

gsym2val::
	movd	t_symbl,r2	;Default R2 in case of error
	addr	t_symalf,r3	;Default R3 pointer in case of error
	cmpqb	0,r0		;Can't be 0 length
	if	eq
	 bicpsrb flag_z
	 ret
	endif
	bsr	sym_indx	;Initialize R3 for proper index entry
	br	sym2sub

;Return proper T_SYMALF pointer in R3

sym_indx::
	save	[r2]
	movzbd	(r1),r2		;Index to index
	cmpb	"A",r2
	if	hi
	 movb	"A",r2		;Don't go below this
	else
	 cmpb	"Z",r2
	 if	lo
	  movb	"Z",r2		;Don't go above this
	 endif
	endif

	subb	"A",r2		;Index to index table
	muld	13,r2		;Pointer to proper 2nd letter index
	cmpqd	1,r0
	if	lo		;If 2nd letter then index by that too
	 movzbd	1(r1),r3
	 cmpb	"A",r3
	 if	hi
	  movb	"A",r3
	 else
	  cmpb	"Z",r3
	  if	lo
	   movb	"Z",r3
	  endif
	 endif
	 subb	"A",r3
	 lshd	-1,r3		;Divide by 2 for 2nd letter index
	 addd	r3,r2
	endif

	muld	sidx_of,r2
	addr	t_symalf[r2:b],r3 ;Pointer to 1st entry for this letter
	restore	[r2]
	ret

;R0 holds length, R1 holds label, R3 holds address of 1st index
;Return pointer to greater or equal symbol in R2
;Pointer to previous symbol in R3
;Symbol must be above MSYM_BEG unless global
;EQ/NE set according to match

t_symsiz::
	db	4,4,4,4		;Integer sizes
	db	8,8,8,8		;Float sizes
	db	6,4,4,4		;Strings
	db	4,4,4,4		;Boolean, BCD, descriptor, undefined

	disp	1

sym2sub::
	save	[r4,r5,r6,r7]
	movd	t_symbl,r4	;Base address of symbol table
	movd	tsym_end,r2	;Initialize to next available slot
	movd	msym_beg,r7
	addd	r4,r7		;Lowest address unless global

s1:	extsd	(r3),r5,0,sidx_bit
	cmpd	sidx_end-1,r5
	blo	s9:w
	addr	r4[r5:b],r2

	save	[r0,r1,r2]
	extsd	sidx_of(r2),r5,0,5 ;Length of string 2
	extsd	sidx_of+1(r2),r6,b_size-8,4 ;Symbol size
	movzbd	t_symsiz[r6:b],r6 ;Adjust for symbol size
	addr	sidx_of+2(r2)[r6:b],r2 ;Address of symbol name
	cmpd	r0,r5
	beq	s4
	blo	s5

;2nd string (R2) is shorter

	movd	r5,r0		;Use shortest length
	cmpsb
	restore	[r0,r1,r2]
	bhs	s3		;Same means 1st string higher (longer)
	br	s9		;String not found

;1st string (R1) is shorter)

s5:	cmpsb
	restore	[r0,r1,r2]
	bhi	s3		;Same means 2nd string higher (longer)

	bicpsrb	flag_z		;No match, reset Z
	br	s9

;Lengths are same, compare strings

s4:	cmpsb
	restore	[r0,r1,r2]
	blo	s9		;Not in table if LO
	bhi	s3		;Not found yet, keep looking

	extsb	sidx_of(r2),r5,b_typ,3
	cmpqb	lbl_glb+4,r5	;Defined globals always accepted
	beq	s9
	cmpd	r2,r7		;Must be above current module
	if	hs
	 cmpd	msym_end,r2	;Can't be too high either
	 bls	s3
	 bispsrb flag_z		;Always good if in current module
	 br	s9
	endif

s3:	movd	r2,r3		;Current entry becomes previous
	br	s1:w

s9:	addr	sidx_of(r2),m_symadr ;Pointer to 16 bit status field
	subd	t_symbl,m_symadr
	restore	[r4,r5,r6,r7]
	ret

	disp	2

;Create new symbol table entry
;TOS holds length, type, label pointer, previous symbol address
;Returns address of symbol in M_SYMADR

make_sym::
	lproc
slen:	blkb	1		;Length of symbol name
typ:	blkb	2		;Symbol designator, B_MODE, B_SIZE
ptr:	blkb	4		;Pointer to symbol name
adr:	blkb	4		;Address of previous symbol entry in table
	reg	[r0,r1,r2,r3,r5]
	code

	movzbd	slen,r0
	movd	adr,r3
	movd	r0,tos	
	addd	20,tos
	bsr	chk_mem:d	;Make sure there's room in memory

	if	fc
	 addr	20(tsym_end),r5
	 subd	t_symbl,r5	;Offset must be in range
	 cmpd	sidx_end,r5
	 if	ls
	  addqd	1,m_errct
	  sbitb	31,m_errct	;Force termination
	  bsr	dsp_msg:d
	  byte	"Symbol table full",cr,lf,0
	 else
	  movd	tsym_end,r5
	  inssd	(r3),(r5),0,8*sidx_of ;Pointer to following symbol
	  movd	r5,r1
	  subd	t_symbl,r1	;Offset to current symbol
	  addr	sidx_of(r1),m_symadr ;Return address here
	  inssd	r1,(r3),0,sidx_bit
	  
	  movw	typ,sidx_of(r5)
	  inssb	r0,sidx_of(r5),0,5 ;Store length in bits 0-5
	  addqd	sidx_of,r5	;Point to 16 bit status
	  bsr	lbl_nam		;Get pointer to name in R1
	  movd	r1,r2		;Address for name
	  movd	ptr,r1
	  movsb			;Move name into place
	  movd	r2,tsym_end
	  movd	mod_indx,r3
	  subd	lmod,r3
	  cmpqd	1,r3		;Check for last module
	  if	eq
	   movd	r2,msym_end
	  endif
	 endif
	endif

	pend


;TOS holds memory required, make sure there's room
;FS on exit if no room

chk_mem::
	lproc
mem:	blkb	4		;Memory size needed
	reg	[r0,r1]
	code

	movd	mem,r0
	addd	tsym_end,r0	;Last address used
	cond	op_sys
	 addr	-1(m_string),r1
	celse
	 addr	-1(sb),r1
	cend
	addd	mem_siz,r1	;Highest usable address
	cmpd	r0,r1

	if	ls		;OK if LS
	 bicpsrb flag_f
	else
	 bsr	mem_ovfl
	 bispsrb flag_f
	end
	pend


;Check space in string table
;Length, String pointer on stack
;FS on exit if no more room

str_spc::
	lproc
slen:	blkb	4		;Length of string
	reg	[r0,r1,r2]
	code

	movd	m_strptr,r1	;Next available address
	addd	slen,r1		;Last address needed
	cmpd	r1,t_cxp	;See if there's already room
	bicpsrb	flag_f		;Assume OK for now
	if	hi
	 movd	slen,r0
	 addd	h'200,r0	;No room, move everything up
	 bicb	3,r0		;Backup to start of Dword
	 movd	r0,tos		;Additional memory required
	 bsr	chk_mem
	quit	fs		;No room for move if FS
	 movd	tsym_end,r1	;Last address to move
	 bicb	3,r1		;Backup to last Dword to move
	 addd	r0,t_cxpx
	 addd	r0,m_xrf
	 addd	r0,m_xrfptr
	 addd	r0,m_xrflin
	 addd	r0,m_link
	 addd	r0,m_linkm
	 addd	r0,m_lnkptr
	 addd	r0,t_symbl
	 addd	r0,tsym_end	;Advance all pointers
	 addd	r0,msym_end
	 movd	r1,r2
	 addd	r0,r2		;Target address for move
	 movd	r1,r0
	 subd	t_cxp,r0	;First address to move
	 lshd	-2,r0		;Number of Dwords
	 addqd	1,r0		;Count must be inclusive
	 movsd	b
	 addr	4(r2),t_cxp
	 bicpsrb flag_f
	endif

	pend

;Check space in CXP table
;FS on exit if no more room

cxp_spc::
	save	[r0,r1,r2]

	addr	20(t_cxpx),r1	;Next available address
	cmpd	r1,m_xrf	;See if there's already room
	bicpsrb	flag_f		;Assume OK for now
	if	hi
	 movd	h'200,r0	;No room, move everything up
	 movd	r0,tos		;Additional memory required
	 bsr	chk_mem
	quit	fs		;No room for move if FS
	 movd	tsym_end,r1	;Last address to move
	 bicb	3,r1		;Backup to last Dword to move
	 addd	r0,m_xrfptr
	 addd	r0,m_xrflin
	 addd	r0,m_link
	 addd	r0,m_linkm
	 addd	r0,m_lnkptr
	 addd	r0,t_symbl
	 addd	r0,tsym_end	;Advance all pointers
	 addd	r0,msym_end
	 movd	r1,r2
	 addd	r0,r2		;Target address for move
	 movd	r1,r0
	 subd	m_xrf,r0	;First address to move
	 lshd	-2,r0		;Number of Dwords
	 addqd	1,r0		;Count must be inclusive
	 movsd	b
	 addr	4(r2),m_xrf
	 bicpsrb flag_f
	endif

	restore	[r0,r1,r2]
	ret


;Check space in XRF table
;FS on exit if no more room

xrf_spc::
	save	[r0,r1,r2]

	addr	50(m_xrflin),r1	;Next available address
	cmpd	r1,m_link	;See if there's already room
	bicpsrb	flag_f		;Assume OK for now
	if	hi
	 movd	h'600,r0	;No room, move everything up
	 movd	r0,tos		;Additional memory required
	 bsr	chk_mem
	quit	fs		;No room for move if FS
	 movd	tsym_end,r1	;Last address to move
	 bicb	3,r1		;Backup to last Dword to move
	 addd	r0,m_linkm
	 addd	r0,m_lnkptr
	 addd	r0,t_symbl
	 addd	r0,tsym_end	;Advance all pointers
	 addd	r0,msym_end
	 movd	r1,r2
	 addd	r0,r2		;Target address for move
	 movd	r1,r0
	 subd	m_link,r0	;First address to move
	 lshd	-2,r0		;Number of Dwords
	 addqd	1,r0		;Count must be inclusive
	 movsd	b
	 addr	4(r2),m_link
	 bicpsrb flag_f
	endif

	restore	[r0,r1,r2]
	ret


;Make more room in link buffer if needed
;FS on exit if not at least 100H bytes left

lnk_spac::
	save	[r0,r1]
	movd	m_lnkptr,r1	;Next available address
	addd	h'100,r1	;Need some extra
	bicpsrb	flag_f		;Assume OK for now
	cmpd	r1,t_symbl	;See if there's already room
	if	gt
	 movd	h'600,r0	;No room, move everything up
	 movd	r0,tos
	 bsr	chk_mem
	quit	fs		;No room for move if FS
	 save	[r2]
	 movd	tsym_end,r1	;Last address to move
	 bicb	3,r1		;Backup to last Dword to move
	 addd	r0,tsym_end	;Advance all pointers
	 addd	r0,msym_end
	 movd	r1,r2
	 addd	r0,r2		;Target address for move
	 movd	r1,r0
	 subd	t_symbl,r0	;First address to move
	 lshd	-2,r0		;Number of Dwords
	 addqd	1,r0		;Count must be inclusive
	 movsd	b
	 addr	4(r2),t_symbl
	 restore [r2]
	 bicpsrb flag_f
	endif
	restore	[r0,r1]
	ret


;Add to string table
;Length, String pointer on stack
;FS on exit if no more room

put_str::
	lproc
slen:	blkb	4		;Length of string
ptr:	blkb	4		;Pointer to string
	reg	[r0,r1,r2]
	code
	movd	slen,tos
	bsr	str_spc

	if	fc		;OK to install if FC
	 movd	slen,r0
	 movd	ptr,r1
	 movd	m_strptr,r2	;Target for move
	 movsb
	 movd	r2,m_strptr	;Update pointer
	end

	pend


;Add to string symbol table
;Symbol table Pointer, Length, String pointer on stack
;FS on exit if no more room

str_lbl::
	lproc
sym:	blkb	4		;Offset of symbol
slen:	blkb	4		;Length of string
ptr:	blkb	4		;Pointer to string
	reg	[r0,r1,r2,r3,r4]
	code

	addd	t_symbl,sym	;Make absolute address
	extsb	1(sym),r3,b_size-8,4 ;String type
	extsb	(sym),r4,b_typ,2 ;Temporary status
	movd	m_strptr,r2	;Current pointer
	cmpqb	2,m_pass
	if	ne
	 movd	slen,tos
	 movd	ptr,tos
	 subd	t_symbl,sym	;Convert back to offset
	 bsr	put_str		;Symbol table might be moved up
	 addd	t_symbl,sym	;Make absolute again
	 if	fc
	  cmpb	b'1000,r3	;See if length included in table
	  if	eq
	   movw	slen,2(sym)
	   movd	r2,4(sym)
	  else
	   movd	r2,2(sym)	;Store symbol table pointer
	  endif
	  sbitb	b_def,(sym)	;Now defined
	  bicpsrb flag_f
	 endif
	else
	 tbitb	b_def,(sym)
	orif	fc		;Define if not done already
	 cmpb	lbl_tmp,r4
	orif	eq
	 cmpb	b'1000,r3	;See if length included in table
	 if	eq
	  movzwd 2(sym),r0	;Stored length
	  movd	4(sym),r1	;Stored text
	 else
	  movd	2(sym),r1	;Stored text
	  movd	slen,r0		;Stored length length
	 endif
	 cmpw	r0,slen		;Compare strings, they must match
	 if	ne
	  bsr	sym_rdf:d
	 else
	  movd	ptr,r2
	  cmpsb
	 orif	ne
	 endif
	 bicpsrb flag_f
	endif

	pend


;Search symbol table and display name if found
;R5 holds value of symbol, R6 holds type

sym_r5::
	save	[r2,r3,r5]
	cmpb	h'b,r6
	if	eq		;Subtract M_PCOFST if this is PC relative
	 subd	m_pcofst,r5
	endif
	movd	r1,tos
	movd	r0,tos
	addr	r1[r0:b],r2	;Target for name

	cmpb	8,r6		;Check for FP
	if	ne
	 bsr	val2sym		;Search for symbol table match
	else
	 cmpqd	-1,m_fpofst
	orif	eq		;Can't search if nothing there
	 movqd	-1,m_symadr	;Default to none
	 save	[r2,r3]
	 movd	m_fpofst,r2	;Absolute base address
	 begin
	  cmpd	tsym_end,r2
	 quit	ls
	  extsb	sidx_of+1(r2),r3,b_mode-8,4
	  cmpb	8,r3		;Must be FP mode
	 quit	ne
	  addr	sidx_of(r2),m_symadr ;Closest thing so far
	  cmpd	sidx_of+2(r2),r5 ;Keep looking if too big
	 while	gt
	  extsd	sidx_of(r2),r3,0,5 ;Length of name
	  addd	sidx_of+2+4,r3
	  addd	r3,r2
	 endw
	 restore [r2,r3]
	endif

	cmpqd	-1,m_symadr
	if	eq		;No match at all if EQ
	 movd	tos,r0
	 movd	tos,r1
	else			;Got an exact or near match
	 movd	tos,r3		;Original R0
	 extsd	(m_symadr),r0,0,5 ;Length of name
	 addr	6(m_symadr),r1	;Pointer to symbol
	 addd	r0,r3		;Length of symbol name
	 
	 movb	"<",(r2)
	 addqd	1,r2
	 addqd	1,r3		;length of <
	 movsb			;Move into place
	 movd	tos,r1		;Pointer back to R1
	 movd	r3,r0		;Length back to R0
	 
	 subd	2(m_symadr),r5	;Offset to actual value
	 cmpqd	0,r5		;Check for exact match
	 if	ne		;Additional offset needed if NE
	  if	le		;Need leading "+" if positive
	   movb	"+",r1[r0:b]
	   addqd 1,r0
	  endif
	  bsr	sgn_asci:d
	 endif
	 movb	">",r1[r0:b]
	 addqd	1,r0
	endif

	restore	[r2,r3,r5]
	ret	0


;Search symbol table for value match
;R5=value, R6=symbol code
;M_SYMADR holds absolute address of closest symbol address <= R5,
;M_SYMADR = -1 if nothing comes close

val2sym::
	movd	msym_beg,r1	;Start of symbols for this module
	addd	t_symbl,r1	;Start of symbol table
	movqd	-1,m_symadr	;Nothing yet
val2sym1::
	cmpd	r1,msym_end
	bhs	return		;End of the line if HS

;Still coming, check attributes

	extsd	sidx_of+1(r1),r0,b_mode-8,4
	cmpb	r0,r6
	if	eq
	 tbitb	b_def,sidx_of(r1)
	 if	fs		;Can't compare undefined symbols
	  cmpd	r5,sidx_of+2(r1) ;Still more symbols, check value
	  if	hs
	   cmpqd -1,m_symadr
	   if	eq
	    addr sidx_of(r1),m_symadr ;Closest thing so far with same mode
	   else
	    cmpd sidx_of+2(r1),2(m_symadr) ;Must also be > previous value
	   orif	hi
	   endif
	  endif
	  cmpd	r5,sidx_of+2(r1) ;Done if exact match
	  beq	return		;Got exact match if EQ
	 endif
	endif

	addqd	sidx_of,r1	;Two more for sort pointers
	bsr	lbl_len		;Get length of label in R0
	addd	r0,r1		;Advance past name

	br	val2sym1


mem_ovfl::
	sbitb	31,m_errct	;Force overflow
	bsr	dsp_msg:d
	byte	"Out of memory",cr,lf,0
	bispsrb	flag_f
	ret

;Type mismatch in stack operation

typ_er1::
	movw	h'ff lsh b_mode,(r5) ;Make undefined
type_err::
	addqd	1,m_errct
	bsr	dsp_msg
	db	"Data type mismatch",cr,lf,0
	ret

sym_und::
	bsr	dsp_msg
	db	"Symbol",0
sym_und1::
	addqd	1,m_errct
	bsr	dsp_msg
	.byte	" undefined",cr,lf,0
	ret	0

prm_ovfl::
	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Invalid parameter or value out of range",cr,lf,0
	ret	0

dup_sym::
	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Duplicate symbol",cr,lf,0
	ret	0

bad_txt::
	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Invalid or missing operand",cr,lf,0
	bispsrb	flag_f		;Flag must be set because of error
	ret	0

;Addressing mode mismatch between passes

mod_er::
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Addressing mode changed",cr,lf,0
	ret

sym_rdf::
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Redefined symbol",cr,lf,0
	br	return

	disp	2

;Delimiter and translation table

t_delim::
	;    ^@     ,^A     ,^B     ,^C     ,^D     ,^E     ,^F     ,^G
	byte trm_nul,trm_nul,trm_nul,trm_nul,trm_fil,trm_nul,trm_nul,trm_nul
	;    ^H     ,TAB     ,LF    ,^K     ,^L     ,CR    ,^N     ,^O	
	byte trm_nul,trm_blnk,trm_cr,trm_nul,trm_nul,trm_cr,trm_nul,trm_nul
	;    ^P     ,^Q     ,^R     ,^S     ,^T     ,^U     ,^V     ,^W
	byte trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul
	;    ^X     ,^Y     ,^Z     ,ESC    ,^\     ,^]     ,^^     ,^_
	byte trm_nul,trm_nul,trm_fil,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul
	;    " "     ,!         "# ,$       ,%       ,&       , '
	byte trm_blnk,trm_str,$'"#',trm_inst,trm_inst,trm_inst,"'"
	;    (      ,)      ,*      ,+      ,,      ,-      , . ,/   
	byte trm_exp,trm_exp,trm_wrd,trm_wrd,trm_exp,trm_wrd,".",trm_wrd
	;     0123456789 ,:      ,;      ,<      ,=      ,>      , ?
	byte "0123456789",trm_exp,trm_lin,trm_wrd,trm_exp,trm_wrd,"?"
	;
	byte "@ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,[      , \ ,]      ,^       , _
	byte "PQRSTUVWXYZ",trm_exp,"\",trm_exp,trm_inst,"_"
	;
	byte "`ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,{      ,|      ,}      , ~ ,DEL
	byte "PQRSTUVWXYZ",trm_lin,trm_lin,trm_lin,"~",h'7f

;Table for quick conversion when translation not required
;Line terminators translate to 0, quotes, ;, { too
;Lower case converted to upper
;Invalid characters translate to blanks
;All other characters as is

t_delim2::
	;     ^@, ^A ,^B ,^C ,^D ,^E ,^F ,^G
	byte " "," "," "," ", 0 ," "," "," "
	;    ^H ,TAB,LF ,^K ,^L ,CR ,^N ,^O	
	byte " ",9  ,10 ," "," ",0  ," "," "
	;    ^P ,^Q ,^R ,^S ,^T ,^U ,^V ,^W
	byte " "," "," "," "," "," "," "," "
	;    ^X ,^Y ,^Z ,ESC,^\ ,^] ,^^ ,^_
	byte " "," ",0  ," "," "," "," "," "
	;    " ", ! ,", # ,  $%& ,'
	byte " ","!",0,"#",$"$%&",0
	;
	byte "()*+,-./"
	;     0123456789: ,;, <=>?
	byte "0123456789:",0,$"<=>?"
	;
	byte "@ABCDEFGHIJKLMNO"
	;
	byte "PQRSTUVWXYZ[\]^_"
	;
	byte "`ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,{,|   }~ ,DEL
	byte "PQRSTUVWXYZ",0,0,$"}~",h'7f

	cond	nscgnx
nsc_dlm:
	;    ^@     ,^A     ,^B     ,^C     ,^D     ,^E     ,^F     ,^G
	byte trm_nul,trm_nul,trm_nul,trm_nul,trm_fil,trm_nul,trm_nul,trm_nul
	;    ^H     ,TAB     ,LF    ,^K     ,^L     ,CR    ,^N     ,^O	
	byte trm_nul,trm_blnk,trm_cr,trm_nul,trm_nul,trm_cr,trm_nul,trm_nul
	;    ^P     ,^Q     ,^R     ,^S     ,^T     ,^U     ,^V     ,^W
	byte trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul
	;    ^X     ,^Y     ,^Z     ,ESC    ,^\     ,^]     ,^^     ,^_
	byte trm_nul,trm_nul,trm_fil,trm_nul,trm_nul,trm_nul,trm_nul,trm_nul
	;    " "     ,!        " ,#      , $ ,%      ,&      , '
	byte trm_blnk,trm_str,'"',trm_lin,"$",trm_wrd,trm_wrd,"'"
	;    (      ,)      ,*      ,+      ,,      ,-      , . ,/   
	byte trm_exp,trm_exp,trm_wrd,trm_wrd,trm_exp,trm_wrd,".",trm_wrd
	;     0123456789 ,:      , ; ,<      ,=      ,>      , ?
	byte "0123456789",trm_exp,";",trm_wrd,trm_exp,trm_wrd,"?"
	;
	byte "@ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,[      , \ ,]      ,^      , _
	byte "PQRSTUVWXYZ",trm_exp,"\",trm_exp,trm_wrd,"_"
	;
	byte "`ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,{      ,|      ,}      ,~      ,DEL
	byte "PQRSTUVWXYZ",trm_lin,trm_wrd,trm_lin,trm_wrd,h'7f

nsc_dlm2:
	;     ^@, ^A ,^B ,^C ,^D ,^E ,^F ,^G
	byte " "," "," "," ", 0 ," "," "," "
	;    ^H ,TAB,LF ,^K ,^L ,CR ,^N ,^O	
	byte " ",9  ,10 ," "," ",0  ," "," "
	;    ^P ,^Q ,^R ,^S ,^T ,^U ,^V ,^W
	byte " "," "," "," "," "," "," "," "
	;    ^X ,^Y ,^Z ,ESC,^\ ,^] ,^^ ,^_
	byte " "," ",0  ," "," "," "," "," "
	;    " ", ! ,",#,  $%& ,'
	byte " ","!",0,0,$"$%&",0
	;
	byte "()*+,-./"

	byte "0123456789:;<=>?"
	;
	byte "@ABCDEFGHIJKLMNO"
	;
	byte "PQRSTUVWXYZ[\]^_"
	;
	byte "`ABCDEFGHIJKLMNO"
	;     PQRSTUVWXYZ ,{,  |}~ ,DEL
	byte "PQRSTUVWXYZ",0,$"|}~",h'7f

	cend

;End of DAT32
