	print	"CMD32"

;Command routines for MON32

;Exit to Kotekan operating system

do_kotkn:
	bsr	sys_xit:d
	br	error		;In case it returns


;System setup

sys_set:
	lproc
	reg	[]
buf:	ds	10
	code

	bsr	dsp_msg:d
	db	"Baud rate in decimal for main serial port: ",0
	movqd	7,r0		;7 digit max
	addr	buf,r1
	bsr	lin_ins:d	;Get input
	bsr	do_cr:d		;Line input echos CR only
	movw	m_radix,tos
	inssb	10,m_radix,0,5
	bsr	exp_gen
	movw	tos,m_radix
	if	fs
	 bsr	error
	else
	 movzbd	dev_smv,r6
	 bsr	set_baud:d
	endif
	
	pend

;Symbol table output/input/display

do_symbl:
	cmpb	"O",(r1)
	beq	lst_labl:d	;Output whole table if YO
	cmpb	"I",(r1)	;Check for input
	if	eq
	 addqd	1,r1
	 
	 bsr	next:d		;Advance to 1st parameter
	 bfs	error
	 bsr	exp_gen		;New M_PCOFST
	 bfs	error
	 movd	r5,m_pcofst
	 
	 save	[r0,r1]
	 movd	m_lnkptr,tos
	 movqw	0,m_opcod
	 bsr	era_mod:d	;Clear last module if empty
	 movd	tos,m_lnkptr
	 
	 movd	mod_indx,r0
	 movd	r0,lmod		;Current module
	 muld	mod_tsiz,r0	;Offset to current MOD_TABL entry
	 addr	mod_tabl[r0:b],r1
	 movqd	0,(r1)		;PC size
	 movqd	0,4(r1)		;SB size
	 movqw	-1,4+4(r1)	;Initial data index
	 movd	tsym_end,r0
	 subd	t_symbl,r0	;Offset to 1st symbol entry for this module
	 movd	r0,msym_beg	;Start of this module's symbols
	 movd	r0,4+4+2(r1)	;Store offset - pad upper bits with 0
	 movd	sidx_end,4+4+2+sidx_of(r1) ;Offset to name (padded with 0s)
	 movd	r5,4+4+2+2*sidx_of(r1) ;M_PCOFST for this module
	 movd	r5,4+4+2+2*sidx_of+4(r1) ;Starting PC
	 movqd	-1,4+4+2+2*sidx_of+4+4(r1) ;Starting SB
	 movqd	-1,4+4+2+2*sidx_of+4+4+4(r1) ;Starting MOD
	 movqd	-1,4+4+2+2*sidx_of+4+4+4+4(r1) ;Starting LINK
	 
	 addqd	1,mod_indx
	 restore [r0,r1]
	 
	 bsr	comma:d
	 bne	error
	 bsr	get_devic
	 movd	r5,r1		;Base address
	 
	 proc
	 reg	[]
buf:	 ds	buf_siz+2	;Input buffer for serial input
buf2:	 ds	buf_siz+2
	 code
	 
	 movqb	1,m_pass	;Evaluate as if 1st pass
	 movqd	0,msym_beg
	 movd	tsym_end,msym_end
	 begin
	  cmpqd	0,r6		;Read a line if necessary
	  if	ne
	   addr	buf,r1
	   movzwd buf_siz+1,r0	;Max input length with CR
	   bsr	blk_in:d
	  endif
	  save	[r1]
	  bsr	nxt_lin:d	;FS if end of file or no CR
	  restore [r1]
	 while	fc
	  addr	buf2,r2
	  bsr	bld_lin:d
	  addr	buf2,r1		;Use translated line now
	  bsr	length:d
	  cmpqd	0,r0		;Nothing in column 1 if length is 0
	  if	ne
	   bsr	sym2val:d	;Pointer to symbol in R2, prev. pointer in R3
	   if	eq		;Symbol found if EQ
	    bsr	dup_sym:d
	    save [r0,r1]
 	    bsr	str_out:d
	    restore [r0,r1]
	    bsr	do_cr:d
	   else
	    movb r0,tos		;Length of name
	    movw exp b_def+(h'2b lsh b_mode),tos ;Defined, variable length
	    movd r1,tos		;Pointer to name
	    movd r3,tos		;Address of previous symbol
	    bsr	make_sym:d
	    addd r0,r1		;Skip over name
	    movd m_symadr,r2	;Address of symbol name in table
	    addd t_symbl,r2	;Convert to absolute address
	    cmpw "::",(r1)
	    if	eq
	     inssb lbl_glb,(r2),b_typ,2
	     addqd 2,r1		;Skip over ::
	    endif
	    bsr	next:d
	    if	fc
	     cmpd "MACR",(r1)	;Can't evaluate if macro
	     if	eq
	      andb h'1f,(r2)	;Only save name length
	      movqb -1,b_mode/8(r2) ;Undefined type
	     else
	      cmpd "EXTE",(r1)	;No value if external
	      if eq
	       andw h'1f,(r2)	;Only save name length
	       orw lbl_ext lsh b_typ+h'2b00,(r2)
	      else
	       movzbd pso_equ:#,r3
	       save [r6]
	       bsr do_equ:d	;Store value of symbol
	       restore [r6]
	      endif
	     endif
	    endif
	   endif
	  endif
	  bsr	nxt_lin:d	;FS if end of file or no CR
	  cmpqd	0,r6
	  if	ne
	   bsr	dev_on:d	;Re-enable transmission
	  endif
	 endw
	 
	 cmpqd	0,r6
	 if	ne		;Re-enable and close device if NE
	  bsr	dev_on:d
	  bsr	dev_clos:d
	 endif
	 pend
	else			;Displaying label
	 bsr	next:d
	 if	fs		;Nothing found if FS 
	  extsd	sym_last,r3,0,sidx_bit
	  cmpd	sidx_end,r3	;End of the line if LS
	  if	eq
	   addr t_symalf+sidx_of*(13*("Z"-"A"+1)-1),r4 ;Last valid entry
	   movd	sym_last+4,r3	;Current T_SYMALF pointer
	   until ne
	    cmpd r3,r4
	   quit	hs
	    addqd sidx_of,r3	;Next T_SYMALF
	    extsd (r3),r2,0,sidx_bit ;Index to next value
	    movd r2,sym_last	
	    movd r3,sym_last+4
	    cmpd sidx_end,r2
	   endu
	  else
	   addd	t_symbl,r3	;Point to last symbol
	   cmpd	tsym_end,r3
	  orif	eq
	   extsd (r3),r2,0,sidx_bit
	   cmpd	sidx_end,r2
	  orif	eq
	   extsd (r3),sym_last,0,sidx_bit
	  endif
	 else
	  movd	t_symfp,tos
	  movd	t_symlcl,tos
	  movd	msym_beg,tos
	  movd	msym_end,tos
	  movd	sidx_end,t_symfp
	  movd	sidx_end,t_symlcl ;Don't want local symbols here
	  movqd	0,msym_beg
	  movd	tsym_end,msym_end ;Search entire table
	  bsr	length:d	;Need length in R0
	  bsr	sym2val:d	;Pointer to symbol in R2, prev. pointer in R3
	  movd	tos,msym_end
	  movd	tos,msym_beg
	  movd	tos,t_symlcl
	  movd	tos,t_symfp
	  movd	m_symadr,sym_last
	  addqd -sidx_of,sym_last ;Must point to pointer
	  movd	m_symalf,sym_last+4 ;Update this
	  cmpd	tsym_end,r2
	 orif	eq		;Something found if NE
	 endif
	 extsd	sym_last,r2,0,sidx_bit
	 cmpd	sidx_end,r2
	 if	eq
	  bsr	dsp_msg:d
	  db	"No symbol",cr,lf,0
	 else
	  addd	t_symbl,r2	;Next symbol in line
	  cmpd	tsym_end,r2
	 orif	eq
	  bsr	dsp_symbl:d
	 endif
	endif
	ret


;Join one device to another device

do_join:
	bsr	dev_out:d	;Get output code in R6
	bfs	error
	cmpqb	0,r6
	beq	error		;Not a device if 0
	cmpqd	0,r0
	bne	error		;No file name
	movd	r6,r3

	bsr	next:d
	cmpb	"=",(r1)
	bne	error
	addqd	1,r1
	bsr	dev_out:d	;Target output device
	bfs	error
	cmpqb	0,r6
	beq	error
	cmpqd	0,r0		;No file names
	bne	error

	movd	r3,r0		;Device to re-route
	movd	r3,r1		;Undo any current assignment
	bsr	dev_rte:d
	movd	r6,r1
	bsr	dev_rte:d	;Re-route output
	addqb	1,r0		;Advance to input device
	movd	r0,r1
	bsr	dev_rte:d	;Cancel any input routing
	addr	1(r6),r1
	br	dev_rte:d	;Re-route input


;Wait for keypress, abort command line if "X" pressed

get_paus:
	bsr	pause:d
	sfsb	lin_abt		;Set abort flag if FS
	ret

;Window select, window number 0-max
;W# starting col, starting row, ending col, ending row

do_wndw:
	bsr	next:d
	bfs	error
	movzbd	(r1),r5
	bsr	hex_dig:d	;Get window number in R5
	bfs	error
	cmpb	win_max:#,r5	;Max window size
	bls	error

	addqd	1,r1
	bsr	next:d
	bfs	set_wndw:d	;Just switch if no new parameters

	movd	r5,r0		;Window number
	cmpb	"=",(r1)
	if	eq
	 cmpqb	1,r5		;If window 1 then enable command input
	 if	eq
	  sbitb	0,m_win1	;Use window 1 for commands
	 endif
	 addqd	1,r1
	 bsr	exp_gen
	 bfs	error
	 movb	r5,r2		;Starting column
	 bsr	comma:d
	 bne	error
	 bsr	exp_gen
	 bfs	error
	 movb	r5,r3		;Starting row
	 bsr	comma:d
	 bne	error
	 bsr	exp_gen
	 bfs	error
	 movb	r5,r6		;Column count
	 bsr	comma:d
	 bne	error
	 bsr	exp_gen		;Row count
	 bfs	error
	else
	 cmpb	"X",(r1)	;Check for window cancel
	 bne	error
	 cmpqb	1,r5		;If window 1 then disable command input
	 if	eq
	  cbitb	0,m_win1	;Use window 1 for commands
	 endif
	 movqd	0,r2		;Starting column
	 movqd	0,r3		;Starting row
	 movzbd	80,r6		;Column count
	 movzbd	24,r5		;Row count
	endif

	movb	r5,tos		;Row count
	movb	r6,tos		;Column count
	movb	r3,tos		;Absolute upper left row
	movb	r2,tos		;Absolute upper left column
	movd	r0,r5		;Window number
	bsr	new_wndw:d
	ret


;Display menu

do_menu:
	bsr	dsp_msg:d
 byte "<A>ssemble: Source address/Device, Object address, Mod address/Device",cr,lf
 byte "   AL: List; A2: 2 pass; AC: Cross reference; AX resets",cr,lf
 db   "   AI Object address: assemble immediate key input",cr,lf
 byte "<B>reakpoint: {0-F}=Address, Count, Condition test, Command",cr,lf
 byte "<C>alculate: Expression",cr,lf
 byte "<D>isplay: Starting address, Byte count",cr,lf
 byte "   DB: bytes; DW: words; DD: Dwords; DA: ASCII; DF: float; DL: long",cr,lf
 byte "<E>dit: Address=New value/String; Address only does continuous edit",cr,lf
 byte "<F>ill: Starting address, Byte count, Fill character",cr,lf
 byte "<G>o: Breakpoint 1, Breakpoint 2",cr,lf
 byte "<H>ex file I/O",cr,lf
 byte "   HI: ASCII hex file address/Device, Target address for object code",cr,lf
 byte "   HO: Starting address, Ending address, Device",cr,lf
 byte "<I>mmediate execution: Opcode/Pseudo-op",cr,lf
 db   "<J>oin Device=Device",cr,lf
	cond op_sys
	 db   "<K>otekan (exit to system)",cr,lf
	cend
 byte "<L>ist: Starting address, Instruction count",cr,lf
 byte "   LD list/display hex object code; LN lists only",cr,lf
 byte "<M>ove: Source address, Target address, Count",cr,lf
	cond	w_mmu
 db   "  MM{U,S}: Virtual address, Physical address, Size, {V,SR,SW,UR,UW"
	 cond	cpu532
	  db	$",CI"
	 cend
	 db	"}",cr,lf
	cend

 byte "L<o>ok: Starting address, Ending address, String to look for",cr,lf

	db	0		;End message
	bsr	pause:d
	bfs	return:d	;Quit now if "X" terminates
	bsr	dsp_msg:d

 byte "<P>ort IO",cr,lf
 db   "   PI: Device, Address; PO: Starting address, Ending address, Device",cr,lf
 db   "<Q>uick setup: QR Module: Set CPU registers for module",cr,lf
 db   "   QD Module: Display module map; QD: Display all modules",cr,lf
 db   "   QM Module=MOD table address: Set internal parameters",cr,lf
 byte "<R>egister: Register=New value; Register name only displays",cr,lf
 byte "   RF: All FPU registers"
	cond	w_mmu
	 db	"; RM: All MMU registers"
	cend
	cond	cpu532
	 db   "; RD: All Debug registers"
	cend
	db	cr,lf
	cond	don
	 db   "<RESET>; RESET R uses displayed register values",cr,lf
	cend
 db   "<S>ystem setup",cr,lf
 byte "<T>race: Count, Condition test, Command",cr,lf
 db   "   TS traces sequential opcodes; TN traces non-sequential",cr,lf
 byte "<U>ntrace: display backtrace buffer",cr,lf
 byte "   U=Count sets current count; U Count displays",cr,lf
 byte "<V>alidate (test) memory: Starting address, Ending address",cr,lf
 byte "<W>indow: {0-7}=Beg. col, Beg. row, Col count, Row count",cr,lf
 byte "   W {0-7} switches to new window",cr,lf
 db   "   W {0-7} X resets window to full screen",cr,lf
 db   "E<x>it or continue command line according to keypress",cr,lf
 db   "S<y>mbol table I/O, display",cr,lf
 db   "   YO outputs; YI PC addr, Address/Device loads table",cr,lf
 db   "   Y Label displays",cr,lf
 byte "<Z>ap (clear) currently selected window",cr,lf

	db	0		;End message 
	ret

;Validate (test) memory
;V (starting address, ending address)

do_val:

;Load 2 parameters into R4 and R5

	bsr	next:d		;Advance to 1st parameter
	bfs	error
	bsr	exp_gen
	bfs	error
	movd	r5,r4		;Base address

	bsr	comma:d
	bne	error
	bsr	exp_gen
	bfs	error

;1st address in R4, last in R5

	subd	r4,r5		;Count in R5
	addqd	1,r5		;Make count inclusive
	divd	4,r5		;Divide by 4 to get Dwords
	cmpqd	1,r5
	bgt	error		;Must be positive and >0
	movd	r5,r0		;Count to R0
	movqd	0,r6		;Error counter

	until	eq
	 movd	(r4),r3		;Save original value
	 comd	r3,(r4)		;Write complemented value
	 movd	(r4),r2		;Read back complemented value
	 movd	r3,(r4)		;Restore original
	 comd	r3,r3		;This is the value written
	 cmpd	r2,r3		;Check for a match
	 if	ne
	  bsr	dsp_msg:d
	  byte	cr,lf,"Error at address ",0
	  movd	r4,r5
	  bsr	dsp_r5:d
	  bsr	dsp_msg:d
	  byte	" - Wrote ",0
	  movd	r3,r5
	  bsr	dsp_r5:d
	  bsr	dsp_msg:d
	  byte	", Read ",0
	  movd	r2,r5
	  bsr	dsp_r5:d

;Increment error count, pause for keypress if multiple of 20

	  addqd	1,r6		;Increment error counter
	  movd	r6,r7
	  modd	20,r7
	  cmpqd	0,r7
	  if	eq
	   bsr	do_cr:d
	   bsr	pause:d
	   bfs	val_x		;Abort now if FS
	  end
	 end
	 addqd	4,r4		;Advance pointer
	 addqd	-1,r0		;Decrement count
	 cmpqd	0,r0
	end

;Display error count

val_x:
	bsr	dsp_msg:d
	byte	cr,lf,"Total errors: ",0
	movd	r6,r5
	bsr	dsp_r5:d
	bsr	do_cr:d
	ret


;Hex file input or output
;HI (memory address/device, target address for code)
;HO (first address, last address to output, device)

do_hex:	movb	0(r1),r7	;Save I/O command
	addqd	1,r1

;Load 2 parameters into R4 and R5

	bsr	get_devic
	cmpb	"O",r7		;Output must be from memory
	if	eq		;Output always requires address
	 cmpqd	0,r6
	 bne	error
	endif
	movd	r5,r4		;Base address

	bsr	comma:d
	bsr	exp_gen
	bfs	error

	cmpb	"I",r7
	beq	dohx_in

;If "O then output

	cmpb	"O",r7
	bne	error

;1st address in R4, last in R5

	subd	r4,r5		;Count in R5
	addqd	1,r5		;Make count inclusive
	cmpqd	1,r5
	bgt	error		;Must be positive and >0
	movd	r5,r3		;Count to R3
	bsr	comma:d
	bsr	devic_out
	bfs	error
	cmpqd	0,r6
	beq	error		;Must be device

	proc
	reg	[]
buf:	blkb	100
ptr:	blkd			;Pointer to start of line
	code

	movd	r4,ptr		;Base pointer

;Output loop
;R4=address, R3=byte count, R6=device

dohexo1:
	addr	buf,r1		;Build string here
	movqd	0,r0		;Length of string
	movqd	0,r7		;Initialize checksum

;Get length of current line, default=H'20

	movzbd	h'20,r2
	subd	r2,r3
	cmpqd	0,r3
	ble	dohexo3		;Still plenty left if >0

;Only a partial line remains

	addd	r3,r2		;Remaining count
	movqd	0,r3		;Nothing left

;Ready to build one line

dohexo3:
	movb	":",r1[r0:b]
	addqd	1,r0

;Put in byte count

	movb	r2,r5
	subb	r5,r7		;Update checksum
	bsr	byt_1r5:d

;Calculate address

	movd	r4,r5		;Current address
	subd	ptr,r5		;Current-initial
	bsr	byt_2r5:d
	subb	r5,r7		;LSB of address
	lshw	-8,r5		;MSB to LSB
	subb	r5,r7		;Subtract MSB

;Status byte

	movw	"00",r1[r0:b]
	addqd	2,r0

;Ready for actual data now

dohexo4:
	movb	0(r4),r5
	bsr	byt_1r5:d
	addqd	1,r4
	subb	r5,r7		;Update checksum
	acbb	-1,r2,dohexo4

;Data done, do checksum

	movb	r7,r5
	bsr	byt_1r5:d
	movw	l'0d0a,r1[r0:b]	;CR/LF
	addqd	2,r0
	movqd	0,r5		;Not binary, no eof termination
	bsr	wrt_file:d	;Send current line

	cmpqd	0,r3
	bne	dohexo1		;Keep going if more

;All done, transmit final line

	addr	buf,r1
	movd	":000",0(r1)
	movd	"1FF",4(r1)
	movw	l'0d0a,7(r1)	;CR/LF
	movzbd	9,r0
	movqd	0,r5
	bsr	wrt_file:d	;Send last line

	pend

	br	dev_clos:d


;ASCII file read in, convert to hex and check checksum
;R4 holds address of file, R5 holds target address for code, R6 holds device

dohx_in:
	proc
	reg	[]
buf:	ds	100		;Input buffer for serial input
typ:	ds	1		;Line type designation
	code

	movd	r4,r1		;Pointer in R1 if no device
	movd	r5,r4		;Base offset to R4

	begin
	 cmpqd	0,r6		;Read a line if necessary
	 if	ne
	  addr	buf,r1
	  movzbd 80,r0		;Max input length with CR
	  bsr	blk_in:d
	 endif
	 
	 movb	(r1),typ	;Save line type, Intel hex or TDS hex
	 bicpsrb flag_f		;Assume all correct for now
	 cmpb	"<",(r1)	;TDS final line designation
	 if	eq
	  movqd	0,r2
	 else
	  cmpb	">",(r1)	;TDS data line
	  if	eq
	   movzbd 16,r2		;16 bytes follow
	   addqd 1,r1		;Point to data
	   movd	r4,r3		;Current target address
	   bicpsrb flag_f	;OK
	  else
	   cmpb	":",0(r1)	;Intel hex starts with a :
	   if	eq
	    addqd 1,r1
	    movqd 0,r7		;Initialize checksum
	    bsr	hex2dig:d	;Get a byte in R5
	   quit	fs
	    movb r5,r2		;Get byte count in R2
	    subb r2,r7		;Update checksum
	    cmpqb 0,r2		;See if anything follows
	    if	ne
	     bsr hex4dig:d
	    quit fs
	     movzwd r5,r3	;Current offset
	     addd r4,r3		;Add base address to offset
	     subb r5,r7
	     lshw -8,r5		;MSB to LSB
	     subb r5,r7
	     bsr hex2dig:d	;Get status byte
	    quit fs
	     subb r5,r7		;Update checksum
	    endif
	   endif
	  endif
	 endif
	quit	fs		;Error if FS
	 
	 cmpqb	0,r2		;Done if count is 0
	while	ne
	 until	eq		;Ready for actual data now
	  bsr	hex2dig:d
	 quit	fs
	  movb	r5,0(r3)
	  subb	r5,r7
	  addqd	1,r3
	  addqb	-1,r2		;Clears F
	  cmpqb	0,r2
	 endu
	quit	fs
	 
	 cmpb	":",typ		;Check for Intel hex
	 if	eq
	  bsr	hex2dig:d	;Data done, do checksum
	 quit	fs
	  cmpb	r5,r7
	  if	ne		;Checksum error if NE
	   bispsrb flag_f
	  endif
	 else
	  movd	r3,r4		;Advance target pointer
	  bicpsrb flag_f
	 endif
	quit	fs
	 cmpb	cr,0(r1)
	quit	ne
	 addqd	1,r1
	 cmpb	lf,(r1)
	 if	eq
	  addqd	1,r1
	 endif
	 cmpqd	0,r6
	 if	ne
	  bsr	dev_on:d	;Re-enable transmission
	 endif
	qend
	 bsr	dsp_msg:d
	 db	cr,lf,"Error in hex file!",cr,lf,0
	endw

	cmpqd	0,r6
	if	ne		;Re-enable and close device if NE
	 bsr	dev_on:d
	 bsr	dev_clos:d
	endif
	pend
	ret


;Look for string in memory
;Starting address, Ending address, Search string

do_o:	movd	mlk_beg,r2	;Default beginning address
	bsr	next:d		;Advance to 1st parameter
	if	fc
	 cmpb	",",(r1)
	 if	ne
	  bsr	exp_gen		;Get first address in R5
	  bfs	error
	  movd	r5,r2		;Start to R2
	 endif
	endif

	movd	mlk_end,r3	;Default ending address
	bsr	comma:d
	if	fc
	 bne	error		;Must have been comma if more
	 cmpb	",",(r1)
	 if	ne
	  bsr	exp_gen
	  bfs	error
	  movd	r5,r3		;Last address
	 endif
	endif
	cmpd	r2,r3		;R2 must be less than R3
	bhs	error
	
	movzbd	10,r5
	bsr	aray_r5:d	;Buffer to R5
	bfs	return:d

	movzbw	mlk_str,2(r5)	;Default string length
	addr	mlk_str+1,4(r5)	;Default string pointer
	bsr	comma:d
	if	fc
	 bne	error		;Must be comma if more
	 bsr	ex:d		;Get search string
	 tbitb	b_def,(r5)
	 bfc	error
	 extsb	1(r5),r4,b_mode-8,8 ;Must be string
	 cmpb	h'8c,r4
	 bne	error
	endif
	cmpqw	0,2(r5)		;Length must not be 0
	beq	error
	cmpw	20,2(r5)	;Max length
	if	lo
	 movw	20,2(r5)
	endif
	movd	4(r5),r6	;Search string to (R6)

;Ready to begin search

	movd	r3,mlk_end	;New default last address
	movd	r2,mlk_beg	;New default starting address
	save	[r2]
	movzbd	2(r5),r0	;Length of string
	movb	r0,mlk_str	;New default
	movd	4(r5),r1	;Start of string
	addr	mlk_str+1,r2	;New default string
	movsb
	restore	[r2]

	movd	r2,r1		;Starting address
	begin
	 movb	(r6),r4		;First character to look for
	 movd	r3,r0		;Last address
	 subd	r1,r0		;Search length
	quit	cs		;Quit if entire memory space searched
	 addqd	1,r0		;Length must be inclusive
	 skpsb	u
	while	fs
	 save	[r1]
	 movd	r6,r2
	 movzwd	2(r5),r0	;String length
	 cmpsb
	 restore [r1]
	 if	eq		;Match found if EQ
	  bsr	dsp_msg:d
	  byte	"Match found at ",0
	  movd	r1,r5
	  addqd	1,r1
	  movd	r1,mlk_beg	;New default starting address
	  br	dsp_r5:d
	 else
	  addqd	1,r1		;Try next address
	 endif
	endw

	bsr	dsp_msg:d
	byte	"No match found",0
	ret


;Return value of expression in (R1)
;On exit (R5) holds value, FS if undefined

exp_r1r5:
	movzbd	20,r5
	bsr	aray_r5:d
	bsr	exp_gnsb
	tbitb	b_def,(r5)
	if	fc
	 bispsrb flag_f
	else
	 bicpsrb flag_f
	endif
	ret


;Display result of expression

do_clc:	lproc
	reg	[r0,r1,r5]
bufr5:	blkb	80
prm:	ds	1		;Selected parameter if any
	code

	movb	(r1),prm
	movw	m_radix,tos	;Save current radix
	cbitb	b_asc,m_radix	;Clear ASCII for now
	cmpb	"D",(r1)
	if	eq
	 inssb	10,m_radix,0,5	;Force decimal evaluation and display
	 addqd	1,r1
	else
	 cmpb	"H",(r1)
	 if	eq
	  inssb	16,m_radix,0,5	;Force hex evaluation and display
	  addqd	1,r1
	 else
	  cmpb	"A",(r1)
	  if	eq
	   sbitb b_asc,m_radix
	   cbitb b_sign,m_radix	;Don't alter negative values
	   addqd 1,r1
	  else
	   cmpb	"B",(r1)	;Force binary evaluation and display
	   if	eq
	    inssb 2,m_radix,0,5
	    addqd 1,r1
	   else
	    cmpb "L",(r1)	;Display as label
	    if	eq
	     addqd 1,r1
	    endif
	   endif
	  endif
	 endif
	endif

	bsr	next:d		;R1 => expression
	addr	bufr5,r5
	bsr	exp_gnsb
	cmpb	"L",prm		;See if label display requested
	if	eq
	 movd	r5,r1		;Buffer address to R1
	 movqd	0,r0		;Length to 0
	 extsd	b_mode/8(r5),r6,b_mode-8,4 ;Get mode of symbol
	 cmpqb	4,r6		;Default to PC if nothing else specified
	 if	eq
	  movb	0bh,r6		;Make PC relative
	 endif
	 movd	2(r5),r5	;Value to display
	 cmpb	8,r6		;Check for FP
	 if	eq
	  subd	m_fp,r5
	 endif
	 bsr	sym_mod
	 bsr	str_out:d
	else
	 bsr	fmt_2r5:d	;Display according to TOS
	endif
	movw	tos,m_radix	;Restore original radix
	pend

;Display symbolic name via SYM_R5
;R5 holds value, R6 holds type
;Also set module parameters

sym_mod:
	cmpb	h'b,r6		;Check for PC relative
	if	eq
	 movd	r5,tos
	 bsr	pc_mod
	else
	 cmpb	h'a,r6		;SB relative
	 if	eq
	  movd	r5,tos
	  bsr	sb_mod
	  subd	msb_mod,r5
	 endif
	endif
	br	sym_r5:d


;Fill command (source, count, fill character)

do_fil:	bsr	next:d		;Advance to 1st parameter
	bfs	error
	bsr	exp_gen		;Get source address in R5
	bfs	error
	movd	r5,r7		;Source to R7

	bsr	comma:d
	bne	error
	bsr	exp_gen		;Count in R5
	bfs	error
	cmpqd	0,r5
	beq	error
	movd	r5,r6		;Count to R6
	
	bsr	comma:d
	bne	error
	bsr	exp_gen		;Fill character in R5
	bfs	error
	movb	r5,0(r7)

;Ready to fill

	movd	r7,r1		;Source address to R1
	movd	r6,r0		;Count to R0
	addqd	-1,r0
	cmpqd	0,r0
	beq	return:d	;Done if only 1 byte

	addr	1(r1),r2
	movsb
	ret	0


;Move command (source, destination, count)

do_mov:
	cond	w_mmu
	cmpb	"M",(r1)	;Check for MMU remap
	bne	mov_mem

	cmpb	"U",1(r1)
	if	eq
	 movd	m_pt1,r3	;User space
	else
	 cmpb	"S",1(r1)	;Supervisor space
	 bne	error
	 movd	m_pt0,r3
	endif
	addqd	2,r1

	bsr	next:d		;Advance to 1st parameter
	bsr	exp_gen		;Get source address in R5
	bfs	error
	movd	r5,r7		;Source to R7

	bsr	comma:d
	bsr	exp_gen		;Target in R5
	bfs	error
	movd	r5,r2

	bsr	comma:d
	bsr	exp_gen		;Count in R5
	bfs	error
	movd	r5,r0		;Byte count in R0

;Adjust for page boundaries

	addd	r7,r0		;Last address requested
	cond	cpu532
	 bicw	exp 12-1,r2	;Round down to page boundary
	 bicw	exp 12-1,r7	;Round down to page boundary
	 subd	r7,r0		;Adjusted byte count
	cend
	cond	cpu032
	 bicw	exp 9-1,r2
	 bicw	exp 9-1,r7
	 subd	r7,r0		;Adjusted byte count
	cend

	movqd	0,r4		;Clear options
	bsr	comma:d
	if	fc		;Options if EQ
	 proc
	 reg	[r2]
buf:	  ds	2+4
	 code
	 addr	buf,r6
	 addr	tmmu_op,r2	;Pointer to option list
	 bsr	bit_lst:d
	 movzbd	2(r6),r4	;Options in R4
	 pend
	endif

	cond	cpu532
	 movzbd	22,r6		;Index offset for level 1 tables
	 extd	r6,r7,r6,31-22+1 ;Index to level 1 table
	cend
	cond	cpu032
	 movzbd	16,r6		;Index offset for level 1 tables
	 extd	r6,r7,r6,23-16+1 ;Index to level 1 table
	cend
	addr	r3[r6:d],r6	;Starting address of level 1 table

	save	[r0]		;Total byte count
	movqd	0,r1		;Count in R0/R1
	cond	cpu532
	 deid	1024*exp 12,r0	;Bytes controlled by a level 1 page
	cend
	cond	cpu032
	 deid	128*exp 9,r0	;Bytes controlled by a level 1 page
	cend			;Quotient in R1, remainder in R0
	addqd	-1,r0		;Set carry if not 0
	addcd	0,r1		;Round up if any remainder (Level 1 pages)
	restore	[r0]

	save	[r0,r1,r4,r6]
	cbitb	6,r4		;Clear cache inhibit for level 1
	orb	b'110,r4	;Anything goes in level 1
	begin	
	 cmpqd	0,r1
	while	ne
	 movb	r4,r5
	 andb	(r6),r5		;See if both valid bits set
	 tbitb	0,r5
	 if	fc		;Keep pointer to level 2 if already valid
	  cond	cpu532
	   movd h'fffff000,(r6)	;Invalidate pointer to level 2
	  cend
	  cond	cpu032
	   movd	h'fffe00,(r6)
	  cend
	 endif
	 cond	cpu532
	  inssd	r4,(r6),0,12	;New status bits
	 cend
	 cond	cpu032
	  inssd	r4,(r6),0,9	;New status bits
	 cend
	 addqd	4,r6
	 addqd	-1,r1
	endw
	restore	[r0,r1,r4,r6]

	tbitb	0,r4		;See if valid
	bfc	return:d	;Nothing left to do if not valid

;Get address of last level 2 table in R5

	save	[r0,r3,r6]
	cond	cpu532
	 movd	1024,r0		;Number of level 1 entries
	cend
	cond	cpu032
	 movd	256,r0
	cend
	addr	r3[r0:d],r5	;Next available slot for level 2 table
	until	eq
	 tbitb	0,(r3)
	 if	fs		;Valid table if FS
	  movd	(r3),r6
	  cond	cpu532
	   andd	h'fffff000,r6	;Mask all but pointer to level 2 table
	   cmpd	h'fffff000,r6
	  cend
	  cond	cpu032
	   andd	h'fffe00,r6	;Mask all but pointer to level 2 table
	   cmpd	h'fffe00,r6
	  cend
	  if	ne		;Valid address if NE
	   cmpd	r5,r6		;See if this is a higher address
	   if	ls
	    cond cpu532
	     addr 4*1024(r6),r5	;Next slot is after this block
	    cend
	    cond cpu032
	     addr 4*128(r6),r5	;Next slot is after this block
	    cend
	   endif
	  endif
	 endif
	 addqd	4,r3		;Next level 1 pointer
	 addqd	-1,r0
	 cmpqd	0,r0
	endu
	restore	[r0,r3,r6]	;Next level 2 slot now in R5

;Now setup any new level 2 tables as needed

	save	[r0,r1,r6,r7]
	cond	cpu532
	 movd	h'fffff000,r7	;Invalid level 2 page
	cend
	cond	cpu032
	 movd	h'fffe00,r7	;Invalid level 2 page
	cend
	begin
	 cmpqd	0,r1
	while	ne
	 movd	(r6),r0
	 andd	r7,r0		;Mask all but pointer to level 2 table
	 cmpd	r0,r7		;See if valid but no level 2 address
	 if	eq		;Valid address if NE
	  save	[r0,r1,r2]
	  cond	cpu032
	   inssd 0,1(r6),9-8,23-9+1 ;Clear current pointer
	   ord	r5,(r6)		;Pointer to level 2 table
	   movd 128-1,r0	;Number of level 2 tables
	  cend
	  cond	cpu532
	   inssd 0,1(r6),12-8,31-12+1 ;Clear current pointer
	   ord	r5,(r6)		;Pointer to level 2 table
	   movd	1024-1,r0	;Number of level 2 tables
	  cend
	  movd	r5,r1		;Source address
	  addr	4(r1),r2	;Target address
	  movd	r7,(r1)		;Invalidate entire level 2 table
	  movsd
	  movd	r2,r5		;Next available slot
	  restore [r0,r1,r2]
	 endif
	 addqd	4,r6		;Next level 1 pointer
	 addqd	-1,r1
	endw
	restore	[r0,r1,r6,r7]	;Next level 2 slot now in R5

;Now set up level 2 table addresses
;Byte count in R0, virtual address in R7, physical address in R2

	movd	r0,r5
	cond	cpu532
	 andd	exp 12-1,r5	;Partial page
	 lshd	-12,r0		;Page count
	cend
	cond	cpu032
	 andd	exp 9-1,r5	;Partial page
	 lshd	-9,r0		;Page count
	cend
	addqd	-1,r5		;Set carry if a partial page
	addcd	0,r0		;One more if partial page
	begin
	 cmpqd	0,r0
	while	ne
	 cond	cpu532
	  movd	22,r1
	  extd	r1,r7,r1,31-22+1 ;Level 1 index
	  addr	r3[r1:d],r1	;Address of level 1 table
	  movd	(r1),r1
	  andd	h'fffff000,r1	;Pointer to level 2 table
	  movd	12,r5
	  extd	r5,r7,r5,21-12+1 ;Level 2 index
	  addr	r1[r5:d],r1	;Proper level 2 table
	  movd	r4,(r1)		;Lower bits
	  ord	r2,(r1)		;Physical address
	  addd	4*1024,r2	;Next physical address
	  addd	4*1024,r7	;Next virtual address
	 cend
	 cond	cpu032
	  movd	16,r1
	  extd	r1,r7,r1,23-16+1 ;Level 1 index
	  addr	r3[r1:d],r1	;Address of level 1 table
	  movd	(r1),r1
	  andd	h'fffe00,r1	;Pointer to level 2 table
	  movd	9,r5
	  extd	r5,r7,r5,15-9+1 ;Level 2 index
	  addr	r1[r5:d],r1	;Proper level 2 table
	  movd	r4,(r1)		;Lower bits
	  ord	r2,(r1)		;Physical address
	  addd	4*128,r2	;Next physical address
	  addd	4*128,r7	;Next virtual address
	 cend
	 addqd	-1,r0
	endw

	ret

;Options list for MMU/S

tmmu_op:
	db	6		;Number of entries
	dd	"V   "		;Valid
	dd	"SR  "		;Supervisor read
	dd	"SW  "		;Supervisor write
	dd	"UR  "		;User read
	dd	"UW  "		;User write
	dd	"CI  "		;Cache inhibit

	cond	cpu532
	 db	b'1000000	;Cache invalidate
	celse
	 db	0
	cend
	db	b'110		;User write
	db	b'100		;User read
	db	b'010		;Supervisor write
	db	0		;Supervisor read
	db	1		;Valid

	cend			;CEND of COND W_MMU

mov_mem:
	bsr	next:d		;Advance to 1st parameter
	bfs	error
	bsr	exp_gen		;Get source address in R5
	bfs	error
	movd	r5,r7		;Source to R7

	bsr	comma:d
	bne	error
	bsr	exp_gen		;Target in R5
	bfs	error
	movd	r5,r2

	bsr	comma:d
	bne	error
	bsr	exp_gen		;Count in R5
	bfs	error
	cmpqd	0,r5
	beq	error
	movd	r5,r0		;Count to R0
	movd	r7,r1		;Source now in R1

;If R2>R1 then do backwards move

	cmpd	r1,r2
	bhs	do_mov1		;Regular forward move if R1>=R2

;R2 bigger, do backwards move

	addd	r0,r1
	addd	r0,r2
	addqd	-1,r1		;Last source address
	addqd	-1,r2		;Last target address
	movsb	b
	ret	0

;Forward move

do_mov1:
	movsb
	ret	0


;Untrace (backtrace)
;U displays entire buffer
;U=0 resets counter
;U # backs up that many and displays one screen at a time

do_unt:	movd	trc_cnt,r2	;Default count
	cmpd	trc_siz,r2	;Can't do more than this
	if	lo
	 movd	trc_siz,r2
	endif
	movd	r2,r5
	bsr	dsp_r5:d
	bsr	dsp_msg:d
	byte	" entries in trace buffer",cr,lf,0

	bsr	next:d
	if	fc
	 cmpb	"=",(r1)
	 if	eq
	  addqd	1,r1
	  bsr	next:d
	  bsr	exp_gen
	  bfs	error
	  movd	r5,trc_cnt
	  ret
	 endif
	endif

	if	fc
	 bsr	exp_gen
	 bfs	error
	 cmpd	r5,r2
	 if	lo		;Can't do more than TRC_CNT
	  movd	r5,r2		;Number of addresses to list
	 endif
	endif

	bsr	g_chrmax:d	;Get max character x/y in r5
	lshd	-16,r5		;Get max row in bits 0-15
	movd	r5,r3
	movd	trc_cnt,r1	;Current pointer
	subd	r2,r1		;Backup to requested entry
	andd	trc_siz-1,r1	;Adjust for wraparound

	begin
	 cmpqd	0,r2		;Total entries to display
	while	ne
	 save	[r3]		;Current row count
	 cmpd	r2,r3		;R2 holds total remaining
	 if	lo
	  movd	r2,r3
	 endif
	 until	eq
	  movd	trc_buf[r1:d],r4 ;Current address to display
	  save	[r1,r2,r3]
	  movd	r4,m_disend	;Last address to do
	  bsr	dis_dsp:d	;Disassemble address in R4
	  restore [r1,r2,r3]
	  addqd	1,r1		;Next address
	  andd	trc_siz-1,r1	;Adjust for wraparound
	  addqd -1,r2		;Total is one less
	  addqd -1,r3		;Current line count for this page
	  cmpqd 0,r3
	 endu
	 restore [r3]
	 bsr	pause:d
	quit	fs
	endw

	ret


;Trace command

do_trc:	movb	m_trcmd,r2	;Default mode to use

	cmpb	"N",(r1)	;Non-sequential trace if so
	if	eq
	 movb	(r1),r2
	 addqd	1,r1
	 movb	r2,m_trcmd
	else
	 cmpb	"S",(r1)	;Sequential trace
	orif	eq
	endif

	cmpb	"N",r2
	if	eq
	 sbitb	1,m_trpbrk	;Non-sequential on
	endif

	movd	t_trcop+1,r5	;Default count
	bsr	next:d
	if	fc
	 cmpb	",",(r1)	;Null entry if this
	 if	ne
	  bsr	exp_gen
	  bfs	error
	 endif
	endif
	movd	r5,r4		;Count in R4

	movd	t_trcop+1+4,r5	;Default condition address
	bsr	comma:d
	if	fc
	 cmpb	",",(r1)
	 if	ne
	  bsr	exp_gen
	  bfs	error
	 endif
	end			;Condition address in R5

	bsr	next:d		;Check for command line
	if	fc
	 cmpb	",",(r1)	;This must follow
	 bne	error
	 save	[r4]
	 addqd	1,r1		;Whatever follows is stored as command
	 addr	t_trcop+1+4+4,r2 ;Address for command
	 movb	cr,r4		;Move until this is found
	 bsr	strx_len:d	;R0 holds length until CR
	 restore [r4]
	 cmpd	tbrk_siz-9,r0	;Max line length
	 bls	error
	 addqd	1,r0		;Include CR
	 movsb
	endif
	movd	r4,t_trcop+1	;Count
	movd	r5,1+4+t_trcop	;Condition address

	orb	flag_t,m_psr	;Set trace bit
	br	do_gobrk


;Port I/O
;(Destination address)

do_prl:	movb	" ",cmd_buf	;Cancel auto command repeat
	cmpb	"I",(r1)
	addqd	1,r1
	beq	prl_in

;Output - Load 2 parameters into R3 and R4, get device too

	bsr	next:d
	bsr	exp_gen
	bfs	error
	movd	r5,r3		;Base address
	bsr	comma:d
	bsr	exp_gen
	bfs	error
	movd	r5,r4		;Last address
	bsr	comma:d
	bsr	devic_out
	bfs	error
	cmpqd	0,r6
	beq	error		;Must be device

;1st address in R3, last in R4

	subd	r3,r4		;Count in R4
	addqd	1,r4		;Make count inclusive
	cmpqd	1,r4
	bgt	error		;Must be positive and >0
	movd	r4,r0		;Count to R0
	movd	r3,r1		;Address to R1

	movd	exp bkb_cnt+exp bkb_bin,r5
	bsr	wrt_file:d
	br	dev_clos:d

prl_in:
	bsr	get_devic
	cmpqd	0,r6
	beq	error		;Must be device

	movd	m_slast,r5	;Default address
	bsr	comma:d
	if	fc
	 bne	error
	 bsr	exp_gen
	 bfs	error
	endif
	movd	r5,r2

	bsr	dev_binget:d
	cmpqb	0,r5
	movd	exp bkb_bin+exp bkb_tr5+eot,r0 ;Default termination
	if	ne
	 movd	exp bkb_bin+exp bkb_trm,r0 ;Read to end of file
	endif

	movd	r2,r1		;Starting address to R1
	bsr	rd_file:d	;Read the file
	bsr	dev_clos:d	;Finished

	addr	r1[r0:b],r5	;Next address to R5
	movb	eot,(r5)	;Terminate file with CTRL_Z
	movd	r5,m_slast
	bsr	dsp_msg:d
	db	"Next address is ",0
	bsr	dsp_r5:d
	br	do_cr:d


;Register display

do_reg:
	cond	don
	 cmpd	"ESET",(r1)
	 if	eq
	  addqd	4,r1
	  bsr	next:d
	  bfs	code1:d		;Restore everything if no MOD specified
	  cmpb	"R",(r1)	;Load registers from M_xx if so
	  bne	error
	  lprd	sp,m_isp	;New SP
	  bispsrw flag_s	;Select user stack
	  lprd	sp,m_usp	;New user SP
	  bicpsrw flag_s	;Back to supervisor stack
	  movw	m_psr,tos	;This is for RETT
	  bicpsrw flag_i	;Clear interrupt enable for now
	  lprd	intbase,m_intb
	  movd	m_mod,r5
	  movd	m_sb,(r5)	;Loaded from here by RETT
	  movw	r5,tos		;MOD address for RETT
	  addr	reset:d,tos	;Target address
	  movd	m_cfg,r7	;RESET routine needs this here
	  cond	cpu532
	   lprw	mod,4(sp)	;In case of DE mode
	   lprd	sb,m_sb
	  cend
	  rett
	 endif
	cend

	bsr	next:d
	bfs	dsp_reg		;Display all registers if no parameters

;Check for 1 character register name "M" for MMU, "F" for FPU, "D" for Debug

	movzbd	1(r1),r4
	cmpb	trm_blnk:#,(m_delim)[r4:b]
	if	hs		;Only one character there
	 cmpb	"F",(r1)	;Display FPU set
	 beq	dsp_fpu
	 cond	w_mmu		;Only if MMU available
	  cmpb	"M",(r1)	;Display MMU set
	  beq	dsp_mmu
	 cend
	 cond	cpu532
	  cmpb	"D",(r1)
	  beq	dsp_dbg
	 cend
	endif

	movb	(r1),r2		;Save 1st letter
	bsr	pad_blnk:d	;Build name in R4
	cmpb	"7",r2
	if	hs
	 lshd	8,r4
	 movb	"R",r4		;Name for R0-R7
	endif
	movzbd	(reg_last-reg_cpu)/4,r0 ;Total number of registers
	save	[r1]
	addr	t_rg_nm-4[r0:d],r1 ;Point to last entry
	skpsd	b,u		;FS if match found
	restore	[r1]
	bfc	error		;No match if FC
	addqd	-1,r0		;Offset starts from 0
	movd	r0,r2		;Register number to R2

;If = follows then set new value, else just display current setting

	bsr	next:d
	if	fc
	 cmpb	"=",(r1)
	 bne	error
	 addqd	1,r1
	 bsr	next:d
	 bfs	error

	 cmpb	(reg_fpu-reg_cpu)/4,r2
	 if	hi		;CPU, MMU, DEBUG if HS
	  bsr	exp_gen
	  bfs	error
	  movd	r5,m_r0[r2:d]
	 else			;FPU
	  cmpb	(m_fsr-reg_cpu)/4,r2 ;Check for FSR
	 orif	eq
	  subb	(m_f0-reg_cpu)/4,r2 ;Convert to offset from M_F0
	  bsr	exp_r1r5	;Get integer or floating value
	  bfs	error
	  extsb	b_size/8(r5),r6,b_size-8,4 ;See if integer or float
	  cmpqb 6,r6		;Must be float or integer
	  blo	error
	  cmpqb	3,r6
	  if	hs
	   movd	2(r5),m_f0[r2:d] ;Just store integer value
	  else
	   cmpqb 4,r6		;Check for 32 bit float
	   if	eq
	    cmpqb 7,r2
	    blo	error		;Must be F0-F7 if 32 bits
	    movlf 2(r5),m_f0[r2:d] ;Store 32 bit float
	   else
	    cmpqb 5,r6		;Check for variable size float
	    if	lo		;Variable if LO (R6=6)
	     cmpb r2,8		;Check for F0-F7
	    endif		;If F0-F7 treat variable as 32 bit
	   orif	lo		;64 bit if not LO
	    cmpb (m_f7-m_f0)/4,r2 ;Check for L0-L7
	    tbitb 0,r2		;Check for even register
	    if	hs		;F0-F7 if HS
	     bfs error		;Can't be odd here
	    else		;L0-L7
	     if fs		;This is L0/L2/L4/L6 if FS
	      subb (m_l0-m_f0)/4,r2 ;Convert to F0/F2/F4/F6 offset
	     else
	      cmpqd 0,m_tfpu	;Can't be 32081 if L1/L3/L5/L7
	      beq error
	     endif
	    endif
	    movl 2(r5),m_f0[r2:d]
	   endif
	  endif
	 endif
	 ret
	endif

	bsr	reg_r2
	ret

;Display register in R2

reg_r2:
	save	[r0,r1]

	movw	m_radix,tos
	cmpqb	7,r2		;If not R0-R7 then always unsigned hex
	if	lo
	 cbitb	b_sign,tos
	 inssb	16,tos,0,5
	endif
	addr	t_rg_nm[r2:d],r1 ;Register name
	movqd	4,r0		;Length of name
	bsr	trl_blnk:d	;Remove trailing blanks
	bsr	str_out:d
	bsr	dsp_msg:d
	db	$"= ",0
	movd	m_r0[r2:d],tos	;Value
	bsr	dsp_tos:d

	restore	[r0,r1]
	ret

;Display CPU all registers

dsp_reg:
	movqd	0,r2		;Start with R0
	cond	cpu032
	 movzbd	(reg_mmu-reg_cpu)/4,r3 ;Count
	cend
	cond	cpu532
	 movzbd	(reg_dbg-reg_cpu)/4,r3 ;Count
	cend
	br	reg_all

;Display all Debug registers

	cond	cpu532
dsp_dbg:
	 movzbd	(reg_dbg-reg_cpu)/4,r2 	;First MMU register
	 movzbd	(reg_cfg-reg_dbg)/4,r3 	;Register count
	 br	reg_all
	cend

;Display all MMU registers

dsp_mmu:
	movzbd	(reg_mmu-reg_cpu)/4,r2 	;First MMU register
	movzbd	(reg_fpu-reg_mmu)/4,r3 	;Register count
	br	reg_all

;Display all FPU registers

dsp_fpu:
	movzbd	(reg_fpu-reg_cpu)/4,r2 	;First FPU register
	movzbd	(reg_last-reg_fpu)/4,r3 ;Register count
	cmpqd	0,m_tfpu
	bne	reg_all			;Not 32081 if NE
	movb	(m_l1-reg_fpu)/4,r3	;Register count
	bsr	reg_all
	bsr	do_cr:d
	movzbd	(m_fsr-reg_cpu)/4,r2 	;FSR
	br	reg_r2

;R2 holds 1st register number, R3 holds count

reg_all:
	movqd	0,r6		;Count from bottom up
	until	eq
	 bsr	reg_r2		;Display register in R2
	 movd	r6,r4		;See if current count is multiple of 4
	 andd	3,r4
	 cmpqd	3,r4
	 addqd	1,r6
	 if	eq
	  cmpd	r6,r3
	  if	ne
	   bsr	do_cr:d
	  endif
	 else
	  movb	" ",r5
	  bsr	char_tx:d
	 endif
	 addqd	1,r2
	 cmpd	r6,r3
	endu

	ret


;Table of register names
;These must be in same order as (SB) storage

t_rg_nm:
	dd	"R0  "
	dd	"R1  "
	dd	"R2  "
	dd	"R3  "
	dd	"R4  "
	dd	"R5  "
	dd	"R6  "
	dd	"R7  "
	dd	"PSR "
	dd	"PC  "
	dd	"SB  "
	dd	"FP  "
	dd	"USP "
	dd	"ISP "
	dd	"INTB"
	dd	"MOD "

	cond	cpu532
	 dd	"DCR "
	 dd	"BPC "
	 dd	"DSR "
	 dd	"CAR "
	 dd	"CFG "
	cend

	cond	cpu032 and w_mmu
	 dd	"BPR0"
	 dd	"BPR1"
	 dd	"PF0 "
	 dd	"PF1 "
	 dd	"SC  "
	 dd	"MSR "
	 dd	"BCNT"
	 dd	"PTB0"
	 dd	"PTB1"
	 dd	"EIA "
	cend
	cond	cpu532
	 dd	"MCR "
	 dd	"MSR "
	 dd	"TEAR"
	 dd	"PTB0"
	 dd	"PTB1"
	cend

	dd	"F0  "
	dd	"F1  "
	dd	"F2  "
	dd	"F3  "
	dd	"F4  "
	dd	"F5  "
	dd	"F6  "
	dd	"F7  "
	dd	"L1  "		;Even register correspond to F0/F2/F4/F6:L
	dd	"L0  "
	dd	"L3  "
	dd	"L2  "
	dd	"L5  "
	dd	"L4  "
	dd	"L7  "
	dd	"L6  "

	dd	"FSR "

;Set or display breakpoints
;(breakpoint number)
;If nothing, just display all
;BM sets break register in MMU

do_pas:
	bsr	next:d
	bfs	dsp_pas

	movzbd	(r1),r5
	cmpb	"X",r5		;Check for clear command
	beq	brk_off
	bsr	hex_dig:d	;Get binary value in R5
	if	fs
	 cond	w_mmu		;Memory access break only if MMU
	  cmpb	"M",(r1)
	  bne	error
	  movb	(r1),r2
	 celse
	  br	error
	 cend
	else
	 movzbd	r5,r2		;Breakpoint number to R2
	 muld	tbrk_siz,r5
	 addr	t_pasop+1[r5:b],r3 ;Pointer to other parameters
	endif

	addqd	1,r1		;Skip over digit
	bsr	next:d
	bfs	dsp_brkr2	;Just display this breakpoint if FS

	cmpb	"=",(r1)
	bne	error

	addqd	1,r1
	bsr	next:d
	bfs	error
	cmpb	"M",r2
	if	eq
	 cond	w_mmu
	  cond	cpu032
	   extsd m_bp0,r4,0,24
	  cend
	  cond	cpu532
	   movd	m_car,r4
	  cend
	 cend
	else
	 movd	t_pas[r2:d],r4	;Default address
	endif
	cmpb	",",(r1)	;Check for null entry
	if	ne
	 bsr	exp_gen
	 bfs	error
	 movd	r5,r4		;Break address in R4
	 bsr	find_bk1	;CS if break already set
	 if	cs
	  addqb	-2,r0
	  cmpb	r0,r2		;Error if not same breakpoint
	  bne	error
	 endif
	endif

	cmpb	"M",r2
	cond	cpu032
	if	eq
	 cond	w_mmu
	  movd	m_bcnt,r6
	 cend
	else
	cend
	cond	cpu532
	if	ne
	cend
	 movd	(r3),r6		;Current count (0 if disabled)
	 cmpqd	0,r6
	 if	eq
	  movqd 1,r6		;Always enable, default to 1
	 endif
	cond	cpu032
	endif
	cend
	 bsr	comma:d
	 if	fc
	  bne	error		;Error if no comma
	  cmpb	",",(r1)
	  if	ne
	   bsr	exp_gen
	   bfs	error
	   movd	r5,r6		;Count in R6
	  endif
	 endif
	cond	cpu532
	endif
	cend

	cmpb	"M",r2
	if	eq
	 cond	w_mmu
	  cond	cpu032
	   movd	m_bp0,r7
	   andd	h'18000000,r7	;R/W enable bits
	  cend
	  cond	cpu532
	   movd	m_dcr,r7
	   andd	h'60,r7		;R/W enable bits
	  cend
	 cend
	else
	 movd	4(r3),r7	;Default condition test
	endif
	bsr	comma:d
	if	fc
	 bne	error		;Error if no comma
	 cmpb	",",(r1)
	 if	ne
	  cmpb	"M",r2
	  if	eq
	   cond	w_mmu
	    movqd 0,r7
	    until ne
	     cmpb "R",(r1)
	     if	eq
	      cond cpu032
	       sbitb 28,r7	;Break on read
	      cend
	      cond cpu532
	       sbitb 6,r7	;Break on read
	      cend
	      addqd 1,r1
	     else
	      cmpb "W",(r1)
	      if eq
	       cond cpu032
	        sbitb 27,r7	;Break on write
	       cend
	       cond cpu532
	        sbitb 5,r7	;Break on write
	       cend
	       addqd 1,r1
	      else
	       cmpb "X",(r1)	;Cancels
	       if eq
	        addqd 1,r1
	       endif
	      endif
	     endif
	    endu
	   cend
	  else
	   bsr	exp_gen
	   bfs	error
	   movd	r5,r7		;Condition in R7
	  endif
	 endif
	endif

	bsr	next:d		;Check for command line
	if	fc
	 cmpb	"M",r2
	 beq	error		;No command line allowed with MMU abort
	 cmpb	",",(r1)	;This must follow
	 bne	error
	 movqb	1,lin_abt	;Can't continue multiple commands now
	 addqd	1,r1		;Whatever follows is stored as command
	 save	[r2,r4]
	 addr	4+4(r3),r2	;Address for command
	 movb	cr,r4		;Move until this is found
	 bsr	strx_len:d	;R0 holds length until CR
	 cmpd	tbrk_siz-9,r0	;Max line length
	 bls	error
	 addqd	1,r0		;Include CR
	 movsb
	 restore [r2,r4]
	endif
	
	cmpb	"M",r2
	if	eq
	 cond	w_mmu
	  cond	cpu032
	   bicd	h'1c000000,m_bp0 ;R/W enable bits, counter enable
	   cbitb 20,m_msr	;Break enable
	   cmpqd 0,r7
	   if	ne
	    sbitb 20,m_msr	;Break enable
	   endif
	   cmpqd 0,r6
	   if	ne
	    sbitb 26,r7		;Counter enable
	    addqd -1,r6		;MMU breaks when BCNT is already 0
	   endif
	   tbitb 30,m_bp0	;Check for virtual address compare
	   if	fc		;Virtual address if FC
	    cbitb 31,m_bp0	;Clear for now
	    tbitb log flag_u,m_psr ;Check for user/supervisor mode
	    sfsd r3		;Set bit 0 of R3 according to U flag
	    rotd -1,r3		;Flag to bit 31 of R3
	    ord	r3,r7		;Set address space
	   endif
	   ord	r7,m_bp0	;Condition
	   inssd r4,m_bp0,0,24	;Address for break
	   movd	r6,m_bcnt	;Count
	  cend
	  cond	cpu532
	   andd	h'10,m_dcr	;Save VNP only
	   cmpqd 0,r7		;Check for R/W condition
	   if	ne
	    ord	h'880080,r7	;Address compare, DBG trap, debug conditions
	    tbitb log flag_u,m_psr ;Check for user/supervisor mode
	    sfcd r3		;R3=1 if supervisor, 0 if user
	    movd h'200000,r5	;Set user flag
	    rotd r3,r5		;Rotate left if supervisor
	    ord	r5,r7		;Complete condition
	    extsd r4,r5,0,2	;Byte within Dword
	    movqd 1,r3		;Byte 1 enable bit
	    lshd r5,r3		;Select LSB only
	    ord	r3,r7
	    ord	r7,m_dcr	;Condition register
	    bicb 3,r4		;Dword aligned
	    movd r4,m_car	;Address
	    movqd 0,m_dsr	;Clear all status bits
	   endif
	  cend
	 cend
	else
	 movd	r4,t_pas[r2:d]	;Store address of breakpoint
	 movd	r6,(r3)		;Count
	 movd	r7,4(r3)	;Condition address
	endif

	ret

;Display all defined passpoints

dsp_pas:
	movqd	0,r2
	addr	t_pasop+1,r3 ;Pointer to count, condition test

	until	lo
	 bsr	dsp_brkr2
	 addd	tbrk_siz,r3	;Next count, condition
	 addqd	1,r2		;Next breakpoint number
	 cmpb	15,r2
	 if	hs
	  bsr	do_cr:d		;No flags altered
	 endif
	endu

	ret

;R2 holds breakpoint number, R3 points to count/condition test
;Display it

dsp_brkr2:
	cmpb	"M",r2		;Can't display MMU from here
	beq	error

	lproc
	reg	[r0,r1,r4,r5,r6]
buf:	blkb	80
	code

	addr	buf,r1

	movb	"B",(r1)
	movb	r2,r5
	addb	"0",r5
	cmpb	"9",r5
	if	lo
	 addqb	7,r5		;Make A-F
	endif
	movb	r5,1(r1)
	movw	"= ",2(r1)
	movqd	4,r0
	movd	t_pas[r2:d],r5
	bsr	pos_r5:d	;Display address
	movzbd	h'b,r6		;PC relative
	cmpqd	0,r5
	if	ne
	 bsr	sym_mod		;Display symbolic name if any
	endif

	movw	", ",r1[r0:b]
	addqd	2,r0
	movd	(r3),r5		;Count
	bsr	pos_r5:d

	movw	", ",r1[r0:b]
	addqd	2,r0
	movd	4(r3),r5	;Condition test
	bsr	pos_r5:d

	movb	",",r1[r0:b]
	addqd	1,r0
	bsr	str_out:d	;Display so far

	addr	4+4(r3),r1	;Pointer to command
	movb	cr,r4
	bsr	strx_len:d	;Get length in R0
	bsr	str_out:d

	pend


;List
;LD lists and dumps hex code too
;LN lists normal, opcodes only
;(Starting address, line count)
;No start displays from M_LLAST
;No ending address displays last default

do_lst:
	movb	m_lstmd,r3	;Default dump mode
	cmpb	"D",(r1)	;Display hex too
	if	eq
	 movb	(r1),r3
	 addqd	1,r1
	else
	 cmpb	"N",(r1)	;Display normal
	orif	eq
	endif

	movd	m_llast,r4	;Default address
	bsr	next:d
	if	fc
	 cmpb	",",(r1)	;Null entry if ","
	 if	ne
	  bsr	exp_gen
	  bfs	error
	  movd	r5,r4		;Starting address
	 endif
	endif

	movd	m_lcount,r5	;Default count
	bsr	comma:d
	if	fc
	 bne	error		;Must be comma
	 bsr	exp_gen
	 bfs	error
	endif

	movb	r3,m_lstmd	;Default dump mode
	movd	r5,m_lcount	;Default count
	addr	dis_dsp:d,r7	;Disassembly routine to use
	cmpb	"D",r3
	if	eq
	 addr	disasm:d,r7	;Full dump and listing
	endif

;R5 holds count, R4 holds starting address

do_lst1:
	save	[r5,r7]
	movd	r4,m_disend	;Last address to do
	jsr	r7		;List one line from R4
	restore	[r5,r7]
	movd	r4,m_llast	;Update next list address
	acbd	-1,r5,do_lst1

	ret	0


;Go
;GS does 1 instruction only (subroutine call, etc.)
;(Break 1, break 2)

do_go:	movb	" ",cmd_buf	;Cancel auto command repeat
	cmpb	"S",0(r1)	;Check for "S" option
	if	eq		;Set breakpoint at next instruction
	 movb	"T",cmd_buf	;Next auto command
	 tbitb	3,m_trpbrk
	 bfs	error		;Can't breakpoint within a breakpoint
	 movb	exp 5,m_trpbrk	;Bit set to not display "Break" message
	 movd	m_pc,r4		;Current instruction
	 bsr	dis_sb:d	;Advance R4 to next instruction
	 bsr	find_bk2
	 if	cc		;Break already set if CS
	  movd	r4,t_brk
	  movqd	1,1+t_brkop	;Enable breakpoint
	 endif
	else			;Check for new breakpoints
	 tbitb	3,m_trpbrk
	 if	fc		;Can't disturb condition test in progress
	  movqb	0,m_trpbrk	;Bit 3 must be clear here
	 endif
	 addr	t_brk,r2
	 bsr	next:d
	 if	fc
	  bsr	exp_gen
	  bfs	error
	  movd	r5,r4
	  bsr	find_bk2
	  if	cc
	   movd	r5,0(r2)
	   movqd 1,1+t_brkop
	  endif

	  bsr	comma:d
	  if	fc
	   bne	error
	   bsr	exp_gen
	   bfs	error
	   movd	r5,r4
	   bsr	find_bk2
	   if	cc
	    movd r5,4(r2)
	    movqd 1,1+tbrk_siz+t_brkop
	   endif
	  endif
	 endif
	endif

do_gobrk:

;Install all breakpoints and save opcodes

	movzbd	16+2,r0		;2 breakpoints, 16 passpoints
	addr	t_brk,r1
	addr	t_brkop,r2
	until	eq
	 movd	(r1),r3
	 cmpqd	0,1(r2)		;Disabled if count is 0
	 if	ne
	  movb	(r3),(r2)	;Save original opcode
	  movb	op_bpt,(r3)	;Install breakpoint
	 endif
	 addqd	4,r1
	 addd	tbrk_siz,r2
	 addqd	-1,r0
	 cmpqd	0,r0
	endu

;Trace one instruction if breakpoint at current PC and no condition test
;or MBRK_NUM is here (already took breakpoint)

	movd	m_pc,r4
	cmpb	op_bpt,(r4)
	if	eq
	 bsr	find_brk
	 if	cs		;Match found if CS
	  cmpb	r0,mbrk_num
	  muld	tbrk_siz,r0	;Offset to count, condition data
	  if	eq		;No test if EQ
	   movb	t_brkop[r0:b],(r4) ;Restore original opcode
	   movd	r4,t_trc	;Address of traced break opcode
	   sbitb 2,m_trpbrk	;Restore BPT to (T_TRC) at trace trap
	   tbitb log flag_t,m_psr
	   if	fc
	    sbitb 4,m_trpbrk	;Clear FLAG_T and RETT at trace trap
	   endif
	   orb	flag_t,m_psr	;Set trace bit
	  else
	   cmpqd 0,t_brkop+1+4[r0:b] ;Check for condition test
	  orif	eq
	  endif
	 endif
	endif

;Load registers and do it

	movqb	-1,mbrk_num	;Cancel breakpoint in progress

	bispsrw	flag_s
	lprd	sp,m_usp
	bicpsrw	flag_s

	cond	cpu532
	 tbitb	cfg_de,m_cfg
	 if	fc		;Not DE mode if FC
	cend
	  movd	m_sb,(m_mod)	;RETT loads SB with this
	cond	cpu532
	 endif
	cend

	lprd	fp,m_fp
	lprd	intbase,m_intb

	movd	m_r0,r0
	movd	m_r1,r1
	movd	m_r2,r2
	movd	m_r3,r3
	movd	m_r4,r4
	movd	m_r5,r5
	movd	m_r6,r6
	movd	m_r7,r7

	lprd	sp,m_isp
	movw	m_psr,tos
	movw	m_mod,tos
	movd	m_pc,tos

	cond	cpu532
	 lprd	cfg,m_cfg
	 cinv	a,i,r0
	cend

	tbitb	cfg_f,m_cfg	;See if FPU present
	if	fs
	 movl	m_f0,f0
	 movl	m_f2,f2
	 movl	m_f4,f4
	 movl	m_f6,f6
	 cmpqd	0,m_tfpu
	 if	ne
	  movl	m_l1,l1
	  movl	m_l3,l3
	  movl	m_l5,l5
	  movl	m_l7,l7
	 endif
	 lfsr	m_fsr
	else
	 cmpqd -1,m_fsr
	orif	ne
	endif

	tbitb	cfg_m,m_cfg	;Check for MMU
	if	fs
	 cond	cpu032 and w_mmu
	  lmr	pf0,m_pf0
	  lmr	pf1,m_pf1
	  lmr	sc,m_sc
	  lmr	bpr0,m_bp0
	  lmr	bpr1,m_bp1
;	  lmr	bcnt,m_bcnt
	  lmr	tear,m_bcnt	;532 equivalent
	  lmr	ptb0,m_pt0
	  lmr	ptb1,m_pt1
;	  lmr	eia,m_eia
	  lmr	ivar1,m_eia	;532 equivalent
	  sbitb	1,m_msr		;Reset bit
	  lmr	msr,m_msr	;This must be loaded last
	 cend
	 cond	cpu532
	  lmr	mcr,m_mcr
	  lmr	ptb0,m_pt0
	  lmr	ptb1,m_pt1
	  lmr	msr,m_msr
	 cend
	endif

	cond	cpu532
	 lprd	dcr,0		;Disable until other registers loaded
	 lprd	dsr,m_dsr
	 lprd	bpc,m_bpc
	 lprd	car,m_car
	 lprd	dcr,m_dcr
	 lprw	mod,4(sp)	;In case of DE mode
	 lprd	sb,m_sb
	cend

	rett	0

;Quick setup of module/parameters
;QD=Display, QM=Module setup, QR=Load registers

do_quik:
	movb	(r1),r2
	addqd	1,r1
	cmpb	"R",r2		;Check for register load
	if	eq
	 movqd	0,r5		;Default mod #
	 bsr	next:d
	 if	fc
	  bsr	exp_gen
	  bfs	error
	 endif			;Mod # now in R5
	 cmpd	mod_indx,r5
	 bls	error		;Must be valid
	 muld	mod_tsiz,r5
	 addr	mod_tabl[r5:b],r4 ;Base address of table
	 movd	4+4+2+2*sidx_of+4(r4),m_pc ;Starting PC
	 movd	4+4+2+2*sidx_of+4+4(r4),m_sb ;Starting SB
	 movd	4+4+2+2*sidx_of+4+4+4(r4),m_mod ;Starting MOD
	 movd	m_stksiz+4,r4	;Default stack address
	 cmpqd	0,r4		;Undefined if 0
	 if	ne
	  tbitb	log flag_s,m_psr ;Check stack selection
	  if	fs		;USP
	   movd	r4,m_usp
	  else
	   movd	r4,m_isp
	  endif
	 endif
	 ret
	endif

	cmpb	"D",r2		;Check for module map display
	if	eq
	 movqd	-1,r5		;Default to all
	 bsr	next:d
	 if	fc
	  bsr	exp_gen
	  bfs	error
	  cmpd	mod_indx,r5
	  bls	error		;Must be valid
	 endif			;Mod # now in R5
	 cmpqd	-1,r5		;Do all if so
	 if	ne
	  movd	r5,tos
	  bsr	dsp_mod:d	;Display it
	 else
	  movd	mod_indx,r0	;Count
	  movqd	0,r3		;Starting module
	  begin
	   cmpqd 0,r0
	  while	ne
	   movd	r3,tos
	   bsr	dsp_mod:d
	   addqd 1,r3		;Next module
	   addqd -1,r0
	  endw
	 endif
	 ret
	endif

	cmpb	"M",r2		;Set internal module parameters
	bne	error
	bsr	next:d
	bsr	exp_gen		;Module number
	bfs	error
	cmpd	mod_indx,r5
	bls	error		;Must be valid
	muld	mod_tsiz,r5
	addr	mod_tabl[r5:b],r3
	bsr	next:d
	cmpb	"=",(r1)
	if	eq
	 addqd	1,r1
	 bsr	next:d
	endif
	bsr	exp_gen		;MOD address
	bfs	error
	movd	r5,4+4+2+2*sidx_of+4+4+4(r3) ;Save MOD
	movd	(r5),4+4+2+2*sidx_of+4+4(r3) ;Save SB
	movd	4(r5),4+4+2+2*sidx_of+4+4+4+4(r3) ;Save Link
	movd	8(r5),4+4+2+2*sidx_of+4(r3) ;Save PC
	ret


;Edit continous memory addresses until <null> entry
;B/W/D address=value

do_edt:	movb	0(r1),r2	;Save B/W/D
	addqd	1,r1

	cmpb	"B",r2
	if	eq
	 movzbd	h'ff,r2		;Max entry
	 movqd	1,r3		;Byte size
	else
	 cmpb	"D",r2
	 if	eq
	  movd	-1,r2		;Max entry size
	  movqd	4,r3		;Byte size
	 else
	  cmpb	"W",r2
	  if	eq
	   movzwd h'ffff,r2	;Max entry size
	   movqd 2,r3		;Byte size
	  else
	   br	error
	  endif
	 endif
	endif

	bsr	next:d
	bfs	error
	bsr	exp_gen
	bfs	error
	movd	r5,r4		;Address to edit in R4

	bsr	next:d
	if	fc
	 cmpb	"=",(r1)	;See if just modifying one address
	 if	eq
	  addqd	1,r1
	  bsr	next:d
	  bfs	error
	  
	  proc
	  reg	[]
buf:	ds	20
	  code
	  
	  addr	buf,r5
	  bsr	exp_gnsb
	  tbitb	b_def,(r5)	;FS if defined
	  if	fs
	   extsb 1(r5),r1,b_size-8,4
	   cmpqb 3,r1		;Check for integer
	   if	hs
	    movd 2(r5),r5
	    andd r2,r5		;Mask unwanted bits
	    bicd r2,(r4)
	    ord	r5,(r4)
	    addd r3,r4		;Advance R4
	    bispsrb flag_f	;Success
	   else
	    bicpsrb flag_f	;Possible error
	    cmpb 8,r1		;Check for string
	    if	eq
	     movd r4,r2		;Target address
	     movd 4(r5),r1	;Source string
	     movzwd 2(r5),r0	;Length
	     movsb
	     bispsrb flag_f	;Success
	    endif
	   endif
	  endif
	  pend
	  bfc	error
	  ret
	 endif
	endif

;R4 holds address, R2 holds max entry size, R3 holds byte count

	proc
	reg	[]
buf1:	blkb	50		;Input buffer
buf2:	blkb	75		;Translation and display buffer
	code

	begin
	 addr	buf2,r1
	 movqd	0,r0		;Length of display string
	 movd	r4,r5
	 bsr	byt_4r5:d	;Display address
	 movw	":<",r1[r0:b]
	 addqd	2,r0
	 movd	(r4),r5		;Current contents
	 andd	r2,r5		;Mask unwanted bits
	 bsr	put_r5:d
	 movd	">=  ",r1[r0:b]
	 addqd	3,r0		;Only one space
	 save	[r0]
	 bsr	str_out:d	;Display address and current contents
	 restore [r0]		;Current input length

	 save	[r2,r3]
	 addr	buf1,r1		;Current input buffer
	 addr	buf2,r2		;Translation buffer
	 sprd	fp,r3
	 subd	r1,r3		;Max input length
	 bsr	lin_inp2:d	;Get input, no prompt
	 movd	r2,r1		;Translated string to R1
	 restore [r2,r3]
	 cmpb	cr,(r1)
	while	ne
	 bsr	next:d
	 if	fc		;Just advance if null entry
	  addr	buf1,r5
	  bsr	exp_gnsb
	  tbitb	b_def,(r5)	;FS if defined
	  if	fs
	   extsb 1(r5),r1,b_size-8,4
	   cmpqb 3,r1		;Check for integer
	   if	hs
	    movd 2(r5),r5
	    andd r2,r5		;Mask unwanted bits
	    bicd r2,(r4)
	    ord	r5,(r4)
	    addd r3,r4		;Advance R4
	   else
	    cmpb 8,r1		;Check for string
	    if	eq
	     save [r2]
	     movd r4,r2		;Target address
	     movd 4(r5),r1	;Source string
	     movzwd 2(r5),r0	;Length
	     movsb
	     movd r2,r4
	     restore [r2]
	    endif
	   endif
	  endif
	 else
	  addd	r3,r4		;Advance R4
	 endif
	endw

	pend
	ret


;Dump memory locations in hex and ASCII
;(B/W/D/A starting address, count)
;If no parameters given, use M_DLAST, M_DCOUNT
;If just "D" then use default mode from last time

do_dmp:
	movb	m_dmpmd,r3	;Default dump mode
	cmpb	"A",(r1)	;Display ASCII
	if	eq
	 movb	(r1),r3
	 addqd	1,r1
	else
	 cmpb	"B",(r1)	;Display bytes
	orif	eq
	 cmpb	"D",(r1)	;Display Dwords
	orif	eq
	 cmpb	"W",(r1)	;Display Words
	orif	eq
	 cmpb	"F",(r1)	;Display 32 bit float
	orif	eq
	 cmpb	"L",(r1)	;Display 64 bit longs
	orif	eq
	endif

	movd	m_dlast,r2	;Default address
	bsr	next:d
	if	fc
	 cmpb	",",(r1)	;Null entry if ","
	 if	ne
	  bsr	exp_gen
	  bfs	error
	  movd	r5,r2		;Starting address
	 endif
	endif

	movd	m_dcount,r5	;Default count
	bsr	comma:d
	if	fc
	 bne	error		;Must be comma
	 bsr	exp_gen
	 bfs	error
	endif

;R5 holds count, R2 holds starting address, R3 holds selection
;Get group params in R4, R6 and byte display routine in R7

	movb	r3,m_dmpmd	;Save new default
	movd	r5,m_dcount	;New default count

	cmpb	"B",r3
	if	eq
	 movzbd	h'10,r4		;Number of groups
	 movqd	1,r6		;Characters/group
	 addr	byt_1r5:d,r7
	else			;Try word
	 cmpb	"W",r3
	 if	eq
	  movzbd 8,r4		;Number of groups
	  movqd	2,r6		;Group size
	  addr	byt_2r5:d,r7
	 else			;Try double word
	  cmpb	"D",r3
	  if	eq
	   movqd 4,r4		;Number of groups
	   movqd 4,r6		;Group size
	   addr	byt_4r5:d,r7
	  else			;Must be ASCII
	   cmpb	"F",r3
	  orif	eq
	   cmpb	"L",r3
	   if	eq
	    movqd 2,r4		;Two groups
	    movzbd 8,r6		;Group size
	   else
	    movqd 1,r4		;Number of groups
	    movzbd h'20,r6	;Group size
	    movqd 0,r7		;Null address for ASCII only
	   endif
	  endif
	 endif
	endif

;Registers set, calculate # of lines, R5=# of bytes

	movd	r5,r0		;Total bytes to R0
	movqd	0,r1		;MSDword of R0R1 pair
	movd	r6,r5		;Group size
	muld	r4,r5		;Number of bytes in a line
	deid	r5,r0		;Complete lines in R1, remainder in R0

;R2 points to data, R1 = complete line count, R0 = remaining bytes
;R4 = groups per line, R6 = size of 1 group, R7 = address of display routine

	proc
	reg	[]
buf:	blkb	10*80		;Allow for full line with attributes
bufr5:	ds	10		;2(R5) buffer for floats
lin:	blkd			;Line count
rem:	blkd			;Remainder count
typ:	blkb
	code

	movb	r3,typ
	movd	r1,lin		;Complete lines
	movd	r0,rem		;Remaining bytes

	begin
	 cmpqd	0,lin		;Display a complete line
	while	ne
	 bsr	dsp1lin
	 addqd	-1,lin		;Decrement line count
	 cmpqd	0,lin
	 if	lo
	  bsr	do_cr:d
	 else
	  cmpqd	0,rem
	 orif	ne		;Need CR if another remainder line coming
	 endif
	endw

;Check for remaining display bytes

	cmpqd	0,rem
	if	ne
	 cmpb	"A",typ		;Check for ASCII
	 if	eq
	  movd	rem,r6		;Group size is just remaining bytes
	 else
	  movd	rem,r4		;Remaining bytes
	  divd	r6,r4		;Remaining groups
	  movd	rem,r3
	  modd	r6,r3		;Partitial groups remaining
	  addqd	-1,r3		;Set carry if any remainder
	  addcd	0,r4		;One more group if needed
	 endif
	 bsr	dsp1lin		;Display it
	endif

;Update next default pointer

	movd	r2,m_dlast
	pend
	ret


;Line loop, display address
;R2 advanced on exit
;R4=groups per line, R6=group size

dsp1lin:
	addr	buf,r1		;Set up pointer in R1
	movqd	0,r0		;Length
	movd	r2,r5
	bsr	byt_4r5:d	;Display 32 bit address
	movb	":",r1[r0:b]
	addqd	1,r0

	cmpb	"A",typ		;Check for ASCII mode
	if	ne
	 save	[r2,r4]		;Save start for ASCII display later
	 until	eq
	  movb	" ",r1[r0:b]	;Leading blank
	  addqd	1,r0
	  addr	bufr5,r5
	  movw	h'4400,(r5)	;Undefined float
	  cmpb	"F",typ
	  if	eq
	   movd	r2,tos		;Address of float
	   bsr	vrf_flt
	   movw exp b_buf,tos	;Output to R1[R0:B]
	   bsr	dsp_2r5:d
	  else
	   movw	h'5400,(r5)	;Invalid long
	   cmpb "L",typ
	  orif	eq
	   movd 0(r2),r5	;Display current group
	   jsr	r7
	  endif
	  addd	r6,r2		;Address of next group
	  addqd	-1,r4
	  cmpqd	0,r4
	 endu
	 restore [r2,r4]
	endif

	save	[r3]		;Calculate count
	movd	r4,r3
	muld	r6,r3		;Total bytes in R3

	cmpb	"F",typ		;No ASCII display if float
	if	eq
	 addd	r3,r2		;Just advance R2 if float
	else
	 cmpb	"L",typ
	orif	eq
	 movw	" '",r1[r0:b]	;Display ASCII now
	 addqd	2,r0
	 until	eq
	  movb	0(r2),r5
	  bsr	put_asc:d
	  addqd	1,r2
	  addqd	-1,r3
	  cmpqd	0,r3
	 endu
	 movd	"'",r1[r0:b]
	 addqd	1,r0
	endif

	restore	[r3]
	br	str_out:d


;Interpret a line of assembler input
;Execute immediately, update register storage
;Set temp break after opcode to execute

do_intpt:
	tbitb	3,m_trpbrk
	bfs	error
	movqb	0,m_trpbrk	;Bit 3 must be clear here
	movzbd	40,r5
	bsr	aray_r5:d	;Need opcode safely in data area
	bfs	return:d
	movd	r5,r7
	movd	lmod,tos	;Use current default mod
	bsr	mod_prm		;Set up parameters
	subd	m_pcofst,r5
	movd	r5,m_pcptr	;Keep original PC offset
	movw	m_radix,tos	;Keep original radix
	movb	m_ascond,tos	;XLAT flag is here
	bsr	asm_in1:d	;Initialize assembler
	movb	tos,m_ascond
	movw	tos,m_radix

	bsr	asm_line:d	;R3 holds original address
	cmpqb	0,r4
	beq	return:d	;Nothing to do if no code generated
	cmpqb	0,m_errct
	bne	return:d	;Don't execute if error
	tbitb	b_ps,m_opcod	;Check for pseudo op
	bfs	return:d

	cond	cpu032
	 cmpb	h'52,m_opcod	;Check for SETCFG
	cend
	cond	cpu532
	 cinv	a,i,r0
	 bicpsrb flag_z		;Make NE
	cend
	if	eq		;Update M_CFG if so
	 extsb	1(r3),m_cfg,7,4	;Store config bit map
	 movw	h'12,r3[r4:b]	;RET opcode
	 jsr	r3		;Can't use GO here because of MMU, FPU regs.
	 br	sav_mf		;Save MMU, FPU registers as needed
	else
	 movd	m_pc,m_tmpc	;Save original PC
	 movd	r3,m_pc		;Opcode to interpret
	 movd	r7,t_brk	;1st breakpoint
	 movqd	1,1+t_brkop	;Enable breakpoint
	 orb	h'e0,m_trpbrk	;No list, restore temp PC after trace
	 br	do_gobrk
	endif

;Assemble loaded text
;AL assembles and lists 2nd pass
;AI does immediate assembly to following address until null line
;A2 forces 2 pass
;AC does cross reference with listing
;AX calls ASM_CST
;(Source code address, object code address)

do_asm:	movqb	0,m_dolst	;All list options off
	cmpb	"X",(r1)
	if	eq
	 movw	m_radix,tos	;Don't let ASM_IN1 change this
	 movb	m_ascond,tos	;XLAT flag is here
	 movqd	0,r7		;New object address
	 bsr	lnk_cst:d	;Multi-file assembler initialization
	 bsr	asm_cst:d	;Single file assembler initialization
	 movb	tos,m_ascond
	 movw	tos,m_radix	;Start with original and save for exit
	 ret
	endif

	cmpb	"I",0(r1)
	bne	do_anoi
	addqd	1,r1
	bsr	next:d
	bfs	error
	bsr	exp_gen
	bfs	error

	movd	r5,r7		;Save address of object code
	movd	lmod,tos	;Use current default mod
	bsr	mod_prm		;Set up parameters
	subd	m_pcofst,r5
	movd	r5,m_pcptr	;Keep original PC offset
	movw	m_radix,tos	;Don't let ASM_IN1 change this
	movb	m_ascond,tos	;XLAT is here
	bsr	asm_in1:d	;Initialize assembler
	movb	(sp),m_ascond
	movw	1(sp),m_radix	;Start with original and save for exit
	movqb	1,m_pass	;This will be pass 1 mode

	proc
	reg	[r7]
buf1:	blkb	120		;Input buffer
buf2:	blkb	120+120/3	;Translation buffer, allow a little extra
;BUF1:	BLKB	BUF_SIZ		;Input buffer
;BUF2:	BLKB	BUF_SIZ+BUF_SIZ/3 ;Translation buffer, allow a little extra
	code

	begin
	 movb	"A",r5
	 bsr	char_tx:d	;Prompt will be A>
	 addr	buf1,r1		;Input buffer
	 addr	buf2,r2		;Translation buffer
	 movd	r1,r3
	 subd	r2,r3		;Max length
	 movqd	1,r0		;Current input length
	 movb	m_ascond,tos
	 bicb	exp b_xlat+exp b_tmpx+exp b_lxlat,m_ascond ;Translation off
	 bsr	lin_inp:d	;Get input to buffer in R1
	 movb	tos,m_ascond	;Restore translation status
	 movd	r2,r1		;Translated buffer to R1
	 cmpb	cr,(r1)
	while	ne		;Repeat until null input
	 bsr	a_onelin:d
	 bsr	dsp_alin:d
	endw
	pend

	bsr	asm_perr:d	;End of pass error checks
	movb	exp blnk_cmd+clnk_end,(m_lnkptr)
	addqd	1,m_lnkptr
	movd	m_linkm,tos	;Pointer to link data
	movd	r7,tos		;Address for object code
	movd	m_pcofst,tos
	movb	"L",m_pass	;Everything must be defined
	bsr	do_link		;Do pass 2 link

	movb	tos,m_ascond
	movw	tos,m_radix	;Keep original value
	movqb	0,m_dolst	;All list options off again
	ret

do_anoi:
	cmpb	"L",0(r1)
	if	eq
	 orb	exp b_alist+exp b_2pass,m_dolst ;2 pass, listing
	 addqd	1,r1
	else
	 cmpb	"2",0(r1)
	 if	eq
	  sbitb	b_2pass,m_dolst	;2 pass enabled
	  addqd	1,r1
	 else
	  cmpb	"C",(r1)
	  if	eq
	   orb	exp b_alist+exp b_2pass+exp b_xrf,m_dolst ;List, XREF
	   addqd 1,r1
	  endif
	 endif
	endif

	bsr	get_devic
	movd	r5,r3		;Save address of source code in R3

	bsr	comma:d
	bne	error
	bsr	exp_gen
	bfs	error
	movd	r5,r7		;Address of object code

	movqd	-1,r2		;Default MOD address (null)
	movqd	0,r4		;No device
	bsr	comma:d
	if	eq
	 save	[r6]
	 bsr	dev_out
	 movd	r6,r4		;Output device
	 restore [r6]
	 bfs	error
	 cmpqb	0,r4
	 if	eq
	  movd	r5,r2		;Only if absolute address
	 endif
	endif

	proc
	reg	[]
buf:	ds	30		;Filename storage
	code

	save	[r0,r4]
	cmpqd	0,r0		;Check for filename
	if	ne
	 save	[r2]
	 addr	buf,r2
	 movd	r5,r1
	 movsb			;Save filename in BUF
	 restore [r2]
	endif

	movd	r3,r1		;Need source address in R1 now
	movd	r4,r3		;Pass output device in R3
	movw	m_radix,tos
	bsr	asembl:d
	movw	tos,m_radix	;Restore original selection
	restore	[r0,r4]

;Now output file if requested

	cmpqb	0,r4
	if	ne
	 movd	r4,r6
	 addr	buf,r1
	 bsr	dev_binget:d	;Current binary status
	 movd	r5,tos
	 bsr	dev_binon:d	;Always binary here
	 bsr	lnk_wrt:d	;Output file
	 movd	tos,r5
	 cmpqb	0,r5
	 if	eq
	  bsr	dev_binoff:d	;Back to ASCII
	 endif
	endif

	pend

;Display next available memory location

	bsr	dsp_msg:d
	db	"Next available address is: ",0
	movd	mod_indx,r2
	addqd	-1,r2		;Last actual module
	muld	mod_tsiz,r2
	addr	mod_tabl[r2:b],r2
	movd	(r2),r5		;Size of PC relative code
	addd	4+4+2+2*sidx_of(r2),r5 ;Base address
	bsr	dsp_r5:d
	bsr	do_cr:d

	movqb	0,m_dolst	;All list options off again

	ret

;End of CMD32
