	print	"ASM32"


;Listing pseudo-ops are format 2
;LINK pseudo-ops are format 3
;System pseudo-ops are format 4
;Allocation pseudo-ops are format 5
;Macro ops are format 10
;Conditional structures are format 13
;Pseudo-ops are format 0 and 15

;This order must be preserved for END_SUB
;CC_END must be last conditional pseudo-op (before PROC pseudo-ops)
;Conditional structures are format 13

cc_beg	equ	0		;BEGIN conditional
cc_if	equ	1		;IF conditional
cc_untl	equ	2		;UNTIL conditional
cc_whl	equ	3		;WHILE conditional
cc_els	equ	4		;ELSE conditional
cc_orif	equ	5		;ORIF conditional
cc_qu	equ	6		;QUIT conditional
cc_qnd	equ	7		;End for QUIT
cc_end	equ	8		;END conditional

;This order must be preserved for CASE opcode
cc_xpr	equ	9		;Begin external procedure
cc_lpr	equ	10		;Begin local procedure
cc_proc	equ	11		;Begin in-line procedure
cc_reg	equ	12		;ENTER opcode for procedure
cc_cod	equ	13		;Actual code of procedure
cc_pend	equ	14		;EXIT procedure
cc_prt	equ	15		;PRET allows returning values on stack

cc_cond	equ	5		;CONDitional assembly
cc_celse equ	6		;Condition assembly else
cc_cend	equ	7		;End of conditional assembly block

pso_equ	equ	4		;EQU pseudo-op
pso_set equ	5		;SET pseudo-op

pso_stop equ	0		;STOP (format 0)
pso_ndmd equ	10		;ENDMOD (format 0)

;Listing pseudo-ops are format 2
op_lst	equ	2		;Pseudo-ops for list options

lst_fc	equ	0		;List false conditionals
lst_mac	equ	1		;List macros
lst_xlt	equ	2		;String translation
lst_wid	equ	3		;Width
l1_mac	equ	4		;Pass 1 listing
lst_str	equ	5		;PPRINT (printer output)

;LINK pseudo-ops are format 3
op_lnk	equ	3
lnk_mod	equ	0		;MODULE
lnk_stk	equ	1		;STACK
lnk_glb	equ	2		;GLOBAL
lnk_ext	equ	3		;EXTRN
lnk_eun	equ	4		;EXTUNDF
lnk_sym	equ	5		;SYMBOLS
lnk_lnk equ	6		;LINK
lnk_one	equ	7		;ONEMOD

;System pseudo-ops are format 4
psop_sys equ	4
sys_siz	equ	0		;MEMSIZE
sys_gnx	equ	1		;NSCGNX MODE
sys_pso	equ	2		;PSEUDO_OP

;Allocation pseudo-ops are format 5
psop_alc equ	5
alc_org	equ	0		;ORG
alc_bll	equ	1		;BLKL

;MACRO pseudo ops, format 10
op_mac	equ	10

mac_mac equ	0		;MACRO
mac_rpt	equ	1		;REPT
mac_irp	equ	2		;IRP
mac_rpc	equ	3		;IRPC
mac_rpl	equ	4		;IRPL
mac_lcl	equ	5		;LOCAL
mac_end	equ	6		;MEND
mac_xit	equ	7		;MEXIT
mac_lnd	equ	8		;LEND (end of repeat line data)

;R1 holds source address, R2 holds default MOD, R7 holds object address
;R3 holds MOD device: 0 if memory

asembl:
	save	[r6]
	movzbd	dev_pr,r6
	bsr	dev_open	;Open print device
	restore	[r6]

;Source code in (R1), put object code in (R7)
;R6 holds device to load from if not 0

	save	[r2,r3,r7]
	bsr	lnk_cst		;Cold start for linker

	movqw	0,m_opcod	;Zap just in case
	until	ne
	 
	 cmpw	exp b_ps+op_lnk*16+lnk_lnk,m_opcod ;Check for LINK pseudo-op
	 if	eq
	  bsr	asm_init	;Set up all but module data
	  movb	lnk_prm,tos	;Save original
	  sbitb	0,lnk_prm	;Undefined symbols are external
	  
	  save	[r0,r1,r5,r6]
	  cmpqd	0,r6		;Must be device
	  if	ne
	   movqd 0,r0		;Use default name loaded by LINK pseudo-op
	   bsr	dev_binget
	   movd	r5,tos		;Save binary status
	   bsr	dev_binon	;Always binary here
	   bsr	dev_open	;Open input device
	   movd	r7,r1
	   movd	exp bkb_bin+exp bkb_trm,r0 ;Binary file
	   bsr	rd_file		;Read the file
	   bsr	dev_clos
	   movd	tos,r5		;Original binary status
	   cmpqb 0,r5		;ASCII if 0
	   if	eq
	    bsr	dev_binoff
	   endif
	   bsr	dev_open	;Open input device again to continue
	  endif
	  restore [r0,r1,r5,r6]
	  
	  movqd	0,tos		;Module number returned here
	  movd	r7,tos		;Address for PC code
	  bsr	rd_link		;Read and link requested file
	  adjspb -8		;Drop module/execution offset
	  movb	tos,lnk_prm
	  movw	exp b_ps+pso_ndmd,m_opcod ;Keep going
	 else
	  movqw	0,m_opcod	;Zap just in case
	  bsr	asm_cst		;Cold start routine
	  movd	r1,tos
	  movd	r7,tos
	  bsr	asm0
	 endif
	 
	 movd	mod_indx,r4	;Next module number
	 addqd	-1,r4		;Last module done
	 muld	mod_tsiz,r4
	 addr	mod_tabl[r4:b],r4 ;Offset to module name offset
	 movd	4+4+2+2*sidx_of(r4),r7 ;Last module's address
	 addd	(r4),r7		;Default address for next module
	 
	 movb	exp blnk_cmd+clnkmod,(m_lnkptr)
	 movqw	-1,1(m_lnkptr)	;Increment module number
	 addqd	3,m_lnkptr

	 cmpw	exp b_ps+op_lnk*16+lnk_lnk,m_opcod ;Check for LINK pseudo-op
	 if	eq		;Only if going back for more
	  bsr	era_mod		;Zap last module if empty
	 else
	  cmpw	exp b_ps+pso_ndmd,m_opcod ;Check for ENDMOD pseudo-op
	 orif	eq
	  cmpqd	1,mod_indx
	 orif	lo		;Also check if very last of multiple modules
	 endif

	 movb	exp blnk_cmd+clnk_end,(m_lnkptr) ;ERA_MOD may change M_LNKPTR
	 movd	m_lnkptr,m_linkm ;New link address for next module

	 cmpqd	0,m_errct	;If errors then quit now
	quit	ne
	 cmpw	exp b_ps+pso_ndmd,m_opcod ;Check for ENDMOD pseudo-op
	 if	ne
	  cmpw	exp b_ps+op_lnk*16+lnk_lnk,m_opcod ;Check for LINK pseudo-op
	 endif
	endu

	restore	[r2,r3,r7]

	cmpqb	0,r3		;Final link only if assembling to memory
	if	eq
	 movd	r2,tos		;Default MOD address
	 bsr	lnk_adr		;Set base addresses in MOD_TABL
	 
	 addr	1(m_lnkptr),r0	;Last address to move+1 (it may be empty)
	 movd	m_link,m_lnkptr ;Reset current link pointer
	 movd	mod_indx,r5
	 addqd	-1,r5
	 muld	mod_tsiz,r5	;Offset to last mod table
	 save	[r2]
	 movd	mod_tabl+4+4+2+2*sidx_of[r5:b],r2 ;Last base address
	 addd	mod_tabl[r5:b],r2 ;Advance to address after code
	 movd	m_link,r1	;Source address
	 subd	r1,r0		;Byte count
	 movd	r2,r5		;Address of link code
	 movsb
	 restore [r2]
	 
	 movd	r5,tos		;Pointer to link data
	 movd	mod_tabl+4+4+2+2*sidx_of,r7 ;Current base address
	 movd	r7,tos		;Address for object code
	 movd	r7,tos		;Starting PC_OFST
	 movqd	0,lmod		;Start with Mod 0
	 movqd	0,msym_beg	;Search entire symbol table now
	 movb	"L",m_pass	;Link only here
	 bsr	do_link		;Final link routine
	 bsr	bld_mod		;Build MOD and LINK tables in memory now
	endif

;Display error count

	cbitb	31,m_errct	;Only display actual errors if forced abort
	movd	m_errct,r5
	bsr	dsp_r5
	bsr	dsp_msg
	db	" error(s)",cr,lf,0

;Assembly complete
;Display symbol table if listing

	tbitb	b_alist,m_dolst
	if	fs		;Only if listing
	 movb	tx_dev,tos
	 movb	dev_pr,tx_dev	;Send output to printer
	 bsr	lst_labl	;List labels
	 movb	tos,tx_dev
	else
	 tbitb	b_1lst,m_dolst
	orif	fs
	endif

	cmpqd	0,r6
	if	ne
	 bsr	dev_on
	 bsr	dev_clos
	endif

	movzbd	dev_pr,r6
	bsr	dev_clos
	ret

;Clear last module if undefined (size is 0)

era_mod:
	save	[r0,r1,r2,r3,r4]
	movd	mod_indx,r4	;Next module number
	addqd	-1,r4		;Last module done
	muld	mod_tsiz,r4
	addr	mod_tabl[r4:b],r4 ;Offset to module name offset

	movd	(r4),r3		;PC size
	ord	4(r4),r3	;SB size
	extsd	4+4+2(r4),r2,0,sidx_bit ;Offset to 1st symbol name
	cmpw	exp b_ps+op_lnk*16+lnk_lnk,m_opcod ;Check for LINK pseudo-op
	if	eq		;Only if going back for more
	 extsd	mod_tsiz+4+4+2+sidx_of(r4),r0,0,sidx_bit ;Next module name
	 addqd	-sidx_of,r0	;Backup to link index
	 cmpd	r0,r2
	 if	eq
	  addd	t_symbl,r0
	  extsd	sidx_of(r0),r1,0,5 ;Length of symbol name
	  addd	sidx_of+2+4,r1	;Link index, header and value
	  addd	r1,r2		;Skip module name
	 endif
	endif
	addd	t_symbl,r2
	subd	tsym_end,r2
	ord	r2,r3
	cmpqd	0,r3
	if	eq
	 movd	mod_tsiz,r0
	 addr	mod_tsiz(r4),r1 ;Source address
	 movd	r4,r2		;Target address
	 movsb			;If LINK then move next parameters down
	 addqd	-1,mod_indx	;One less mod table
	 addqd	-3,m_lnkptr	;Remove module number increment command
	endif
	restore	[r0,r1,r2,r3,r4]
	ret


;Save current code/link data
;R6 holds device, R0/R1 hold file name if any

lnk_wrt:
	cmpqd	0,m_errct
	bne	return		;Don't save if errors

	proc
	reg	[all]
buf:	ds	dhd_mod		;Working buffer for writes
sym_siz: blkd			;Size of symbol storage
dis_siz: blkd			;Size of disassembler data (FP, etc.)
	code

	bsr	dev_open

	addr	mod_tabl,r4
	movqd	0,r7		;Current module
	until	eq		;Do all modules
	 movqd	0,sym_siz
	 movqd	0,dis_siz
	 	
;Calculate size of disassembler data
;Set all FP variables temporarily to external type so
;  string processor won't see them
	 
	 tbitb	1,lnk_prm	;See if all symbols saved
	 if	fs
	  addr	t_symlnk,r3
	  begin
	   extsd (r3),r3,0,sidx_bit
	   cmpd	sidx_end,r3
	  while	ne
	   addd	t_symbl,r3
	   movd	r3,tos
	   bsr	set_mod		;Get module number
	   cmpd	tos,r7
	   if	eq		;Must be current module
	    cmpb h'2e,sidx_of+1(r3) ;Possible FP local procedure
	    if	eq
	     cmpb lcod_fp,sidx_of+2+4(r3) ;FP procedure designation
	     if eq
	      addqd 2+4+1,dis_siz ;Only 1 byte name stored
	      movd sidx_of+2+4+1+4(r3),r2 ;First local label in symbol table
	      addd t_symbl,r2
	      begin
	       extsb sidx_of+1(r2),r1,b_mode-8,4
	       cmpb 8,r1	;Must be FP mode
	      while eq
	       inssb lbl_ext,sidx_of(r2),b_typ,2 ;Make external for now
	       addr sidx_of(r2),r1 ;Pointer to status field
	       bsr lbl_len	;Get length in R0
	       addd r0,dis_siz
	       addqd sidx_of,r2
	       addd r0,r2
	      endw
	     endif
	    endif
	   endif
	  endw
	 endif
	 
;Calculate size of symbol and string storage
	 
	 addr	t_symalf,r2	;Pointer to symbol pointers
	 movzwd 13*("Z"-"A"+1),r3 ;Number of pointers
	 until	eq
	  save	[r2,r3,r4]
	  extsd	4+4+2+sidx_of(r4),r4,0,sidx_bit ;Offset to module name
	  addd	t_symbl,r4	;Absolute address of name
	  addqd	-sidx_of,r4	;Address of next symbol index
	  begin
	   extsd (r2),r2,0,sidx_bit
	   cmpd	sidx_end,r2	;Go until last symbol
	  while ne
	   addd t_symbl,r2	;Pointer to actual symbol
	   extsb sidx_of(r2),r3,b_typ,3 ;Symbol type, defined status
	   cmpqb lbl_glb+4,r3	;Only if global
	   if	eq
	    cmpd r2,r4		;Don't save module name
	    if	ne
	     movd r2,tos
	     bsr set_mod	;Get module number
	     cmpd tos,r7
	     if	eq		;Only if current module
	      addr sidx_of(r2),r1 ;Pointer to status field
	      bsr lbl_len	;Get length in R0
	      addd r0,sym_siz
	      extsb sidx_of+1(r2),r3,b_size-8,4
	      cmpb b'1000,r3	;Check for string
	      if eq
	       movzwd sidx_of+2(r2),r3 ;Length of string
	       addd r3,sym_siz	;String data follows symbol
	      endif
	     endif
	    endif
	   else
	    bicpsrb flag_z	;Make NE
	    tbitb 1,lnk_prm
	    if	fs
	     cmpqb lbl_nrm+4,r3	;Check for general symbol
	    endif
	   orif	eq		;All general symbols included
	   endif
	  endw
	  restore [r2,r3,r4]
	  addqd sidx_of,r2	;Next symbol pointer
	  addqd -1,r3
	  cmpqd 0,r3		;Do all symbol table pointers
	 endu
	 
	 movd	ver_num,buf	;Last 3 bytes of ID
	 movb	usr_exe,buf	;User executable file
	 addr	buf+4,r1
	 addr	1(r1),r2
	 movzbd 32+32+8-1,r0
	 movqb	0,(r1)
	 movsb			;Fill names with 0
	 extsb	lnk_prm,r5,2,1	;ONEMOD status
	 inssb	r5,buf+4+32+32,0,1 ;Store it here
	 extsd	4+4+2+sidx_of(r4),r5,0,sidx_bit ;Module name
	 cmpd	sidx_end,r5
	 if	ne
	  addd	t_symbl,r5	;Pointer to symbol name
	  extsd	(r5),r0,0,5	;Length of symbol
	  addr	2+4(r5),r1	;Pointer to name
	  movb	r0,buf+4+32	;Position for module name
	  addr	buf+4+32+1,r2
	  movsb			;Move name into place
	 endif
	 
	 movd	dhd_mod+mod_tsiz-2-2*sidx_of,r3 ;Offset to symbol table
	 movd	r3,buf+dhd_pc	;Offset to symbol data
	 movd	sym_siz,buf+dhd_pc+4 ;Size of symbol data
	 cmpqd	0,sym_siz	;See if any symbols used
	 if	eq
	  movqd	-1,buf+dhd_pc	;Nothing
	 endif
	 addd	sym_siz,r3
	 
	 movqd	-1,buf+dhd_pc+1*8 ;Offset to string data
	 movqd	0,buf+dhd_pc+1*8+4 ;Size of string data
	 
	 movd	r3,buf+dhd_pc+2*8
	 movd	(r4),buf+dhd_pc+2*8+4 ;PC size
	 addd	(r4),r3		;Size of PC code
	 
	 addqd	1,r7		;Number of modules
	 cmpd	mod_indx,r7	;Check for last module
	 if	eq		;Link data only in last module
	  movd	r3,buf+dhd_pc+3*8 ;Offset to link data
	  movd	m_lnkptr,r0
	  subd	m_link,r0	;Size of link data
	  addqd	1,r0		;Include final END token
	  movd	r0,buf+dhd_pc+3*8+4
	  addd	r0,r3		;Size of link data
	 else
	  movqd	-2,buf+dhd_pc+3*8 ;Link data in last module
	  movqd	0,buf+dhd_pc+3*8+4 ;No size
	 endif
	 addqd	-1,r7		;Restore R7
	 
	 movqd	-1,buf+dhd_pc+4*8 ;Offset to CXP data
	 movqd	0,buf+dhd_pc+4*8+4 ;Size of CXP data
	 
	 movd	r3,buf+dhd_pc+5*8 ;Offset to disassembly data
	 movd	dis_siz,buf+dhd_pc+5*8+4 ;Size of disassembly data
	 cmpqd	0,dis_siz	;See if anything there
	 if	eq
	  movqd	-1,buf+dhd_pc+5*8 ;Nothing
	 endif
	 addd	dis_siz,r3
	 
	 movqd	-1,buf+dhd_pc+6*8 ;Offset to line number data
	 movqd	0,buf+dhd_pc+6*8+4 ;Size of line number data

	 cmpqd	0,r7		;Check for 1st module
	 if	eq
	  movmd	m_stksiz,buf+dhd_stk,2 ;Stack size, address
	  movqd	0,buf+dhd_stk+8	;Offset to execution address
	 else
	  movqd	-1,buf+dhd_stk	;Size of stack
	  movqd	0,buf+dhd_stk+4	;Address of stack
	  movqd	-1,buf+dhd_stk+8 ;Offset to execution address
	 endif
	 
	 addqd	1,r7		;Next mod number
	 cmpd	mod_indx,r7
	 if	eq
	  movqd	-1,buf+dhd_stk+8+4 ;No more modules
	 else
	  movd	r3,buf+dhd_stk+8+4 ;Offset to next mod
	 endif
	 addqd	-1,r7		;Back to original
	 
;Ready to write now
	 
	 movzbd	dhd_mod,r0
	 addr	buf,r1
	 movd	exp bkb_bin,r5	;Binary file
	 bsr	wrt_file	;Write header
	 movzbd	4+4,r0		;PC,SB size
	 movd	r4,r1		;Address of current MOD parameter table
	 movd	exp bkb_bin,r5	;Binary file
	 bsr	wrt_file	;Write MOD_TABL
	 movzbd	4+4+4+4+4,r0
	 addr	4+4+2+2*sidx_of(r4),r1
	 movd	exp bkb_bin,r5	;Binary file
	 bsr	wrt_file	;2nd portion of MOD_TABL

;Now do symbols/strings
	 
	 addr	t_symalf,r2	;Pointer to symbol pointers
	 movzwd 13*("Z"-"A"+1),r3 ;Number of pointers
	 until	eq
	  save	[r2,r3,r4]
	  begin
	   extsd (r2),r2,0,sidx_bit
	   cmpd	sidx_end,r2
	  while ne
	   addd t_symbl,r2	;Pointer to actual symbol
	   extsb sidx_of(r2),r3,b_typ,3 ;Symbol type and defined status
	   cmpqb lbl_glb+4,r3	;Only if global and defined
	   if	eq
	    tbitb b_def,sidx_of(r2) ;Must be defined
	    if	fs
	     movd r2,tos
	     bsr set_mod	;Get module number
	     cmpd tos,r7
	     if	eq		;Only if current module
	      addr sidx_of(r2),r1 ;Pointer to status field
	      bsr lbl_len	;Get length in R0
	      movd exp bkb_bin,r5 ;Binary file
	      bsr wrt_file
	      extsb sidx_of+1(r2),r3,b_size-8,4
	      cmpb b'1000,r3	;Check for string
	      if eq
	       movzwd sidx_of+2(r2),r0 ;Length of string
	       movd sidx_of+2+2(r2),r1 ;Address of string
	       movd exp bkb_bin,r5 ;Binary file
	       bsr wrt_file	;Write string data
	      endif
	     endif
	    endif
	   else
	    bicpsrb flag_z	;Make NE
	    tbitb 1,lnk_prm
	    if	fs
	     cmpqb lbl_nrm+4,r3	;Check for general symbol
	    endif
	   orif	eq		;All general symbols included
	   endif
	  endw
	  restore [r2,r3,r4]
	  addqd sidx_of,r2	;Next symbol pointer
	  addqd -1,r3
	  cmpqd 0,r3		;Do all symbol table pointers
	 endu

	 movd	(r4),r0		;Code size
	 movd	4+4+2+2*sidx_of(r4),r1 ;Code address
	 movd	exp bkb_bin,r5	;Binary file
	 bsr	wrt_file

	 addqd	1,r7		;Number of modules
	 cmpd	mod_indx,r7	;Check for last module
	 if	eq		;Link data only in last module
	  movd	m_lnkptr,r0	;End of link data
	  movb	exp blnk_cmd+clnk_end,(r0) ;Terminate new link data
	  addqd	1,r0
	  movd	m_link,r1	;Address of link data
	  subd	r1,r0
	  movd	exp bkb_bin,r5	;Binary file
	  bsr	wrt_file
	 endif
	 addqd	-1,r7		;Restore R7

	 cmpqd	0,dis_siz
	 if	ne
	  addr	t_symlnk,r3
	  begin
	   extsd (r3),r3,0,sidx_bit
	   cmpd	sidx_end,r3
	  while	ne
	   addd	t_symbl,r3
	   movd	r3,tos
	   bsr	set_mod		;Get module number
	   cmpd	tos,r7
	   if	eq		;Must be current module
	    cmpb h'2e,sidx_of+1(r3) ;Possible FP local procedure
	    if	eq
	     cmpb lcod_fp,sidx_of+2+4(r3)
	     if eq
	      movd sidx_of+2+4+1+4(r3),r2 ;First local label in symbol table
	      addd t_symbl,r2
	      begin
	       extsb sidx_of+1(r2),r1,b_mode-8,4
	       cmpb 8,r1	;Must be FP mode
	      while eq
	       inssb lbl_nrm,sidx_of(r2),b_typ,2 ;Cancel external type
	       addr sidx_of(r2),r1 ;Pointer to status field
	       bsr lbl_len	;Get length in R0
	       cmpd sidx_end,sidx_of+2+4+1(r3) ;Local symbol if NE
	       if hi
	        inssb lbl_tmp,sidx_of(r2),b_typ,2 ;Make local
	       endif
	       save [r0]
	       movd exp bkb_bin,r5 ;Binary file
	       bsr wrt_file
	       restore [r0]
	       inssb lbl_nrm,sidx_of(r2),b_typ,2 ;Cancel temp type
	       addqd sidx_of,r2
	       addd r0,r2	;Next linear label
	      endw
	      movmd sidx_of(r3),buf,2 ;Symbol type, value, LCOD designator
	      inssb 1,buf,0,5	;Only save 1 byte of name
	      addr buf,r1
	      movqd 2+4+1,r0
	      movd exp bkb_bin,r5 ;Binary file
	      bsr wrt_file	;Write 2E label
	     endif
	    endif
	   endif
	  endw
	 endif
	 addd	mod_tsiz,r4
	 addqd	1,r7
	 cmpd	mod_indx,r7	;Check for last module
	endu			;All modules done

	bsr	dev_clos
	pend
	ret

asm0:
	lproc
reg_r1:	blkd
reg_r7:	blkd
	reg	[]
buf:	ds	buf_siz+2	;Input buffer for serial input
tlin:	blkd			;Initial line count
tlst:	blkd			;Initial list line count
	code

	movd	m_lincnt,tlin
	movd	m_linlst,tlst

asm1:	movd	reg_r1,r1
	movd	reg_r7,r7
	movd	tlin,m_lincnt
	movd	tlst,m_linlst
	bsr	asm_in2		;Reset for next pass
	bsr	dsp_msg
	db	"Pass ",0
	movzbd	m_pass,r5
	addb	"0",r5
	bsr	char_tx
	bsr	do_cr
asmlp:	movb	m_dolst,tos	;Restore original on exit
	begin
	 cmpqd	0,r6		;Read a line if necessary
	 if	ne
	  addr	buf,r1
	  movzwd buf_siz+1,r0	;Max input length including CR
	  bsr	blk_in
	 endif
	 save	[r1]
	 bsr	nxt_lin:d	;FS if end of file or no CR
	 restore [r1]
	while	fc
	 
	 save	[r6]
	 bsr	a_onelin	;Assemble a line, list and do errors
	 restore [r6]
	 addqd	1,m_lincnt	;Increment line counter
	 
	 cmpd	max_err,m_errct	;If max errors then quit now
	quit	lo
	 cmpqd	0,r6
	 if	ne
	  bsr	dev_on
	 else
	  bsr	lin_end:d	;Advance to next line if reading from memory
	 endif
	 cmpw	exp b_ps+pso_stop,m_opcod ;Check for STOP pseudo-op
	quit	eq
	 cmpw	exp b_ps+op_lnk*16+lnk_lnk,m_opcod ;Check for LINK pseudo-op
	quit	eq
	 cmpw	exp b_ps+pso_ndmd,m_opcod ;Check for ENDMOD pseudo-op
	quit	eq
	endw
	movb	tos,m_dolst

;End of file or terminated by exessive errors

	cmpqb	1,m_pass	;Set size of FP,SP,SB,PC if pass 1
	if	eq
	 movd	m_fpptr,siz_fp
	 movd	m_spptr,siz_sp
	 movd	m_sbptr,siz_sb
	 movd	m_pcptr,siz_pc
	 movd	mod_indx,r0
	 addqd	-1,r0		;Current table pointer
	 muld	mod_tsiz,r0
	 movd	m_pcptr,mod_tabl[r0:b] ;Set code size
	 movd	m_sbptr,mod_tabl+4[r0:b] ;Set SB size
	 movqw	-1,(m_xrflin)	;Terminate XRF with -1, don't advance
	 movd	m_xrflin,m_xrfptr ;Advance base pointer
	endif

	bsr	asm_perr	;Assembler end of pass error checks
	addqb	1,m_pass	;Next pass
	cmpqd	0,m_errct	;Quit now if errors
	if	eq		;If no errors, do next pass if needed
	 cmpqb	2,m_pass
	 if	eq
	  tbitb	b_2pass,m_dolst	;Check for 2 pass assembly
	  if	fs
	   cmpqd 0,r6
	   if	ne
	    bsr	dev_on
	   endif
	   br	asm1		;Another pass if listing
	  endif
	 endif
	endif

	movd	m_lnkptr,r0	;Last address to move + 1
	movd	m_linkm,m_lnkptr ;Reset current link pointer
	cmpqd	0,m_errct
	if	eq		;Link if no errors
	 save	[r1]
	 movd	m_pcptr,r2	;Target address
	 addd	m_pcofst,r2
	 movb	exp blnk_cmd+clnk_end,(r0) ;Terminate link data
	 addqd	1,r0
	 movd	m_linkm,r1	;Source address
	 subd	r1,r0
	 save	[r2]
	 movsb
	 restore [r2]
	 movd	r2,tos		;Pointer to link data
	 movd	reg_r7,tos	;Address for object code
	 movd	m_pcofst,tos
	 movd	mod_indx,lmod
	 addqd -1,lmod
	 bsr	do_link		;Link if not listing
	 movb	exp blnk_cmd+clnk_end,(m_lnkptr) ;Terminate new link data
	 restore [r1]		;Source code pointer
	endif

	pend


lst_labl:
	addr	t_symalf,r2	;Pointer to symbol pointers
	movzwd 13*("Z"-"A"+1),r3 ;Number of pointers
	until	eq
	 save	[r2,r3]
	 begin
	  extsd	(r2),r2,0,sidx_bit
	  cmpd	sidx_end,r2
	 while ne
	  addd t_symbl,r2	;Pointer to actual symbol
	  bsr	dsp_symbl	;Display name and value
	  tbitb b_xrf,m_dolst 	;Check for cross reference
	  if	fs
	   save [r2]
	   movw m_radix,tos
	   movzbw 10,m_radix	;Line numbers always unsigned decimal
	   movqd 0,r3		;Number of line matches found
	   addr sidx_of(r2),r4
	   subd t_symbl,r4	;Offset to search for
	   movd m_xrf,r2	;Pointer to XREF data
	   begin
	    cmpqw -1,(r2)	;End of line if so
	   while ne
	    movzbd 2(r2),r0	;Number of entries in this line
	    addr 3(r2),r1	;Start of data
	    begin
	     cmpqd 0,r0
	    quit eq
	     extsd (r1),r5,0,sidx_bit
	     cmpd r4,r5
	    while ne	
	     addqd sidx_of,r1
	     addqd -1,r0
	    endw
	    cmpqd 0,r0		;Nothing found if EQ
	    if ne
	     save [r3]
	     modd 20,r3
	     cmpqd 0,r3
	     restore [r3]
	     if eq
	      bsr do_cr
	      movb 9,r5
	      bsr char_tx	;Start with CR and tab every 10 line numbers
	     else
	      movb " ",r5
	      bsr char_tx
	     endif
	     movzwd (r2),r5
	     bsr dsp_r5		;Display line number
	     addqd 1,r3
	    endif
	    movzbd 2(r2),r0	;Number of entries
	    muld sidx_of,r0	;Skip over all labels
	    addqd 3,r0
	    addd r0,r2		;Next line's data
	   endw
	   movw tos,m_radix
	   restore [r2]
	  endif
	  bsr	do_cr
	 endw
	 restore [r2,r3]
	 addqd sidx_of,r2	;Next symbol pointer
	 addqd -1,r3
	 cmpqd 0,r3		;Do all symbol table pointers
	endu
	ret

dsp_symbl:
	addr	sidx_of(r2),r5	;Standard R5 pointer
	bsr	lbl_nam		;Get pointer to name in R1
	extsd	(r5),r0,0,5	;Length of name in R0
 	bsr	str_out
	extsb	sidx_of(r2),r5,b_typ,3
	cmpb	lbl_glb+4,r5
	if	eq
	 bsr	dsp_msg
	 db	$"::",0		;Global symbol
	endif
	bsr	dsp_msg		;Pad to 16 characters
	db	vc_scr,vcs_tab,16,0 ;Prepare for horizontal position
	extsd	sidx_of+1(r2),r4,b_mode-8,4 ;Mode of label
	cmpb	h'bc,sidx_of+1(r2) ;Check for macro
	if	eq
	 bsr	dsp_msg
	 db	"Macro",0
	else
	 extsb	sidx_of(r2),r5,b_typ,2
	 cmpb	lbl_ext,r5
	 if	eq
	  bsr	dsp_msg
	  db	"External",0
	 else
	  tbitb b_def,sidx_of(r2)
	  if	fs		;Defined
	   movw	m_radix,tos	;Default radix
	   andw	h'1f+exp b_sign,tos ;Only keep radix and sign bit
	   sbitb b_rdx,tos	;Display radix
	   cmpb	b'0100,r4	;Check for constant
	   if	ne
	    inssb 16,tos,0,5	;Force hex radix
	   endif
	   cmpb	b'1011,r4	;Check for PC relative
	   if eq
	    cbitb b_sign,tos	;Always unsigned here
	   endif
	   cmpb	b'1100,r4	;Check for string
	   if	eq
	    bsr	dsp_msg
	    db	$"S'",0		;String prefix
	   endif
	   addr	sidx_of(r2),r5	;Standard R5 pointer
	   bsr	dsp_2r5
	   bicpsrb flag_f	;Not external
	  else
	   tbitb 0,lnk_prm	;See if undefineds are external
	   if	fc
	    bsr	dsp_msg
	    db	"Undefined",0
	    bicpsrb flag_f	;No default external
	   endif
	  endif
	 orif	fs
	 endif
	 cmpb	b'1100,r4	;Strings already done
	 if	ne
	  movb	":",r5
	  bsr	char_tx
	  addr	t_mode[r4:d],r1 ;Mode label
	  movqd 4,r0
	  bsr	trl_blnk
	  bsr	str_out
	 endif
	endif
	ret


asm_perr:
	cmpqd	0,cond_ptr	;Check condition stack, must be 0
	if	ne
	 addqd	1,m_errct
	 bsr	dsp_msg
	 byte	"Unterminated IF/UNTIL/WHILE block",cr,lf,0
	 bsr	last_cnd:d	;Display last line where stack was clear
	endif

	cmpqb	0,acnd_ptr	;Check condition stack, must be 0
	if	ne
	 addqd	1,m_errct
	 bsr	dsp_msg
	 byte	"Unterminated conditional assembly block after line ",0
	 movd	acnd_lst,r5
	 bsr	dsp_r5
	 bsr	do_cr
	endif

	cmpqd	0,mac_rd	;Check for unterminated macro
	if	ne
	 addqd	1,m_errct
	 bsr	dsp_msg
	 byte	"Unterminated macro after line ",0
	 movd	m_macclr,r5
	 bsr	dsp_r5
	 bsr	do_cr
	endif

	cmpqb	0,m_proc	;Check for unterminated procedure
	if	ne
	 addqd	1,m_errct
	 bsr	dsp_msg
	 db	"Unterminated FP procedure block",cr,lf,0
	endif

	ret

;Assemble a line in (R1)
;Update cross reference
;Display errors as necessary

a_onelin:
	tbitb	b_xrf,m_dolst	;See if cross reference required
	if	fs
	 cmpqb	1,m_pass	;Only on pass 1
	 if	eq
	  movd	m_xrflin,m_xrfptr ;Start of XREF for current line
	  movw	m_linlst,(m_xrfptr) ;Start with line number
	  movqb	0,2(m_xrfptr)	;No entries so far
	  addqd	3,m_xrflin	;Next available address
	 endif
	endif

	movd	(m_amodp),m_lstmod ;Current mode pointer for listing
	bsr	asm_line	;Assemble one line and list as necessary

	tbitb	b_xrf,m_dolst	;See if cross reference required
	if	fs
	 cmpqb	1,m_pass	;Only on pass 1
	 if	eq
	  cmpqb	0,2(m_xrfptr)	;See if any entries made
	  if	eq
	   movd	m_xrfptr,m_xrflin ;Reset pointer, erase line number and count
	  endif
	 endif
	endif

;If macro just started, do it now

	tbitb	b_mac,m_opcod
	if	fs
	 proc
	 reg	[r1,r2,r3]
buf:	 ds	buf_siz
	 code
	 addr	buf,r2		;Translate here
	 bsr	do_macro:d	;R1 points to untranslated source
	 pend
	 
	 movd	r7,r4
	 subd	r3,r4		;Total bytes generated
	endif
	ret


;List line in (R1)
;R4 holds number of bytes assembled
;R3 points to 1st byte of object code assembled

a_onelst:
	tbitb	b_1lst,m_dolst
	if	fc		;Always list if FS
	 cmpqb	1,m_pass	;Don't list on pass 1
	 if	eq
	  addqd	1,m_linlst	;Just increment list counter on pass 1
	  ret
	 endif
	endif

	proc
	reg	[all]
buf:	blkb	60
	code

	movb	tx_dev,tos
	movb	dev_pr,tx_dev	;Send output to printer
	save	[r1]		;Save pointer to source text
	movb	"0",m_rpad	;Padding character
	movqb	5,m_rfld	;Field size
	movw	10+exp b_fld,tos ;Base 10, pad to 5 characters
	movd	m_linlst,tos
	bsr	dsp_tos
	bsr	dsp_msg
	byte	":",9,0
	movqd	0,r0
	addr	buf,r1		;Build output here
	cmpqd	0,r4		;Force PC relative if code generated
	if	ne		;In case mode just changed
	 movd	m_pcptr,r5
	 subd	r4,r5		;Backup to starting address
	else
	 movd	m_lstmod,r5
	endif
	bsr	byt_4r5
	movb	" ",r1[r0:b]
	addqd	1,r0
	
;Display up to 11 bytes of hex code (40 characters before text)
;R3 holds pointer, R4 holds total bytes generated
	  
	save	[r4]
	cmpd	11,r4
	if	lo
	 movzbd 11,r4		;Max number of bytes to do
	endif
	begin
	 cmpqb 0,r4
	while	ne
	 movb	(r3),r5
	 bsr	byt_1r5		;Put one byte into listing
	 addqd 1,r3
	 addqb -1,r4
	endw
	bsr	str_out
	restore	[r4]		;Total bytes of object code
	  
;Now pad listing to 40 characters
	  
	bsr	dsp_msg
	db	vc_scr,vcs_tab,0 ;Prepare for horizontal position
	movzbd	40,r5		;Horizontal position
	bsr	char_tx

	restore	[r1]
	bsr	dsp_cr		;Display source code now

	cmpd	m_width,r4
	if	lo		;Don't display more than M_WIDTH bytes
	 movd	m_width,r4
	endif
	subd	11,r4
	cmpqd	0,r4
	if	lt		;See if more object code to display
	 movd	r4,r6
	 movqd	0,r7		;Remaining count in Dword in R1R0
	 deid	11,r6		;Line count in R1, remaining count in R0
	 begin
	  cmpqd	0,r7
	 while	ne
	  bsr	dsp_msg
	  db	9,9," ",0	;Starting position for object code
	  movzbd 11,r2		;Number of bytes in a line
	  movqd	0,r0
	  addr	buf,r1		;Build output here
	  until	eq
	   movb	(r3),r5
	   bsr	byt_1r5		;Put one byte into listing
	   addqd 1,r3
	   addqb -1,r2
	   cmpqb 0,r2
	  endu
	  addqd	-1,r7
	  bsr	str_out
	  bsr	do_cr		;New line
	 endw
	 cmpqd	0,r6		;Remaining bytes
	 if	ne
	  bsr	dsp_msg
	  db	9,9," ",0	;Starting position for object code
	  movqd	0,r0
	  addr	buf,r1		;Build output here
	  until eq
	   movb (r3),r5
	   bsr	byt_1r5		;Put one byte into listing
	   addqd 1,r3
	   addqb -1,r6
	   cmpqb 0,r6
	  endu
	  bsr	str_out
	  bsr	do_cr		;New line
	 endif
	endif

	addqd	1,m_linlst	;Increment listing pointer
	movb	tos,tx_dev
	pend
	ret

;Linker cold start routine
;Before multi-file assembly/link/load

lnk_cst:
	movqd	0,mod_indx	;Clear MOD table
	movqd	0,lmod		;Start with module 0
	movqd	0,msym_beg	;Starting offset for current module's symbols
	movzwd	h'800,m_stksiz	;Default size is 2K
	movqd	0,m_stksiz+4	;Default address is relocatable

	addr	last_buf:d(sb),r0 ;Beginning of general storage
	addqd	3,r0
	bicb	3,r0		;Round up to Dword boundary

;STRING, CXP, XRF, LINK, SYMBOL tables must stay in this order

	movd	r0,m_string	;Start of string table
	movd	r0,m_strptr	;Next available byte of table

	addd	h'200,r0
	movd	r0,t_cxp
	movd	r0,t_cxpx

	addd	h'200,r0
	movd	r0,m_xrf	;Cross reference starts here
	movd	r0,m_xrfptr	;Base address for current line
	movd	r0,m_xrflin	;Actual symbol reference pointer

	addd	h'200,r0
	movd	r0,m_link	;Start of link buffer
	movd	r0,m_linkm	;Start of current module's link buffer
	movd	r0,m_lnkptr	;Initialize link pointer to beginning
	
	addd	h'200,r0
	movd	r0,t_symbl	;Initialize start of symbol table
	movd	r0,tsym_end	;Initialize symbol table end
	movd	r0,msym_end	;Ending address for current module's symbols

	save	[r1]
	addr	t_symalf,r1	;Source for move
	addr	1(r1),r2	;Target for move
	movqb	-1,(r1)
	movzwd	sidx_of*13*("Z"-"A"+1)-1,r0 ;Count for move
	movsb			;Fill offsets with 0
	restore	[r1]

	movqd	1,m_lincnt	;Start with line 1
	movqd	1,m_linlst	;Listing pointer

	movd	sidx_end,t_symlnk ;Link index

	ret

;Assembler cold start routine
;R7 holds base address for code

asm_cst:
	save	[r0,r1]
	movd	mod_indx,r0
	movd	r0,lmod		;Current module
	muld	mod_tsiz,r0	;Offset to current MOD_TABL entry
	addr	mod_tabl[r0:b],r1
	movqd	0,(r1)		;PC size
	movqd	0,4(r1)		;SB size
	movqw	-1,4+4(r1)	;Initial data index
	movd	tsym_end,r0
	subd	t_symbl,r0	;Offset to 1st symbol entry for this module
	movd	r0,msym_beg	;Start of this module's symbols
	movd	r0,4+4+2(r1)	;Store offset - pad upper bits with 0
	movd	sidx_end,4+4+2+sidx_of(r1) ;Offset to name (padded with 0s)
	movd	r7,4+4+2+2*sidx_of(r1) ;M_PCOFST for this module
	movqd	-1,4+4+2+2*sidx_of+4(r1) ;Starting PC
	movqd	-1,4+4+2+2*sidx_of+4+4(r1) ;Starting SB
	movqd	-1,4+4+2+2*sidx_of+4+4+4(r1) ;Starting MOD
	movqd	-1,4+4+2+2*sidx_of+4+4+4+4(r1) ;Starting LINK

	addqd	1,mod_indx
	restore	[r0,r1]

	movqb	0,lnk_prm	;Clear all parameters

;Fall through to :

;ASM_INIT is full initialization for LINK pseudo-op (keeps module data)
;ASM_IN1 is initialization for single line assembly
;ASM_IN2 is initialization required before each pass begins

asm_init:
	movd	r7,m_pcofst	;Save object code base address
	movqd	0,m_pcptr	;Initial PC offset
	movqd	0,m_spptr	;Initial SP offset
	movqd	0,m_fpptr	;Initial FP offset
	movqd	0,m_sbptr	;Initial SB offset
	movqb	1,m_pass	;Initialize pass counter
	movzbd	11,m_width	;Initialize width
	movd	sidx_end,t_symfp ;FP index - keep until new FP block
asm_in1:
	movd	m_linkm,m_lnkptr ;Re-initialize pointer

	movqd	0,m_errct	;Initialize error count
	movzbd	40,max_err	;Max errors before abort
	movd	m_pcptr,old_pc	;Save starting values
	movd	m_spptr,old_sp
	movd	m_fpptr,old_fp
	movd	m_sbptr,old_sb
asm_in2:
	movd	old_pc,m_pcptr	;Restore starting settings
	movd	old_sp,m_spptr
	movd	old_fp,m_fpptr
	movd	old_sb,m_sbptr
	movqd	0,m_imptr	;These always start at 0
	movqd	0,m_imdptr

	movqb	4,m_dspsz	;Default displacement size is :D
	cbitb	b_rpn,m_radix
	inssb	10,m_radix,0,5	;Start with decimal, RPN off
	
	movd	sidx_end,t_symlcl ;Local index
	movqd	-1,sym_last	;Invalidate M_SYMADR
	addr	t_symalf,sym_last+4 ;Start at beginning here

	movqd	0,cond_ptr	;Conditional structure stack index
	movqd	0,math_ptr	;Re-initialize math stack index
	addr	m_pcptr,m_amodp	;Start with PC relative mode
	movb	b'11011,m_amode	;PC relative mode
	movqb	0,m_ascond	;Comment, conditional assembly flags
	movqb	0,mac_ex	;No MACRO in progress
	movqd	0,mac_rd	;Not reading MACROs
	movqb	0,mac_cnt	;MACRO counter

	movqb	0,m_proc	;Make PROC block inactive
	movqd	-1,m_prcstk	;Make stack size invalid

	movd	m_lincnt,m_cndclr ;Last line where condition stack empty
	movd	m_lincnt,acnd_lst ;Line where conditional assembly stack clear
	movd	m_lincnt,m_macclr ;1st line where nested macros clear

	movqb	0,acnd_ptr	;Conditional assembly stack pointer
	movqd	0,mac_lbl	;Local label name counter

	addr	t_delim,m_delim	;Translation tables
	addr	t_delim2,m_delim2 ;Default to Kotekan translation

	ret	0


;Assemble 1 line
;R1 points to source code, R7 points to address for object code
;On exit, R3=previous PC, R4=number of bytes generated
;R1 unchanged, R7 updated, M_PCPTR updated
;List line as necessary

asm_line:
	lproc	1		;General label
	reg	[r1,r2,r5,r6]
albuf:	blkb	buf_siz		;Translation buffer
	code

	movd	mac_rd,tos	;Save current read status
	movb	m_ascond,tos	;Last conditional assembly status
	movd	m_errct,tos	;Starting error count
	movd	r1,tos		;Current source code pointer
	movd	r7,tos		;Current object code pointer
	movd	var_ptr,tos	;Save current beginning

	addr	albuf,r2	;Translation buffer
	bsr	asm_sub

	movd	tos,var_ptr	;Clear variable array
	movd	tos,r3		;Previous PC pointer
	movd	tos,r1		;Beginning of line

	negd	r3,r4
	addd	r7,r4		;Number of bytes generated

	addd	r4,m_pcptr	;Update PC pointer
	movd	m_pcptr,r7	;PC_PTR may have been updated by BLKB
	addd	m_pcofst,r7

	tbitb	b_xlat,m_ascond	;See if translation enabled
	if	fs
	 addr	albuf,r1	;Display translated line instead
	endif

;Check for errors in line just assembled

	movd	tos,r6		;Error count before last line
	cmpd	m_errct,r6	;Display if new errors
	if	ne
	 tbitb	b_alist,m_dolst	;Display if not listing
	 if	fc
	  bsr	dsp_err		;Display line just assembled
	 else
	  cmpqb	2,m_pass
	 orif	ne		;Display if listing but not pass 2
	 endif
	endif

;Display here if enabled
;R3 holds pointer to code, R4 holds count

	movb	tos,r6		;Last M_ASCOND
	movd	tos,r5		;Last MACRO read status (MAC_RD)
	tbitb	b_alist,m_dolst	;Listing flag
	if	fs		;List not requested if FC
	 andb	m_ascond,r6	;Always list COND line of false conditioal
	 tbitb	b_asmbl,r6	;False conditional in progess if FS
	 if	fc		;No false conditionals if FC
	  ord	mac_rd,r5
	  cmpqd	0,r5		;Last MEND counts as read line
	  if	eq		;Always list if not reading
	   bsr	a_onelst	;List line
	  else
	   cmpqb 0,mac_ex
	  orif	eq		;List read block if not executing
	  endif
	 else
	  tbitb	b_fclst,m_dolst	;See if false conditionals should be listed
	 orif	fs		;List falst condtionals if FS
	 endif
	endif
	
	pend

;Display line just assembled, R1=> source
;R3 => 1st byte of object code

dsp_err:
	lproc	1
	reg	[r0,r1,r5,r6]
al2buf:	ds	60
	code

	bsr	dsp_msg
	byte	"Line ",0	;Display line number 1st
	movd	m_lincnt,r5
	bsr	dsp_r5

	save	[r1]
	addr	al2buf,r1
	movqd	0,r0
	movd	r3,r5		;Old PC
	movzbd	h'b,r6		;PC type

	movw	m_radix,tos
	movw	16+exp b_sign+exp b_rdx,m_radix ;Signed hex with radix
	bsr	sym_r5		;Display nearest PC symbol
	movw	tos,m_radix

	bsr	str_out
	restore [r1]
	bsr	dsp_msg
	db	$": ",0
	bsr	dsp_cr		;Display source now
	pend


;Display line of object code just assembled
;R3 holds address, R4 holds number of bytes

dsp_alin:
	cmpqd	0,r4		;No code to display if 0
	beq	return

	cmpw	exp b_ps+h'f2,m_opcod ;See if that was .BLKB
	beq	return		;Don't display this either

	save	[r0,r1,r3,r4,r5]
	cmpd	20,r4
	if	lo		;Don't display more than 20 bytes
	 movzbd	20,r4
	endif
	movqd	0,r0
	addr	hb,r1
	movd	r3,r5
	bsr	byt_4r5		;Display current program counter
	movb	":",r1[r0:b]
	movb	" ",1(r1)[r0:b]
	addqd	2,r0

asm_1a:	movb	0(r3),r5
	bsr	byt_1r5
	addqd	1,r3		;Advance pointer
	acbb	-1,r4,asm_1a
	movw	cr+256*lf,r1[r0:b]
	addqd	2,r0
	bsr	str_out

	restore	[r0,r1,r3,r4,r5]
	ret	0


;Display message in (R1) until CR

dsp_cr:	save	[r0,r1,r4]
	movb	cr,r4
	bsr	strx_len
	bsr	str_out
	bsr	do_cr
	restore	[r0,r1,r4]
	ret	0


;See if string is label for another string, translate if so
;Just keep original string and update pointer with length if not
;Stack holds text buffer, length, string pointer
;Text buffer pointer updated and returned on stack
;Null strings replaced with $<>

str_xlat:
	lproc
buf:	blkb	4		;Next buffer address
slen:	blkb	1		;Length of string
	reg	[r0,r1,r2,r3,r4]
	code

	movd	buf,r4		;Save starting address
	movzbd	slen,r0
	movd	buf,r1
	addd	r0,buf		;Default is keep existing text
	tbitb	b_lxlat,m_ascond ;Check for local or general translation
	if	fs
	 addr	t_symlcl,r3	;Local only if FS
	 bsr	sym2sub		;See if this represents another string
	else
	 bsr	sym2val		;Check all symbols
	endif
	if	eq
	 extsb	sidx_of+1(r2),r3,b_mode-8,4 ;See if this is a string
	 cmpb	b'1100,r3	;Must be literal text
	 if	eq
	  tbitb	b_def,sidx_of(r2)
	  if	fs
	   extsb sidx_of+1(r2),r3,b_size-8,4 ;Pointer mode
	   cmpb	b'1000,r3	;Length, text
	   if	eq
	    movzwd sidx_of+2(r2),r0 ;Length of text
	    movd sidx_of+2+2(r2),r1 ;Pointer to text
	    movd r4,r2		;Target for move
	    cmpqd 0,r0		;Null strings require special treatment
	    if	ne
	     movsb
	    else
	     movw "$<",(r2)
	     movb ">",2(r2)
	     addqd 3,r2
	    endif
	    movd r2,buf
	   endif
	  endif
	 endif
	endif

	pend	buf-slen	;Return Buffer pointer on stack


;Build expression until expression terminator
;TOS holds target buffer, pointer to source
;Buffer address and source pointer updated and returned on stack

bld_exp:
	lproc
buf:	blkb	4		;Target buffer
ptr:	blkb	4		;Current source pointer
	reg	[r1,r2,r3,r4]
	code

	movd	buf,r2
	movd	ptr,r1
	movd	m_delim,r3
	movzbd	(r1),r4
	begin
	 cmpb trm_lin,r3[r4:b] ;Quit now if end of line
	quit hs
	 cmpb trm_exp,r3[r4:b]
	while ne
	 movd	r2,tos		;Target pointer
	 movd	r1,tos		;Source pointer
	 movb	trm_wrd,tos	;Skip anything bigger or equal to this
	 bsr	skp_spc		;Skip inter-word spaces
	 bsr	bld_str
	 movd	tos,r1		;Source updated
	 movd	tos,r2		;Target updated
	 movzbd	(r1),r4
	endw

	movd	r1,ptr
	movd	r2,buf
	pend	0


;Copy inter-word characters from PTR to BUF
;TOS holds buffer, pointer to string, smallest terminator to include
;Buffer updated and returned on stack

skp_spc:
	lproc
buf:	blkb	4		;Target buffer
ptr:	blkb	4		;Starting address of word
trm:	blkb	1		;Smallest terminator
	reg	[r1,r2,r3,r4,r5]
	code

	movd	ptr,r1		;Source address
	movd	buf,r2		;Target address
	movzbd	trm,r5
	movd	m_delim,r3	;Translation table
	movzbd	(r1),r4

 	begin			;Copy inter-word characters
	 begin
	  cmpb	trm_str,r3[r4:b]
	 while	eq
	  addqd	1,r1
	  movzbd (r1),r4
	 endw
	 cmpb	r5,r3[r4:b]
	quit	hi		;End of the line if HI
	 cmpb	trm_blnk,r3[r4:b]
	while	hs
	 movb	r4,(r2)
	 addqd	1,r1
	 addqd	1,r2
	 movzbd	(r1),r4
	endw

	movd	r1,ptr
	movd	r2,buf
	pend	ptr-trm


;R1 => quoted source line, build string in (R2)
;If NSCGNX then also process \ esc characters
;(R1) => Closing quote+1 on exit
;EQ true if OK

bld_quot:
	save	[r3,r4,r5]

	movb	(r1),r5		;Termination character
	addqd	1,r1		;Advance to next character
	movd	m_delim,r3
	begin
	 movzbd	(r1),r4
	 cmpqb	trm_cr+1,r3[r4:b]
	quit	hi		;Need NE if error
	 addqd	1,r1
	 cmpb	r4,r5		;Check for termination
	while	ne
	 tbitb	b_nscgnx,m_ascond
	 if	fc		;Everything literal if no NSCGNX
	  movb	r4,(r2)		;Copy current character
	  addqd	1,r2		;Target pointer
	 else
	  cmpb	"\",r4		;Check for \ ESC character
	 orif	ne
	  save	[r3,r5]
	  movzbw (r1),r4
	  subb	"0",r4
	  cmpb	9,r4		;Check for octal code
	  if	hs
	   movqb 1,r3		;Character counter (3 max)
	   begin
	    addqd 1,r1		;Advance to character
	    cmpqb 3,r3
	   quit	eq
	    movzbw (r1),r5
	    subb "0",r5
	    cmpb 9,r5		;Check for octal code
	   while hs
	    lshw 3,r4		;Multiply by 8
	    addw r5,r4
	    addqb 1,r3
	   endw
	   cmpw	h'ff,r4		;Max allowable value
	   if	lo
	    bsr	prm_ovfl
	   endif
	  else			;Some kind of ESC character
	   movb	(r1),r5
	   addqd 1,r1
	   movb	tab,r4
	   cmpb	"t",r5
	   if	ne
	    movb bksp,r4
	    cmpb "b",r5		;Backspace
	    if	ne	
	     movb cr,r4		
	     cmpb "r",r5	;CR
	     if ne
	      movb ff,r4
	      cmpb "f",r5	;FF
	      if ne
	       movb r5,r4	;Anything else is taken literally
	       cmpb "n",r5	;New line is 2 characters
	       if eq
	        movb cr,(r2)
	        addqd 1,r2
	        movb lf,r4
	       endif
	      endif
	     endif
	    endif
	   endif
	  endif
	  movb	r4,(r2)
	  addqd 1,r2
	  restore [r3,r5]
	 endif
	endw

	restore	[r3,r4,r5]
	ret

;Build a string until word separator encountered
;TOS holds buffer, pointer to string, buffer updated and returned on stack
;Termination character not moved

bld_str:
	lproc
buf:	blkb	4		;Target buffer
ptr:	blkb	4		;Starting address of word
	reg	[all]
buf_st:	blkb	4		;Starting buffer address
	code

	movd	buf,buf_st	;Starting address of target text
	movd	ptr,r1		;Source address
	movd	buf,r2		;Target address
	movd	m_delim,r3	;Translation table
	movzbd	(r1),r4

;	BEGIN			;Skip null characters
;	 CMPQB	TRM_NUL,R3[R4:B]
;	WHILE	EQ
;	 ADDQD	1,R1
;	 MOVZBD	(R1),R4
;	ENDW

	cmpb	"'",r3[r4:b]	;Don't translate quoted strings
	if	eq
	 save	[r0]
	 save	[r1,r2]
	 bsr	str_len		;Length of text in R0
	 addr	r1[r2:b],r0	;Address of next character after final quote
	 restore [r1,r2]
	 subd	r1,r0		;Total length including quotes
	 movsb
	 restore [r0]
	 movzbd	(r1),r4		;Next character
	else
	 cmpb	'"',r3[r4:b]
	orif	eq
	endif

	cmpb	"%",r4		;Replace label with ASCII value
	if	eq
	 addqd	1,r1
	 movd	r2,tos		;Target buffer
	 movd	r1,tos		;Source pointer
	 bsr	bld_str
	 movd	tos,r6		;Updated source pointer
	 movd	tos,r5		;Updated target pointer
	 movb	cr,(r5)		;Terminate expression
	 movd	r2,r1		;Address of new string to R1
	 bsr	get_of1		;Resolve expression after "%"
	 if	fs
	  bsr	sym_und
	  movqd	0,r5
	 endif
	 movd	r2,r1		;Target base address
	 movqd	0,r0		;Current length of string
	 bsr	put_r5
	 addr	r1[r0:b],r2	;Next translation pointer to R2
	 movd	r6,r1		;Next source pointer
	 movzbd	(r1),r4
	endif

	begin			;Go until end of word
	 movzbd	(r1),r4		;Current character
	 cmpb	trm_blnk,r3[r4:b]
	while	lo
	 cmpb	trm_inst,r3[r4:b]
	 if	ne
	  movb	r3[r4:b],(r2)
	  addqd	1,r1
	  addqd	1,r2
	 else
	  movd	buf_st,tos	;Start of text
	  movd	r2,r0
	  subd	buf_st,r0	;Length of current word
	  movb	r0,tos		;Length so far
	  bsr	str_xlat	;See if this is a string label
	  movd	tos,r2		;Buffer pointer updated
	  cmpb	"^",r4		;Take next character literally
	  if	eq
	   addqd 1,r1
	   movzbd (r1),r4
	   cmpb	trm_cr,r3[r4:b]
	   if	lo
	    movb r4,(r2)	;Don't translate this character
	    addqd 1,r1
	    addqd 1,r2
	    movzbd (r1),r4
	   endif
	  else
	  cmpb	"&",r4		;Concatenate this and following string
	   if	eq
	    addqd 1,r1
	    movd r2,tos		;Target buffer
	    movd r1,tos		;Source pointer
	    bsr bld_str
	    movd tos,r1		;Updated source pointer
	    movd tos,r2		;New target pointer
	    movzbd (r1),r4
	   else
	    movb (r1),(r2)	;Copy but don't increment length
	    addqd 1,r1
	    addqd 1,r2
	   endif
	  endif
	 endif
	endw

	movd	buf_st,tos	;Base address
	movd	r2,r0
	subd	buf_st,r0	;Length of current word
	movb	r0,tos		;Length of entire string
	bsr	str_xlat	;See if entire string is label
	movd	tos,r2		;Updated target pointer

	movd	r1,ptr
	movd	r2,buf
	pend	0		;Leave updated pointers on stack


;Build translated line in R2
;R1, R2 point to next available slot
;R1 points to character that terminated translation,
;but everything copied to R2

bld_lin:
	save	[r0,r3,r4,r5,r6]
	movd	r1,r6		;Save start of source line
	movd	m_delim,r3	;Translation table

	bsr	next		;Check for comment block
	cmpb	"{",(r1)
	movd	r6,r1		;Restore beginning of line
	if	eq
	 sbitb	b_comnt,m_ascond
	endif

	tbitb	b_comnt,m_ascond
	if	fs		;If comment block then check for end
	 movzbd	buf_siz,r0	;Max search length
	 movb	cr,r4
	 skpsb	u		;Advance to end of line
	 cmpb	buf_siz,r0
	 if	gt		;Can't backup if line is empty
	  movb	trm_blnk,r4	;Remove these from end of line
	  addqd	-1,r1		;Backup past CR
	  skpst	b,w		;Point to last non-blank
	 endif
	 cmpb	"}",(r1)	;Check for end of comment block
	 if	eq
	  cbitb	b_comnt,m_ascond
	 endif
	 movd	r6,r1		;Restore beginning of line
	else			;No comment block
	 tbitb	b_xlat,m_ascond	;See if translation enabled
	 if	fc
	  movzbd buf_siz,r0	;Max line length
	  movd	m_delim2,r3	;Quick translation
	  begin
	   movqb 0,r4
	   movst u
	  while	fs		;Got a match if FS
	   cmpb	"'",(r1)
	   if	ne
	    cmpb '"',(r1)
	   endif
	  quit	ne
	   cmpd	r1,r6
	   if	hi		;Must be past 1st character
	    movzbd -1(r1),r5
	   else
	    movzbd " ",r5	;Always good at beginning
	   endif
	   cmpb	"$",r5		;Quotes may follow this
	   if	ne
	    cmpb "&",r5		;This too
	   endif
	   if	eq
	    movd r0,tos		;Remaining length
	    save [r1,r2]
	    bsr str_len		;Length of text in R0
	    addr r1[r2:b],r0	;Next character after string
	    restore [r1,r2]
	    subd r1,r0		;Total length including quotes
	    movd r0,tos
	    movsb
	    negd tos,r0
	    addd tos,r0		;New remaining length
	   else
	    cmpqb trm_blnk,(m_delim)[r5:b] ;Quotes must start a new operand
	    if	hs
	     cmpb (m_delim)[r5:b],trm_str+1 ;Not before opening quote
	    endif
	   orif	hs
	    movb (r1),(r2)	;Just copy quote as character
	    addqd 1,r1
	    addqd 1,r2
	    addqd -1,r0
	   endif
	  endw
	 else			;XLAT on
	  begin
	   movzbd (r1),r4
	   cmpb trm_lin,r3[r4:b]
	  while	lo
	   cmpb trm_blnk,r3[r4:b]
	   if	lo
	    movd r2,tos		;Target address
	    movd r1,tos
	    bsr bld_str
	    movd tos,r1
	    movd tos,r2		;Pointers updated
	    movzbd (r1),r4
	   endif
	   cmpb trm_str,r3[r4:b]
	   if	lo
	    movb r4,(r2)	;Copy these as is
	    addqd 1,r2
	    addqd 1,r1
	   else
	    if	eq
	     addqd 1,r1	;Just ignore these
	    endif
	   endif
	  endw
	 endif
	endif

;Copy remaining comments or whatever as is

	save	[r1]		;Return R1 pointing to terminator
	movzbd	buf_siz-1,r0	;Finite length
	subd	r1,r0
	addd	r6,r0		;Remaining length
	movb	cr,r4		;Real end of line
	movsb	u
	movb	r4,(r2)		;Move CR too, line always terminated
	addqd	1,r2
	restore	[r1]

	restore	[r0,r3,r4,r5,r6]
	ret	

;R1 holds address of source code
;R2 holds address of translation buffer
;R7 holds address for object code

asm_sub:
	movw	h'ff,m_opcod	;Clear this for now
	movd	r1,m_srcptr	;Pointer to source code line
	movd	r2,r6		;Save original R2

	movb	m_ascond,r3	;Original comment block status
	bsr	bld_lin		;Translate line from R1 to R2
	orb	m_ascond,r3	;Merge new status
	tbitb	b_comnt,r3	;See if this is a comment block
	bfs	return		;Comment if beginning or end of block

	tbitb	b_asmbl,m_ascond ;Set if false conditional being processed
	if	fs
	 movd	r6,r1		;Beginning of translated line
	 bsr	next		;R1 points to opcode if any
	 bfs	return		;No more text
	 addr	tpsopa,tos	;Pseudo-op table
	 addr	tpsopalf,tos	;Pseudo-op index
	 bsr	fnd_opcd	;Check for opcode match
	 bne	return		;Not opcode if NE
	 cmpb	cc_cond,m_opcod
	 if	ne
	  cmpb	cc_cend,m_opcod	;Check for end
	  if	ne
	   cmpb	cc_celse,m_opcod ;Check for else
	   bne	return
	  endif
	 endif
	endif

	cmpqd	0,mac_rd	;See if reading in MACRO line
	if	ne
	 movd	m_strptr,tos	;Save beginning of current storage
	 cmpqb	0,mac_ex	;If macro is executing, don't store again
	 if	eq
	  cmpqb	2,m_pass	;Don't store again on 2nd pass
	  if	ne
;	   MOVD	M_SRCPTR,R1	;Pointer to untranslated source
	   movd	r6,r1		;Pointer to translated source
	   movd	m_delim,r3
	   movqd 0,r0		;Initialize length
	   save	[r1]
	   begin
	    cmpw ";;",(r1)	;Don't store ";;" comments
	   quit	eq
	    movzbd (r1),r4
	    cmpb trm_cr,r3[r4:b]
	   while lo
	    addqd 1,r0		;Increment length
	    addqd 1,r1
	   endw
	   restore [r1]
	   bsr	trl_blnk	;Remove trailing blanks
	   addr	r1[r0:b],r2	;Last character+1
	   movb	(r2),r3		;Save actual last character
	   movb	cr,(r2)		;Line must end with this
	   addqd 1,r0		;Always include delimiter
	   movd	r0,tos		;Length to store
	   movd	r1,tos		;Starting address to store
	   bsr	put_str		;Store string
	   movb	r3,(r2)
	  endif
	 endif
	 movd	tos,r4		;Beginning of current line for IRPL

;Check for MEND or a nested macro in this line

	 movd	r6,r1		;Beginning of translated line
	 bsr	length
	 addd	r0,r1
	 bsr	skp_coln
	 bsr	next		;R1 points to opcode if any
	 bfs	return		;No more text
	 addr	tpsopa,tos	;Pseudo-op table
	 addr	tpsopalf,tos	;Pseudo-op index
	 bsr	fnd_opcd	;Check for opcode match
	 bne	return		;Not opcode if NE
	 cmpb	16*op_mac+mac_mac,m_opcod ;Check for nested MACRO
	 if	eq
	  addqd	1,mac_rd
	 else
	  cmpb	16*op_mac+mac_rpt,m_opcod ;Check for nested REPT
	 orif	eq
	  cmpb	16*op_mac+mac_rpc,m_opcod ;Check for nested IRPC
	 orif	eq
	  cmpb	16*op_mac+mac_irp,m_opcod ;Check for nested IRP
	 orif	eq
	  cmpb	16*op_mac+mac_rpl,m_opcod ;Check for nested IRPL
	 orif	eq
	  cmpb	16*op_mac+mac_lnd,m_opcod ;Check for LEND
	  if	eq		;Put end marker so IRPL can find macro text
	   cmpqb 0,mac_ex	;Don't do anything if MACRO executing now
	   if	eq
	    movb vc_xpag,(r4)	;Termination of parameters
	   endif
	  else
	   cmpb	16*op_mac+mac_end,m_opcod ;See if end of MACRO block
	   if	eq
	    addqd -1,mac_rd
	    cmpqd 0,mac_rd
	    if	eq		;Just terminated complete block
	     movd m_lincnt,m_macclr ;MACRO nesting clear here
	     cmpb 16*op_mac+mac_mac,mac_stk ;See if this was MACRO or Repeat
	     if	ne		;If repeat block, do it now
	      sbitb b_mac,m_opcod ;Next instruction is macro expansion
	     endif
	    endif
	   endif
	  endif
	 endif
	 ret
	endif

	movd	r6,r1		;Address of translated line
	bsr	next		;See if anything in line
	bfs	return
	bsr	lnk_spac	;Make room in the link buffer
	bfs	return		;No room if FS
	bsr	xrf_spc
	bfs	return
	movd	r6,r1		;Start over at beginning

;If a character is in column 1, assume it's a symbol

	movd	sidx_end,m_symadr ;No symbol yet
	bsr	length
	cmpqd	0,r0		;Nothing in column 1 if length is 0
	beq	no_sym

	cmpb	b'11000,m_amode	;Check for FP relative
	if	ne
	 bsr	sym2val		;Pointer to symbol in R2, prev. pointer in R3
	else
	 tbitb	b_fp,m_ascond	;Check for general FP storage
	orif	fs
	 addr	t_symfp,r3
	 bsr	sym2sub		;Error if not in local FP storage
	 if	ne		;Can't be in any other table either
	  save	[r2,r3]
	  bsr	sym2val
	  restore [r2,r3]
	  if	eq
	   bsr	dup_sym
	   br	put_sym2	;Skip over name and quit
	  endif
	 endif
	endif
	seqb	r4		;R4=0 if symbol not found

	cmpqb	2,m_pass	;If pass 2 just do phase check
	bne	asms_p1

	extsb	sidx_of(r2),r3,b_typ,2
	cmpqb	lbl_tmp,r3	;Temporary labels are always OK
	if	ne
	 extsb	sidx_of+1(r2),r3,b_mode-8,4 ;Get type designator
	 cmpb	b'1011,r3	;Check for PC relative
	 if	eq
	  cmpd	(m_amodp),sidx_of+2(r2)	;Must still match
	  if	ne
	   bsr	err_phs
	  endif
	 else
	  cmpb	b'1010,r3	;Check SB too
	 orif	eq
	 endif
	endif

	br	put_sym2	;Skip over name

;Phase error

err_phs:
	addqd	1,m_errct	;Phase error
	bsr	dsp_msg
	byte	"Phase error",cr,lf,0
	ret

asms_p1:
	cmpqb	0,r4		;EQ means symbol not found by SYM2VAL
	beq	put_sym		;Add new symbol

;If symbol already in table is defined, then error

	tbitb	b_def,sidx_of(r2)
	bfc	put_sym1
	extsb	sidx_of(r2),r4,b_typ,2 ;Get type designator
	cmpqb	lbl_tmp,r4
	beq	put_sym2	;Don't redefine temporary symbols
	br	dup_sym		;Duplicate symbol error
put_sym:
	movb	r0,tos		;Length of name
	movw	exp b_def+(h'20 lsh b_mode),tos ;Defined, variable length
	movd	r1,tos		;Pointer to name
	movd	r3,tos		;Address of previous symbol
	bsr	make_sym
put_sym1:
	movd	m_symadr,r2	;Address of symbol name in table
	addd	t_symbl,r2	;Convert to absolute address
	extsb	1(r2),r3,b_size-8,4 ;Check for integer
	cmpqb	3,r3
	if	hs		;Don't change here if not integer
	 movd	(m_amodp),2(r2)	;Store value of symbol
	 inssb	m_amode,1(r2),b_mode-8,4 ;Actual MODE
	 sbitb	b_def,(r2)
	 tbitb	2,lnk_prm
	 if	fs		;All SBs are global if FS
	  cmpb	b'11010,m_amode	;Check for SB
	  if	eq
	   inssb lbl_glb,(r2),b_typ,2
	  endif
	 endif
	endif

put_sym2:
	addd	r0,r1		;Skip over name

;R1 points to byte after symbol, skip ":" if there

do_coln:
	cmpw	"::",(r1)	;Global symbol if EQ
	if	eq
	 movd	m_symadr,r2	;Address of symbol name in table
	 addd	t_symbl,r2	;Convert to absolute address
	 inssb	lbl_glb,(r2),b_typ,2
	endif
	bsr	skp_coln

no_sym:	bsr	comma
	bfs	return		;Line exhausted if no new text

;Ready for opcode field now

	movd	m_errct,tos
	bsr	asm_opcd
	movd	tos,r3		;Old error count

;Don't do remainder check if other errors

	cmpd	r3,m_errct
	bne	return

;Shouldn't be anything left

	bsr	next
	bfs	return

;Error, display message and return

	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Extra text",cr,lf,0
	ret	0


;Pack current word in R1 into R4 as ASCII characters, pad with blanks
;On exit, R1 advanced past word

pad_blnk:
	save	[r0]
	bsr	wrd_len		;Get length of any string in R1
	bsr	pad_blsb:b
	restore	[r0]
	ret

;Length of word to pad into R4 must be in R0

pad_blsb:
	save	[r2]
	cmpqd	0,r0
	beq	padb3:b
	movqd	0,r2		;R4 index
	movd	"    ",r4
padb2:	insb	r2,0(r1),r4,8
	addb	8,r2

;Don't do more than 1st 4 characters

	cmpb	h'18,r2
	blo	padb3:b
	addqd	1,r1
	acbd	-1,r0,padb2
padb3:	addd	r0,r1		;Skip any remaining characters
	restore	[r2]
	ret	0


;Search opcode table for match with (R1)
;TOS must hold opcode table, table index
;M_OPCOD holds opcode format/code on exit, R0 holds length
;NE if no match found, EQ and R1 advanced if matched

fnd_opcd:
	lproc
t_op:	blkb	4		;Base address of opcode table
idx:	blkb	4		;Base address of opcode index
	reg	[r2,r4]
	code

	cmpb	".",(r1)	;Skip "." if there
	if	eq
	 addqd	1,r1		;Skip period
	endif
	bsr	length		;Get length of source code string in R0
	cmpqb	1,r0
	if	ls		;Just exit with NE set if no length
	 movzbd	0(r1),r4	;1st letter is index
	 subb	"A",r4
	quit	cs		;Must be at least "A"
	 cmpb	"Z",r4
	quit	lo		;Must be A-Z
	 movzwd	(idx)[r4:w],r2
	 addd	t_op,r2		;R2 points to 1st entry for this letter

;Main opcode search loop
;Find first letter, length in table, search until either changes

	 begin
	  cmpb	0(r1),2(r2)	;Compare 1st letters
	  quit	ne		;End of line if letters don't match
	  cmpb	r0,0(r2)	;1st character matches, check length
	 while	ne		;Advance pointer and try next opcode
	  movzbd 1(r2),r4	;Offset to next group
	  addd	r4,r2
	 endw

;Correct group within table found, now compare entire strings

	 if	eq		;Length test failed if NE
	  addqd	2,r2		;Advance to 1st actual character
	  begin
	   cmpb	"A",(r2)	;If not upper case, then no match was found
	   quit	hi		;End of this letter if HI, exit with NE
	   save	[r0,r1]
	   bsr	cmp_gen
	   addd	r0,r2		;Point R2 to format/opcode
	   restore [r0,r1]	;Length and name to search for
	  while	ne
	   addqd 1,r2		;Advance to next name and try again
	  endw

	  if	eq		;No match if NE
	   addd	r0,r1		;Advance past op name
	   movb	(r2),m_opcod	;Return opcode here
	  endif
	 endif
	qend
	 bicpsrb flag_z		;Must be NE if error
	endif
	pend


opcd_err:
	addd	r0,r1		;Advance past op name
	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Bad opcode",cr,lf,0
	bispsrb	flag_f
	ret	0



;Subroutine to build op codes in R7
;R1 points to 1st character of opcode in source
;R6 holds 10 byte buffer for parameters

asm_opcd:
	movzbd	2+8,r5
	bsr	aray_r5
	bfs	return
	movd	r5,r6		;Get short parameter array field in R6
	movw	exp b_def+(h'24 lsh b_mode),(r6) ;Defined constant

	movqw	0,m_opcod	;Clear opcode
	addr	t_op_a,tos	;Opcode table
	addr	t_alpha,tos	;Alpha index for opcodes
	bsr	fnd_opcd	;Find opcode
	if	eq
	 cmpb	h'32,m_opcod	;Check for BICPSRi
	 if	eq
	  cmpqb	4,m_siz		;May not be this
	  if	eq
	   bicpsrb flag_z	;Make not equal
	  else
	   bispsrb flag_z	;OK (EQ true) if B or W
	  endif
	 else
	  cmpb	h'36,m_opcod	;Check for BISPSRi
	 orif	eq
	  cmpb	h'76,m_opcod	;Check for MOVZiD
	 orif	eq
	  cmpb	h'77,m_opcod	;Check for MOVXiD
	 orif	eq
	  bispsrb flag_z	;Make EQ
	 endif
	endif
	if	ne		;No opcode match if NE
	 movd	m_symadr,tos	;Can't change this
	 bsr	sym2val		;See if we have a MACRO here
	 movd	tos,m_symadr
	 if	eq
	  cmpb	h'bc,sidx_of+b_mode/8(r2)
	  if	eq
	   tbitb b_def,sidx_of(r2) ;Must be defined
	   if	fs
	    sbitb b_mac,m_opcod	;Make macro
	    addd r0,r1		;Skip over macro name
	    addqd sidx_of,r2	;Advance past symbol index word
	    movb 16*op_mac+mac_mac,mac_stk ;Make this an actual MACRO
	    movd 2(r2),mac_stk+1 ;Pointer to text
	    tbitb b_xrf,m_dolst	;See if cross reference required
	    if	fs
	     cmpqb 1,m_pass
	     if	eq		;Only on pass 1
	      subd t_symbl,r2	;Offset to symbol name
	      inssd r2,(m_xrflin),0,sidx_bit
	      addqd sidx_of,m_xrflin
	      addqb 1,2(m_xrfptr) ;One more label
	     endif
	    endif
	    movb cr,r4
	    movqd -1,r0
	    skpsb u		;Advance past parameters
	    ret
	   endif
	  endif
	 endif
	 until	ne
	  addr	tpsopa,tos	;Pseudo-op table
	  addr	tpsopalf,tos	;Pseudo-op index
	  bsr	fnd_opcd
	  bne	opcd_err
	  cmpb	16*psop_sys+sys_pso,m_opcod ;Next word is new pseudo-op if EQ
	  if	eq
	   bsr	next
	   bispsrb flag_z	;Must still be EQ
	  endif
	 endu
	 sbitb	b_ps,m_opcod	;Make pseudo op
	endif	

;M_OPCOD holds format/opcode, branch to proper routine

	movqd	2,r5
	bsr	aray_r5
	bfs	return
	movd	r5,r4		;Need opcode parameter field in RAM
	movzbd	m_opcod,r5	;Need it here
	extsd	r5,r3,0,4	;Opcode in R3
	extsd	r5,r2,4,4	;Format index in R2

	tbitb	b_ps,m_opcod	;FS if pseudo op
	if	fc
	 movd	t_fmtp[r2:w],(r4) ;ASM_FLD parameters
fmt_cs:	 casew	t_fmt[r2:w]

;Format dispatch table

t_fmt:	 word	afmt_0-fmt_cs
	 word	afmt_1-fmt_cs
	 word	afmt_2-fmt_cs
	 word	afmt_3-fmt_cs
	 word	afmt_4-fmt_cs
	 word	afmt_5-fmt_cs
	 word	afmt_6-fmt_cs
	 word	afmt_7-fmt_cs
	 word	afmt_8-fmt_cs
	 word	afmt_9-fmt_cs
	 word	afmt_a-fmt_cs
	 word	afmt_b-fmt_cs
	 word	afmt_c-fmt_cs
	 word	afmt_d-fmt_cs
	 word	afmt_e-fmt_cs
	 word	afmt_f-fmt_cs
	else
psfmt:	 casew	$+4:b[r2:w]
	 word	pfmt_0-psfmt
	 word	pfmt_1-psfmt
	 word	pfmt_2-psfmt
	 word	pfmt_3-psfmt
	 word	pfmt_4-psfmt
	 word	pfmt_5-psfmt
	 word	pfmt_6-psfmt
	 word	pfmt_7-psfmt
	 word	pfmt_8-psfmt
	 word	pfmt_9-psfmt
	 word	pfmt_a-psfmt
	 word	pfmt_b-psfmt
	 word	pfmt_c-psfmt
	 word	pfmt_d-psfmt
	 word	pfmt_e-psfmt
	 word	pfmt_f-psfmt
	endif

;R1 points to source string, R2 points to table entry with same length
;Compare, check i/f/cc fields, return EQ if same, NE if not

cmp_gen:
	cmpsb
	beq	return		;Got a match if EQ

;No equal, check for i,f,cc

	cmpb	"a",0(r2)
	bhi	return		;No possible match here

	cmpb	"i",0(r2)
	beq	do_int
	cmpw	"cc",0(r2)
	beq	do_cond
	cmpb	"f",0(r2)
	bne	return

;"f" found, must be F or L in (R1)

	movqb	1,m_flt
	cmpb	"F",0(r1)
	beq	nxt_ifcc
	movqb	0,m_flt
	cmpb	"L",0(r1)
	beq	nxt_ifcc
	ret	0

;Make sure 0(R1) is B/W/D

do_int:
	movqb	0,m_int
	movqb	1,m_siz
	cmpb	"B",0(r1)
	beq	nxt_ifcc
	movqb	1,m_int
	movqb	2,m_siz
	cmpb	"W",0(r1)
	beq	nxt_ifcc
	movqb	3,m_int
	movqb	4,m_siz
	cmpb	"D",0(r1)
	beq	nxt_ifcc
	br	return

;"cc" found, check condition

do_cond:
	bsr	cond_chk
	bne	return

;Got a keeper, make sure rest of string matches

	addqd	-1,r0
	addqd	1,r1
	addqd	1,r2
	br	nxt_ifcc

t_cond:	.byte	$"GE"
	.byte	$"LT"
	.byte	$"HS"
	.byte	$"LO"
	.byte	$"FC"
	.byte	$"FS"
	.byte	$"LE"
	.byte	$"GT"
	.byte	$"LS"
	.byte	$"HI"
	.byte	$"CC"
	.byte	$"CS"
	.byte	$"NE"
	.byte	$"EQ"

;Good so far, check remainder of string if any
;If only 1 byte left then match

nxt_ifcc:
	addqd	-1,r0		;Must always reflect remaining length
	addqd	1,r1		;Keep pointers current too
	addqd	1,r2
	cmpqb	0,r0		;Exact match if string exhausted
	beq	return
	br	cmp_gen		;Check remainder of string

;Check for condition, EQ true on return if a match found
;M_COND holds condition code

cond_chk:
	cmpqb	2,r0
	bhi	return		;Impossible match if not 2 characters left

	save	[r0,r1,r4]
	movw	0(r1),r4
	movzbd	h'e,r0		;Number of conditions to check
	addr	t_cond,r1
	skpsw	u		;FS if match is found

;Load condition into M_COND

	addqb	-1,r0
	movb	r0,m_cond

	cmpqb	0,r0		;GT if no match found
	restore	[r0,r1,r4]
	bgt	return		;NE if GT (no match)
	bispsrb	flag_z
	ret	0


;Format parameter table
;Bits 0-1 are number of opcodes (1-3)
;Bit 2 set if B/W/D field present
;Bit 3 set if F/L field in bit 0
;Bit 4 set if F/L field in bit 2
;Bits 5-7 are offset to op field (1-7, 0 if none)
;Bits 8-10 are offset to short field (1-7, 0 if none)
;Bit 11 set if gen 1 present
;Bit 12 set if gen 2 present

t_fmtp:	.word	h'0081		;Format 0
	.word	h'0081		;Format 1
	.word	h'0f86		;Format 2
	.word	h'08e6		;Format 3
	.word	h'1846		;Format 4
	.word	h'0747		;Format 5
	.word	h'1847		;Format 6
	.word	h'1847		;Format 7
	.word	h'1b07		;Format 8
	.word	h'1877		;Format 9
	.word	h'0		;Format A
	.word	h'184b		;Format B
	.word	h'184b		;Format C
	.word	h'0		;Format D
	.word	h'0f43		;Format E
	.word	h'0		;Format F

;Mode selection error

mode_err:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Mode error",cr,lf,0
	ret


;Store op, short fields, int/flt bits, gens
;R5 holds op, (R6) holds short field if any
;(R4) holds format bit code
;R1 points to source code (byte after opcode name)
;R7 points to 1st byte of object code

asm_fld:
	save	[r0,r2,r3,r4,r5,r6]

	cmpb	b'11011,m_amode	;Must be PC mode
	if	ne
	 movb	b'11011,m_amode	;Select PC mode
	 addr	m_pcptr,m_amodp
	 bsr	mode_err
	endif

;Skip over 1st byte if 3 byte opcode

	extsd	0(r4),r0,0,2	;Size of opcode
	cmpqd	3,r0	
	if	eq
	 addqd	1,r7		;Prefix must already be loaded
	 addqd	-1,r0		;Only 2 bytes left
	endif

;Check for B/W,D

	tbitb	2,0(r4)
	if	fs
	 orb	m_int,0(r7)
	endif

;Check for F/L in bit 0

	tbitb	3,0(r4)
	if	fs
	 orb	m_flt,0(r7)
	endif

;Check for F/L in bit 2

	tbitb	4,0(r4)
	if	fs
	 movb	m_flt,r3
	 lshb	2,r3
	 orb	r3,0(r7)
	endif

;Install op field if required

	extsd	0(r4),r2,5,3
	cmpqb	0,r2
	if	ne
	 extsw	r5,r3,0,4	;Op field
	 lshw	r2,r3		;Shift to proper position
	 orw	r3,0(r7)
	endif

;Install short field if required

	extsd	1(r4),r3,0,3
	cmpqd	0,r3
	if	ne
	 tbitb	b_def,(r6)	;See if short field defined
	 if	fs		;Defined if FS
	  extsw 2(r6),r2,0,4	;Short parameter
	  lshw	r3,r2		;Shift to proper position
	  orw	r2,(r7)
	 else			;Field not defined yet
	  cmpqb	1,m_pass
	  if	eq
	   tbitb b_2pass,m_dolst ;Check list status
	  else
	   bispsrb flag_f	;Assume not linking
	   cmpqb 2,m_pass
	   if	eq
	    extsb (r6),tos,b_typ,2
	    cmpqb lbl_ext,tos
	    if	eq
	     bicpsrb flag_f
	    endif
	   endif
	  endif
	  if	fc		;Don't link if 2 pass assembly
	   bsr	lnkfldchk	;Prepare link data for new field
	   movd	2(r6),tos	;Push address of link field data
	   bsr	link_fld
	   save	[r5,r7]
	   movd	2(r6),tos
	   movw	(r6),tos
	   movd	r6,r5		;Buffer address to R5
	   movw	exp b_def+(h'2b lsh b_mode),(r5) ;Defined PC relative
	   movd	r7,2(r5)
	   subd	m_pcofst,2(r5)	;Need PC offset only
	   movd	m_lnkptr,r7
	   movb	exp blnk_cmd+(clnk_ad7 lsh blnkgcmd),(r7)
	   addqd 1,r7
	   bsr	dsp_pi		;Store displacement
	   orb	exp blnk_cmd+exp blnk_or,r3 ;Build link command in R3
	   movb	r3,(r7)
	   addqd 1,r7
	   movd	r7,m_lnkptr
	   movw	tos,(r6)
	   movd	tos,2(r6)
	   restore [r5,r7]
	  endif
	 endif
 	endif
 
	addd	r0,r7		;Advance past entire opcode now
	bsr	do_gens		;Do general addressing modes now
	restore	[r0,r2,r3,r4,r5,r6]
	ret

;Don general addressing modes
;R7 is object code pointer, R1 is source code pointer

do_gens:
	lproc
	reg	[]
	code

;Check for gen 1

	tbitb	11,(r4)
	if	fs
	 movd	-4(r1),r3	;Save LXPD if it was
	 bsr	comma		;Skip comma if there
	 bsr	nxt_txt		;Make sure good text follows
	 if	fc
	  addr	gen1,r5		;Address for gen, displacements
	  bsr	asm_gen
	  cmpb	h'49,m_opcod	;ADDR or LXPD
	  if	eq
	   cmpd	"LXPD",r3
	   if	eq
	    movw exp b_def+l'0004,2+2+8(r5) ;2nd disp. is constant:B
	    movqd 0,2+2+8+2(r5)	;2nd displacement is always 0 for this
	    movb h'16,(r5)	;Always EXT addressing mode
	   else			;This is ADDR
	    cmpb h'16,(r5)	;ADDR EXT(xx) forced to LXPD type
	   orif	eq		;This is treated as LXPD
	    cmpb h'14,(r5)
	    if	eq
	     bsr err_imm
	    endif
	   endif
	  else
	   cmpb h'14,(r5)
	   if	eq
	    extsb m_opcod,r3,4,4 ;Format of opcode
	    cmpqb 2,r3		;Format 2
	    if	eq
	     cmpb h'21,m_opcod	;CMPQi
	     if	ne
	      cmpb h'26,m_opcod	;LPRi
	      if ne
	       bsr err_imm
	      endif
	     endif
	    else
	     cmpqb 3,r3		;Format 3
	     if	eq
	      extsb m_opcod,r3,0,4 ;Opcode within format
	      cmpqb 4,r3	;JUMP
	      if eq
	       bsr err_imm
	      else
	       cmpb h'c,r3	;JSR
	      orif eq
	       cmpb h'e,r3	;CASEi
	      orif eq
	      endif
	     endif
	    endif
	   endif
	  endif
	  cmpb	2,m_pass
	  if	eq
	   extsb -1(r7),r3,3,5	;Mode from pass 1
	   cmpb	(r5),r3
	   if	ne
	    bsr	mod_er:d
	   endif
	  endif
	  movb	(r5),r3		;Gen 1 code
	  lshb	3,r3
	  orb	r3,-1(r7)
	 end
	endif

;Check for gen 2

	tbitb	12,0(r4)
	if	fs
	 bsr	comma		;Skip comma if there
	 bsr	nxt_txt		;Make sure good text follows
	 if	fc
	  addr	gen2,r5		;Address for gen, displacements
	  bsr	asm_gen
	  cmpb	h'14,(r5)	;Gen 2 may not be immediate unless CMPB
	  if	eq
	   cmpw	h'41,m_opcod	;Check for compare opcode
	   if	ne
	    bsr err_imm
	   endif
	  endif
	  cmpb	2,m_pass
	  if	eq
	   extsb -2(r7),r3,6,5	;Mode from pass 1
	   cmpb	(r5),r3
	   if	ne
	    bsr	mod_er:d
	   endif
	  endif
	  movzbw (r5),r3	;Gen 2 code
	  lshw	6,r3
	  orw	r3,-2(r7)
	 end
	endif

;See if gen 1 was indexed

	tbitb	11,(r4)
	if	fs
	 addr	gen1,r5		;Address for gen, displacements
	 cmpb	h'1c,(r5)	;Check for index mode
	 if	ls
	  movb	1(r5),(r7)	;Install index
	  addqd	1,r7
	 end
	endif

;See if gen 2 was indexed

	tbitb	12,(r4)
	if	fs
	 addr	gen2,r5		;Address for gen, displacements
	 cmpb	h'1c,(r5)
	 if	ls
	  movb	1(r5),(r7)	;Install index
	  addqd	1,r7
	 end
	endif

;Do displacements now if required
;Check for gen 1

	tbitb	11,(r4)
	if	fs
	 addr	gen1,r5		;Address for gen, displacements
	 bsr	asm_dsp
	endif

;Check for gen 2

	tbitb	12,(r4)
	if	fs
	 addr	gen2,r5		;Address for gen, displacements
	 bsr	asm_dsp
	endif

	pend


;R5 => value, link with link command on stack

addr_cxp:
	lproc
cmd:	blkb			;Link command ORed with size in R6
	reg	[r4,r5,r6]
	code

	movzbd	m_pass,r4	;Always link if not pass 1
	addqb	-1,r4		;Make 0 if pass 1
	cmpqb	0,r4
	if	eq		;Link if no 2nd pass requested
	 tbitb	b_2pass,m_dolst
	 sfcb	r4		;Link if FC
	endif
	inssb	lbl_ext,(r5),b_typ,2 ;Must be external type now
	extsb	1(r5),r6,b_mode-8,4
	cmpqb	4,r6
	if	eq
	 bsr	set_size	;If integer, use integer size
	else			;If not integer then linker assigns index
	 extsd	1(r5),r6,b_size-8,2 ;Defined size
	 addqb	1,r6
	 cmpqb	3,r6
	 if	eq
	  movb	m_dspsz,r6
	 endif
	endif
	tbitb	b_def,(r5)
	if	fc
	 bsr	byt_put:d	;Store size in R7, save link data
	else			;Defined values must be linked too
	 cmpb	"I"-1,r4
	orif	eq
	 cmpqb	0,r4
	 if	ne
	  save	[r7]
	  movd	2(r5),tos	;Save original value
	  movw	(r5),tos
	  movw	exp b_def+(h'2b lsh b_mode),(r5) ;Defined offset
	  movd	r7,2(r5)
	  subd	m_pcofst,2(r5)	;Just store displacement
	  movd	m_lnkptr,r7
	  movb	exp blnk_cmd+(clnk_ad7 lsh blnkgcmd),(r7)
	  addqd	1,r7
	  bsr	dsp_pi		;Store offset
	  movd	r7,m_lnkptr
	  movw	tos,(r5)
	  movd	tos,2(r5)
	  restore [r7]
	  movb	exp blnk_cmd+(clnkpshv lsh blnkgcmd),(m_lnkptr)
	  movmw (r5),1(m_lnkptr),3
	  addqd 7,m_lnkptr
	 endif
	 cmpqb	2,m_pass
	 if	ne
	  movb	r6,(r7)
	  inssb	b_mode/8(r5),(r7),4,4
	 else
	  extsd	(r7),r6,0,4	;Use stored size always
	 endif
	 addd	r6,r7
	endif
	cmpqb	0,r4
	if	ne
	 addqb	-1,r6		;Link size code is 0-3
	 orb	cmd,r6
	 movb	r6,(m_lnkptr)
	 addqd	1,m_lnkptr
	endif

	pend


;Immediate operand in gen 2

err_imm:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Immediate operand not allowed",cr,lf,0
	ret


;Put displacements as needed into R7
;(R5) => gen, index, displacements

asm_dsp:
	save	[r0,r2,r3,r5,r6]
	movb	0(r5),r0	;Assume not indexed
	cmpb	h'1f,r0
	blo	asm_dsx		;Invalid gen if LO

	cmpb	h'1c,r0		;Check for indexed
	if	ls
	 extsb	1(r5),r0,3,5	;Indexed, get real gen code
	endif

	cmpqb	7,r0		;Nothing to do if register
	bhs	asm_dsx
	cmpb	h'17,r0		;Nothing to do if TOS
	beq	asm_dsx
	addr	2(r5),r5	;Skip over gen mode and index

;Check for immediate

	cmpb	h'14,r0
	if	eq
	 extsb	1(r5),r6,b_size-8+2,2 ;See if float or integer
	 cmpb	h'91,m_opcod
	 if	hs		;Must be integer if HS (also MOVif, LFSR)
	  cmpqb	0,r6
	  if	ne
	   bsr	prm_err		;Error if not integer
	  endif
	 else
	  cmpb	h'bf,m_opcod	;Formats 9 and 11 are floats (10 is unused)
	 orif	lo
	  cmpb	h'96,m_opcod	;SFSR
	 orif	eq
	  cmpqb	1,r6		;Must be float value
	  if	ne
	   bsr	prm_err
	  endif
	 endif
	 movzbd	m_siz,r6	;Number of bytes that follow
	 bsr	byt_put:d
	 tbitb	b_def,(r5)
	 if	fc
	  cmpqb	1,m_pass
	  if	eq
	   tbitb b_2pass,m_dolst ;Check list status
	  else
	   bispsrb flag_f	;Assume not linking
	   cmpqb 2,m_pass
	   if	eq
	    extsb (r5),tos,b_typ,2
	    cmpqb lbl_ext,tos
	    if	eq
	     bicpsrb flag_f
	    endif
	   endif
	  endif
	  if	fc		;Don't link if FS
	   extsb 1(r5),tos,b_size-8+2,2
	   cmpqb 1,tos		;Check for float
	   if	eq
	    lshd -2,r6		;Divide by 4 to get size code 0:F or 1:L
	    addqd -1,r6
	    orb	exp blnk_cmd+exp blnk_val+(clnkfli lsh blnkvcmd),r6
	   else
	    addqd -1,r6		;Size code is 0-3
	    orb	exp blnk_cmd+exp blnk_val+(clnkimm lsh blnkvcmd),r6
	   endif
	   movb	r6,(m_lnkptr)
	   addqd 1,m_lnkptr
	  endif
	 endif
	 br	asm_dsx
	endif

;At least one displacement

	cmpb	h'1b,r0		;Check for memory space "*"
	if	eq
	 movd	2(r5),tos	;Save original value in case of "*" 
	 tbitb	b_def,(r5)
	 if	fs
	  subd	m_pcptr,2(r5)
	 endif
	 bsr	asm_dsub
	 movd	tos,2(r5)
	else
	 cmpb	h'16,r0		;Check for EXT mode
	 if	ne
	  bsr	asm_dsub	;Load displacement in (R5)
	  cmpb	h'f,r0		;Done if register relative
	  if	lo
	   cmpb	h'12,r0		;Check for memory relative
	   if	hs
	    addr 2+8(r5),r5	;2nd displacement required
	    inssb 4,1(r5),b_mode-8,4 ;Force to constant
	    bsr asm_dsub
	   endif
	  endif
	 else
	  movb	exp blnk_cmd+exp blnk_val+(clnkext lsh blnkvcmd),tos
	  bsr	addr_cxp
	  addr	2+8(r5),r5	;2nd displacement required
	  movb	exp blnk_cmd+exp blnk_val+(clnkex2 lsh blnkvcmd),tos
	  bsr	addr_cxp
	 endif
	endif
asm_dsx:
	restore	[r0,r2,r3,r5,r6]
	ret	0

;Subroutine to do actual displacement in (R5)
;If undefined, 2(R5) points to link data
;1(R5) must hold addressing mode (PC relative or not)

asm_dsub:
	save	[r5,r6]
	bsr	set_size	;Get and verify size in R6
	bsr	dsp_put
	restore	[r5,r6]
	ret

;Get size in R6, if defined, verify size
;Use default size if undefined

set_size:
	save	[r4]
	extsd	1(r5),r6,b_size-8,2 ;Designated length
	addqb	1,r6
	tbitb	b_def,(r5)	;FS if defined
	if	fs
	 bsr	dsp_byt		;Get minimum size in R4
	 cmpqb	3,r6		;EQ set if variable size
	 if	eq		;Parameter sets its own size if variable
	  movb	r4,r6
	 else			;Size fixed
	  cmpb	r4,r6		;Size must be possible
	  if	hi
	   bsr	prm_ovfl
	   movb	r4,r6		;Use bigger size
	  endif
	 endif
	else
	 cmpqb	3,r6		;EQ set if variable size
	 if	eq		;Fixed length if not 3
	  movzbd m_dspsz,r6
	 endif
	endif
	restore	[r4]
	ret


;2(R5) holds value, R6 holds size in bytes (1,2,4)
;If undefined then 2(R5) points to link data
;1(R5) must hold PC addressing mode if required
;Put into (R7) according to M_PASS and size, do error check

dsp_put:
	tbitb	b_def,(r5)
	if	fs
	 cmpqb	2,m_pass
	 beq	dsp_p2
	 bsr	dsp_adj		;Adjust R5 for size in R6 if defined
	 bsr	byt_p1:d
	else			;Install link stack command
	 bsr	byt_p1:d
	 cmpqb	1,m_pass
	 if	eq
	  tbitb b_2pass,m_dolst ;Check list status
	 else
	  bispsrb flag_f	;Assume not linking
	  cmpqb 2,m_pass
	  if	eq
	   extsb (r5),tos,b_typ,2
	   cmpqb lbl_ext,tos
	   if	eq
	    bicpsrb flag_f
	   endif
	  endif
	 endif
	 if	fc
	  save	[r0,r6]
	  extsb	1(r5),r0,b_mode-8,4 ;Addressing mode
	  addqd	-1,r6		;Link size code is 0-3
	  orb	exp blnk_cmd+exp blnk_val+(clnkpcr lsh blnkvcmd),r6
	  cmpb	h'b,r0		;Check for PC relative
	  if	eq
	   save	[r7]
	   movd	2(r5),tos	;Save original value
	   movd	m_lnkptr,r7	;Target address
	   movb	exp blnk_cmd+(clnk_adr lsh blnkgcmd),(r7)
	   addqd 1,r7
	   movd	m_pcptr,2(r5)	;Base value for offset
	   bsr	dsp_pi		;Store as displacement
	   movd	r7,m_lnkptr
	   movd	tos,2(r5)
	   restore [r7]
	  else
	   inssb clnkdsp,r6,blnkvcmd,4 ;Displacement
	  endif
	  movb	r6,(m_lnkptr)
	  addqd	1,m_lnkptr
	  restore [r0,r6]
	  ret
	 endif
	endif
	ret

;Immediate pass mode, just insert disp.

dsp_pi:	save	[r4,r6]
	bsr	dsp_siz		;Get required size for R5 in R4
	movd	r4,r6		;Parameter dictates it's own size
	bsr	byt_ok:d
	restore	[r4,r6]
	ret	0


;2(R5) holds disp.
;Return size of disp. in R4 (1,2,4), adjusted value in 2(R5)

dsp_siz:
	save	[r6]
	bsr	dsp_byt		;Get byte count (1,2,4) in R4
	movd	r4,r6
	bsr	dsp_adj		;Adjust R5 for size in R6
	restore	[r6]
	ret	0


;Do general addressing mode, return gen code in 0(R5), index in 1(R5)
;displacement 1 in 4(R5), displacement 2 in 14(R5)

asm_gen:
	bsr	asm_gnsb

;If 0(R5) < H'20 then OK, else display error message

	cmpb	h'1f,(r5)
	bhs	return

;Invalid gen code, display message

	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Bad addressing mode",cr,lf,0
	ret

asm_gnsb:
	save	[r0,r2,r3]

	movd	r1,tos		;Save beginning of expression
	bsr	gm		;R2 and R3 altered
	movd	tos,r2		;Start of expression

;If nothing found and "(" then try regular expression

	cmpqb	-1,(r5)		;See if undefined
	if	eq
	 cmpb	"(",(r2)
	 bne	asm_gnx		;Hopeless if NE
	 movd	r2,r1		;Re-evaluate entire expression
	 bsr	gen_exf		;Must be integer or float
	 if	fc		;OK if FC
	  movb	h'14,(r5)
	 endif
	 br	asm_gnx
	endif

;Mode of displacements must match addressing mode

	cmpb	0fh,(r5)	;Check for register or register relative
	if	hs		;Displacements must be constant if register
	 inssb	4,3(r5),b_mode-8,4
	else			;Use addressing mode for displacements
	 inssb	4,13(r5),b_mode-8,4 ;2nd displacement always constant
	 cmpb	b'10110,(r5)	;If EXT then leave displacement as is
	 if	ne
	  inssb	(r5),3(r5),b_mode-8,4 ;1st disp. must match addressing mode
	 endif
	endif

	bsr	next
	bfs	asm_gnx

;Check for indexed mode

	cmpb	"[",0(r1)
	bne	asm_gnx

;This is indexed mode

	movb	0(r5),1(r5)
	movqb	-1,0(r5)

;Error if immediate mode

	cmpb	h'14,1(r5)
	beq	asm_gnx		;Indexed immediate mode invalid

	cmpb	"R",1(r1)
	bne	asm_gnx
	cmpb	":",3(r1)
	bne	asm_gnx
	cmpb	"]",5(r1)
	bne	asm_gnx

	lshb	3,1(r5)		;Move gen to bits 3-7
	movb	2(r1),r2	;Register
	subb	"0",r2
	cmpb	7,r2
	blo	asm_gnx
	orb	r2,1(r5)

	movb	h'1c,r2
	cmpb	"B",4(r1)
	beq	gz

	addqd	1,r2
	cmpb	"W",4(r1)
	beq	gz

	addqd	1,r2
	cmpb	"D",4(r1)
	beq	gz

	addqd	1,r2
	cmpb	"Q",4(r1)
	bne	asm_gnx
gz:	movb	r2,0(r5)
	addqd	6,r1

asm_gnx:
	restore	[r0,r2,r3]
	ret


;Do addressing mode and displacements
;R2 and R3 are altered

gm:	bsr	length
	movqb	-1,0(r5)	;In case of error

	movw	exp b_def+l'0004,12(r5)	;Defined constant:B
	movqd	0,14(r5)	;2nd disp. defaults to 0

;Check for register

	cmpb	"F",0(r1)
	if	eq
	 cmpqd	2,r0		;Length must be 2
	 bne	gf		;Must be expression if not 2

	 movb	1(r1),r2
	 subb	"0",r2
	 cmpb	7,r2

;Symbol if not R0-R7

	 blo	gf
	 movb	r2,0(r5)	;Gen is register number
	 addqd	2,r1
	 ret
	else
	 cmpb	"R",0(r1)
	orif	eq
	 cmpb	"L",(r1)	;May be L0-L7 for 32381
	orif	eq
	endif

;Check for absolute mode

	cmpb	"@",0(r1)
	if	eq
	 movb	h'15,0(r5)
	 addqd	1,r1
	 br	gen_ex
	endif

	tbitb	b_nscgnx,m_ascond
	if	fs
	 movb	h'14,(r5)	;Immediate
	 cmpb	"$",(r1)
	 if	eq
	  addqd	1,r1
	  br	gen_ex
	 else
	  movb	h'1b,(r5)	;PC relative
	  cmpb	"%",(r1)
	 orif	eq
	  movb	h'1a,(r5)	;SB relative
	  cmpb	"^",(r1)
	 orif	eq
	  movqb	-1,(r5)		;Nothing again
	 endif
	endif

;Check for EXT mode

	cmpqb	3,r0
	bne	gf
	movd	0(r1),r2
	andd	h'ffffff,r2
	cmpd	"EXT",r2
	bne	ge

	addqd	3,r1		;Advance to disp. 1
	bsr	nxt_txt
	bfs	return		;Error if no more
	cmpb	"(",(r1)
	bne	return
	addqd	1,r1

	bsr	gen_ex		;Do 1st displacement
	bfs	return
	bsr	nxt_txt
	bfs	return		;Error if no more
	cmpb	")",(r1)
	bne	return
	addqd	1,r1		;Skip closing parenthesis
	extsb	3(r5),r2,b_mode-8,4
	cmpqb	4,r2		;Use external type if not immediate
	if	eq
	 inssb	lbl_ext,2(r5),b_typ,2
	else
	 cmpqb	5,r2		;Absolute
	orif	eq
	 cmpqb	6,r2		;EXT
	orif	eq
	 cmpb	b'1010,r2	;SB
	orif	eq
	 cmpb	b'1011,r2	;PC
	orif	eq
	 br	type_err
	endif

	bsr	next
	if	fs		;End of line if FS
	 movb	h'16,0(r5)
	 ret
	else
	 cmpb	",",(r1)
	orif	eq
	endif

	save	[r5]		;2nd displacement
	addr	10(r5),r5
	bsr	gen_ex
	restore	[r5]
	if	fs
	 movqb	-1,(r5)
	else
	 movb	h'16,(r5)
	 inssb	lbl_ext,12(r5),b_typ,2
	endif
	ret

;Check for TOS

ge:	cmpd	"TOS",r2
	if	eq
	 movb	h'17,0(r5)
	 addqd	3,r1
	 ret
	endif

;Must be an expression
;Check for null displacement first

gf:	tbitb	b_nscgnx,m_ascond
	if	fc		;No default to 0 if NSCGNX
	 cmpb	"(",0(r1)
	 if	eq
	  movw	exp b_def+h'2400,2(r5)	;Defined constant
	  movqd	0,4(r5)		;Load default displacement of 0
	  br	gen_mem
	 endif
	endif

	bsr	gen_exf		;Get symbol, may be float
	bfs	return		;Error if FS
	extsb	3(r5),0(r5),0,4	;Gen mode from symbol table
	sbitb	4,0(r5)	

;Use returned mode if no "("

	bsr	next
	cmpb	"(",0(r1)
	if	ne
	 tbitb	b_nscgnx,m_ascond
	 bfc	return		;Use default mode
	 cmpb	h'14,(r5)	;Check for immediate
	 if	eq
	  cmpb	h'34,3(r5)	;Check for integer type
	  if	hs
	   movb	h'15,(r5)	;These default to absolute
	   inssb 5,3(r5),b_mode-8,4
	  endif
	 endif
	 ret
	endif
gen_mem:
	movb	h'18,r2		;Bits 2-7 of gen code
	bsr	chk_fp
	cmpqb	-1,0(r5)	;Success if not this
	bne	return

	addqd	1,r1		;Skip over last parenthesis
	bsr	nxt_txt
	bfs	return
	cmpb	"R",0(r1)
	bne	gj

	cmpb	")",2(r1)
	bne	gj

	movb	1(r1),r2
	subb	"0",r2
	cmpb	7,r2
	blo	gj

;This is register relative

	addb	8,r2
	movb	r2,0(r5)
	addqd	3,r1
	ret	0

;Only thing left is memory relative

gj:	movmw	2(r5),12(r5),5	;1st disp was really 2nd

	tbitb	b_nscgnx,m_ascond
	if	fc		;No default to 0 if NSCGNX
	 cmpb	"(",0(r1)	;Check for null parameter
	 if	eq
	  movw	exp b_def+h'2400,2(r5)	;Defined constant
	  movqd	0,4(r5)		;Load default displacement of 0
	  br	gen_mrl
	 endif
	endif

	bsr	gen_ex		;New 1st displacment
	bfs	return

;Try memory relative symbolic

	extsb	3(r5),0(r5),0,3	;Implied FP/SP/SB from mode of symbol
	bsr	nxt_txt
	bfs	gm_err
	cmpb	")",0(r1)
	bne	gen_mrl
	addqd	1,r1		;Skip over last ")"

;Range check on return value, must be 0-2

	cmpqb	3,0(r5)
	sbitb	4,0(r5)		;Bit 4 must be set too
	bhi	return		;SP/SB/FP mode if HI

gm_err:	movqb	-1,0(r5)
	ret	0

gen_mrl:
	cmpb	")",4(r1)	;Memory relative must end with this
	bne	gm_err		;Error if not
	movb	h'10,r2		;Bits 2-7 of gen code
	bsr	chk_fp
	addqd	1,r1		;Skip over last parenthesis
	ret


;Check for (FP), (SP), (SB). R2 holds bits 2-7 of gen code
;Returns -1 in 0(R5) if none of the above
;Advances R1 by 4 if a match found

chk_fp:	save	[r0,r4]
	movd	0(r1),r4
	cmpd	"(EXT",r4
	if	eq
	 movqb	-1,r0		;Assume no match
	 cmpb	")",4(r1)
	 if	eq
	  addqd	1,r1		;Advance past extra character
	  movb	h'16,r0		;External
	 endif	
	else
	 save	[r1]
	 movqb	3,r0
	 addr	t_fpsp,r1
	 skpsd	u
	 addqd	-1,r0		;Code is offset-1
	 restore [r1]
	 orb	r2,r0
	endif
	movb	r0,0(r5)
	restore	[r0,r4]
	cmpqb	-1,0(r5)
	beq	return		;No match if EQ

;A match was found, advance R1

	addqd	4,r1
	ret	0


t_fpsp:	.byte	$"(SB)"
	.byte	$"(SP)"
	.byte	$"(FP)"


;Resolve symbol, use storage in 2(R5)

gen_ex:	bsr	nxt_txt
	bfc	gen_ex1
	movqb	-1,(r5)		;Make undefined
	ret	0
gen_ex1:
	bsr	gen_exf

;Check for integer but don't display error message if not

	extsb	3(r5),tos,b_size-8,4 ;Must be integer here
	cmpqb	3,tos
	bicpsrb flag_f		;In case OK
	if	lo
;	 MOVW	H'FF00,2(R5)	;Completely undefined
	 movqb	-1,(r5)
	 bispsrb flag_f
	endif
	ret

;Evaluate symbol, may be float, constant or any addressing mode

gen_exf:
	addqd	2,r5
	bsr	ex
	addqd	-2,r5

;Check for integer or float but don't display error message if not
;FS if not valid addressing mode

	save	[r2]
	extsb	3(r5),r2,b_size-8,4
	cmpqb	6,r2
	bicpsrb flag_f		;In case OK
	if	lo
	 cmpb	b'1100,r2	;May also be boolean
	 if	eq
	  movb	h'24,2+b_mode/8(r5) ;Make this constant
	 else
	  cmpb	b'1101,r2	;BCD is OK too
	 orif	eq
;	  MOVW	H'FF00,2(R5)	;Completely undefined
	  movqb	-1,(r5)
	  bispsrb flag_f
	 endif
	endif
	restore	[r2]
	ret

;Get integer data type via EX
;Type set to undefined if not integer

ex_int:	cond	nscgnx
	 tbitb	b_nscgnx,m_ascond
	 if	fs
	  cmpb	"$",(r1)
	  if	eq
	   addqd 1,r1		;Ignore this
	  endif
	 endif
	cend

	bsr	ex
	save	[r0]
	extsd	1(r5),r0,b_size-8,4 ;Must be integer here
	cmpqb	4,t_type[r0:b]
	if	eq
	 inssb	4,1(r5),b_mode-8,4 ;Make constant
	else
	 movw	h'ff00,(r5)	;Completely undefined
	 bsr	err_int		;Integer data type required
	endif
	restore	[r0]
	ret

err_int:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Integer data type required",cr,lf,0
	ret


;Return length of any string.
;Terms beginnig with a word delimiter (math operators, etc) are
;given a length of the sequential word delimiter count

wrd_len:
	bsr	length
	cmpqd	0,r0
	bne	return
	save	[r1,r3,r4]
	movqd	7,r0
	movd	m_delim,r3
	movb	trm_wrd,r4
	skpst	w
	negd	r0,r0
	addqd	7,r0
	restore	[r1,r3,r4]
	ret


;Find length of string until termination character in R4
;R5 holds character beginning new inner string to be skipped
;R3 holds translation table address, R1=>string, R0=current length
;FS if end of line encountered first

nxt_mtch:
	save	[r6]

	until	eq
	 movzbd (r1),r6
	 cmpqb	trm_lin,r3[r6:b]
	 bispsrb flag_f
	 quit	hs
	 cmpb	r5,r6		;Check for inner loop
	 if	eq
	  addqd 1,r1		;This is part of inner string if present
	  addqd 1,r0
	  bsr	nxt_mtch
	  if	fc
	   addqd 1,r1		;This is also part of inner string
	   addqd 1,r0
	  endif
	  bicpsrb flag_z	;Make not equal now
	 else
	  cmpb	r4,r6
	  if	ne
	   addqd 1,r1
	   addqd 1,r0
	  endif
	 endif
	 bicpsrb flag_f		;This must be clear
	endu

	restore	[r6]
	ret


;Return length of comma or space separated string in 0(R1) in R0
;R1 points to 1st valid character
;R2 holds length of entire string and includes final ">"
;If 1st character is "<" then process entire string until matching ">"
;[] equivalent to <>
;Quotes not included in quoted strings
;&& may also delimit text
;Also does mid-string function $(position,count)string
;$" doesn't include quotes in string
;FS if error encountered

str_len:
	save	[r3,r4,r5,r6]
	movqd	0,r0		;Start with 0 length
	movqd	0,r2		;Default length for entire string
	movd	m_delim,r3	;Delimiter table

	movzbd	(r1),r4
	cmpb	"$",r4
	if	ne
	 cmpb	'"',r4
	 if	eq		;Special routine for quotes
	  addqd 1,r1		;Point to 1st valid character
	  movqd 0,r0		;Length of quoted string
	  movqd 0,r2		;Include closing quote if any here
	  begin			;Get length of quoted string in R0
	   movzbd r1[r0:b],r5	;Current character
	   cmpb trm_cr,r3[r5:b] ;Check for end of line
	   bispsrb flag_f	;Error if end of line
	  quit	hs
	   cmpb	"\",r5
	   if	eq
	    tbitb b_nscgnx,m_ascond
	    if	fs		;\ is ESC character if FS
	     cmpb "&",r4	;Only within quotes
	     if	ne
	      addqd 1,r2
	      addqd 1,r0
	     endif
	    endif
	   endif
	   addqd 1,r2
	   bicpsrb flag_f	;OK
	   cmpb r5,r4		;Check for closing character
	  while ne
	   addqd 1,r0		;Don't include closing character in R0
	  endw
	 else
	  cmpb	"'",r4
	 orif	eq
	  cmpb	"&",r4
	 orif	eq
	  cmpb	"<",r4
	  if	eq
	   addqd 1,r1		;Advance past starting character
	   save	[r1]
	   movb	r4,r5		;Character starting inner string
	   addqb 2,r4		;Closing character
	   bsr	nxt_mtch
	   movd	r0,r2		;String length
	   restore [r1]
	   if	fc
	    addqd 1,r2		;Advance past ">"
	   endif
	  else
	   cmpb	"[",r4
	  orif	eq
	   save	[r1]
	   begin
	    movzbd (r1),r4
	    cmpb trm_lin,(m_delim)[r4:b]
	   quit	hs
	    cmpb trm_blnk,(m_delim)[r4:b]
	   quit	eq
	    cmpb ",",r4
	   while ne
	    addqd 1,r0
	    addqd 1,r1
	    addqd 1,r2
	   endw
	   restore [r1]
	   bicpsrb flag_f	;F clear
	  endif
	 endif
	else
	 addqd	1,r1		;Skip over leading "$"
	 movzbd (r1),r4
	 cmpb	"(",r4		;Check for mid-string function
	orif	ne
	 bsr	mid_str
	endif

	if	fs
	 bsr	str_err
	endif
	restore	[r3,r4,r5,r6]
	ret


;End of line error in line

str_err:
	addqd	1,m_errct
	bsr	dsp_msg
	byte	"Error in string",cr,lf,0
	bispsrb	flag_f		;Must be set on error
	ret


;Return R1 pointing to beginning of mid-string, R0 holds length
;R2 holds length to skip (includes trailing quote or ">")
;On entry R1 points to 1st "("

mid_str:
	addqd	1,r1		;Skip over "("
	bsr	next
	bsr	get_of1		;Get position expression in R5
	bfs	return
	movd	r5,r6		;Save position pointer
	cmpqd	0,r6
	if	ge
	 movqd	1,r6		;Position always greater than 0
	endif
	bsr	nxt_coma
	bsr	get_of1		;Get count expression in R5
	bfs	return
	cmpqd	0,r5
	if	ge
	 movqd	1,r5		;Position always greater than 0
	endif
	bsr	next
	cmpb	")",(r1)
	bispsrb	flag_f
	bne	return
	addqd	1,r1		;Advance to string text
	bsr	next

;R5 holds count, R6 holds position, R1 points to string

	save	[r5,r6]
	bsr	str_len		;Get length of entire string
	restore	[r5,r6]
	cmpd	r6,r0		;Position cannot exceed length
	if	hi
	 movd	r0,r6		;Position is lower of R6 or R0
	endif
	subd	r6,r0		;Max possible substring length in R0
	addqd	1,r0		;Count is inclusive
	cmpd	r0,r5
	if	hi
	 movd	r5,r0		;Count is lower of R0 or R5
	endif

;R1=> base of string, R0 holds count, R6 holds position

	addqd	-1,r6		;1st position is 1
	addd	r6,r1
	subd	r6,r2
	ret


;Return length of string in 0(R1) in R0

length:	movqd	0,r0
	save	[r1,r3,r4]
	movd	m_delim,r3	;Delimiter table
	begin
	 movzbd (r1),r4
	 cmpb	trm_blnk,r3[r4:b]
	while	lo
	 addqd	1,r1
	 addqd	1,r0
	endw
	restore	[r1,r3,r4]
	ret

;Return length of expression in 0(R1) in R0
;Like LENGTH but also keeps word delimiters other than TRM_BLNK

exp_len:
	movqd	0,r0
	save	[r1,r3,r4]
	movd	m_delim,r3	;Delimiter table
	begin
	 movzbd (r1),r4
	 cmpqb	trm_wrd,r3[r4:b]
	 if	ne
	  cmpqb	trm_blnk+1,r3[r4:b]
	 endif
	while	ls
	 addqd	1,r1
	 addqd	1,r0
	endw
	restore	[r1,r3,r4]
	ret


;Advance to next text, display error message if none
;FC if OK, FS if error

nxt_txt:
	bsr	next
	bfc	return
	br	bad_txt


;Advance to next text after comma, display error message if none
;FC if OK, FS if error

nxt_coma:
	bsr	comma
	beq	return

	addqd	1,m_errct
	bsr	dsp_msg
	.byte	"Comma expected",cr,lf,0
	bispsrb	flag_f
	ret	0


;Skip colons after label if present

skp_coln:
	begin
	 cmpb	":",(r1)
	while	eq
	 addqd	1,r1
	endw
	ret


;Find next character not blank or tab, F clear if found
;FS if end of line or ";"
;Return pointer in R1

next:	save	[r0,r3,r4,r5]
	movqd	-1,r0		;Infinite search length
	movd	m_delim,r3
	movqb	trm_blnk,r4	;Inter-word blanks

	until	ne
	skpst	w
	movzbd	(r1),r5
	cmpqb	trm_nul,r3[r5:b] ;Skip nulls too
	if	eq
	  addqd	1,r1		;Advance past null character
	endif
	endu

;Set F if end of text

	bicpsrb	flag_f		;Assume OK
	cmpqb	trm_lin,r3[r5:b]
	restore	[r0,r3,r4,r5]
	blo	return
	bispsrb	flag_f
	ret

;Skip over remaining parameters
;Line must be properly terminated

skp_prm:
	save	[r3,r4]
	movd	m_delim,r3
	begin
	 movzbd	(r1),r4
	 cmpqb	trm_lin,r3[r4:b]
	while	lo
	 addqd	1,r1
	endw
	restore	[r3,r4]
	ret


;Advance to next line, CR must be there
;LF skipped if there

lin_end:
	save	[r0,r4]
	movd	buf_siz,r0	;Max search length
	movb	cr,r4
	skpsb	u		;Find line delimiter
	addqd	1,r1		;Skip over CR
	cmpb	lf,(r1)
	if	eq
	 addqd	1,r1
	endif
	restore	[r0,r4]
	ret


;Advance R1 to next line, FS if end of file encountered
;Only BUF_SIZ characters searched
;Error if CR not found

nxt_lin:
	save	[r0,r3,r4]
	movd	buf_siz-1,r0	;Max search length includes CR
	movd	m_delim,r3
	until	eq
	 movzbd	(r1),r4
	 cmpb	trm_fil,r3[r4:b]
	quit	eq
	 addqd	1,r1		;Advance pointer
	 addqd	-1,r0		;Clears F
	quit	cc		;Text exhausted if no carry
	 cmpb	cr,r4
	qend
	 cmpqd	-1,r0		;This if no CR found
	 if	eq
	  addqd	1,m_errct
	  bsr	dsp_msg
	  db	"Line too long",cr,lf,0
	 endif
	 bispsrb flag_f
	endu
	restore	[r0,r3,r4]
	bfs	return		;End of file if FS
	cmpb	lf,(r1)		;Check for LF
	if	eq
	 addqd	1,r1
	 bicpsrb flag_f		;F must be clear
	endif
	ret

;End of ASM32
