	Title	PRL-XFER Parallel File Transfers
	Page	80,132
	Comment	|

LP Command
________________

Remarks:
LP14.ASM Written by Vernon Buerg for the IBM PC using DOS 2.0 or 
later. For public domain use. Not for sale or hire.   Prints an ASCII 
file on the standard printer device at either 66 or 88 lines per page. 
A title is printed at the top of each page which contains the file 
name, creation date, and page number.


Aug. 30, 1989 modified by Don Rowe to function as a fast "misbehaved" 
parallel printer port driver for Kotekan 32000 CPU assembler/linker.  
Renamed to PRL-XFER.  LPT 1 is used unless you change the P_PORT 
equate.

Dec. 13, 1990 forces INIT high.  Exits if no file name.

PRL-XFER will write a file directly to the hardware and will 
optionally provide the hardware termination handshaking needed by the 
linker and other commands requiring 8 bit transfers.
PRL-XFER options:
   /A sends a standard ASCII file with no hardware termination.  This 
	is the default selection.
   /T sends an ASCII file but suppresses EOT or ^Z termination bytes.
   /L sends an 8 bit data file with hardware termination 	
	handshaking.  (INIT is set low by the computer, SELECT is set low by 	
	he 32000, INIT returns high, SELECT returns high.)

Pressing any key aborts.  Only status is checked: the keypress is not 
read which allows aborting the calling program with the same keypress.

________________							|

P_PORT	EQU	378H			;Base address of printer port

EOT	EQU	4			;^D is End of Transmission
BEL	EQU	7
LF	EQU	10
CR	EQU	13
CTRL_Z	EQU	26			;^Z is also possible terminator


Cseg	Segment	Public Para 'CODE'
	Assume	CS:Cseg,DS:Cseg
	Org	100h

LP	Proc	Far
	Mov	SP,Offset CS:Lstack	;Use local stack

	Push	DS			;For DOS return
	Sub	AX,AX
	Push	AX
	Mov	Stk_Top,SP

	Mov	dx,P_PORT+2		;Output status port
	In	al,dx
	Or	al,04			;INIT high
	Out	dx,al

	Mov	SI,80h			;Point to command line
	Sub	CX,CX			;Clear length reg
	Or	CL,Byte	Ptr [SI]	;Get command tail length
	Jnz	continue		;OK if name there
	jmp	Exit

continue:
	Call	Ver			; Check DOS version

	Call	Alloc			; Allocate memory

	Call	GetFile			; Get file name

	Call	Opens			; Open input

	Call	List			; Print the file

	Mov	al,L_stat		;Hardware termination if not 0
	Or	al,al			;Check for 0
	Jz	Eod			;Nothing more needed if 0

	Mov	ah,1			;Status check
	Int	16h
	Jnz	Eod			;Aborted by keypress if nz

;Hardware handshake termination required

	Mov	dx,P_PORT+2		;Output status port
	In	al,dx
	And	al,0fbh			;Set INIT low
	Out	dx,al
	Dec	dx			;Input port
In_wait:
	In	al,dx
	And	al,10h			;Check SELECT line
	Jnz	In_wait			;Wait for it to go low
	Inc	dx
	In	al,dx
	Or	al,04			;Set INIT high again
	Out	dx,al
Eod:
	Mov	DX,Offset EofMsg	;Say END-OF-FILE
	Jmp	Fini

Error:	Mov	CS:Errlvl,1
Fini:	Mov	AX,CS			;Insure seg regs
	Mov	DS,AX
	Mov	SP,Stk_Top		; and stackck

	Mov	AH,9			;Print error message
	Int	21h

	Mov	BX,IHandle		;Close input
	Mov	AH,3Eh
	Int	21h

Exit:
	Mov	AL,Errlvl		; Set ERROR LEVEL
	Mov	AH,4Ch			; and Exit
	Int	21h
	Page
;
Buflen	Dw	0			;I/O buffer size (variable)
Stk_Top	Dw	0			;Stack ptr at entry

Lcnt	Db	0			;Line counter
Cpp	Db	96			;Chars per page
LPP	Db	82			;Lines per page
L_stat	Db	0			;/L option selected if not 0
T_stat	Db	0			;/T option selected if not 0
Errlvl	Db	0			;Error level returned
Ccnt	Db	0			;Chars in current line

MsgIn	Db	CR,LF,'Enter INPUT filename  $'
Msg1	Db	CR,LF,'Unable to open input'
InKey	Db	32,32			;Keyboard buffer
Input	Db	76 Dup (0),'$'		;Drive:path\name.ext
IHandle	Dw	0			;Input file handle
Ilen	Dw	0			;Input block length
Iptr	Dw	0			;Offset	to next	char
InPtr	Dw	0			;Offset to input buffer


AlocMsg	Db	CR,LF,'Not enough memory',CR,LF,BEL,'$'
ErrMsg	Db	CR,LF,'Invalid command option(s)',CR,LF,BEL,'$'
Version	Db	'PRL-XFER V1.1 - V.Buerg and Don Rowe',CR,LF,'$'
Sorry	Db	'Sorry, PC DOS 2.0 or later required',CR,LF,BEL,'$'


EofMsg	Db	' ','$'
	Db	'End of File',CR,LF,'$'


;	Copy file to printer

List	Proc	Near

List1:	Call	Read			;Get one character
	MOV	BL,AL			;Save character
	jc	Done			;End of file if CS
	MOV	AL,T_stat		;See if termination suppressed
	OR	AL,AL
	JZ	List2			;Not suppressed if 0
	MOV	AL,BL
	CMP	AL,EOT			;Check for EOT
	JZ	Done
	CMP	AL,CTRL_Z
	JZ	Done			

List2:
	Mov	dx,P_PORT+1		;Status input port
List3:
	In	al,dx
	And	al,80h			;Check busy (inverted at input)
	Jnz	List4			;Ready for next character if NZ

;Check for a keypress, abort if so

	Push	bx
	Push	dx
	Mov	ah,1			;Status check
	Int	16h
	Pop	dx
	Pop	bx
	Jz	List3			;Check busy again if no key
	Jmp	Done			;Keypress is there, abort

List4:
	Dec	dx			;Backup to data port
	Mov	al,bl			;Get character back
	Out	dx,al			;Write the data

	Inc	dx
	Inc	dx			;Status output port
	In	al,dx
	Or	al,1			;Inverted output set high
	Out	dx,al
	And	al,0feh			;Strobe low again
	Out	dx,al

	Jmp	List1			;Do all characters

Done:	Ret
List	Endp
	Page
;
;	Extract one char from record
;Carry set on exit if end of file, carry clear if AL holds character

Read	Proc	Near			;Read char into	AL
Read1:	Cmp	Ilen,0			;Any in	buffer?
	Je	Read2			; no, read next	block
	Mov	SI,Iptr			; yes, get offset in buf
	Lodsb
	Inc	Iptr			;Offset	for next one
	Dec	Ilen			;Decr buffer size left
	CLC				;Got a character
	Ret				; and return

Read2:	Mov	BX,IHandle		;Read input
	Mov	CX,BufLen
	Mov	DX,InPtr		;Set up	DS:DX
	Mov	AH,3Fh
	Int	21h			;Read a	block
	Mov	DX,InPtr
	Mov	Iptr,DX			;Reset buffer ptr
	Mov	Ilen,AX			; and length
	Jc	Read8
	Or	AX,AX			;Anything read?
	Jnz	Read1			; yes, pick it up
	STC				;End of file
	Ret

Read8:	Mov	DX,Offset Msg3		;Say I/O ERROR
	Jmp	Error

Msg3	Db	CR,LF,'I/O error',CR,LF,BEL,'$'
Read	Endp

;
;	Get file names from parm

GetFile	Proc	Near			;Get file name(s)
	Mov	SI,80h			;Point to command line
	Sub	CX,CX			;Clear length reg
	Or	CL,Byte	Ptr [SI]	;Get command tail length
	Jz	GetF8			; none, ask for them
	Mov	DI,Offset Input		;Point fname target
	Inc	SI			;Bump command ptr

GetF1:	Lodsb				;Get next char
	Cmp	AL,' '			;Skip leading blanks
	Jne	GetF2
	Loope	GetF1
	Jcxz	GetF8			; all blank

GetF2:	Cmp	AL,CR			;End of parm?
	Je	GetF7			; yes, terminate fname
	Cmp	AL,' '			;Delimiter?
	Je	GetF4			; yes, look for swithes
	Cmp	AL,'/'			;Switch char?
	Je	GetF5
	Stosb				;Save fname char
	Lodsb
	Loop	GetF2
	Jmp	GetF7

GetF4:	Dec	CX
	Jz	GetF8
GetF4a:	Lodsb
	Cmp	AL,' '			;Skip intervening blanks
	Jne	GetF4b
	Loope	GetF4a
	Jcxz	GetF7			; just trailing blanks
GetF4b:	Cmp	AL,CR			;End of parm?
	Je	GetF7			; yes, no switches
	Jmp	Short GetF5b

GetF5:	Dec	CX
	Jz	GetF7
GetF5a:	Lodsb
GetF5b:	Cmp	AL,'/'			;Switch char?
	Jne	GetFx			; no, invalid
	Dec	SI			; yes, back up to it
	Call	GetParm			; and set switches

GetF7:
GetF8:	Cmp	Input,0			;Any input name?
	Jne	GetF9			; no, ask for it
	Call	AskIn
GetF9:	Ret

GetFx:	Mov	DX,Offset ErrMsg
	Jmp	Error
	Page
;
;	Determine switch parameters

GetParm	Proc	Near
	Push	DI
	Push	SI			;Offset to parm string
	Push	CX			;Length of string

	Mov	DI,SI			;Save string ptr
	Add	DI,CX      		; ending offset
GetP0:	Cmp	SI,DI			;Any left?
	Jb	GetP1
	Jmp	GetP9			; no, done

GetP1:	Lodsb
	Cmp	AL,'/'			;Switch char?
	Je	GetP2
	Jmp	Short GetP0

GetP2:	Cmp	SI,DI			;Any string left?
	Jae	GetPx			; no, invalid option
GetP2a:	Lodsb
	Cmp	AL,'A'			;ASCII?
	Je	GetP9			;Default already set
	Cmp	AL,'a'
	Je	GetP9
	Cmp	AL,'L'			;Link?
	Je	GetPl
	Cmp	AL,'l'
	Je	GetPl
	Cmp	AL,'T'			;Termination suppressed?
	Je	GetPt
	Cmp	AL,'t'
	Je	GetPt

GetPx:	Mov	DX,Offset ErrMsg	; no, say INVALID OPTIONS
	Jmp	Error

GetPl:
	Mov	L_stat,AL		;Make Not 0
	Jmp	GetP9			;All done

GetPt:
	Mov	T_stat,AL		;Make Not 0
	Jmp	GetP9			;All done

GetP9:	Pop	CX
	Pop	SI
	Pop	DI
	Ret
GetParm	Endp

	Page
;
;	Ask for input file name

AskIn	Proc	Near
Ask:	Mov	DX,Offset MsgIn		;Prompt	msg for	input
	Mov	AH,9			;Print string
	Int	21h

	Mov	InKey,64
	Mov	DX,Offset InKey		;Ptr to	keyboard buffer
	Mov	AH,10			;Buffered keyboard input
	Int	21h
	Sub	BX,BX			;Clear for insert
	Add	BL,InKey+1		;Get length read
	Jz	Ask			;If nothing read
	Mov	Byte Ptr Input[BX],0	;Set ASCIIZ stopper
	Mov	Word Ptr InKey,' :'	;Clear error message part
	Ret
AskIn	Endp

GetFile	Endp
	Page
;
;	Open files

Opens	Proc	Near
	Mov	DX,Offset Input
	Mov	AX,3D00h		;Open for input
	Int	21h
	Jnc	Openi
	Mov	DX,Offset Msg1
	Jmp	Error

Openi:	Mov	IHandle,AX		; Return input handle
	Ret
Opens	Endp


;
;	Check DOS version

Ver	Proc	Near
	Mov	AH,30h			;Get DOS version
	Int	21h
	Cmp	AL,2			;Rel 2 or later?
	Jae	Ver1			; if not
	Mov	DX,Offset Sorry
 	Jmp	Error

Ver1:
;	Mov	DX,Offset Version
;	Mov	AH,9			;Display title
;	Int	21h
	Ret

Ver	Endp
	Page
;
;	Allocate up to 32K for read buffer

Alloc	Proc	Near			;Allocate storage
	Mov	AH,4Ah			;Modify allocated memory
	Mov	BX,PgmSize		;Length of Code and Stack
	Int	21h

	Mov	BX,MaxSize		;Try for 32K each
Alloc1:	Mov	AH,48h
	Int	21h
	Jc	Alloc1			;Failed, get what there is

	Sub	BX,MinSize		;Safety pad
	Cmp	BX,MinSize		;Have enough?
	Jb	Alloc9

	Mov	DX,CS			;Get offset into DS
	Sub	AX,DX			; for input buffer
	Mov	CL,4
	Shl	AX,CL
	Mov	InPtr,AX 		; Read buffer start
	Mov	Iptr,AX			;  and current char offset

	Shr	BX,1			; Split into two buffers
	Mov	CL,4			; Convert paras
	Shl	BX,CL			;  to bytes available
	Mov	Buflen,BX

	Ret

Alloc9:	Mov	DX,Offset AlocMsg
	Jmp	Error
Alloc	Endp

LP	Endp

Lstack	Equ	$+128			;End of local stack

PgmSize	Equ	($-Cseg+16+128)/16	;Size of program in paragraphs
MaxSize	Equ	4096-PgmSize		;Paras left in segment
MinSize	Equ	32			;Minimum buffer needed

Cseg	Ends

	End	LP
