; MACROS for 432, etc. 09/14/85

;MACLIB.ASM  is  a  batch of macros to fix some omissions in my  2500AD  cross
;assembler.  I had to repair and complete a lot of things in that assembler to
;make  it operational,  and since 2500AD would not help,  I do not  think  too
;highly of 2500AD.   My latest version is X32E.COM.  One thing that I have not
;repaired  yet is the lack of any way for the programmer to specify the  short
;forms of the relative jump and call instructions.   The macros in MACLIB.ASM,
;although time consuming,  provide the short forms.  For example BSR1 is a BSR
;with  a  1-byte  displacement and BSR2 is a BSR with a  2-byte  displacement.
;These  macros have features which allow the assembler to detect  out-of-range
;errors.   These  macros are used only for the forward displacements since  my
;assembler automatically sizes the backward displacements.

REL1 MACRO ARG1
XXX VAR ARG1-$+1
 IFTRUE (XXX+40H).ULT.80H
 DB XXX.AND.7FH
 ELSE
 DB XXX.SHL.8
 ENDIF
 ENDM

REL2 MACRO ARG1
XXX VAR ARG1-$+1
 IFTRUE (XXX+2000H).ULT.4000H
 DB XXX.SHR.8.AND.3FH.OR.80H
 DB XXX.AND.0FFH
 ELSE
 DW XXX.SHL.8
 ENDIF
 ENDM

BEQ1 MACRO ARG1
 DB 0AH
 REL1 ARG1
 ENDM

BEQ2 MACRO ARG1
 DB 0AH
 REL2 ARG1
 ENDM

BNE1 MACRO ARG1
 DB 1AH
 REL1 ARG1
 ENDM

BNE2 MACRO ARG1
 DB 1AH
 REL2 ARG1
 ENDM

BCS1 MACRO ARG1
 DB 2AH
 REL1 ARG1
 ENDM

BCS2 MACRO ARG1
 DB 2AH
 REL2 ARG1
 ENDM

BCC1 MACRO ARG1
 DB 3AH
 REL1 ARG1
 ENDM

BCC2 MACRO ARG1
 DB 3AH
 REL2 ARG1
 ENDM

BHI1 MACRO ARG1
 DB 4AH
 REL1 ARG1
 ENDM

BHI2 MACRO ARG1
 DB 4AH
 REL2 ARG1
 ENDM

BLS1 MACRO ARG1
 DB 5AH
 REL1 ARG1
 ENDM

BLS2 MACRO ARG1
 DB 5AH
 REL2 ARG1
 ENDM

BGT1 MACRO ARG1
 DB 6AH
 REL1 ARG1
 ENDM

BGT2 MACRO ARG1
 DB 6AH
 REL2 ARG1
 ENDM

BLE1 MACRO ARG1
 DB 7AH
 REL1 ARG1
 ENDM

BLE2 MACRO ARG1
 DB 7AH
 REL2 ARG1
 ENDM

BFS1 MACRO ARG1
 DB 8AH
 REL1 ARG1
 ENDM

BFS2 MACRO ARG1
 DB 8AH
 REL2 ARG1
 ENDM

BFC1 MACRO ARG1
 DB 9AH
 REL1 ARG1
 ENDM

BFC2 MACRO ARG1
 DB 9AH
 REL2 ARG1
 ENDM

BLO1 MACRO ARG1
 DB 0AAH
 REL1 ARG1
 ENDM

BLO2 MACRO ARG1
 DB 0AAH
 REL2 ARG1
 ENDM

BHS1 MACRO ARG1
 DB 0BAH
 REL1 ARG1
 ENDM

BHS2 MACRO ARG1
 DB 0BAH
 REL2 ARG1
 ENDM

BLT1 MACRO ARG1
 DB 0CAH
 REL1 ARG1
 ENDM

BLT2 MACRO ARG1
 DB 0CAH
 REL2 ARG1
 ENDM

BGE1 MACRO ARG1
 DB 0DAH
 REL1 ARG1
 ENDM

BGE2 MACRO ARG1
 DB 0DAH
 REL2 ARG1
 ENDM

BR1 MACRO ARG1
 DB 0EAH
 REL1 ARG1
 ENDM

BR2 MACRO ARG1
 DB 0EAH
 REL2 ARG1
 ENDM

BSR1 MACRO ARG1
 DB 2
 REL1 ARG1
 ENDM

BSR2 MACRO ARG1
 DB 2
 REL2 ARG1
 ENDM

 END
