;   DIS32.ASM

;by Neil R. Koozer  --  April 13, 1986
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709

;This code is released to the public domain for personal non-profit use only.

;This is a disassembler for 32000 code.  It is designed to be invoked from a
;debugger and only displays its output to the CRT.  To invoke the disassembler,
;call the entry point with R7 set to the address of the code to be
;disassembled.  It returns to the caller if it finds an undefined instruction
;or if the operator presses a control-C.  Pressing any other key will pause
;the display.  While in a paused condition, pressing any key will resume.

;The routines EMIT, KEYPRESS, and KEY are hardware dependent, and the number
;conversion routines call the ROM (NSC Tiny Development System on the NSC
;DB16000 development board).

STAK EQU 27FF0H
USART EQU 0C00000H
BUFLEN EQU 80H

 INCLUDE MACLIB.ASM
 LIST ON
 MACLIST OFF

 RESTORE [R0]    ;get return addr.
 LPRD SP,STAK
 SAVE [R0]       ;save return addr
 BR START

STRBUF
 BLKB BUFLEN

BINBUF           ;"binary" buffer for conversion routines
 DOUBLE 0,0

ADDRESS          ;addr of 1st byte of current instruction
 DOUBLE 0

INDSTOR
 BLKB 6

MSPTAB
 DB '(FP)',0
 DB '(SP)',0
 DB '(SB)',0

SCALSIZ
 DB ':B]',0
 DB ':W]',0
 DB ':D]',0
 DB ':Q]',0

SETCTAB
 DB 'IFMC'

INTSZTAB
 DB 'BW?D'

BTOAFLT          ;convert binary float to ascii
 MOVQD 0,R2
 BR1 BTOA1
BTOALONG         ;convert binary long float to ascii
 MOVQD 1,R2
 BR1 BTOA1
BTOADEC          ;convert binary int to ascii (decimal)
 MOVQD 2,R2
 BR1 BTOA1
BTOAHEX          ;convert binary int to ascii (hex)
 MOVQD 3,R2
BTOA1
 MOVD BINBUF,R1
 MOVD STRBUF,R3
 MOVQD 6,R0
 SVC             ;call ROM routine
 MOVD R3,R1
REA3             ;replace terminating space with 0
 ADDQD 1,R3
 CMPB 20H,-1(R3)
 BNE REA3
 MOVQB 0,-1(R3)
 RET 0

REGPR            ;print a register #
 ANDB 7,R0
 ADDB 30H,R0
EMIT             ;display 1 character
 SAVE [R1]
 MOVD USART,R1
EMI1
 TBITB 0,2(R1)   ;TxRdy bit
 BFC EMI1
 MOVB R0,0(R1)   ;write to USART
 RESTORE [R1]
 RET 0

KEYPRESS         ;see if a key has been pressed
 MOVD USART,R0
 TBITB 1,2(R0)   ;RxRdy bit
 RET 0

KEY              ;get 1 char from keyboard
 BSR KEYPRESS    ;see if there's a char ready
 BFC KEY
 MOVB 0(R0),R0   ;read USART
 RET 0

CRLF
 MOVB 0DH,R0
 BSR EMIT
LINEFD
 MOVB 0AH,R0
 BR EMIT

GETDISP          ;get a number from input stream assuming "disp" format
 MOVD 0(R7),R0
 ADDB R0,R0      ;get msb into carry
 BCS1 DISP2
 ASHB -1,R0      ;sign extend one bit
 MOVXBD R0,R0
 ADDQD 1,R7
 BR1 DISP0
DISP2
 ADDB R0,R0      ;get next msb into carry
 ASHB -2,R0      ;sign extend 2 bits
 BCS1 DISP4
 ROTW 8,R0
 MOVXWD R0,R0
 ADDQD 2,R7
 BR1 DISP0
DISP4
 ROTW 8,R0
 ROTD 16,R0
 ROTW 8,R0
 ADDQD 4,R7
DISP0
 MOVD R0,@BINBUF ;store number in "binary" buffer
 RET 0

DISP             ;get a disp and print it in decimal
 BSR GETDISP
DECPR            ;display contents of "binary" buffer in decimal
 BSR BTOADEC
PRI2
 MOVD STRBUF,R1
PRI1             ;display a string whose addr is in R1
 MOVB 0(R1),R0   ;get string char
 ADDQD 1,R1
 CMPQB 0,R0      ;0 is terminator
 BEQ PRI3
 BSR EMIT
 CMPB 0DH,R0     ;0D also terminates after being printed
 BEQ LINEFD
 BR PRI1
PRI3
 RET 0

PRINT            ;display a literal string
 RESTORE [R1]    ;get return addr (pointer to string)
 BSR PRI1
 JUMP R1

HDISP            ;get a disp and print it in hex
 BSR GETDISP
HEXPR            ;display # in binary buffer in hex
 BSR BTOAHEX
 BSR PRI2
 MOVB 'h',R0     ;label it as 'hex'
 BR EMIT

UND
 BSR PRINT
 DB 'Undefined instruction',0
UND1
 LPRD SP,STAK-4
 RET 0

GENMODE
 MOVB R6,0(R4)   ;store addr mode byte
 CMPB 1CH,R6     ;see if indexed addr mode
 BHI GENM0
 MOVZBD 0(R7),R6 ;get next byte (index byte) from input stream
 ADDQD 1,R7
 MOVB R6,1(R4)   ;store index byte
 LSHD -3,R6      ;adjust byte to use as basemode indicator
NOIMM            ;immediate not allowed as basemode with indexing
 CMPB 14H,R6
 BEQ UND
GENM0
 RET 0

AGEN1            ;do a single general operand which disallows immediate
 MOVW R5,R6
 LSHW -11,R6
 BSR NOIMM
GEN1             ;do a single general operand
 MOVD INDSTOR,R4 ;pointer to stored index-mode information
 MOVZWD R5,R6    ;get general operand designator
 LSHW -11,R6
 BSR GENMODE     ;check for indexed-mode
 BR2 BASEMODE    ;analyze and display the operand

REG8             ;used in format8 to print register #
 BSR PRINT
 DB 'R',0
 MOVB R5,R0
 LSHB -3,R0
 BSR REGPR
COMMA
 MOVB ',',R0
 BR EMIT

AGEN2            ;do 2 general operands where neither operand can be immediate
 MOVW R5,R6
 LSHW -11,R6
 BSR NOIMM
GEN2             ;do 2 general operands where 2nd operand can't be immediate
 MOVW R5,R6
 LSHW -6,R6
 ANDW 1FH,R6
 BSR NOIMM
GEN2IMM          ;do 2 general operands where both can be immediate
 MOVD INDSTOR,R4 ;pointer to additional information pertaining to operands
 MOVZWD R5,R6    ;get addr mode designator of 1st operand
 LSHW -11,R6
 BSR GENMODE     ;check for indexed-mode (1st operand)
 ADDQD 3,R4      ;change pointer to correspond to 2nd operand
 MOVD R6,R3      ;save addr-mode (or basemode) of 1st operand
 MOVZWD R5,R6    ;get addr mode designator of 2nd operand
 LSHD -6,R6
 ANDW 1FH,R6
 BSR GENMODE     ;check for indexed-mode (2nd operand)
 SAVE [R6]       ;save addr-mode (or basemode) of 2nd operand
 MOVD R3,R6      ;get addr-mode (or basemode) of 1st operand
 ADDQD -3,R4     ;change pointer to correspond to 1st operand
 BSR1 BASEMODE   ;analyze and display 1st operand
 ADDQD 3,R4      ;change pointer to correspond to 2nd operand
 RESTORE [R6]    ;get addr-mode (or basemode) of 2nd operand
 BSR COMMA
BASEMODE         ;analyze and display operand
 MOVD SCALE,TOS  ;store ret. addr to cause jump to SCALE
 CMPQB 7,R6      ;see if 'register'
 BLO1 BASE1
 MOVB 2(R4),R0   ;get stored 'R' or 'F'
 BSR EMIT
BASE3
 MOVB R6,R0
 BR REGPR        ;print reg #
BASE1
 CBITB 4,R6
 BFS1 BASE2      ;if bit-4 was set, we don't have reg-relative
 BSR DISP        ;display disp for reg-rel
 BSR PRINT
 DB '(R',0
 BSR BASE3       ;display reg #
BASE11
 MOVB ')',R0
 BR EMIT

BASE2
 CASEB *+4[R6:B]
 DB MREL-BASE2
 DB MREL-BASE2
 DB MREL-BASE2
 DB UNDBASE-BASE2
 DB IMMED-BASE2
 DB ABS-BASE2
 DB EXT-BASE2
 DB TOS-BASE2
 DB MSPACE-BASE2
 DB MSPACE-BASE2
 DB MSPACE-BASE2
 DB PROGMEM-BASE2
 DB UNDBASE-BASE2 ;basemode can't be index-mode
 DB UNDBASE-BASE2
 DB UNDBASE-BASE2
 DB UNDBASE-BASE2

UNDBASE
 BR UND

MSPACE
 BSR DISP
MSP1
 MOVD R6,R1
 ANDB 3,R1
 MULB 5,R1
 ADDD MSPTAB,R1
 BR PRI1

PROGMEM
 BSR PRINT
 DB '* +',0
 BR BSR

TOS
 BSR PRINT
 DB 'TOS',0
 RET 0

EXT
 BSR PRINT
 DB 'EXT(',0
 BSR HDISP
 BSR PRINT
 DB ')+',0
 BR DISP

ABS
 BSR PRINT
 DB '@',0
 BR HDISP

MREL
 BSR GETDISP     ;get disp1
 MOVD R0,TOS
 BSR DISP        ;get & print disp2
 BSR PRINT
 DB '(',0
 MOVD TOS,@BINBUF ;put disp1 into convert buffer
 BSR DECPR       ;print it
 BSR MSP1
 BR BASE11       ;print ')' & exit

IMMED
 CMPB 'F',2(R4)  ;see if it's floating point
 BEQ2 IMMF
 TBITB 1,R5      ;see if D size
 BFC1 IMM1
 BSR1 GETDROT
 BR1 IMM0
GETDROT          ;get 4-byte immediate value
 MOVD 0(R7),R6
 ADDQD 4,R7
 ROTW 8,R6
 ROTD 16,R6
 ROTW 8,R6
 RET 0
IMM1
 TBITB 0,R5      ;see if B-size
 BFS1 IMM2
 MOVXBD 0(R7),R6 ;get 1-byte immediate value
 ADDQD 1,R7
 BR1 IMM0
IMM2
 MOVW 0(R7),R6   ;get 2-byte immed value
 ADDQD 2,R7
 ROTW 8,R6
 MOVXWD R6,R6
IMM0
 MOVD R6,@BINBUF ;store the result
 BR DECPR        ;print it

IMMF             ;get & print a floating-point immed value
 BSR GETDROT
 TBITB 2,R5      ;see if long
 BFS1 IMMLONG
 MOVD R6,@BINBUF
 BSR BTOAFLT
 BR PRI2
IMMLONG
 MOVD R6,@BINBUF+4
 BSR GETDROT
 MOVD R6,@BINBUF
 BSR BTOALONG
 BR PRI2

SCALE            ;print scaled index suffix if indexed-mode
 CMPB 1CH,0(R4)  ;see if indexed mode
 BLS1 SCA1
 RET 0
SCA1
 BSR PRINT
 DB '[R',0
 MOVZBD 1(R4),R0 ;get reg #
 BSR REGPR       ;print reg #
 MOVZBD 0(R4),R1 ;get scale size data
 ANDB 3,R1
 ADDD R1,R1
 ADDD R1,R1
 ADDD SCALSIZ,R1
 BR PRI1         ;print scale size suffix

;the mnemonic-printing routine is called with literal data following the call:
;     DB shift amount to right-justify code for operation
;     DB mask to clear extraneous bits
;     DB length of mnemonic strings in this block
;     DB offset used in jumping past table
;     DB 'stringstringstringstring....'
;any mnemonic strings in the block shorter than 'length' are padded with 0's
MNEMONIC
 RESTORE [R0]    ;use ret addr as pointer
 ADDQD 4,R0
 MOVZBD -1(R0),R2 ;get offset to continuation code
 ADDD R0,R2
 SAVE [R2]       ;new ret. addr
 MOVB R5,R4
 ANDB 3,R4       ;int size (in case it's needed by the caller)
 MOVW R5,R6      ;get basic instruction
 LSHW -4(R0),R6  ;shift specified amount
 ANDB -3(R0),R6  ;mask it
 MOVZBD R6,R6
 MOVD R6,R1      ;preserve R6 for the CASE statements
 MOVB -2(R0),R2  ;# of characters in string
 MULB R2,R1      ;compute addr of string to print
 ADDD R0,R1
MNE1             ;print the string
 MOVB 0(R1),R0
 ADDQD 1,R1
 CMPQB 0,R0      ;exit if we hit a 0
 BEQ1 MNE0
 BSR EMIT
 ACBB -1,R2,MNE1
MNE0
 RET 0

CONDTAB
 DB 'EQNECSCCHILSGTLEFSFCLOHSLTGER',0,'??'

COND             ;print condition for Bcond or Scond
 MOVW *+CONDTAB-$[R4:W],R0
 BSR EMIT
 ROTW 8,R0
 BR EMIT

START
 ADDR *+0,TOS    ;store return to this point
 BSR KEYPRESS    ;check for key pressed
 BFC1 STA2
 BSR KEY         ;read the key
 CMPQB 3,R0      ;see if contr-C
 BEQ UND1        ;exit if control-C
 BSR KEY         ;wait for another keypress
STA2
 MOVD R7,@ADDRESS ;save address for relative instructions
 MOVB 'R',@INDSTOR+2 ;default register type
 MOVB 'R',@INDSTOR+5
 BSR PRINT
 DB 0DH
 MOVD R7,@BINBUF
 BSR BTOAHEX
 BSR PRI2        ;print address
 BSR PRINT
 DB '    ',0
 MOVW 0(R7),R5   ;get basic part of opcode
 MOVZBD R5,R6
 ANDB 0FH,R6
STA1
 CASEW *+4[R6:W]
 DW FORMAT4-STA1
 DW FORMAT4-STA1
 DW FORMAT1-STA1
 DW FORMAT4-STA1
 DW FORMAT4-STA1
 DW FORMAT4-STA1
 DW CUSTOM-STA1
 DW FORMAT4-STA1
 DW FORMAT4-STA1
 DW FORMAT4-STA1
 DW FORMAT0-STA1
 DW FORMAT4-STA1
 DW FORMAT23-STA1
 DW FORMAT23-STA1
 DW EFORMAT-STA1
 DW FORMAT23-STA1

INTSIZE          ;print B, W, or D for int size
 MOVZBD R5,R0
 ANDB 3,R0
 CMPQB 2,R0
 BEQ UND
 MOVB @INTSZTAB[R0:B],R0
 BR EMIT

INTSZSP
 BSR INTSIZE
SPACE
 MOVB 20H,R0
 BR EMIT

FLTSIZE          ;print L or F for size of floating point operation
 TBITB 2,R5
FLTSI1
 MOVB 'L',R0
 BFC EMIT
 MOVB 'F',R0
 BR EMIT

FLTSZSP
 BSR FLTSIZE
 BR SPACE

FORMAT0
 ADDQD 1,R7
 BSR PRINT
 DB 'B',0
 MOVZBD R5,R4
 LSHD -4,R4
 BSR COND
 BR BSR

FORMAT1
 ADDQD 1,R7
 BSR MNEMONIC
 DB -4,0FH,4,64
 DB 'BSR',0,'RET',0,'CXP',0,'RXP',0,'RETTRETISAVE',0,0,0,0,0,0,0,0
 DB 'EXITNOP',0,'WAITDIA',0,'FLAGSVC',0,'BPT',0
FOR11
 CASEB *+4[R6:B]
 DB BSR-FOR11
 DB FOR1DISP-FOR11
 DB FOR1DISP-FOR11
 DB FOR1DISP-FOR11
 DB FOR1DISP-FOR11
 DB FOR10-FOR11
 DB SAVE-FOR11
 DB RESTORE-FOR11
 DB ENTER-FOR11
 DB EXIT-FOR11
 DB FOR10-FOR11
 DB FOR10-FOR11
 DB FOR10-FOR11
 DB FOR10-FOR11
 DB FOR10-FOR11
 DB FOR10-FOR11

FOR10
 RET 0

FOR1DISP
 BSR SPACE
 BR DISP

BSR
 BSR FOR1DISP    ;print the displacement in decimal
BSR3
 BSR PRINT
 DB ' <',0
 MOVD @ADDRESS,R0
 ADDD R0,@BINBUF
 BSR HEXPR       ;print the actual destination address in hex
 BSR PRINT
 DB '>',0
 RET 0

ENTER
 BSR PRINT
 DB 'ENTER',0
 BSR1 SAVE       ;display reglist
CDISP
 BSR COMMA
 BR DISP

SAVE
 MOVQB 0,R5      ;used in XOR to handle sequence of regs
 BR1 REST6

RESTORE
 BSR PRINT
 DB 'RESTORE',0
EXIT
 MOVQB 7,R5      ;used in XOR to handle sequece of regs
REST6            ;print register list
 ADDQD 1,R7
 BSR PRINT
 DB ' [',0
 MOVQB 0,R6
REST1
 TBITB R6,-1(R7)
 BFS1 REST2
 ADDQB 1,R6
 CMPQB 7,R6
 BHS REST1
REST0
 BSR PRINT
 DB ']',0
 RET 0
REST2
 BSR PRINT
 DB 'R',0
REST5
 MOVB R6,R0
 XORB R5,R0      ;modify reg # if 'RESTORE'
 BSR REGPR
REST4
 ADDQB 1,R6
 CMPQB 7,R6
 BLO REST0
REST3
 TBITB R6,-1(R7) ;see if reg#(R6) is in list
 BFC REST4
 BSR PRINT
 DB ',R',0
 BR REST5

FORMAT23
 ADDQD 2,R7
 BSR MNEMONIC
 DB -4,7,4,32
 DB 'ADDQCMPQSPR',0,'S',0,0,0,'ACB',0,'MOVQLPR',0,0,0,0,0
 MOVW R5,R4      ;get the 'short' field into R4
 LSHW -7,R4
 ANDB 0FH,R4
 CMPQB 7,R6
 BEQ2 FORMAT3
 CMPQB 3,R6      ;see if Scond
 BNE1 FOR22
 BSR COND
FOR22
 BSR INTSZSP     ;print int size + space
FOR21
 CASEB *+4[R6:B]
 DB MOVQ-FOR21
 DB CMPQ-FOR21
 DB SPR-FOR21
 DB FOR23-FOR21
 DB ACB-FOR21
 DB MOVQ-FOR21
 DB LPR-FOR21

FOR20
 BSR COMMA
FOR23
 BR AGEN1

QUICK
 CMPQB 7,R4
 BHS1 QUI1
 ORB -16,R4      ;sign extend 4 bits if neg
QUI1
 MOVXBD R4,@BINBUF ;sign extend & store
 BR DECPR        ;print it in decimal

MOVQ
 BSR QUICK
 BR FOR20

ACB
 BSR MOVQ
 BSR COMMA
 BSR DISP
 BR BSR3         ;print relative displacement

CMPQ
 BSR QUICK
CMPQ1
 BSR COMMA
 BR GEN1

SPR
 BSR1 PROCREG
 BR FOR20

LPR
 BSR1 PROCREG
 BR CMPQ1

PROCREG
 CMPQB 0,R4      ;see if UPSR
 BNE1 SPR1
 BSR PRINT
 DB 'UPSR',0
 RET 0
SPR1
 CBITB 3,R4      ;no more with bit3 = 0
 BFC UND
 CMPQB 6,R4      ;see if INTBASE
 BNE1 SPR2
 BSR PRINT
 DB 'INTBASE',0
 RET 0
SPR2
 BSR MNEMONIC
 DB -7,7,3,24
 DB 'FP',0,'S','P',0,'SB',0,'UND???PSR',0,0,0,'MOD'
 RET 0

FORMAT3
 CBITB 0,R4
 BFS2 UND3
 BSR MNEMONIC
 DB -8,7,6,48
 DB 'CXPD',0,0,'BICPSRJUMP',0,0,'BISPSR??????ADJSP',0,'JSR',0,0,0,'CASE',0,0
FOR31
 CASEB *+4[R6:B]
 DB JSR-FOR31
 DB BICPSR-FOR31
 DB JSR-FOR31
 DB BICPSR-FOR31
 DB UND3-FOR31
 DB CASE-FOR31
 DB JSR-FOR31
 DB CASE-FOR31

UND3
 BR UND

CASE
 BSR INTSZSP
 BR GEN1

JSR
 TBITB 1,R5
 BFC UND3
 BSR SPACE
 BR AGEN1

BICPSR
 TBITB 1,R5
 BFS UND3
 BR CASE

FORMAT4
 ADDQD 2,R7
 BSR MNEMONIC
 DB -2,0FH,4,64
 DB 'ADD',0,'CMP',0,'BIC',0,'????ADDCMOV',0,'OR',0,0,'????'
 DB 'SUB',0,'ADDRAND',0,'????SUBCTBITXOR',0,'????'
 CMPB 9,R6
 BEQ1 ADDR
 BSR INTSZSP
 CMPQB 1,R6      ;see if CMPi
 BNE GEN2
 BR GEN2IMM      ;CMPi allows both operands to be immediate

ADDR
 CMPQB 3,R4      ;must be D size
 BNE UND
 BSR SPACE
 BR AGEN2        ;neither operand can be immediate

FORMAT5
 MOVW R5,R6
 ANDW 0F870H,R6
 CMPQW 0,R6
 BNE UND
 BSR MNEMONIC
 DB -2,3,6,24
 DB 'MOVS',0,0,'CMPS',0,0,'SETCFGSKPS',0,0
 CMPQB 2,R6
 BEQ2 SETCFG
 TBITB 7,R5
 BFS1 SKPST
 BSR INTSZSP
 BR1 SKPS
SKPST
 CMPQB 0,R4      ;must be B size
 BNE UND
 BSR PRINT
 DB 'T ',0
SKPS
 TBITB 8,R5
 BFC1 SKPS1
 BSR PRINT
 DB 'B',0
SKPS1
 LSHW -9,R5
 ANDB 3,R5
 CMPQB 2,R5
 BEQ UND
 BHI1 SKPS2
 MOVB 'U',R0
 BR EMIT
SKPS2
 CMPQB 0,R5
 BEQ1 SKPS0
 MOVB 'W',R0
 BR EMIT
SKPS0
 RET 0
SETCFG
 CMPQB 3,R4
 BNE UND
 BSR PRINT
 DB '[',0
 LSHW -7,R5      ;get the 'short' field
 ANDB 0FH,R5
 MOVQB 0,R6
 FFSB R5,R6
 BFS1 SETC0
SETC1
 MOVB @SETCTAB[R6:B],R0 ;get the letter corresponding to the bit set
 BSR EMIT
 ADDQB 1,R6
 FFSB R5,R6
 BFS1 SETC0
 BSR COMMA
 BR SETC1
SETC0
 MOVB ']',R0
 BR EMIT

FORMAT6
 BSR MNEMONIC
 DB -2,0FH,5,80
 DB 'ROT',0,0,'ASH',0,0,'CBIT',0,'CBITI?????LSH',0,0,'SBIT',0,'SBITINEG',0,0
 DB 'NOT',0,0,'?????SUBP',0,'ABS',0,0,'COM',0,0,'IBIT',0,'ADDP',0
 BSR INTSZSP
FOR61
 CASEB *+4[R6:B]
 DB ROT-FOR61
 DB ROT-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB UND6-FOR61
 DB ROT-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB UND6-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61
 DB FOR60-FOR61

UND6
 BR UND

ROT
 ANDB 0FCH,R5    ;after printing int size, force 1st operand to be B size
FOR60
 BR GEN2

FORMAT7
 BSR MNEMONIC
 DB -2,0FH,4,64
 DB 'MOVMCMPMINSSEXTSMOVXMOVZMOVZMOVXMUL',0,'MEI',0,'????DEI',0
 DB 'QUO',0,'REM',0,'MOD',0,'DIV',0
FOR71
 CASEB *+4[R6:B]
 DB MOVM-FOR71
 DB MOVM-FOR71
 DB INSS-FOR71
 DB EXTS-FOR71
 DB XZBW-FOR71
 DB XZBW-FOR71
 DB XZD-FOR71
 DB XZD-FOR71
 DB MUL-FOR71
 DB MUL-FOR71
 DB UND7-FOR71
 DB MUL-FOR71
 DB MUL-FOR71
 DB MUL-FOR71
 DB MUL-FOR71
 DB MUL-FOR71

UND7
 BR UND

MUL
 BSR INTSZSP
 BR GEN2

XZBW
 CMPQB 0,R4
 BNE UND7
 BSR PRINT
 DB 'BW ',0
 BR GEN2

XZD
 CMPQB 1,R4
 BLO UND7
 BSR INTSIZE
 BSR PRINT
 DB 'D ',0
 BR GEN2

MOVM
 BSR INTSZSP
 BSR AGEN2
 BSR COMMA
 BSR GETDISP
 ANDB 3,R5
 CMPQB 3,R5
 BNE1 MOVM1
 MOVQB 2,R5
MOVM1
 NEGB R5,R5
 ASHD R5,R0      ;divide by 2 for W, 4 for D, 1 for B
 ADDQD 1,R0      ;apply the finishing touch before printing
 MOVD R0,@BINBUF
 BR DECPR

EXTS
 BSR INTSZSP
 BSR AGEN2
 BR1 INSS1
INSS
 BSR INTSZSP
 BSR GEN2
INSS1
 BSR COMMA
 MOVB 0(R7),R6
 ADDQD 1,R7
 MOVB R6,R0
 LSHB -5,R0
 BSR REGPR       ;print a 0-to-7 size number
 BSR COMMA
 ANDB 1FH,R6
 ADDQB 1,R6
 MOVZBD R6,@BINBUF
 BR DECPR

FORMAT80
 BSR MNEMONIC
 DB -2,1,5,10
 DB 'EXT',0,0,'INDEX'
 BSR INTSZSP
 BSR REG8        ;print register number
 CMPQB 1,R6
 BEQ GEN2
 BSR AGEN2
 BR CDISP        ;print comma & disp

FORMAT81
 BSR MNEMONIC
 DB -2,1,4,8
 DB 'CVTPFFS',0
 CMPQB 1,R6
 BEQ1 FFS
 BSR SPACE
FOR84
 BSR REG8
 BR AGEN2
FFS
 BSR INTSZSP
 BR GEN2

FORMAT83
 TBITB 2,R5
 BFS UND
 BSR PRINT
 DB 'CHECK',0
 BSR INTSZSP
 BR FOR84

FORMAT82
 BSR MNEMONIC
 DB -2,1,3,6
 DB 'INSMOV'
 CMPQB 1,R6
 BEQ1 FOR85
 BSR INTSZSP
 BSR REG8
 BSR GEN2
 BR CDISP
FOR85
 MOVB R5,R6
 ANDB 38H,R6
 CMPB 8,R6
 BEQ1 MOVSU
 CMPB 18H,R6
 BNE UND
 BSR PRINT
 DB 'US',0
 BR1 MOV8
MOVSU
 BSR PRINT
 DB 'SU',0
MOV8
 BSR INTSZSP
 BR AGEN2

FORMAT9
 BSR MNEMONIC
 DB -3,7,5,40
 DB 'MOV',0,0,'LFSR',0,'MOVLFMOVFLROUNDTRUNCSFSR',0,'FLOOR'
 MOVD INDSTOR,R4
FOR91
 CASEB *+4[R6:B]
 DB MOVIF-FOR91
 DB LFSR-FOR91
 DB MOVLF-FOR91
 DB MOVFL-FOR91
 DB ROUND-FOR91
 DB ROUND-FOR91
 DB SFSR-FOR91
 DB ROUND-FOR91

ROUND
 MOVB 'F',2(R4)  ;set 1st operand register-type to 'F'
 BSR FLTSIZE
 BSR INTSZSP
 BR GEN2

MOVIF
 MOVB 'F',5(R4)  ;set 2nd operand register-type to 'F'
 BSR INTSIZE
 BSR FLTSZSP
 BR GEN2

LFSR
 MOVW R5,R6
 ANDW 7FFH,R6
 CMPW 0FH,R6
 BNE UND
 BSR SPACE
 BR GEN1

MOVLF
 MOVB R5,R6
 ANDB 7,R6
 CMPQB 6,R6
 BNE UND
 BR1 FOR92
MOVFL
 MOVB R5,R6
 ANDB 7,R6
 CMPQB 3,R6
 BNE UND
FOR92
 MOVB 'F',2(R4)  ;set register-type to 'F' for both operands
 MOVB 'F',5(R4)
 BSR SPACE
 BR GEN2

SFSR
 MOVW R5,R6
 ANDW 0F83FH,R6
 CMPW 37H,R6
 BNE UND
 BSR SPACE
 LSHW 5,R5
 BR AGEN1

FORMAT11
 TBITB 1,R5
 BFS UND
 BSR MNEMONIC
 DB -2,0FH,3,48
 DB 'ADDMOVCMP',0,0,0,'SUBNEG',0,0,0,0,0,0
 DB 'DIV',0,0,0,0,0,0,0,0,0,'MULABS',0,0,0,0,0,0
FOR111
 CASEB *+4[R6:B]
 DB ADDF-FOR111
 DB ADDF-FOR111
 DB ADDF-FOR111
 DB UND11-FOR111
 DB ADDF-FOR111
 DB ADDF-FOR111
 DB UND11-FOR111
 DB UND11-FOR111
 DB ADDF-FOR111
 DB UND11-FOR111
 DB UND11-FOR111
 DB UND11-FOR111
 DB ADDF-FOR111
 DB ADDF-FOR111
 DB UND11-FOR111
 DB UND11-FOR111

UND11
 BR UND

ADDF
 MOVB 'F',@INDSTOR+2 ;make register type 'F' for both operands
 MOVB 'F',@INDSTOR+5
 TBITB 0,R5      ;test if float or long float
 BSR FLTSI1      ;print 'L' or 'F'
 BSR SPACE
 BR GEN2

FORMAT14
 MOVB R5,R6
 ANDB 73H,R6
 CMPQB 3,R6
 BNE UND
 BSR MNEMONIC
 DB -2,3,5,20
 DB 'RDVALWRVALLMR',0,0,'SMR',0,0
 BSR SPACE
 CMPQB 2,R6
 BLS1 LMR
 MOVW R5,R6
 ANDW 780H,R6
 CMPQW 0,R6
 BNE UND
 BR AGEN1
LMR
 BSR MNEMONIC
 DB -7,0FH,4,64
 DB 'BPR0BPR1????????PF0',0,'PF1',0,'????????'
 DB 'SC',0,0,'????MSR',0,'BCNTPTB0PTB1????EIA',0
 BSR COMMA
 TBITB 2,R5
 BFS1 SMR
 BR GEN1
SMR
 BR AGEN1

CUSTOM
 BR UND

EFORMAT
 ADDQD 3,R7
 MOVZBD -3(R7),R6
 MOVW -2(R7),R5  ;basic instruction code
 LSHD -4,R6
EFOR1
 CASEW *+4[R6:W]
 DW FORMAT5-EFOR1
 DW FORMAT14-EFOR1
 DW FORMAT80-EFOR1
 DW FORMAT9-EFOR1
 DW FORMAT6-EFOR1
 DW UND-EFOR1
 DW FORMAT81-EFOR1
 DW UND-EFOR1
 DW UND-EFOR1
 DW UND-EFOR1
 DW FORMAT82-EFOR1
 DW FORMAT11-EFOR1
 DW FORMAT7-EFOR1
 DW UND-EFOR1
 DW FORMAT83-EFOR1
 DW UND-EFOR1

 END
