
 INCLUDE 4CON.ASM
 INCLUDE MACLIB.ASM
 LIST ON
 MACLIST OFF

;  BASIC for the 32000

;by Neil R. Koozer            July 29, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709

;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.


;  September 20, 1985      November 19, 1985       November 26, 1985
;  January 9, 1986         February 1, 1986


 GLOBAL STRDEL,STRD1,STRD2,EXPRESS,SYNERR,ALIGN,EXP0,DISP,PSTART,PRIN4
 GLOBAL OFFSET,ACCUM,AEMPTY,LOOK,REGBYTE,SAVESP,LINK4B1,BHEADER,INEXPR

 EXTERNAL PQU1,ATAIL,SBCOMMA,REGLIST,QUI1,ALOAD,COMPILE,SAVACC,ADD,WFLAG
 EXTERNAL ERR1,OPTABLE,DEFI21,DEFF03,NEGACC,MODEL,INTERP1,FINDWRD,TO_INL
 EXTERNAL RELDISP,DPL,SBC4,HEADER,DIM5,IMMED,DEFI1,TIBL,PERI1,DEFI20
 EXTERNAL STYPE,FIL2,XLOAD,DBL1,MULT,LINK4B0,QRUN,STR21,SKEY,EDI0,EDTABL
 EXTERNAL BLKL,BNEW

SAVESP DOUBLE 0
PSTART DOUBLE 0  ;addr of start of compiled executable BASIC code
REGBYTE DB 0     ;count of integer register variables
REGDBL DB 0      ;count of float register variables
SIGN DW 0
NOTF DW 0
ACCUM            ;storage for description of accumulator (6 means R6)
 DOUBLE 6        ;this part holds addressing mode & data type indicators
 DOUBLE 0        ;this part for address or disp when accum isn't reg. or TOS
AEMPTY DW 0      ;flag to indicate accum. empty
 DB 0            ;NULL uses this byte
NULL
 DB 9            ;NOP uses this byte
NOP RET 0
INEXPR DB 0

SNERROR
 DB 13,' Syntax Error'

 DB 4,'STOP'
 DW LINK4B0-$    ;link to previous module
BL VAR $-7
 MOVD BSTOP,R1
 JUMP @SBCOMMA

BSTOP
 PUTREG          ;save reg. variables
 SPRD SP,*+SAVESP-$ ;save SP in case errors occur during command mode
 BSR PQUOTE
 DB 11,0DH,0AH,'Break at '
 MOVD 0(SP),R6
 BSR2 PRINT
 JUMP @QUI1      ;goto main command loop

 DB 4,'CONT'
 DW BL-$
BL VAR $-7
 ADJSPB -12      ;set up return to previous STOP location
 GETREG          ;get reg. variables
 RET 0

FIND1            ;find next non-space in input stream
 ADDQD -2,R7
 MOVB ' ',0(R7)
 JUMP @FINDWRD

LOOK             ;This does a conditional jump depending on whether a
 SAVE [R3,R4,R6] ;particular string is found in the input stream.  If the
 BSR FIND1       ;string is found, the text pointer is advanced just past the
 MOVD 12(SP),R1  ;string.  If char count has bit 7 set, it does jump-if-found;
 MOVZBD 0(R1),R0 ;otherwise it does jump-if-not-found.
 MOVB R0,R4
 CBITB 7,R0
 ADDQD 1,R1
 CMPSB
 ADDD R0,R1
 ADDQD 1,R1
 BNE1 LOO4
 SUBD R6,R2
 MOVD R2,@TO_INL
 TBITB 7,R4
 BFC1 LOO2
 BR1 LOO1
LOO4
 TBITB 7,R4
 BFS1 LOO2
LOO1
 MOVXBD -1(R1),R2
 ADDD R2,R1
LOO2
 RESTORE [R3,R4,R6]
 ADJSPB -4
 JUMP R1

OFFSET           ;compile code to compute offset into array of desired element
 SAVE [R6]       ;addr of addr. mode bytes
 MOVZBW 2(R6),TOS ;push #-of-dimensions
 ADDQD 7,R6      ;point to 2nd dim (or start of array)
 SAVE [R6]
 BSR EXP0        ;read expression
 CMPQB 2,R1      ;2 means 2-operand expression (not yet compiled)
 BHI DIM7
 SAVE [R2,R5,R6]
 MOVD R3,R5
 MOVD R4,R6
 JSR @ALOAD      ;load the first operand
 RESTORE [R4,R5,R6]
 JSR R4          ;compile operation & second operand
 MOVQD 0,R1      ;0 means result is in accum
DIM7
 MOVD R1,R4      ;save flag
 BSR LOOK
 DB 1,','
 BRR DIM6
 CMPQB 1,R4      ;1 means 1-operand expression (not yet compiled)
 BNE1 DIM8       ;NE means the value is already in accum.
 JSR @ALOAD      ;put it into accum
DIM8
 RESTORE [R5]    ;addr of next dim
 MOVD -4(R5),R6  ;get dim
 ADDQD 4,R5      ;point to next dim or start of array
 ADDQB -1,0(SP)  ;decr dimension counter
 SAVE [R5]
 ADDR @14H,R5    ;set R5 = 14h for 'immediate'
 JSR @MULT       ;mult the running product by dim.
 MOVD DIM13,TOS  ;return addr.
 MOVQB 1,*+AEMPTY-$ ;tell expression routine that accum. is full
 MOVD NULL,TOS   ;stack delimiter for expresson routine
 MOVD ADD,TOS    ;save the add till the exp. is done
 BR2 EXP2        ;do an expression
DIM13            ;return here
 BSR LOOK        ;see if there are more dimensions
 DB 81H,','
 BRR DIM8
 MOVQD 0,R4
DIM6
 BSR LOOK
 DB 1,')'
 BRR SYNERR
 CMPQB 1,R4      ;see if 1-operand expr (not yet compiled)
 BNE2 DIM9
 CMPQB 5,R5
 BLO1 DIM10
 MOVB R5,R0      ;Rn = reg.
 BR1 DIM11

SYNERR
 MOVD SNERROR,R2
 JSR @STYPE
 JSR @SKEY       ;wait for key-pressed
 CMPQB 0,@BLKL   ;see if we're in a block
 BEQ1 SYN0
 MOVW @TO_INL,@EDTABL ;init edit cursor to point of error
 JSR @EDI0
SYN0
 JUMP @BNEW      ;start anew

DIM10
 JSR @ALOAD
DIM9
 MOVW *+ACCUM-$,R0 ;Rn = accum
DIM11
 RESTORE [R6]    ;addr of array
 CMPQW 0,TOS     ;see if correct # of dimensions found
 BNE1 INDERR
 RESTORE [R2]    ;addr of type bytes
 MOVZBD 0(R2),R5 ;basemode
 LSHW 3,R5
 ORB R0,R5       ;append 'Rn'
 LSHW 8,R5
 MOVB 1(R2),R5   ;indexed-addressing-mode byte
 CMPB 1FH,R5     ;see if real
 BNE1 DIM12
 SBITB 16,R5     ;set real flag
DIM12
 RET 0

INDERR
 MOVD INDERRM,R2
 JUMP @ERR1

EXPRESS
 MOVD *+ACCUM-$,R5 ;make the accum the destination
 MOVD *+ACCUM+4-$,R6
 JSR @DEFI21       ;do an asignment statement
 MOVQB 1,*+AEMPTY-$ ;set 'accum full' flag
 RET 0

;expression parser starts with EXP0.  If it finds one or two operands, it
;returns information about the operands and operator, but does not compile.  If
;it finds more than two operands, it compiles code to evaluate the expression
;and place the result into the current accumulator.
EXP0
 MOVQB 0,*+AEMPTY-$ ;0 means accum empty
EXP1
 MOVD NULL,TOS     ;stack delimiter
EXP2
 MOVQB 0,*+SIGN-$  ;'READ OPERAND' starts here
 MOVQB 0,*+NOTF-$
EXP0B
 BSR LOOK
 DB 81H,'+'
 BRR EXP0B
 BSR LOOK
 DB 1,'-'
 BRR EXP0D
 XORB 1,*+SIGN-$
 BR EXP0B
EXP0D
 BSR LOOK
 DB 81H,'('
 BRR EXP0DD
 BR2 EXP0E
EXP0DD
 MOVQD -2,R5       ;-2 means expression in expression
RECURSIVE
 CBITB 0,*+AEMPTY-$ ;test accum-busy flag
 BFC1 RECUR1
 RESTORE [R4]      ;pending operator
 MOVD *+ACCUM-$,R2 ;get type of accum
 MOVW @17H,R2      ;make it TOS
 SAVE [R2,R3,R4]   ;save the operation
 JSR @SAVACC       ;compile code to push accumulator
RECUR1
 CMPQD -3,R5       ;see if array element
 BNE1 RECUR5
 MOVW *+SIGN-$,TOS
 MOVQD 6,*+ACCUM-$ ;use R6 for array element offset
 MOVQD 0,*+ACCUM-$+4
 BSR OFFSET        ;compile code to compute array element offset
 MOVW TOS,*+SIGN-$
 CMPQB 0,*+AEMPTY-$ ;accum still clean if offset is a reg. variable
 BEQ2 REA2
 MOVD ALOAD,TOS    ;make pending operator 'load-into-accum'
 BR2 REA2
RECUR5
 MOVD NOP,TOS      ;fake 'pending operator'
 MOVW *+SIGN-$,TOS
 CMPQD -1,R5       ;see if function
 BNE1 RECUR3
 JSR @DEFF03       ;compile function call
 MOVQB 1,*+AEMPTY-$ ;function always uses accum
 BR1 RECUR4
RECUR3
 BSR EXPRESS       ;get expression recursively
 BSR LOOK
 DB 1,')'
 BRR RECURE        ;error if no ')'
RECUR4
 CMPQW 0,TOS       ;pop & test sign
 BEQ1 RECUR2
 JSR @NEGACC       ;compile code to negate accum.
RECUR2
 MOVD *+ACCUM-$,R5 ;make accum the source of the operand
 MOVD *+ACCUM+4-$,R6
 BR2 EXP3

RECURE
 BR SYNERR

EXP0E
 BSR LOOK
 DB 3,'NOT'
 BRR EXP0F
 XORB 1,*+NOTF-$
 BR EXP0E
EXP0F
 CMPQB 0,*+NOTF-$
; BNE EXP0NOT      ;this NOT stuff isn't finished yet
EXP0H
 MOVQB 1,@INEXPR  ;set flags meaning 'within BASIC expression'
 MOVQB 3,@MODEL
 JSR @INTERP1      ;get operand from input stream
 MOVQB 0,@INEXPR
 MOVQB 0,@MODEL
 CMPQD -8,R5       ;-1 means function, -3 means array element
 BLS RECURSIVE
REA2
 CBITB 0,*+SIGN-$  ;test & clear sign
 BFC1 REA0
 CMPB 14H,R5       ;see if immed.
 BNE1 REA1
 NEGD R6,R6        ;negate before compiling
REA0
 CBITB 31,R5       ;clear sign bit for pos.
 BR1 EXP3
REA1
 SBITB 31,R5       ;set sign bit for neg.
EXP3               ;here we have finished getting operand by whatever method
 SAVE [R6]         ;we now prepare to look for an operator
 BSR FIND1         ;find next non-space
 MOVD R2,R3        ;text pointer
 MOVD OPTABLE,R1
 MOVQB 5,R4        ;counter
 MOVQD 3,R0        ;look for 3-char string
 BR1 OPER3
OPER2
 MOVQD 2,R0        ;look for 2-char strings
OPER3
 MOVD R3,R2        ;text pointer
 CMPSB
 BEQ1 OPFOUND
 ADDD R0,R1
 ADDQD 4,R1        ;point to next table entry
 ACBB -1,R4,OPER2
 ADDQD 1,R1
 MOVD R3,R2
 ADDQD 1,R2        ;point to start of 1-char strings
 MOVB 8,R4         ;count
OPER1
 CMPB -1(R2),-1(R1)
 BEQ1 OPFOUND
 ADDQD 5,R1        ;point to next table entry
 ACBB -1,R4,OPER1
 RESTORE [R6]      ;no operator found
 BR2 FINUP         ;goto finish-up
OPFOUND
 MOVD 0(R1),R3     ;get addr of routine for this operator
 SUBD R6,R2
 MOVD R2,@TO_INL   ;store the text pointer
 RESTORE [R6]
 CMPQB 0,*+AEMPTY-$ ;see if accum clean
 BNE2 EXP15
 CMPD NULL,0(SP)   ;see if first operand
 BNE1 EXP11
 SAVE [R5,R6]      ;save first operand descriptors
 BR1 EXP14

EXP11              ;arrive here if operator found after second operand
 RESTORE [R4]      ;remember first operator
 MOVD R5,R0        ;move second operand descriptors
 MOVD R6,R1
 RESTORE [R5,R6]   ;get first operand
 SAVE [R4]         ;save first operator
 SAVE [R0,R1,R3]   ;save second operand & second operator
 JSR @ALOAD        ;compile code to load 1st operand into accum
 RESTORE [R3]      ;second operator
 RESTORE [R5,R6]   ;second operand
 BR1 EXP15

EXP13
 RESTORE [R5,R6]   ;get stacked operand designators
 SBITB 30,R5       ;reverse flag
EXP12
 SAVE [R3]         ;save new operator
 JSR R4            ;execute old operator & current operand
 RESTORE [R3]
 RESTORE [R4]      ;check for stacked operations of higher or equal precedence
 CMPB -1(R4),-1(R3)
 BHS EXP13
 SAVE [R4]         ;put it back if we didn't use it
EXP14
 SAVE [R3]         ;save new operator
 BR EXP2           ;go back to get another operand
EXP15
 RESTORE [R4]
 CMPB -1(R3),-1(R4) ;compare pecedence of old & new operators
 BLS EXP12         ;jump to execute old operator & current operand
 ADDR @17H,R2      ;we stack the operation if new operator has high pecedence
 SAVE [R2,R3,R4]   ;R4=old operation, R2=TOS operand, R3=junk
 SAVE [R3]         ;new operator
 JSR @SAVACC       ;compile code to push accum.
 JSR @ALOAD        ;compile code to load current operand into accum.
 BR EXP2           ;go back for another operand

FINUP              ;finish up expression
 CMPQB 0,*+AEMPTY-$ ;see if accum clean
 BNE1 FIN4
 CMPD NULL,0(SP)   ;accum clean & nothing on stack means one-operand expr.
 BNE1 FIN1
FIN5
 MOVQD 1,R1        ;return a '1' for one-operand expression
 ADJSPB -4
 RET 0
FIN4
 RESTORE [R4]
 CMPD ALOAD,R4     ;'ALOAD' on stack & accum dirty means we have an uncompiled
 BEQ FIN5          ;one-operand expression (probably and array element)
 BR1 FIN3
FIN1
 CMPD NULL,12(SP)
 BNE1 FIN2
 MOVQD 2,R1        ;return a '2' for uncompiled two-operand expression
 RESTORE [R2]      ;operator
 RESTORE [R3,R4]   ;1st operand designators
 ADJSPB -4
 RET 0
FIN2               ;we probably can't get here (>2 operands & accum clean)
 MOVD ALOAD,R4     ;operator to load most recent operand
FIN3
 JSR R4            ;compile code to execute pending operation
 RESTORE [R4]      ;compile code to execute all stacked operations
 CMPD NULL,R4
 BEQ1 FIN0
 RESTORE [R5,R6]
 SBITB 30,R5       ;set reverse bit
 BR FIN3
FIN0
 MOVQD 0,R1        ;return a '0' for 'expr. compiled & result is in accum'
 MOVD *+ACCUM-$,R5 ;make accum the new source
 MOVD *+ACCUM+4-$,R6
 RET 0

DISP               ;compile value in R1 in 32000 disp format
 JSR @RELDISP
DIS1
 MOVD R2,@DPL
 RET 0
DISP4              ;compile value in R1 in 32000 4-byte disp format
 JSR @SBC4
 BR DIS1

BHEADER
 JSR @QRUN
 MOVQB 1,@INEXPR   ;make new word conform to BASIC syntax
 JSR @HEADER
 MOVQB 0,@INEXPR
 JUMP @IMMED

VARHEAD
 BSR BHEADER
ALIGN              ;align compiled code by compiling a NOP if necessary
 TBITB 0,@DPL
 BFC1 ALI0
 JSR @COMPILE
 DB 1,0A2H
ALI0
 RET 0

GETDIM           ;used in array delarations to get index limits
 MOVD @DPL,R2
 MOVD R2,R6      ;dest addr for assign. statement
 SAVE [R6]
 ADDQD 4,R2
 MOVD R2,@DPL    ;anticipate new dict pointer after # stored
 MOVD R2,@PSTART
 ADDR @15H,R5    ;abs addr mode for dest. of assig. statement
 JSR @DEFI20     ;compile assignment statement
 JSR @QRUN       ;execute the compiled code
 RESTORE [R0]    ;addr of dim.
 MOVD 0(R0),R6   ;get dim.
 ADDQD 1,R6      ;# of array elements is 1 greater than index limit
 MOVD R6,0(R0)
 RET 0

 DB 6,'DEFSTR'
 DW BL-$
BL VAR $-9
 MOVW 0DCH,TOS   ;indexed mode [Rn:B]
 BR1 AHEADER

 DB 6,'DIMINT'
 DW BL-$
BL VAR $-9
 MOVW 1EH,TOS    ;indexed mode [Rn:D]
 BR1 AHEADER

 DB 6,'DIMDBL'
 DW BL-$
BL VAR $-9
 MOVW 1FH,TOS    ;indexed mode [Rn:Q]
AHEADER
 BSR VARHEAD    ;compile a FORTH header in dictionary using next word
 MOVD DIM5,R1    ;addr of generic executable code for arrays & strings
 JSR @SBCOMMA    ;compile a BSR to addr in R1
 MOVB *+REGBYTE-$,R0 ;check for availability of registers for reg. variable
 CMPQB 5,R0
 BLO1 NONREG
 MOVB R0,4(R2)   ;compile reg addressing code into heading
 ADDQB 1,R0
 MOVB R0,*+REGBYTE-$
 BR1 DEFI6
NONREG
 MOVB 15H,4(R2)  ;compile abs addressing code into heading
DEFI6
 MOVB 0(SP),5(R2) ;indexed mode byte into header
 BSR1 DIM0
 BSR LOOK
 DB 81H,','
 BRR AHEADER
 ADJSPB -2       ;drop 'index mode' from stack
 RET 0

DIME
 BR SYNERR

DIM0
 ADDQD 6,R2
 SAVE [R2]        ;save addr of #-of-dimesions byte
 MOVQB 0,0(R2)    ;init count of #-of-dimensions
 ADDQD 1,R2
 MOVD R2,@DPL
 BSR LOOK
 DB 1,'('         ;array or string declaration must have '('
 BRR DIME
 BSR GETDIM       ;get 1st dimension
DIM2
 SAVE [R6]        ;remember size of each dimension
 BSR LOOK
 DB 1,','
 BRR DIM1         ;jump to DIM1 if no more dims.
 MOVD 4(SP),R2    ;addr of #-of-dimensions
 ADDQB 1,0(R2)    ;incr #-of-dimensions
 BSR GETDIM       ;get next dimension
 MULD TOS,R6      ;partial product of dim sizes
 BR DIM2
DIM1
 RESTORE [R6]     ;product of all dim. sizes
 RESTORE [R2]     ;addr of #-of-dimesions
 MOVZBD -2(R2),R1 ;basemode
 MOVQD 5,R0
 SUBD R1,R0
 BCS1 DIMC        ;carry set means basemode not reg.
 MOVD @DPL,@REGLIST[R0:D] ;init reg with array addr.
DIMC
 TBITB 1,-1(R2)   ;see if byte array
 BFC1 DIMB        ;avoid *4 if byte array or word array
 ADDD R6,R6
 ADDD R6,R6       ;*4 for 32-bit-element array
DIMB
 TBITB 0,-1(R2)
 BFC1 DIMD
 ADDD R6,R6       ;*8 for reals, *2 for word-size array
DIMD
 MOVD R6,-6(R2)   ;store length
 ADDD R6,@DPL     ;allocate space for array
 MOVD R2,R6       ;save addr. in R6
 BSR LOOK
 DB 1,')'
 BRR DIM3         ;error if no ')'
 MOVD @DPL,@PSTART ;update start-of-program pointer
 BSR LOOK
 DB 1,'='
 BRR DIMF
 ADDQD -6,R6      ;addr. of lenth
 JSR @STR21       ;compile a string assignment statement
 JSR @QRUN        ;execute it
DIMF
 RET 0

DIM3
 BR SYNERR

INDERRM
 DB 11,'Index Error'

 DB 6,'DEFDBL'
 DW BL-$
BL VAR $-9
DEFDBL           ;declare one or more double precision float variables
 BSR VARHEAD     ;compile a variable heading
 MOVD DBL1,R1    ;addr of generic executable code for flt variables
 JSR @SBCOMMA    ;compile a BSR to addr in R1
 ADDQD 1,R2      ;addr. of var space
 MOVZBD @REGDBL,R0 ;check availability of registers for reg. variables
 CMPQB 5,R0
 BLO1 DNONREG
 MOVB R0,-1(R2)  ;compile reg. addr mode byte into heading
 MOVD R0,R5      ;anticipate assignment statement
 MOVQD 0,R6      ;ditto
 ADDQB 2,R0      ;update reg. availability
 MOVB R0,@REGDBL
 BR1 DBL2
DNONREG
 ADDR @15H,R5    ;abs. addr. mode
 MOVD R2,R6      ;addr of var. (if abs mode)
 MOVB R5,-1(R2)  ;compile abs addressing mode byte into heading
 ADDQD 4,R2
 ADDQD 4,R2
DBL2
 MOVD R2,@DPL
 MOVD R2,@PSTART
 BSR LOOK
 DB 1,'='        ;check for assignment statement in definition
 BRR DBL3
 SBITB 16,R5     ;'real' flag
 JSR @DEFI20     ;compile assignment statement
 JSR @QRUN       ;execute assignment statement
DBL3
 BSR LOOK
 DB 81H,','
 BRR DEFDBL
 RET 0

 DB 6,'DEFINT'
 DW BL-$
BL VAR $-9
DEFINT           ;declare one or more integer variables
 BSR VARHEAD     ;compile a variable heading
 MOVD DEFI1,R1   ;addr of generic executable code for int variables
 JSR @SBCOMMA    ;compile a BSR to addr in R1
 ADDQD 1,R2      ;addr. of var space
 MOVZBD @REGBYTE,R0 ;check availability of registers for reg. variables
 CMPQB 5,R0
 BLO1 INONREG
 MOVB R0,-1(R2)  ;compile reg. addr mode byte into heading
 MOVD R0,R5      ;anticipate assignment statement
 MOVQD 0,R6      ;ditto
 ADDQB 1,R0      ;update reg. availability
 MOVB R0,@REGBYTE
 BR1 DEFIA
INONREG
 ADDR @15H,R5    ;abs. addr. mode
 MOVD R2,R6      ;addr of var. (if abs mode)
 MOVB R5,-1(R2)  ;compile abs addressing mode byte into heading
 ADDQD 4,R2
DEFIA
 MOVD R2,@DPL
 MOVD R2,@PSTART
 BSR LOOK
 DB 1,'='        ;check for assignment statement in definition
 BRR DEFIB
 JSR @DEFI20     ;compile assignment statement
 JSR @QRUN       ;execute assignment statement
DEFIB
 BSR LOOK
 DB 81H,','
 BRR DEFINT
 RET 0

PRINT            ;run-time routine to print an integer held in R6
 SAVE [R0,R1,R2,R3,R4,R5]
 MOVD TIBL+80H,R2
 MOVD R6,R3
 ABSD R3,R1
 MOVQD 0,R4
 JSR @PERI1
 RESTORE [R0,R1,R2,R3,R4,R5]
 RET 0

PRIN4            ;routine to compile a literal string handler & string
 ADDQD 1,R2
 SUBD R6,R2
 MOVD R2,@TO_INL
 MOVB R0,R6
 MOVQB 0,@WFLAG  ;0 makes scanner accept all printable chars
 JSR @PQU1
 MOVQB 1,@WFLAG  ;1 makes scanner look for BASIC identifiers
 RET 0

 DB 5,'PRINT'
 DW BL-$
BL VAR $-8
PRIN1
 BSR2 STRDEL     ;check for string delimiter
 BEQ1 PRIN3
 MOVQD 6,R5      ;make R6 the destination
 MOVQD 0,R6
 JSR @DEFI20     ;do an assignment statement
 MOVD PRINT,R1
 JSR @SBCOMMA    ;compile a BSR to run-time code to print R6 value
 BR1 PRIN2
PRIN3
 MOVD PQUOTE,R1  ;addr of literal handler to print a string
 BSR PRIN4       ;compile BSR to R1 & compile string
 BSR LOOK
 DB 81H,'+'      ;for strings, treat '+' same as ';'
 BRR PRIN1
PRIN2
 BSR LOOK
 DB 81H,';'      ;';' means print next item without space
 BRR PRIN1
 BSR LOOK
 DB 81H,','      ;',' means print space then next item
 BRR PRIN5
 RET 0
PRIN5
 MOVD SPACE,R1
 JSR @SBCOMMA
 BR PRIN1

STRDEL           ;check for string delimiter " ' ` ~ | ^
 BSR FIND1
STRD1
 MOVB 0(R2),R0
STRD2
 CMPB '"',R0
 BEQ1 STRD0
 CMPB 27H,R0
 BEQ1 STRD0
 CMPB 60H,R0
 BEQ1 STRD0
 CMPB '~',R0
 BEQ1 STRD0
 CMPB '|',R0
 BEQ1 STRD0
 CMPB '^',R0
STRD0
 RET 0

PQUOTE           ;run-time code to print a string that follows the call
 RESTORE [R6]    ;string address
 SAVE [R0,R1,R2,R4] ;protect register variables
 MOVD R6,R2
 JSR @STYPE      ;print the string
 MOVD R2,R6
 RESTORE [R0,R1,R2,R4]
 JUMP 1(R6)

SPACE            ;run-time code to print a space
 BSR PQUOTE
 DB 1,' '
 RET 0

 DB 7,'STRING$'
 DW BL-$
BL VAR $-10
 BSR LOOK
 DB 1,'('
 BRR ST$E
 MOVQD 0,*+ACCUM-$ ;make R0 the accum
 MOVQD 0,*+ACCUM+4-$
 BSR EXPRESS       ;get # of bytes into R0
 BSR LOOK
 DB 1,','          ;error if no ','
 BRR ST$E
 BSR LOOK
 DB 1,'"'
 BRR ST$1
 ADDQD -2,R7
 MOVB '"',0(R7)
 JSR @FINDWRD      ;find char after first '"'
 MOVB 0(R2),R6     ;get char into R6
 ADDQD 1,@TO_INL   ;advance test pointer
 MOVZBD 0D4H,R5    ;make source immed mode & byte length
 MOVZBD 0C6H,R3    ;make destination R6 & byte length
 JSR @XLOAD        ;compile code to move char into R6 at run time.
 BSR LOOK
 DB 1,'"'          ;error if no closing '"'
 BRR ST$E
 BR ST$2
ST$E
 BR SYNERR
ST$1
 ADDR @0C6H,*+ACCUM-$ ;make accum R6 & byte length
 MOVQD 0,*+ACCUM+4-$
 BSR EXPRESS       ;get the number into R6
ST$2
 BSR LOOK
 DB 1,')'          ;error if no ')'
 BRR ST$E
 MOVQD 6,*+ACCUM-$ ;put accum designators back to normal
 MOVQD 0,*+ACCUM+4-$
 MOVD FIL2,R1      ;addr of run-time code to fill a block at addr of R2 and
 JUMP @SBCOMMA     ;   length of R0 with bytes of R6


 DB 4,'THEN'
 DW BL-$
BL VAR $-7
 RET 0

 ALIGN 2           ;same as in prev. modules
LINK4B1 EQU BL-$   ;to link next module

 END
