 INCLUDE 4CON.ASM
 INCLUDE MACLIB.ASM
 LIST ON
 MACLIST OFF

;Third part of 432.ASM

;by Neil R. Koozer              08/21/85
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709

;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.


;  Nov 18, 1985          Nov 26, 1985      January 7, 1986
;  January 29, 1986

 EXTERNAL VAR1,STYPE,TYP1,SEMIT,PERIOD,SPACE,BASEL,SCRLF,DSTACK,ERR1,LESS
 EXTERNAL TESTIT,PERI1,STATEL,CONTEXL,TIBL,IOWORD,LINK433

 GLOBAL CLS,BLOCK,CURBUF,BUFBLK,VOC,LINK434,EDI0,EDTABL

 DB 4,'?DUP'
 DW LINK433-$      ;splice linked list to prev. module
LINK VAR $-7
 CMPQD 0,0(R7)
 BEQ1 QDUP1
 ADDQD -4,R7
 MOVD 4(R7),0(R7)
QDUP1
 RET 0

 DB 8,'FORTH-83'
 DW LINK-$
LINK VAR $-11
 MOVD FMSG,R2
 JUMP @STYPE

FMSG
 DB 74,13,10,'Same as FORTH-83 except all standard words use 32-bit signed '
 DB 'integers.',13,10

 DB 5,'CMOVE'
 DW LINK-$
LINK VAR $-8
 MOVD 0(R7),R0
 ADDQD 4,R7
 MOVD 0(R7),R2
 ADDQD 4,R7
 MOVD 0(R7),R1
 ADDQD 4,R7
 MOVSB
 RET 0

 DB 5,'COUNT'
 DW LINK-$
LINK VAR $-8
 MOVD 0(R7),R0
 MOVXBW 0(R0),-4(R7)
 ADDQD 1,R0
 MOVD R0,0(R7)
 ADDQD -4,R7
 RET 0

 DB 5,'DEPTH'
 DW LINK-$
LINK VAR $-8
 MOVD R7,R6
 SUBD DSTACK,R6
 PUSH              ;macro to push R6 onto data stack
 RET 0

 DB 6,'NEGATE'
 DW LINK-$
LINK VAR $-9
 NEGD 0(R7),0(R7)
 RET 0

 DB 3,'MAX'
 DW LINK-$
LINK VAR $-6
 POP               ;macro to pop R6 from data stack
 CMPD R6,0(R7)
 BLE1 MAX1
 MOVD R6,0(R7)
MAX1
 RET 0

 DB 3,'MIN'
 DW LINK-$
LINK VAR $-6
 POP               ;macro to pop R6 from data stack
 CMPD R6,0(R7)
 BGE1 MIN1
 MOVD R6,0(R7)
MIN1
 RET 0

 DB 6,'CMOVE>'
 DW LINK-$
LINK VAR $-9
 MOVD 0(R7),R0
 ADDQD 4,R7
 MOVD 0(R7),R2
 ADDQD 4,R7
 MOVD 0(R7),R1
 ADDQD 4,R7
 ADDD R0,R2
 ADDD R0,R1
 ADDQD -1,R2
 ADDQD -1,R1
 MOVSB B
 RET 0

 DB 3,'NOT'
 DW LINK-$
LINK VAR $-6
 COMD 0(R7),0(R7)
 RET 0

 DB 2,'OR'
 DW LINK-$
LINK VAR $-5
 ORD 0(R7),4(R7)
 ADDQD 4,R7
 RET 0

 DB 4,'PICK'
 DW LINK-$
LINK VAR $-7
 MOVD 0(R7),R0
 ADDQD 1,R0
 MOVD 0(R7)[R0:D],0(R7)
 RET 0

 DB 2,'R>'
 DW LINK-$
LINK VAR $-5
 RESTORE [R0]
 MOVD TOS,-4(R7)
 ADDQD -4,R7
 JUMP R0

 DB 6,'SPACES'
 DW LINK-$
LINK VAR $-9
 MOVD 0(R7),R2
 CMPQD 0,R2
 BEQ1 SPA2
SPA1
 JSR @SPACE
 ACBD -1,R2,SPA1
SPA2
 RET 0

 DB 4,'ROLL'
 DW LINK-$
LINK VAR $-7
 MOVD 0(R7),R0
 MOVD R0,R2
 ADDD R2,R2
 ADDD R2,R2
 ADDD R7,R2 ;addr of Nth element
 MOVD 0(R2),0(R7)
 MOVD R2,R1
 ADDQD -4,R1
 MOVSD B
 ADDQD 4,R7
 RET 0

 DB 4,'EXIT'
 DW LINK-$
LINK VAR $-7
EXIT
 ADJSPB -4
 RET 0

 DB 40H            ;null word (0 length)
 DW LINK-$
LINK VAR $-3
 ADJSPB -8         ;escape from interpret loop
 RET 0

 DB 86H,2,'D<'
 DW LINK-$
LINK VAR $-6
 JSR @LESS
 RET 0

 DB 88H,2,'D+'
 DW LINK-$
LINK VAR $-6
 POP
 ADDD R6,0(R7)
 RET 0

 DB 85H,7,'DNEGATE'
 DW LINK-$
LINK VAR $-11
 NEGD 0(R7),0(R7)
 RET 0

 DB 4,'FIND'
 DW LINK-$
LINK VAR $-7
 MOVD 0(R7),R5
 MOVD @CONTEXL,R0
 MOVD 0(R0),R2
 JSR @TESTIT
 ADDQD -2,R7
 CMPQB 0,2(R7)
 BEQ1 FIN1
 ADDQD -4,R7
 MOVQD 0,0(R7)
 MOVD R5,4(R7)
 RET 0
FIN1
 TBITB 6,@STATEL
 BFS1 FIN2
 MOVQD -1,0(R7)
 RET 0
FIN2
 MOVQD 1,0(R7)
 RET 0

 DB 2,'U.'
 DW LINK-$
LINK VAR $-5
 MOVD TIBL+80H,R2
 MOVQD 0,R3
 MOVQD 0,R4
 MOVD 0(R7),R1
 ADDQD 4,R7
 JUMP @PERI1

 DB 2,'U<'
 DW LINK-$
LINK VAR $-5
 POP
 CMPD R6,0(R7)
 MOVQD -1,R6
 BHI $+4
 MOVQD 0,R6
 MOVD R6,0(R7)
 RET 0

 DB 3,'UM*'
 DW LINK-$
LINK VAR $-6
 MOVD 0(R7),R0
 MEID 4(R7),R0
 ADDQD 4,R7
 MOVD R0,0(R7)
 RET 0

 DB 6,'UM/MOD'
 DW LINK-$
LINK VAR $-9
 MOVD 4(R7),R0
 MOVQD 0,R1
 DEID 0(R7),R0
 MOVD R0,4(R7)
 MOVD R1,0(R7)
 RET 0

 DB 5,'>BODY'
 DW LINK-$
LINK VAR $-8
 RET 0

;Here's some disk I/O stuff

BUFFMAC            ;this macro makes a table of buffer addresses
 MACRO ARG1
COUNT
 VAR ARG1
 IFZ COUNT-NBUFFS
 IFCLEAR
 MACEXIT
 ENDIF
 MACLIST ON
 DOUBLE BLOKBUF+COUNT*BUFLEN
 MACLIST OFF
 BUFFMAC COUNT+1
 ENDM

CURBUF DB 1        ;currently active buffer
BUFBLK BLKW NBUFFS ;table of block assigned to each buffer
BUFFLG BLKW NBUFFS ;table of update flags
BUFADD BUFFMAC 0   ;table of buffer addresses
DISKERR DB 10,'Disk Error'

DISKOP
 MOVD *+BUFADD-$-4[R0:D],4(R2) ;put buffer addr into IOPB
 MOVQB 2,1(R2)     ;put #-of-sectors-to-read into IOPB
 MOVQB 3,7(R2)     ;sector length (512 bytes) into IOPB
 MOVQD 2,10(R2)    ;2 means double density, side 0
 MOVW 0DFH,8(R2)   ;retry code & other stuff
 ADDW R4,R4        ;sector # (ref 2)
 ADDQW -2,R4       ;sector # (ref 0)
 MOVQW 0,R5        ;prepare for DEI
 DEIW 15,R4        ;R4 = sect. R5 = track
 ADDQW 1,R4        ;sector # in track (ref 1)
 MOVB R5,2(R2)     ;track # into IOPB
 MOVB R4,3(R2)     ;sector # into IOPB
 CMPB 0FH,R4       ;if we're at sector 15, do two separate reads
 BNE1 DIS4
 MOVQB 1,1(R2)
 BSR1 DIS4
 MOVD IOPB,R2
 MOVQB 1,3(R2)     ;sector #1
 ADDQB 1,2(R2)     ;next track
 ADDQW 2,5(R2)     ;add 512 to buffer addr pointer
DIS4
 MOVD FDC,R3
 MOVB R2,1(R3)     ;1st byte of FDC command
 LSHD -8,R2
 MOVB R2,2(R3)     ;2nd byte of FDC command
DIS1
 MOVB 1(R3),R4     ;get status byte
 ANDB 90H,R4
 CMPB 90H,R4
 BNE DIS1          ;wait till ready
 LSHD -8,R2
 MOVB R2,2(R3)     ;3rd byte of FDC command
DIS2
 MOVB 1(R3),R4     ;get status byte
 TBITB 7,R4        ;check busy bit
 BFS DIS2          ;wait till done
 MOVB 0(R3),R4     ;get error byte
 CMPQB 0,R4
 BEQ1 DIS3         ;0 means no error
 MOVD DISKERR,R2
 JUMP @ERR1
DIS3
 RET 0

WRITE1             ;write a buffer (R0) to disk
 MOVD IOPB,R2
 MOVB 9,0(R2)      ;put write cmd into IOPB
 MOVW *+BUFBLK-$-2[R0:W],R4 ;block #
 BSR DISKOP        ;write buffer (R0) to disk block (R4)
 MOVQB 0,*+BUFFLG-$-1[R0:W] ;clear 'update' flag
 RET 0

READ1              ;read a block from disk into a block buffer
 MOVD IOPB,R2
 MOVB 8,0(R2)      ;put read cmd into IOPB
 MOVW 0(R7),R4     ;block #
 BR DISKOP         ;read disk block (R4) into buffer (R0)

 DB 12,'SAVE-BUFFERS'
 DW LINK-$
LINK VAR $-15
SAVEBUF
 MOVZBD NBUFFS,R0
SAV2
 TBITB 15,@BUFFLG-2[R0:W] ;check 'update' flag
 BFC1 SAV1
 BSR WRITE1        ;write block to disk if data was changed
SAV1
 ACBB -1,R0,SAV2
 RET 0

 DB 5,'FLUSH'
 DW LINK-$
LINK VAR $-8
 BSR SAVEBUF       ;save buffers
FLU2
 MOVZBD NBUFFS,R0
FLU1               ;un-assign buffers
 MOVQW 0,@BUFFLG-2[R0:W]
 MOVQW 0,@BUFBLK-2[R0:W]
 ACBB -1,R0,FLU1
 RET 0

 DB 6,'UPDATE'
 DW LINK-$
LINK VAR $-9
UPDATE             ;mark a buffer as having changed data
 MOVZBD *+CURBUF-$,R0
 SBITB 15,*+BUFFLG-$-2[R0:W]
 RET 0

 DB 6,'BUFFER'
 DW LINK-$
LINK VAR $-9
 MOVQB 0,R6
 BR1 SBLOCK


 DB 5,'BLOCK'
 DW LINK-$
LINK VAR $-8
BLOCK
 MOVQB 1,R6
SBLOCK
 MOVW 0(R7),R4     ;block #
 MOVD BUFBLK+(NBUFFS-1)*2,R1 ;blk # table
 MOVZBD NBUFFS,R0
 SKPSW U,B         ;look for matching blk #
 MOVD BUFFLG,R1    ;addr of update flag table
 BFC1 CHOOSE
 CMPQB -2,-2(R1)[R0:W] ;see if buffer is already newest
 BEQ1 SBL6         ;skip the aging if it's the newest
SBL1
 SAVE [R5]
 MOVQB -1,-2(R1)[R0:W] ;make chosen buffer newest
 MOVZBD NBUFFS,R5
SBL4
 ADDQB -1,-2(R1)[R5:W]
 BCS1 SBL5
 MOVQB 0,-2(R1)[R5:W]
SBL5
 ACBB -1,R5,SBL4
 RESTORE [R5]
SBL6
 MOVB R0,*+CURBUF-$ ;store active-buffer #
 MOVW 0(R7),*+BUFBLK-$-2[R0:W] ;store block #
 MOVD *+BUFADD-$-4[R0:D],0(R7) ;return buffer addr
 RET 0

CHOOSE             ;choose the best buffer to use
 MOVQW -1,R3       ;initialize comparison value
 MOVZBD NBUFFS,R5
SBL3
 MOVW -2(R1)[R5:W],R2
 CMPW R2,R3
 BHS1 SBL2
 MOVW R2,R3        ;update flag
 MOVD R5,R0        ;buffer #
SBL2
 ACBB -1,R5,SBL3
 TBITB 15,R3       ;buffer dirty?
 BFC1 LOADBLK
 BSR WRITE1        ;write buffer to disk if data has been altered
LOADBLK
 CMPQB 0,R6        ;no read if 'BUFFER'
 BEQ SBL1
 BSR READ1         ;read the block into the chosen buffer
 BR SBL1

 DB 4,'WIPE'
 DW LINK-$
LINK VAR $-7
 MOVXBD *+CURBUF-$,R0
 MOVD *+BUFADD-$-4[R0:D],R1
 MOVD BUFLEN-2,R0
WIP1
 MOVD R1,R2
 ADDQD 2,R2
 LSHD -1,R0
 MOVW 2020H,0(R1)
 MOVSW
 RET 0

 DB 4,'COPY'       ;this isn't good enough yet
 DW LINK-$
LINK VAR $-7
 ADDQD 4,R7
 BSR BLOCK
 ADDQD 4,R7
 MOVXBD *+CURBUF-$,R0
 MOVW -8(R7),*+BUFBLK-$-2[R0:W]
 MOVQB -1,*+BUFFLG-$-1[R0:W] ;update flag
 RET 0

 DB 13,'EMPTY-BUFFERS'
 DW LINK-$
LINK VAR $-16
 BR FLU2

 DB 3,'XOR'
 DW LINK-$
LINK VAR $-6
 XORD 0(R7),4(R7)
 ADDQD 4,R7
 RET 0

 DB 5,'LLIST'
 DW LINK-$
LINK VAR $-8
 MOVW @IOWORD,TOS ;save IOWORD
 MOVQW 2,@IOWORD  ;re-route CRT to printer
 BSR1 LIST
 MOVW TOS,@IOWORD
 RET 0

 DB 4,'LIST'
 DW LINK-$
LINK VAR $-7
LIST
 JSR @SCRLF
LIS5
 MOVW 0(R7),*+SCRL-$
 BSR BLOCK
 MOVD 0(R7),R1     ;buffer addr returned by BLOCK
 ADDQD 4,R7
 MOVD EDBUF,R2     ;addr of edit buffer
 MOVD 100H,R0
 MOVSD             ;copy the block into edit buffer
LIS8
 MOVD EDBUF,R6
 MOVD LIS3,R5
 MOVB 10H,R3       ;# of lines to list
 MOVB '|',4(R5)    ;insert border character
 MOVB '|',6(R5)
LIS6
 MOVD BASEL,R2
 MOVB 0(R2),R0
 SAVE [R0,R2,R6]   ;save number base and edit buffer addr
 MOVB 0AH,0(R2)    ;make number base decimal
 ADDQD -1,R6
 MOVW 3020H,1(R5)  ;prime the line number
LIS1
 MOVD R5,R2
 JSR @STYPE        ;print line # & left border
 MOVD R6,R2
 MOVW 40H,R4
 JSR @TYP1         ;print 64 characters from buffer
 MOVD R2,R6        ;update buffer pointer
 MOVD LIS7,R2
 JSR @STYPE        ;print right border
 ADDQB 1,2(R5)     ;increment line number
 CMPB 3AH,2(R5)    ;check for carry
 BNE1 LIS2
 MOVW 3031H,1(R5)  ;repair carry
LIS2
 CMPQB 1,R3        ;see if it's the last line
 BEQ1 LIS4
 JSR @SCRLF        ;do carriage return except on last line
LIS4
 ACBB -1,R3,LIS1
 JSR @SPACE        ;print a space
 ADDQD -4,R7
 MOVXWD *+SCRL-$,0(R7)
 JSR @PERIOD       ;print the block # to right of last line
 RESTORE [R0,R2,R6] ;pop number base and edit buffer addr
 MOVB R0,0(R2)     ;restore previous number base
 RET 0
LIS3
 DB 4,' 0 |'
LIS7
 DB 21,'|          ',8,8,8,8,8,8,8,8,8,8

 DB 1,'L'
 DW LINK-$
LINK VAR $-4
L
 JSR @SCRLF
L__1                ;list contents of current buffer
 MOVXBD @CURBUF,R0
 MOVD BUFBLK,R1
 MOVW -2(R1)[R0:W],-4(R7)
 ADDQD -4,R7
 BR LIS5

EDTABL
 DOUBLE 0
 DB 4,1BH,'=  ',0
 DW 0

CLSMSG
 DB 2,1AH,1EH      ;2-byte message to clear screen
CLS                ;clear-screen routine
 MOVD CLSMSG,R2
 JSR @STYPE
 MOVD EDBUF,R1
 MOVD 5FEH,R0
 JUMP @WIP1        ;clear the edit buffer (also allows terminal time to clear)

CURSOR
 MOVQW 0,R5        ;ready for DEI
 DEIW 40H,R4
 ADDB 24H,R4       ;horizontal offset (20h for terminal + 4 for left border)
 ADDB 20H,R5       ;vertical offset (for terminal)
CUR1
 MOVB R5,7(R3)     ;put offsets into cursor-addressing string
 MOVB R4,8(R3)
 MOVD R3,R2
 ADDQD 4,R2
 JUMP @STYPE       ;send abs cursor-addressing string

BLIST              ;list the auxiliary edit buffer below main buffer
 MOVD EDTABL,R3
 MOVB 20H,R4
 MOVB 30H,R5
 BSR CUR1          ;position cursor at left edge of 16th line
 MOVD LIS3,R5
 MOVB '[',4(R5)    ;use different border characters
 MOVB ']',6(R5)
 MOVB 8,R3         ;# of lines to list
 SAVE [R6]
 ADDD 400H,R6      ;start addr of aux buffer
 BSR LIS6          ;list it out
 RESTORE [R6]
 RET 0


 DB 4,'EDIT'
 DW LINK-$
LINK VAR $-7
 MOVQW 0,@EDTABL   ;init cursor
EDI0
 MOVB 1EH,R0       ;home the cursor
 JSR @SEMIT
 BSR L__1          ;list main edit buffer
 BSR BLIST         ;list aux. edit buffer
EDI1
 BSR UPDATE        ;mark the current block as 'changed'
 MOVD EDTABL,R3
 MOVQB 0,9(R3)     ;flag for unfinished display updating
 MOVW 0(R3),2(R3)  ;cursor position for display updating

KBD
 MOVW 0(R3),R4
 BSR CURSOR        ;place cursor on CRT
KBD1
 MOVD USART,R0
 TBITB 1,2(R0)     ;see if there's a char ready
 BFS2 CHAR
 CMPQB 0,9(R3)     ;if no char ready, check for unfinished display updating
 BEQ KBD1
 MOVW 2(R3),R4
 BSR CURSOR
 MOVXWD 2(R3),R4
 CMPW R4,10(R3)    ;see if we've finished the area that needs printed
 BHS1 KBD3
 ADDD R6,R4        ;addr of char to print
 MOVB 0(R4),R0     ;get char
 JSR @SEMIT        ;print char
 MOVW 2(R3),R4
 ADDQW 1,R4        ;advance the print cursor
 MOVW R4,2(R3)
 CMPW 600H,R4      ;check for end of buffer
 BNE KBD
KBD3
 MOVW 0(R3),2(R3)  ;make print cursor the same as the edit cursor
 MOVQB 0,9(R3)     ;reset the 'printing needed' flag
 BR KBD

CHAR
 MOVZBD 0(R0),R0   ;get keyboard char
 CMPB R0,20H       ;see if control char
 BLO2 CONTROL
 CMPB R0,7EH       ;see if printable char
 BHI KBD
 MOVZWD 0(R3),R4   ;if we have a printable char, we insert it
 MOVW R4,2(R3)     ;set print cursor to equal the keyboard cursor
 MOVQB -1,9(R3)    ;set the 'printing needed' flag
 MOVD 600H,R5
 ADDQW 1,R4        ;advance kbd cursor unless it's at end of buffer
 CMPW R5,R4
 BLS1 CHA3
 MOVW R4,0(R3)
CHA3
 ADDD R6,R4        ;convert cursor to mem. addr.
 ADDD R6,R5        ;addr of end of buffer
CHA2
 MOVB -1(R4),R1    ;start the insert process
 CMPB R0,R1
 BNE1 CHA1
 CMPB 20H,R0       ;stop moving text if we hit two spaces in a row
 BNE1 CHA1
CHA4
 SUBD R6,R4
 MOVW R4,10(R3)    ;store cursor position where effect of the insert ends
 BR KBD
CHA1
 MOVB R0,-1(R4)
 MOVB R1,R0
 CMPD R5,R4        ;check for end of buffer
 BLS CHA4
 ADDQW 1,R4
 BR CHA2           ;continue the inserting process

CONTROL
 MOVD KBD,TOS      ;return addr
CTAB
 CASEW @CTABLE[R0:W] ;branch to selected routine

CTABLE
 DW KBD-CTAB
 DW CONT_A-CTAB
 DW KBD-CTAB
 DW CONT_C-CTAB
 DW CONT_D-CTAB
 DW CONT_E-CTAB
 DW CONT_F-CTAB
 DW CONT_G-CTAB
 DW CONT_H-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW CONT_L-CTAB
 DW CONT_M-CTAB
 DW CONT_N-CTAB
 DW KBD-CTAB
 DW CONT_P-CTAB
 DW CONT_Q-CTAB
 DW CONT_R-CTAB
 DW CONT_S-CTAB
 DW CONT_T-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW CONT_W-CTAB
 DW CONT_X-CTAB
 DW CONT_Y-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW KBD-CTAB
 DW KBD-CTAB


CONT_S
 MOVQW -1,R4
CONS1
 ADDW 0(R3),R4
 MOVW 600H,R0
 CMPW R4,R0
 BLT1 CONS3
 SUBW R0,R4
CONS3
 CMPQW 0,R4
 BLE1 CONS2
 ADDW R0,R4
CONS2
 MOVW R4,0(R3)
 RET 0

CONT_D
 MOVQW 1,R4
 BR CONS1

CONT_E
 MOVW -40H,R4
 BR CONS1

CONT_X
 MOVW 40H,R4
 BR CONS1

CONT_A
 MOVQW -1,R1
CONA3
 MOVZWD 0(R3),R4
CONA1
 ADDW R1,R4
 CMPW 600H,R4
 BHI1 CONA4
 MOVQW 0,R4
CONA4
 CMPQW 0,R4
 BEQ1 CONA2
 MOVD R4,R5
 ADDD R6,R5
 CMPB 20H,0(R5)
 BEQ CONA1
 CMPB 20H,-1(R5)
 BNE CONA1
CONA2
 MOVW R4,0(R3)
 RET 0

CONT_F
 MOVQW 1,R1
 BR CONA3

CONT_G
 MOVZWD 0(R3),R4
CONG3
 MOVQB -1,9(R3)
 MOVW R4,2(R3)
 MOVD 600H,R5
 ADDD R6,R5
 ADDD R6,R4
CONG2
 MOVB 1(R4),R1
 CMPB 20H,R1
 BNE1 CONG1
 CMPB 20H,0(R4)
 BNE1 CONG1
CONG4
 SUBD R6,R4
 MOVW R4,10(R3)
 RET 0
CONG1
 MOVB R1,0(R4)
 ADDQD 1,R4
 CMPD R4,R5
 BNE CONG2
 MOVB 20H,-1(R4)
 BR CONG4

CONY1
 MOVZWD 0(R3),R1
 ANDB 0C0H,R1
 MOVW R1,0(R3)
 MOVW R1,2(R3)
 MOVQB 0,9(R3)
 MOVZWD 5C0H,R0
 SUBD R1,R0
 LSHD -2,R0
 RET 0

CONT_Y
 BSR CONY1
 ADDD R6,R1
 MOVD R1,R2
 ADDD 40H,R1
 MOVSD
 MOVD R2,R1
 BR1 CONN2

CONT_N
 BSR CONY1
 MOVZWD 5FCH,R1
 ADDD R6,R1
 MOVD R1,R2
 SUBD 40H,R1
 MOVSD B
 ADDQD 4,R1
CONN2
 MOVZBD 3EH,R0
CONN1
 BSR WIP1
 BR2 CONT_P

CONT_W
 MOVD R6,R1
 MOVD 3FEH,R0
 BR CONN1

CONT_H
 MOVZWD 0(R3),R4
 CMPW 0,R4
 BEQ2 RET0
 ADDQD -1,R4
 MOVW R4,0(R3)
 BR CONG3

CONT_T
 MOVZWD 0(R3),R1
 MOVD R6,R5
 ADDD 600H,R5
 ADDD R6,R1
 MOVD R1,R2
CONT2
 CMPD R6,R1
 BEQ1 CONT1
 CMPB 20H,-1(R1)
 BEQ1 CONT1
 CMPB 20H, 0(R1)
 BEQ1 CONT1
 ADDQD -1,R1
 BR CONT2
CONT1
 CMPD R5,R2
 BEQ1 CONT5
 ADDQD 1,R2
 CMPB 20H,0(R2)
 BEQ CONT1
 CMPB 20H,-1(R2)
 BNE CONT1
 CMPD R1,R2
 BEQ1 RETT
CONT5
 MOVD R1,R4
 SUBD R6,R4
 MOVW R4,0(R3)
 MOVW R4,2(R3)
CONT3
 CMPD R2,R5
 BHS1 CONT6
 MOVB 0(R2),0(R1)
 ADDQD 1,R1
 ADDQD 1,R2
 CMPW 2020H,-2(R1)
 BNE CONT3
CONT6
 MOVD R2,R4
 SUBD R6,R4
 MOVW R4,10(R3)
 SUBD R1,R2
CONT4
 MOVB 20H,0(R1)
 ADDQD 1,R1
 ACBD -1,R2,CONT4
 SUBW 0(R3),R4
 CMPW R4,40H
 BHI1 CONT_P
 MOVQB -1,9(R3)
RETT
 RET 0

CONT_Q
 ADJSPB -4
 MOVB 67H,R4
 MOVB 37H,R5
 BSR CUR1
CONQ1
 MOVXBD @CURBUF,R0
 MOVD BUFADD,R1
 MOVD -4(R1)[R0:D],R2
 MOVD R6,R1
 MOVD 100H,R0
 MOVSD
 RET 0

CONT_P
 MOVQB 0,9(R3)
 MOVW 0(R3),R4
 SAVE [R3,R4]
 MOVB 1EH,R0
 JSR @SEMIT
 BSR LIS8
 BSR BLIST
 RESTORE [R3,R4]
 MOVW R4,0(R3)
 MOVW R4,2(R3)
RET0
 RET 0

CONT_R
 MOVQW -1,R0
CONR1
 ADDW *+SCRL-$,R0
 CMPW 576,R0
 BLO RET0
 ADDQD -4,R7
 MOVW R0,0(R7)
 MOVB 1EH,R0
 JSR @SEMIT
 BSR CONQ1
 BSR LIS5
 ADJSPB -4
 BR EDI1

CONT_C
 MOVQW 1,R0
 BR CONR1

CONT_L
 ANDB 0C0H,0(R3)
 RET 0

CONT_M
 BSR CONT_L
 BR CONT_X

 DB 3,'SCR'
 DW LINK-$
LINK VAR $-6
 JSR @VAR1+2
SCRL
 DOUBLE 0

 ALIGN 2        ;this makes the end come out even so the &%!!* assembler
                ;won't add a surprise byte at the end and ruin the linked list
VOC EQU LINK
LINK434 EQU LINK-$

 END
