 INCLUDE 4CON.ASM
 INCLUDE MACLIB.ASM
 LIST ON
 MACLIST OFF
;           432  --  FORTH-83 for 32000 processor
;                (this is the second module)

;by Neil R. Koozer  --  November 13,1984      July 7, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709

;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.

;   August 21, 1985     Sept 14, 1985         Nov 18, 1985
;   Nov 23, 1985        January 8, 1986       January 30, 1986

 EXTERNAL TYP2,ASPACE,DICT,COMMA,ABORT,QUIT,BVOC,VOC,SEARCH,ERROR,WFLAG
 EXTERNAL SBCOMMA,RELHERE,SBC2,NUMLIT,INTERP,SEMIT,WORD,NUML2,BCOMMA
 EXTERNAL STYPE,ABQUOTE,REGBYTE,PSTART,LINK432,STA1,INEXPR

 GLOBAL SPACE,VAR1,MODEL,TO_INL,BLKL,PERIOD,BASEL,DPL,VOC1,IMMED,HEADER
 GLOBAL PQUOTE,EMPTY,LOAD,HERE,BACK,UNT1,REPEAT,CONTEXL,CURRENTL,PERI1
 GLOBAL TIBL,FIL2,STATEL,MACROL,XTIBL,SPANL,TIC,LESS,PQU1,BASICL,LINK433
 GLOBAL BNEW

 DB 1,'*'
 DW LINK432-$      ;this splices the linked list
LINK VAR $-4
MULT
 MULD 0(R7),4(R7)
 ADDQD 4,R7
 RET 0

 DB 1,'/'
 DW LINK-$
LINK VAR $-4
DIVIDE
 QUOD 0(R7),4(R7)
 ADDQD 4,R7
 RET 0

 DB 4,'/MOD'
 DW LINK-$
LINK VAR $-7
DIVMOD
 MOVD 4(R7),R0
 REMD 0(R7),4(R7)
 QUOD 0(R7),R0
 MOVD R0,0(R7)
 RET 0

SMULTDIV
 MOVD 8(R7),R0
 MOVD 4(R7),R2
 MOVQD 0,R1
 XORD R0,R1
 XORD R2,R1
 ABSD R0,R0
 ABSD R2,R2
 MEID R0,R2
 MOVD 0(R7),R0
 MOVD R1,R4      ;remember sign of product
 XORD R0,R1
 ABSD R0,R0
 DEID R0,R2      ;R3 = QUO, R2 = REM
 TBITB 31,R1     ;sign of result
 BFC1 MUL1
 NEGD R3,R3
MUL1
 ADDQD 4,R7
 RET 0

 DB 2,'*/'
 DW LINK-$
LINK VAR $-5
MULTDIV
 BSR SMULTDIV
 ADDQD 4,R7
 MOVD R3,0(R7)
 RET 0

 DB 5,'*/MOD'
 DW LINK-$
LINK VAR $-8
MULTMOD
 BSR SMULTDIV
 MOVD R3,0(R7)
 TBITB 31,R4     ;sign of remainder
 BFC1 MUL2
 NEGD R2,4(R7)
 RET 0
MUL2
 MOVD R2,4(R7)
 RET 0

 DB 1,'#'
 DW LINK-$
LINK VAR $-4
XNUMBER
 MOVZBD *+BASEL-$,R5  ;get radix
 MOVD R1,R0      ;previous quo = new dividend
 MOVQD 0,R1
 DEID R5,R0      ;quo = r1, rem = r0
 ADDB 30H,R0
 CMPB 3AH,R0
 BHI1 X2
 ADDQB 7,R0
X2
 ADDQD -1,R2
 ADDQD 1,R4
 MOVB R0,0(R2)
 RET 0

 DB 2,'#S'
 DW LINK-$
LINK VAR $-5
XS
 BSR XNUMBER
 CMPQD 0,R1
 BNE XS
 RET 0

 DB 2,'<#'
 DW LINK-$
LINK VAR $-5
LX
 MOVD TIBL+80H,R2
 MOVD 0(R7),R3
 ADDQD 4,R7
 ABSD R3,R1
 MOVQB 0,R4
 RET 0

 DB 2,'#>'
 DW LINK-$
LINK VAR $-5
XR
 JUMP @TYP2

 DB 4,'SIGN'
 DW LINK-$
LINK VAR $-7
SIGN
 TBITB 31,R3
 BFC1 SIG1
 ADDQD -1,R2
 ADDQD 1,R4
 MOVB '-',0(R2)
SIG1
 RET 0

 DB 4,'HOLD'
 DW LINK-$
LINK VAR $-7
HOLD
 ADDQD -1,R2
 ADDQD 1,R4
 MOVB 0(R7),0(R2)
 ADDQD 4,R7
 RET 0

 DB 5,'SPACE'
 DW LINK-$
LINK VAR $-8
SPACE
 MOVB 20H,R0
 JUMP @SEMIT

 DB 1,'.'
 DW LINK-$
LINK VAR $-4
PERIOD
 BSR LX
 BSR1 PERI1
 BR SPACE

PERI1
 BSR XS
 BSR SIGN
 BR XR

 DB 8BH
 DB 1,'!'
 DW LINK-$
LINK VAR $-5
Y
 POP
 ADDQD 4,R7
 MOVD -4(R7),0(R6)
 RET 0

 DB 8BH
 DB 2,'C!'
 DW LINK-$
LINK VAR $-6
CY
 POP
 ADDQD 4,R7
 MOVB -4(R7),0(R6)
 RET 0

 DB 8BH
 DB 2,'+!'
 DW LINK-$
LINK VAR $-6
PLUSY
 POP
 ADDQD 4,R7
 ADDD -4(R7),0(R6)
 RET 0

 DB 95H
 DB 1,'<'
 DW LINK-$
LINK VAR $-5
LESS
 POP
 ADDQD 4,R7
 CMPD R6,-4(R7)
 MOVQD -1,R6
 BGT $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 95H
 DB 1,'>'
 DW LINK-$
LINK VAR $-5
 POP
 ADDQD 4,R7
 CMPD R6,-4(R7)
 MOVQD -1,R6
 BLT $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 95H
 DB 1,'='
 DW LINK-$
LINK VAR $-5
 POP
 ADDQD 4,R7
 CMPD R6,-4(R7)
 MOVQD -1,R6
 BEQ $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 3,'MOD'
 DW LINK-$
LINK VAR $-6
MOD
 REMD 0(R7),4(R7)
 ADDQD 4,R7
 RET 0

 DB 2,'C.'
 DW LINK-$
LINK VAR $-5
CPERIOD
 MOVXWD 0(R7),-2(R7)
 ADDQD -2,R7
 BR PERIOD

HEADER
 JSR @ASPACE
 JSR @WORD
 MOVD *+CURRENTL-$,R0
 MOVD 0(R0),R3   ;R3 = last header addr.
 MOVD *+DPL-$,R1 ;r1 = dict. pointer
 MOVD R1,0(R0)   ;make the token the new heading
 MOVXBD 0(R1),R0 ;token length
 ADDQD 1,R0      ;include the length-byte in the length
 ADDD R0,R1      ;r1 = addr of link word
 SUBD R1,R3      ;r3 = link offset
 CMPD R3,-8000H
 BGE1 HEA1
 MOVQW 0,0(R1)
 MOVD R3,2(R1)
 ADDQD 6,R1
 BR1 HEA2
HEA1
 MOVW R3,0(R1)   ;store link word
 ADDQD 2,R1      ;update dict. pointer
HEA2
 MOVD R1,*+DPL-$
 RET 0

 DB 7,'<BUILDS'
 DW LINK-$
LINK VAR $-10
BUILDS
 BSR HEADER
 MOVD 0(SP),R3
 MOVD SDOES,R4
 ADDQD -1,R3
BUI1
 ADDQD 1,R3
 MOVD R3,R1
 MOVD R4,R2
 MOVQD 7,R0
 CMPSB           ;search for 'DOES' code
 BNE BUI1
 MOVD R3,R1
 ADDQD 2,R1
 JUMP @SBCOMMA

 DB 6,'CREATE'
 DW LINK-$
LINK VAR $-9
CREATE
 BSR BUILDS
 DOES
 RET 0

 DB 8,'VARIABLE'
 DW LINK-$
LINK VAR $-11
 BSR BUILDS
 BSR2 IMMED
 ADDQD 4,*+DPL-$
VAR1
 DOES
VAR2
 CMPQB 0,@MODEL
 BEQ VAR1
 ADDQD 4,R7
 MOVD -4(R7),R3
 JUMP @NUML2

 DB 7,'CURRENT'
 DW LINK-$
LINK VAR $-10
CURRENT
 BSR VAR1+2
CURRENTL
 DOUBLE FORTHL

 DB 7,'CONTEXT'
 DW LINK-$
LINK VAR $-10
CONTEXT
 BSR VAR1+2
CONTEXL
 DOUBLE FORTHL

 DB 3,'>IN'
 DW LINK-$
LINK VAR $-6
 BSR VAR1+2
TO_INL
 DOUBLE 0

 DB 2,'DP'
 DW LINK-$
LINK VAR $-5
 BSR VAR1+2
DPL
 DOUBLE DICT

 DB 4,'BASE'
 DW LINK-$
LINK VAR $-7
 BSR VAR1+2
BASEL
 DB 0

 DB 5,'STATE'
 DW LINK-$
LINK VAR $-8
 BSR VAR1+2
STATEL
 DB 0

 DB 4,'MODE'
 DW LINK-$
LINK VAR $-7
 BSR VAR1+2
MODEL
 DB 0

 DB 4,'SPAN'
 DW LINK-$
LINK VAR $-7
 BSR VAR1+2
SPANL
 DOUBLE 0

 DB 3,'BLK'
 DW LINK-$
LINK VAR $-6
 BSR VAR1+2
BLKL
 DOUBLE 0

 DB 4,'#TIB'
 DW LINK-$
LINK VAR $-7
 BSR VAR1+2
XTIBL
 DOUBLE 0

 DB 3,'TIB'
 DW LINK-$
LINK VAR $-6
 BSR VAR1+2
TIBL
 BLKB KBUFLEN      :keyboard buffer

MACROL
 DB 0

 DB 1,':'
 DW LINK-$
LINK VAR $-4
 MOVD *+CURRENTL-$,*+CONTEXL-$
 BSR HEADER
 MOVQB 1,@MODEL
 RET 0

 DB 87H,5,'DOES>'
 DW LINK-$
LINK VAR $-9
SDOES
 DOES

 DB 8DH
 DB 1,'@'
 DW LINK-$
LINK VAR $-5
AT
 POP
 MOVD 0(R6),R6
 PUSH
 RET 0

 DB 8,'CONSTANT'
 DW LINK-$
LINK VAR $-11
 BSR BUILDS
 BSR2 IMMED
 JSR @COMMA
CON1
 DOES
 BSR AT
 BR VAR2

 DB 41H,';'
 DW LINK-$
LINK VAR $-4
 MOVD *+DPL-$,R0
 MOVXBW 12H,0(R0)
 ADDQD 2,R0
 MOVD R0,*+DPL-$
 MOVQB 0,@MODEL
 RET 0

 DB 86H
 DB 3,'DUP'
 DW LINK-$
LINK VAR $-7
DUP
 MOVD 0(R7),-4(R7)
 ADDQD -4,R7
 RET 0

 DB 5,'ENTRY'
 DW LINK-$
LINK VAR $-8
ENTRY
 BSR CURRENT
 BSR AT
 BR AT

 DB 4,'HERE'
 DW LINK-$
LINK VAR $-7
HERE
 ADDQD -4,R7
 MOVD *+DPL-$,0(R7)
 RET 0

 DB 92H
 DB 2,'0<'
 DW LINK-$
LINK VAR $-6
 POP
 CMPQD 0,R6
 MOVQD -1,R6
 BGT $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 92H
 DB 2,'0='
 DW LINK-$
LINK VAR $-6
 POP
 CMPQD 0,R6
 MOVQD -1,R6
 BEQ $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 92H
 DB 2,'0>'
 DW LINK-$
LINK VAR $-6
 POP
 CMPQD 0,R6
 MOVQD -1,R6
 BLT $+4
 MOVQD 0,R6
 PUSH
 RET 0

 DB 8CH
 DB 2,'1+'
 DW LINK-$
LINK VAR $-6
 POP
 ADDQD 1,R6
 PUSH
 RET 0

 DB 83H,2,'1-'
 DW LINK-$
LINK VAR $-6
 ADDQD -1,0(R7)
 RET 0

 DB 83H,2,'2+'
 DW LINK-$
LINK VAR $-6
 ADDQD 2,0(R7)
 RET 0

 DB 83H,2,'2-'
 DW LINK-$
LINK VAR $-6
 ADDQD -2,0(R7)
 RET 0

 DB 1,'?'
 DW LINK-$
LINK VAR $-4
 BSR AT
 BR PERIOD

 DB 85H,2,'>R'
 DW LINK-$
LINK VAR $-6
RR
 MOVD 0(R7),TOS
 ADDQD 4,R7
 RESTORE [R0,R1]
 SAVE [R1]
 JUMP R0

 DB 83H,5,'ABORT'
 DW LINK-$
LINK VAR $-9
 JUMP @ABORT

 DB 83H,4,'QUIT'
 DW LINK-$
LINK VAR $-8
 JUMP @QUIT

 DB 5,'ALLOT'
 DW LINK-$
LINK VAR $-8
ALLOT
 ADDD 0(R7),*+DPL-$
 ADDQD 4,R7
 RET 0

 DB 88H
 DB 3,'AND'
 DW LINK-$
LINK VAR $-7
 POP
 ANDD R6,0(R7)
 RET 0

 DB 8DH
 DB 2,'C@'
 DW LINK-$
LINK VAR $-6
 POP
 MOVB 0(R6),R6
 PUSH
 RET 0

 DB 7,'DECIMAL'
 DW LINK-$
LINK VAR $-10
 MOVB 10,*+BASEL-$
 RET 0

 DB 3,'HEX'
 DW LINK-$
LINK VAR $-6
HEX
 MOVB 16,*+BASEL-$
 RET 0

 DB 2,'H.'
 DW LINK-$
LINK VAR $-5
PHEX
 MOVB *+BASEL-$,TOS
 BSR HEX
 BSR PERIOD
 MOVB TOS,*+BASEL-$
 RET 0

 DB 82H,4,'DROP'
 DW LINK-$
LINK VAR $-8
DROP
 ADDQD 4,R7
 RET 0

 DB 11,'DEFINITIONS'
 DW LINK-$
LINK VAR $-14
 MOVD *+CONTEXL-$,*+CURRENTL-$
 RET 0

 DB 10,'VOCABULARY'
 DW LINK-$
LINK VAR $-13
 BSR BUILDS
 BSR ENTRY
 JSR @COMMA
VOC1
 DOES
 BSR CONTEXT
 BR Y

FORTHDPL DOUBLE DICT ;this stuff has to do with maintaining pointers when
FORTHVOC DOUBLE VOC  ;   switching between FORTH and BASIC
BASDPL DOUBLE DICT
BASICL DOUBLE BVOC
BASVOC DOUBLE BVOC
RGB DW 0

 DB 5,'EMPTY'
 DW LINK-$
LINK VAR $-8
EMPTY
 MOVD DICT,R0
 MOVD R0,*+DPL-$
 MOVD R0,*+FORTHDPL-$
 MOVD R0,*+BASDPL-$
 MOVD R0,@PSTART
 MOVD VOC,R0
 MOVD R0,*+FORTHL-$
 MOVD R0,*+FORTHVOC-$
 MOVD BVOC,R0
 MOVD R0,*+BASICL-$
 MOVD R0,*+BASVOC-$
 MOVQW 0,*+RGB-$
 MOVQW 0,@REGBYTE
 RET 0

 DB 5,'FORTH'
 DW LINK-$
LINK VAR $-8
 CBITB 0,@WFLAG
 BFC1 FORT1                 ;already in FORTH ?
 MOVD *+DPL-$,*+FORTHDPL-$  ;protect BASIC dict.
 MOVD *+BASICL-$,*+BASVOC-$ ;protect BASIC voc.
 MOVW @REGBYTE,*+RGB-$      ;save reg. variable counters
FORT1
 BSR VOC1+2
FORTHL
 DOUBLE VOC

 DB 5,'BASIC'
 DW LINK-$
LINK VAR $-8
BASIC
 SBITB 0,@WFLAG
 BFS1 BAS1                    ;see if already in BASIC
 MOVD *+DPL-$,*+BASDPL-$      ;protect FORTH dict.
 MOVD *+FORTHL-$,*+FORTHVOC-$ ;protect FORTH voc.
BAS1
 MOVB 0AH,*+BASEL-$
 MOVD BASICL,R0
 MOVQB 0,@INEXPR
NEW1
 MOVD R0,*+CONTEXL-$
 MOVD R0,*+CURRENTL-$
 RET 0

 DB 3,'NEW'
 DW LINK-$
LINK VAR $-6
 TBITB 0,@WFLAG  ;1 means BASIC
 BFS1 BNEW
 MOVD *+FORTHDPL,*+DPL-$
 MOVD FORTHL,R0
 MOVD *+FORTHVOC-$,0(R0)
 BR NEW1
BNEW
 MOVW *+RGB-$,@REGBYTE
 MOVD *+BASDPL-$,R2
 MOVD R2,*+DPL-$
 MOVD R2,@PSTART
 MOVD *+BASVOC-$,*+BASICL-$
 BSR BAS1
 MOVD OK,R2
 JUMP @STA1

OK DB 3,' OK'

 DB 9,'IMMEDIATE'
 DW LINK-$
LINK VAR $-12
IMMED
 MOVD *+CURRENTL-$,R0
 MOVD 0(R0),R0
 SBITB 6,0(R0)
 RET 0

 DB 1,27H          ;TIC
 DW LINK-$
LINK VAR $-4
TIC
 JSR @ASPACE
 JSR @WORD
 BSR CONTEXT
 BSR AT
 BSR AT
 JSR @SEARCH
 ADDQD 2,R7
 CMPQB 0,-2(R7)
 BEQ1 TIC1
 BSR ENTRY
 JSR @SEARCH
 ADDQD 2,R7
 CMPQB 0,-2(R7)
 BEQ1 TIC1
 JUMP @ERROR
TIC1
 RET 0

 DB 6,'FORGET'
 DW LINK-$
LINK VAR $-9
 BSR TIC
 MOVD 0(R7),R0   ;code addr
 ADDQD 4,R7
 ADDQD -2,R0     ;link addr
 MOVXWD 0(R0),R1 ;link
 ADDD R0,R1      ;prev. header addr
 MOVD *+CURRENTL-$,R2
 MOVD R1,0(R2)
 ADDQD -1,R3     ;addr of heading being forgotten
 MOVD R3,*+DPL-$
 RET 0

ADO              ;this macro is compiled by DO
 POP
 ADDQD 4,R7
 MOVW -4(R7),TOS
 MOVW R6,TOS
 MOVD 0,TOS      ;the 0 will be replaced by the exit address in case
                 ;there's a LEAVE within the loop

 DB 42H,'DO'
 DW LINK-$
LINK VAR $-5
 MOVB 92H,@MACROL
 MOVD ADO,R1
 JSR @SBCOMMA
 BR HERE         ;remember this addr so we can fill in the exit addr later

ALOOP            ;this macro is compiled by LOOP to perform the conditional
 MOVQW 1,R6      ;   jump back to the start of the loop
 ADDW 4(SP),R6
 CMPW R6,6(SP)
 MOVW R6,4(SP)
 BLO $           ;the argument will be filled in by LOOP code

ALO1
 ADJSPB -8

 DB 44H,'LOOP'
 DW LINK-$
LINK VAR $-7
 MOVD ALOOP,R1
 MOVB 8CH,@MACROL
LOO1
 JSR @SBCOMMA
 MOVQD 1,R1      ;compute displacement for the compiled BLO instruction
 ADDD 0(R7),R1
 SUBD *+DPL-$,R1
 JSR @RELHERE    ;compile the displacement
 MOVD ALO1,R1
 MOVB 83H,@MACROL
 JSR @SBCOMMA    ;compile the 'ADJSPB -8'
 MOVD 0(R7),R1   ;retrieve addr of start of loop
 ADDQD 4,R7
 ROTW 8,R2       ;R2 has addr of location just past the 'ADJSPB -8'
 ROTD 16,R2      ;reverse order for immediate mode
 ROTW 8,R2
 MOVD R2,-4(R1)  ;put into the instruction 'MOVD 0,TOS' at start of loop
 RET 0

AIF
 POP
 CMPQB 0,R6
 BEQ $             ;argument to be filled in later

 DB 42H,'IF'
 DW LINK-$
LINK VAR $-5
IF
 MOVD AIF,R1
 MOVB 8AH,@MACROL
 JSR @SBCOMMA      ;compile AIF macro
AREP
 BR HERE           ;remember this address so we can fill in the BEQ instr.

APLOOP
 POP
 ADDW 4(SP),R6
 CMPW R6,6(SP)
 MOVW R6,4(SP)
 BLO $

 DB 45H,'+LOOP'
 DW LINK-$
LINK VAR $-8
 MOVD APLOOP,R1
 MOVB 8EH,@MACROL
 JSR @SBCOMMA
 MOVQD 2,R1
 BR LOO1

 DB 4,'SWAP'
 DW LINK-$
LINK VAR $-7
SWAP
 MOVD 0(R7),R0
 MOVD 4(R7),0(R7)
 MOVD R0,4(R7)
 RET 0

 DB 44H,'THEN'
 DW LINK-$
LINK VAR $-7
 MOVD ANOP,R1      ;compile a NOP to prevent the possibility of a push-pop
 MOVB 81H,@MACROL  ;sequence, which would be automatically erased, but half of
 JSR @SBCOMMA      ;it would be in the conditional portion of the construct.
 BSR2 BACK         ;Fill in the forward reference in the IF or ELSE part
 ADDQD 4,R7
 RET 0

 DB 44H,'ELSE'
 DW LINK-$
LINK VAR $-7
 MOVD AREP,R1
 MOVB 83H,@MACROL
 JSR @SBCOMMA      ;compile a 'BR' instruction
 BSR2 BACK         ;Fill in the forward reference in the IF part
 MOVD *+DPL-$,0(R7) ;remember this addr so we can fill in the arg. of the 'BR'
 RET 0

 DB 45H,'BEGIN'
 DW LINK-$
LINK VAR $-8
 MOVD ANOP,R1      ;similar to the problem in 'THEN'
 MOVB 81H,@MACROL
 JSR @SBCOMMA
 BR HERE

 DB 45H,'UNTIL'
 DW LINK-$
LINK VAR $-8
 MOVD AIF,R1       ;macro to do test & conditional branch
 MOVB 88H,@MACROL
 JSR @SBCOMMA      ;compile the macro
UNT1
 MOVQD 1,R1
 ADDD 0(R7),R1
 ADDQD 4,R7
 SUBD *+DPL-$,R1
 JUMP @RELHERE     ;compile the disp for the conditional branch

BACK               ;fill in arg. of a previous forward reference (2-byte disp)
 MOVD *+DPL-$,R1
 MOVD 0(R7),R2
BAC1
 ADDQD -3,R2
 SUBD R2,R1
 ADDQD 1,R2
 JUMP @SBC2

 DB 46H,'REPEAT'
 DW LINK-$
LINK VAR $-9
REPEAT
 MOVD AREP,R1
 MOVB 81H,@MACROL
 JSR @SBCOMMA      ;compile a 'BR' opcode
 MOVQD 1,R1
 ADDD 4(R7),R1
 SUBD *+DPL-$,R1
 JSR @RELHERE      ;compile a disp to branch back to beginning of loop
 BSR BACK          ;fill in the forward ref. in the WHILE
 ADDQD 4,R7
 ADDQD 4,R7
 RET 0

 DB 45H,'WHILE'
 DW LINK-$
LINK VAR $-8
 BR IF

ALEAVE
 RET 4

 DB 45H,'LEAVE'
 DW LINK-$
LINK VAR $-8
LEAVE
 MOVB 82H,@MACROL
 MOVD ALEAVE,R1
 JUMP @SBCOMMA     ;compile LEAVE code (simply a RET 4)

 DB 1,']'
 DW LINK-$
LINK VAR $-4
 MOVQB 1,*+MODEL-$
 RET 0

 DB 41H,'['
 DW LINK-$
LINK VAR $-4
 MOVQB 0,*+MODEL-$
 RET 0

COMX
 RESTORE [R0]
 MOVD 0(R0),R1
 ADDQD 4,R0
 SAVE [R0]
 JUMP @SBCOMMA

 DB 47H,'COMPILE'
 DW LINK-$
LINK VAR $-10
 BSR TIC
 MOVD COMX,R1
 JSR @SBCOMMA
 JSR @COMMA

 DB 49H,'[COMPILE]'
 DW LINK-$
LINK VAR $-12
 BSR TIC
 MOVQB 0,*+STATEL-$
 JUMP @BCOMMA

 DB 47H,'LITERAL'
 DW LINK-$
LINK VAR $-10
 JUMP @NUMLIT

 DB 89H
 DB 1,'I'
 DW LINK-$
LINK VAR $-5
 MOVXWD 4(SP),R6
 PUSH
 RET 0

 DB 89H
 DB 1,'J'
 DW LINK-$
LINK VAR $-5
 MOVXWD 12(SP),R6
 PUSH
 RET 0

 DB 89H
 DB 1,'K'
 DW LINK-$
LINK VAR $-5
 MOVXWD 20(SP),R6
 PUSH
 RET 0

 DB 88H
 DB 4,'OVER'
 DW LINK-$
LINK VAR $-8
 MOVD 4(R7),R6
 PUSH
FIL1
 RET 0

 DB 4,'FILL'       ;the fill routine has some extra junk to enable it to use
 DW LINK-$         ;   a MOVSD for most of the filling
LINK VAR $-7
 MOVB 0(R7),R6
 MOVD 4(R7),R0
 MOVD 8(R7),R2
 ADDQD 6,R7
 ADDQD 6,R7
FIL2
 CMPQD 0,R0
 BEQ FIL1
 MOVB R6,0(R2)
 MOVD R2,R1
 ADDQD 1,R2
 ADDQD -1,R0
 CMPQD 7,R0
 BLO1 LONG
 MOVSB
 RET 0
LONG
 MOVD R0,R6
 MOVQD 4,R0
 MOVSB
 ADDQD -4,R1
 TBITB 0,R1
 BFC1 LONG1
 ADDQD 1,R1
 ADDQD -1,R6
LONG1
 MOVD R1,R2
 ADDQD 4,R2
 MOVD R6,R0
 ANDB 0FCH,R0
 ADDQD -4,R0
 SUBD R0,R6
 LSHD -2,R0
 MOVSD
 ADDQD -3,R2
 MOVD R6,R0
 MOVSB
 RET 0

 DB 4,'LOAD'
 DW LINK-$
LINK VAR $-7
LOAD
 MOVD @TO_INL,TOS  ;save input-stream pointer
 MOVD @BLKL,TOS    ;save block # pointer
 MOVQD 0,@TO_INL
 MOVD 0(R7),@BLKL  ;pop # of block to load
 ADDQD 4,R7
 JSR @INTERP       ;interpret the block
 MOVD TOS,@BLKL
 MOVD TOS,@TO_INL
 RET 0

 DB 41H,'('
 DW LINK-$
LINK VAR $-4
 ADDQD -2,R7
 MOVB ')',0(R7)
 JUMP @WORD

 DB 46H,'ABORT"'
 DW LINK-$
LINK VAR $-9
 MOVD ABQUOTE,R1
 MOVB '"',R6       ;ending delimiter
 BR1 PQU1

 DB 42H,'."'
 DW LINK-$
LINK VAR $-5
 MOVB '"',R6       ;ending delimiter
PQU0
 MOVD PQUOTE,R1
PQU1
 JSR @SBCOMMA      ;compile a call to literal handler
 ADDQD -2,R7
 MOVB R6,0(R7)
 JSR @WORD         ;compile the literal string
 MOVD *+DPL-$,R1
 MOVXBD 0(R1),R0
 ADDQD 1,R0
 ADDD R0,R1        ;change dict. pointer to enclose the compiled string
 MOVD R1,*+DPL-$
 RET 0

PQUOTE             ;a literal handler to print a string
 RESTORE [R2]
 JSR @STYPE
 JUMP 1(R2)

 DB 3,'ABS'
 DW LINK-$
LINK VAR $-6
ABS
 ABSD 0(R7),0(R7)
 RET 0

 DB 88H     
 DB 1,'+'
 DW LINK-$
LINK VAR $-5
PLUS
 POP
 ADDD R6,0(R7)
 RET 0

ANOP
 NOP

 ALIGN 2    ;this makes the last byte come out even so the @#*!!$ assembler
            ;won't sometimes add a surprise byte at the end.
LINK433 EQU LINK-$

 END
