 INCLUDE 4CON.ASM
 INCLUDE MACLIB.ASM
 LIST ON
;4CON.ASM and MACLIB.ASM were INCLUDEd at this point
 MACLIST OFF
;           432  --  FORTH-83 for 32000 processor

;by Neil R. Koozer  --  November 13,1984      July 7, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709

;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.

;   August 21, 1985     Sept 14, 1985         Nov 18, 1985
;   Nov 27, 1985        January 6, 1986       January 29, 1986


 EXTERNAL BLOCK,CLS,BASICL,PSTART,MODEL,BASEL,STATEL
 EXTERNAL MACROL,DPL,XTIBL,SPANL,TO_INL,STRD1,STRD2
 EXTERNAL CONTEXL,CURRENTL,BLKL,TIBL,TIC,SAVESP,SYNERR,INEXPR

 GLOBAL DSTACK,STYPE,ERR1,TYP1,SEMIT,SCRLF,SBCOMMA,QUI1,RELDISP,SBC4,FINDWRD
 GLOBAL INTERP1,QUIT,REGLIST,WORD,TYP2,ASPACE,COMMA,ABORT,SEARCH,ERROR,WFLAG
 GLOBAL RELHERE,SBC2,NUMLIT,INTERP,NUML2,BCOMMA,ABQUOTE,TESTIT,BRCOMMA
 GLOBAL IOWORD,LINK432,QRUN,SKEY,STA1

STACK EQU $-30H    ;this leaves space to store the register variables
REGLIST EQU STACK
DSTACK EQU $-400H  ;data stack

 SETCFG [F]        ;this activates the FPU opcodes
 MOVB 90H,@P_8255+6 ;set up printer port
 MOVQB 0,@P_8255+2 ;reset strobe for printer
 BR2 START

STKMSG DB 11,'Stack Error'
MSGQ   DB 1,'?'
OK     DB 5,' OK',0DH,0AH
SRTMSG DB 33,'432 -- FORTH-83/BASIC version 0.C'
RSTMSG DB 13,13,10,'432 Restart'
BSPACE DB 3,8,20H,8
CONT_X DB 3,0DH,1BH,'K'
 ALIGN 2
WFLAG  DW 0

 DB 7,'EXECUTE'
 DW 0            ;end of linked list
 DOUBLE 0        ;end of linked list
LINK VAR $-14
EXECUTE
 ADDQD 4,R7
 MOVD -4(R7),R0
 JUMP R0         ;same as call + ret

IOWORD DW 95H    ;similar to CPM's IOBYTE

 DB 4,'EMIT'
 DW LINK-$
LINK VAR $-7
EMIT
 MOVB 0(R7),R0   ;POP CHAR
 ADDQD 2,R7
SEMIT
 MOVB *+IOWORD-$,R1
 ANDB 3,R1
 CMPQB 2,R1      ;see if re-routed to printer
 BEQ1 PEMIT
 MOVD USART,R1
SEC1
 TBITB 0,2(R1)   ;TxRdy bit
 BFC SEC1
 MOVB R0,0(R1)   ;write to USART
 RET 0

PEMIT            ;all 3 ports used for the printer have inverting I.C.'s
 MOVD P_8255,R1  ;base addr of printer port
PEM1
 TBITB 0,0(R1)   ;printer-ready bit
 BFC PEM1
 COMB R0,4(R1)   ;send byte to printer
 MOVQB 1,2(R1)   ;strobe the printer
 MOVQB 0,2(R1)
 RET 0

SKEY
 MOVD USART,R0
SKE1
 TBITB 1,2(R0)   ;RxRdy bit
 BFC SKE1
 MOVB 0(R0),R0   ;read USART
 RET 0

 DB 3,'KEY'
 DW LINK-$
LINK VAR $-6
KEY
 BSR SKEY
 ADDQD -2,R7
 MOVB R0,0(R7)
 RET 0

 DB 2,'C','R'
 DW LINK-$
LINK VAR $-5
SCRLF
 MOVB 0DH,R0
 BSR SEMIT
 MOVB 0AH,R0
 BR SEMIT

STYPE            ;print a sting, 1st byte is char count
 MOVXBW 0(R2),R4 ;char count
TYP1
 ADDQD 1,R2
TYP2
 MOVB 0(R2),R0   ;get char.
 BSR SEMIT
 ACBW -1,R4,TYP1
 RET 0

 DB 4,'TYPE'
 DW LINK-$
LINK VAR $-7
TYPE
 MOVXWD 0(R7),R4 ;char count
 ADDQD 4,R7
 MOVD 0(R7),R2   ;string addr.
 ADDQD 4,R7
 BR TYP2

 DB 6,'EXPECT'
 DW LINK-$
LINK VAR $-9
 MOVD 4(R7),R5   ;get count
 MOVD R5,R6      ;get buffer address
 ADDD 0(R7),R5   ;end of buffer
 ADDQD 4,R7
 ADDQD 4,R7
SEXPECT
 MOVD R6,R3      ;reset line buffer pointer
INKEY
 BSR SKEY        ;get char into R0
 CMPB 18H,R0     ;see if control-X
 BNE1 TESTBS
 MOVD CONT_X,R2  ;ADDR OF ^X MSG
 BSR STYPE
 BR SEXPECT
TESTBS
 CMPB 8,R0       ;see if backspace
 BNE1 TESTCR
 MOVD BSPACE,R2
 BSR STYPE
 ADDQD -1,R3
 CMPD R3,R6
 BLO SEXPECT
 BR INKEY
TESTCR
 CMPB 0DH,R0     ;see if carriage ret.
 BEQ1 LAST1
 CMPB R0,20H
 BLO INKEY       ;reject other control codes
 CMPD R3,R5      ;check for end of buffer
 BLO1 SAVEIT
 ADDQD -1,R3     ;back up
 MOVB R0,R4      ;save R4
 MOVB 8,R0       ;do a backspace
 BSR SEMIT
 MOVB R4,R0
SAVEIT
 MOVB R0,0(R3)   ;store the char
 ADDQD 1,R3
 CMPB R0,61H     ;change lower to upper case (what's this in here for?)
 BLO1 ISSUE
 CMPB R0,7BH
 BHS1 ISSUE
 CBITB 5,0(R3)
ISSUE
 BSR SEMIT       ;display the char
 BR INKEY
LAST1
 MOVB 20H,R0
 BSR SEMIT
 SUBD R6,R3
 MOVD R3,@SPANL  ;store the count
 RET 0

 DB 5,'QUERY'
 DW LINK-$
LINK VAR $-8
QUERY
 MOVD TIBL,R6    ;Kbd input buffer
 MOVD TIBL+KBUFLEN-1,R5 ;end of buffer
 BSR SEXPECT
 ADDD R6,R3
 MOVQB -1,0(R3)  ;hard delimiter
 MOVQD 0,@TO_INL ;reset input stream pointer
 MOVQD 0,@BLKL   ;0 means keyboard input
 MOVD @SPANL,@XTIBL ;another copy of char count
 RET 0

 DB 1,','
 DW LINK-$
LINK VAR $-4
COMMA            ;compile a 32-bit entity into the dictionary
 MOVD @DPL,R0
 MOVD 0(R7),0(R0)
 ADDQD 4,R7
 ADDQD 4,R0
 MOVD R0,@DPL
 RET 0

 DB 2,'W,'
 DW LINK-$
LINK VAR $-5
WCOMMA           ;compile a 16-bit entity into the dictionary
 MOVD @DPL,R0
 MOVW 0(R7),0(R0)
 ADDQD 2,R0
WCO1
 ADDQD 2,R7
 MOVD R0,@DPL
 RET 0

 DB 2,'C,'
 DW LINK-$
LINK VAR $-5
CCOMMA           ;compile a byte into the dictionary
 MOVD @DPL,R0
 MOVB 0(R7),0(R0)
 ADDQD 1,R0
 BR WCO1

RELDISP          ;compile a quantity in the 32000 'disp' format
 CMPD R1,1FFFH   ;see if D required
 BGT1 SBC4
 CMPD R1,-2000H
 BLT1 SBC4
 CMPW R1,3FH     ;see if W required
 BGT1 SBC2
 CMPW R1,-40H
 BLT1 SBC2
 ANDB 7FH,R1     ;make byte disp format
 MOVB R1,0(R2)   ;store disp into dict.
 ADDQD 1,R2
 BR1 SBC1
SBC4
 ROTW 8,R1       ;reverse the order
 ROTD 16,R1
 ROTW 8,R1
 ORB 0C0H,R1     ;format the hi byte
 MOVD R1,0(R2)   ;store into dict.
 ADDQD 4,R2
 BR1 SBC1
SBC2
 ROTW 8,R1       ;reverse the order
 ANDB 3FH,R1     ;format the hi byte
 ORB 80H,R1
 MOVW R1,0(R2)
 ADDQD 2,R2
SBC1
 RET 0

BRCOMMA          ;compile a BR jump to addr in R1
 MOVD @DPL,R2
 MOVB 0EAH,0(R2)
 BR1 SBC0

 DB 2,'B,'
 DW LINK-$
LINK VAR $-5
BCOMMA
 MOVD 0(R7),R1
 ADDQD 4,R7
SBCOMMA          ;compile a BSR call to addr in R1
 MOVD @DPL,R2
 MOVZBD @MACROL,R0 ;let's see if it's a macro
 MOVQB 0,@MACROL ;clear the macro indicator
 TBITB 7,R0      ;test flag to compile macro instead of a call
 BFS1 SBMACRO
 MOVQB 2,0(R2)   ;'BSR' opcode
SBC0
 SUBD R2,R1      ;rel dislacement value
 ADDQD 1,R2
SBC5
 BSR RELDISP     ;compile the disp
SBC6
 MOVD R2,@DPL
 RET 0

RELHERE          ;compile the value in R1 in the 32000 disp format
 MOVD @DPL,R2
 BR SBC5

MOVE1
 MOVSB
 BR SBC6

SBMACRO          ;compile a macro
 ANDB 7FH,R0     ;byte count in macro
 SAVE [R0,R2]
 BSR MOVE1
 RESTORE [R4,R5] ;check for push-pop sequence
 MOVD R5,R1
 ADDQD -5,R1
 MOVD PUSHPOP,R2
 MOVZBD 10,R0
 CMPSB
 BEQ1 SBM1
 MOVD @DPL,R2
 RET 0
SBM1             ;remove push-pop sequence
 MOVD R5,R2
 ADDQD -5,R2
 MOVD R4,R0
 ADDQD -5,R0
 BR MOVE1        ;move the macro to close up the gap

PUSHPOP
 PUSH
 POP

 DB 6,'ASPACE'
 DW LINK-$
LINK VAR $-9
ASPACE
 ADDQD -2,R7
 MOVB 20H,0(R7)  ;PUSH 20H TO DATA STAK
 RET 0

FINDWRD          ;find the next non-space in the input stream
 MOVD @BLKL,R0
 CMPQD 0,R0
 BEQ1 KBUF
 MOVD R0,-4(R7)
 ADDQD -4,R7
 JSR @BLOCK
 ADDQD 4,R7
 MOVD -4(R7),R6
 MOVD BLKLEN,R1
 BR1 WOR1
KBUF
 MOVD TIBL,R6
 MOVD @XTIBL,R1
WOR1
 ADDD R6,R1
 MOVD @TO_INL,R2
 ADDD R6,R2
 MOVD @DPL,R3
 MOVB 0(R7),R0   ;POP SEP. CHAR
 ADDQD 2,R7
 CMPB R0,20H     ;SEP = SPACE?
 BNE1 WOR2
IGNLB
 CMPD R1,R2
 BEQ1 WOR2
 CMPB 20H,0(R2)  ;FIND NON-SPACE
 BNE1 WOR2
 ADDQD 1,R2
 BR IGNLB
WOR2
 RET 0

 DB 4,'WORD'
 DW LINK-$
LINK VAR $-7
WORD
 BSR FINDWRD
 MOVZBD @WFLAG,R4 ;1 = BASIC syntax, 0 = FORTH syntax or literal strings
 ROTD -2,R4      ;save the flag in a safe place
 MOVQW 0,R4      ;SET COUNT = 0
 BEQ2 ENDTOK     ;jump if FINDWRD failed
 CMPB ' ',R0
 BEQ1 TOK
 CBITB 30,R4
 BR1 TOK
COUNT
 ADDQD 1,R4      ;CHAR COUNT
 ADDQD 1,R3      ;DICT POINTER
TOK4
 ADDQD 1,R2      ;L. B. POINTER
TOK
 CMPD R1,R2
 BLS2 ENDTOK
 MOVZBD 0(R2),R5 ;GET BYTE
 CMPB '^',R0     ;^ terminator means contrl char
 BNE1 TOK3
 SUBB 40H,R5
 MOVB R5,1(R3)
 MOVB R0,R5
 ADDQD 1,R4
 ADDQD 1,R3
TOK3
 MOVB R5,1(R3)   ;STORE BYTE
 TBITB 30,R4     ;see if BASIC syntax
 BFC1 TOK1
TOK2
 CASEB @WTABLE[R5:B]
TOK5             ;delimiter found
 CMPQW 0,R4      ;see if first char
 BNE1 ENDTOK     ;1st char being delimiter is error
TOK51
 CBITB 30,R4     ;change flag to accept any FORTH word
 BR COUNT
TOK6             ;numeral found
 CMPQW 0,R4
 BNE COUNT       ;ok if not first char
 CMPQB 3,@MODEL
 BEQ COUNT       ;ok if within expression
 BR TOK51

TOK1
 CMPB R5,R0      ;CHECK FOR TERMINATOR
 BNE COUNT
 ADDQD 1,R2      ;L. B. POINTER
 JSR @STRD2      ;was the terminator a string delimitor?
 BNE1 ENDTOK
 JSR @STRD1      ;is next char a string delimiter?
 BEQ TOK4
ENDTOK
 SUBD R6,R2
 MOVD R2,@TO_INL
 MOVD @DPL,R1
 MOVB R4,0(R1)   ;STORE CHAR COUNT IN HEADER
 RET 0

WTABLE          ;sacrifices memory for speed
 DB TOK5-TOK2 ;control codes
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2

 DB TOK5-TOK2 ;control codes
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2

 DB TOK5-TOK2 ;space
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB COUNT-TOK2 ;$
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2

 DB TOK6-TOK2 ;0
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2
 DB TOK6-TOK2 ;9
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2

 DB TOK5-TOK2 ;@
 DB COUNT-TOK2 ;A
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2

 DB COUNT-TOK2 ;P
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2 ;Z
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB COUNT-TOK2 ;_

 DB TOK5-TOK2 ;`
 DB COUNT-TOK2 ;a
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2

 DB COUNT-TOK2 ;p
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2
 DB COUNT-TOK2 ;z
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2
 DB TOK5-TOK2


 DB 6,'SEARCH'
 DW LINK-$
LINK VAR $-9
SEARCH
 MOVD 0(R7),R2   ;HEADER POINTER
 MOVD @DPL,R5    ;DICT. POINTER
TESTIT
 MOVD R5,R1
 MOVZBD 0(R2),R0 ;HEADER LEN.
 MOVB R0,@MACROL ;in case its a macro
 TBITB 7,R0      ;bit 7 set = macro
 BFC1 SEA1
 ADDQD 1,R2
 MOVZBD 0(R2),R0 ;get new token length byte
SEA1
 MOVB R0,@STATEL ;store for immediate flag
 ANDB 3FH,R0     ;strip flags from char count
 ADDQD 1,R2      ;point to first char
 MOVD R2,R3      ;SAVE R2
 MOVD R0,R4      ;save R0
 CMPB R0,0(R1)   ;compare length byte separately (the null word has 0 length)
 BNE1 NXTHDR
 ADDQD 1,R1
 CMPSB           ;COMPARE STRINGS
 BNE1 NXTHDR
 ADDQD 2,R2      ;SKIP LINK
 CMPQW 0,-2(R2)  ;0 means a 32-bit link value follows
 BNE1 SEA2
 ADDQD 4,R2
SEA2
 MOVD R2,0(R7)   ;PUT IT IN SAME STACK SPOT
 BR1 FLAG        ;R0 = FLAG = 0
NXTHDR
 MOVD R3,R2      ;RESTORE R2
 ADDD R4,R2      ;ADDR OF LINK WORD
 MOVXWD 0(R2),R0 ;LINK WORD IS OFFSET
 ADDD R0,R2      ;ADDR OF NEXT HEADER
 CMPQW 0,R0      ;0 means a 32-bit link value follows
 BNE TESTIT
 MOVD 2(R2),R0
 ADDD R0,R2
 CMPQD 0,R0      ;0 means end of dictionary
 BNE TESTIT
 MOVQW -1,R0     ;MAKE FLAG = TRUE
 ADDQD 4,R7      ;FIX STACK (NO NUMBER BEING OUTPUTTED)
FLAG
 ADDQD -2,R7     ;PUSH FLAG
 MOVW R0,0(R7)
 RET 0

PAT1
 MOVD STKMSG,R2
PATCH            ;fix up environment after error
 CMPQB 0,@MODEL  ;see if a word definition was in progress
 BEQ2 STA1
 MOVD @CURRENTL,R0 ;FIX DICTIONARY
 MOVD 0(R0),R1   ;addr of word to be deleted
 MOVD R1,@DPL    ;make it free space
 MOVZBD 0(R1),R3 ;char count
 ADDQD 1,R3
 ADDD R3,R1      ;addr of link word
 MOVXWD 0(R1),R3 ;get link offset & convert to 32 bits
 ADDD R3,R1      ;addr of previous heading
 MOVD R1,0(R0)   ;make it the current last entry
 BR2 STA1

ERROR
 MOVD @DPL,R2
 TBITB 0,@WFLAG  ;see if BASIC
 BFC1 ERR1
 JUMP @SYNERR
ERR1
 BSR SCRLF
 BSR STYPE       ;print name of unk token
 MOVD MSGQ,R2    ;addr of '?' msg
 BR PATCH

INT1
 TBITB 6,@STATEL
 MOVQB 0,@STATEL
 BFS1 QEX1       ;execute if STATE = imm.
 CMPQB 0,@MODEL
 BEQ1 QEX1
 BR BCOMMA       ;compile if MODE = 1
QEX1
 ADDQD 4,R7      ;call subr whose addr is
 MOVD -4(R7),R0  ;   on DSTACK (EXECUTE)
 JSR R0
 CMPD R7,DSTACK  ;check for stack error
 BHI PAT1
 RET 0

 DB 7,'CONVERT'
 DW LINK-$
LINK VAR $-10
 MOVD 4(R7),R3
 MOVD 0(R7),R2
 BSR1 NLOOP
 MOVD R3,4(R7)
 MOVD R2,0(R7)
 RET 0

NUMEND
 RET 0
NLOOP            ;loop to convert a string to a number
 ADDQD 1,R2
 MOVZBD 0(R2),R4 ;GET CHAR
 SUBB 30H,R4
 BCS NUMEND
 CMPB R4,0AH
 BLO1 NUMB
 CMPB R4,11H
 BLO NUMEND
 ADDQB -7,R4
NUMB
 MOVZBD @BASEL,R5 ;RADIX
 CMPB R4,R5
 BHS NUMEND
 MULD R5,R3      ;RESULT = RESULT * RADIX
 ADDD R4,R3      ;RESULT = RESULT + NUMB
 BR NLOOP

INTERP           ;this loop gets exited by the null word when
 BSR1 INTERP1    ;   the input stream is exausted
 BR INTERP

INTERP1          ;interpret one word from input stream
 BSR ASPACE      ;make the delimiter a space
 BSR WORD
 CMPQB 0,@INEXPR ;1 means in BASIC expression
 BEQ1 INT2
 MOVB 1(R1),R0   ;if in BASIC check for number to avoid searching dictionary
 SUBB 30H,R0
 CMPB 9,R0
 BHS1 NUMBER
INT2
 ADDQD -4,R7
 MOVD @CONTEXL,R0
 MOVD 0(R0),0(R7) ;same as CONTEXT @ @
 BSR SEARCH
 ADDQD 2,R7
 CMPQB 0,-2(R7)
 BEQ INT1        ;execute if found
NUMBER           ;try to interpret the word as a number
 MOVD @DPL,R2
 MOVZBD 0(R2),R0
 MOVB 1(R2),R1
 CMPB '-',R1
 MOVQD 0,R3      ;RESULT REG
 MOVQB 0,R1      ;SIGN = '+'
 BNE1 SKPSAV
 MOVQB -1,R1     ;SIGN = '-'
 ADDQD -1,R0     ;FIX CHAR COUNT
 ADDQD 1,R2      ;CHAR POINTER
SKPSAV
 ADDD R2,R0
 ADDQD 1,R0
 BSR NLOOP       ;convert the string to a number
 CMPD R0,R2      ;see if the string was used up
 BNE ERROR
 CMPQB 0,R1      ;0=positive NZ=negative
 BEQ1 DONE
 NEGD R3,R3
DONE
 CMPQB 0,@MODEL  ;see if compile mode
 BNE1 NUMLIT
 MOVD R3,-4(R7)  ;push number to stack if not compile mode
 ADDQD -4,R7
 RET 0

NUMLIT
 CMPQB 3,@MODEL  ;3 means in BASIC expression
 BNE1 NUML5
 MOVD R3,R6      ;return number in R6
 ADDR @14H,R5    ;14h in R5 means 'immediate' addressing mode of 32000
 RET 0
NUML5            ;the rest of this routine is due for revision although
 CMPQD 7,R3      ;   it works ok
 BLT1 NUML1
 CMPQD -8,R3
 BGT1 NUML1
 MOVD QNUMBER,R1
 MOVZBD 87H,R0
 ANDW 0FH,R3
 ORW 0BE60H,R3
 ROTW 7,R3
 MOVW R3,0(R1)
 BR2 NUMSTOR
NUML1
 CMPD 127,R3
 BLT1 NUML2
 CMPD -128,R3
 BGT1 NUML2
 MOVD BNUMBER,R1
 MOVZBD 89H,R0
 MOVB R3,3(R1)
 BR1 NUMSTOR
NUML2
 MOVD DNUMBER,R1
 MOVZBD 8BH,R0
 ROTW 8,R3
 ROTD 16,R3
 ROTW 8,R3
 MOVD R3,2(R1)
NUMSTOR
 CMPD @CONTEXL,BASICL
 BEQ1 NUML3
NUML4
 MOVB R0,@MACROL
 BR SBCOMMA
NUML3
 ADDQD -5,R0
 BR NUML4

QNUMBER
 MOVQD 0,R6
 PUSH

BNUMBER
 MOVXBD 0,R6
 PUSH

DNUMBER
 MOVD 0,R6
 PUSH

START
 JSR @CLS          ;clear screen
 MOVD RSTMSG,R2    ;addr of warm start message
 CMPQB 0,@BASEL    ;0 means we have a cold start
 BNE1 STA1         
 MOVB 10,@BASEL    ;set decimal number base
 MOVD STACK,@SAVESP ;SP saved here for shifting between FORTH and BASIC
 MOVD SRTMSG,R2    ;addr of cold start message
STA1
 BSR STYPE
 BSR SCRLF
ABORT
 MOVD DSTACK,R7    ;reset data stack pointer
QUIT
 LPRD SP,@SAVESP   ;reset return stack pointer
 MOVQB 0,@MODEL
 MOVQB 0,@STATEL
QUI1               ;this is the start of the command loop
 BSR QUERY         ;get a keyboard line
 MOVD @DPL,@PSTART ;reset @PSTART, which points to beginning of executable
                   ;   compiled code
 BSR INTERP        ;interpret the line from keyboard
 BSR1 QRUN
 MOVD OK,R2
 BSR STYPE
 BR QUI1

QRUN               ;run any existing compiled executable code
 CMPD BASICL,@CONTEXL ;see if we're in BASIC
 BNE2 QRU0
 MOVD @PSTART,R6
 MOVD @DPL,R2
 CMPD R2,R6
 BEQ2 QRU0         ;EQ means no executable code has been compiled
 MOVW 12H,0(R2)    ;compile a RET 0
 SAVE [R6,R7]
 GETREG            ;load the register variables
 MOVD 4(SP),R6
 JSR R6            ;execute the compiled code
 PUTREG            ;store the register variables
 RESTORE [R6,R7]
 MOVD R6,@DPL      ;reset dict. pointer to where the compiled code had been
QRU0
 RET 0

 DB 85H            ;bit 7 set means macro; the rest is the # of bytes in macro
 DB 2,'2/'
 DW LINK-$
LINK VAR $-6
 ASHD -1,0(R7)
 RET 0             ;not part of macro; the return is for non-compile mode

 DB 86H
 DB 2,'R@'
 DW LINK-$
LINK VAR $-6
 ADDQD -4,R7
 MOVD 0(SP),0(R7)
 RET 0

 DB 9,'-TRAILING'
 DW LINK-$
LINK VAR $-12
 MOVD 0(R7),R0
 MOVD 4(R7),R1
 ADDD R0,R1
 ADDQD -1,R1
 MOVB 20H,R4
 SKPSB BW
 MOVD R0,0(R7)
 RET 0

 DB 3,'ROT'
 DW LINK-$
LINK VAR $-6
 MOVD 8(R7),R0
 MOVD 4(R7),8(R7)
 MOVD 0(R7),4(R7)
 MOVD R0,0(R7)
 RET 0

 DB 3,'PAD'
 DW LINK-$
LINK VAR $-6
 ADDR @100H,R6
 ADDD @DPL,R6
 PUSH
 RET 0

 DB 43H,'[',27H,']'
 DW LINK-$
LINK VAR $-6
 MOVQB 0,@MODEL
 JSR @TIC
 MOVQB 1,@MODEL
 MOVD 0(R7),R3
 ADDQD 4,R7
 BR NUML5

 DB 42H,'.('
 DW LINK-$
LINK VAR $-5
 ADDQD -2,R7
 MOVB ')',0(R7)
 BSR WORD
 MOVD @DPL,R2
 BR STYPE

ABQUOTE
 RESTORE [R2]
 ADDQD 4,R7
 CMPQW 0,-4(R7)
 BEQ1 ABQ1
 BSR STYPE
 BR ABORT
ABQ1
 MOVZBD 0(R2),R0
 ADDD R0,R2
 JUMP 1(R2)

 DB 88H
 DB 1,'-'
 DW LINK-$
LINK VAR $-5
SUBTRACT
 POP
 SUBD R6,0(R7)
 RET 0

 ALIGN 2           ;this is to make the end come out even so the @&%$#!
                   ;assembler won't add a surprise byte at the end
LINK432 EQU LINK-$ ;link to next module

 END
