/* The display routine assumes that the storage format for double numbers
is that of Mix-C (the same format is used by MBASIC).  If you re-compile
this with another C compiler, be sure that it has enough accuracy.  Aztec-C
is not adequate in this respect.*/

display(in)    /* print (in hexedecimnal) the binary form of a double float */
char *in;      /* number.  Both Mix format and IEEE format are displayed */
{
char out[8];
unsigned exp;
int j;
out[0]=exp=in[0]+4;   /* round before truncating */
for( j=1; j<6 && exp>255; j++ )
   out[j]=exp=in[j]+1;  /* ripple carry */
for( ; j<=7; j++ )
   out[j]=in[j];
if( exp>255 ){
   out[6]=exp=(out[6] | 128)+1;   /* carry into ms-byte */
   if( exp>255 ) out[7]++;
   out[6]=(out[6] & 127) | (in[6] & 128);}   /* replace sign */
for( j=0; j<6; j++ )
   out[j] = (out[j+1]<<5) | ((unsigned)out[j]>>3);
exp = ((0x37e + (unsigned)out[7])<<4)
      | ((0x7f & out[6])>>3) | ((0x80 & out[6])<<8);
out[6] = exp;
out[7] = exp>>8;
for( j=7; j>=0; j-- ){
   if( j&1 ) printf(" ");
   printf(" %x%x",in[j]>>4,in[j]&15);}
printf("\n");
for( j=7; j>=0; j-- ){
   if( j&1 ) printf(" ");
   printf(" %x%x",out[j]>>4,out[j]&15);}
printf("\n");
}

double x,y,z;
main(){
printf("This program displays (in hexadecimal) the binary form of double\n");
printf("precision numbers that are input at the keyboard.  The result of\n");
printf("(number * multiplier / divisor) is used for the display.  The\n");
printf("first line of output is for 8-bit exponent and 56-bit mantissa,\n");
printf("while the second line is for IEEE double precision.\n\n");
for(;;){
   printf("number multiplier divisor: ");
   scanf("%lf %lf %lf",&x,&y,&z);
   x = x * y / z;
   display(&x);
   }
}
