;32032 fractal program
;1/8/87
;
;R0 = starting x coordinate (left side)
;R1 = ending x coordinate (right side)
;R2 = starting Y coordinate (bottom)
;R3 = ending y coordinate (top)
;R4 = horizontal count
;R5 = vertical count
;
BG:	MOVDF	R0,R0		;Starting X
	MOVDF	R1,R1		;Ending X
	MOVDF	R2,R2		;Starting Y
	MOVDF	R3,R3		;Ending Y
	MOVDF	R4,R4		;X count
	MOVDF	R5,R5		;Y count
;
;Calculate total X  and Y change
;
	SUBF	R0,R1
	SUBF	R2,R3
;
;Calculate X and Y increments
;
	DIVF	R4,R1
	DIVF	R5,R3
;
;Initialize X and Y coordinates
;
	MOVQW	0,R0
	MOVW	R0,R2
;
;Y loop
;
LY:	MOVD	R0,TOS
	MOVD	R4,TOS
	MOVF	R0,TOS
;
;X loop
;
LX:	MOVDF	0,R4
	MOVF	R4,R5
	MOVD	1000,R6
;
;Main test loop
;
LC:	MOVF	R4,R6
	MOVF	R5,R7
;
;Calculate new X
;
	MULF	R6,R6		;X2
	MULF	R7,R7		;Y2
	SUBF	R7,R6		;X2-Y2
	ADDF	R0,R6		;New X
;
;Calculate new Y
;
	MULF	R4,R5		;X*Y
	ADDF	R5,R5		;2*X*Y
	ADDF	R2,R5		;New Y
	MOVF	R6,R4		;Current X
;
;See if magnitude is > 4
;
	MULF	R6,R6		;X2
	MOVF	R5,R7
	MULF	R7,R7		;Y2
	ADDF	R6,R7		;X2+Y2
;
	TRUNCFD	R7,R7
	CMPQD	4,R7
	BLE	AA:B
;
;No overflow yet, keep trying for count
;
	ACBD	-1,R6,LC:W
	BR	AB:B
;
;Set pixel if not in set
;
AA:	BSR	AS
;
;
;Continue with next column
;
AB:	ADDQD	1,R0
	ADDF	R1,R0
	ACBD	-1,R4,LX:W
;
;Column finished, do next row
;
	MOVF	TOS,R0		;Floating beginning X
	MOVD	TOS,R4		;X count
	MOVD	TOS,R0		;Integer beginning X
;
;Advance to next row
;
	ADDQD	1,R2
	ADDF	R3,R2
	ACBD	-1,R5,LY:W
;
;All done
;
	RXP	0
;
;
AS:	SAVE	[R0,R1,R2,R3,R4,R5,R6,R7]
;
;Convert R0, R2 binary values to ASCII in OB
;
	ADDR	OB,R3
	BSR	A1		;Convert R0
	MOVW	R2,R0
	BSR	A1
;
	MOVQD	4,R0
	ADDR	OB,R1
	MOVB	H'D,8(R1)
	MOVZBD	9,R2
	MOVQD	0,R3
;
	SVC
;
	RESTORE	[R0,R1,R2,R3,R4,R5,R6,R7]
	RET	0
;
;Convert word in R0 to ASCII in (R3)
;
A1:	SAVE	[R0,R2]
	MOVB	4,R2
A2:	ROTW	4,R0
	EXTSB	R0,0(R3),0,4
	ADDB	"0",0(R3)
	CMPB	"9",0(R3)
	BGE	A3:B
	ADDQB	7,0(R3)
A3:	ADDQD	1,R3
	ACBB	-1,R2,A2:B
	RESTORE	[R0,R2]
	RET	0
;
;Transmit buffer
;
XB:	.BYTE	"  "
YB:	.BYTE	"  "
	.BYTE	H'D		;CR
OB:	.BYTE	"                "
	.BYTE	"                "
	.BYTE	"                "
	.BYTE	"                "
;
;End of FRACTAL.MAC
