;FORTH.CMD - January 20, 1990
;This ProComm command file will do a complete assembly/link sequence 
;on the 432 FORTH files with the Kotekan assembler/linker.  If any 
;assembly errors occur, the file will abort.  Assembly and linking is 
;done via the parallel port with PRL-XFER.  The executable FORTH 
;program will be ready to run and all CPU registers will be 
;initialized.  The file STOP is also needed to end assembly.

;PRL-XFER, 4CON.ASM, 432.ASM, 433.ASM, 434.ASM, STOP must all be on 
;the default drive/directory (Use ALT B to change from within ProComm)

DOS "DEL 43?.LNK"                 ;Delete any existing .LNK files
TRANSMIT "I RADIX -16!"           ;Force hex input radix
TRANSMIT "J PRTR=PRTR!"           ;Set up to use parallel port
TRANSMIT "J DISK=DISK!"
TRANSMIT "A PRTR,100000,DISK!"    ;Start assembling
DOS "PRL-XFER 4CON.ASM /T"        ;This is included
DOS "PRL-XFER 432.ASM /T"         ;1st FORTH file
DOS "PRL-XFER STOP"               ;End assembly
RGET S0 10 3                      ;Get error count
IF FAILURE
 EXIT                             ;Exit if nothing received
ENDIF
FIND S0 "0 error(s)"
IF NOT FOUND
 EXIT                             ;Exit if assembly errors
ENDIF
GETFILE XMODEM "432.LNK"          ;Receive link file
TRANSMIT "A PRTR,100000,DISK!"    ;Do 433.ASM now
DOS "PRL-XFER 4CON.ASM /T"
DOS "PRL-XFER 433.ASM /T"
DOS "PRL-XFER STOP"
RGET S0 10 3
IF FAILURE
 EXIT
ENDIF
FIND S0 "0 error(s)"
IF NOT FOUND
 EXIT
ENDIF
GETFILE XMODEM "433.LNK"
TRANSMIT "A PRTR,100000,DISK!"    ;Do 434.ASM
DOS "PRL-XFER 4CON.ASM /T"
DOS "PRL-XFER 434.ASM /T"
DOS "PRL-XFER STOP"
RGET S0 10 3
IF FAILURE
 EXIT
ENDIF
FIND S0 "0 error(s)"
IF NOT FOUND
 EXIT
ENDIF
GETFILE XMODEM "434.LNK"

;All files assembled, now link them

TRANSMIT "A SER1,100000,6000!"
TRANSMIT " ONEMOD 1!"
TRANSMIT " LINK!"
DOS "PRL-XFER 432.LNK /L"
TRANSMIT " ONEMOD 1!"
TRANSMIT " LINK!"
DOS "PRL-XFER 433.LNK /L"
TRANSMIT " ONEMOD 1!"
TRANSMIT " LINK!"
DOS "PRL-XFER 434.LNK /L"
TRANSMIT " ONEMOD 1!"
TRANSMIT " STACK 1,H'100000!"     ;Set up stack
TRANSMIT " STOP!"
WAITFOR "H>" 3                    ;Wait for linker to finish
TRANSMIT "QR!"                    ;Load register for execution
TRANSMIT "QD!"                    ;Display map
MESSAGE "Press G <return> to run FORTH"
