;constants and macros for 432

INCL_BAS EQU	0		;BASIC not included
INCL	EQU	0		;1 if assembling all together
				;0 if assembling separately and linking
	COND	NOT INCL
	 ONEMOD	1		;One big SB area
	CEND

KBUFLEN	EQU	80H		;Size of keyboard buffer
MAXBLK	EQU	8		;Number of blocks
BLKLEN	EQU	400H		;Block size
BUFLEN	EQU	BLKLEN		;Block buffer size
NBUFFS	EQU	MAXBLK		;Number of block buffers
DICT_SIZ EQU	H'3000		;Size of dictionary space
STK_SIZ	EQU	H'400		;Size of data stack

;Kotekan equates:

dev_vid	equ	4		;Video output device
dev_kbd	equ	6+1		;Keyboard input device
dev_pr	equ	20		;Printer output device

	mode	imm,0

dof_name: ds	1	;Device ID
dof_bdat: ds	1	;Base data block common to all related devices/instances
dof_dat: ds	1	;Physical device data block
dof_vdat: ds	1	;Virtual device data block
dof_lnk: ds	1	;Device link data pointer (-1 = none)
dof_cdat: ds	1	;Command data
dof_cmd: ds	1	;Device command routine
dof_blk: ds	1	;Block I/O routine
dof_chr: ds	1	;Character I/O with translation/system update
dof_sst: ds	1	;Software status
dof_sio: ds	1	;Software I/O
dof_stat: ds	1	;Device hardware status fetch
dof_io: ds	1	;Device hardware I/O routine

	mode	imm-,32
bkb_28: blkb			;Termination on 28 bit count in r0 if set
bkb_bin: blkb			;Binary file if set
	blkb			;Reserved
	blkb			;Reserved

;These are active only if bkb_28 is clear

bkb_cnt: blkb			;Termination on 16 bit count in R0 if set
bkb_tr5: blkb			;Terminate on character in r5

bkb_edt: blkb			;Editing enabled if set
bkb_cnv: blkb			;Lower to upper case conversion if set
bkb_eko: blkb			;Echo characters if set
bkb_ekt: blkb			;Echo termination if set

;These are active when EDT is set
;R5 must hold termination character

	mode	imm,16

bkb_esc: blkb			;Quit and zap entry if ESC pressed
bkb_ret: blkb			;Also exit if RET pressed

;These are active when EDT is clear

	org	16

bkb_trm: blkb			;Handshaking termination on end of file
bkb_hlt: blkb			;Halt (XOFF etc.) after input is complete

	mode	pc

dc_open: equ	(1 lsh 8)+(0 lsh 14)+(4 lsh 18)+(3 lsh 22)+exp 31
	;Open device, can't create new files
dc_close: equ	(1 lsh 8)+(0 lsh 14)+(4 lsh 18)+(2 lsh 22)+exp 31
	;Close device
dc_binon: equ	(6 lsh 8)+(0 lsh 14)+(4 lsh 18)+(3 lsh 22)+exp 31
	;Binary file type selected
dc_binoff: equ	(6 lsh 8)+(0 lsh 14)+(4 lsh 18)+(2 lsh 22)+exp 31
	;Binary file type off

;Special video control characters

vc_win:	equ	h'89		;Cursor positioning prefix
vcw_up:	equ	h'f2		;Cursor up
vcw_dn:	equ	h'f3		;Cursor down
vcw_lf:	equ	h'f0		;Cursor left
vcw_rt:	equ	h'f1		;Cursor right
vcw_dl:	equ	h'fd		;Delete character right

vc_scr:	equ	h'85		;Screen command
vcs_pag: equ	h'23		;New page (clear screen)
vcs_cur: equ	h'24		;Position cursor (column, row follow)

;Push and Pop macros are not always used, don't change them!!

PUSH	MACRO			;;Push a value onto the data stack
	MOVD	R6,-4(R7)
	ADDQD	-4,R7
	MEND

POP	MACRO			;;Pop a value from the data stack
	ADDQD	4,R7
	MOVD	-4(R7),R6
	MEND

DOES	MACRO
	RET	0
	ADDQD	-4,R7
	MOVD	TOS,0(R7)
	MEND

MAC_LINK MACRO	STR		;;Put string into linked list
	DB	LEN $^"&STR!^"
	DB	$^"&STR!^"
	DW	LINK-`
LINK	SET	`-LEN $^"&STR!^"-3 ;;Length of string, length byte, link word
	MEND

MAC_MSG MACRO	STR               ;;DB length,text string
	LOCAL	ADR
	DB	ADR-(`+1)         ;;Length of string
	DB	STR               ;;String text
ADR:
	MEND
