
B4B1:	MODULE

; INCLUDE 4CON.ASM
; INCLUDE MACLIB.ASM
; LIST ON
; MACLIST OFF
;  BASIC for the 32000
;by Neil R. Koozer            July 29, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709
;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.
;  September 20, 1985      November 19, 1985       November 26, 1985
;  January 9, 1986         February 1, 1986

	EXTRN	F432,F433,F434,B4B0,B4B1,B4B2,SAVESP
	GLOBAL	STRDEL,STRD1,STRD2,EXPRESS,SYNERR,ALIGN,EXP0,DISP,PSTART,PRIN4
	GLOBAL	OFFSET,ACCUM,AEMPTY,LOOK,LINK4B1,BHEADER,INEXPR
	EXTRN	PQU1,ATAIL,SBCOMMA,REGLIST,QUI1,ALOAD,COMPILE,SAVACC,ADD,WFLAG
	EXTRN	ERR1,OPTABLE,DEFI21,DEFF03,NEGACC,MODEL,INTERP1,FINDWRD,TO_INL
	EXTRN	RELDISP,DPL,SBC4,HEADER,DIM5,IMMED,DEFI1,TIBL,PERI1,DEFI20
	EXTRN	STYPE,FIL2,XLOAD,DBL1,MULT,LINK4B0,QRUN,STR21,SKEY,EDI0,EDTABL
	EXTRN	BLKL,BNEW,BEGIN
	EXTRN	STRD0,STRD1,STRD2,REGBYTE

PSTART:	DD	0	;addr of start of compiled executable BASIC code
REGDBL:	DB	0	;count of float register variables
SIGN:	DW	0
NOTF:	DW	0
ACCUM:	;storage for description of accumulator (6 means R6)
	DD	6	;this part holds addressing mode & data type indicators
	DD	0	;this part for address or disp when accum isn't reg. or TOS
AEMPTY:	DW	0	;flag to indicate accum. empty
	DB	0	;NULL uses this byte
NULL:
	DB	9	;NOP uses this byte
NOP:	RET	0
INEXPR:	DB	0

SNERROR:
	DB	13,' Syntax Error'
	DB	4,'STOP'
	DW	LINK4B0-$	;link to previous module
BL	SET	$-7
	ADDR	BSTOP,R1
	BR	SBCOMMA
BSTOP:
	PUTREG	;save reg. variables
	SPRD	SP,*+SAVESP-$	;save SP in case errors occur during command mode
	BSR	PQUOTE
	DB	11,0DH,0AH,'Break at '
	MOVD	0(SP),R6
	BSR	PRINT:W
	BR	QUI1	;goto main command loop
	DB	4,'CONT'
	DW	BL-$
BL	SET	$-7
	ADJSPB	-12	;set up return to previous STOP location
	GETREG	;get reg. variables
	RET	0
FIND1:	;find next non-space in input stream
	ADDQD	-2,R7
	MOVB	' ',0(R7)
	BR	FINDWRD
LOOK:	;This does a conditional jump depending on whether a
	SAVE	[R3,R4,R6]	;particular string is found in the input stream.  If the
	BSR	FIND1	;string is found, the text pointer is advanced just past the
	MOVD	12(SP),R1	;string.  If char count has bit 7 set, it does jump-if-found;
	MOVZBD	0(R1),R0	;otherwise it does jump-if-not-found.
	MOVB	R0,R4
	CBITB	7,R0
	ADDQD	1,R1
	CMPSB
	ADDD	R0,R1
	ADDQD	1,R1
	BNE	LOO4:B
	SUBD	R6,R2
	MOVD	R2,TO_INL
	TBITB	7,R4
	BFC	LOO2:B
	BR	LOO1:B
LOO4:
	TBITB	7,R4
	BFS	LOO2:B
LOO1:
	MOVXBD	-1(R1),R2
	ADDD	R2,R1
LOO2:
	RESTORE	[R3,R4,R6]
	ADJSPB	-4
	JUMP	R1
OFFSET:	;compile code to compute offset into array of desired element
	SAVE	[R6]	;addr of addr. mode bytes
	MOVZBW	2(R6),TOS	;push #-of-dimensions
	ADDQD	7,R6	;point to 2nd dim (or start of array)
	SAVE	[R6]
	BSR	EXP0	;read expression
	CMPQB	2,R1	;2 means 2-operand expression (not yet compiled)
	BHI	DIM7
	SAVE	[R2,R5,R6]
	MOVD	R3,R5
	MOVD	R4,R6
	BSR	ALOAD	;load the first operand
	RESTORE	[R4,R5,R6]
	JSR	R4	;compile operation & second operand
	MOVQD	0,R1	;0 means result is in accum
DIM7:
	MOVD	R1,R4	;save flag
	BSR	LOOK
	DB	1,','
	DB	DIM6-($+1)	;H'40
{ BSR DIM6 }
	CMPQB	1,R4	;1 means 1-operand expression (not yet compiled)
	BNE	DIM8:B	;NE means the value is already in accum.
	BSR	ALOAD	;put it into accum
DIM8:
	RESTORE	[R5]	;addr of next dim
	MOVD	-4(R5),R6	;get dim
	ADDQD	4,R5	;point to next dim or start of array
	ADDQB	-1,0(SP)	;decr dimension counter
	SAVE	[R5]
	MOVD	14H,R5	;set R5 = 14h for 'immediate'
	BSR	MULT	;mult the running product by dim.
	ADDR	DIM13,TOS	;return addr.
	MOVQB	1,*+AEMPTY-$	;tell expression routine that accum. is full
	ADDR	NULL,TOS	;stack delimiter for expresson routine
	ADDR	ADD,TOS	;save the add till the exp. is done
	BR	EXP2:W	;do an expression
DIM13:	;return here
	BSR	LOOK	;see if there are more dimensions
	DB	81H,','
	DB	DIM8-($+1)	;H'CC
{ BSR DIM8 }
	MOVQD	0,R4
DIM6:
	BSR	LOOK
	DB	1,')'
	DB	SYNERR-($+1)	;H'D
{ BSR SYNERR }
	CMPQB	1,R4	;see if 1-operand expr (not yet compiled)
	BNE	DIM9:W
	CMPQB	5,R5
	BLO	DIM10:B
	MOVB	R5,R0	;Rn = reg.
	BR	DIM11:B
SYNERR:
	ADDR	SNERROR,TOS
	BSR	STYPE
	MOVD	TOS,R2
	BSR	SKEY	;wait for key-pressed
	CMPQB	0,BLKL	;see if we're in a block
	BEQ	SYN0:B
	MOVW	TO_INL,EDTABL	;init edit cursor to point of error
	BSR	EDI0
SYN0:
	BR	BNEW	;start anew
DIM10:
	BSR	ALOAD
DIM9:
	MOVW	*+ACCUM-$,R0	;Rn = accum
DIM11:
	RESTORE	[R6]	;addr of array
	CMPQW	0,TOS	;see if correct # of dimensions found
	BNE	INDERR:B
	RESTORE	[R2]	;addr of type bytes
	MOVZBD	0(R2),R5	;basemode
	LSHW	3,R5
	ORB	R0,R5	;append 'Rn'
	LSHW	8,R5
	MOVB	1(R2),R5	;indexed-addressing-mode byte
	CMPB	1FH,R5	;see if real
	BNE	DIM12:B
	SBITB	16,R5	;set real flag
DIM12:
	RET	0
INDERR:
	ADDR	INDERRM,R2
	BR	ERR1
EXPRESS:
	MOVD	*+ACCUM-$,R5	;make the accum the destination
	MOVD	*+ACCUM+4-$,R6
	BSR	DEFI21	;do an asignment statement
	MOVQB	1,*+AEMPTY-$	;set 'accum full' flag
	RET	0

;expression parser starts with EXP0.  If it finds one or two operands, it
;returns information about the operands and operator, but does not compile.  If
;it finds more than two operands, it compiles code to evaluate the expression
;and place the result into the current accumulator.
EXP0:
	MOVQB	0,*+AEMPTY-$	;0 means accum empty
EXP1:
	ADDR	NULL,TOS	;stack delimiter
EXP2:
	MOVQB	0,*+SIGN-$	;'READ OPERAND' starts here
	MOVQB	0,*+NOTF-$
EXP0B:
	BSR	LOOK
	DB	81H,'+'
	DB	EXP0B-($+1)	;H'FA
{ BSR EXP0B }
	BSR	LOOK
	DB	1,'-'
	DB	EXP0D-($+1)	;H'7
{ BSR EXP0D }
	XORB	1,*+SIGN-$
	BR	EXP0B
EXP0D:
	BSR	LOOK
	DB	81H,'('
	DB	EXP0DD-($+1)	;H'3
{ BSR EXP0DD }
	BR	EXP0E:W
EXP0DD:
	MOVQD	-2,R5	;-2 means expression in expression
RECURSIVE:
	CBITB	0,*+AEMPTY-$	;test accum-busy flag
	BFC	RECUR1:B
	RESTORE	[R4]	;pending operator
	MOVD	*+ACCUM-$,R2	;get type of accum
	MOVW	17H,R2	;make it TOS
	SAVE	[R2,R3,R4]	;save the operation
	BSR	SAVACC	;compile code to push accumulator
RECUR1:
	CMPQD	-3,R5	;see if array element
	BNE	RECUR5:B
	MOVW	*+SIGN-$,TOS
	MOVQD	6,*+ACCUM-$	;use R6 for array element offset
	MOVQD	0,*+ACCUM-$+4
	BSR	OFFSET	;compile code to compute array element offset
	MOVW	TOS,*+SIGN-$
	CMPQB	0,*+AEMPTY-$	;accum still clean if offset is a reg. variable
	BEQ	REA2:W
	ADDR	ALOAD,TOS	;make pending operator 'load-into-accum'
	BR	REA2:W
RECUR5:
	ADDR	NOP,TOS	;fake 'pending operator'
	MOVW	*+SIGN-$,TOS
	CMPQD	-1,R5	;see if function
	BNE	RECUR3:B
	BSR	DEFF03	;compile function call
	MOVQB	1,*+AEMPTY-$	;function always uses accum
	BR	RECUR4:B
RECUR3:
	BSR	EXPRESS	;get expression recursively
	BSR	LOOK
	DB	1,')'
	DB	RECURE-($+1)	;H'15
{ BSR RECURE        ;error if no ')' }
RECUR4:
	CMPQW	0,TOS	;pop & test sign
	BEQ	RECUR2:B
	BSR	NEGACC	;compile code to negate accum.
RECUR2:
	MOVD	*+ACCUM-$,R5	;make accum the source of the operand
	MOVD	*+ACCUM+4-$,R6
	BR	EXP3:W
RECURE:
	BR	SYNERR
EXP0E:
	BSR	LOOK
	DB	3,'NOT'
	DB	EXP0F-($+1)	;H'7
{ BSR EXP0F }
	XORB	1,*+NOTF-$
	BR	EXP0E
EXP0F:
	CMPQB	0,*+NOTF-$
; BNE EXP0NOT      ;this NOT stuff isn't finished yet
EXP0H:
	MOVQB	1,INEXPR	;set flags meaning 'within BASIC expression'
	MOVQB	3,MODEL
	BSR	INTERP1	;get operand from input stream
	MOVQB	0,INEXPR
	MOVQB	0,MODEL
	CMPQD	-8,R5	;-1 means function, -3 means array element
	BLS	RECURSIVE
REA2:
	CBITB	0,*+SIGN-$	;test & clear sign
	BFC	REA0:B
	CMPB	14H,R5	;see if immed.
	BNE	REA1:B
	NEGD	R6,R6	;negate before compiling
REA0:
	CBITB	31,R5	;clear sign bit for pos.
	BR	EXP3:B
REA1:
	SBITB	31,R5	;set sign bit for neg.
EXP3:	;here we have finished getting operand by whatever method
	SAVE	[R6]	;we now prepare to look for an operator
	BSR	FIND1	;find next non-space
	MOVD	R2,R3	;text pointer
	ADDR	OPTABLE,R1
	MOVQB	5,R4	;counter
	MOVQD	3,R0	;look for 3-char string
	BR	OPER3:B
OPER2:
	MOVQD	2,R0	;look for 2-char strings
OPER3:
	MOVD	R3,R2	;text pointer
	CMPSB
	BEQ	OPFOUND:B
	ADDD	R0,R1
	ADDQD	4,R1	;point to next table entry
	ACBB	-1,R4,OPER2
	ADDQD	1,R1
	MOVD	R3,R2
	ADDQD	1,R2	;point to start of 1-char strings
	MOVB	8,R4	;count
OPER1:
	CMPB	-1(R2),-1(R1)
	BEQ	OPFOUND:B
	ADDQD	5,R1	;point to next table entry
	ACBB	-1,R4,OPER1
	RESTORE	[R6]	;no operator found
	BR	FINUP:W	;goto finish-up
OPFOUND:
	MOVD	0(R1),R3	;get addr of routine for this operator
	SUBD	R6,R2
	MOVD	R2,TO_INL	;store the text pointer
	RESTORE	[R6]
	CMPQB	0,*+AEMPTY-$	;see if accum clean
	BNE	EXP15:W
	ADDR	NULL,TOS
	CMPD	TOS,4(SP)	;see if first operand
	BNE	EXP11:B
	SAVE	[R5,R6]	;save first operand descriptors
	BR	EXP14:B
EXP11:	;arrive here if operator found after second operand
	RESTORE	[R4]	;remember first operator
	MOVD	R5,R0	;move second operand descriptors
	MOVD	R6,R1
	RESTORE	[R5,R6]	;get first operand
	SAVE	[R4]	;save first operator
	SAVE	[R0,R1,R3]	;save second operand & second operator
	BSR	ALOAD	;compile code to load 1st operand into accum
	RESTORE	[R3]	;second operator
	RESTORE	[R5,R6]	;second operand
	BR	EXP15:B
EXP13:
	RESTORE	[R5,R6]	;get stacked operand designators
	SBITB	30,R5	;reverse flag
EXP12:
	SAVE	[R3]	;save new operator
	JSR	R4	;execute old operator & current operand
	RESTORE	[R3]
	RESTORE	[R4]	;check for stacked operations of higher or equal precedence
	CMPB	-1(R4),-1(R3)
	BHS	EXP13
	SAVE	[R4]	;put it back if we didn't use it
EXP14:
	SAVE	[R3]	;save new operator
	BR	EXP2	;go back to get another operand
EXP15:
	RESTORE	[R4]
	CMPB	-1(R3),-1(R4)	;compare pecedence of old & new operators
	BLS	EXP12	;jump to execute old operator & current operand
	MOVD	17H,R2	;we stack the operation if new operator has high pecedence
	SAVE	[R2,R3,R4]	;R4=old operation, R2=TOS operand, R3=junk
	SAVE	[R3]	;new operator
	BSR	SAVACC	;compile code to push accum.
	BSR	ALOAD	;compile code to load current operand into accum.
	BR	EXP2	;go back for another operand
FINUP:	;finish up expression
	CMPQB	0,*+AEMPTY-$	;see if accum clean
	BNE	FIN4:B
	ADDR	NULL,TOS
	CMPD	TOS,4(SP)	;accum clean & nothing on stack means one-operand expr.
	BNE	FIN1:B
FIN5:
	MOVQD	1,R1	;return a '1' for one-operand expression
	ADJSPB	-4
	RET	0
FIN4:
	RESTORE	[R4]
	ADDR	ALOAD,TOS
	CMPD	TOS,R4	;'ALOAD' on stack & accum dirty means we have an uncompiled
	BEQ	FIN5	;one-operand expression (probably and array element)
	BR	FIN3:B
FIN1:
	ADDR	NULL,TOS
	CMPD	TOS,16(SP)
	BNE	FIN2:B
	MOVQD	2,R1	;return a '2' for uncompiled two-operand expression
	RESTORE	[R2]	;operator
	RESTORE	[R3,R4]	;1st operand designators
	ADJSPB	-4
	RET	0
FIN2:	;we probably can't get here (>2 operands & accum clean)
	ADDR	ALOAD,R4	;operator to load most recent operand
FIN3:
	JSR	R4	;compile code to execute pending operation
	RESTORE	[R4]	;compile code to execute all stacked operations
	ADDR	NULL,TOS
	CMPD	TOS,R4
	BEQ	FIN0:B
	RESTORE	[R5,R6]
	SBITB	30,R5	;set reverse bit
	BR	FIN3
FIN0:
	MOVQD	0,R1	;return a '0' for 'expr. compiled & result is in accum'
	MOVD	*+ACCUM-$,R5	;make accum the new source
	MOVD	*+ACCUM+4-$,R6
	RET	0
DISP:	;compile value in R1 in 32000 disp format
	BSR	RELDISP
DIS1:
	MOVD	R2,DPL
	RET	0
DISP4:	;compile value in R1 in 32000 4-byte disp format
	BSR	SBC4
	BR	DIS1
BHEADER:
	BSR	QRUN
	MOVQB	1,INEXPR	;make new word conform to BASIC syntax
	BSR	HEADER
	MOVQB	0,INEXPR
	BR	IMMED
VARHEAD:
	BSR	BHEADER
ALIGN:	;align compiled code by compiling a NOP if necessary
	TBITB	0,DPL
	BFC	ALI0:B
	BSR	COMPILE
	DB	1,0A2H
ALI0:
	RET	0

GETDIM:	;used in array delarations to get index limits
	MOVD	DPL,R2
	MOVD	R2,R6	;dest addr for assign. statement
	SAVE	[R6]
	ADDQD	4,R2
	MOVD	R2,DPL	;anticipate new dict pointer after # stored
	MOVD	R2,PSTART
	MOVD	15H,R5	;abs addr mode for dest. of assig. statement
	BSR	DEFI20	;compile assignment statement
	BSR	QRUN	;execute the compiled code
	RESTORE	[R0]	;addr of dim.
	MOVD	0(R0),R6	;get dim.
	ADDQD	1,R6	;# of array elements is 1 greater than index limit
	MOVD	R6,0(R0)
	RET	0


	DB	6,'DEFSTR'
	DW	BL-$
BL	SET	$-9
	MOVW	0DCH,TOS	;indexed mode [Rn:B]
	BR	AHEADER:B
	DB	6,'DIMINT'
	DW	BL-$
BL	SET	$-9
	MOVW	1EH,TOS	;indexed mode [Rn:D]
	BR	AHEADER:B
	DB	6,'DIMDBL'
	DW	BL-$
BL	SET	$-9
	MOVW	1FH,TOS	;indexed mode [Rn:Q]
AHEADER:
	BSR	VARHEAD	;compile a FORTH header in dictionary using next word
	ADDR	DIM5,R1	;addr of generic executable code for arrays & strings
	BSR	SBCOMMA	;compile a BSR to addr in R1
	MOVB	*+REGBYTE-$,R0	;check for availability of registers for reg. variable
	CMPQB	5,R0
	BLO	NONREG:B
	MOVB	R0,4(R2)	;compile reg addressing code into heading
	ADDQB	1,R0
	MOVB	R0,*+REGBYTE-$
	BR	DEFI6:B
NONREG:
	MOVB	15H,4(R2)	;compile abs addressing code into heading
DEFI6:
	MOVB	0(SP),5(R2)	;indexed mode byte into header
	BSR	DIM0:B
	BSR	LOOK
	DB	81H,','
	DB	AHEADER-($+1)	;H'CE
{ BSR AHEADER }
	ADJSPB	-2	;drop 'index mode' from stack
	RET	0
DIME:
	BR	SYNERR
DIM0:
	ADDQD	6,R2
	SAVE	[R2]	;save addr of #-of-dimesions byte
	MOVQB	0,0(R2)	;init count of #-of-dimensions
	ADDQD	1,R2
	MOVD	R2,DPL
	BSR	LOOK
	DB	1,'('	;array or string declaration must have '('
	DB	DIME-($+1)	;H'E8
{ BSR DIME }
	BSR	GETDIM	;get 1st dimension
DIM2:
	SAVE	[R6]	;remember size of each dimension
	BSR	LOOK
	DB	1,','
	DB	DIM1-($+1)	;H'E
{ BSR DIM1         ;jump to DIM1 if no more dims. }
	MOVD	4(SP),R2	;addr of #-of-dimensions
	ADDQB	1,0(R2)	;incr #-of-dimensions
	BSR	GETDIM	;get next dimension
	MULD	TOS,R6	;partial product of dim sizes
	BR	DIM2
DIM1:
	RESTORE	[R6]	;product of all dim. sizes
	RESTORE	[R2]	;addr of #-of-dimesions
	MOVZBD	-2(R2),R1	;basemode
	MOVQD	5,R0
	SUBD	R1,R0
	BCS	DIMC:B	;carry set means basemode not reg.
	MOVD	DPL,REGLIST[R0:D]	;init reg with array addr.
DIMC:
	TBITB	1,-1(R2)	;see if byte array
	BFC	DIMB:B	;avoid *4 if byte array or word array
	ADDD	R6,R6
	ADDD	R6,R6	;*4 for 32-bit-element array
DIMB:
	TBITB	0,-1(R2)
	BFC	DIMD:B
	ADDD	R6,R6	;*8 for reals, *2 for word-size array
DIMD:
	MOVD	R6,-6(R2)	;store length
	ADDD	R6,DPL	;allocate space for array
	MOVD	R2,R6	;save addr. in R6
	BSR	LOOK
	DB	1,')'
	DB	DIM3-($+1)	;H'20
{ BSR DIM3         ;error if no ')' }
	MOVD	DPL,PSTART ;update start-of-program pointer
	BSR	LOOK
	DB	1,'='
	DB	DIMF-($+1)	;H'E
{ BSR DIMF }
	ADDQD	-6,R6	;addr. of lenth
	BSR	STR21	;compile a string assignment statement
	BSR	QRUN	;execute it
DIMF:
	RET	0
DIM3:
	BR	SYNERR
INDERRM:
	DB	11,'Index Error'
	DB	6,'DEFDBL'
	DW	BL-$
BL	SET	$-9
DEFDBL:	;declare one or more double precision float variables
	BSR	VARHEAD	;compile a variable heading
	ADDR	DBL1,R1	;addr of generic executable code for flt variables
	BSR	SBCOMMA	;compile a BSR to addr in R1
	ADDQD	1,R2	;addr. of var space
	MOVZBD	REGDBL,R0	;check availability of registers for reg. variables
	CMPQB	5,R0
	BLO	DNONREG:B
	MOVB	R0,-1(R2)	;compile reg. addr mode byte into heading
	MOVD	R0,R5	;anticipate assignment statement
	MOVQD	0,R6	;ditto
	ADDQB	2,R0	;update reg. availability
	MOVB	R0,REGDBL
	BR	DBL2:B
DNONREG:
	MOVD	15H,R5	;abs. addr. mode
	MOVD	R2,R6	;addr of var. (if abs mode)
	MOVB	R5,-1(R2)	;compile abs addressing mode byte into heading
	ADDQD	4,R2
	ADDQD	4,R2
DBL2:
	MOVD	R2,DPL
	MOVD	R2,PSTART
	BSR	LOOK
	DB	1,'='	;check for assignment statement in definition
	DB	DBL3-($+1)	;H'10
{ BSR DBL3 }
	SBITB	16,R5	;'real' flag
	BSR	DEFI20	;compile assignment statement
	BSR	QRUN	;execute assignment statement
DBL3:
	BSR	LOOK
	DB	81H,','
	DB	DEFDBL-($+1)	;H'9F
{ BSR DEFDBL }
	RET	0
	DB	6,'DEFINT'
	DW	BL-$
BL	SET	$-9
DEFINT:	;declare one or more integer variables
	BSR	VARHEAD	;compile a variable heading
	ADDR	DEFI1,R1	;addr of generic executable code for int variables
	BSR	SBCOMMA	;compile a BSR to addr in R1
	ADDQD	1,R2	;addr. of var space
	MOVZBD	REGBYTE,R0	;check availability of registers for reg. variables
	CMPQB	5,R0
	BLO	INONREG:B
	MOVB	R0,-1(R2)	;compile reg. addr mode byte into heading
	MOVD	R0,R5	;anticipate assignment statement
	MOVQD	0,R6	;ditto
	ADDQB	1,R0	;update reg. availability
	MOVB	R0,REGBYTE
	BR	DEFIA:B
INONREG:
	MOVD	15H,R5	;abs. addr. mode
	MOVD	R2,R6	;addr of var. (if abs mode)
	MOVB	R5,-1(R2)	;compile abs addressing mode byte into heading
	ADDQD	4,R2
DEFIA:
	MOVD	R2,DPL
	MOVD	R2,PSTART
	BSR	LOOK
	DB	1,'='	;check for assignment statement in definition
	DB	DEFIB-($+1)	;H'C
{ BSR DEFIB }
	BSR	DEFI20	;compile assignment statement
	BSR	QRUN	;execute assignment statement
DEFIB:
	BSR	LOOK
	DB	81H,','
	DB	DEFINT-($+1)	;H'A5
{ BSR DEFINT }
	RET	0
PRINT:	;run-time routine to print an integer held in R6
	SAVE	[R0,R1,R2,R3,R4,R5]
	ADDR	TIBL+80H,R2
	MOVD	R6,R3
	ABSD	R3,R1
	MOVQD	0,R4
	BSR	PERI1
	RESTORE	[R0,R1,R2,R3,R4,R5]
	RET	0

PRIN4:	;routine to compile a literal string handler & string
	ADDQD	1,R2
	SUBD	R6,R2
	MOVD	R2,TO_INL
	MOVB	R0,R6
	MOVQB	0,WFLAG	;0 makes scanner accept all printable chars
	BSR	PQU1
	MOVQB	1,WFLAG	;1 makes scanner look for BASIC identifiers
	RET	0


	DB	5,'PRINT'
	DW	BL-$
BL	SET	$-8
PRIN1:
	BSR	STRDEL:W	;check for string delimiter
	BEQ	PRIN3:B
	MOVQD	6,R5	;make R6 the destination
	MOVQD	0,R6
	BSR	DEFI20	;do an assignment statement
	ADDR	PRINT,R1
	BSR	SBCOMMA	;compile a BSR to run-time code to print R6 value
	BR	PRIN2:B
PRIN3:
	ADDR	PQUOTE,R1	;addr of literal handler to print a string
	BSR	PRIN4	;compile BSR to R1 & compile string
	BSR	LOOK
	DB	81H,'+'	;for strings, treat '+' same as ';'
	DB	PRIN1-($+1)	;H'D4
{ BSR PRIN1 }
PRIN2:
	BSR	LOOK
	DB	81H,';'	;';' means print next item without space
	DB	PRIN1-($+1)	;H'CE
{ BSR PRIN1 }
	BSR	LOOK
	DB	81H,','	;',' means print space then next item
	DB	PRIN5-($+1)	;H'2
{ BSR PRIN5 }
	RET	0
PRIN5:
	ADDR	SPACE,R1
	BSR	SBCOMMA
	BR	PRIN1
STRDEL:	;check for string delimiter " ' ` ~ | ^
	BSR	FIND1
	BR	STRD1

PQUOTE:	;run-time code to print a string that follows the call
	RESTORE	[R6]	;string address
	SAVE	[R0,R1,R2,R4]	;protect register variables
	MOVD	R6,TOS
	BSR	STYPE		;print the string
	MOVD	TOS,R2
	MOVD	R2,R6
	RESTORE	[R0,R1,R2,R4]
	JUMP	1(R6)
SPACE:	;run-time code to print a space
	BSR	PQUOTE
	DB	1,' '
	RET	0
	DB	7,'STRING$'
	DW	BL-$
BL	SET	$-10
	BSR	LOOK
	DB	1,'('
	DB	ST$E-($+1)	;H'45
{ BSR ST$E }
	MOVQD	0,*+ACCUM-$	;make R0 the accum
	MOVQD	0,*+ACCUM+4-$
	BSR	EXPRESS	;get # of bytes into R0
	BSR	LOOK
	DB	1,','	;error if no ','
	DB	ST$E-($+1)	;H'34
{ BSR ST$E }
	BSR	LOOK
	DB	1,'"'
	DB	ST$1-($+1)	;H'31
{ BSR ST$1 }
	ADDQD	-2,R7
	MOVB	'"',0(R7)
	BSR	FINDWRD	;find char after first '"'
	MOVB	0(R2),R6	;get char into R6
	ADDQD	1,TO_INL	;advance test pointer
	MOVZBD	0D4H,R5	;make source immed mode & byte length
	MOVZBD	0C6H,R3	;make destination R6 & byte length
	BSR	XLOAD ;compile code to move char into R6 at run time.
	BSR	LOOK
	DB	1,'"'	;error if no closing '"'
	DB	ST$E-($+1)	;H'5
{ BSR ST$E }
	BR	ST$2
ST$E:
	BR	SYNERR
ST$1:
	MOVD	0C6H,*+ACCUM-$	;make accum R6 & byte length
	MOVQD	0,*+ACCUM+4-$
	BSR	EXPRESS	;get the number into R6
ST$2:
	BSR	LOOK
	DB	1,')'	;error if no ')'
	DB	ST$E-($+1)	;H'EA
{ BSR ST$E }
	MOVQD	6,*+ACCUM-$	;put accum designators back to normal
	MOVQD	0,*+ACCUM+4-$
	ADDR	FIL2,R1	;addr of run-time code to fill a block at addr of R2 and
	BR	SBCOMMA	;   length of R0 with bytes of R6
	DB	4,'THEN'
	DW	BL-$
BL	SET	$-7
	RET	0
	ALIGN	2	;same as in prev. modules
LINK4B1	EQU	BL-$	;to link next module
