B4B0:	MODULE

;INCLUDE 4CON.ASM
;INCLUDE MACLIB.ASM
;LIST ON
;MACLIST OFF
;  BASIC for the 32000 processor
;by Neil R. Koozer              July 29, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709
;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.
;  September 20, 1985      November 19, 1985
;  November 26, 1985       January 9, 1986      January 31, 1986

	EXTRN	F432,F433,F434,B4B0,B4B1,B4B2
	GLOBAL	COMPILE,DEFI20,ALOAD,ADD,XLOAD,ATAIL,COMPARE,DUM1,DBL1,MULT
	GLOBAL	NE,DEFI2,ACOMPAR,SAVACC,OPTABLE,DEFI21,NEGACC,DIM5,DEFI1
	GLOBAL	LINK4B0,STR21
	EXTRN	BASEL,CONTEXL,CURRENTL,WFLAG,BVOC,DPL,DISP,FINDWRD,ERR1,LINK434
	EXTRN	TO_INL,SYNERR,EXP0,OFFSET,INTERP1,DICT,STYPE,QUIT,CURBUF,BUFBLK
	EXTRN	LOAD,ACCUM,AEMPTY,LOOK,REGBYTE,PSTART,PRIN4,STRDEL,INEXPR

	DB	3,'RUN'
	DW	LINK434-$	;link to previous module
BL	SET	$-6
	MOVXBD	CURBUF,R0
	ADDR	BUFBLK,R1
	MOVW	-2(R1)[R0:W],-4(R7)	;push current block # to data stack
	ADDQD	-4,R7
	BR	LOAD
COMPILE:
	RESTORE	[R1]	;use ret addr for pointer to code after the call
	MOVZBD	0(R1),R0	;# of bytes to be compiled
	ADDQD	1,R1	;increment past the count byte
	MOVD	DPL,R2	;destination of move is the dictionary
	MOVSB
	MOVD	R2,DPL	;store new value of dict. pointer
	JUMP	R1	;R1 is now the proper return addr.
SAVACC:	;compile code to push the accumulator
	SAVE	[R4,R5,R6]
	MOVD	ACCUM,R5
	MOVD	ACCUM+4,R6
	MOVD	R5,R3	;get int/flt flag
	MOVW	17H,R3	;make dest. TOS
	BSR	XLOAD:W
	RESTORE	[R4,R5,R6]
	RET	0
ATAIL:
	MOVD	ACCUM,R3	;make the accum. the destination
	MOVD	ACCUM+4,R4
TAIL:	;insert addressing mode bits into instructions that
	;have just been compiled using R0 for both the source
	;and destination
	MOVB	R5,R0	;get size bits for source
	ORB	R3,R0	;OR the size bits for dest.
	COMB	R0,R0	;polarity was backwards so the smaller operand would
	;determine size of operation
	LSHB	-6,R0	;get the bits where they belong
	ORB	R0,-2(R2)	;put the size bits (for B,W,D) into compiled instruction
	MOVB	R0,TOS
	ANDB	1FH,R5	;erase all but the addressing mode bits
	ANDB	1FH,R3
	MOVZBW	R3,R0	;get a copy with high byte of word all zeros
	ROTW	6,R0
	ORW	R0,-2(R2)	;put dest. bits into the compiled opcode
	MOVZBW	R5,R0
	ROTW	-5,R0
	ORW	R0,-2(R2)	;put source bits into the compiled opcode
	CMPB	R5,1CH	;check source for indexed addr. mode
	BLO	TAIL1:B
	ROTW	-8,R5	;get the index byte
	MOVB	R5,0(R2)	;compile index byte
	ADDQD	1,R2
	LSHB	-3,R5	;move basemode bits to the right for later use
TAIL1:
	CMPB	R3,1CH	;check dest. for indexed addr. mode
	BLO	TAIL2:B
	ROTW	-8,R3	;get index byte
	MOVB	R3,0(R2)	;compile index byte
	ADDQD	1,R2
	LSHB	-3,R3	;move basemode bits to the right for later use
TAIL2:
	MOVB	TOS,R0
	BSR	TAIL3:B	;append addressing extensions for source
	MOVD	R3,R5	;now the addressing extensions for dest.
	MOVD	R4,R6
	CMPB	14H,R5
	BEQ	BADADD:B	;immed. not allowed for dest.
TAIL3:
	MOVZBD	R5,R5
	CMPB	1CH,R5	;scaled indexing already taken care of
	BHI	TAIL4:B
BADADD:
	ADDR	BADDMSG,R2
	BR	ERR1
TAIL4:
	CASEB	MTABLE[R5:B]
VARR2:
	BSR	VARR1:B
	MOVQD	0,R6
VARR1:
	MOVD	R6,R1
	BR	DISP
IMM:
	CMPQB	3,R0	;3 means D size operation
	BEQ	COMPIM4:B
	MOVB	R6,0(R2)	;if not D, assume it's B
	ADDQD	1,R2
TAIL6:
	MOVD	R2,DPL
	RET	0
REVERS4:
	ROTW	8,R6
	ROTD	16,R6
	ROTW	8,R6
	RET	0
COMPIM4:
	BSR	REVERS4
	MOVD	R6,0(R2)
	ADDQD	4,R2
	BR	TAIL6
MTABLE:
	DB	TAIL6-TAIL4	;register
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	TAIL6-TAIL4
	DB	VARR1-TAIL4	;register relative
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR2-TAIL4	;memory relative
	DB	VARR2-TAIL4
	DB	VARR2-TAIL4
	DB	BADADD-TAIL4	;reserved
	DB	IMM-TAIL4	;immediate
	DB	VARR1-TAIL4	;absolute
	DB	VARR2-TAIL4	;external
	DB	TAIL6-TAIL4	;TOS
	DB	VARR1-TAIL4	;memory space
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
	DB	VARR1-TAIL4
BADDMSG:
	DB	19,'Bad addressing mode'
AQTAIL:
	MOVD	ACCUM,R3
	MOVD	ACCUM+4,R4
QTAIL:	;insert a 'quick' type of operand
	ANDW	0FH,R6
	LSHW	7,R6
	ORW	R6,-2(R2)
	MOVD	R3,R5	;put dest. bits where the source bits usually go
	MOVD	R4,R6
	ANDD	0C0H,R3	;dummy dest. to prevent TAIL from inserting anything
	BR	TAIL
NEGACC:	;compile code to negate the accum.
	SAVE	[R5,R6]
	MOVD	ACCUM,R5
	MOVD	ACCUM+4,R6
	TBITB	16,R5	;see if flt
	BFS	NEG1:B
	BSR	COMPILE
	DB	3
	NEGB	R0,R0
	BR	NEG2:B
NEG1:
	BSR	COMPILE
	DB	3
	NEGL	F0,F0
NEG2:
	BSR	ATAIL
	RESTORE	[R5,R6]
	RET	0
MIXMATCH:	;automatic type conversion
	MOVD	R5,R1
	MOVD	R3,R0
	MOVQW	0,R0
	ROTD	-16,R1
	ROTD	-12,R0
	ORB	R1,R0	;type flags now in one byte, R0
	CMPQB	0,R0	;0 means int->int
	BNE	MIX5:B
	RET	0
MIX5:
	CMPB	11H,R0	;11h means flt->flt
	BNE	MIX6:B
MIX7:
	CMPB	17H,R5	;see if TOS
	BNE	MIX0:B
	BSR	COMPILE	;convert TOS to stack memory mode because my CPU/FPU
	DB	3	;has a defect that messes up long float operations if the
	ADJSPB	-8	;source is TOS
	MOVW	19H,R5
	MOVQD	-8,R6
MIX0:
	MOVB	11H,R0	;flag for flt->flt operation
	ORB	0C0H,R5	;prevent TAIL from messing up flt format
	ORB	0C0H,R3
	RET	0
MIX6:
	CMPQB	1,R0	;1 means convert dest. to flt then flt->flt
	BNE	MIX1:W
	TBITB	8,R0	;bit-8 set means dest. has hard control of type
	BFS	MIX2:W
	CMPW	R3,ACCUM	;dest must be accum
	BNE	TYPERR:W
	CMPD	R4,ACCUM+4
	BNE	TYPERR:W
	SBITB	16,R3	;set flt flag of dest.
	MOVD	R3,ACCUM	;make accum flt
	ADDR	XLO0,TOS
	CMPD	TOS,4(SP)	;see if called from XLOAD
	BEQ	MIX7
	SAVE	[R5,R6]	;source designators
	MOVD	R3,R5
	MOVD	R4,R6
	BSR	COMPILE
	DB	3
	MOVBL	R0,F0	;convert dest. to flt
	BSR	TAIL
	RESTORE	[R5,R6]
	BR	MIX7
MIX9:	;convert source to int. and put on stack
	SAVE	[R3,R4,R5]
	MOVD	17H,R3	;make dest. TOS
	BSR	COMPILE
	DB	3
	ROUNDLB	F0,R0
	BSR	TAIL
	RESTORE	[R3,R4,R5]
	MOVW	17H,R5	;make the new source TOS
	MOVQB	0,R0	;make the new type-of-operation int->int
MIX4:
	RET	0
MIX2:
	ADDR	XLO0,TOS
	CMPD	TOS,4(SP)	;see if called from XLOAD
	BNE	MIX9
	TBITB	31,R5	;see if neg.
	BFS	MIX9
	BSR	COMPILE	;on a load, we can covert directly into the dest.
	DB	3
	ROUNDLB	F0,R0
	ADJSPB	-4	;drop return to XLOAD
	BR	TAIL
MIX8:	;convert source to flt & put on stack
	SAVE	[R3,R4,R5]	;save final dest.
	MOVD	17H,R3	;make interim dest TOS
	BSR	COMPILE
	DB	3
	MOVBL	R0,F0
	BSR	TAIL
	RESTORE	[R3,R4,R5]
	MOVW	17H,R5	;make new source TOS
	SBITB	16,R5	;make it flt
	BR	MIX7
MIX1:
	CMPB	10H,R0	;10h means source is int & dest is flt
	BNE	MIX4
	ADDR	XLO0,TOS
	CMPD	TOS,4(SP)	;see if called from XLOAD
	BNE	MIX8
	TBITB	31,R5	;see if neg.
	BFS	MIX8
	BSR	COMPILE	;in a load, we convert directly into dest.
	DB	3
	MOVBL	R0,F0
	ADJSPB	-4	;drop the return to XLOAD
	BR	TAIL
	DB	5
ADD:
	CMPB	14H,R5	;see if immed.
	BNE	ADD2:B
ADDIMM:
	CMPQD	7,R6
	BLT	ADD1:B
	CMPQD	-8,R6
	BGT	ADD1:B
ADDQ:
	BSR	COMPILE
	DB	2
	ADDQB	0,R0
	BR	AQTAIL
ADD2:
	TBITB	31,R5	;see if neg.
	BFS	SUB1:W
ADD1:
	BSR	MIXMATCH
	CMPQB	0,R0
	BNE	ADDFLT:B
	BSR	COMPILE	;integer addition
	DB	2
	ADDB	R0,R0
	BR	ATAIL
ADDFLT:
	CMPB	11H,R0
	BNE	TYPERR
	BSR	COMPILE	;flt addition
	DB	3
	ADDL	F0,F0
	BR	ATAIL
	DB	5
SUBTR:
	TBITB	30,R5	;see if reverse
	BFC	SUB2:B
	BSR	NEGACC
	BR	ADD
SUB2:
	CMPB	14H,R5	;see if immed.
	BNE	SUB3:B
	NEGD	R6,R6	;negate immed. value before compiling
	BR	ADDIMM	;   then add
SUB3:
	TBITB	31,R5	;see if source is neg.
	BFS	ADD1
SUB1:
	BSR	MIXMATCH	;automatic type conversion
	CMPQB	0,R0
	BNE	SUBFLT:B
	BSR	COMPILE	;integer subtraction
	DB	2
	SUBB	R0,R0
	BR	ATAIL
SUBFLT:
	CMPB	11H,R0
	BNE	TYPERR
	BSR	COMPILE	;flt subtraction
	DB	3
	SUBL	F0,F0
	BR	ATAIL
	DB	6
MULT:
	TBITB	31,R5
	BFC	MUL1:B
	BSR	NEGACC
MUL1:
	BSR	MIXMATCH
	CMPQB	0,R0
	BNE	MULFLT:B
	BSR	COMPILE
	DB	3
	MULB	R0,R0
	BR	ATAIL
MULFLT:
	CMPB	11H,R0
	BNE	TYPERR
	BSR	COMPILE
	DB	3
	MULL	F0,F0
	BR	ATAIL
	DB	6
DIVIDE:
	TBITB	31,R5
	BFC	DIV0:B
	BSR	NEGACC
DIV0:
	TBITB	30,R5	;see if reverse
	BFC	DIV1:B
	BSR	SAVACC
	BSR	ALOAD
	MOVD	17H,R5
DIV1:
	BSR	MIXMATCH
	CMPQB	0,R0
	BNE	DIVFLT:B
	BSR	COMPILE
	DB	3
	QUOB	R0,R0
	BR	ATAIL
DIVFLT:
	CMPB	11H,R0
	BNE	TYPERR
	BSR	COMPILE
	DB	3
	DIVL	F0,F0
	BR	ATAIL
ACOMPAR:
	MOVD	ACCUM,R3
	MOVD	ACCUM+4,R4
COMPARE:
	BSR	MIXMATCH
	CMPQB	0,R0
	BNE	COMP2:B
	CMPB	14H,R5
	BNE	COMP1:B
	CMPQD	7,R6
	BLT	COMP1:B
	CMPQD	-8,R6
	BGT	COMP1:B
	BSR	COMPILE
	DB	2
	CMPQB	0,R0
	BR	QTAIL
COMP1:
	BSR	COMPILE
	DB	2
	CMPB	R0,R0
	BR	TAIL
COMP2:
	CMPB	11H,R0
	BNE	COMP3:B
	BSR	COMPILE
	DB	3
	CMPL	F0,F0
	BR	TAIL
COMP3:
	BR	TYPERR
	BR	LE4:W
GT4:
	BSR	COMPILE:W
	DB	3
	BGE	$
	DB	'N'
	RET	0
	DB	4
GT:
	TBITB	31,R5
	BFC	GT2:B
	BSR	NEGACC
	BR	LT2:W
GT2:
	TBITB	30,R5
	BFS	LT1:W
GT1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SLTD	R0
GT3:
	CBITB	16,ACCUM	;make accum. integer
	MOVD	ACCUM,R5
	MOVD	ACCUM+4,R6
	MOVQD	0,R3	;dummy dest.
	BR	TAIL
	BR	GE4:W
LT4:
	BSR	COMPILE:W
	DB	3
	BLE	$
	DB	'N'
	RET	0
	DB	4
LT:
	TBITB	31,R5
	BFC	LT2:B
	BSR	NEGACC
	BR	GT2:B
LT2:
	TBITB	30,R5
	BFS	GT1:B
LT1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SGTD	R0
	BR	GT3
	BR	LT4:W
GE4:
	BSR	COMPILE:W
	DB	3
	BGT	$
	DB	'K'
	RET	0
	DB	4
GE:
	TBITB	31,R5
	BFC	GE2:B
	BSR	NEGACC
	BR	LE2:B
GE2:
	TBITB	30,R5
	BFS	LE1:B
GE1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SLED	R0
	BR	GT3
	BR	GT4:W
LE4:
	BSR	COMPILE:W
	DB	3
	BLT	$
	DB	'K'
	RET	0
	DB	4
LE:
	TBITB	31,R5
	BFC	LE2:B
	BSR	NEGACC
	BR	GE2:B
LE2:
	TBITB	30,R5
	BFS	GE1:B
LE1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SGED	R0
	BR	GT3
	BR	NE4:W
EQ4:
	BSR	COMPILE:W
	DB	3
	BNE	$
	DB	'N'
	RET	0
	DB	4
EQ:
	TBITB	31,R5
	BFC	EQ1:B
	BSR	NEGACC
EQ1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SEQD	R0
	BR	GT3
	BR	EQ4:W
NE4:
	BSR	COMPILE:W
	DB	3
	BEQ	$
	DB	'K'
	RET	0
	DB	4
NE:
	TBITB	31,R5
	BFC	NE1:B
	BSR	NEGACC
NE1:
	BSR	ACOMPAR
	BSR	COMPILE
	DB	2
	SNED	R0
	BR	GT3
	DB	8
ALOAD:
	MOVD	ACCUM,R3
	MOVD	ACCUM+4,R4
	MOVQB	1,AEMPTY
XLOAD:
	BSR	MIXMATCH
XLO0:
	CMPQB	0,R0	;0 means int->int
	BNE	XLO1:W
	CMPB	14H,R5	;see if immed.
	BNE	LOAD2:B
	CMPQD	7,R6
	BLT	LOAD1:B
	CMPQD	-8,R6
	BGT	LOAD1:B
	BSR	COMPILE
	DB	2
	MOVQB	0,R0
	BR	QTAIL
LOAD1:
	CMPB	3FH,R3
	BLO	LDPOS:B	;jump if dest. not 32-bit size
	BSR	COMPILE
	DB	2
	ADDR	R0,R0	;use ADDR in place of MOVD immed.
	MOVB	15H,R5
	BR	TAIL
LOAD2:	;here's the normal case
	TBITB	31,R5	;see if neg.
	BFC	LDPOS:B
	BSR	COMPILE
	DB	3
	NEGB	R0,R0
	BR	TAIL
LDPOS:
	CMPW	R3,R5	;skip the load if source and dest. are the same place
	BNE	LOAD3:B
	CMPD	R4,R6
	BNE	LOAD3:B
	RET	0
LOAD3:
	CMPB	3FH,R5
	BHS	LOAD4:B	;jump if source is D
	CMPB	3FH,R3
	BLO	LOAD5:B	;jump if dest. is not D
	BSR	COMPILE	;compile B->D or W->D
	DB	3
	MOVZBD	R0,R0
	BR	TAIL
LOAD5:	;source not D
	CMPB	0BFH,R5
	BHS	LOAD4:B	;jump if source is W
	CMPB	0BFH,R3
	BLO	LOAD4:B	;jump if dest. is not B
	BSR	COMPILE	;compile B->W
	DB	3
	MOVZBW	R0,R0
	BR	TAIL
LOAD4:	;here the operation will be the size of the smaller operand
	BSR	COMPILE
	DB	2
	MOVB	R0,R0
	BR	TAIL
XLO1:
	CMPB	11H,R0	;11h means flt->flt
	BNE	XLO2:B
	TBITB	31,R5	;see if neg.
	BFC	LDF1:B
	BSR	COMPILE
	DB	3
	NEGL	F0,F0
	BR	TAIL
LDF1:
	CMPW	R3,R5
	BNE	LDF2:B
	CMPD	R4,R6
	BNE	LDF2:B
	RET	0	;skip load if source and dest are same
LDF2:
	BSR	COMPILE
	DB	3
	MOVL	F0,F0
	BR	TAIL
XLO2:
TYPERR:
	ADDR	TYPEMSG,R2
	BR	ERR1
TYPEMSG:
	DB	13,'Type Mismatch'
	DB	1
OR:
	TBITB	31,R5
	BFC	OR1:B
	BSR	SAVACC
	BSR	COMPILE
	DB	3
	NEGB	R0,R0
	BSR	ATAIL
	MOVD	17H,R5
OR1:
	BSR	COMPILE
	DB	2
	ORB	R0,R0
	BR	ATAIL
	DB	2
AND:
	TBITB	31,R5
	BFC	AND1:B
	BSR	SAVACC
	BSR	COMPILE
	DB	3
	NEGB	R0,R0
	BSR	ATAIL
	MOVD	17H,R5
AND1:
	BSR	COMPILE
	DB	2
	ANDB	R0,R0
	BR	ATAIL
	DB	3
NOT:
	BSR	COMPILE
	DB	3
	COMB	R0,R0
	MOVD	ACCUM,R5
	MOVD	ACCUM+4,R6
	BSR	ATAIL
	RESTORE	[R0]	;return addr
	CMPQD	0,TOS	;sign
	BEQ	NOT1:B
	BSR	NEGACC
NOT1:
	RESTORE	[R4,R5,R6]	;get stacked operation
	SAVE	[R0]	;return addr
	SBITB	30,R5	;set reverse flag
	JUMP	R4	;execute pending operation
DEFI5:	BR	SYNERR
DBL1:	;execution of an flt variable comes here
	MOVD	10000H,R5	;flt flag
	BR	DEFI11:B
DEFI1:	;execution of an int variable comes here
	MOVQD	0,R5
DEFI11:
	MOVD	TOS,R6	;use ret addr for a data pointer
	ADDB	0(R6),R5	;get addressing mode of variable
	ADDQD	1,R6	;R6 = addr of variable
	CMPQW	5,R5	;see if register variable
	BLO	DUM1:B
	MOVQD	0,R6	;0 if reg var
DUM1:
	CBITB	0,INEXPR	;0 = assignment statement
	BFS	DEFI0:W	;1 = 'within expression'
DEFI2:
	BSR	LOOK
	DB	1,'='
	DB	DEFI5-($+1)	;H'CF
{	BSR	DEFI5       ;syntax error if no '=' }
DEFI20:
	MOVQD	6,ACCUM	;make R6 the accumulator
	MOVQD	0,ACCUM+4
DEFI21:
	SAVE	[R5,R6]	;save destination
	CMPQW	5,R5	;see if register-variable
	BLO	DEFI22:B
	MOVD	R5,ACCUM	;make our reg. var. the accumulator
	MOVQD	0,ACCUM+4
DEFI22:
	BSR	EXP0	;read expression, R5 = type, R6 = val or addr
	CMPQB	1,R1	;see if 1-element expression (uncompiled)
	BLO	TWOTERM:B
TWO3:
	RESTORE	[R3,R4]	;destination variable
	SBITB	20,R3	;make dest control the type of operation
	BSR	XLOAD
DEFI23:
	MOVQD	6,ACCUM	;make R6 the accum. before exiting
	MOVQD	0,ACCUM+4
DEFI0:
	RET	0
TWOTERM:	;we have a two-operand expression (not compiled)
	RESTORE	[R0,R1]	;get dest. designators
	CMPD	R0,R3	;see if 1st operand = dest.
	BNE	TWO1:B
	CMPD	R1,R4
	BNE	TWO1:B
TWO0:	;1st operand = dest.
	SBITB	20,R0	;make dest. control the type of operation
	MOVD	R0,ACCUM	;make our dest. the accum.
	MOVD	R1,ACCUM+4
	JSR	R2	;do operation (2nd operand into dest.)
	BR	DEFI23
TWO1:
	CMPD	R0,R5	;see if 2nd operand = dest.
	BNE	TWO2:B
	CMPD	R1,R6
	BNE	TWO2:B
	MOVD	R3,R5	;2nd operand = dest, make 1st operand the source
	MOVD	R4,R6
	SBITB	30,R5	;set the reverse flag
	BR	TWO0
TWO2:	;dest is different from either operand
	SAVE	[R0,R1,R2,R5,R6]
	MOVD	R3,R5	;make 1st operand the source
	MOVD	R4,R6
	BSR	ALOAD	;load 1st operand into accum
	RESTORE	[R2,R5,R6]	;remember 2nd operand
	JSR	R2	;do the operation (2nd operand into accum)
	MOVD	ACCUM,R5	;make the accum the new source
	MOVD	ACCUM+4,R6
	BR	TWO3
DIM5:	;execution of array or array element comes here
	BSR	LOOK
	DB	1,'('	;no '(' means treat it as a string
	DB	STR1-($+1)	;H'27	
{ BSR STR1 }
	RESTORE	[R6]	;addr of array or string parameters
	ADDQD	4,R6	;skip string length entry
	CBITB	0,INEXPR	;1=in expr, 0=assig.
	BFC	DIM51:B
	MOVQD	-3,R5	;-3 means array element in expression
	RET	0
DIM51:
	MOVQD	7,ACCUM	;make R7 the accum
	MOVQD	0,ACCUM+4
	BSR	OFFSET	;get offset of array element in terms of # of elements
	BR	DEFI2	;   from start of array (put into R7)
STR1:
	RESTORE	[R6]	;addr of length
	CBITB	2,INEXPR	;bit 2 set = 'in string expression'
	BFC	STR2:B
	MOVZBD	6(R6),R5	;# of dimensions (-1)
	ADDD	R5,R5
	ADDD	R5,R5	;* 4
	ADDQD	5,R5
	ADDQD	6,R5	;offset to data
	ADDD	R5,R6	;R6 = addr of data
	SAVE	[R5]
	MOVD	14H,R5	;source = immed.
	MOVQD	1,R3	;dest = R1
	BSR	XLOAD	;put string addr into R1
	MOVD	9,R5	;source = disp(R1)
	NEGD	TOS,R6	;offset back to length addr
	MOVQD	0,R3	;dest. = R0
	BSR	XLOAD	;put sting len. into R0
	BSR	COMPILE
	DB	3
	MOVSB
	RET	0
STR0:
	BR	SYNERR
STR2:
	BSR	LOOK
	DB	1,'='	;must be assign. statement
	DB	STR0-($+1)	;H'F1
{ BSR STR0        ;syntax error }
STR21:
	MOVZBD	6(R6),R5	;# of dimensions (-1)
	ADDD	R5,R5
	ADDD	R5,R5	;* 4
	ADDQD	5,R5
	ADDQD	6,R5	;offset to data
	ADDD	R5,R6	;R6 = addr of data
	SAVE	[R5]
	BSR	COMPILE
	DB	2
	SAVE	[R0,R1,R2]
	MOVD	14H,R5	;souce = immed.
	MOVQD	2,R3	;dest = R2
	BSR	XLOAD	;put string addr into R2
	BSR	COMPILE
	DB	2
	SAVE	[R2]	;save addr
STR3:
	BSR	STRDEL	;check for literal string
	BNE	STR4:B
	ADDR	GETSTR,R1	;addr of literal string handler
	BSR	PRIN4	;compile string handler and literal string
	BR	STR5:B
STR4:
	MOVQB	4,INEXPR
	BSR	INTERP1	;process 1 string argument
STR5:
	BSR	LOOK
	DB	81H,'+'
	DB	STR3-($+1)	;H'D5
{ BSR STR3 }
	MOVQB	0,INEXPR
	BSR	COMPILE
	DB	4
	RESTORE	[R6]
	SUBD	R6,R2
	MOVQD	2,R5	;source = R2
	MOVD	0EH,R3	;dest. = disp(R6)
	NEGD	TOS,R4	;offset
	BSR	XLOAD	;store new length
	BSR	COMPILE
	DB	2
	RESTORE	[R0,R1,R2]
	RET	0
GETSTR:
	RESTORE	[R1]
	MOVZBD	0(R1),R0
	ADDQD	1,R1
	MOVSB
	JUMP	R1
OPTABLE:
	DB	'AND'
	DD	PCAD B4B0+AND
	DB	'OR'
	DD	PCAD B4B0+OR
	DB	'>='
	DD	PCAD B4B0+GE
	DB	'<>'
	DD	PCAD B4B0+NE
	DB	'<='
	DD	PCAD B4B0+LE
	DB	'^' 
	DD	PCAD B4B0+EXPON
	DB	'>'
	DD	PCAD B4B0+GT
	DB	'='
	DD	PCAD B4B0+EQ
	DB	'<'
	DD	PCAD B4B0+LT
	DB	'/'
	DD	PCAD B4B0+DIVIDE
	DB	'-'
	DD	PCAD B4B0+SUBTR
	DB	'+'
	DD	PCAD B4B0+ADD
	DB	'*'
	DD	PCAD B4B0+MULT
	DB	7
EXPON:
	RET	0
	DB	3,'END'
	DW	BL-$
BL	SET	$-6
	BSR	COMPILE:W
	DB	2
	RET	0
	RET	0
	ALIGN	2	;prevent assembler from ruining linked list
LINK4B0	EQU	BL-$	;link to next module
