F434:	MODULE

; INCLUDE 4CON.ASM
; INCLUDE MACLIB.ASM
; LIST ON
; MACLIST OFF
;Third part of 432.ASM
;by Neil R. Koozer              08/21/85
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709
;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.
;  Nov 18, 1985          Nov 26, 1985      January 7, 1986
;  January 29, 1986

	COND	NOT INCL
	 EXTRN	F432,F433,B4B0,B4B1,B4B2
	 EXTRN	ERR1,LESS,LINK433,PERI1,PERIOD
	 EXTRN	SCRLF,SEMIT,SKEY,SPACE,STYPE,TESTIT
	 EXTRN	TYP1,TYP2,VAR1

	 EXTRN	BASEL:(SB)D,BLOKBUF:(SB)D,BUFADD:(SB)D,BUFBLK:(SB)D
	 EXTRN	BUFFLG:(SB)D,CONTEXL:(SB)D,CURBUF:(SB)D,DSTACK:(SB)D
	 EXTRN	EDBUF:(SB)D,EDTABL:(SB)D,IOWORD:(SB)D
;	 EXTRN	IOPB:(SB)D,
	 EXTRN	JUNK:(SB)D,SCRL:(SB)D,STATEL:(SB)D,TIBL:(SB)D

	 GLOBAL	BLOCK,CLS,EDI0,LINK434,VOC
	CEND

	DISP	2
{
>BODY just does a return
}

;Duplicate TOS if not 0

	DB	4,$'?DUP'
	DW	LINK433-$	;splice linked list to prev. module
LINK	SET	$-7
	CMPQD	0,0(R7)
	BEQ	QDUP1:B
	ADDQD	-4,R7
	MOVD	4(R7),0(R7)
QDUP1:
	RET	0


;Display FORTH-83 message

	DB	8,'FORTH-83'
	DW	LINK-$
LINK	SET	$-11
	ADDR	FMSG,R2
	BSR	STYPE
	RET
FMSG:
	DB	74,13,10,'Same as FORTH-83 except all standard words use 32-bit signed '
	DB	'integers.',13,10


;Byte move/increment/repeat
;TOS=count, 2nd on stack=target address, 3rd on stack=source address

	DB	5,'CMOVE'
	DW	LINK-$
LINK	SET	$-8
	MOVD	0(R7),R0
	ADDQD	4,R7
	MOVD	0(R7),R2
	ADDQD	4,R7
	MOVD	0(R7),R1
	ADDQD	4,R7
	MOVSB
	RET	0


;TOS=pointer to length/string
;Leave pointer 2nd on stack, length TOS

	DB	5,'COUNT'
	DW	LINK-$
LINK	SET	$-8
	MOVD	0(R7),R0
	MOVXBW	0(R0),-4(R7)
	ADDQD	1,R0
	MOVD	R0,0(R7)
	ADDQD	-4,R7
	RET	0


;Push size of data stack before DEPTH

	DB	5,'DEPTH'
	DW	LINK-$
LINK	SET	$-8
	ADDR	DSTACK,R6
	NEGD	R6,R6
	ADDD	R7,R6
	PUSH		;macro to push R6 onto data stack
	RET	0


	DB	6,'NEGATE'
	DW	LINK-$
LINK	SET	$-9
	NEGD	0(R7),0(R7)
	RET	0


	DB	3,$'MAX'
	DW	LINK-$
LINK	SET	$-6
	POP		;macro to pop R6 from data stack
	CMPD	R6,0(R7)
	BLE	MAX1:B
	MOVD	R6,0(R7)
MAX1:
	RET	0


	DB	3,$'MIN'
	DW	LINK-$
LINK	SET	$-6
	POP	;macro to pop R6 from data stack
	CMPD	R6,0(R7)
	BGE	MIN1:B
	MOVD	R6,0(R7)
MIN1:
	RET	0


;Backwards byte move/decrement/repeat
;TOS=count, 2nd on stack=target, 3rd on stack=source

	DB	6,'CMOVE>'
	DW	LINK-$
LINK	SET	$-9
	MOVD	0(R7),R0
	ADDQD	4,R7
	MOVD	0(R7),R2
	ADDQD	4,R7
	MOVD	0(R7),R1
	ADDQD	4,R7
	ADDD	R0,R2
	ADDD	R0,R1
	ADDQD	-1,R2
	ADDQD	-1,R1
	MOVSB	B
	RET	0


;Complement

	DB	3,$'NOT'
	DW	LINK-$
LINK	SET	$-6
	COMD	0(R7),0(R7)
	RET	0


	DB	2,$'OR'
	DW	LINK-$
LINK	SET	$-5
	ORD	0(R7),4(R7)
	ADDQD	4,R7
	RET	0


	DB	4,$'PICK'
	DW	LINK-$
LINK	SET	$-7
	MOVD	0(R7),R0
	ADDQD	1,R0
	MOVD	0(R7)[R0:D],0(R7)
	RET	0


	DB	2,$'R>'
	DW	LINK-$
LINK	SET	$-5
	RESTORE	[R0]
	MOVD	TOS,-4(R7)
	ADDQD	-4,R7
	JUMP	R0


;Echo number of spaces on stack

	DB	6,'SPACES'
	DW	LINK-$
LINK	SET	$-9
	MOVD	0(R7),R2
	CMPQD	0,R2
	BEQ	SPA2:B
SPA1:
	BSR	SPACE
	ACBD	-1,R2,SPA1
SPA2:
	RET	0


	DB	4,$'ROLL'
	DW	LINK-$
LINK	SET	$-7
	MOVD	0(R7),R0
	MOVD	R0,R2
	ADDD	R2,R2
	ADDD	R2,R2
	ADDD	R7,R2	;addr of Nth element
	MOVD	0(R2),0(R7)
	MOVD	R2,R1
	ADDQD	-4,R1
	MOVSD	B
	ADDQD	4,R7
	RET	0


;Exit current routine by dropping return address and returning to previous
;routine

	DB	4,$'EXIT'
	DW	LINK-$
LINK	SET	$-7
EXIT:
	ADJSPB	-4
	RET	0


	DB	40H	;null word (0 length)
	DW	LINK-$
LINK	SET	$-3
	ADJSPB	-8	;escape from interpret loop
	RET	0


	DB	86H
	DB	2,$'D<'
	DW	LINK-$
LINK	SET	$-6
	BSR	LESS
	RET	0


	DB	88H
	DB	2,$'D+'
	DW	LINK-$
LINK	SET	$-6
	POP
	ADDD	R6,0(R7)
	RET	0


	DB	85H
	DB	7,'DNEGATE'
	DW	LINK-$
LINK	SET	$-11
	NEGD	0(R7),0(R7)
	RET	0


	DB	4,$'FIND'
	DW	LINK-$
LINK	SET	$-7
	MOVD	0(R7),R5
	MOVD	CONTEXL,R0
	MOVD	0(R0),R2
	BSR	TESTIT
	ADDQD	-2,R7
	CMPQB	0,2(R7)
	BEQ	FIN1:B
	ADDQD	-4,R7
	MOVQD	0,0(R7)
	MOVD	R5,4(R7)
	RET	0
FIN1:
	TBITB	6,STATEL
	BFS	FIN2:B
	MOVQD	-1,0(R7)
	RET	0
FIN2:
	MOVQD	1,0(R7)
	RET	0


{ Unsigned operators }

	DB	2,$'U.'
	DW	LINK-$
LINK	SET	$-5
	ADDR	TIBL,R2
	ADDD	80H,R2
	MOVQD	0,R3
	MOVQD	0,R4
	MOVD	0(R7),R1
	ADDQD	4,R7
	BR	PERI1


	DB	2,$'U<'
	DW	LINK-$
LINK	SET	$-5
	POP
	CMPD	R6,0(R7)
	MOVQD	-1,R6
	BHI	$+4
	MOVQD	0,R6
	MOVD	R6,0(R7)
	RET	0


	DB	3,$'UM*'
	DW	LINK-$
LINK	SET	$-6
	MOVD	0(R7),R0
	MEID	4(R7),R0
	ADDQD	4,R7
	MOVD	R0,0(R7)
	RET	0


	DB	6,'UM/MOD'
	DW	LINK-$
LINK	SET	$-9
	MOVD	4(R7),R0
	MOVQD	0,R1
	DEID	0(R7),R0
	MOVD	R0,4(R7)
	MOVD	R1,0(R7)
	RET	0


	DB	5,'>BODY'
	DW	LINK-$
LINK	SET	$-8
	RET	0




DISKERR: DB	12,'Disk Error',13,10

DISKOP:
	SAVE	[R2]
	ADDR	DISKERR,R2
	BSR	STYPE
	RESTORE	[R2]
	RET
{
	MOVD	BUFADD-4[R0:D],4(R2)	;put buffer addr into IOPB
	MOVQB	2,1(R2)	;put #-of-sectors-to-read into IOPB
	MOVQB	3,7(R2)	;sector length (512 bytes) into IOPB
	MOVQD	2,10(R2)	;2 means double density, side 0
	MOVW	0DFH,8(R2)	;retry code & other stuff
	ADDW	R4,R4	;sector # (ref 2)
	ADDQW	-2,R4	;sector # (ref 0)
	MOVQW	0,R5	;prepare for DEI
	DEIW	15,R4	;R4 = sect. R5 = track
	ADDQW	1,R4	;sector # in track (ref 1)
	MOVB	R5,2(R2)	;track # into IOPB
	MOVB	R4,3(R2)	;sector # into IOPB
	CMPB	0FH,R4	;if we're at sector 15, do two separate reads
	BNE	DIS4:B
	MOVQB	1,1(R2)
	BSR	DIS4:B
	ADDR	IOPB,R2
	MOVQB	1,3(R2)	;sector #1
	ADDQB	1,2(R2)	;next track
	ADDQW	2,5(R2)	;add 512 to buffer addr pointer
DIS4:
	MOVD	FDC:#,R3
	MOVB	R2,1(R3)	;1st byte of FDC command
	LSHD	-8,R2
	MOVB	R2,2(R3)	;2nd byte of FDC command
DIS1:
	MOVB	1(R3),R4	;get status byte
	ANDB	90H,R4
	CMPB	90H,R4
	BNE	DIS1	;wait till ready
	LSHD	-8,R2
	MOVB	R2,2(R3)	;3rd byte of FDC command
DIS2:
	MOVB	1(R3),R4	;get status byte
	TBITB	7,R4	;check busy bit
	BFS	DIS2	;wait till done
	MOVB	0(R3),R4	;get error byte
	CMPQB	0,R4
	BEQ	DIS3:B	;0 means no error
	ADDR	DISKERR,R2
	BR	ERR1
DIS3:
	RET	0
}

WRITE1:	;write a buffer (R0) to disk
	SAVE	[R2]
	ADDR	DISKERR,R2
	BSR	STYPE
	RESTORE	[R2]
	RET
{
	ADDR	IOPB,R2
	MOVB	9,0(R2)	;put write cmd into IOPB
	MOVW	BUFBLK-2[R0:W],R4	;block #
	BSR	DISKOP	;write buffer (R0) to disk block (R4)
	MOVQB	0,BUFFLG-1[R0:W]	;clear 'update' flag
	RET	0
}
READ1:	;read a block from disk into a block buffer
	SAVE	[R2]
	ADDR	DISKERR,R2
	BSR	STYPE
	RESTORE	[R2]
	RET
{
	ADDR	IOPB,R2
	MOVB	8,0(R2)	;put read cmd into IOPB
	MOVW	0(R7),R4	;block #
	BR	DISKOP	;read disk block (R4) into buffer (R0)
}
	DB	12,'SAVE-BUFFERS'
	DW	LINK-$
LINK	SET	$-15
SAVEBUF:
	MOVZBD	NBUFFS,R0
SAV2:
	TBITB	15,BUFFLG-2[R0:W]	;check 'update' flag
	BFC	SAV1:B
	BSR	WRITE1	;write block to disk if data was changed
SAV1:
	ACBB	-1,R0,SAV2
	RET	0


	DB	5,'FLUSH'
	DW	LINK-$
LINK	SET	$-8
	BSR	SAVEBUF	;save buffers
FLU2:
	MOVZBD	NBUFFS,R0
FLU1:	;un-assign buffers
	MOVQW	0,BUFFLG-2[R0:W]
	MOVQW	0,BUFBLK-2[R0:W]
	ACBB	-1,R0,FLU1
	RET	0


	DB	6,'UPDATE'
	DW	LINK-$
LINK	SET	$-9
UPDATE:	;mark a buffer as having changed data
	MOVZBD	CURBUF,R0
	SBITB	15,BUFFLG-2[R0:W]
	RET	0

;TOS holds block number,
;return address of buffer containing that block, or available block if
;no match
;Don't read into buffer

	DB	6,'BUFFER'
	DW	LINK-$
LINK	SET	$-9
	MOVQB	0,R6
	BR	SBLOCK:B


;TOS holds block number,
;return address of buffer containing that block
;Read block if not already in buffer
;All buffers default to block 0 on reset

	DB	5,'BLOCK'
	DW	LINK-$
LINK	SET	$-8
BLOCK:
	MOVQB	1,R6
SBLOCK:
	MOVW	0(R7),R4	;block #
	ADDR	BUFBLK+(NBUFFS-1)*2,R1	;Last entry of blk # table
	MOVZBD	NBUFFS,R0	;Number of entries in table
	SKPSW	U,B		;look for matching blk #
	ADDR	BUFFLG,R1	;addr of update flag table
	BFC	CHOOSE:W	;Not found
	CMPQB	-2,-2(R1)[R0:W]	;see if buffer is already newest
	BEQ	SBL6:B		;skip the aging if it's the newest
SBL1:				;Decrement access count of all buffers
	SAVE	[R5]
	MOVQB	-1,-2(R1)[R0:W]	;make chosen buffer newest
	MOVZBD	NBUFFS,R5
SBL4:
	ADDQB	-1,-2(R1)[R5:W]
	BCS	SBL5:B
	MOVQB	0,-2(R1)[R5:W]	;Don't go below -255
SBL5:
	ACBB	-1,R5,SBL4
	RESTORE	[R5]
SBL6:
	MOVB	R0,CURBUF	;store active-buffer #
	MOVW	0(R7),BUFBLK-2[R0:W] ;store block #
	MOVD	BUFADD-4[R0:D],0(R7) ;return address of buffer block
	RET	0

CHOOSE:				;choose the best buffer to use
	MOVW	MAXBLK-1,(R7)
	BR	SBLOCK		;Default to max available block

	MOVQW	-1,R3		;initialize comparison value
	MOVZBD	NBUFFS,R5
SBL3:				;Find least recently accessed
	MOVW	-2(R1)[R5:W],R2
	CMPW	R2,R3
	BHS	SBL2:B		;R2 more recent if HS
	MOVW	R2,R3		;update flag
	MOVD	R5,R0		;buffer #
SBL2:
	ACBB	-1,R5,SBL3
	TBITB	15,R3		;buffer dirty?
	BFC	LOADBLK:B
	BSR	WRITE1		;write buffer to disk if data has been altered
LOADBLK:
	CMPQB	0,R6		;no read if 'BUFFER'
	BEQ	SBL1
	BSR	READ1		;read the block, R0=buffer #, TOS=block #
	BR	SBL1


;Erase current buffer (number in CURBUF)

	DB	4,$'WIPE'
	DW	LINK-$
LINK	SET	$-7
	MOVZBD	CURBUF,R0
	MOVD	BUFADD-4[R0:D],R1
	MOVD	BUFLEN-2,R0
WIP1:
	MOVD	R1,R2
	ADDQD	2,R2
	LSHD	-1,R0
	MOVW	2020H,0(R1)
	MOVSW
	RET	0


	DB	4,$'COPY'	;this isn't good enough yet
	DW	LINK-$
LINK	SET	$-7
	ADDQD	4,R7
	BSR	BLOCK
	ADDQD	4,R7
	MOVXBD	CURBUF,R0
	MOVW	-8(R7),BUFBLK-2[R0:W]
	MOVQB	-1,BUFFLG-1[R0:W]	;update flag
	RET	0


	DB	13,'EMPTY-BUFFERS'
	DW	LINK-$
LINK	SET	$-16
	BR	FLU2


	DB	3,$'XOR'
	DW	LINK-$
LINK	SET	$-6
	XORD	0(R7),4(R7)
	ADDQD	4,R7
	RET	0


	DB	5,'LLIST'
	DW	LINK-$
LINK	SET	$-8
	MOVW	IOWORD,TOS	;save IOWORD
	MOVQW	2,IOWORD	;re-route CRT to printer
	BSR	LIST:B
	MOVW	TOS,IOWORD
	RET	0


;Copy string (length, text) in TOS to RAM buffer JUNK
;Return address of JUNK in TOS

GET_JUNK:
	LPROC
PTR:	BLKD			;Pointer to string
	REG	[R0,R1,R2]
	CODE

	MOVD	PTR,R1		;Source address
	ADDR	JUNK,R2		;Target address
	MOVD	R2,PTR		;RAM buffer address to R5
	MOVZBD	(R1),R0		;Length of text
	ADDQD	1,R0		;Include length byte
	MOVSB			;Copy LIS3 to JUNK

	PEND	0		;Don't drop parameter


	DB	4,$'LIST'
	DW	LINK-$
LINK	SET	$-7
LIST:
	BSR	SCRLF		;CR/LF
LIS5:
	MOVW	0(R7),SCRL	;Block number
	BSR	BLOCK		;Get address of block
	MOVD	0(R7),R1	;buffer addr returned by BLOCK
	ADDQD	4,R7
	ADDR	EDBUF,R2	;addr of edit buffer
	MOVD	BUFLEN/4,R0
	MOVSD			;copy the block into edit buffer
LIS8:
	ADDR	EDBUF,R6	;Display from here
	ADDR	LIS3,TOS
	BSR	GET_JUNK	;Copy R5 ROM string to JUNK RAM buffer
	MOVD	TOS,R5
	MOVB	10H,R3		;# of lines to list
	MOVB	'|',4(R5)	;insert border character
	MOVB	'|',6(R5)
LIS6:
	ADDR	BASEL,R2	;Current radix
	MOVB	0(R2),R0	;Radix to R0
	SAVE	[R0,R2,R6]	;save number base and edit buffer addr
	MOVB	0AH,0(R2)	;make number base decimal
	MOVW	3020H,1(R5)	;prime the line number
LIS1:
	MOVD	R5,R2
	BSR	STYPE		;print line # & left border
	MOVD	R6,R2
	MOVW	40H,R4
	BSR	TYP2		;print 64 characters from buffer
	MOVD	R2,R6		;update buffer pointer
	ADDR	LIS7,R2
	BSR	STYPE		;print right border
	ADDQB	1,2(R5)		;increment line number
	CMPB	3AH,2(R5)	;check for carry
	BNE	LIS2:B
	MOVW	3031H,1(R5)	;repair carry
LIS2:
	CMPQB	1,R3		;see if it's the last line
	BEQ	LIS4:B
	BSR	SCRLF		;do carriage return except on last line
LIS4:
	ACBB	-1,R3,LIS1
	BSR	SPACE		;print a space
	ADDQD	-4,R7
	MOVXWD	SCRL,0(R7)	;Current block number
	BSR	PERIOD		;print the block # to right of last line
	RESTORE	[R0,R2,R6]	;pop number base and edit buffer addr
	MOVB	R0,0(R2)	;restore previous number base
	RET	0
LIS3:
	DB	4,$' 0 |'
LIS7:
	DB	21,'|          ',8,8,8,8,8,8,8,8,8,8


	DB	1,'L'
	DW	LINK-$
LINK	SET	$-4
L:
	BSR	SCRLF		;CR/LF
L__1:				;list contents of current buffer
	MOVXBD	CURBUF,R0
	ADDR	BUFBLK,R1
	MOVW	-2(R1)[R0:W],-4(R7)
	ADDQD	-4,R7		;Push buffer number onto stack
	BR	LIS5

CLSMSG:
	DB	2,vc_scr,vcs_pag ;2-byte message to clear screen
CLS:				;clear-screen routine
	ADDR	CLSMSG,R2
	BSR	STYPE
	ADDR	EDBUF,R1
	MOVD	5FEH,R0		;Edit buffer size-2
	BR	WIP1		;clear the edit buffer

;R4 holds absolute cursor position with block
;R3 must address of EDTABL
;R2 and R5 are altered

CURSOR:
	MOVQW	0,R5		;ready for DEI
	DEIW	40H,R4		;Column-4 in R5, Row in R5
	ADDQB	4,R4		;horizontal offset for left border)

;Position cursor to column in R4, row in R5

CUR1:
	MOVB	R4,7(R3)	;Column
	MOVB	R5,8(R3)	;Row
	MOVD	R3,R2
	ADDQD	4,R2
	BSR	STYPE		;send abs cursor-addressing string
	RET

CSR_HOM:
	SAVE	[R0]
	MOVB	vc_scr,R0 	;Video command
	BSR	SEMIT
	MOVB	vcs_cur,R0	;Cursor position
	BSR	SEMIT
	MOVQB	0,R0		;Column 0
	BSR	SEMIT
	MOVQB	0,R0		;Row 0
	BSR	SEMIT
	RESTORE	[R0]
	RET

BLIST:	;list the auxiliary edit buffer below main buffer

	ADDR	EDTABL,R3
	MOVQB	0,R4		;Cursor column
	MOVB	16,R5		;Cursor row
	BSR	CUR1		;position cursor at left edge of 16th line
	ADDR	LIS3,TOS
	BSR	GET_JUNK
	MOVD	TOS,R5
	MOVB	'[',4(R5)	;use different border characters
	MOVB	']',6(R5)
	MOVB	8,R3	;# of lines to list
	SAVE	[R6]
	ADDD	400H,R6	;start addr of aux buffer
	BSR	LIS6	;list it out
	RESTORE	[R6]
	RET	0


	DB	4,$'EDIT'
	DW	LINK-$
LINK	SET	$-7
	MOVQW	0,EDTABL	;init cursor
EDI0:
	BSR	CSR_HOM
	BSR	LIS5		;List block on stack and drop value
	BSR	BLIST		;list aux. edit buffer
EDI1:
	BSR	UPDATE		;mark the current block as 'changed'
	ADDR	EDTABL,R3
	MOVQB	0,9(R3)		;flag for unfinished display updating
	MOVW	0(R3),2(R3)	;cursor position for display updating
KBD:
	MOVW	0(R3),R4
	BSR	CURSOR		;place cursor on CRT
KBD1:
	save	[r6]
	movd	dev_kbd+dof_sst*256,r6 ;Keyboard status check
	svc
	cmpqd	0,r6		;Character ready if eq
	restore	[r6]

	BEQ	CHAR:B		;Character ready if EQ
	CMPQB	0,9(R3)	;if no char ready, check for unfinished display updating
	BEQ	KBD1
	MOVW	2(R3),R4
	BSR	CURSOR
	MOVXWD	2(R3),R4
	CMPW	R4,10(R3)	;see if we've finished the area that needs printed
	BHS	KBD3:B
	ADDD	R6,R4	;addr of char to print
	MOVB	0(R4),R0	;get char
	BSR	SEMIT	;print char
	MOVW	2(R3),R4
	ADDQW	1,R4	;advance the print cursor
	MOVW	R4,2(R3)
	CMPW	600H,R4	;check for end of buffer
	BNE	KBD
KBD3:
	MOVW	0(R3),2(R3)	;make print cursor the same as the edit cursor
	MOVQB	0,9(R3)	;reset the 'printing needed' flag
	BR	KBD
CHAR:
	BSR	SKEY

	CMPB	R0,vc_win	;Check for virtual cursor key
	BEQ	CONTROL:W
	CMPB	R0,20H		;see if control char
	BLO	CONTROL:W
	CMPB	R0,7FH		;see if printable char
	BEQ	CONTROL:W	;Delete character
	BHI	KBD
	MOVZWD	0(R3),R4	;if we have a printable char, we insert it
	MOVW	R4,2(R3)	;set print cursor to equal the keyboard cursor
	MOVQB	-1,9(R3)	;set the 'printing needed' flag
	MOVD	600H,R5
	ADDQW	1,R4	;advance kbd cursor unless it's at end of buffer
	CMPW	R5,R4
	BLS	CHA3:B
	MOVW	R4,0(R3)
CHA3:
	ADDD	R6,R4	;convert cursor to mem. addr.
	ADDD	R6,R5	;addr of end of buffer
CHA2:
	MOVB	-1(R4),R1	;start the insert process
	CMPB	R0,R1
	BNE	CHA1:B
	CMPB	20H,R0	;stop moving text if we hit two spaces in a row
	BNE	CHA1:B
CHA4:
	SUBD	R6,R4
	MOVW	R4,10(R3) ;store cursor position where effect of the insert ends
	BR	KBD
CHA1:
	MOVB	R0,-1(R4)
	MOVB	R1,R0
	CMPD	R5,R4	;check for end of buffer
	BLS	CHA4
	ADDQW	1,R4
	BR	CHA2	;continue the inserting process

;Conversion table for virtual cursor control codes
; to standard control key codes

VCW_CMD:
	DB	H'00		;^@
	DB	H'00		;^A
	DB	H'00		;^B
	DB	H'00		;^C
	DB	vcw_rt		;^D
	DB	vcw_up		;^E
	DB	H'00		;^F
	DB	vcw_dl		;^G
	DB	H'00		;^H
	DB	H'00		;^I
	DB	H'00		;^J
	DB	H'00		;^K
	DB	H'00		;^L
	DB	H'00		;^M
	DB	H'00		;^N
	DB	H'00		;^O
	DB	H'00		;^P
	DB	H'00		;^Q
	DB	H'00		;^R
	DB	vcw_lf		;^S
	DB	H'00		;^T
	DB	H'00		;^U
	DB	H'00		;^V
	DB	H'00		;^W
	DB	vcw_dn		;^X
	DB	H'00		;^Y
	DB	H'00		;^Z
	DB	H'00		;^[
	DB	H'00		;^\
	DB	H'00		;^]
	DB	H'00		;^^
	DB	H'00		;^_


CONTROL:
	CMPB	vc_win,R0	;Check for virtual cursor key
	IF	EQ
	 BSR	SKEY		;Get 2nd command
	 SAVE	[R1,R4]
	 ADDR	VCW_CMD+31,R1	;End of command table
	 MOVB	R0,R4		;Code to search for
	 MOVZBD	32,R0		;Size of table
	 SKPSB	B,U
	 RESTORE [R1,R4]
	 BFC	KBD		;No match if FC
	 ADDQB	-1,R0		;Convert to 0 offset
	ENDIF
	ANDB	H'1F,R0		;Delete becomes 1F
	BSR	CTAB:B
	BR	KBD

CTAB:
	CASEW	CTABLE[R0:W]	;branch to selected routine
CTABLE:
	DW	RET0-CTAB
	DW	CONT_A-CTAB	;Previous word
	DW	RET0-CTAB
	DW	CONT_C-CTAB	;Next block
	DW	CONT_D-CTAB	;Cursor right
	DW	CONT_E-CTAB	;Cursor up
	DW	CONT_F-CTAB	;Next word
	DW	CONT_G-CTAB	;Delete character
	DW	CONT_S-CTAB	;^H is non-destructive
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	CONT_L-CTAB	;Beginning of line
	DW	CONT_M-CTAB	;Cursor down and beginning of line
	DW	CONT_N-CTAB	;Insert a line
	DW	RET0-CTAB
	DW	CONT_P-CTAB	;Redraw screen
	DW	CONT_Q-CTAB	;Save edit and exit
	DW	CONT_R-CTAB	;Previous block
	DW	CONT_S-CTAB	;Non-destructive cursor left
	DW	CONT_T-CTAB	;Delete word
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	CONT_W-CTAB	;Clear (wipe) screen
	DW	CONT_X-CTAB	;cursor down
	DW	CONT_Y-CTAB	;Delete line
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	RET0-CTAB
	DW	CONT_H-CTAB	;Destructive backspace

CONT_S:				;Non-destructive backspace
	MOVQW	-1,R4
CONS1:
	ADDW	0(R3),R4
	MOVW	600H,R0
	CMPW	R4,R0
	BLT	CONS3:B
	SUBW	R0,R4
CONS3:
	CMPQW	0,R4
	BLE	CONS2:B
	ADDW	R0,R4
CONS2:
	MOVW	R4,0(R3)
	RET	0

CONT_D:				;Advance cursor
	MOVQW	1,R4
	BR	CONS1

CONT_E:				;Cursor up
	MOVW	-40H,R4
	BR	CONS1

CONT_X:				;Cursor down
	MOVW	40H,R4
	BR	CONS1

CONT_A:				;Previous word
	MOVQW	-1,R1
CONA3:
	MOVZWD	0(R3),R4
CONA1:
	ADDW	R1,R4
	CMPW	600H,R4
	BHI	CONA4:B
	MOVQW	0,R4
CONA4:
	CMPQW	0,R4
	BEQ	CONA2:B
	MOVD	R4,R5
	ADDD	R6,R5
	CMPB	20H,0(R5)
	BEQ	CONA1
	CMPB	20H,-1(R5)
	BNE	CONA1
CONA2:
	MOVW	R4,0(R3)
	RET	0

CONT_F:				;Next word
	MOVQW	1,R1
	BR	CONA3

CONT_G:				;Delete a character
	MOVZWD	0(R3),R4
CONG3:
	MOVQB	-1,9(R3)
	MOVW	R4,2(R3)
	MOVD	600H,R5
	ADDD	R6,R5
	ADDD	R6,R4
CONG2:
	MOVB	1(R4),R1
	CMPB	20H,R1
	BNE	CONG1:B
	CMPB	20H,0(R4)
	BNE	CONG1:B
CONG4:
	SUBD	R6,R4
	MOVW	R4,10(R3)
	RET	0
CONG1:
	MOVB	R1,0(R4)
	ADDQD	1,R4
	CMPD	R4,R5
	BNE	CONG2
	MOVB	20H,-1(R4)
	BR	CONG4

CONY1:
	MOVZWD	0(R3),R1
	ANDB	0C0H,R1
	MOVW	R1,0(R3)
	MOVW	R1,2(R3)
	MOVQB	0,9(R3)
	MOVZWD	5C0H,R0
	SUBD	R1,R0
	LSHD	-2,R0
	RET	0
CONT_Y:				;Delete a line
	BSR	CONY1
	ADDD	R6,R1
	MOVD	R1,R2
	ADDD	40H,R1
	MOVSD
	MOVD	R2,R1
	BR	CONN2:B

CONT_N:				;Insert blank line
	BSR	CONY1
	MOVZWD	5FCH,R1
	ADDD	R6,R1
	MOVD	R1,R2
	SUBD	40H,R1
	MOVSD	B
	ADDQD	4,R1
CONN2:
	MOVZBD	3EH,R0
CONN1:
	BSR	WIP1
	BR	CONT_P:W

CONT_W:				;Erase (wipe) screen
	MOVD	R6,R1
	MOVD	3FEH,R0
	BR	CONN1

CONT_H:				;Destructive backspace
	MOVZWD	0(R3),R4
	CMPW	0,R4
	BEQ	RET0:W
	ADDQD	-1,R4
	MOVW	R4,0(R3)
	BR	CONG3

CONT_T:				;Delete word right
	MOVZWD	0(R3),R1
	MOVD	R6,R5
	ADDD	600H,R5
	ADDD	R6,R1
	MOVD	R1,R2
CONT2:
	CMPD	R6,R1
	BEQ	CONT1:B
	CMPB	20H,-1(R1)
	BEQ	CONT1:B
	CMPB	20H,0(R1)
	BEQ	CONT1:B
	ADDQD	-1,R1
	BR	CONT2
CONT1:
	CMPD	R5,R2
	BEQ	CONT5:B
	ADDQD	1,R2
	CMPB	20H,0(R2)
	BEQ	CONT1
	CMPB	20H,-1(R2)
	BNE	CONT1
	CMPD	R1,R2
	BEQ	RETT:B
CONT5:
	MOVD	R1,R4
	SUBD	R6,R4
	MOVW	R4,0(R3)
	MOVW	R4,2(R3)
CONT3:
	CMPD	R2,R5
	BHS	CONT6:B
	MOVB	0(R2),0(R1)
	ADDQD	1,R1
	ADDQD	1,R2
	CMPW	2020H,-2(R1)
	BNE	CONT3
CONT6:
	MOVD	R2,R4
	SUBD	R6,R4
	MOVW	R4,10(R3)
	SUBD	R1,R2
CONT4:
	MOVB	20H,0(R1)
	ADDQD	1,R1
	ACBD	-1,R2,CONT4
	SUBW	0(R3),R4
	CMPW	R4,40H
	BHI	CONT_P:B
	MOVQB	-1,9(R3)
RETT:
	RET	0

CONT_Q:				;Save edit and exit
	ADJSPB	-4		;Drop return address
	MOVB	23,R5		;Cursor row
	MOVB	63+4,R4		;Cursor column
	BSR	CUR1
CONQ1:
	MOVXBD	CURBUF,R0
	ADDR	BUFADD,R1
	MOVD	-4(R1)[R0:D],R2
	MOVD	R6,R1
	MOVD	100H,R0
	MOVSD
	RET	0

CONT_P:				;Redraw screen
	MOVQB	0,9(R3)
	MOVW	0(R3),R4
	SAVE	[R3,R4]
	BSR	CSR_HOM
	BSR	LIS8
	BSR	BLIST
	RESTORE	[R3,R4]
	MOVW	R4,0(R3)
	MOVW	R4,2(R3)
RET0:
	RET	0

CONT_R:				;Back 1 screen
	MOVQW	-1,R0
CONR1:
	ADDW	SCRL,R0
	CMPW	MAXBLK,R0
	BLS	RET0
	ADDQD	-4,R7
	MOVW	R0,0(R7)
	BSR	CSR_HOM
	BSR	CONQ1
	BSR	LIS5
	ADJSPB	-4
	BR	EDI1

CONT_C:				;Advance 1 screen
	MOVQW	1,R0
	BR	CONR1

CONT_L:				;Beginning of line
	ANDB	0C0H,0(R3)
	RET	0

CONT_M:
	BSR	CONT_L
	BR	CONT_X


	DB	3,$'SCR'
	DW	LINK-$
LINK	SET	$-6
	ADDR	SCRL,TOS
	BR	VAR1+2

	MAC_LINK LOADBUF	;Load all blocks from disk device
GETBUF:
	movd	dev_kbd+dof_cmd*256,r6 ;Command to input device
	movd	dc_binon,r5	;Set for binary transfers
	svc

	movd	dev_kbd+dof_cmd*256,r6 ;Command to input device
	movd	dc_open,r5	;Open device
	svc
	
	movd	dev_kbd+dof_blk*256,r6 ;Block input
	movd	h'ffff+exp bkb_trm+exp bkb_bin,r0 ;Read until end of binary file
	addr	blokbuf,r1
	svc

	movd	dev_kbd+dof_cmd*256,r6 ;Command to input device
	movd	dc_close,r5	;Close device
	svc
	
	movd	dev_kbd+dof_cmd*256,r6 ;Command to input device
	movd	dc_binoff,r5	;Binary off
	svc

	ret
	
	MAC_LINK SAVEBUF	;Save all blocks to disk device
PUTBUF:
	movd	dev_vid+dof_cmd*256,r6 ;Command to output device
	movd	dc_binon,r5	;Set for binary transfers
	svc

	movd	dev_vid+dof_cmd*256,r6 ;Command to output device
	movd	dc_open,r5	;Open device
	svc
	
	movd	dev_vid+dof_blk*256,r6 ;Block output
	movzwd	buflen*nbuffs,r0  ;Byte count
	ord	exp bkb_cnt+exp bkb_bin,r0 ;Terminate on count, binary file
	addr	blokbuf,r1
	svc

	movd	dev_vid+dof_cmd*256,r6 ;Command to output device
	movd	dc_close,r5	;Close device
	svc
	
	movd	dev_vid+dof_cmd*256,r6 ;Command to output device
	movd	dc_binoff,r5	;Binary off
	svc

	ret

	MAC_LINK BYE		;Exit
BYE:	BPT			;Back to Kotekan debugger

VOC	EQU	LINK:#		;1st FORTH dictionary entry
	COND	INCL
LINK434	EQU	LINK:#		;link to next module
	CELSE
LINK434	EQU	LINK-$:#	;link to next module
	CEND

;End of 434.MAC
