F433:	MODULE

; INCLUDE 4CON.ASM
; INCLUDE MACLIB.ASM
; LIST ON
; MACLIST OFF
;           432  --  FORTH-83 for 32000 processor
;                (this is the second module)
;by Neil R. Koozer  --  November 13,1984      July 7, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709
;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.
;   August 21, 1985     Sept 14, 1985         Nov 18, 1985
;   Nov 23, 1985        January 8, 1986       January 30, 1986

	COND	NOT INCL
	 EXTRN	F432,F434,B4B0,B4B1,B4B2
	 EXTRN	ABORT,ABQUOTE,ASPACE,BCOMMA,BVOC
	 EXTRN	COMMA,ERROR,INEXPR,INTERP
	 EXTRN	LINK432,NUML2,NUMLIT,OK,PSTART,QUIT
	 EXTRN	RELHERE,SBC2,SBCOMMA,SEARCH,SEMIT
	 EXTRN	STA1,STYPE,TYP2,VOC,WORD

	 EXTRN	BASDPL:(SB)D,BASEL:(SB)D,BASICL:(SB)D,BASVOC:(SB)D
	 EXTRN	BLKL:(SB)D,CONTEXL:(SB)D,CURRENTL:(SB)D,DICT:(SB),DPL:(SB)D
	 EXTRN	FORTHDPL:(SB)D,FORTHL:(SB)D,FORTHVOC:(SB)D,MACROL:(SB)D
	 EXTRN	MODEL:(SB)D,REGBYTE:(SB)D,RGB:(SB)D,SPANL:(SB)D
	 EXTRN	STATEL:(SB)D,TIBL:(SB)D,TO_INL:(SB)D,WFLAG:(SB)D,XTIBL:(SB)D

	 GLOBAL	BACK,BNEW,EMPTY,FIL2,HEADER,HERE,IMMED
	 GLOBAL	LESS,LINK433,LOAD,PERI1,PERIOD,PQU1,PQUOTE,REPEAT
	 GLOBAL	SPACE,TIC,UNT1,VAR1,VOC1
	CEND

	DISP	2

{
The division/remainder routines here use QUO and REM opcodes
DOES macro must start with RET 0, some routines jump into DOES+2 
}

	DB	1,'*'
	DW	LINK432-$	;this splices the linked list
LINK	SET	$-4
MULT:
	MULD	0(R7),4(R7)
	ADDQD	4,R7
	RET	0

	DB	1,'/'
	DW	LINK-$
LINK	SET	$-4
DIVIDE:
	QUOD	0(R7),4(R7)
	ADDQD	4,R7
	RET	0

	DB	4,$'/MOD'
	DW	LINK-$
LINK	SET	$-7
DIVMOD:
	MOVD	4(R7),R0
	REMD	0(R7),4(R7)
	QUOD	0(R7),R0
	MOVD	R0,0(R7)
	RET	0


SMULTDIV:
	MOVD	8(R7),R0
	MOVD	4(R7),R2
	MOVQD	0,R1
	XORD	R0,R1
	XORD	R2,R1
	ABSD	R0,R0
	ABSD	R2,R2
	MEID	R0,R2
	MOVD	0(R7),R0
	MOVD	R1,R4	;remember sign of product
	XORD	R0,R1
	ABSD	R0,R0
	DEID	R0,R2	;R3 = QUO, R2 = REM
	TBITB	31,R1	;sign of result
	BFC	MUL1:B
	NEGD	R3,R3
MUL1:
	ADDQD	4,R7
	RET	0


	DB	2,$'*/'
	DW	LINK-$
LINK	SET	$-5
MULTDIV:
	BSR	SMULTDIV
	ADDQD	4,R7
	MOVD	R3,0(R7)
	RET	0


	DB	5,'*/MOD'
	DW	LINK-$
LINK	SET	$-8
MULTMOD:
	BSR	SMULTDIV
	MOVD	R3,0(R7)
	TBITB	31,R4	;sign of remainder
	BFC	MUL2:B
	NEGD	R2,4(R7)
	RET	0
MUL2:
	MOVD	R2,4(R7)
	RET	0


{
The following number routines use registers, not the stack
If they are called within FORTH, they must be consectuive
In order to preserve the register contents
}

;Convert least significant digit of number in R1 to ASCII in R0
;This doesn't use the stack so may only be called as a subroutine
;Store ASCII character in buffer in R2, decrement R2, increment R4

	DB	1,'#'
	DW	LINK-$
LINK	SET	$-4
XNUMBER:
	MOVZBD	BASEL,R5	;get radix
	MOVD	R1,R0		;previous quo = new dividend
	MOVQD	0,R1
	DEID	R5,R0		;quo = r1, rem = r0
	ADDB	30H,R0
	CMPB	3AH,R0
	BHI	X2:B
	ADDQB	7,R0
X2:
	ADDQD	-1,R2
	ADDQD	1,R4
	MOVB	R0,0(R2)
	RET	0


;R1 holds number, R2 holds buffer, convert to ASCII
;This doesn't use the stack so may only be called as a subroutine

	DB	2,$'#S'
	DW	LINK-$
LINK	SET	$-5
XS:
	BSR	XNUMBER
	CMPQD	0,R1
	BNE	XS
	RET	0


;Prepare number on stack for XS subroutine
;Original number in R3, absolute value in R1
;Use TIBL input buffer

	DB	2,$'<#'
	DW	LINK-$
LINK	SET	$-5
LX:
	ADDR	TIBL,R2
	ADDD	80H,R2		;Buffer fills backwards
	MOVD	0(R7),R3
	ADDQD	4,R7
	ABSD	R3,R1		;Absolute value
	MOVQB	0,R4		;Initialize length
	RET	0


;R2 holds buffer address, R4 holds length, output string
;Doesn't use stack

	DB	2,$'#>'
	DW	LINK-$
LINK	SET	$-5
XR:
	BR	TYP2


;Put sign into R2 buffer as necessary
;Doesn't use stack

	DB	4,$'SIGN'
	DW	LINK-$
LINK	SET	$-7
SIGN:
	TBITB	31,R3
	BFC	SIG1:B
	ADDQD	-1,R2
	ADDQD	1,R4
	MOVB	'-',0(R2)
SIG1:
	RET	0


;Put value on stack into R2 buffer
;Decrement R2, increment R4

	DB	4,$'HOLD'
	DW	LINK-$
LINK	SET	$-7
HOLD:
	ADDQD	-1,R2
	ADDQD	1,R4
	MOVB	0(R7),0(R2)
	ADDQD	4,R7
	RET	0


;Display a space

	DB	5,'SPACE'
	DW	LINK-$
LINK	SET	$-8
SPACE:
	MOVB	20H,R0
	BR	SEMIT


;Display number on stack

	DB	1,'.'
	DW	LINK-$
LINK	SET	$-4
PERIOD:
	BSR	LX
	BSR	PERI1:B
	BR	SPACE
PERI1:
	BSR	XS
	BSR	SIGN
	BR	XR

;Store Dword 2nd on stack in address on TOS
;32 bit store

	DB	8BH		;Macro
	DB	1,'!'
	DW	LINK-$
LINK	SET	$-5
Y:
	POP			;Address
	ADDQD	4,R7
	MOVD	-4(R7),0(R6)
	RET	0


;Store byte 2nd on stack in address on TOS

	DB	8BH
	DB	2,$'C!'
	DW	LINK-$
LINK	SET	$-6
CY:
	POP
	ADDQD	4,R7
	MOVB	-4(R7),0(R6)
	RET	0


;Add Dword 2nd on stack to address on TOS

	DB	8BH
	DB	2,$'+!'
	DW	LINK-$
LINK	SET	$-6
PLUSY:
	POP
	ADDQD	4,R7
	ADDD	-4(R7),0(R6)
	RET	0

{
The following comparison routines leave 0:D on stack if false, -1:D if true
}

;Less than comparison

	DB	95H
	DB	1,'<'
	DW	LINK-$
LINK	SET	$-5
LESS:
	POP
	ADDQD	4,R7
	CMPD	R6,-4(R7)
	MOVQD	-1,R6
	BGT	$+4
	MOVQD	0,R6
	PUSH
	RET	0


;Greater than comparison

	DB	95H
	DB	1,'>'
	DW	LINK-$
LINK	SET	$-5
	POP
	ADDQD	4,R7
	CMPD	R6,-4(R7)
	MOVQD	-1,R6
	BLT	$+4
	MOVQD	0,R6
	PUSH
	RET	0


	DB	95H
	DB	1,'='
	DW	LINK-$
LINK	SET	$-5
	POP
	ADDQD	4,R7
	CMPD	R6,-4(R7)
	MOVQD	-1,R6
	BEQ	$+4
	MOVQD	0,R6
	PUSH
	RET	0


	DB	3,$'MOD'
	DW	LINK-$
LINK	SET	$-6
MOD:
	REMD	0(R7),4(R7)
	ADDQD	4,R7
	RET	0


;Print word on TOS

	DB	2,$'C.'
	DW	LINK-$
LINK	SET	$-5
CPERIOD:
	MOVXWD	0(R7),-2(R7)
	ADDQD	-2,R7
	BR	PERIOD

;Build header in dictionary
;DPL holds length/text, on exit DPL updated to point to code address

HEADER:
	BSR	ASPACE
	BSR	WORD
	MOVD	CURRENTL,R0	;Current last entry pointer
	MOVD	0(R0),R3	;R3 = last header addr.
	MOVD	DPL,R1		;r1 = dict. pointer
	MOVD	R1,0(R0)	;make the token the new current last heading
	MOVXBD	0(R1),R0	;token length
	ADDQD	1,R0		;include the length-byte in the length
	ADDD	R0,R1		;r1 = addr of link word
	SUBD	R1,R3		;r3 = link offset
	CMPD	R3,-8000H
	BGE	HEA1:B		;2 byte link value if GE
	MOVQW	0,0(R1)		;0 means Dword offset follows
	MOVD	R3,2(R1)
	ADDQD	6,R1		;Point to start of code
	BR	HEA2:B
HEA1:
	MOVW	R3,0(R1)	;store link word
	ADDQD	2,R1		;update dict. pointer
HEA2:
	MOVD	R1,DPL
	RET	0


	DB	7,'<BUILDS'
	DW	LINK-$
LINK	SET	$-10
BUILDS:
	BSR	HEADER		;Build a header
	MOVD	0(SP),R3
	ADDR	SDOES,R4
	ADDQD	-1,R3
BUI1:
	ADDQD	1,R3
	MOVD	R3,R1
	MOVD	R4,R2
	MOVQD	7,R0
	CMPSB			;search for 'DOES' code
	BNE	BUI1
	MOVD	R3,R1
	ADDQD	2,R1
	BR	SBCOMMA


	DB	6,'CREATE'
	DW	LINK-$
LINK	SET	$-9
CREATE:
	BSR	BUILDS
	DOES
	RET	0


	DB	8,'VARIABLE'
	DW	LINK-$
LINK	SET	$-11
	BSR	BUILDS
	BSR	IMMED:W
	ADDQD	4,DPL
VAR1:
	DOES			;RET followed by push TOS to data stack
VAR2:
	CMPQB	0,MODEL
	BEQ	VAR1
	ADDQD	4,R7
	MOVD	-4(R7),R3
	BR	NUML2



{
The following commands push the address of the appropriate
storage address onto the stack
}
	DB	7,'CURRENT'
	DW	LINK-$
LINK	SET	$-10
CURRENT:
	ADDR	CURRENTL,TOS
	BR	VAR1+2		;Push TOS onto data stack


	DB	7,'CONTEXT'
	DW	LINK-$
LINK	SET	$-10
CONTEXT:
	ADDR	CONTEXL,TOS
	BR	VAR1+2		;2nd byte of DOES macro (TOS to R7 data stack)

	DB	3,$'>IN'
	DW	LINK-$
LINK	SET	$-6
	ADDR	TO_INL,TOS
	BR	VAR1+2		;2nd byte of DOES macro


	DB	2,$'DP'
	DW	LINK-$
LINK	SET	$-5
	ADDR	DPL,TOS
	BR	VAR1+2


	DB	4,$'BASE'
	DW	LINK-$
LINK	SET	$-7
	ADDR	BASEL,TOS
	BR	VAR1+2		;2nd byte of DOES macro


	DB	5,'STATE'
	DW	LINK-$
LINK	SET	$-8
	ADDR	STATEL,TOS
	BR	VAR1+2		;2nd byte of DOES macro


	DB	4,$'MODE'
	DW	LINK-$
LINK	SET	$-7
	ADDR	MODEL,TOS
	BR	VAR1+2		;2nd byte of DOES macro


	DB	4,$'SPAN'
	DW	LINK-$
LINK	SET	$-7
	ADDR	SPANL,TOS
	BR	VAR1+2		;2nd byte of DOES macro


	DB	3,$'BLK'
	DW	LINK-$
LINK	SET	$-6
	ADDR	BLKL,TOS
	BR	VAR1+2


	DB	4,$'#TIB'
	DW	LINK-$
LINK	SET	$-7
	ADDR	XTIBL,TOS
	BR	VAR1+2


	DB	3,$'TIB'
	DW	LINK-$
LINK	SET	$-6
	ADDR	TIBL,TOS
	BR	VAR1+2


	DB	1,':'
	DW	LINK-$
LINK	SET	$-4
	MOVD	CURRENTL,CONTEXL ;Copy last current entry
	BSR	HEADER		;Build a header
	MOVQB	1,MODEL		;Set compile flag
	RET	0


	DB	87H,5,'DOES>'
	DW	LINK-$
LINK	SET	$-9
SDOES:
	DOES


;Fetch Dword from address on TOS

	DB	8DH
	DB	1,'@'
	DW	LINK-$
LINK	SET	$-5
AT:
	POP
	MOVD	0(R6),R6
	PUSH
	RET	0


	DB	8,'CONSTANT'
	DW	LINK-$
LINK	SET	$-11
	BSR	BUILDS
	BSR	IMMED:W
	BSR	COMMA
CON1:
	DOES
	BSR	AT
	BR	VAR2


;Terminate compilation

	DB	41H,';'
	DW	LINK-$
LINK	SET	$-4
	MOVD	DPL,R0
	MOVXBW	12H,0(R0)	;RET 0 opcode
	ADDQD	2,R0
	MOVD	R0,DPL
	MOVQB	0,MODEL		;Compilation off
	RET	0


	DB	86H
	DB	3,$'DUP'
	DW	LINK-$
LINK	SET	$-7
DUP:
	MOVD	0(R7),-4(R7)
	ADDQD	-4,R7
	RET	0


;Indirect fetch of value pointed to by CURRENTL

	DB	5,'ENTRY'
	DW	LINK-$
LINK	SET	$-8
ENTRY:
	BSR	CURRENT		;Addres of CURRENTL to data stack
	BSR	AT		;Contents of CURRENTL
	BR	AT


;Return next dictionary slot on stack

	DB	4,$'HERE'
	DW	LINK-$
LINK	SET	$-7
HERE:
	ADDQD	-4,R7
	MOVD	DPL,0(R7)
	RET	0


	DB	92H
	DB	2,$'0<'
	DW	LINK-$
LINK	SET	$-6
	POP
	CMPQD	0,R6
	MOVQD	-1,R6
	BGT	$+4
	MOVQD	0,R6
	PUSH
	RET	0


	DB	92H
	DB	2,$'0='
	DW	LINK-$
LINK	SET	$-6
	POP
	CMPQD	0,R6
	MOVQD	-1,R6
	BEQ	$+4
	MOVQD	0,R6
	PUSH
	RET	0


	DB	92H
	DB	2,$'0>'
	DW	LINK-$
LINK	SET	$-6
	POP
	CMPQD	0,R6
	MOVQD	-1,R6
	BLT	$+4
	MOVQD	0,R6
	PUSH
	RET	0


	DB	8CH
	DB	2,$'1+'
	DW	LINK-$
LINK	SET	$-6
	POP
	ADDQD	1,R6
	PUSH
	RET	0


	DB	83H
	DB	2,$'1-'
	DW	LINK-$
LINK	SET	$-6
	ADDQD	-1,0(R7)
	RET	0


	DB	83H
	DB	2,$'2+'	
	DW	LINK-$
LINK	SET	$-6
	ADDQD	2,0(R7)
	RET	0


	DB	83H
	DB	2,$'2-'
	DW	LINK-$
LINK	SET	$-6
	ADDQD	-2,0(R7)
	RET	0


;Print data pointed to by value on stack

	DB	1,'?'
	DW	LINK-$
LINK	SET	$-4
	BSR	AT
	BR	PERIOD


	DB	85H,2,$'>R'
	DW	LINK-$
LINK	SET	$-6
RR:
	MOVD	0(R7),TOS
	ADDQD	4,R7
	RESTORE	[R0,R1]		;Return address to R0, pushed value to R1
	SAVE	[R1]		;Restore data value
	JUMP	R0		;Instead of RET


	DB	83H,5,'ABORT'
	DW	LINK-$
LINK	SET	$-9
	BR	ABORT


	DB	83H,4,$'QUIT'
	DW	LINK-$
LINK	SET	$-8
	BR	QUIT


;Assign storage in dictionary

	DB	5,'ALLOT'
	DW	LINK-$
LINK	SET	$-8
ALLOT:
	ADDD	0(R7),DPL
	ADDQD	4,R7
	RET	0


	DB	88H
	DB	3,$'AND'
	DW	LINK-$
LINK	SET	$-7
	POP
	ANDD	R6,0(R7)
	RET	0


	DB	8DH
	DB	2,$'C@'
	DW	LINK-$
LINK	SET	$-6
	POP
	MOVB	0(R6),R6
	PUSH
	RET	0


	DB	7,'DECIMAL'
	DW	LINK-$
LINK	SET	$-10
	MOVB	10,BASEL
	RET	0


	DB	3,$'HEX'
	DW	LINK-$
LINK	SET	$-6
HEX:
	MOVB	16,BASEL
	RET	0


;Print TOS in hex radix

	DB	2,$'H.'
	DW	LINK-$
LINK	SET	$-5
PHEX:
	MOVB	BASEL,TOS
	BSR	HEX
	BSR	PERIOD
	MOVB	TOS,BASEL
	RET	0


	DB	82H,4,$'DROP'
	DW	LINK-$
LINK	SET	$-8
DROP:
	ADDQD	4,R7
	RET	0


	DB	11,'DEFINITIONS'
	DW	LINK-$
LINK	SET	$-14
	MOVD	CONTEXL,CURRENTL
	RET	0


	DB	10,'VOCABULARY'
	DW	LINK-$
LINK	SET	$-13
	BSR	BUILDS
	BSR	ENTRY
	BSR	COMMA
VOC1:
	DOES
	BSR	CONTEXT
	BR	Y


	DB	5,'EMPTY'
	DW	LINK-$
LINK	SET	$-8
EMPTY:
	ADDR	DICT:D,R0
	MOVD	R0,DPL
	MOVD	R0,FORTHDPL
	COND	INCL_BAS
	 MOVD	R0,BASDPL
	 MOVD	R0,PSTART
	CEND

	ADDR	VOC:*,R0
	MOVD	R0,FORTHL
	MOVD	R0,FORTHVOC

	COND	INCL_BAS
	 ADDR	BVOC,R0
	 MOVD	R0,BASICL
	 MOVD	R0,BASVOC
	CEND

	MOVQW	0,REGBYTE
	MOVQW	0,RGB
	RET	0


	DB	5,'FORTH'
	DW	LINK-$
LINK	SET	$-8
	CBITB	0,WFLAG
	BFC	FORT1:B		;already in FORTH ?
	MOVD	DPL,FORTHDPL	;protect BASIC dict.
	MOVD	BASICL,BASVOC	;protect BASIC voc.
	MOVW	REGBYTE,RGB	;save reg. variable counters
FORT1:
	ADDR	FORTHL,TOS
	BR	VOC1+2


	DB	5,'BASIC'
	DW	LINK-$
LINK	SET	$-8
BASIC:
	COND	INCL_BAS
	 SBITB	0,WFLAG
	 BFS	BAS1:B		;see if already in BASIC
	 MOVD	DPL,BASDPL	;protect FORTH dict.
	 MOVD	FORTHL,FORTHVOC	;protect FORTH voc.
BAS1:
	 MOVB	0AH,BASEL
	 ADDR	BASICL,R0
	 MOVQB	0,INEXPR:#
	CEND
NEW1:
	MOVD	R0,CONTEXL
	MOVD	R0,CURRENTL
	RET	0


	DB	3,$'NEW'
	DW	LINK-$
LINK	SET	$-6
	COND	INCL_BAS
	 TBITB	0,WFLAG	;1 means BASIC
	 BFS	BNEW:B
	CEND
	MOVD	FORTHDPL,DPL
	ADDR	FORTHL,R0
	MOVD	FORTHVOC,0(R0)
	BR	NEW1
BNEW:
	COND	INCL_BAS
	 MOVW	RGB,REGBYTE
	 MOVD	BASDPL,R2
	 MOVD	R2,DPL
	 MOVD	R2,PSTART
	 MOVD	BASVOC,BASICL
	 BSR	BAS1
	CEND
	ADDR	OK,R2
	BR	STA1


	DB	9,'IMMEDIATE'
	DW	LINK-$
LINK	SET	$-12
IMMED:
	MOVD	CURRENTL,R0
	MOVD	0(R0),R0
	SBITB	6,0(R0)
	RET	0


	DB	1,27H	;TIC
	DW	LINK-$
LINK	SET	$-4
TIC:
	BSR	ASPACE
	BSR	WORD
	BSR	CONTEXT
	BSR	AT
	BSR	AT
	BSR	SEARCH
	ADDQD	2,R7
	CMPQB	0,-2(R7)
	BEQ	TIC1:B
	BSR	ENTRY
	BSR	SEARCH
	ADDQD	2,R7
	CMPQB	0,-2(R7)
	BEQ	TIC1:B
	BR	ERROR
TIC1:
	RET	0


	DB	6,'FORGET'
	DW	LINK-$
LINK	SET	$-9
	BSR	TIC
	MOVD	0(R7),R0	;code addr
	ADDQD	4,R7
	ADDQD	-2,R0	;link addr
	MOVXWD	0(R0),R1	;link
	ADDD	R0,R1	;prev. header addr
	MOVD	CURRENTL,R2
	MOVD	R1,0(R2)
	ADDQD	-1,R3	;addr of heading being forgotten
	MOVD	R3,DPL
	RET	0

ADO:	;this macro is compiled by DO
	POP
	ADDQD	4,R7
	MOVW	-4(R7),TOS
	MOVW	R6,TOS
	MOVD	0,TOS	;the 0 will be replaced by the exit address in case
	;there's a LEAVE within the loop


	DB	42H,$'DO'
	DW	LINK-$
LINK	SET	$-5
	MOVB	92H,MACROL
	ADDR	ADO,R1
	BSR	SBCOMMA
	BR	HERE	;remember this addr so we can fill in the exit addr later


ALOOP:	;this macro is compiled by LOOP to perform the conditional
	MOVQW	1,R6	;   jump back to the start of the loop
	ADDW	4(SP),R6
	CMPW	R6,6(SP)
	MOVW	R6,4(SP)
	BLO	$	;the argument will be filled in by LOOP code
ALO1:
	ADJSPB	-8


	DB	44H,$'LOOP'
	DW	LINK-$
LINK	SET	$-7
	ADDR	ALOOP,R1
	MOVB	8CH,MACROL
LOO1:
	BSR	SBCOMMA
	MOVQD	1,R1	;compute displacement for the compiled BLO instruction
	ADDD	0(R7),R1
	SUBD	DPL,R1
	BSR	RELHERE	;compile the displacement
	ADDR	ALO1,R1
	MOVB	83H,MACROL
	BSR	SBCOMMA	;compile the 'ADJSPB -8'
	MOVD	0(R7),R1	;retrieve addr of start of loop
	ADDQD	4,R7
	ROTW	8,R2	;R2 has addr of location just past the 'ADJSPB -8'
	ROTD	16,R2	;reverse order for immediate mode
	ROTW	8,R2
	MOVD	R2,-4(R1)	;put into the instruction 'MOVD 0,TOS' at start of loop
	RET	0

AIF:	POP
	CMPQB	0,R6
	BEQ	$	;argument to be filled in later


	DB	42H,$'IF'
	DW	LINK-$
LINK	SET	$-5
IF:
	ADDR	AIF,R1
	MOVB	8AH,MACROL
	BSR	SBCOMMA	;compile AIF macro
AREP:
	BR	HERE	;remember this address so we can fill in the BEQ instr.

APLOOP:
	POP
	ADDW	4(SP),R6
	CMPW	R6,6(SP)
	MOVW	R6,4(SP)
	BLO	$


	DB	45H,$'+LOOP'
	DW	LINK-$
LINK	SET	$-8
	ADDR	APLOOP,R1
	MOVB	8EH,MACROL
	BSR	SBCOMMA
	MOVQD	2,R1
	BR	LOO1


	DB	4,$'SWAP'
	DW	LINK-$
LINK	SET	$-7
SWAP:
	MOVD	0(R7),R0
	MOVD	4(R7),0(R7)
	MOVD	R0,4(R7)
	RET	0


	DB	44H,$'THEN'
	DW	LINK-$
LINK	SET	$-7
	ADDR	ANOP,R1	;compile a NOP to prevent the possibility of a push-pop
	MOVB	81H,MACROL	;sequence, which would be automatically erased, but half of
	BSR	SBCOMMA	;it would be in the conditional portion of the construct.
	BSR	BACK:W	;Fill in the forward reference in the IF or ELSE part
	ADDQD	4,R7
	RET	0


	DB	44H,$'ELSE'
	DW	LINK-$
LINK	SET	$-7
	ADDR	AREP,R1
	MOVB	83H,MACROL
	BSR	SBCOMMA	;compile a 'BR' instruction
	BSR	BACK:W	;Fill in the forward reference in the IF part
	MOVD	DPL,0(R7)	;remember this addr so we can fill in the arg. of the 'BR'
	RET	0


	DB	45H,'BEGIN'
	DW	LINK-$
LINK	SET	$-8
	ADDR	ANOP,R1	;similar to the problem in 'THEN'
	MOVB	81H,MACROL
	BSR	SBCOMMA
	BR	HERE


	DB	45H,'UNTIL'
	DW	LINK-$
LINK	SET	$-8
	ADDR	AIF,R1	;macro to do test & conditional branch
	MOVB	88H,MACROL
	BSR	SBCOMMA	;compile the macro
UNT1:
	MOVQD	1,R1
	ADDD	0(R7),R1
	ADDQD	4,R7
	SUBD	DPL,R1
	BR	RELHERE	;compile the disp for the conditional branch


BACK:	;fill in arg. of a previous forward reference (2-byte disp)
	MOVD	DPL,R1
	MOVD	0(R7),R2
BAC1:
	ADDQD	-3,R2
	SUBD	R2,R1
	ADDQD	1,R2
	BR	SBC2


	DB	46H,'REPEAT'
	DW	LINK-$
LINK	SET	$-9
REPEAT:
	ADDR	AREP,R1
	MOVB	81H,MACROL
	BSR	SBCOMMA	;compile a 'BR' opcode
	MOVQD	1,R1
	ADDD	4(R7),R1
	SUBD	DPL,R1
	BSR	RELHERE	;compile a disp to branch back to beginning of loop
	BSR	BACK	;fill in the forward ref. in the WHILE
	ADDQD	4,R7
	ADDQD	4,R7
	RET	0


	DB	45H,'WHILE'
	DW	LINK-$
LINK	SET	$-8
	BR	IF


ALEAVE:
	RET	4

	DB	45H,'LEAVE'
	DW	LINK-$
LINK	SET	$-8
LEAVE:
	MOVB	82H,MACROL
	ADDR	ALEAVE,R1
	BR	SBCOMMA	;compile LEAVE code (simply a RET 4)


;Start compiling

	DB	1,']'
	DW	LINK-$
LINK	SET	$-4
	MOVQB	1,MODEL
	RET	0


;Stop compiling

	DB	41H,'['
	DW	LINK-$
LINK	SET	$-4
	MOVQB	0,MODEL
	RET	0

COMX:
	RESTORE	[R0]
	MOVD	0(R0),R1
	ADDQD	4,R0
	SAVE	[R0]
	BR	SBCOMMA


	DB	47H,'COMPILE'
	DW	LINK-$
LINK	SET	$-10
	BSR	TIC
	ADDR	COMX,R1
	BSR	SBCOMMA
	BSR	COMMA


	DB	49H,'[COMPILE]'
	DW	LINK-$
LINK	SET	$-12
	BSR	TIC
	MOVQB	0,STATEL
	BR	BCOMMA


	DB	47H,'LITERAL'
	DW	LINK-$
LINK	SET	$-10
	BR	NUMLIT


	DB	89H
	DB	1,'I'
	DW	LINK-$
LINK	SET	$-5
	MOVXWD	4(SP),R6
	PUSH
	RET	0


	DB	89H
	DB	1,'J'
	DW	LINK-$
LINK	SET	$-5
	MOVXWD	12(SP),R6
	PUSH
	RET	0


	DB	89H
	DB	1,'K'
	DW	LINK-$
LINK	SET	$-5
	MOVXWD	20(SP),R6
	PUSH
	RET	0


	DB	88H
	DB	4,$'OVER'
	DW	LINK-$
LINK	SET	$-8
	MOVD	4(R7),R6
	PUSH
FIL1:
	RET	0


	DB	4,$'FILL'	;the fill routine has some extra junk to enable it to use
	DW	LINK-$	;   a MOVSD for most of the filling
LINK	SET	$-7
	MOVB	0(R7),R6
	MOVD	4(R7),R0
	MOVD	8(R7),R2
	ADDQD	6,R7
	ADDQD	6,R7
FIL2:
	CMPQD	0,R0
	BEQ	FIL1
	MOVB	R6,0(R2)
	MOVD	R2,R1
	ADDQD	1,R2
	ADDQD	-1,R0
	CMPQD	7,R0
	BLO	LONG:B
	MOVSB
	RET	0
LONG:
	MOVD	R0,R6
	MOVQD	4,R0
	MOVSB
	ADDQD	-4,R1
	TBITB	0,R1
	BFC	LONG1:B
	ADDQD	1,R1
	ADDQD	-1,R6
LONG1:
	MOVD	R1,R2
	ADDQD	4,R2
	MOVD	R6,R0
	ANDB	0FCH,R0
	ADDQD	-4,R0
	SUBD	R0,R6
	LSHD	-2,R0
	MOVSD
	ADDQD	-3,R2
	MOVD	R6,R0
	MOVSB
	RET	0


	DB	4,$'LOAD'
	DW	LINK-$
LINK	SET	$-7
LOAD:
	MOVD	TO_INL,TOS	;save input-stream pointer
	MOVD	BLKL,TOS	;save block # pointer
	MOVQD	0,TO_INL
	MOVD	0(R7),BLKL	;pop # of block to load
	ADDQD	4,R7
	BSR	INTERP		;interpret the block
	MOVD	TOS,BLKL
	MOVD	TOS,TO_INL
	RET	0


	DB	41H,'('
	DW	LINK-$
LINK	SET	$-4
	ADDQD	-2,R7
	MOVB	')',0(R7)	;Closing delimiter
	BR	WORD


	DB	46H,'ABORT"'
	DW	LINK-$
LINK	SET	$-9
	ADDR	ABQUOTE,R1
	MOVB	'"',R6	;ending delimiter
	BR	PQU1:B


	DB	42H,$'."'
	DW	LINK-$
LINK	SET	$-5
	MOVB	'"',R6	;ending delimiter
PQU0:
	ADDR	PQUOTE,R1
PQU1:
	BSR	SBCOMMA	;compile a call to literal handler
	ADDQD	-2,R7
	MOVB	R6,0(R7)
	BSR	WORD	;compile the literal string
	MOVD	DPL,R1
	MOVXBD	0(R1),R0
	ADDQD	1,R0
	ADDD	R0,R1	;change dict. pointer to enclose the compiled string
	MOVD	R1,DPL
	RET	0


PQUOTE:	;a literal handler to print a string
	RESTORE	[R2]
	BSR	STYPE
	JUMP	1(R2)


	DB	3,$'ABS'
	DW	LINK-$
LINK	SET	$-6
ABS:
	ABSD	0(R7),0(R7)
	RET	0


	DB	88H
	DB	1,'+'
	DW	LINK-$
LINK	SET	$-5
PLUS:
	POP
	ADDD	R6,0(R7)
	RET	0
ANOP:
	NOP

	COND	INCL
LINK433	EQU	LINK:#		;link to next module
	CELSE
LINK433	EQU	LINK-$:#	;link to next module
	CEND
