F432:	MODULE

;           432  --  FORTH-83 for 32000 processor
;by Neil R. Koozer  --  November 13,1984      July 7, 1985
;   Kellogg Star Rt. Box 125
;   Oakland, OR 97462
;   (503)-459-3709
;Everyone is welcome to use this code and give it to others, but you may not
;include it in any commercial product or charge money for it.
;Distributors of public domain material may include this code on the media
;which they distribute for a nominal copy fee.
;   August 21, 1985     Sept 14, 1985         Nov 18, 1985
;   Nov 27, 1985        January 6, 1986       January 29, 1986

;Modified by Don Rowe for Kotekan 32000 assembler
;Many changes were made to make the code relocatable and ROMable:
;  All JSR opcodes changed to BSR
;  All storage made SB relative
;  All absolute address references changed to PC/SB relative
;So far only the FORTH has been changed, not BASIC
;Only limited testing has been done and no guarantees are offered

	COND	NOT INCL
	 EXTRN	F433,F434,B4B0,B4B1,B4B2
	 EXTRN	BLOCK,CLS,INEXPR,SYNERR,TIC,VOC

	 GLOBAL	ABORT,ABQUOTE,ASPACE,BCOMMA,BRCOMMA,COMMA,DICT
	 GLOBAL	DSTACK,EDTABL,ERR1,ERROR,FINDWRD,INTERP,INTERP1
	 GLOBAL	IOWORD,JUNK,LINK432,NUML2,NUMLIT,OK,QRUN,QUI1
	 GLOBAL	QUIT,RELDISP,RELHERE,SAVESP,SBC2
	 GLOBAL	SBC4,SBCOMMA,SCRLF,SEARCH,SEMIT,SKEY
	 GLOBAL	STA1,STRD0,STRD1,STRD2,STYPE,TESTIT
	 GLOBAL	TYP1,TYP2,WFLAG,WORD
	CEND

{
R7 is data stack
PUSH and POP macros assume data in R6
Most data items are 32 bits, EMIT and KEY are 16 bits
Changing PUSH or POP macro also requires changing SBMACRO
DPL is dictionary pointer
CURRENTL points to current last word in dictionary (start of search)
BASEL is current radix
MODEL=0 if not in compile mode
}

	MODE	SB
DICT:	DS	DICT_SIZ	;Dictionary continues up from here
	DS	STK_SIZ		;Data stack builds down from here
DSTACK:
	BLKD	8		;Allow for stack underflow
WFLAG:	BLKW			;0=FORTH, 1=BASIC
IOWORD:	BLKW			;similar to CPM's IOBYTE
SAVESP:	BLKD			;Storage for return stack pointer
NUM_BUF: BLKD	4		;Buffer for number compilation by NUML5

CURRENTL:: BLKD			;Current last dictionary entry
CONTEXL::  BLKD			;FORTH/BASIC
TO_INL:: BLKD
DPL::	BLKD			;Pointer to next available dictionary slot
BASEL::	BLKB			;Current radix
STATEL:: BLKB
MODEL::	BLKB			;0= not compiling
SPANL::	BLKD
BLKL::	BLKD			;Block to load, -1=keyboard input
XTIBL::	BLKD			;Length of TIBL 
TIBL::	DS	KBUFLEN		;keyboard buffer
JUNK::	DS	128		;Temporary buffer for use within one routine
EDTABL:	BLKD			;Edit table
	BLKB	5		;Cursor positioning command built here
	BLKW
MACROL:: BLKB
FORTHDPL:: BLKD		;this stuff has to do with maintaining pointers when
FORTHVOC:: BLKD		;   switching between FORTH and BASIC
BASDPL:: BLKD
BASICL:: BLKD
BASVOC:: BLKD
RGB::	BLKW
REGBYTE:: BLKD
FORTHL:: BLKD

SCRL::	BLKD		;Current block number
CURBUF:: BLKB		;currently active buffer number
BUFBLK:: BLKW	NBUFFS	;table of block numbers assigned to each buffer
BUFFLG:: BLKW	NBUFFS	;table of update flags,
			;  1st byte is number of accesses negated
			;  Bit 15 set if buffer changed
BUFADD:: BLKD	NBUFFS	;Table of block addresses
BLOKBUF:: DS	NBUFFS*BUFLEN ;Storage for block buffers
EDBUF::	DS	64*24	;Edit buffer, auxilliary buffer follows main buffer
			;Listed by BLIST
;IOPB::	DS	2*BUFLEN ;Disk IO buffer
	MODE	PC

BEGIN::
	SPRD	SP,SAVESP	;SP saved here
	BR	START:W
STKMSG:	DB	11,'Stack Error'
MSGQ:	DB	1,'?'
OK:	DB	3,$' OK'
OKCR:	DB	5,$' OK',0DH,0AH
SRTMSG:	MAC_MSG	<'Kotekan FORTH-83 version 1.1'>
RSTMSG:	DB	13,13,10,'432 Restart'
BSPACE:	DB	3,8," ",8	;Backspace string

	DB	7,'EXECUTE'
	DW	0		;32 bit link value follows
	DD	0		;end of linked list
LINK	SET	$-14

EXECUTE:
	MOVD	(R7),TOS
	ADDQD	4,R7
	RET

	MAC_LINK "EMIT"	
EMIT:
	MOVZBD	0(R7),R0	;POP CHAR
	ADDQD	2,R7
SEMIT:
	SAVE	[R1]
	MOVB	IOWORD,R1
	ANDB	3,R1
	CMPQB	2,R1		;see if re-routed to printer
	RESTORE	[R1]
	BEQ	PEMIT:B

;Send byte in R0 to console

	save	[r5,r6]
	movzbd	r0,r5
	movd	dev_vid+dof_chr*256,r6 	;System message output
	svc
	restore	[r5,r6]
	ret

;Send byte in R0 to printer

PEMIT:			;all 3 ports used for the printer have inverting I.C.'s
	save	[r5,r6]
	movzbd	r0,r5
	movd	dev_pr+dof_chr*256,r6
	svc
	restore	[r5,r6]
	ret


;Return keypress in R0

SKEY:
	save	[r5,r6]
	movd	dev_kbd+dof_chr*256,r6 ;Keyboard input
	svc
	movzbd	r5,r0
	restore	[r5,r6]
	ret


;"KEY"
;Get a keypress
;Return on stack:W

	DB	3,$'KEY'
	DW	LINK-$
LINK	SET	$-6
KEY:
	BSR	SKEY
	ADDQD	-2,R7
	MOVZBW	R0,0(R7)
	RET	0

;"CR"
;Do CR/LF

	DB	2,'C','R'
	DW	LINK-$
LINK	SET	$-5
SCRLF:
	MOVB	0DH,R0
	BSR	SEMIT
	MOVB	0AH,R0
	BR	SEMIT

STYPE:
;print a string, 1st byte is char count
;R2 holds pointer to string, updated on exit

	SAVE	[R4]
	BSR	TYP_R2
	RESTORE	[R4]
	RET

;Print string in (R2), 1st byte is length
;R4 is altered

TYP_R2:
	MOVZBD	0(R2),R4	;char count

;Print string in 1(R2), length in R4

TYP1:	ADDQD	1,R2		;Skip over count

;Print string in (R2), length in R4:W

TYP2:	save	[r0,r1,r6]
	movd	r2,r1		;Pointer
	movzwd	r4,r0		;Length
	sbitb	bkb_cnt,r0	;Terminate on count in r0
	movd	dev_vid+dof_blk*256,r6 ;Block output to video
	svc
	restore	[r0,r1,r6]
	addd	r4,r2		;Advance past text
	ret


;"TYPE"
;TOS holds length:W, next on stack holds string pointer

	DB	4,$'TYPE'
	DW	LINK-$
LINK	SET	$-7
TYPE:
	MOVZWD	0(R7),R4	;char count
	ADDQD	4,R7
	MOVD	0(R7),R2	;string addr.
	ADDQD	4,R7
	BR	TYP2

;"EXPECT"
;TOS is buffer pointer, next byte is count
;Input until CR, then echo a space and store length in SPANL

	DB	6,'EXPECT'
	DW	LINK-$
LINK	SET	$-9
	MOVD	4(R7),R5	;get count
	MOVD	R5,R6		;get buffer address
	ADDD	0(R7),R5	;end of buffer
	ADDQD	4,R7
	ADDQD	4,R7

;R6 => input buffer, R5 holds highest address
;Translate lower case to upper case, echo all but last CR
;Input a line until CR, echo a space and store length in SPANL
;R3 holds character count exclusive of CR

SEXPECT:
	save	[r0,r1,r6]
	movd	r5,r0
	subd	r6,r0		;Number of characters to read
	addqd	1,r0		;Inclusive count

;LC to UC conversion, editing enabled, echo input but not final CR

	ord	exp bkb_tr5+exp bkb_edt+exp bkb_cnv+exp bkb_eko,r0
	movd	r6,r1		;Buffer to R1
	movd	dev_kbd+dof_blk*256,r6 ;Block input from keyboard
	movzbd	13,r5		;Stop on CR
	svc
	movzwd	r0,r3
	addqd	-1,r3		;Don't return length of CR
	restore	[r0,r1,r6]

	MOVB	" ",R0
	BSR	SEMIT
	MOVD	R3,SPANL 	;store the count
	RET	0

;"QUERY"
;Input a string to TIBL, store length in XTIBL

	DB	5,'QUERY'
	DW	LINK-$
LINK	SET	$-8
QUERY:
	ADDR	TIBL,R6		 ;Kbd input buffer
	ADDR	KBUFLEN-1(R6),R5 ;Last byte of buffer
	BSR	SEXPECT
	MOVQB	-1,TIBL[R3:B]	;hard delimiter
	MOVQD	0,TO_INL	;reset input stream pointer
	MOVQD	-1,BLKL		;-1 means keyboard input
	MOVD	SPANL,XTIBL	;another copy of char count
	RET	0

;"," (comma)
;Move TOS:D into DPL:D and advance DPL

	DB	1,','
	DW	LINK-$
LINK	SET	$-4

COMMA:				;compile a 32-bit entity into the dictionary
	MOVD	DPL,R0
	MOVD	0(R7),0(R0)
	ADDQD	4,R7
	ADDQD	4,R0
	MOVD	R0,DPL
	RET	0

;"W,"
;Move TOS:W into DPL:W and advance DPL

	DB	2,$'W,'
	DW	LINK-$
LINK	SET	$-5

WCOMMA:				;compile a 16-bit entity into the dictionary
	MOVD	DPL,R0
	MOVW	0(R7),0(R0)
	ADDQD	2,R0
WCO1:
	ADDQD	2,R7
	MOVD	R0,DPL
	RET	0

;"C,"
;Move TOS:W into DPL:B and advance DPL

	DB	2,$'C,'
	DW	LINK-$
LINK	SET	$-5

CCOMMA:				;compile a byte into the dictionary
	MOVD	DPL,R0
	MOVB	0(R7),0(R0)
	ADDQD	1,R0
	BR	WCO1

;Move binary value in R1 to displacement in (R2) and advance R2

RELDISP:			;compile a quantity in the 32000 'disp' format
	CMPD	R1,1FFFH	;see if D required
	BGT	SBC4:B
	CMPD	R1,-2000H
	BLT	SBC4:B
	CMPW	R1,3FH		;see if W required
	BGT	SBC2:B
	CMPW	R1,-40H
	BLT	SBC2:B
	ANDB	7FH,R1		;make byte disp format
	MOVB	R1,0(R2)	;store disp into dict.
	ADDQD	1,R2
	BR	SBC1:B
SBC4:
	ROTW	8,R1		;reverse the order
	ROTD	16,R1
	ROTW	8,R1
	ORB	0C0H,R1		;format the hi byte
	MOVD	R1,0(R2)	;store into dict.
	ADDQD	4,R2
	BR	SBC1:B
SBC2:
	ROTW	8,R1	;reverse the order
	ANDB	3FH,R1	;format the hi byte
	ORB	80H,R1
	MOVW	R1,0(R2)
	ADDQD	2,R2
SBC1:
	RET	0

;Put a relative jump into (DPL), R1 holds address

BRCOMMA:		;compile a BR jump to addr in R1
	MOVD	DPL,R2
	MOVB	0EAH,0(R2)
	BR	SBC0:B

;"B,"
;TOS holds address for subroutine call, compile into (DPL)

	DB	2,$'B,'
	DW	LINK-$
LINK	SET	$-5
BCOMMA:
	MOVD	0(R7),R1
	ADDQD	4,R7
SBCOMMA:			;compile a BSR call to addr in R1
	MOVD	DPL,R2
	MOVZBD	MACROL,R0	;let's see if it's a macro
	MOVQB	0,MACROL	;clear the macro indicator
	TBITB	7,R0		;test flag to compile macro instead of a call
	BFS	SBMACRO:B	;R0 holds length if macro
	MOVQB	2,0(R2)		;'BSR' opcode
SBC0:
	SUBD	R2,R1		;rel dislacement value
	ADDQD	1,R2
SBC5:
	BSR	RELDISP		;compile the disp
SBC6:
	MOVD	R2,DPL
	RET	0

;R1 holds binary value, compile as displacement into (DPL)

RELHERE:		;compile the value in R1 in the 32000 disp format
	MOVD	DPL,R2
	BR	SBC5

;R1 => string, R0=length, move into (DPL)
;Also removes redundant PUSH/POP

MOVE1:
	MOVSB
	BR	SBC6

SBMACRO:			;compile a macro
	ANDB	7FH,R0		;byte count in macro
	SAVE	[R0,R2]
	BSR	MOVE1
	RESTORE	[R4,R5]		;check for push-pop sequence
	MOVD	R5,R1
	ADDQD	-5,R1		;5 byte PUSH from previous definition
	ADDR	PUSHPOP,R2
	MOVZBD	10,R0		;5 byte previous PUSH, 5 byte current POP 
	CMPSB
	BEQ	SBM1:B		;Redundant PUSH/POP if EQ
	MOVD	DPL,R2
	RET	0

SBM1:				;remove push-pop sequence
	MOVD	R5,R2
	ADDQD	-5,R2		;Address of last PUSH
	MOVD	R4,R0
	ADDQD	-5,R0		;Current byte count less initial POP
	BR	MOVE1		;move the macro to close up the gap
PUSHPOP:
	PUSH
	POP

;"ASPACE"
;Push " " onto stack:W

	DB	6,'ASPACE'
	DW	LINK-$
LINK	SET	$-9
ASPACE:
	ADDQD	-2,R7
	MOVZBW	" ",0(R7)	;PUSH 20H TO DATA STAK
	RET	0

;NE true if non-space found
;EQ true if space or end of line

FINDWRD:		;find the next non-space in the input stream
	MOVD	BLKL,R0		;Block number to load
	CMPQD	-1,R0		;-1 if keyboard input
	BEQ	KBUF:B
	MOVD	R0,-4(R7)
	ADDQD	-4,R7		;Block number to TOS
	BSR	BLOCK		;Get address of block
	ADDQD	4,R7
	MOVD	-4(R7),R6	;Pointer to block text
	MOVD	BLKLEN,R1	;Length in R1
	BR	WOR1:B
KBUF:
	ADDR	TIBL,R6		;Buffer pointer
	MOVD	XTIBL,R1	;Length of buffer
WOR1:
	ADDD	R6,R1		;R1=last address
	MOVD	TO_INL,R2
	ADDD	R6,R2
	MOVD	DPL,R3
	MOVB	0(R7),R0	;POP SEP. CHAR
	ADDQD	2,R7
	CMPB	R0,20H		;SEP = SPACE?
	BNE	WOR2:B
IGNLB:
	CMPD	R1,R2
	BEQ	WOR2:B
	CMPB	20H,0(R2)	;FIND NON-SPACE
	BNE	WOR2:B
	ADDQD	1,R2
	BR	IGNLB
WOR2:
	RET	0


;"WORD"
;TOS holds delimiter character
;Advance to 1st non-space

	DB	4,$'WORD'
	DW	LINK-$
LINK	SET	$-7
WORD:
	BSR	FINDWRD
	MOVZBD	WFLAG,R4	;1 = BASIC syntax, 0 = FORTH syntax or literal strings
	ROTD	-2,R4		;save the flag in a safe place
	MOVQW	0,R4		;SET COUNT = 0
	BEQ	ENDTOK:W	;jump if FINDWRD failed
	CMPB	' ',R0
	BEQ	TOK:B
	CBITB	30,R4
	BR	TOK:B
COUNT:
	ADDQD	1,R4	;CHAR COUNT
	ADDQD	1,R3	;DICT POINTER
TOK4:
	ADDQD	1,R2	;L. B. POINTER
TOK:
	CMPD	R1,R2
	BLS	ENDTOK:W
	MOVZBD	0(R2),R5	;GET BYTE
	CMPB	'^',R0		;^ terminator means contrl char
	BNE	TOK3:B
	SUBB	40H,R5
	MOVB	R5,1(R3)
	MOVB	R0,R5
	ADDQD	1,R4
	ADDQD	1,R3
TOK3:
	MOVB	R5,1(R3)	;STORE BYTE
	TBITB	30,R4		;see if BASIC syntax
	BFC	TOK1:B		;FC=FORTH
TOK2:
	CASEB	WTABLE[R5:B]
TOK5:	;delimiter found
	CMPQW	0,R4	;see if first char
	BNE	ENDTOK:B	;1st char being delimiter is error
TOK51:
	CBITB	30,R4	;change flag to accept any FORTH word
	BR	COUNT
TOK6:	;numeral found
	CMPQW	0,R4
	BNE	COUNT	;ok if not first char
	CMPQB	3,MODEL
	BEQ	COUNT	;ok if within expression
	BR	TOK51
TOK1:
	CMPB	R5,R0	;CHECK FOR TERMINATOR
	BNE	COUNT
	ADDQD	1,R2	;L. B. POINTER
	BSR	STRD2 ;was the terminator a string delimitor?
	BNE	ENDTOK:B
	BSR	STRD1 ;is next char a string delimiter?
	BEQ	TOK4
ENDTOK:
	SUBD	R6,R2
	MOVD	R2,TO_INL
	MOVD	DPL,R1
	MOVB	R4,0(R1)	;STORE CHAR COUNT IN HEADER
	RET	0

STRD1:
	MOVB	0(R2),R0
STRD2:
	CMPB	'"',R0
	BEQ	STRD0:B
	CMPB	27H,R0
	BEQ	STRD0:B
	CMPB	60H,R0
	BEQ	STRD0:B
	CMPB	'~',R0
	BEQ	STRD0:B
	CMPB	'|',R0
	BEQ	STRD0:B
	CMPB	'^',R0
STRD0:
	RET	0

WTABLE:	;sacrifices memory for speed
	DB	TOK5-TOK2	;control codes
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2	;control codes
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2	;space
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	COUNT-TOK2	;$
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK6-TOK2	;0
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2
	DB	TOK6-TOK2	;9
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2	;@
	DB	COUNT-TOK2	;A
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2	;P
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2	;Z
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	COUNT-TOK2	;_
	DB	TOK5-TOK2	;`
	DB	COUNT-TOK2	;a
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2	;p
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2
	DB	COUNT-TOK2	;z
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2
	DB	TOK5-TOK2



	DB	6,'SEARCH'
	DW	LINK-$
LINK	SET	$-9
SEARCH:
	MOVD	0(R7),R2	;HEADER POINTER
	MOVD	DPL,R5		;DICT. POINTER
TESTIT:
	MOVD	R5,R1
	MOVZBD	0(R2),R0	;HEADER LEN.
	MOVB	R0,MACROL	;in case its a macro
	TBITB	7,R0		;bit 7 set = macro
	BFC	SEA1:B
	ADDQD	1,R2
	MOVZBD	0(R2),R0	;get new token length byte
SEA1:
	MOVB	R0,STATEL	;store for immediate flag
	ANDB	3FH,R0		;strip flags from char count
	ADDQD	1,R2		;point to first char
	MOVD	R2,R3		;SAVE R2
	MOVD	R0,R4		;save R0
	CMPB	R0,0(R1)	;compare length byte separately (the null word has 0 length)
	BNE	NXTHDR:B
	ADDQD	1,R1
	CMPSB			;COMPARE STRINGS
	BNE	NXTHDR:B
	ADDQD	2,R2		;SKIP LINK
	CMPQW	0,-2(R2)	;0 means a 32-bit link value follows
	BNE	SEA2:B
	ADDQD	4,R2
SEA2:				;Match found, return code address on stack
	MOVD	R2,0(R7)	;PUT IT IN SAME STACK SPOT
	BR	FLAG:B		;R0 = FLAG = 0
NXTHDR:
	MOVD	R3,R2		;RESTORE R2
	ADDD	R4,R2		;R4 = lenth of name, get ADDR OF LINK WORD
	MOVXWD	0(R2),R0	;LINK WORD IS OFFSET
	ADDD	R0,R2		;ADDR OF NEXT HEADER
	CMPQW	0,R0		;0 means a 32-bit link value follows
	BNE	TESTIT
	MOVD	2(R2),R0
	ADDD	R0,R2
	CMPQD	0,R0		;0 means end of dictionary
	BNE	TESTIT
	MOVQW	-1,R0		;MAKE FLAG = TRUE
	ADDQD	4,R7		;Drop address from stack
FLAG:
	ADDQD	-2,R7		;PUSH FLAG
	MOVW	R0,0(R7)	;0=found
	RET	0


PAT1:
	ADDR	STKMSG,R2
PATCH:	;fix up environment after error
	CMPQB	0,MODEL	;see if a word definition was in progress
	BEQ	STA1:W
	MOVD	CURRENTL,R0	;Current last word in dictionary
	MOVD	0(R0),R1	;addr of word to be deleted
	MOVD	R1,DPL		;make it free space
	MOVZBD	0(R1),R3	;char count
	ADDQD	1,R3
	ADDD	R3,R1		;addr of link word
	MOVXWD	0(R1),R3	;get link offset & convert to 32 bits
	ADDD	R3,R1		;addr of previous heading
	MOVD	R1,0(R0)	;make it the current last entry
	BR	STA1:W

ERROR:
	MOVD	DPL,R2
	COND	INCL_BAS
	 TBITB	0,WFLAG		;see if BASIC
	 BFC	ERR1:B		;Not BASIC if FC
	 BR	SYNERR
	CEND
ERR1:
	BSR	SCRLF
	BSR	STYPE		;print name of unk token
	ADDR	MSGQ,R2		;addr of '?' msg
	BR	PATCH
INT1:
	TBITB	6,STATEL
	MOVQB	0,STATEL
	BFS	QEX1:B		;execute if STATE = imm.
	CMPQB	0,MODEL
	BEQ	QEX1:B
	BR	BCOMMA		;compile if MODE = 1
QEX1:
	ADDQD	4,R7		;call subr whose addr is
	MOVD	-4(R7),R0	;   on DSTACK (EXECUTE)
	JSR	R0
	ADDR	DSTACK,TOS
	CMPD	R7,TOS		;check for stack error
	BHI	PAT1
	RET	0

;"CONVERT"
;TOS holds pointer to ASCII number, 2nd on stack is current subtotal
;Update both values until invalid digit and return on stack

	DB	7,'CONVERT'
	DW	LINK-$
LINK	SET	$-10
	MOVD	4(R7),R3	;Current sub-total
	MOVD	0(R7),R2	;Pointer to ASCII number
	BSR	NLOOP:B
	MOVD	R3,4(R7)
	MOVD	R2,0(R7)
	RET	0



;R2=> address of ASCII number-1, R3 holds current subtotal
;BASEL holds radix, return new subtotal in R3 and advance R2 until
;invalid digit

NLOOP:			;loop to convert a string to a number
	ADDQD	1,R2
	MOVZBD	0(R2),R4	;GET CHAR
	SUBB	30H,R4
	BCS	NUMEND:B
	CMPB	R4,0AH
	BLO	NUMB:B
	CMPB	R4,11H
	BLO	NUMEND:B
	ADDQB	-7,R4
NUMB:
	MOVZBD	BASEL,R5	;RADIX
	CMPB	R4,R5
	BHS	NUMEND:B
	MULD	R5,R3	;RESULT = RESULT * RADIX
	ADDD	R4,R3	;RESULT = RESULT + NUMB
	BR	NLOOP
NUMEND:
	RET	0


INTERP:				;this loop gets exited by the null word when
	BSR	INTERP1:B	;the input stream is exausted
	BR	INTERP

INTERP1:			;interpret one word from input stream
	BSR	ASPACE		;make the delimiter a space
	BSR	WORD

	COND	INCL_BAS
	 CMPQB	0,INEXPR	;1 means in BASIC expression
	 BEQ	INT2:B
	 MOVB	1(R1),R0	;if in BASIC check for number to avoid searching dictionary
	 SUBB	30H,R0
	 CMPB	9,R0
	 BHS	NUMBER:B
	CEND
INT2:
	ADDQD	-4,R7
	MOVD	CONTEXL,R0
	MOVD	0(R0),0(R7)	;same as CONTEXT @ @
	BSR	SEARCH
	ADDQD	2,R7		;Result of search, 0 is successful
	CMPQB	0,-2(R7)
	BEQ	INT1		;execute if found

NUMBER:				;try to interpret the word as a number
	MOVD	DPL,R2
	MOVZBD	0(R2),R0
	MOVB	1(R2),R1
	CMPB	'-',R1
	MOVQD	0,R3		;RESULT REG
	MOVQB	0,R1		;SIGN = '+'
	BNE	SKPSAV:B
	MOVQB	-1,R1		;SIGN = '-'
	ADDQD	-1,R0		;FIX CHAR COUNT
	ADDQD	1,R2		;CHAR POINTER
SKPSAV:
	ADDD	R2,R0
	ADDQD	1,R0
	BSR	NLOOP		;convert the string to a number
	CMPD	R0,R2		;see if the string was used up
	BNE	ERROR
	CMPQB	0,R1		;0=positive NZ=negative
	BEQ	DONE:B
	NEGD	R3,R3
DONE:
	CMPQB	0,MODEL		;see if compile mode
	BNE	NUMLIT:B
	MOVD	R3,-4(R7)	;push number to stack if not compile mode
	ADDQD	-4,R7
	RET	0

NUMLIT:
	CMPQB	3,MODEL		;3 means in BASIC expression
	BNE	NUML5:B
	MOVD	R3,R6		;return number in R6
	MOVD	H'14,R5		;14h in R5 means 'immediate' addressing mode
	RET	0


;Compile a number in R3

NUML5:	;the rest of this routine is due for revision although
	CMPQD	7,R3	;   it works ok
	BLT	NUML1:B
	CMPQD	-8,R3
	BGT	NUML1:B

;Can use Quick mode here

	ADDR	QNUMBER,R1	;MOVQD XX,R6/PUSH
	MOVMD	R1,NUM_BUF,4	;Copy data to SB storage
	ADDR	NUM_BUF,R1	;Now point to SB copy
	MOVZBD	87H,R0		;7 byte macro (bit 7 set)
	ANDW	0FH,R3
	ORW	0BE60H,R3	;<MOVQD 0,R6> ROT -7
	ROTW	7,R3
	MOVW	R3,0(R1)
	BR	NUMSTOR:W
NUML1:
	CMPD	127,R3		;Max signed byte value
	BLT	NUML2:B
	CMPD	-128,R3
	BGT	NUML2:B
	ADDR	BNUMBER,R1
	MOVMD	R1,NUM_BUF,4	;Copy data to SB storage
	ADDR	NUM_BUF,R1	;Now point to SB copy
	MOVZBD	89H,R0		;9 byte macro
	MOVB	R3,3(R1)	;Store signed byte value
	BR	NUMSTOR:B
NUML2:
	ADDR	DNUMBER,R1
	MOVMD	R1,NUM_BUF,4	;Copy data to SB storage
	ADDR	NUM_BUF,R1	;Now point to SB copy
	MOVZBD	8BH,R0		;11 byte macro
	ROTW	8,R3
	ROTD	16,R3
	ROTW	8,R3
	MOVD	R3,2(R1)	;Reverse order of digits
NUMSTOR:
	COND	INCL_BAS
	 ADDR	BASICL,TOS
	 CMPD	CONTEXL,TOS	;Check for BASIC
	 BEQ	NUML3:B
	CEND
NUML4:				;This is for FORTH
	MOVB	R0,MACROL	;Compile MACRO into dictionary
	BR	SBCOMMA
NUML3:
	ADDQD	-5,R0		;Drop PUSH if in BASIC
	BR	NUML4

;Executable code portion of number compilation routine

QNUMBER:
	MOVQD	0,R6
	PUSH
BNUMBER:
	MOVXBD	0,R6
	PUSH
DNUMBER:
	MOVD	0,R6
	PUSH


;Start of main execution routine

START:
	BSR	CLS		;clear screen
;	ADDR	RSTMSG,R2	;addr of warm start message
;	CMPQB	0,BASEL		;0 means we have a cold start
;	BNE	STA1:B
	MOVQW	0,WFLAG		;Start with FORTH
	MOVW	95H,IOWORD	;Route to console

	MOVB	10,BASEL	;set decimal number base

	MOVQD	0,TO_INL
	MOVQB	0,STATEL
	MOVQB	0,MODEL	;Interpret mode
	MOVQD	0,SPANL
	MOVQD	-1,BLKL		;Block to interpret, -1=keyboard
	MOVQB	0,MACROL	;No macro yet
	MOVQD	0,XTIBL	;Nothing in buffer
	MOVQW	0,RGB
	MOVQB	0,REGBYTE	;count of integer register variables
	MOVQD	0,SCRL

	ADDR	EDTABL,R1
	MOVQD	0,(R1)
	MOVQB	4,4(R1)		;Length of cursor string
	movb	vc_scr,5(r1)	;Cursor positioning command
	movb	vcs_cur,6(r1)
	MOVW	0,9(R1)

	MOVQB	0,CURBUF	;Currently active buffer
	ADDR	BUFBLK,R1
	MOVQD	0,R0		;Buffer counter
	UNTIL	EQ
	 MOVW	R0,(R1)
	 ADDQD	2,R1
	 ADDQD	1,R0
	 CMPD	R0,NBUFFS
	ENDU

	ADDR	BUFFLG,R1
	MOVD	NBUFFS-1,R0	;Number of buffers
	ADDR	1(R1),R2
	ADDR	2(R1),R2	;Target address
	MOVQW	0,(R1)
	MOVSW

	ADDR	BUFADD,R1	;Table of buffer block addresses
	MOVD	NBUFFS,R0	;Number of buffers
	ADDR	BLOKBUF,R2	;Address of 1st buffer
	UNTIL	EQ
	 MOVD	R2,(R1)
	 ADDD	BUFLEN,R2	;Address of next buffer
	 ADDQD	4,R1		;Next pointer
	 ADDQD	-1,R0
	 CMPQD	0,R0
	ENDU	

	ADDR	BLOKBUF,R1
	MOVD	NBUFFS*BUFLEN-1,R0 ;Size of all buffers
	ADDR	1(R1),R2
	MOVB	" ",(R1)
	MOVSB			;Fill buffers with blanks

	ADDR	DICT:B,R1	;Next available dictionary slot in SB area
	MOVQW	1,(R1)		;Build dummy null entry
	ADDR	VOC-2:*,R0	;Last defined entry in PC area-2
	SUBD	R1,R0		;Offset to last actual entry from DICT+2
	MOVQW	0,2(R1)		;32 bit offset follows
	MOVD	R0,4(R1)	;Dword offset
	MOVW	L'1200,8(R1)	;RET 0 opcode

	ADDR	10(R1),DPL	;Next dictionary slot
	ADDR	10(R1),FORTHDPL	;FORTH next dictionary slot
	MOVD	R1,FORTHVOC	;Current start of vocabulary
	MOVD	R1,FORTHL	;Current last FORTH entry
	ADDR	FORTHL,CURRENTL ;Last current entry
	ADDR	FORTHL,CONTEXL

	COND	INCL_BAS
	 ADDR	BVOC,BASICL
	 ADDR	BVOC,CBASVOC
	 ADDR	DICT,BASDPL
	CEND

	ADDR	SRTMSG,R2	;addr of cold start message


;Re-entry point, R2 holds address of length/message to display

STA1:
	BSR	STYPE
	BSR	SCRLF
ABORT:
	ADDR	DSTACK,R7	;reset data stack pointer
QUIT:
	LPRD	SP,SAVESP	;reset return stack pointer
	MOVQB	0,MODEL		;Not compiling
	MOVQB	0,STATEL
QUI1:				;this is the start of the command loop
	BSR	QUERY		;get a keyboard line

 ;reset @PSTART, which points to beginning of executable compiled code

	COND	INCL_BAS
	 MOVD	DPL,PSTART
	CEND

	BSR	INTERP		;interpret the line from keyboard
	BSR	QRUN:B
	ADDR	OKCR,R2
	BSR	STYPE
	BR	QUI1
QRUN:				;run any existing compiled executable code
	COND	INCL_BAS
	 ADDR	BASICL,TOS
	 CMPD	TOS,CONTEXL 	;see if we're in BASIC
	 BNE	QRU0:W		;Nothing to do if not in BASIC
	 MOVD	PSTART,R6
	 MOVD	DPL,R2
	 CMPD	R2,R6
	 BEQ	QRU0:W		;EQ means no executable code has been compiled
	 MOVW	12H,0(R2)	;compile a RET 0
	 SAVE	[R6,R7]
	 GETREG
	 MOVD	4(SP),R6
	 JSR	R6		;execute the compiled code
	 PUTREG
	 RESTORE [R6,R7]
 ;reset dict. pointer to where the compiled code had been
	 MOVD	R6,DPL
	CEND
QRU0:
	RET	0


	DB	85H	;Byte count of macro with bit 7 set to indicate macro
	DB	2,$'2/'
	DW	LINK-$
LINK	SET	$-6
	ASHD	-1,0(R7) ;This compiled right into the code instead
			;of being called
	RET	0	;not part of macro; the return is for non-compile mode


	DB	86H
	DB	2,$'R@'
	DW	LINK-$
LINK	SET	$-6
	ADDQD	-4,R7
	MOVD	0(SP),0(R7)
	RET	0


;TOS is byte count, 2nd on stack is pointer to text
;Remove trailing blanks

	DB	9,'-TRAILING'
	DW	LINK-$
LINK	SET	$-12
	MOVD	0(R7),R0
	MOVD	4(R7),R1
	ADDD	R0,R1
	ADDQD	-1,R1
	MOVB	20H,R4
	SKPSB	B,W
	MOVD	R0,0(R7)
	RET	0


;Rotate top 3 stack entries: 1,2,3 => 3,1,2

	DB	3,$'ROT'
	DW	LINK-$
LINK	SET	$-6
	MOVD	8(R7),R0
	MOVD	4(R7),8(R7)
	MOVD	0(R7),4(R7)
	MOVD	R0,0(R7)
	RET	0


;Address of PAD (Next availabe byte of dictionary + 100H

	DB	3,$'PAD'
	DW	LINK-$
LINK	SET	$-6
	MOVD	100H,R6
	ADDD	DPL,R6
	PUSH
	RET	0


	DB	43H,'[',27H,']'	;[']
	DW	LINK-$
LINK	SET	$-6
	MOVQB	0,MODEL		;Not compiling
	BSR	TIC
	MOVQB	1,MODEL		;Compiling now
	MOVD	0(R7),R3	;Number to compile
	ADDQD	4,R7
	BR	NUML5		;Compile number in R3


	DB	42H,$'.('
	DW	LINK-$
LINK	SET	$-5
	ADDQD	-2,R7
	MOVB	')',0(R7)	;Delimiter character
	BSR	WORD
	ADDR	DPL,R2
	BSR	STYPE
	RET


ABQUOTE:
	RESTORE	[R2]
	ADDQD	4,R7
	CMPQW	0,-4(R7)
	BEQ	ABQ1:B
	BSR	STYPE
	BR	ABORT

ABQ1:
	MOVZBD	0(R2),R0
	ADDD	R0,R2
	JUMP	1(R2)


	DB	88H
	DB	1,'-'
	DW	LINK-$
LINK	SET	$-5
SUBTRACT:
	POP
	SUBD	R6,0(R7)
	RET	0

	COND	INCL
LINK432	EQU	LINK:#	;link to next module
	CELSE
LINK432	EQU	LINK-$:# ;link to next module
	CEND
