1 REM 32032 disassembler
2 REM Subroutines
4 REM 21000 returns V$ set to address/value/parameter
6 REM 22000 returns SZ$ set to B,W,D according to bits 0,1 of current byte
8 REM 23000 advances to next byte of input string.  If OF=0 then no more.
9 REM 23100 returns HX according to HX$ and OF
25 REM build up string for mode parameters.  Return as G$. Requires Gen1 as G1 and Gen2 as G2.  HX should point to 1st byte of extensions.
50 REM HX$ = current input string of hex digits, HX = value of current byte, OF = offset value from 1 to MO according to current offset within HX$
60 REM MH = max hex string array.
100 CLEAR 200 : MAXFILES = 2 : DEFINT A-Z : DIM RG$(15)
110 CLS : AD=0 : FOR X = 0 TO 15 : READ X$ : RG$(X) = X$ : NEXT
120 DATA "UPSR"," "," "," "," "," "," "," ","FP","SP","SB"," "," ","PSR","INTBASE","MOD"
150 REM O1$ = Hex opcodes
151 REM O2$ = Mnemonics
160 REM H-Hn, H$-Hn$ available for building output string
200 CLS : INPUT "<F>ile or <O>pcodes";X$ : IF X$="o" OR X$="O" THEN 500
210 IF X$<>"F" AND X$<>"f" THEN 200
300 INPUT "Filename for output";FO$ : IF FO$<>"" THEN OPEN FO$ FOR OUTPUT AS #2
310 INPUT "Filename for input";FI$ : OPEN FI$ FOR INPUT AS #1 : INPUT #1,HX$ : MH=5 : OH=1 : MO = 16 : OF = 1 : GOSUB 23100
320 R#=AD : GOSUB 21040 : IF FO$="" THEN PRINT V$;":" : O1$="" : O2$ = O1$ : GOSUB 1000 : PRINT LEFT$(O1$,LEN(O1$)-2),O2$ : GOTO 320
330 PRINT #2,V$;":" : O1$="" : O2$ = O1$ : GOSUB 1000 : PRINT #2,LEFT$(O1$,LEN(O1$)-2),O2$ : GOTO 320
500 INPUT "String to disassemble ";HX$ : MH=1 : OH=MH : MO = LEN(HX$)/2 : OF=1 : O1$="" : O2$="" : GOSUB 23100 : GOSUB 1000 : PRINT O1$, O2$ : PRINT : GOTO 500
1000 REM Check bits 0,1. If not 10 then integer opcode
1010 O1$ = H$ : IF (HX AND 3) = 2 THEN 5000 : REM non-integor opcode if 2
1020 REM This is an integer opcode. Check bits 2,3
1030 IF (HX AND (4+8)) <> (4+8) THEN GOTO 4000 : REM format 4 if not 12
1040 REM This is format 2 or 3. Check 4-6
1050 IF (HX AND (16+32+64)) = (16+32+64) THEN GOTO 3000 : REM format 3 if 112
2000 REM This is format 2
2010 ON (HX AND (16+32+64))/16+1 GOSUB 2100, 2200, 2300, 2400, 2500, 2600, 2700
2020 GOSUB 22000 : O2$ = O2$+SZ$+" " : H1 = HX : GOSUB 23000 : H = H1/128 + (HX AND 7)*2 : G1 = (HX AND (255-7))/8 : G2 = 32 : GOSUB 23000 : GOSUB 25000
2030 ON (H1 AND (16+32+64))/16+1 GOTO 2150, 2150, 2350, 2450, 2550, 2150, 2350
2100 O2$ = "ADDQ" : RETURN
2150 IF H < 8 THEN O2$ = O2$ + CHR$(48+H) + "," + GN$ ELSE O2$ = O2$ + STR$((H AND 7)-8) + "," + GN$
2160 RETURN
2200 O2$ = "CMPQ" : RETURN
2300 O2$ = "SPR" : RETURN
2350 O2$ = O2$ + RG$(H) + "," + GN$ : RETURN
2400 O2$ = "" : RETURN
2450 FL=H : GOSUB 24000 : O2$ = "S" + FL$ + SZ$ + " " + GN$ : RETURN
2500 O2$ = "ACB" : RETURN
2550 IF H < 8 THEN O2$ = O2$ + CHR$(48+H) + "," + GN$ ELSE O2$ = O2$ + STR$((H AND 7)-8) + "," + GN$
2560 GOSUB 21000 : O2$ = O2$ + "," + V$ : RETURN
2600 O2$ = "MOVQ" : RETURN
2700 O2$ = "LPR" : RETURN
3000 REM this is format 3
3010 GOSUB 22000 : H1 = HX : GOSUB 23000 : G1 = (HX AND (255-7))/8 : G2 = 32 : ON (HX AND 7) + 1 GOSUB 3100, 3200, 3300, 3400, 3500, 3600, 3700, 3800
3020 GOSUB 23000 : GOSUB 25000 : O2$ = O2$ + " " + GN$ : RETURN
3100 O2$ = "CXPD" : RETURN
3200 O2$ = "BICPSR" + SZ$ : RETURN
3300 O2$ = "JUMP" : RETURN
3400 O2$ = "BISPSR" + SZ$ : RETURN
3500 O2$ = "" : RETURN
3600 O2$ = "ADJSP" + SZ$ : RETURN
3700 O2$ = "JSR" : RETURN
3800 O2$ = "CASE" + SZ$ : RETURN
4000 REM This is format 4
4010 GOSUB 22000 : H1 = HX : GOSUB 23000 : G2 = (HX AND 7)*4 + (H1 AND (128+64))/64 : G1 = (HX AND (255-7))/8 : ON ((H1/4) AND 15) + 1 GOSUB 4100, 4150, 4200, 4250, 4300, 4350, 4400, 4450, 4500, 4550, 4600, 4650,4700,4750,4800
4020 GOSUB 23000 : GOSUB 25000 : O2$ = O2$ + " " + GN$ : RETURN
4100 O2$ = "ADD" + SZ$ : RETURN
4150 O2$ = "CMP" + SZ$ : RETURN
4200 O2$ = "BIC" + SZ$ : RETURN
4250 O2$ = "" : RETURN
4300 O2$ = "ADDC" + SZ$ : RETURN
4350 O2$ = "MOV" + SZ$ : RETURN
4400 O2$ = "OR" + SZ$ : RETURN
4450 O2$ = "" : RETURN
4500 O2$ = "SUB" + SZ$ : RETURN
4550 O2$ = "ADDR" : IF G1 <> 22 THEN RETURN ELSE O2$ = "LXPD" : RETURN
4600 O2$ = "AND" + SZ$ : RETURN
4650 O2$ = "" : RETURN
4700 O2$ = "SUBC" + SZ$ : RETURN
4750 O2$ = "TBIT" + SZ$ : RETURN
4800 O2$ = "XOR" + SZ$ : RETURN
5000 REM This is non-integer opcode
5010 REM Check bits 2-3, 00 = format 1
5020 IF (HX AND (4+8)) <> 0 THEN 6000
5030 REM This is format 1
5040 H1 = HX : GOSUB 23000 : ON H1/16+1 GOTO 5100,5150,5200,5250,5300,5350,5400,5450,5500,5550,5600,5650,5700,5750,5800,5850
5100 GOSUB 21000 : O2$ = "BSR *" : IF LEFT$(V$,1) <> "-" THEN O2$=O2$ + "+"
5110 O2$=O2$+V$ : RETURN
5150 GOSUB 21000 : O2$ = "RET "+V$ : RETURN
5200 GOSUB 21000 : O2$ = "CXP EXT(" + V$ + ")" : RETURN
5250 GOSUB 21000 : O2$ = "RXP " + V$ : RETURN
5300 GOSUB 21000 : O2$ = "RETT " + V$ : RETURN
5350 O2$ = "RETI" : RETURN
5400 O2$ = "SAVE [" : X=48 : Y=1 : FOR Z=1 TO 8 : IF HX AND Y THEN O2$=O2$ + "R" + CHR$(X) + ", "
5410 X=X+1 : Y=Y*2 : NEXT : O2$ = LEFT$(O2$,LEN(O2$)-2) + "]" : RETURN
5450 O2$ = "RESTORE [" : X=48+7 : Y=1 : FOR Z=1 TO 8 : IF HX AND Y THEN O2$=O2$ + "R" + CHR$(X) + ", "
5460 X=X-1 : Y=Y*2 : NEXT : O2$ = LEFT$(O2$,LEN(O2$)-2) + "]" : RETURN
5500 O2$ = "ENTER [" : X=48 : Y=1 : FOR Z=1 TO 8 : IF HX AND Y THEN O2$=O2$ + "R" + CHR$(X) + ", "
5510 X=X+1 : Y=Y*2 : NEXT : O2$ = LEFT$(O2$,LEN(O2$)-2) + "] " : GOSUB 23000 : GOSUB 21000 : O2$ = O2$+V$ : RETURN
5550 O2$ = "EXIT [" : X=48+7 : Y=1 : FOR Z=1 TO 8 : IF HX AND Y THEN O2$=O2$ + "R" + CHR$(X) + ", "
5560 X=X-1 : Y=Y*2 : NEXT : O2$ = LEFT$(O2$,LEN(O2$)-2) + "]" : RETURN
5600 O2$ = "NOP" : RETURN
5650 O2$ = "WAIT" : RETURN
5700 O2$ = "DIA" : RETURN
5750 O2$ = "FLAG" : RETURN
5800 O2$ = "SVC" : RETURN
5850 O2$ = "BPT" : RETURN
6000 REM This is format 0 or 5-8
6010 REM Check bits 2,3.  10 = format 0
6020 IF (HX AND 15) <> 10 THEN 7000
6030 REM This is format 0
6040 H1 = HX : GOSUB 23000 : GOSUB 21000 : IF INT(H1/16) = 14 THEN O2$ = "BR " ELSE FL=H1/16 : GOSUB 24000 : O2$ = "B" + FL$ + " "
6050 IF LEFT$(V$,1) = "-" THEN O2$ = O2$ + "*" + V$ : RETURN ELSE O2$ = O2$ + "*+" + V$ : RETURN
7000 REM This is formats 5-8
7010 IF HX <> 14 THEN 8000 : REM Format 5 if HX is 14
7020 GOSUB 23000 : ON (HX AND (4+8))/4+1 GOTO 7100, 7200, 7300, 7400
7100 O2$ = "MOVS" : GOTO 7500
7200 O2$ = "CMPS" : GOTO 7500
7300 O2$ = "SETCFG [" : H=HX/128 : GOSUB 23000 : H = H + 2*HX : X=1 : FOR Y = 1 TO 4 : IF (H AND X) THEN O2$ = O2$ + MID$("IFMC",Y,1) + ", "
7310 X=X*2 : NEXT : O2$ = LEFT$(O2$,LEN(O2$)-2) + "]" : RETURN
7400 O2$ = "SKPS" : GOTO 7500
7500 GOSUB 22000 : IF HX AND 128 THEN O2$ = O2$+"T" ELSE O2$ = O2$ + SZ$
7510 GOSUB 23000 : O2$ = O2$ + " " : IF (HX AND 1) THEN O2$ = O2$ + "B"
7520 IF (HX AND (2+4)) = 0 THEN RETURN
7530 IF (HX AND 1) THEN O2$ = O2$+", "
7540 O2$=O2$ + MID$("W U",HX/2,1) : RETURN
8000 REM These are formats 6-8
8010 IF HX <> (64+14) THEN 9000 : REM Not format 6 if not 80
8020 GOSUB 23000 : ON ((HX/4) AND 15) + 1 GOSUB 8100,8150,8200,8250,8300,8350,8400,8450,8500,8550,8600,8650,8700,8750,8800,8850
8030 GOSUB 22000 : H2=HX : GOSUB 23000 : G1 = HX/8 : G2 = 4*(HX AND 7) + H2/64 : GOSUB 23000 : GOSUB 25000 : O2$ = O2$ + SZ$ + " " + GN$ : RETURN
8100 O2$ = "ROT" : RETURN
8150 O2$ = "ASH" : RETURN
8200 O2$ = "CBIT" : RETURN
8250 O2$ = "CBITI" : RETURN
8300 O2$ = "" : RETURN
8350 O2$ = "LSH" : RETURN
8400 O2$ = "SBIT" : RETURN
8450 O2$ = "SBITI" : RETURN
8500 O2$ = "NEG" : RETURN
8550 O2$ = "NOT" : RETURN
8600 O2$ = "" : RETURN
8650 O2$ = "SUBP" : RETURN
8700 O2$ = "ABS" : RETURN
8750 O2$ = "COM" : RETURN
8800 O2$ = "IBIT" : RETURN
8850 O2$ = "ADDP" : RETURN
9000 REM These are formats 8-9
9010 IF HX <> (128+64+14) THEN 10000 : REM Not format 8 if not equal
9020 GOSUB 23000 : GOSUB 22000 : H2=HX : GOSUB 23000 : G1 = HX/8 : G2 = (HX AND 7)*4 + H2/64 : GOSUB 23000 : GOSUB 25000 : ON ((H2/4) AND 15) + 1 GOTO 9100,9150,9200,9250,9300,9350,9400,9450,9500,9550,9600,9650,9700,9750,9800,9850
9100 O2$ = "MOVM"
9110 O2$ = O2$ + SZ$ + " " + GN$ + "," : X = HX/SZ + 1 : IF X > 9 THEN O2$ = O2$ + CHR$(55+X) : RETURN ELSE O2$ = O2$ + CHR$(48+X) : RETURN
9150 O2$ = "CMPM" : GOTO 9110
9200 O2$ = "INSS"
9210 O2$ = O2$ + SZ$ + " " + GN$ + "," + CHR$(HX/32+48) : R# = (HX AND 31)+1 : GOSUB 21040 : O2$ = O2$ + "," + V$ : RETURN
9250 O2$ = "EXTS" : GOTO 9210
9300 O2$ = "MOVXBW" + " " + GN$ : RETURN
9350 O2$ = "MOVZBW" + " " + GN$ : RETURN
9400 O2$ = "MOVZ" + SZ$ + "D " + GN$ : RETURN
9450 O2$ = "MOVX" + SZ$ + "D " + GN$ : RETURN
9500 O2$ = "MUL" + SZ$ + " " + GN$ : RETURN
9550 O2$ = "MEI" + SZ$ + " " + GN$ : RETURN
9600 O2$ = "" : RETURN
9650 O2$ = "DEI" + SZ$ + " " + GN$ : RETURN
9700 O2$ = "QUO" + SZ$ + " " + GN$ : RETURN
9750 O2$ = "REM" + SZ$ + " " + GN$ : RETURN
9800 O2$ = "MOD" + SZ$ + " " + GN$ : RETURN
9850 O2$ = "DIV" + SZ$ + " " + GN$ : RETURN
21000 REM Return V$ set to offset
21010 IF (HX AND 128) = 0 THEN S = 1 ELSE S = 2 * (((HX AND 64)/64) + 1)
21020 GOSUB 21800
21030 ON S GOSUB 21100,21200,21300,21400
21040 X=1 : X#=ABS(R#) : IF R#<0 THEN V$="-" ELSE V$=""
21050 IF X#>15 THEN X#=X#/16 : X=X+1 : GOTO 21050
21060 Z#=16^(X-1) : X#=ABS(R#) : FOR Y=1 TO X : Z=X#/Z# : V$=V$+MID$("0123456789ABCDEF",Z+1,1) : X#=X#-Z*Z# : Z#=Z#/16 : NEXT : RETURN
21100 IF R# < 64 THEN RETURN ELSE R# = R# - 128 : RETURN
21200 R# = R# - 32768! : IF R# < 8192 THEN RETURN ELSE R#=R# - 16384 : RETURN
21300 RETURN
21400 X# = 65536# * 65536# / 8# : R# = R# -X#*2 -X#*4 : IF R# < X# THEN RETURN ELSE R# = R# - 2*X# : RETURN
21800 R#=0 : FOR T = 1 TO S : VH$ = MID$(HX$,2*(OF-1)+1,1) : GOSUB 30000 : R#=R# * 16 + VH : VH$ = MID$(HX$,2*(OF-1)+2,1) : GOSUB 30000 : R#=R# * 16 + VH : GOSUB 23000 : NEXT : RETURN
22000 REM SET SZ$ TO B,W,D according to bit 0,1 of HX. SZ set to number of bytes
22010 SZ = 1+(HX AND 3) : SZ$ = MID$("BW D",SZ,1) : RETURN
23000 REM advance to next byte. OF = current offset.  OF=0 => no more.
23010 IF OF = 0 THEN RETURN
23020 AD=AD+1 : OF=OF+1 : IF OF<=MO THEN 23100
23030 OF=0 : OH=OH+1 : IF OH>MH THEN RETURN
23040 INPUT #1,HX$ : OF = 1 : GOTO 23100
23100 X$ = MID$(HX$,2*(OF-1)+1,1) : Y$ = MID$(HX$,2*(OF-1)+2,1) : HX = 16 * (INSTR("0123456789ABCDEF",X$)-1) + INSTR("0123456789ABCDEF",Y$) - 1 : H$=X$+Y$ : O1$ = O1$ + H$ : RETURN
24000 REM Return FL$ set to condition code according to FL (0-13)
24010 FL$ = MID$("EQNECSCCHILSGTLEFSFCLOHSLTGE",FL*2+1,2) : RETURN
25000 REM build up string for mode parameters.  Return as GN$. Requires Gen1 as G1 and Gen2 as G2.  HX should point to 1st byte of extensions.
25010 IF (G1 AND (16+8+4)) <> (16+8+4) AND (G2 AND (16+8+4)) <> (16+8+4) THEN GOTO 25100 : REM No indexing if both less
25020 H8$ = "" : IF (G1 AND (16+8+4)) = (16+8+4) THEN H8$="[R" + CHR$(48+(HX AND 7)) + ":" + MID$("BWDQ",((G1 AND 3)+1),1) + "]" : G1 = HX/8 : GOSUB 23000
25030 H9$ = "" : IF (G2 AND (16+8+4)) = (16+8+4) THEN H9$="[R" + CHR$(48+(HX AND 7)) + ":" + MID$("BWDQ",((G2 AND 3)+1),1) + "]" : G2 = HX/8 : GOSUB 23000
25035 G=G1 : H6$="" : IF G1<32 THEN GOSUB 26000 : H6$=GN$
25040 G=G2 : H7$="" : IF G2<32 THEN GOSUB 26000 : H7$=GN$ 
25050 GN$=H6$+H8$ : IF H7$<>"" THEN GN$ = GN$ + "," +H7$ +H9$ : RETURN ELSE RETURN
25100 G=G1 : H8$="" : GN$ = "" : IF G1 < 32 THEN GOSUB 26000 : H8$=GN$
25110 G=G2 : H9$="" : GN$ = "" : IF G2 < 32 THEN GOSUB 26000 : H9$=GN$
25120 GN$=H8$ : IF H8$<>"" AND H9$ <> "" THEN GN$ = GN$ + ","
25130 GN$ = GN$ + H9$ : RETURN
26000 REM G=gen, HX points to extensions : return mode as GN$
26010 IF G<8 THEN GN$ = "R" + CHR$(48+(G AND 7)) : RETURN
26020 IF G<16 THEN GOSUB 21000 : GN$ = V$ + "(R" + CHR$(48 + (G AND 7)) + ")" : RETURN
26030 IF G < (16+4) THEN GOSUB 21000 : H1$ = V$ : GOSUB 21000 : GN$ = V$ + "(" + H1$ + "(" + MID$("FPSPSB",(G AND 3)*2+1,2) + "))" : RETURN
26040 IF G=(16+4) THEN S=SZ : GOSUB 31000 : GN$ = V$ : RETURN
26050 IF G=(16+4+1) THEN GOSUB 21000 : GN$ = "@" + V$ : RETURN
26060 IF G=(16+4+2) THEN GOSUB 21000 : H1$ = V$ : GOSUB 21000 : GN$ = "EXT(" + H1$ + ")+" + V$ : RETURN
26070 IF G = (16+4+2+1) THEN GN$ = "TOS" : RETURN
26080 IF G = (16+8+2+1) THEN GOSUB 21000 : GN$ = "*+" + V$ : RETURN
26090 GOSUB 21000 : GN$ = V$ + "(" + MID$("FPSPSB",(G AND 3)*2+1,2) + ")" : RETURN
30000 REM Convert VH$ (hex character) to actual value (0-15).  Return as VH
30010 VH = INSTR("0123456789ABCDEF",VH$)-1 : RETURN
31000 REM Return V$ set to B/W/D immediate value. S must hold number of bytes
31020 GOSUB 21800
31030 ON S GOSUB 31100,31200,31300,31400 : GOTO 21040
31100 IF R# < 128 THEN RETURN ELSE R# = R# - 256 : RETURN
31200 IF R# < 32768! THEN RETURN ELSE R# = R# - 65536! : RETURN
31300 RETURN
31400 X# = 65536# * 65536# : IF R# < X#/2 THEN RETURN ELSE R# = R# - X# : RETURN
