;Convert MAINDEM.OUT character data to source code statements
;Binary file written by SDB:
;  Starting address (4 bytes, LSB first)
;  Ending address (4 bytes, LSB first)
;  Actual binary data

BASE	EQU	H'FFC5A540	;Base address of data in 34010 memory
EXEC	EQU	1		;Exec designed character set

;R0 = absolute address of start of binary file in memory
;R3 => Offset array pointer in binary file (in bits)
;R4 => Character bit map in binary file (in bits)
;R5 = Source pitch (in bits)
;R6 = Dy (in bits)
;R7 => target address for source code

;If EXEC then R0 => start of binary file

BEGIN:	COND	EXEC
	 MOVZBD 10,R6		;Y height is always 10
	 MOVD	8,R5		;Y pitch is always 8 bits
	 MOVQD	0,R4		;Character bits at start of file
	CELSE
	 SUBD	BASE,R3		;Convert to offset from R0
	 DIVD	8,R3		;Convert offset to bytes
	 ADDD	R0,R3		;Point to absolute address now
	 SUBD	BASE,R4		;Bit pointer converted to offset from R0
	CEND

	MOVQD	0,R2		;Character label
	MOVD	R7,TOS		;Starting address
	UNTIL	EQ
	 COND	EXEC
	  MOVZBD 8,R1		;Always 8 bits wide
	 CELSE
	  MOVZWD 2(R3),R1
	  SUBW	(R3),R1		;X width of current character
	 CEND
	 CMPQW	0,R1
	 IF	NE
	  BSR	LABEL		;Generate label
	  BSR	DO_BITS		;Create actual bit pattern
	 ENDIF
	 COND	EXEC
	  ADDD	8*16,R4		;Advance to next character
	 CEND
	 ADDQD	2,R3		;Next offset pointer
	 ADDQB	1,R2
	 CMPB	H'80,R2		;Do all characters
	ENDU

;Now build offset table

	COND	EXEC
	 MOVQD	0,R2
	CELSE
	 MOVD	H'20,R2		;First character to do
	CEND
	UNTIL	EQ
	 MOVB	9,(R7)
	 MOVB	".",1(R7)
	 MOVD	"WORD",2(R7)
	 MOVB	9,6(R7)
	 ADDQD	7,R7
	 BSR	NAME_R2
	 MOVB	"-",(R7)
	 ADDQD	1,R7
	 MOVD	"_00",(R7)
	 ADDQD	3,R7
	 MOVB	H'0D,(R7)
	 ADDQD	1,R7
	 ADDQD	1,R2
	 CMPB	H'80,R2		;Just do 20-7F here
	ENDU

;Transmit file now

	MOVD	TOS,R1		;Starting address
	MOVD	R7,R0		;Ending address
	SUBD	R1,R0		;Number of bytes to R0
	UNTIL	EQ
	 MOVZBD	(R1),R5
	 MOVD	H'20609,R6	;SM char output routine
	 CXP	0
	 ADDQD	1,R1
	 ADDQD	-1,R0
	 CMPQD	0,R0
	ENDU

FINISH:
	NOP			;Stop here
	NOP

;Build actual character bit pattern
;R1 holds width

DO_BITS:
	SAVE	[R2,R4,R6]
	UNTIL	EQ
	 BSR	BIT_SUB
	 COND	EXEC
	  BSR	BIT_SUB		;Double everything for EXEC
	 CEND
	 ADDD	R5,R4		;Next line of character
	 ADDQD	-1,R6
	 CMPQD	0,R6
	ENDU
	RESTORE	[R2,R4,R6]
	RET


;Actual bit subroutine

BIT_SUB:
	MOVB	9,(R7)		;Start with a tab
	MOVD	".FIE",1(R7)
	MOVW	"LD",5(R7)
	MOVB	9,7(R7)		;Another tab
	ADDD	8,R7
	COND	EXEC
	 MOVQD	0,R2		;Bit order reversed here
	CELSE
	 MOVZWD 2(R3),R2
	 ADDQD	-1,R2		;Last bit of current character
	CEND
	ADDD	R4,R2		;Add base offset
	SAVE	[R1]		;Width of character
	UNTIL	EQ
	 EXTB	R2,(R0),(R7),1	;Current bit
	 ADDB	"0",(R7)
	 COND	EXEC
	  ADDQD	1,R2		;Advance if Exec
	 CELSE
	  ADDQD	-1,R2		;Next bit
	 CEND
	 ADDQD	1,R7
	 ADDQD	-1,R1
	 CMPQD	0,R1
	ENDU
	RESTORE [R1]		;Width of bit field
	MOVD	"B, ",(R7)
	ADDQD	3,R7
	SAVE	[R0,R1]
	MOVD	R1,R0
	MOVQD	0,R1		;Width to R0,R1
	DEID	10,R0		;Quotient to R1, remainder to R0
	CMPQB	0,R1		;MS digit
	IF	NE
	 ADDB	"0",R1
	 MOVB	R1,(R7)
	 ADDQD	1,R7
	ENDIF
	ADDB	"0",R0		;LS digit
	MOVB	R0,(R7)
	ADDQD	1,R7
	RESTORE [R0,R1]
	MOVB	H'0D,(R7)
	ADDQD	1,R7
	RET	

;R2 holds character number
;R7 holds target address

LABEL:	BSR	NAME_R2
	MOVB	":",(R7)
	MOVB	H'0D,1(R7)	;CR/LF
	ADDQD	2,R7
	RET

;R2=name, put into ASCII file

NAME_R2:
	MOVB	"_",(R7)
	EXTSB	R2,1(R7),4,4	;MSB of name
	ADDB	"0",1(R7)
	CMPB	"9",1(R7)
	IF	LO
	 ADDQD	7,1(R7)		;Make A-F
	ENDIF
	EXTSB	R2,2(R7),0,4	;LSB of name
	ADDB	"0",2(R7)
	CMPB	"9",2(R7)
	IF	LO
	 ADDQD	7,2(R7)		;Make A-F
	ENDIF
	ADDQD	3,R7
	RET
